import { MessagingMenu } from "@mail/core/public_web/messaging_menu";

import { _t } from "@web/core/l10n/translation";
import { patch } from "@web/core/utils/patch";

/** @type {MessagingMenu} */
const messagingMenuPatch = {
    /**
     * @override
     */
    get _tabs() {
        const items = super._tabs;
        if (this.store.show_livechat_category) {
            items.push({
                counter: this.store.discuss.livechats.reduce(
                    (acc, channel) =>
                        channel.self_member_id?.message_unread_counter > 0 ? acc + 1 : acc,
                    0
                ),
                id: "livechat",
                icon: "fa fa-commenting-o",
                activeIcon: "fa fa-commenting",
                label: _t("Live Chats"),
                sequence: 60,
            });
        }
        return items;
    },
};
patch(MessagingMenu.prototype, messagingMenuPatch);
