import { useState } from "@web/owl2/utils";
import { _t } from "@web/core/l10n/translation";
import { useService } from "@web/core/utils/hooks";
import { Component } from "@odoo/owl";

export class ProgressBar extends Component {
    static template = "html_editor.ProgressBar";
    static props = {
        progress: { type: Number, optional: true },
        hasError: { type: Boolean, optional: true },
        uploaded: { type: Boolean, optional: true },
        name: String,
        size: { type: String, optional: true },
        errorMessage: { type: String, optional: true },
        mimetype: { type: String, optional: true },
        cancelUpload: { type: Function, optional: true },
    };
    static defaultProps = {
        progress: 0,
        hasError: false,
        uploaded: false,
        size: "",
        errorMessage: "",
        mimetype: "",
        cancelUpload: () => {},
    };

    get errorMessage() {
        return this.props.errorMessage || _t("File could not be saved");
    }

    get progress() {
        return Math.round(this.props.progress);
    }
}

export class UploadProgressToast extends Component {
    static template = "html_editor.UploadProgressToast";
    static components = {
        ProgressBar,
    };
    static props = {
        close: Function,
    };

    setup() {
        this.uploadService = useService("upload");
        this.state = useState(this.uploadService.progressToast);
    }
}
