from odoo.tests import HttpCase, tagged, users
from odoo.addons.hr.tests.test_utils import get_admin_employee

@tagged('post_install', '-at_install')
class TestTimeOffCardTour(HttpCase):

    @users('admin')
    def test_time_off_card_tour(self):
        work_entry_type = self.env['hr.work.entry.type'].create({
            'name': 'Time Off with no validation for approval',
            'code': 'Time Off with no validation for approval',
            'count_as': 'absence',
            'requires_allocation': True,
            'allocation_validation_type': 'no_validation',
            'request_unit': 'day',
            'unit_of_measure': 'day',
        })
        admin_employee = get_admin_employee(self.env)
        self.env['hr.leave.allocation'].create({
            'employee_id': admin_employee.id,
            'work_entry_type_id': work_entry_type.id,
            'allocation_type': 'regular',
            'type_request_unit': 'half_day',
        })
        self.start_tour('/', 'time_off_card_tour', login='admin')
