import time

from odoo.tests.common import tagged, TransactionCase


@tagged('attendance_searchbar_user_domain')
@tagged('at_install', '-post_install')  # LEGACY at_install
class TestHrAttendanceDomainTranslation(TransactionCase):

    @classmethod
    def setUpClass(cls):
        super().setUpClass()

        cls.hr_attendance = cls.env['hr.attendance']
        cls.hr_employee = cls.env['hr.employee']
        cls.employee_musa, employee_tecna = cls.hr_employee.create([{'name': 'Musa'}, {'name': 'Tecna'}])
        cls.hr_attendance.create({
            'employee_id': employee_tecna.id,
            'check_in': time.strftime('%Y-%m-10 10:00'),
        })

    def test_searchbar_with_user_domain(self):
        # Checks that this domain returns no attendance
        self.assertEqual(
            self.hr_attendance.search([
                '&',
                    ('check_out', "!=", False),
                    '|',
                        ('employee_id', 'ilike', 'Musa'),
                        ('employee_id', 'ilike', 'Flora')
            ]),
            self.hr_attendance
        )
