import { patch } from "@web/core/utils/patch";
import { ProductTemplate } from "@point_of_sale/../tests/unit/data/product_template.data";

patch(ProductTemplate.prototype, {
    _load_pos_data_fields() {
        return [...super._load_pos_data_fields(), "self_order_available"];
    },
});

ProductTemplate._records = [
    ...ProductTemplate._records,
    {
        id: 101,
        display_name: "T-Shirt",
        standard_price: 0,
        categ_id: false,
        pos_categ_ids: [],
        taxes_id: [],
        barcode: false,
        name: "T-Shirt",
        list_price: 10,
        is_favorite: false,
        default_code: false,
        to_weight: false,
        uom_id: 1,
        description_sale: false,
        description: false,
        tracking: "none",
        type: "consu",
        service_tracking: "no",
        is_storable: false,
        write_date: "2025-07-03 13:04:14",
        color: 0,
        pos_sequence: 5,
        available_in_pos: true,
        attribute_line_ids: [101],
        active: true,
        image_128: false,
        product_variant_ids: [101, 102],
        public_description: false,
        pos_optional_product_ids: [],
        sequence: 1,
        product_tag_ids: [],
    },
    {
        id: 102,
        display_name: "Smart Watch",
        standard_price: 0,
        categ_id: false,
        pos_categ_ids: [],
        taxes_id: [],
        barcode: false,
        name: "Smart Watch",
        list_price: 200,
        is_favorite: false,
        default_code: false,
        to_weight: false,
        uom_id: 1,
        description_sale: false,
        description: false,
        tracking: "none",
        type: "consu",
        service_tracking: "no",
        is_storable: false,
        write_date: "2025-07-03 13:04:14",
        color: 0,
        pos_sequence: 5,
        available_in_pos: true,
        attribute_line_ids: [102],
        active: true,
        image_128: false,
        product_variant_ids: [103],
        public_description: false,
        pos_optional_product_ids: [],
        sequence: 1,
        product_tag_ids: [],
    },
    {
        id: 103,
        display_name: "Running Sweater",
        standard_price: 0,
        categ_id: false,
        pos_categ_ids: [],
        taxes_id: [],
        barcode: false,
        name: "Running Sweater",
        list_price: 100,
        is_favorite: false,
        default_code: false,
        to_weight: false,
        uom_id: 1,
        description_sale: false,
        description: false,
        tracking: "none",
        type: "consu",
        service_tracking: "no",
        is_storable: false,
        write_date: "2025-07-03 13:04:14",
        color: 0,
        pos_sequence: 5,
        available_in_pos: true,
        attribute_line_ids: [101, 102],
        active: true,
        image_128: false,
        product_variant_ids: [104, 105],
        public_description: false,
        pos_optional_product_ids: [],
        sequence: 1,
        product_tag_ids: [],
    },
].map((record) => ({
    ...record,
    self_order_available: true,
}));
