import {
    clickOnSnippet,
    insertSnippet,
    registerWebsitePreviewTour,
} from "@website/js/tours/tour_utils";

const snippets = [
    { id: "s_popup", name: "Popup", groupName: "Content" },
    { id: "s_banner", name: "Banner", groupName: "Into" },
    { customID: "s_popup", name: "Custom Popup", groupName: "Custom" },
];

registerWebsitePreviewTour(
    "custom_popup_snippet",
    {
        url: "/",
        edition: true,
    },
    () => [
        ...insertSnippet(snippets[0]),
        ...clickOnSnippet(snippets[1]),
        {
            content: "save this snippet to save later",
            trigger: ".options-container[data-container-title='Popup'] .oe_snippet_save",
            run: "click",
        },
        {
            content: "Hide the popup",
            trigger: ".o_we_invisible_entry i",
            run: "click",
        },
        ...insertSnippet(snippets[2]),
        {
            content: "check whether new custom popup is visible or not.",
            trigger: ":iframe section[data-snippet='s_banner']",
        },
    ]
);
