
/**
 * This file is generated by o-spreadsheet build tools. Do not edit it.
 * @see https://github.com/odoo/o-spreadsheet
 * @version 18.0.19
 * @date 2025-03-12T15:45:47.820Z
 * @hash d8dea1b8e
 */

import { useEnv, useSubEnv, onWillUnmount, useComponent, status, Component, useRef, onMounted, useEffect, useState, onPatched, onWillPatch, onWillUpdateProps, useExternalListener, onWillStart, xml, useChildSubEnv, markRaw, toRaw } from '@odoo/owl';

function createActions(menuItems) {
    return menuItems.map(createAction).sort((a, b) => a.sequence - b.sequence);
}
let nextItemId = 1;
function createAction(item) {
    const name = item.name;
    const children = item.children;
    const description = item.description;
    const icon = item.icon;
    const secondaryIcon = item.secondaryIcon;
    const itemId = item.id || nextItemId++;
    return {
        id: itemId.toString(),
        name: typeof name === "function" ? name : () => name,
        isVisible: item.isVisible ? item.isVisible : () => true,
        isEnabled: item.isEnabled ? item.isEnabled : () => true,
        isActive: item.isActive,
        execute: item.execute,
        children: children
            ? (env) => {
                return children
                    .map((child) => (typeof child === "function" ? child(env) : child))
                    .flat()
                    .map(createAction);
            }
            : () => [],
        isReadonlyAllowed: item.isReadonlyAllowed || false,
        separator: item.separator || false,
        icon: typeof icon === "function" ? icon : () => icon || "",
        iconColor: item.iconColor,
        secondaryIcon: typeof secondaryIcon === "function" ? secondaryIcon : () => secondaryIcon || "",
        description: typeof description === "function" ? description : () => description || "",
        textColor: item.textColor,
        sequence: item.sequence || 0,
        onStartHover: item.onStartHover,
        onStopHover: item.onStopHover,
    };
}

/**
 * Registry
 *
 * The Registry class is basically just a mapping from a string key to an object.
 * It is really not much more than an object. It is however useful for the
 * following reasons:
 *
 * 1. it let us react and execute code when someone add something to the registry
 *   (for example, the FunctionRegistry subclass this for this purpose)
 * 2. it throws an error when the get operation fails
 * 3. it provides a chained API to add items to the registry.
 */
class Registry {
    content = {};
    /**
     * Add an item to the registry
     *
     * Note that this also returns the registry, so another add method call can
     * be chained
     */
    add(key, value) {
        this.content[key] = value;
        return this;
    }
    /**
     * Get an item from the registry
     */
    get(key) {
        /**
         * Note: key in {} is ~12 times slower than {}[key].
         * So, we check the absence of key only when the direct access returns
         * a falsy value. It's done to ensure that the registry can contains falsy values
         */
        const content = this.content[key];
        if (!content) {
            if (!(key in this.content)) {
                throw new Error(`Cannot find ${key} in this registry!`);
            }
        }
        return content;
    }
    /**
     * Check if the key is already in the registry
     */
    contains(key) {
        return key in this.content;
    }
    /**
     * Get a list of all elements in the registry
     */
    getAll() {
        return Object.values(this.content);
    }
    /**
     * Get a list of all keys in the registry
     */
    getKeys() {
        return Object.keys(this.content);
    }
    /**
     * Remove an item from the registry
     */
    remove(key) {
        delete this.content[key];
    }
}

const CANVAS_SHIFT = 0.5;
// Colors
const HIGHLIGHT_COLOR = "#37A850";
const BACKGROUND_GRAY_COLOR = "#f5f5f5";
const BACKGROUND_HEADER_COLOR = "#F8F9FA";
const BACKGROUND_HEADER_SELECTED_COLOR = "#E8EAED";
const BACKGROUND_HEADER_ACTIVE_COLOR = "#595959";
const TEXT_HEADER_COLOR = "#666666";
const FIGURE_BORDER_COLOR = "#c9ccd2";
const SELECTION_BORDER_COLOR = "#3266ca";
const HEADER_BORDER_COLOR = "#C0C0C0";
const CELL_BORDER_COLOR = "#E2E3E3";
const BACKGROUND_CHART_COLOR = "#FFFFFF";
const DISABLED_TEXT_COLOR = "#CACACA";
const DEFAULT_COLOR_SCALE_MIDPOINT_COLOR = 0xb6d7a8;
const LINK_COLOR = "#017E84";
const FILTERS_COLOR = "#188038";
const SEPARATOR_COLOR = "#E0E2E4";
const ICONS_COLOR = "#4A4F59";
const HEADER_GROUPING_BACKGROUND_COLOR = "#F5F5F5";
const HEADER_GROUPING_BORDER_COLOR = "#999";
const GRID_BORDER_COLOR = "#E2E3E3";
const FROZEN_PANE_HEADER_BORDER_COLOR = "#BCBCBC";
const FROZEN_PANE_BORDER_COLOR = "#DADFE8";
const COMPOSER_ASSISTANT_COLOR = "#9B359B";
const CHART_WATERFALL_POSITIVE_COLOR = "#4EA7F2";
const CHART_WATERFALL_NEGATIVE_COLOR = "#EA6175";
const CHART_WATERFALL_SUBTOTAL_COLOR = "#AAAAAA";
const GRAY_900 = "#111827";
const GRAY_300 = "#D8DADD";
const GRAY_200 = "#E7E9ED";
const GRAY_100 = "#F9FAFB";
const TEXT_BODY = "#374151";
const TEXT_BODY_MUTED = TEXT_BODY + "C2";
const TEXT_HEADING = "#111827";
const PRIMARY_BUTTON_BG = "#714B67";
const PRIMARY_BUTTON_HOVER_BG = "#624159";
const PRIMARY_BUTTON_ACTIVE_BG = "#f1edf0";
const BUTTON_BG = GRAY_200;
const BUTTON_HOVER_BG = GRAY_300;
const BUTTON_HOVER_TEXT_COLOR = "#111827";
const BUTTON_ACTIVE_BG = "#e6f2f3";
const BUTTON_ACTIVE_TEXT_COLOR = "#111827";
const ACTION_COLOR = "#017E84";
const ACTION_COLOR_HOVER = "#01585c";
const ALERT_WARNING_BG = "#FBEBCC";
const ALERT_WARNING_BORDER = "#F8E2B3";
const ALERT_WARNING_TEXT_COLOR = "#946D23";
const ALERT_DANGER_BG = "#D44C591A";
const ALERT_DANGER_BORDER = "#C34A41";
const ALERT_DANGER_TEXT_COLOR = "#C34A41";
const ALERT_INFO_BG = "#CDEDF1";
const ALERT_INFO_BORDER = "#98DBE2";
const ALERT_INFO_TEXT_COLOR = "#09414A";
const BADGE_SELECTED_COLOR = "#E6F2F3";
const DEFAULT_CHART_PADDING = 20;
const DEFAULT_CHART_FONT_SIZE = 22;
const SCORECARD_GAUGE_CHART_PADDING = 10;
const SCORECARD_GAUGE_CHART_FONT_SIZE = 14;
// Color picker defaults as upper case HEX to match `toHex`helper
const COLOR_PICKER_DEFAULTS = [
    "#000000",
    "#434343",
    "#666666",
    "#999999",
    "#B7B7B7",
    "#CCCCCC",
    "#D9D9D9",
    "#EFEFEF",
    "#F3F3F3",
    "#FFFFFF",
    "#980000",
    "#FF0000",
    "#FF9900",
    "#FFFF00",
    "#00FF00",
    "#00FFFF",
    "#4A86E8",
    "#0000FF",
    "#9900FF",
    "#FF00FF",
    "#E6B8AF",
    "#F4CCCC",
    "#FCE5CD",
    "#FFF2CC",
    "#D9EAD3",
    "#D0E0E3",
    "#C9DAF8",
    "#CFE2F3",
    "#D9D2E9",
    "#EAD1DC",
    "#DD7E6B",
    "#EA9999",
    "#F9CB9C",
    "#FFE599",
    "#B6D7A8",
    "#A2C4C9",
    "#A4C2F4",
    "#9FC5E8",
    "#B4A7D6",
    "#D5A6BD",
    "#CC4125",
    "#E06666",
    "#F6B26B",
    "#FFD966",
    "#93C47D",
    "#76A5AF",
    "#6D9EEB",
    "#6FA8DC",
    "#8E7CC3",
    "#C27BA0",
    "#A61C00",
    "#CC0000",
    "#E69138",
    "#F1C232",
    "#6AA84F",
    "#45818E",
    "#3C78D8",
    "#3D85C6",
    "#674EA7",
    "#A64D79",
    "#85200C",
    "#990000",
    "#B45F06",
    "#BF9000",
    "#38761D",
    "#134F5C",
    "#1155CC",
    "#0B5394",
    "#351C75",
    "#741B47",
    "#5B0F00",
    "#660000",
    "#783F04",
    "#7F6000",
    "#274E13",
    "#0C343D",
    "#1C4587",
    "#073763",
    "#20124D",
    "#4C1130",
];
// Dimensions
const MIN_ROW_HEIGHT = 10;
const MIN_COL_WIDTH = 5;
const HEADER_HEIGHT = 26;
const HEADER_WIDTH = 48;
const TOPBAR_HEIGHT = 63;
const TOPBAR_TOOLBAR_HEIGHT = 34;
const BOTTOMBAR_HEIGHT = 36;
const DEFAULT_CELL_WIDTH = 96;
const DEFAULT_CELL_HEIGHT = 23;
const SCROLLBAR_WIDTH = 15;
const AUTOFILL_EDGE_LENGTH = 8;
const ICON_EDGE_LENGTH = 18;
const MIN_CF_ICON_MARGIN = 4;
const MIN_CELL_TEXT_MARGIN = 4;
const CF_ICON_EDGE_LENGTH = 15;
const PADDING_AUTORESIZE_VERTICAL = 3;
const PADDING_AUTORESIZE_HORIZONTAL = MIN_CELL_TEXT_MARGIN;
const GROUP_LAYER_WIDTH = 21;
const GRID_ICON_MARGIN = 2;
const GRID_ICON_EDGE_LENGTH = 17;
const FOOTER_HEIGHT = 2 * DEFAULT_CELL_HEIGHT;
// Menus
const MENU_WIDTH = 250;
const MENU_VERTICAL_PADDING = 6;
const MENU_ITEM_HEIGHT = 26;
const MENU_ITEM_PADDING_HORIZONTAL = 11;
const MENU_ITEM_PADDING_VERTICAL = 4;
const MENU_SEPARATOR_BORDER_WIDTH = 1;
const MENU_SEPARATOR_PADDING = 5;
// Style
const DEFAULT_STYLE = {
    align: "left",
    verticalAlign: "bottom",
    wrapping: "overflow",
    bold: false,
    italic: false,
    strikethrough: false,
    underline: false,
    fontSize: 10,
    fillColor: "",
    textColor: "",
};
const DEFAULT_VERTICAL_ALIGN = DEFAULT_STYLE.verticalAlign;
const DEFAULT_WRAPPING_MODE = DEFAULT_STYLE.wrapping;
// Fonts
const DEFAULT_FONT_WEIGHT = "400";
const DEFAULT_FONT_SIZE = DEFAULT_STYLE.fontSize;
const HEADER_FONT_SIZE = 11;
const DEFAULT_FONT = "'Roboto', arial";
// Borders
const DEFAULT_BORDER_DESC = { style: "thin", color: "#000000" };
// Max Number of history steps kept in memory
const MAX_HISTORY_STEPS = 99;
// Id of the first revision
const DEFAULT_REVISION_ID = "START_REVISION";
// Figure
const DEFAULT_FIGURE_HEIGHT = 335;
const DEFAULT_FIGURE_WIDTH = 536;
const FIGURE_BORDER_WIDTH = 1;
const MIN_FIG_SIZE = 80;
// Chart
const MAX_CHAR_LABEL = 20;
const FIGURE_ID_SPLITTER = "??";
const DEFAULT_GAUGE_LOWER_COLOR = "#EA6175";
const DEFAULT_GAUGE_MIDDLE_COLOR = "#FFD86D";
const DEFAULT_GAUGE_UPPER_COLOR = "#43C5B1";
const DEFAULT_SCORECARD_BASELINE_MODE = "difference";
const DEFAULT_SCORECARD_BASELINE_COLOR_UP = "#43C5B1";
const DEFAULT_SCORECARD_BASELINE_COLOR_DOWN = "#EA6175";
const LINE_FILL_TRANSPARENCY = 0.4;
// session
const DEBOUNCE_TIME = 200;
const MESSAGE_VERSION = 1;
// Sheets
const FORBIDDEN_SHEETNAME_CHARS = ["'", "*", "?", "/", "\\", "[", "]"];
const FORBIDDEN_SHEETNAME_CHARS_IN_EXCEL_REGEX = /'|\*|\?|\/|\\|\[|\]/;
// Cells
const FORMULA_REF_IDENTIFIER = "|";
// Components
var ComponentsImportance;
(function (ComponentsImportance) {
    ComponentsImportance[ComponentsImportance["Grid"] = 0] = "Grid";
    ComponentsImportance[ComponentsImportance["Highlight"] = 5] = "Highlight";
    ComponentsImportance[ComponentsImportance["HeaderGroupingButton"] = 6] = "HeaderGroupingButton";
    ComponentsImportance[ComponentsImportance["Figure"] = 10] = "Figure";
    ComponentsImportance[ComponentsImportance["ScrollBar"] = 15] = "ScrollBar";
    ComponentsImportance[ComponentsImportance["GridPopover"] = 19] = "GridPopover";
    ComponentsImportance[ComponentsImportance["GridComposer"] = 20] = "GridComposer";
    ComponentsImportance[ComponentsImportance["Dropdown"] = 21] = "Dropdown";
    ComponentsImportance[ComponentsImportance["IconPicker"] = 25] = "IconPicker";
    ComponentsImportance[ComponentsImportance["TopBarComposer"] = 30] = "TopBarComposer";
    ComponentsImportance[ComponentsImportance["Popover"] = 35] = "Popover";
    ComponentsImportance[ComponentsImportance["FigureAnchor"] = 1000] = "FigureAnchor";
    ComponentsImportance[ComponentsImportance["FigureSnapLine"] = 1001] = "FigureSnapLine";
})(ComponentsImportance || (ComponentsImportance = {}));
let DEFAULT_SHEETVIEW_SIZE = 0;
function getDefaultSheetViewSize() {
    return DEFAULT_SHEETVIEW_SIZE;
}
function setDefaultSheetViewSize(size) {
    DEFAULT_SHEETVIEW_SIZE = size;
}
const MAXIMAL_FREEZABLE_RATIO = 0.85;
const NEWLINE = "\n";
const FONT_SIZES = [6, 7, 8, 9, 10, 11, 12, 14, 18, 24, 36];
// Pivot
const PIVOT_TABLE_CONFIG = {
    hasFilters: false,
    totalRow: false,
    firstColumn: true,
    lastColumn: false,
    numberOfHeaders: 1,
    bandedRows: true,
    bandedColumns: false,
    styleId: "TableStyleMedium5",
    automaticAutofill: false,
};
const DEFAULT_CURRENCY = {
    symbol: "$",
    position: "before",
    decimalPlaces: 2,
    code: "",
    name: "Dollar",
};

//------------------------------------------------------------------------------
// Miscellaneous
//------------------------------------------------------------------------------
const sanitizeSheetNameRegex = new RegExp(FORBIDDEN_SHEETNAME_CHARS_IN_EXCEL_REGEX, "g");
/**
 * Remove quotes from a quoted string
 * ```js
 * removeStringQuotes('"Hello"')
 * > 'Hello'
 * ```
 */
function removeStringQuotes(str) {
    if (str[0] === '"') {
        str = str.slice(1);
    }
    if (str[str.length - 1] === '"' && str[str.length - 2] !== "\\") {
        return str.slice(0, str.length - 1);
    }
    return str;
}
function isCloneable(obj) {
    return "clone" in obj && obj.clone instanceof Function;
}
/**
 * Escapes a string to use as a literal string in a RegExp.
 * @url https://developer.mozilla.org/en-US/docs/Web/JavaScript/Guide/Regular_Expressions#Escaping
 */
function escapeRegExp(str) {
    return str.replace(/[.*+?^${}()|[\]\\]/g, "\\$&");
}
/**
 * Deep copy arrays, plain objects and primitive values.
 * Throws an error for other types such as class instances.
 * Sparse arrays remain sparse.
 */
function deepCopy(obj) {
    switch (typeof obj) {
        case "object": {
            if (obj === null) {
                return obj;
            }
            else if (isCloneable(obj)) {
                return obj.clone();
            }
            else if (!(isPlainObject(obj) || obj instanceof Array)) {
                throw new Error("Unsupported type: only objects and arrays are supported");
            }
            const result = Array.isArray(obj) ? new Array(obj.length) : {};
            if (Array.isArray(obj)) {
                for (let i = 0, len = obj.length; i < len; i++) {
                    if (i in obj) {
                        result[i] = deepCopy(obj[i]);
                    }
                }
            }
            else {
                for (const key in obj) {
                    result[key] = deepCopy(obj[key]);
                }
            }
            return result;
        }
        case "number":
        case "string":
        case "boolean":
        case "function":
        case "undefined":
            return obj;
        default:
            throw new Error(`Unsupported type: ${typeof obj}`);
    }
}
/**
 * Check if the object is a plain old javascript object.
 */
function isPlainObject(obj) {
    return (typeof obj === "object" &&
        obj !== null &&
        // obj.constructor can be undefined when there's no prototype (`Object.create(null, {})`)
        (obj?.constructor === Object || obj?.constructor === undefined));
}
/**
 * Sanitize the name of a sheet, by eventually removing quotes
 * @param sheetName name of the sheet, potentially quoted with single quotes
 */
function getUnquotedSheetName(sheetName) {
    return unquote(sheetName, "'");
}
function unquote(string, quoteChar = '"') {
    if (string.startsWith(quoteChar)) {
        string = string.slice(1);
    }
    if (string.endsWith(quoteChar)) {
        string = string.slice(0, -1);
    }
    return string;
}
/**
 * Add quotes around the sheet name or any symbol name if it contains at least one non alphanumeric character
 * '\w' captures [0-9][a-z][A-Z] and _.
 * @param symbolName Name of the sheet or symbol
 */
function getCanonicalSymbolName(symbolName) {
    if (symbolName.match(/\w/g)?.length !== symbolName.length) {
        symbolName = `'${symbolName}'`;
    }
    return symbolName;
}
/** Replace the excel-excluded characters of a sheetName */
function sanitizeSheetName(sheetName, replacementChar = " ") {
    return sheetName.replace(sanitizeSheetNameRegex, replacementChar);
}
function clip(val, min, max) {
    return val < min ? min : val > max ? max : val;
}
/**
 * Create a range from start (included) to end (excluded).
 * range(10, 13) => [10, 11, 12]
 * range(2, 8, 2) => [2, 4, 6]
 */
function range(start, end, step = 1) {
    if (end <= start && step > 0) {
        return [];
    }
    if (step === 0) {
        throw new Error("range() step must not be zero");
    }
    const length = Math.ceil(Math.abs((end - start) / step));
    const array = Array(length);
    for (let i = 0; i < length; i++) {
        array[i] = start + i * step;
    }
    return array;
}
/**
 * Groups consecutive numbers.
 * The input array is assumed to be sorted
 * @param numbers
 */
function groupConsecutive(numbers) {
    return numbers.reduce((groups, currentRow, index, rows) => {
        if (Math.abs(currentRow - rows[index - 1]) === 1) {
            const lastGroup = groups[groups.length - 1];
            lastGroup.push(currentRow);
        }
        else {
            groups.push([currentRow]);
        }
        return groups;
    }, []);
}
/**
 * Create one generator from two generators by linking
 * each item of the first generator to the next item of
 * the second generator.
 *
 * Let's say generator G1 yields A, B, C and generator G2 yields X, Y, Z.
 * The resulting generator of `linkNext(G1, G2)` will yield A', B', C'
 * where `A' = A & {next: Y}`, `B' = B & {next: Z}` and `C' = C & {next: undefined}`
 * @param generator
 * @param nextGenerator
 */
function* linkNext(generator, nextGenerator) {
    nextGenerator.next();
    for (const item of generator) {
        const nextItem = nextGenerator.next();
        yield {
            ...item,
            next: nextItem.done ? undefined : nextItem.value,
        };
    }
}
function isBoolean(str) {
    const upperCased = str.toUpperCase();
    return upperCased === "TRUE" || upperCased === "FALSE";
}
const MARKDOWN_LINK_REGEX = /^\[(.+)\]\((.+)\)$/;
//link must start with http or https
//https://stackoverflow.com/a/3809435/4760614
const WEB_LINK_REGEX = /^https?:\/\/(www\.)?[-a-zA-Z0-9@:%._\+~#=]{2,256}\.[a-z]{2,4}\b([-a-zA-Z0-9@:%_\+.~#?&//=]*)$/;
function isMarkdownLink(str) {
    return MARKDOWN_LINK_REGEX.test(str);
}
/**
 * Check if the string is a web link.
 * e.g. http://odoo.com
 */
function isWebLink(str) {
    return WEB_LINK_REGEX.test(str);
}
/**
 * Build a markdown link from a label and an url
 */
function markdownLink(label, url) {
    return `[${label}](${url})`;
}
function parseMarkdownLink(str) {
    const matches = str.match(MARKDOWN_LINK_REGEX) || [];
    const label = matches[1];
    const url = matches[2];
    if (!label || !url) {
        throw new Error(`Could not parse markdown link ${str}.`);
    }
    return {
        label,
        url,
    };
}
const O_SPREADSHEET_LINK_PREFIX = "o-spreadsheet://";
function isSheetUrl(url) {
    return url.startsWith(O_SPREADSHEET_LINK_PREFIX);
}
function buildSheetLink(sheetId) {
    return `${O_SPREADSHEET_LINK_PREFIX}${sheetId}`;
}
/**
 * Parse a sheet link and return the sheet id
 */
function parseSheetUrl(sheetLink) {
    if (sheetLink.startsWith(O_SPREADSHEET_LINK_PREFIX)) {
        return sheetLink.substr(O_SPREADSHEET_LINK_PREFIX.length);
    }
    throw new Error(`${sheetLink} is not a valid sheet link`);
}
/**
 * This helper function can be used as a type guard when filtering arrays.
 * const foo: number[] = [1, 2, undefined, 4].filter(isDefined)
 */
function isDefined(argument) {
    return argument !== undefined;
}
function isNotNull(argument) {
    return argument !== null;
}
/**
 * Check if all the values of an object, and all the values of the objects inside of it, are undefined.
 */
function isObjectEmptyRecursive(argument) {
    if (argument === undefined)
        return true;
    return Object.values(argument).every((value) => typeof value === "object" ? isObjectEmptyRecursive(value) : !value);
}
/**
 * Returns a function, that, as long as it continues to be invoked, will not
 * be triggered. The function will be called after it stops being called for
 * N milliseconds. If `immediate` is passed, trigger the function on the
 * leading edge, instead of the trailing.
 *
 * Also decorate the argument function with two methods: stopDebounce and isDebouncePending.
 *
 * Inspired by https://davidwalsh.name/javascript-debounce-function
 */
function debounce(func, wait, immediate) {
    let timeout = undefined;
    const debounced = function () {
        const context = this;
        const args = Array.from(arguments);
        function later() {
            timeout = undefined;
            if (!immediate) {
                func.apply(context, args);
            }
        }
        const callNow = immediate && !timeout;
        clearTimeout(timeout);
        timeout = setTimeout(later, wait);
        if (callNow) {
            func.apply(context, args);
        }
    };
    debounced.isDebouncePending = () => timeout !== undefined;
    debounced.stopDebounce = () => {
        clearTimeout(timeout);
    };
    return debounced;
}
/**
 * Creates a batched version of a callback so that all calls to it in the same
 * microtick will only call the original callback once.
 *
 * @param callback the callback to batch
 * @returns a batched version of the original callback
 *
 * Copied from odoo/owl repo.
 */
function batched(callback) {
    let scheduled = false;
    return async (...args) => {
        if (!scheduled) {
            scheduled = true;
            await Promise.resolve();
            scheduled = false;
            callback(...args);
        }
    };
}
/*
 * Concatenate an array of strings.
 */
function concat(chars) {
    // ~40% faster than chars.join("")
    let output = "";
    for (let i = 0, len = chars.length; i < len; i++) {
        output += chars[i];
    }
    return output;
}
/**
 * Lazy value computed by the provided function.
 */
function lazy(fn) {
    let isMemoized = false;
    let memo;
    const lazyValue = () => {
        if (!isMemoized) {
            memo = fn instanceof Function ? fn() : fn;
            isMemoized = true;
        }
        return memo;
    };
    lazyValue.map = (callback) => lazy(() => callback(lazyValue()));
    return lazyValue;
}
/**
 * Find the next defined value after the given index in an array of strings. If there is no defined value
 * after the index, return the closest defined value before the index. Return an empty string if no
 * defined value was found.
 *
 */
function findNextDefinedValue(arr, index) {
    let value = arr.slice(index).find((val) => val);
    if (!value) {
        value = arr
            .slice(0, index)
            .reverse()
            .find((val) => val);
    }
    return value || "";
}
/** Get index of first header added by an ADD_COLUMNS_ROWS command */
function getAddHeaderStartIndex(position, base) {
    return position === "after" ? base + 1 : base;
}
/**
 * Compares two objects.
 */
function deepEquals(o1, o2) {
    if (o1 === o2)
        return true;
    if ((o1 && !o2) || (o2 && !o1))
        return false;
    if (typeof o1 !== typeof o2)
        return false;
    if (typeof o1 !== "object")
        return false;
    // Objects can have different keys if the values are undefined
    for (const key in o2) {
        if (!(key in o1) && o2[key] !== undefined) {
            return false;
        }
    }
    for (const key in o1) {
        if (typeof o1[key] !== typeof o2[key])
            return false;
        if (typeof o1[key] === "object") {
            if (!deepEquals(o1[key], o2[key]))
                return false;
        }
        else {
            if (o1[key] !== o2[key])
                return false;
        }
    }
    return true;
}
/**
 * Compares two arrays.
 * For performance reasons, this function is to be preferred
 * to 'deepEquals' in the case we know that the inputs are arrays.
 */
function deepEqualsArray(arr1, arr2) {
    if (arr1.length !== arr2.length) {
        return false;
    }
    for (let i = 0; i < arr1.length; i++) {
        if (!deepEquals(arr1[i], arr2[i])) {
            return false;
        }
    }
    return true;
}
/**
 * Check if the given array contains all the values of the other array.
 * It makes the assumption that both array do not contain duplicates.
 */
function includesAll(arr, values) {
    if (arr.length < values.length) {
        return false;
    }
    const set = new Set(arr);
    return values.every((value) => set.has(value));
}
/**
 * Return an object with all the keys in the object that have a falsy value removed.
 */
function removeFalsyAttributes(obj) {
    if (!obj)
        return obj;
    const cleanObject = { ...obj };
    Object.keys(cleanObject).forEach((key) => !cleanObject[key] && delete cleanObject[key]);
    return cleanObject;
}
/**
 * Equivalent to "\s" in regexp, minus the new lines characters
 *
 * https://developer.mozilla.org/en-US/docs/Web/JavaScript/Guide/Regular_Expressions/Character_Classes
 */
const whiteSpaceSpecialCharacters = [
    " ",
    "\t",
    "\f",
    "\v",
    String.fromCharCode(parseInt("00a0", 16)),
    String.fromCharCode(parseInt("1680", 16)),
    String.fromCharCode(parseInt("2000", 16)),
    String.fromCharCode(parseInt("200a", 16)),
    String.fromCharCode(parseInt("2028", 16)),
    String.fromCharCode(parseInt("2029", 16)),
    String.fromCharCode(parseInt("202f", 16)),
    String.fromCharCode(parseInt("205f", 16)),
    String.fromCharCode(parseInt("3000", 16)),
    String.fromCharCode(parseInt("feff", 16)),
];
const whiteSpaceRegexp = new RegExp(whiteSpaceSpecialCharacters.join("|"), "g");
const newLineRegexp = /(\r\n|\r)/g;
/**
 * Replace all different newlines characters by \n
 */
function replaceNewLines(text) {
    if (!text)
        return "";
    return text.replace(newLineRegexp, NEWLINE);
}
/**
 * Determine if the numbers are consecutive.
 */
function isConsecutive(iterable) {
    const array = Array.from(iterable).sort((a, b) => a - b); // sort numerically rather than lexicographically
    for (let i = 1; i < array.length; i++) {
        if (array[i] - array[i - 1] !== 1) {
            return false;
        }
    }
    return true;
}
/**
 * Creates a version of the function that's memoized on the value of its first
 * argument, if any.
 */
function memoize(func) {
    const cache = new Map();
    const funcName = func.name ? func.name + " (memoized)" : "memoized";
    return {
        [funcName](...args) {
            if (!cache.has(args[0])) {
                cache.set(args[0], func(...args));
            }
            return cache.get(args[0]);
        },
    }[funcName];
}
function removeIndexesFromArray(array, indexes) {
    return array.filter((_, index) => !indexes.includes(index));
}
function insertItemsAtIndex(array, items, index) {
    const newArray = [...array];
    newArray.splice(index, 0, ...items);
    return newArray;
}
function replaceItemAtIndex(array, newItem, index) {
    const newArray = [...array];
    newArray.splice(index, 1, newItem);
    return newArray;
}
function trimContent(content) {
    const contentLines = content.split("\n");
    return contentLines.map((line) => line.replace(/\s+/g, " ").trim()).join("\n");
}
function isNumberBetween(value, min, max) {
    if (min > max) {
        return isNumberBetween(value, max, min);
    }
    return value >= min && value <= max;
}
/**
 * Get a Regex for the find & replace that matches the given search string and options.
 */
function getSearchRegex(searchStr, searchOptions) {
    let searchValue = escapeRegExp(searchStr);
    const flags = !searchOptions.matchCase ? "i" : "";
    if (searchOptions.exactMatch) {
        searchValue = `^${searchValue}$`;
    }
    return RegExp(searchValue, flags);
}
/**
 * Alternative to Math.max that works with large arrays.
 * Typically useful for arrays bigger than 100k elements.
 */
function largeMax(array) {
    let len = array.length;
    if (len < 100_000)
        return Math.max(...array);
    let max = -Infinity;
    while (len--) {
        max = array[len] > max ? array[len] : max;
    }
    return max;
}
/**
 * Alternative to Math.min that works with large arrays.
 * Typically useful for arrays bigger than 100k elements.
 */
function largeMin(array) {
    let len = array.length;
    if (len < 100_000)
        return Math.min(...array);
    let min = +Infinity;
    while (len--) {
        min = array[len] < min ? array[len] : min;
    }
    return min;
}
class TokenizingChars {
    text;
    currentIndex = 0;
    current;
    constructor(text) {
        this.text = text;
        this.current = text[0];
    }
    shift() {
        const current = this.current;
        const next = this.text[++this.currentIndex];
        this.current = next;
        return current;
    }
    advanceBy(length) {
        this.currentIndex += length;
        this.current = this.text[this.currentIndex];
    }
    isOver() {
        return this.currentIndex >= this.text.length;
    }
    remaining() {
        return this.text.substring(this.currentIndex);
    }
    currentStartsWith(str) {
        if (this.current !== str[0]) {
            return false;
        }
        for (let j = 1; j < str.length; j++) {
            if (this.text[this.currentIndex + j] !== str[j]) {
                return false;
            }
        }
        return true;
    }
}
/**
 * Remove duplicates from an array.
 *
 * @param array The array to remove duplicates from.
 * @param cb A callback to get an element value.
 */
function removeDuplicates$1(array, cb = (a) => a) {
    const set = new Set();
    return array.filter((item) => {
        const key = cb(item);
        if (set.has(key)) {
            return false;
        }
        set.add(key);
        return true;
    });
}
/**
 * Similar to transposing and array, but with POJOs instead of arrays. Useful, for example, when manipulating
 * a POJO grid[col][row] and you want to transpose it to grid[row][col].
 *
 * The resulting object is created such as result[key1][key2] = pojo[key2][key1]
 */
function transpose2dPOJO(pojo) {
    const result = {};
    for (const key in pojo) {
        for (const subKey in pojo[key]) {
            if (!result[subKey]) {
                result[subKey] = {};
            }
            result[subKey][key] = pojo[key][subKey];
        }
    }
    return result;
}

const RBA_REGEX = /rgba?\(|\s+|\)/gi;
const HEX_MATCH = /^#([A-F\d]{2}){3,4}$/;
const colors$1 = [
    "#eb6d00",
    "#0074d9",
    "#ad8e00",
    "#169ed4",
    "#b10dc9",
    "#00a82d",
    "#00a3a3",
    "#f012be",
    "#3d9970",
    "#111111",
    "#62A300",
    "#ff4136",
    "#949494",
    "#85144b",
    "#001f3f",
];
/*
 * transform a color number (R * 256^2 + G * 256 + B) into classic hex6 value
 * */
function colorNumberString(color) {
    return toHex(color.toString(16).padStart(6, "0"));
}
/**
 * Converts any CSS color value to a standardized hex6 value.
 * Accepts: hex3, hex6, hex8, rgb[1] and rgba[1].
 *
 * [1] under the form rgb(r, g, b, a?) or rgba(r, g, b, a?)
 * with r,g,b ∈ [0, 255] and a ∈ [0, 1]
 *
 * toHex("#ABC")
 * >> "#AABBCC"
 *
 * toHex("#AAAFFF")
 * >> "#AAAFFF"
 *
 * toHex("rgb(30, 80, 16)")
 * >> "#1E5010"
 *
 *  * toHex("rgb(30, 80, 16, 0.5)")
 * >> "#1E501080"
 *
 */
function toHex(color) {
    let hexColor = color;
    if (color.startsWith("rgb")) {
        hexColor = rgbaStringToHex(color);
    }
    else {
        hexColor = color.replace("#", "").toUpperCase();
        if (hexColor.length === 3 || hexColor.length === 4) {
            hexColor = hexColor.split("").reduce((acc, h) => acc + h + h, "");
        }
        hexColor = `#${hexColor}`;
    }
    if (!HEX_MATCH.test(hexColor)) {
        throw new Error(`invalid color input: ${color}`);
    }
    return hexColor;
}
function isColorValid(color) {
    try {
        toHex(color);
        return true;
    }
    catch (error) {
        return false;
    }
}
function isHSLAValid(color) {
    try {
        hslaToHex(color);
        return true;
    }
    catch (error) {
        return false;
    }
}
const isColorValueValid = (v) => v >= 0 && v <= 255;
function rgba(r, g, b, a = 1) {
    const isInvalid = !isColorValueValid(r) || !isColorValueValid(g) || !isColorValueValid(b) || a < 0 || a > 1;
    if (isInvalid) {
        throw new Error(`Invalid RGBA values ${[r, g, b, a]}`);
    }
    return { a, b, g, r };
}
/**
 * The relative brightness of a point in the colorspace, normalized to 0 for
 * darkest black and 1 for lightest white.
 * https://www.w3.org/TR/WCAG20/#relativeluminancedef
 */
function relativeLuminance(color) {
    let { r, g, b } = colorToRGBA(color);
    r /= 255;
    g /= 255;
    b /= 255;
    const toLinearValue = (c) => (c <= 0.03928 ? c / 12.92 : ((c + 0.055) / 1.055) ** 2.4);
    const R = toLinearValue(r);
    const G = toLinearValue(g);
    const B = toLinearValue(b);
    return 0.2126 * R + 0.7152 * G + 0.0722 * B;
}
/**
 * Convert a CSS rgb color string to a standardized hex6 color value.
 *
 * rgbaStringToHex("rgb(30, 80, 16)")
 * >> "#1E5010"
 *
 * rgbaStringToHex("rgba(30, 80, 16, 0.5)")
 * >> "#1E501080"
 *
 * DOES NOT SUPPORT NON INTEGER RGB VALUES
 */
function rgbaStringToHex(color) {
    const stringVals = color.replace(RBA_REGEX, "").split(",");
    let alphaHex = 255;
    if (stringVals.length !== 3 && stringVals.length !== 4) {
        throw new Error("invalid color");
    }
    else if (stringVals.length === 4) {
        const alpha = parseFloat(stringVals.pop() || "1");
        alphaHex = Math.round((alpha || 1) * 255);
    }
    const vals = stringVals.map((val) => parseInt(val, 10));
    if (alphaHex !== 255) {
        vals.push(alphaHex);
    }
    return "#" + concat(vals.map((value) => value.toString(16).padStart(2, "0"))).toUpperCase();
}
/**
 * RGBA to HEX representation (#RRGGBBAA).
 *
 * https://css-tricks.com/converting-color-spaces-in-javascript/
 */
function rgbaToHex(rgba) {
    let r = rgba.r.toString(16);
    let g = rgba.g.toString(16);
    let b = rgba.b.toString(16);
    let a = Math.round(rgba.a * 255).toString(16);
    if (r.length === 1)
        r = "0" + r;
    if (g.length === 1)
        g = "0" + g;
    if (b.length === 1)
        b = "0" + b;
    if (a.length === 1)
        a = "0" + a;
    if (a === "ff")
        a = "";
    return ("#" + r + g + b + a).toUpperCase();
}
/**
 * Color string to RGBA representation
 */
function colorToRGBA(color) {
    color = toHex(color);
    let r;
    let g;
    let b;
    let a;
    if (color.length === 7) {
        r = parseInt(color[1] + color[2], 16);
        g = parseInt(color[3] + color[4], 16);
        b = parseInt(color[5] + color[6], 16);
        a = 255;
    }
    else if (color.length === 9) {
        r = parseInt(color[1] + color[2], 16);
        g = parseInt(color[3] + color[4], 16);
        b = parseInt(color[5] + color[6], 16);
        a = parseInt(color[7] + color[8], 16);
    }
    else {
        throw new Error("Invalid color");
    }
    a = +(a / 255).toFixed(3);
    return { a, r, g, b };
}
/**
 * HSLA to RGBA.
 *
 * https://css-tricks.com/converting-color-spaces-in-javascript/
 */
function hslaToRGBA(hsla) {
    hsla = { ...hsla };
    // Must be fractions of 1
    hsla.s /= 100;
    hsla.l /= 100;
    let c = (1 - Math.abs(2 * hsla.l - 1)) * hsla.s;
    let x = c * (1 - Math.abs(((hsla.h / 60) % 2) - 1));
    let m = hsla.l - c / 2;
    let r = 0;
    let g = 0;
    let b = 0;
    if (0 <= hsla.h && hsla.h < 60) {
        r = c;
        g = x;
        b = 0;
    }
    else if (60 <= hsla.h && hsla.h < 120) {
        r = x;
        g = c;
        b = 0;
    }
    else if (120 <= hsla.h && hsla.h < 180) {
        r = 0;
        g = c;
        b = x;
    }
    else if (180 <= hsla.h && hsla.h < 240) {
        r = 0;
        g = x;
        b = c;
    }
    else if (240 <= hsla.h && hsla.h < 300) {
        r = x;
        g = 0;
        b = c;
    }
    else if (300 <= hsla.h && hsla.h < 360) {
        r = c;
        g = 0;
        b = x;
    }
    r = Math.round((r + m) * 255);
    g = Math.round((g + m) * 255);
    b = Math.round((b + m) * 255);
    return { a: hsla.a, r, g, b };
}
/**
 * HSLA to RGBA.
 *
 * https://css-tricks.com/converting-color-spaces-in-javascript/
 */
function rgbaToHSLA(rgba) {
    // Make r, g, and b fractions of 1
    const r = rgba.r / 255;
    const g = rgba.g / 255;
    const b = rgba.b / 255;
    // Find greatest and smallest channel values
    let cMin = Math.min(r, g, b);
    let cMax = Math.max(r, g, b);
    let delta = cMax - cMin;
    let h = 0;
    let s = 0;
    let l = 0;
    // Calculate hue
    // No difference
    if (delta === 0)
        h = 0;
    // Red is max
    else if (cMax === r)
        h = ((g - b) / delta) % 6;
    // Green is max
    else if (cMax === g)
        h = (b - r) / delta + 2;
    // Blue is max
    else
        h = (r - g) / delta + 4;
    h = Math.round(h * 60);
    // Make negative hues positive behind 360°
    if (h < 0)
        h += 360;
    l = (cMax + cMin) / 2;
    // Calculate saturation
    s = delta === 0 ? 0 : delta / (1 - Math.abs(2 * l - 1));
    // Multiply l and s by 100
    s = +(s * 100).toFixed(1);
    l = +(l * 100).toFixed(1);
    return { a: rgba.a, h, s, l };
}
function hslaToHex(hsla) {
    return rgbaToHex(hslaToRGBA(hsla));
}
function hexToHSLA(hex) {
    return rgbaToHSLA(colorToRGBA(hex));
}
/**
 * Will compare two color strings
 * A tolerance can be provided to account for small differences that could
 * be introduced by non-bijective transformations between color spaces.
 *
 * E.g. HSV <-> RGB is not a bijection
 *
 * Note that the tolerance is applied on the euclidean distance between
 * the two **normalized** color values.
 */
function isSameColor(color1, color2, tolerance = 0) {
    if (!(isColorValid(color1) && isColorValid(color2))) {
        return false;
    }
    const rgb1 = colorToRGBA(color1);
    const rgb2 = colorToRGBA(color2);
    // alpha cannot differ as it is not impacted by transformations
    if (rgb1.a !== rgb2.a) {
        return false;
    }
    const diff = Math.sqrt(((rgb1.r - rgb2.r) / 255) ** 2 + ((rgb1.g - rgb2.g) / 255) ** 2 + ((rgb1.b - rgb2.b) / 255) ** 2);
    return diff <= tolerance;
}
function setColorAlpha(color, alpha) {
    return alpha === 1 ? toHex(color).slice(0, 7) : rgbaToHex({ ...colorToRGBA(color), a: alpha });
}
function lightenColor(color, percentage) {
    const hsla = hexToHSLA(color);
    if (percentage === 1) {
        return "#fff";
    }
    hsla.l = percentage * (100 - hsla.l) + hsla.l;
    return hslaToHex(hsla);
}
function darkenColor(color, percentage) {
    const hsla = hexToHSLA(color);
    if (percentage === 1) {
        return "#000";
    }
    hsla.l = hsla.l - percentage * hsla.l;
    return hslaToHex(hsla);
}
const COLORS_SM = [
    "#4EA7F2", // Blue
    "#EA6175", // Red
    "#43C5B1", // Teal
    "#F4A261", // Orange
    "#8481DD", // Purple
    "#FFD86D", // Yellow
];
const COLORS_MD = [
    "#4EA7F2", // Blue #1
    "#3188E6", // Blue #2
    "#43C5B1", // Teal #1
    "#00A78D", // Teal #2
    "#EA6175", // Red #1
    "#CE4257", // Red #2
    "#F4A261", // Orange #1
    "#F48935", // Orange #2
    "#8481DD", // Purple #1
    "#5752D1", // Purple #2
    "#FFD86D", // Yellow #1
    "#FFBC2C", // Yellow #2
];
const COLORS_LG = [
    "#4EA7F2", // Blue #1
    "#3188E6", // Blue #2
    "#056BD9", // Blue #3
    "#A76DBC", // Violet #1
    "#7F4295", // Violet #2
    "#6D2387", // Violet #3
    "#EA6175", // Red #1
    "#CE4257", // Red #2
    "#982738", // Red #3
    "#43C5B1", // Teal #1
    "#00A78D", // Teal #2
    "#0E8270", // Teal #3
    "#F4A261", // Orange #1
    "#F48935", // Orange #2
    "#BE5D10", // Orange #3
    "#8481DD", // Purple #1
    "#5752D1", // Purple #2
    "#3A3580", // Purple #3
    "#A4A8B6", // Gray #1
    "#7E8290", // Gray #2
    "#545B70", // Gray #3
    "#FFD86D", // Yellow #1
    "#FFBC2C", // Yellow #2
    "#C08A16", // Yellow #3
];
const COLORS_XL = [
    "#4EA7F2", // Blue #1
    "#3188E6", // Blue #2
    "#056BD9", // Blue #3
    "#155193", // Blue #4
    "#A76DBC", // Violet #1
    "#7F4295", // Violet #1
    "#6D2387", // Violet #1
    "#4F1565", // Violet #1
    "#EA6175", // Red #1
    "#CE4257", // Red #2
    "#982738", // Red #3
    "#791B29", // Red #4
    "#43C5B1", // Teal #1
    "#00A78D", // Teal #2
    "#0E8270", // Teal #3
    "#105F53", // Teal #4
    "#F4A261", // Orange #1
    "#F48935", // Orange #2
    "#BE5D10", // Orange #3
    "#7D380D", // Orange #4
    "#8481DD", // Purple #1
    "#5752D1", // Purple #2
    "#3A3580", // Purple #3
    "#26235F", // Purple #4
    "#A4A8B6", // Grey #1
    "#7E8290", // Grey #2
    "#545B70", // Grey #3
    "#3F4250", // Grey #4
    "#FFD86D", // Yellow #1
    "#FFBC2C", // Yellow #2
    "#C08A16", // Yellow #3
    "#936A12", // Yellow #4
];
function getNthColor(index, palette) {
    return palette[index % palette.length];
}
function getColorsPalette(quantity) {
    if (quantity <= 6) {
        return COLORS_SM;
    }
    else if (quantity <= 12) {
        return COLORS_MD;
    }
    else if (quantity <= 24) {
        return COLORS_LG;
    }
    else {
        return COLORS_XL;
    }
}
class ColorGenerator {
    preferredColors;
    currentColorIndex = 0;
    palette;
    constructor(paletteSize, preferredColors = []) {
        this.preferredColors = preferredColors;
        this.palette = getColorsPalette(paletteSize).filter((c) => !preferredColors.includes(c));
    }
    next() {
        return this.preferredColors?.[this.currentColorIndex]
            ? this.preferredColors[this.currentColorIndex++]
            : getNthColor(this.currentColorIndex++, this.palette);
    }
}

//------------------------------------------------------------------------------
// Coordinate
//------------------------------------------------------------------------------
/**
 * Convert a (col) number to the corresponding letter.
 *
 * Examples:
 *     0 => 'A'
 *     25 => 'Z'
 *     26 => 'AA'
 *     27 => 'AB'
 */
function numberToLetters(n) {
    if (n < 0) {
        throw new Error(`number must be positive. Got ${n}`);
    }
    if (n < 26) {
        return String.fromCharCode(65 + n);
    }
    else {
        return numberToLetters(Math.floor(n / 26) - 1) + numberToLetters(n % 26);
    }
}
function lettersToNumber(letters) {
    let result = 0;
    const l = letters.length;
    for (let i = 0; i < l; i++) {
        const charCode = letters.charCodeAt(i);
        const colIndex = charCode >= 65 && charCode <= 90 ? charCode - 64 : charCode - 96;
        result = result * 26 + colIndex;
    }
    return result - 1;
}
function isCharALetter(char) {
    return (char >= "A" && char <= "Z") || (char >= "a" && char <= "z");
}
function isCharADigit(char) {
    return char >= "0" && char <= "9";
}
/**
 * Convert a "XC" coordinate to cartesian coordinates.
 *
 * Examples:
 *   A1 => [0,0]
 *   B3 => [1,2]
 *
 * Note: it also accepts lowercase coordinates, but not fixed references
 */
function toCartesian(xc) {
    xc = xc.trim();
    let letterPart = "";
    let numberPart = "";
    let i = 0;
    // Process letter part
    if (xc[i] === "$")
        i++;
    while (i < xc.length && isCharALetter(xc[i])) {
        letterPart += xc[i++];
    }
    if (letterPart.length === 0 || letterPart.length > 3) {
        // limit to max 3 letters for performance reasons
        throw new Error(`Invalid cell description: ${xc}`);
    }
    // Process number part
    if (xc[i] === "$")
        i++;
    while (i < xc.length && isCharADigit(xc[i])) {
        numberPart += xc[i++];
    }
    if (i !== xc.length || numberPart.length === 0 || numberPart.length > 7) {
        // limit to max 7 numbers for performance reasons
        throw new Error(`Invalid cell description: ${xc}`);
    }
    const col = lettersToNumber(letterPart);
    const row = Number(numberPart) - 1;
    if (isNaN(row)) {
        throw new Error(`Invalid cell description: ${xc}`);
    }
    return { col, row };
}
/**
 * Convert from cartesian coordinate to the "XC" coordinate system.
 *
 * Examples:
 *   - 0,0 => A1
 *   - 1,2 => B3
 *   - 0,0, {colFixed: false, rowFixed: true} => A$1
 *   - 1,2, {colFixed: true, rowFixed: false} => $B3
 */
function toXC(col, row, rangePart = { colFixed: false, rowFixed: false }) {
    return ((rangePart.colFixed ? "$" : "") +
        numberToLetters(col) +
        (rangePart.rowFixed ? "$" : "") +
        String(row + 1));
}

/**
 * ####################################################
 * # INTRODUCTION
 * ####################################################
 *
 * This file contain the function recomputeZones.
 * This function try to recompute in a performant way
 * an ensemble of zones possibly overlapping to avoid
 * overlapping and to reduce the number of zones.
 *
 * It also allows to remove some zones from the ensemble.
 *
 * In the following example, 2 zones are overlapping.
 * Applying recomputeZones will return zones without
 * overlapping:
 *
 * ["B3:D4", "D2:E3"]         ["B3:C4", "D2:D4", "E2:E3"]
 *
 *      A B C D E                    A B C D E
 *    1       ___                  1       ___
 *    2   ___|_  |                 2   ___| | |
 *    3  |   |_|_|      --->       3  |   | |_|
 *    4  |_____|                   4  |___|_|
 *    6                            6
 *    7                            7
 *
 *
 * In the following example, 2 zones are contiguous.
 * Applying recomputeZones will return only one zone:
 *
 *  ["B2:B3", "C2:D3"]               ["B2:D3"]
 *
 *       A B C D E                   A B C D E
 *     1   _ ___                   1   _____
 *     2  | |   |        --->      2  |     |
 *     3  |_|___|                  3  |_____|
 *     4                           4
 *
 *
 * In the following example, we want to remove a zone
 * from the ensemble. Applying recomputeZones will
 * return the ensemble without the zone to remove:
 *
 *    remove ["C3:D3"]           ["B2:B4", "C2:D2",
 *                                "C4:D4", "E2:E4"]
 *
 *       A B C D E F                 A B C D E F
 *     1   _______                 1   _______
 *     2  |       |       --->     2  | |___| |
 *     3  |  xxx  |                3  | |___| |
 *     4  |_______|                4  |_|___|_|
 *     5                           5
 *
 *
 * The exercise seems simple when we have only 2 zones.
 * But with n zones and in a performant way, we want to
 * avoid comparing each zone with all the others.
 *
 *
 * ####################################################
 * # Methodological approach
 * ####################################################
 *
 * The methodological approach to avoid comparing each
 * zone with all the others is to use a data structure
 * that allow to quickly find which zones are
 * overlapping with any other given zone.
 *
 * Here the idea is to profile the zones at the columns level.
 *
 * To do that, we propose to use a data structure
 * composed of 2 parts:
 * - profilesStartingPosition: a sorted number array
 * indicating on which columns a new profile begins.
 * - profiles: a map where the key is a column
 * position (from profilesStartingPosition) and the
 * value is a sorted number array representing a
 * profile.
 *
 *
 * See the following example:    here profileStartingPosition
 *                               corresponds to [A,C,E,G,K]
 *    A B C D E F G H I J K      so with number [0,2,4,6,10]
 *  1    '   '   '       '
 *  2    '   '   '_______'       here profile correspond
 *  3    '___'   |_______|       for A to []
 *  4    |   |                   for C to [3, 5]
 *  5    |___|                   for E to []
 *  6                            for G to [2, 3]
 *  7                            for K to []
 *
 *
 * Now we can easily find which zones are overlapping
 * with a given zone. Suppose we want to add a new zone
 * D5:H6 to the ensemble:
 *
 *                              With a binary search of left and right
 *    A B C D E F G H I J K     on profilesStartingPosition, we can
 *  1    '   '   '       '      find the indexes of the profiles on which
 *  2    '   '   '_______'      to apply a modification.
 *  3    '___'   |_______|
 *  4    |  _|_______           Here we will:
 *  5    |_|_|       |          - add a new profile in D   --> become [3, 6]
 *  6      |_________|          - modify the profile in E  --> become [4, 6]
 *  7                           - modify the profile in G  --> become [2, 3, 4, 6]
 *                              - add a new profile in I   --> become [8, 10]
 *
 *  See below the result:
 *
 *                              Note the particularity of the profile
 *    A B C D E F G H I J K     for G: it will correspond to [2, 3, 4, 6]
 *  1    ' ' '   '   '   '
 *  2    ' ' '   '___'___'      To know how to modify the profile (add a
 *  3    '_'_'   |___|___|      zone or remove it) we do a binary
 *  4    | | |___ ___           search of the top and bottom value on the
 *  5    |_| |   |   |          profile array. Depending on the result index
 *  6      |_|___|___|          parity (odd or even), because zone boundaries
 *  7                           go by pairs, we know if we are in a zone or
 *                              not and how operate.
 */
/**
 * Recompute the zone without the cells in toRemoveZones and avoid overlapping.
 * This compute is particularly useful because after this function:
 * - you will find coordinate of a cell only once among all the zones
 * - the number of zones will be reduced to the minimum
 */
function recomputeZones(zones, zonesToRemove = []) {
    if (zones.length <= 1 && zonesToRemove.length === 0) {
        return zones;
    }
    const profilesStartingPosition = [0];
    const profiles = new Map([[0, []]]);
    modifyProfiles(profilesStartingPosition, profiles, zones, false);
    modifyProfiles(profilesStartingPosition, profiles, zonesToRemove, true);
    return constructZonesFromProfiles(profilesStartingPosition, profiles);
}
function modifyProfiles(// export for testing only
profilesStartingPosition, profiles, zones, toRemove = false) {
    for (const zone of zones) {
        const leftValue = zone.left;
        const rightValue = zone.right === undefined ? undefined : zone.right + 1;
        const leftIndex = findIndexAndCreateProfile(profilesStartingPosition, profiles, leftValue, true, 0);
        const rightIndex = findIndexAndCreateProfile(profilesStartingPosition, profiles, rightValue, false, leftIndex);
        for (let i = leftIndex; i <= rightIndex; i++) {
            const profile = profiles.get(profilesStartingPosition[i]);
            modifyProfile(profile, zone, toRemove);
        }
        // maybe this part cost in performance, and maybe it's not necessary (depending on the use case). To be checked
        removeContiguousProfiles(profilesStartingPosition, profiles, leftIndex, rightIndex);
    }
}
function findIndexAndCreateProfile(profilesStartingPosition, profiles, value, searchLeft, startIndex) {
    if (value === undefined) {
        // this is only the case when the value correspond to a bottom value that could be undefined
        return profilesStartingPosition.length - 1;
    }
    const predecessorIndex = binaryPredecessorSearch(profilesStartingPosition, value, startIndex);
    if (value != profilesStartingPosition[predecessorIndex]) {
        // mean that the value is not ending/starting at the same position as the previous/next profile
        // --> it's a new profile
        // --> we need to add it
        profilesStartingPosition.splice(predecessorIndex + 1, 0, value);
        // suppose the               we want to add the       for the left value
        // following profile         following zone:          'C', the predecessor index
        //   for B: [1, 3]                "C3:D4"             correspond to 'B'.
        //                                                    The next line code will
        //       A B C D                A B C D               copy the profile of 'B'
        //     1  '___'               1  '___'                to 'C'. In the rest of the
        //     2  |   |       --->    2  |  _|_               process the 'modifyProfile'
        //     3  |___|               3  |_|_| |              function will adapt the waiting
        //     4                      4    |___|              'C' profile [1, 3] to the
        //                                                    correct 'C' profile [1, 4]
        profiles.set(value, [...profiles.get(profilesStartingPosition[predecessorIndex])]);
        return searchLeft ? predecessorIndex + 1 : predecessorIndex;
    }
    return searchLeft ? predecessorIndex : predecessorIndex - 1;
}
/**
 *  Suppose the following        Suppose we want to add          We want to have the
 *  profile:                     the following zone:             following profile:
 *
 *       A B C D E F                  A B C D E F                     A B C D E F
 *     1    '___'                   1    '   '                      1    '___'
 *     2    |___|                   2    '___'                      2    |   |
 *     3    '   '                   3    |   |                      3    |   |
 *     4    '___'          -->      4    |   |            -->       4    |   |
 *     6    |   |                   6    |___|                      6    |   |
 *     7    |___|                   7                               7    |___|
 *     8                            8                               8
 *
 *  the profile for 'C'          the top zone correspond        Here [2, 3, 5, 8] with [3, 7]
 *  corresponds to:              to 3 and the bottom zone       would be merged into [2, 8]
 *   ____  ____                  correspond to 6
 *  [2, 3, 5, 8]                 would be the profile:          The difficulty of modify profile
 *                                ____                          is to know what must be deleted
 *  Note that the 'filled        [3, 7]                         and what must be added to the
 *  zone' are always between                                    existing profile.
 *  an even index and its
 *  next index
 *
 */
function modifyProfile(profile, zone, toRemove = false) {
    const topValue = zone.top;
    const bottomValue = zone.bottom === undefined ? undefined : zone.bottom + 1;
    const newPoints = [];
    // Case we want to add a zone to the profile:
    // - If the top predecessor index `topPredIndex` is even, it means the top of the zone is already positioned on a filled zone
    // so we don't need to add it to the profile. we can keep in reference the index of the predecessor.
    // - If it is odd, it means the top of the zone must be the beginning of a filled zone.
    // so we can keep the index of the top position
    // Case we want to remove a zone from the profile: it's the opposite of the previous case
    const topPredIndex = binaryPredecessorSearch(profile, topValue, 0, false);
    if ((topPredIndex % 2 !== 0 && !toRemove) || (topPredIndex % 2 === 0 && toRemove)) {
        newPoints.push(topValue);
    }
    if (bottomValue === undefined) {
        // The following two code lines will not impact the final result,
        // but they will impact the intermediate profile.
        // We keep them for performance reason
        profile.splice(topPredIndex + 1);
        profile.push(...newPoints);
        return;
    }
    // Case we want to add a zone to the profile:
    // - If the bottom successor index `bottomSuccIndex` is even, it means the bottom of the zone must be the ending of a filled zone
    // so we can keep the index of the bottom position.
    // - If it is odd, it means the bottom of the zone is already positioned on a filled zone
    // so we don't need to add it to the profile. we can keep in reference the index of the successor
    // Case we want to remove a zone from the profile: it's the opposite of the previous case
    const bottomSuccIndex = binarySuccessorSearch(profile, bottomValue, 0, false);
    if ((bottomSuccIndex % 2 === 0 && !toRemove) || (bottomSuccIndex % 2 !== 0 && toRemove)) {
        newPoints.push(bottomValue);
    }
    // add the top and bottom value to the profile and
    // remove all information between the top and bottom index
    profile.splice(topPredIndex + 1, bottomSuccIndex - topPredIndex - 1, ...newPoints);
}
function removeContiguousProfiles(profilesStartingPosition, profiles, leftIndex, rightIndex) {
    const start = leftIndex - 1 === -1 ? 0 : leftIndex - 1;
    const end = rightIndex === profilesStartingPosition.length - 1 ? rightIndex : rightIndex + 1;
    for (let i = end; i > start; i--) {
        if (deepEqualsArray(profiles.get(profilesStartingPosition[i]), profiles.get(profilesStartingPosition[i - 1]))) {
            profiles.delete(profilesStartingPosition[i]);
            profilesStartingPosition.splice(i, 1);
        }
    }
}
function constructZonesFromProfiles(profilesStartingPosition, profiles) {
    const mergedZone = [];
    let pendingZones = [];
    for (let colIndex = 0; colIndex < profilesStartingPosition.length; colIndex++) {
        const left = profilesStartingPosition[colIndex];
        const profile = profiles.get(left);
        if (!profile || profile.length === 0) {
            mergedZone.push(...pendingZones);
            pendingZones = [];
            continue;
        }
        let right = profilesStartingPosition[colIndex + 1];
        if (right !== undefined) {
            right--;
        }
        const nextPendingZones = [];
        for (let i = 0; i < profile.length; i += 2) {
            const top = profile[i];
            let bottom = profile[i + 1];
            if (bottom !== undefined) {
                bottom--;
            }
            const profileZone = {
                top,
                left,
                bottom,
                right,
                hasHeader: (bottom === undefined && top !== 0) || (right === undefined && left !== 0),
            };
            let findCorrespondingZone = false;
            for (let j = pendingZones.length - 1; j >= 0; j--) {
                const pendingZone = pendingZones[j];
                if (pendingZone.top === profileZone.top && pendingZone.bottom === profileZone.bottom) {
                    pendingZone.right = profileZone.right;
                    pendingZones.splice(j, 1);
                    nextPendingZones.push(pendingZone);
                    findCorrespondingZone = true;
                    break;
                }
            }
            if (!findCorrespondingZone) {
                nextPendingZones.push(profileZone);
            }
        }
        mergedZone.push(...pendingZones);
        pendingZones = nextPendingZones;
    }
    mergedZone.push(...pendingZones);
    return mergedZone;
}
function binaryPredecessorSearch(arr, val, start = 0, matchEqual = true) {
    let end = arr.length - 1;
    let result = -1;
    while (start <= end) {
        const mid = Math.floor((start + end) / 2);
        if (arr[mid] === val && matchEqual) {
            return mid;
        }
        else if (arr[mid] < val) {
            result = mid;
            start = mid + 1;
        }
        else {
            end = mid - 1;
        }
    }
    return result;
}
function binarySuccessorSearch(arr, val, start = 0, matchEqual = true) {
    let end = arr.length - 1;
    let result = arr.length;
    while (start <= end) {
        const mid = Math.floor((start + end) / 2);
        if (arr[mid] === val && matchEqual) {
            return mid;
        }
        else if (arr[mid] > val) {
            result = mid;
            end = mid - 1;
        }
        else {
            start = mid + 1;
        }
    }
    return result;
}

const defaultTranslate = (s) => s;
const defaultLoaded = () => false;
let _translate = defaultTranslate;
let _loaded = defaultLoaded;
function sprintf(s, ...values) {
    if (values.length === 1 && typeof values[0] === "object" && !(values[0] instanceof String)) {
        const valuesDict = values[0];
        s = s.replace(/\%\(([^\)]+)\)s/g, (match, value) => valuesDict[value]);
    }
    else if (values.length > 0) {
        s = s.replace(/\%s/g, () => values.shift());
    }
    return s;
}
/***
 * Allow to inject a translation function from outside o-spreadsheet. This should be called before instantiating
 * a model.
 * @param tfn the function that will do the translation
 * @param loaded a function that returns true when the translation is loaded
 */
function setTranslationMethod(tfn, loaded = () => true) {
    _translate = tfn;
    _loaded = loaded;
}
/**
 * If no translation function has been set, this will mark the translation are loaded.
 *
 * By default, the translations should not be set as loaded, otherwise top-level translated constants will never be
 * translated. But if by the time the model is instantiated no custom translation function has been set, we can set
 * the default translation function as loaded so o-spreadsheet can be run in standalone with no translations.
 */
function setDefaultTranslationMethod() {
    if (_translate === defaultTranslate && _loaded === defaultLoaded) {
        _loaded = () => true;
    }
}
const _t = function (s, ...values) {
    if (!_loaded()) {
        return new LazyTranslatedString(s, values);
    }
    return sprintf(_translate(s), ...values);
};
class LazyTranslatedString extends String {
    values;
    constructor(str, values) {
        super(str);
        this.values = values;
    }
    valueOf() {
        const str = super.valueOf();
        return _loaded() ? sprintf(_translate(str), ...this.values) : sprintf(str, ...this.values);
    }
    toString() {
        return this.valueOf();
    }
}

/** Reference of a cell (eg. A1, $B$5) */
const cellReference = new RegExp(/\$?([A-Z]{1,3})\$?([0-9]{1,7})/, "i");
// Same as above, but matches the exact string (nothing before or after)
const singleCellReference = new RegExp(/^\$?([A-Z]{1,3})\$?([0-9]{1,7})$/, "i");
/** Reference of a column header (eg. A, AB, $A) */
const colHeader = new RegExp(/^\$?([A-Z]{1,3})+$/, "i");
/** Reference of a row header (eg. 1, $1) */
const rowHeader = new RegExp(/^\$?([0-9]{1,7})+$/, "i");
/** Reference of a column (eg. A, $CA, Sheet1!B) */
const colReference = new RegExp(/^\s*('.+'!|[^']+!)?\$?([A-Z]{1,3})$/, "i");
/** Reference of a row (eg. 1, 59, Sheet1!9) */
const rowReference = new RegExp(/^\s*('.+'!|[^']+!)?\$?([0-9]{1,7})$/, "i");
/** Reference of a normal range or a full row range (eg. A1:B1, 1:$5, $A2:5) */
const fullRowXc = /(\$?[A-Z]{1,3})?\$?[0-9]{1,7}\s*:\s*(\$?[A-Z]{1,3})?\$?[0-9]{1,7}\s*/i;
/** Reference of a normal range or a column row range (eg. A1:B1, A:$B, $A1:C) */
const fullColXc = /\$?[A-Z]{1,3}(\$?[0-9]{1,7})?\s*:\s*\$?[A-Z]{1,3}(\$?[0-9]{1,7})?\s*/i;
/** Reference of a cell or a range, it can be a bounded range, a full row or a full column */
const rangeReference = new RegExp(/^\s*('.+'!|[^']+!)?/.source +
    "(" +
    [cellReference.source, fullRowXc.source, fullColXc.source].join("|") +
    ")" +
    /$/.source, "i");
/**
 * Return true if the given xc is the reference of a column (e.g. A or AC or Sheet1!A)
 */
function isColReference(xc) {
    return colReference.test(xc);
}
/**
 * Return true if the given xc is the reference of a column (e.g. 1 or Sheet1!1)
 */
function isRowReference(xc) {
    return rowReference.test(xc);
}
function isColHeader(str) {
    return colHeader.test(str);
}
function isRowHeader(str) {
    return rowHeader.test(str);
}
/**
 * Return true if the given xc is the reference of a single cell,
 * without any specified sheet (e.g. A1)
 */
function isSingleCellReference(xc) {
    return singleCellReference.test(xc);
}
function splitReference(ref) {
    if (!ref.includes("!")) {
        return { xc: ref };
    }
    const parts = ref.split("!");
    const xc = parts.pop();
    const sheetName = getUnquotedSheetName(parts.join("!")) || undefined;
    return { sheetName, xc };
}
/** Return a reference SheetName!xc from the given arguments */
function getFullReference(sheetName, xc) {
    return sheetName !== undefined ? `${getCanonicalSymbolName(sheetName)}!${xc}` : xc;
}

/**
 * Convert from a cartesian reference to a Zone
 * The range boundaries will be kept in the same order as the
 * ones in the text.
 * Examples:
 *    "A1" ==> Top 0, Bottom 0, Left: 0, Right: 0
 *    "B1:B3" ==> Top 0, Bottom 3, Left: 1, Right: 1
 *    "Sheet1!A1" ==> Top 0, Bottom 0, Left: 0, Right: 0
 *    "Sheet1!B1:B3" ==> Top 0, Bottom 3, Left: 1, Right: 1
 *    "C3:A1" ==> Top 2, Bottom 0, Left 2, Right 0
 *    "A:A" ==> Top 0, Bottom undefined, Left 0, Right 0
 *    "A:B3" or "B3:A" ==> Top 2, Bottom undefined, Left 0, Right 1
 *
 * @param xc the string reference to convert
 *
 */
function toZoneWithoutBoundaryChanges(xc) {
    if (xc.includes("!")) {
        xc = xc.split("!").at(-1);
    }
    if (xc.includes("$")) {
        xc = xc.replaceAll("$", "");
    }
    let firstRangePart = "";
    let secondRangePart;
    if (xc.includes(":")) {
        [firstRangePart, secondRangePart] = xc.split(":");
        firstRangePart = firstRangePart.trim();
        secondRangePart = secondRangePart.trim();
    }
    else {
        firstRangePart = xc.trim();
    }
    let top, bottom, left, right;
    let fullCol = false;
    let fullRow = false;
    let hasHeader = false;
    if (isColReference(firstRangePart)) {
        left = right = lettersToNumber(firstRangePart);
        top = bottom = 0;
        fullCol = true;
    }
    else if (isRowReference(firstRangePart)) {
        top = bottom = parseInt(firstRangePart, 10) - 1;
        left = right = 0;
        fullRow = true;
    }
    else {
        const c = toCartesian(firstRangePart);
        left = right = c.col;
        top = bottom = c.row;
        hasHeader = true;
    }
    if (secondRangePart) {
        if (isColReference(secondRangePart)) {
            right = lettersToNumber(secondRangePart);
            fullCol = true;
        }
        else if (isRowReference(secondRangePart)) {
            bottom = parseInt(secondRangePart, 10) - 1;
            fullRow = true;
        }
        else {
            const c = toCartesian(secondRangePart);
            right = c.col;
            bottom = c.row;
            top = fullCol ? bottom : top;
            left = fullRow ? right : left;
            hasHeader = true;
        }
    }
    if (fullCol && fullRow) {
        throw new Error("Wrong zone xc. The zone cannot be at the same time a full column and a full row");
    }
    const zone = {
        top,
        left,
        bottom: fullCol ? undefined : bottom,
        right: fullRow ? undefined : right,
    };
    hasHeader = hasHeader && (fullRow || fullCol);
    if (hasHeader) {
        zone.hasHeader = hasHeader;
    }
    return zone;
}
/**
 * Convert from a cartesian reference to a (possibly unbounded) Zone
 *
 * Examples:
 *    "A1" ==> Top 0, Bottom 0, Left: 0, Right: 0
 *    "B1:B3" ==> Top 0, Bottom 3, Left: 1, Right: 1
 *    "B:B" ==> Top 0, Bottom undefined, Left: 1, Right: 1
 *    "B2:B" ==> Top 1, Bottom undefined, Left: 1, Right: 1, hasHeader: 1
 *    "Sheet1!A1" ==> Top 0, Bottom 0, Left: 0, Right: 0
 *    "Sheet1!B1:B3" ==> Top 0, Bottom 3, Left: 1, Right: 1
 *
 * @param xc the string reference to convert
 *
 */
function toUnboundedZone(xc) {
    const zone = toZoneWithoutBoundaryChanges(xc);
    return reorderZone(zone);
}
/**
 * Convert from a cartesian reference to a Zone.
 * Will return throw an error if given a unbounded zone (eg : A:A).
 *
 * Examples:
 *    "A1" ==> Top 0, Bottom 0, Left: 0, Right: 0
 *    "B1:B3" ==> Top 0, Bottom 2, Left: 1, Right: 1
 *    "Sheet1!A1" ==> Top 0, Bottom 0, Left: 0, Right: 0
 *    "Sheet1!B1:B3" ==> Top 0, Bottom 2, Left: 1, Right: 1
 *
 * @param xc the string reference to convert
 *
 */
function toZone(xc) {
    const zone = toUnboundedZone(xc);
    if (zone.bottom === undefined || zone.right === undefined) {
        throw new Error("This does not support unbounded ranges");
    }
    return zone;
}
/**
 * Check that the zone has valid coordinates and in
 * the correct order.
 */
function isZoneValid(zone) {
    // Typescript *should* prevent this kind of errors but
    // it's better to be on the safe side at runtime as well.
    const { bottom, top, left, right } = zone;
    if ((bottom !== undefined && isNaN(bottom)) ||
        isNaN(top) ||
        isNaN(left) ||
        (right !== undefined && isNaN(right))) {
        return false;
    }
    return isZoneOrdered(zone) && zone.top >= 0 && zone.left >= 0;
}
/**
 * Check that the zone properties are in the correct order.
 */
function isZoneOrdered(zone) {
    return ((zone.bottom === undefined || (zone.bottom >= zone.top && zone.bottom >= 0)) &&
        (zone.right === undefined || (zone.right >= zone.left && zone.right >= 0)));
}
/**
 * Convert from zone to a cartesian reference
 *
 */
function zoneToXc(zone) {
    const { top, bottom, left, right } = zone;
    const hasHeader = "hasHeader" in zone ? zone.hasHeader : false;
    const isOneCell = top === bottom && left === right;
    if (bottom === undefined && right !== undefined) {
        return top === 0 && !hasHeader
            ? `${numberToLetters(left)}:${numberToLetters(right)}`
            : `${toXC(left, top)}:${numberToLetters(right)}`;
    }
    else if (right === undefined && bottom !== undefined) {
        return left === 0 && !hasHeader
            ? `${top + 1}:${bottom + 1}`
            : `${toXC(left, top)}:${bottom + 1}`;
    }
    else if (bottom !== undefined && right !== undefined) {
        return isOneCell ? toXC(left, top) : `${toXC(left, top)}:${toXC(right, bottom)}`;
    }
    throw new Error(_t("Bad zone format"));
}
/**
 * Expand a zone after inserting columns or rows.
 *
 * Don't resize the zone if a col/row was added right before/after the row but only move the zone.
 */
function expandZoneOnInsertion(zone, start, base, position, quantity) {
    const dimension = start === "left" ? "columns" : "rows";
    const baseElement = position === "before" ? base - 1 : base;
    const end = start === "left" ? "right" : "bottom";
    const zoneEnd = zone[end];
    if (zone[start] <= baseElement && zoneEnd && zoneEnd > baseElement) {
        return createAdaptedZone(zone, dimension, "RESIZE", quantity);
    }
    if (baseElement < zone[start]) {
        return createAdaptedZone(zone, dimension, "MOVE", quantity);
    }
    return { ...zone };
}
/**
 * Update the selection after column/row addition
 */
function updateSelectionOnInsertion(selection, start, base, position, quantity) {
    const dimension = start === "left" ? "columns" : "rows";
    const baseElement = position === "before" ? base - 1 : base;
    const end = start === "left" ? "right" : "bottom";
    if (selection[start] <= baseElement && selection[end] > baseElement) {
        return createAdaptedZone(selection, dimension, "RESIZE", quantity);
    }
    if (baseElement < selection[start]) {
        return createAdaptedZone(selection, dimension, "MOVE", quantity);
    }
    return { ...selection };
}
/**
 * Update the selection after column/row deletion
 */
function updateSelectionOnDeletion(zone, start, elements) {
    const end = start === "left" ? "right" : "bottom";
    let newStart = zone[start];
    let newEnd = zone[end];
    for (let removedElement of elements.sort((a, b) => b - a)) {
        if (zone[start] > removedElement) {
            newStart--;
            newEnd--;
        }
        if (zone[start] < removedElement && zone[end] >= removedElement) {
            newEnd--;
        }
    }
    return { ...zone, [start]: newStart, [end]: newEnd };
}
/**
 * Reduce a zone after deletion of elements
 */
function reduceZoneOnDeletion(zone, start, elements) {
    const end = start === "left" ? "right" : "bottom";
    let newStart = zone[start];
    let newEnd = zone[end];
    const zoneEnd = zone[end];
    for (let removedElement of elements.sort((a, b) => b - a)) {
        if (zone[start] > removedElement) {
            newStart--;
            if (newEnd !== undefined)
                newEnd--;
        }
        if (zoneEnd !== undefined &&
            newEnd !== undefined &&
            zone[start] <= removedElement &&
            zoneEnd >= removedElement) {
            newEnd--;
        }
    }
    if (newEnd !== undefined && newStart > newEnd) {
        return undefined;
    }
    return { ...zone, [start]: newStart, [end]: newEnd };
}
/**
 * Compute the union of multiple zones.
 */
function union(...zones) {
    return {
        top: Math.min(...zones.map((zone) => zone.top)),
        left: Math.min(...zones.map((zone) => zone.left)),
        bottom: Math.max(...zones.map((zone) => zone.bottom)),
        right: Math.max(...zones.map((zone) => zone.right)),
    };
}
/**
 * Compute the union of multiple unbounded zones.
 */
function unionUnboundedZones(...zones) {
    return {
        top: Math.min(...zones.map((zone) => zone.top)),
        left: Math.min(...zones.map((zone) => zone.left)),
        bottom: zones.some((zone) => zone.bottom === undefined)
            ? undefined
            : Math.max(...zones.map((zone) => zone.bottom)),
        right: zones.some((zone) => zone.right === undefined)
            ? undefined
            : Math.max(...zones.map((zone) => zone.right)),
    };
}
/**
 * Compute the intersection of two zones. Returns nothing if the two zones don't overlap
 */
function intersection(z1, z2) {
    if (!overlap(z1, z2)) {
        return undefined;
    }
    return {
        top: Math.max(z1.top, z2.top),
        left: Math.max(z1.left, z2.left),
        bottom: Math.min(z1.bottom, z2.bottom),
        right: Math.min(z1.right, z2.right),
    };
}
/**
 * Two zones are equal if they represent the same area, so we clearly cannot use
 * reference equality.
 */
function isEqual(z1, z2) {
    return (z1.left === z2.left && z1.right === z2.right && z1.top === z2.top && z1.bottom === z2.bottom);
}
/**
 * Return true if two zones overlap, false otherwise.
 */
function overlap(z1, z2) {
    if (z1.bottom < z2.top || z2.bottom < z1.top) {
        return false;
    }
    if (z1.right < z2.left || z2.right < z1.left) {
        return false;
    }
    return true;
}
function isInside(col, row, zone) {
    const { left, right, top, bottom } = zone;
    return col >= left && col <= right && row >= top && row <= bottom;
}
/**
 * Check if a zone is inside another
 */
function isZoneInside(smallZone, biggerZone) {
    return isEqual(union(biggerZone, smallZone), biggerZone);
}
function zoneToDimension(zone) {
    return {
        numberOfRows: zone.bottom - zone.top + 1,
        numberOfCols: zone.right - zone.left + 1,
    };
}
function isOneDimensional(zone) {
    const { numberOfCols, numberOfRows } = zoneToDimension(zone);
    return numberOfCols === 1 || numberOfRows === 1;
}
function excludeTopLeft(zone) {
    const { top, left, bottom, right } = zone;
    if (getZoneArea(zone) === 1) {
        return [];
    }
    const leftColumnZone = {
        top: top + 1,
        bottom,
        left,
        right: left,
    };
    if (right === left) {
        return [leftColumnZone];
    }
    const rightPartZone = {
        top,
        bottom,
        left: left + 1,
        right,
    };
    if (top === bottom) {
        return [rightPartZone];
    }
    return [leftColumnZone, rightPartZone];
}
function aggregatePositionsToZones(positions) {
    const result = {};
    for (const position of positions) {
        result[position.sheetId] ??= [];
        result[position.sheetId].push(positionToZone(position));
    }
    for (const sheetId in result) {
        result[sheetId] = recomputeZones(result[sheetId]);
    }
    return result;
}
/**
 * Array of all positions in the zone.
 */
function positions(zone) {
    const positions = [];
    const { left, right, top, bottom } = reorderZone(zone);
    for (const col of range(left, right + 1)) {
        for (const row of range(top, bottom + 1)) {
            positions.push({ col, row });
        }
    }
    return positions;
}
function reorderZone(zone) {
    if (zone.right !== undefined && zone.left > zone.right) {
        zone = { ...zone, left: zone.right, right: zone.left };
    }
    if (zone.bottom !== undefined && zone.top > zone.bottom) {
        zone = { ...zone, top: zone.bottom, bottom: zone.top };
    }
    return zone;
}
/**
 * This function returns a zone with coordinates modified according to the change
 * applied to the zone. It may be possible to change the zone by resizing or moving
 * it according to different dimensions.
 *
 * @param zone the zone to modify
 * @param dimension the direction to change the zone among "columns", "rows" and
 * "both"
 * @param operation how to change the zone, modify its size "RESIZE" or modify
 * its location "MOVE"
 * @param by a number of how many units the change should be made. This parameter
 * takes the form of a two-number array when the dimension is "both"
 */
function createAdaptedZone(zone, dimension, operation, by) {
    const offsetX = dimension === "both" ? by[0] : dimension === "columns" ? by : 0;
    const offsetY = dimension === "both" ? by[1] : dimension === "rows" ? by : 0;
    // For full columns/rows, we have to make the distinction between the one that have a header and
    // whose start should be moved (eg. A2:A), and those who don't (eg. A:A)
    // The only time we don't want to move the start of the zone is if the zone is a full column (or a full row)
    // without header and that we are adding/removing a row (or a column)
    const hasHeader = "hasHeader" in zone ? zone.hasHeader : false;
    let shouldStartBeMoved;
    if (isFullCol(zone) && !hasHeader) {
        shouldStartBeMoved = dimension !== "rows";
    }
    else if (isFullRow(zone) && !hasHeader) {
        shouldStartBeMoved = dimension !== "columns";
    }
    else {
        shouldStartBeMoved = true;
    }
    const newZone = { ...zone };
    if (shouldStartBeMoved && operation === "MOVE") {
        newZone["left"] += offsetX;
        newZone["top"] += offsetY;
    }
    if (newZone["right"] !== undefined) {
        newZone["right"] += offsetX;
    }
    if (newZone["bottom"] !== undefined) {
        newZone["bottom"] += offsetY;
    }
    return newZone;
}
/**
 * Returns a Zone array with unique occurrence of each zone.
 * For each multiple occurrence, the occurrence with the largest index is kept.
 * This allows to always have the last selection made in the last position.
 * */
function uniqueZones(zones) {
    return zones
        .reverse()
        .filter((zone, index, self) => index ===
        self.findIndex((z) => z.top === zone.top &&
            z.bottom === zone.bottom &&
            z.left === zone.left &&
            z.right === zone.right))
        .reverse();
}
/**
 * This function will find all overlapping zones in an array and transform them
 * into an union of each one.
 * */
function mergeOverlappingZones(zones) {
    return zones.reduce((dissociatedZones, zone) => {
        const nextIndex = dissociatedZones.length;
        for (let i = 0; i < nextIndex; i++) {
            if (overlap(dissociatedZones[i], zone)) {
                dissociatedZones[i] = union(dissociatedZones[i], zone);
                return dissociatedZones;
            }
        }
        dissociatedZones[nextIndex] = zone;
        return dissociatedZones;
    }, []);
}
/**
 * This function will compare the modifications of selection to determine
 * a cell that is part of the new zone and not the previous one.
 */
function findCellInNewZone(oldZone, currentZone) {
    let col, row;
    const { left: oldLeft, right: oldRight, top: oldTop, bottom: oldBottom } = oldZone;
    const { left, right, top, bottom } = currentZone;
    if (left != oldLeft) {
        col = left;
    }
    else if (right != oldRight) {
        col = right;
    }
    else {
        // left and right don't change
        col = left;
    }
    if (top != oldTop) {
        row = top;
    }
    else if (bottom != oldBottom) {
        row = bottom;
    }
    else {
        // top and bottom don't change
        row = top;
    }
    return { col, row };
}
function positionToZone(position) {
    return { left: position.col, right: position.col, top: position.row, bottom: position.row };
}
/** Transform a zone into a zone with only its top-left position */
function zoneToTopLeft(zone) {
    return { ...zone, right: zone.left, bottom: zone.top };
}
function isFullRow(zone) {
    return zone.right === undefined;
}
function isFullCol(zone) {
    return zone.bottom === undefined;
}
/** Returns the area of a zone */
function getZoneArea(zone) {
    return (zone.bottom - zone.top + 1) * (zone.right - zone.left + 1);
}
/**
 * Check if the zones are continuous, ie. if they can be merged into a single zone without
 * including cells outside the zones
 * */
function areZonesContinuous(zones) {
    if (zones.length < 2)
        return true;
    return recomputeZones(zones).length === 1;
}
/** Return all the columns in the given list of zones */
function getZonesCols(zones) {
    const set = new Set();
    for (let zone of recomputeZones(zones)) {
        for (let col of range(zone.left, zone.right + 1)) {
            set.add(col);
        }
    }
    return set;
}
/** Return all the rows in the given list of zones */
function getZonesRows(zones) {
    const set = new Set();
    for (let zone of recomputeZones(zones)) {
        for (let row of range(zone.top, zone.bottom + 1)) {
            set.add(row);
        }
    }
    return set;
}
/**
 * Check if two zones are contiguous, ie. that they share a border
 */
function areZoneContiguous(zone1, zone2) {
    if (zone1.right + 1 === zone2.left || zone1.left === zone2.right + 1) {
        return ((zone1.top <= zone2.bottom && zone1.top >= zone2.top) ||
            (zone2.top <= zone1.bottom && zone2.top >= zone1.top));
    }
    if (zone1.bottom + 1 === zone2.top || zone1.top === zone2.bottom + 1) {
        return ((zone1.left <= zone2.right && zone1.left >= zone2.left) ||
            (zone2.left <= zone1.right && zone2.left >= zone1.left));
    }
    return false;
}
/**
 * Merge contiguous and overlapping zones that are in the array into bigger zones
 */
function mergeContiguousZones(zones) {
    const mergedZones = [...zones];
    let hasMerged = true;
    while (hasMerged) {
        hasMerged = false;
        for (let i = 0; i < mergedZones.length; i++) {
            const zone = mergedZones[i];
            const mergeableZoneIndex = mergedZones.findIndex((z, j) => i !== j && (areZoneContiguous(z, zone) || overlap(z, zone)));
            if (mergeableZoneIndex !== -1) {
                mergedZones[i] = union(mergedZones[mergeableZoneIndex], zone);
                mergedZones.splice(mergeableZoneIndex, 1);
                hasMerged = true;
                break;
            }
        }
    }
    return mergedZones;
}

const globalReverseLookup$1 = new WeakMap();
const globalIdCounter = new WeakMap();
/**
 * Get the id of the given item (its key in the given dictionary).
 * If the given item does not exist in the dictionary, it creates one with a new id.
 */
function getItemId(item, itemsDic) {
    if (!globalReverseLookup$1.has(itemsDic)) {
        globalReverseLookup$1.set(itemsDic, new Map());
        globalIdCounter.set(itemsDic, 0);
    }
    const reverseLookup = globalReverseLookup$1.get(itemsDic);
    const canonical = getCanonicalRepresentation(item);
    if (reverseLookup.has(canonical)) {
        const id = reverseLookup.get(canonical);
        itemsDic[id] = item;
        return id;
    }
    // Generate new Id if the item didn't exist in the dictionary
    const newId = globalIdCounter.get(itemsDic) + 1;
    reverseLookup.set(canonical, newId);
    globalIdCounter.set(itemsDic, newId);
    itemsDic[newId] = item;
    return newId;
}
function groupItemIdsByZones(positionsByItemId) {
    const result = {};
    for (const itemId in positionsByItemId) {
        const zones = recomputeZones(positionsByItemId[itemId].map(positionToZone));
        for (const zone of zones) {
            result[zoneToXc(zone)] = Number(itemId);
        }
    }
    return result;
}
function getCanonicalRepresentation(item) {
    if (item === null)
        return "null";
    if (item === undefined)
        return "undefined";
    if (typeof item !== "object")
        return String(item);
    if (Array.isArray(item)) {
        const len = item.length;
        let result = "[";
        for (let i = 0; i < len; i++) {
            if (i > 0)
                result += ",";
            result += getCanonicalRepresentation(item[i]);
        }
        return result + "]";
    }
    const keys = Object.keys(item).sort();
    let repr = "{";
    for (const key of keys) {
        if (item[key] !== undefined) {
            repr += `"${key}":${getCanonicalRepresentation(item[key])},`;
        }
    }
    repr += "}";
    return repr;
}

// -----------------------------------------------------------------------------
// Date Type
// -----------------------------------------------------------------------------
/**
 * A DateTime object that can be used to manipulate spreadsheet dates.
 * Conceptually, a spreadsheet date is simply a number with a date format,
 * and it is timezone-agnostic.
 * This DateTime object consistently uses UTC time to represent a naive date and time.
 */
class DateTime {
    jsDate;
    constructor(year, month, day, hours = 0, minutes = 0, seconds = 0) {
        this.jsDate = new Date(Date.UTC(year, month, day, hours, minutes, seconds, 0));
    }
    static fromTimestamp(timestamp) {
        const date = new Date(timestamp);
        return new DateTime(date.getUTCFullYear(), date.getUTCMonth(), date.getUTCDate(), date.getUTCHours(), date.getUTCMinutes(), date.getUTCSeconds());
    }
    static now() {
        const now = new Date();
        return new DateTime(now.getFullYear(), now.getMonth(), now.getDate(), now.getHours(), now.getMinutes(), now.getSeconds());
    }
    toString() {
        return this.jsDate.toString();
    }
    toLocaleDateString() {
        return this.jsDate.toLocaleDateString();
    }
    getTime() {
        return this.jsDate.getTime();
    }
    getFullYear() {
        return this.jsDate.getUTCFullYear();
    }
    getMonth() {
        return this.jsDate.getUTCMonth();
    }
    getQuarter() {
        return Math.floor(this.getMonth() / 3) + 1;
    }
    getDate() {
        return this.jsDate.getUTCDate();
    }
    getDay() {
        return this.jsDate.getUTCDay();
    }
    getHours() {
        return this.jsDate.getUTCHours();
    }
    getMinutes() {
        return this.jsDate.getUTCMinutes();
    }
    getSeconds() {
        return this.jsDate.getUTCSeconds();
    }
    getIsoWeek() {
        const date = new Date(this.jsDate.getTime());
        const dayNumber = date.getUTCDay() || 7;
        date.setUTCDate(date.getUTCDate() + 4 - dayNumber);
        const yearStart = new Date(Date.UTC(date.getUTCFullYear(), 0, 1));
        return Math.ceil(((date.getTime() - yearStart.getTime()) / 86400000 + 1) / 7);
    }
    setFullYear(year) {
        return this.jsDate.setUTCFullYear(year);
    }
    setMonth(month) {
        return this.jsDate.setUTCMonth(month);
    }
    setDate(date) {
        return this.jsDate.setUTCDate(date);
    }
    setHours(hours) {
        return this.jsDate.setUTCHours(hours);
    }
    setMinutes(minutes) {
        return this.jsDate.setUTCMinutes(minutes);
    }
    setSeconds(seconds) {
        return this.jsDate.setUTCSeconds(seconds);
    }
}
// -----------------------------------------------------------------------------
// Parsing
// -----------------------------------------------------------------------------
const INITIAL_1900_DAY = new DateTime(1899, 11, 30);
const MS_PER_DAY = 24 * 60 * 60 * 1000;
const CURRENT_MILLENIAL = 2000; // note: don't forget to update this in 2999
const CURRENT_YEAR = DateTime.now().getFullYear();
const CURRENT_MONTH = DateTime.now().getMonth();
const INITIAL_JS_DAY = DateTime.fromTimestamp(0);
const DATE_JS_1900_OFFSET = INITIAL_JS_DAY.getTime() - INITIAL_1900_DAY.getTime();
const mdyDateRegexp = /^\d{1,2}(\/|-|\s)\d{1,2}((\/|-|\s)\d{1,4})?$/;
const ymdDateRegexp = /^\d{3,4}(\/|-|\s)\d{1,2}(\/|-|\s)\d{1,2}$/;
const dateSeparatorsRegex = /\/|-|\s/;
const dateRegexp = /^(\d{1,4})[\/-\s](\d{1,4})([\/-\s](\d{1,4}))?$/;
const timeRegexp = /((\d+(:\d+)?(:\d+)?\s*(AM|PM))|(\d+:\d+(:\d+)?))$/;
/** Convert a value number representing a date, or return undefined if it isn't possible */
function valueToDateNumber(value, locale) {
    switch (typeof value) {
        case "number":
            return value;
        case "string":
            if (isDateTime(value, locale)) {
                return parseDateTime(value, locale)?.value;
            }
            return !value || isNaN(Number(value)) ? undefined : Number(value);
        default:
            return undefined;
    }
}
function isDateTime(str, locale) {
    return parseDateTime(str, locale) !== null;
}
const CACHE = new Map();
function parseDateTime(str, locale) {
    if (!CACHE.has(locale)) {
        CACHE.set(locale, new Map());
    }
    if (!CACHE.get(locale).has(str)) {
        CACHE.get(locale).set(str, _parseDateTime(str, locale));
    }
    return CACHE.get(locale).get(str);
}
function _parseDateTime(str, locale) {
    str = str.trim();
    let time = null;
    const timeMatch = str.match(timeRegexp);
    if (timeMatch) {
        time = parseTime(timeMatch[0]);
        if (time === null) {
            return null;
        }
        str = str.replace(timeMatch[0], "").trim();
    }
    let date = null;
    const dateParts = getDateParts(str, locale);
    if (dateParts) {
        const separator = dateParts.dateString.match(dateSeparatorsRegex)[0];
        date = parseDate(dateParts, separator);
        if (date === null) {
            return null;
        }
        str = str.replace(dateParts.dateString, "").trim();
    }
    if (str !== "" || !(date || time)) {
        return null;
    }
    if (date && date.jsDate && time && time.jsDate) {
        return {
            value: date.value + time.value,
            format: date.format + " " + (time.format === "hhhh:mm:ss" ? "hh:mm:ss" : time.format),
            jsDate: new DateTime(date.jsDate.getFullYear() + time.jsDate.getFullYear() - 1899, date.jsDate.getMonth() + time.jsDate.getMonth() - 11, date.jsDate.getDate() + time.jsDate.getDate() - 30, date.jsDate.getHours() + time.jsDate.getHours(), date.jsDate.getMinutes() + time.jsDate.getMinutes(), date.jsDate.getSeconds() + time.jsDate.getSeconds()),
        };
    }
    return date || time;
}
/**
 * Returns the parts (day/month/year) of a date string corresponding to the given locale.
 *
 * - A string "xxxx-xx-xx" will be parsed as "y-m-d" no matter the locale.
 * - A string "xx-xx-xxxx" will be parsed as "m-d-y" for mdy locale, and "d-m-y" for ymd and dmy locales.
 * - A string "xx-xx-xx" will be "y-m-d" for ymd locale, "d-m-y" for dmy locale, "m-d-y" for mdy locale.
 * - A string "xxxx-xx" will be parsed as "y-m" no matter the locale.
 * - A string "xx-xx" will be parsed as "m-d" for mdy and ymd locales, and "d-m" for dmy locale.
 */
function getDateParts(dateString, locale) {
    const match = dateString.match(dateRegexp);
    if (!match) {
        return null;
    }
    const [, part1, part2, , part3] = match;
    if (part1.length > 2 && part3 && part3.length > 2) {
        return null;
    }
    if (part1.length > 2) {
        return { year: part1, month: part2, day: part3, dateString, type: "ymd" };
    }
    const localeDateType = getLocaleDateFormatType(locale);
    if (!part3) {
        if (part2.length > 2) {
            // e.g. 11/2023
            return { month: part1, year: part2, day: undefined, dateString, type: localeDateType };
        }
        if (localeDateType === "dmy") {
            return { day: part1, month: part2, year: part3, dateString, type: "dmy" };
        }
        return { month: part1, day: part2, year: part3, dateString, type: "mdy" };
    }
    if (part3.length > 2) {
        if (localeDateType === "mdy") {
            return { month: part1, day: part2, year: part3, dateString, type: "mdy" };
        }
        return { day: part1, month: part2, year: part3, dateString, type: "dmy" };
    }
    if (localeDateType === "mdy") {
        return { month: part1, day: part2, year: part3, dateString, type: "mdy" };
    }
    if (localeDateType === "ymd") {
        return { year: part1, month: part2, day: part3, dateString, type: "ymd" };
    }
    if (localeDateType === "dmy") {
        return { day: part1, month: part2, year: part3, dateString, type: "dmy" };
    }
    return null;
}
function getLocaleDateFormatType(locale) {
    switch (locale.dateFormat[0]) {
        case "d":
            return "dmy";
        case "m":
            return "mdy";
        case "y":
            return "ymd";
    }
    throw new Error("Invalid date format in locale");
}
function parseDate(parts, separator) {
    let { year: yearStr, month: monthStr, day: dayStr } = parts;
    const month = inferMonth(monthStr);
    const day = inferDay(dayStr);
    const year = inferYear(yearStr);
    if (year === null || month === null || day === null) {
        return null;
    }
    // month + 1: months are 0-indexed in JS
    const leadingZero = (monthStr?.length === 2 && month + 1 < 10) || (dayStr?.length === 2 && day < 10);
    const fullYear = yearStr?.length !== 2;
    const jsDate = new DateTime(year, month, day);
    if (jsDate.getMonth() !== month || jsDate.getDate() !== day) {
        // invalid date
        return null;
    }
    const delta = jsDate.getTime() - INITIAL_1900_DAY.getTime();
    const format = getFormatFromDateParts(parts, separator, leadingZero, fullYear);
    return {
        value: Math.round(delta / MS_PER_DAY),
        format: format,
        jsDate,
    };
}
function getFormatFromDateParts(parts, sep, leadingZero, fullYear) {
    const yearFmt = parts.year ? (fullYear ? "yyyy" : "yy") : undefined;
    const monthFmt = parts.month ? (leadingZero ? "mm" : "m") : undefined;
    const dayFmt = parts.day ? (leadingZero ? "dd" : "d") : undefined;
    switch (parts.type) {
        case "mdy":
            return [monthFmt, dayFmt, yearFmt].filter(isDefined).join(sep);
        case "ymd":
            return [yearFmt, monthFmt, dayFmt].filter(isDefined).join(sep);
        case "dmy":
            return [dayFmt, monthFmt, yearFmt].filter(isDefined).join(sep);
    }
}
function inferYear(yearStr) {
    if (!yearStr) {
        return CURRENT_YEAR;
    }
    const nbr = Number(yearStr);
    switch (yearStr.length) {
        case 1:
            return CURRENT_MILLENIAL + nbr;
        case 2:
            const offset = CURRENT_MILLENIAL + nbr > CURRENT_YEAR + 10 ? -100 : 0;
            const base = CURRENT_MILLENIAL + offset;
            return base + nbr;
        case 3:
        case 4:
            return nbr;
    }
    return null;
}
function inferMonth(monthStr) {
    if (!monthStr) {
        return CURRENT_MONTH;
    }
    const nbr = Number(monthStr);
    if (nbr >= 1 && nbr <= 12) {
        return nbr - 1;
    }
    return null;
}
function inferDay(dayStr) {
    if (!dayStr) {
        return 1;
    }
    const nbr = Number(dayStr);
    if (nbr >= 0 && nbr <= 31) {
        return nbr;
    }
    return null;
}
function parseTime(str) {
    str = str.trim();
    if (timeRegexp.test(str)) {
        const isAM = /AM/i.test(str);
        const isPM = /PM/i.test(str);
        const strTime = isAM || isPM ? str.substring(0, str.length - 2).trim() : str;
        const parts = strTime.split(/:/);
        const isMinutes = parts.length >= 2;
        const isSeconds = parts.length === 3;
        let hours = Number(parts[0]);
        let minutes = isMinutes ? Number(parts[1]) : 0;
        let seconds = isSeconds ? Number(parts[2]) : 0;
        let format = isSeconds ? "hh:mm:ss" : "hh:mm";
        if (isAM || isPM) {
            format += " a";
        }
        else if (!isMinutes) {
            return null;
        }
        if (hours >= 12 && isAM) {
            hours -= 12;
        }
        else if (hours < 12 && isPM) {
            hours += 12;
        }
        minutes += Math.floor(seconds / 60);
        seconds %= 60;
        hours += Math.floor(minutes / 60);
        minutes %= 60;
        if (hours >= 24) {
            format = "hhhh:mm:ss";
        }
        const jsDate = new DateTime(1899, 11, 30, hours, minutes, seconds);
        return {
            value: hours / 24 + minutes / 1440 + seconds / 86400,
            format: format,
            jsDate: jsDate,
        };
    }
    return null;
}
// -----------------------------------------------------------------------------
// Conversion
// -----------------------------------------------------------------------------
function numberToJsDate(value) {
    const truncValue = Math.trunc(value);
    let date = DateTime.fromTimestamp(truncValue * MS_PER_DAY - DATE_JS_1900_OFFSET);
    let time = value - truncValue;
    time = time < 0 ? 1 + time : time;
    const hours = Math.round(time * 24);
    const minutes = Math.round((time - hours / 24) * 24 * 60);
    const seconds = Math.round((time - hours / 24 - minutes / 24 / 60) * 24 * 60 * 60);
    date.setHours(hours);
    date.setMinutes(minutes);
    date.setSeconds(seconds);
    return date;
}
function jsDateToRoundNumber(date) {
    return Math.round(jsDateToNumber(date));
}
function jsDateToNumber(date) {
    const delta = date.getTime() - INITIAL_1900_DAY.getTime();
    return delta / MS_PER_DAY;
}
/** Return the number of days in the current month of the given date */
function getDaysInMonth(date) {
    return new DateTime(date.getFullYear(), date.getMonth() + 1, 0).getDate();
}
function isLastDayOfMonth(date) {
    return getDaysInMonth(date) === date.getDate();
}
/**
 * Add a certain number of months to a date. This will adapt the month number, and possibly adapt
 * the day of the month to keep it in the month.
 *
 * For example "31/12/2020" minus one month will be "30/11/2020", and not "31/11/2020"
 *
 * @param keepEndOfMonth if true, if the given date was the last day of a month, the returned date will
 *          also always be the last day of a month.
 */
function addMonthsToDate(date, months, keepEndOfMonth) {
    const yStart = date.getFullYear();
    const mStart = date.getMonth();
    const dStart = date.getDate();
    const jsDate = new DateTime(yStart, mStart + months, 1);
    if (keepEndOfMonth && dStart === getDaysInMonth(date)) {
        jsDate.setDate(getDaysInMonth(jsDate));
    }
    else if (dStart > getDaysInMonth(jsDate)) {
        // 31/03 minus one month should be 28/02, not 31/02
        jsDate.setDate(getDaysInMonth(jsDate));
    }
    else {
        jsDate.setDate(dStart);
    }
    return jsDate;
}
function isLeapYear(year) {
    const _year = Math.trunc(year);
    return (_year % 4 === 0 && _year % 100 != 0) || _year % 400 === 0;
}
function getYearFrac(startDate, endDate, _dayCountConvention) {
    if (startDate === endDate) {
        return 0;
    }
    if (startDate > endDate) {
        const stack = endDate;
        endDate = startDate;
        startDate = stack;
    }
    const jsStartDate = numberToJsDate(startDate);
    const jsEndDate = numberToJsDate(endDate);
    let dayStart = jsStartDate.getDate();
    let dayEnd = jsEndDate.getDate();
    const monthStart = jsStartDate.getMonth(); // january is 0
    const monthEnd = jsEndDate.getMonth(); // january is 0
    const yearStart = jsStartDate.getFullYear();
    const yearEnd = jsEndDate.getFullYear();
    let yearsStart = 0;
    let yearsEnd = 0;
    switch (_dayCountConvention) {
        // 30/360 US convention --------------------------------------------------
        case 0:
            if (dayStart === 31)
                dayStart = 30;
            if (dayStart === 30 && dayEnd === 31)
                dayEnd = 30;
            // If jsStartDate is the last day of February
            if (monthStart === 1 && dayStart === (isLeapYear(yearStart) ? 29 : 28)) {
                dayStart = 30;
                // If jsEndDate is the last day of February
                if (monthEnd === 1 && dayEnd === (isLeapYear(yearEnd) ? 29 : 28)) {
                    dayEnd = 30;
                }
            }
            yearsStart = yearStart + (monthStart * 30 + dayStart) / 360;
            yearsEnd = yearEnd + (monthEnd * 30 + dayEnd) / 360;
            break;
        // actual/actual convention ----------------------------------------------
        case 1:
            let daysInYear = 365;
            const isSameYear = yearStart === yearEnd;
            const isOneDeltaYear = yearStart + 1 === yearEnd;
            const isMonthEndBigger = monthStart < monthEnd;
            const isSameMonth = monthStart === monthEnd;
            const isDayEndBigger = dayStart < dayEnd;
            // |-----|  <-- one Year
            // 'A' is start date
            // 'B' is end date
            if ((!isSameYear && !isOneDeltaYear) ||
                (!isSameYear && isMonthEndBigger) ||
                (!isSameYear && isSameMonth && isDayEndBigger)) {
                // |---A-|-----|-B---|  <-- !isSameYear && !isOneDeltaYear
                // |---A-|----B|-----|  <-- !isSameYear && isMonthEndBigger
                // |---A-|---B-|-----|  <-- !isSameYear && isSameMonth && isDayEndBigger
                let countYears = 0;
                let countDaysInYears = 0;
                for (let y = yearStart; y <= yearEnd; y++) {
                    countYears++;
                    countDaysInYears += isLeapYear(y) ? 366 : 365;
                }
                daysInYear = countDaysInYears / countYears;
            }
            else if (!isSameYear) {
                // |-AF--|B----|-----|
                if (isLeapYear(yearStart) && monthStart < 2) {
                    daysInYear = 366;
                }
                // |--A--|FB---|-----|
                if (isLeapYear(yearEnd) && (monthEnd > 1 || (monthEnd === 1 && dayEnd === 29))) {
                    daysInYear = 366;
                }
            }
            else {
                // remaining cases:
                //
                // |-F-AB|-----|-----|
                // |AB-F-|-----|-----|
                // |A-F-B|-----|-----|
                // if February 29 occurs between date1 (exclusive) and date2 (inclusive)
                // daysInYear --> 366
                if (isLeapYear(yearStart)) {
                    daysInYear = 366;
                }
            }
            yearsStart = startDate / daysInYear;
            yearsEnd = endDate / daysInYear;
            break;
        // actual/360 convention -------------------------------------------------
        case 2:
            yearsStart = startDate / 360;
            yearsEnd = endDate / 360;
            break;
        // actual/365 convention -------------------------------------------------
        case 3:
            yearsStart = startDate / 365;
            yearsEnd = endDate / 365;
            break;
        // 30/360 European convention --------------------------------------------
        case 4:
            if (dayStart === 31)
                dayStart = 30;
            if (dayEnd === 31)
                dayEnd = 30;
            yearsStart = yearStart + (monthStart * 30 + dayStart) / 360;
            yearsEnd = yearEnd + (monthEnd * 30 + dayEnd) / 360;
            break;
    }
    return yearsEnd - yearsStart;
}
/**
 * Get the number of whole months between two dates.
 * e.g.
 *  2002/01/01 -> 2002/02/01 = 1 month,
 *  2002/01/01 -> 2003/02/01 = 13 months
 * @param startDate
 * @param endDate
 * @returns
 */
function getTimeDifferenceInWholeMonths(startDate, endDate) {
    const months = (endDate.getFullYear() - startDate.getFullYear()) * 12 +
        endDate.getMonth() -
        startDate.getMonth();
    return startDate.getDate() > endDate.getDate() ? months - 1 : months;
}
function getTimeDifferenceInWholeDays(startDate, endDate) {
    const startUtc = startDate.getTime();
    const endUtc = endDate.getTime();
    return Math.floor((endUtc - startUtc) / MS_PER_DAY);
}
function getTimeDifferenceInWholeYears(startDate, endDate) {
    const years = endDate.getFullYear() - startDate.getFullYear();
    const monthStart = startDate.getMonth();
    const monthEnd = endDate.getMonth();
    const dateStart = startDate.getDate();
    const dateEnd = endDate.getDate();
    const isEndMonthDateBigger = monthEnd > monthStart || (monthEnd === monthStart && dateEnd >= dateStart);
    return isEndMonthDateBigger ? years : years - 1;
}
function areTwoDatesWithinOneYear(startDate, endDate) {
    return getYearFrac(startDate, endDate, 1) < 1;
}
function areDatesSameDay(startDate, endDate) {
    return Math.trunc(startDate) === Math.trunc(endDate);
}
function isDateBetween(date, startDate, endDate) {
    if (startDate > endDate) {
        return isDateBetween(date, endDate, startDate);
    }
    date = Math.trunc(date);
    startDate = Math.trunc(startDate);
    endDate = Math.trunc(endDate);
    return date >= startDate && date <= endDate;
}
/** Check if the first date is strictly before the second date */
function isDateStrictlyBefore(date, dateBefore) {
    return Math.trunc(date) < Math.trunc(dateBefore);
}
/** Check if the first date is before or equal to the second date */
function isDateBefore(date, dateBefore) {
    return Math.trunc(date) <= Math.trunc(dateBefore);
}
/** Check if the first date is strictly after the second date */
function isDateStrictlyAfter(date, dateAfter) {
    return Math.trunc(date) > Math.trunc(dateAfter);
}
/** Check if the first date is after or equal to the second date */
function isDateAfter(date, dateAfter) {
    return Math.trunc(date) >= Math.trunc(dateAfter);
}

/**
 * This function returns a regexp that is supposed to be as close as possible as the numberRegexp,
 * but its purpose is to be used by the tokenizer.
 *
 * - it tolerates extra characters at the end. This is useful because the tokenizer
 *   only needs to find the number at the start of a string
 * - it does not support % symbol, in formulas % is an operator
 */
const getFormulaNumberRegex = memoize(function getFormulaNumberRegex(decimalSeparator) {
    decimalSeparator = escapeRegExp(decimalSeparator);
    return new RegExp(`(?:^-?\\d+(?:${decimalSeparator}?\\d*(?:e\\d+)?)?|^-?${decimalSeparator}\\d+)(?!\\w|!)`);
});
const getNumberRegex = memoize(function getNumberRegex(locale) {
    const decimalSeparator = escapeRegExp(locale.decimalSeparator);
    const thousandsSeparator = escapeRegExp(locale.thousandsSeparator || "");
    const pIntegerAndDecimals = `(?:\\d+(?:${thousandsSeparator}\\d{3,})*(?:${decimalSeparator}\\d*)?)`; // pattern that match integer number with or without decimal digits
    const pOnlyDecimals = `(?:${decimalSeparator}\\d+)`; // pattern that match only expression with decimal digits
    const pScientificFormat = "(?:e(?:\\+|-)?\\d+)?"; // pattern that match scientific format between zero and one time (should be placed before pPercentFormat)
    const pPercentFormat = "(?:\\s*%)?"; // pattern that match percent symbol between zero and one time
    const pNumber = "(?:\\s*" +
        pIntegerAndDecimals +
        "|" +
        pOnlyDecimals +
        ")" +
        pScientificFormat +
        pPercentFormat;
    const pMinus = "(?:\\s*-)?"; // pattern that match negative symbol between zero and one time
    const pCurrencyFormat = "(?:\\s*[\\$€])?";
    const p1 = pMinus + pCurrencyFormat + pNumber;
    const p2 = pMinus + pNumber + pCurrencyFormat;
    const p3 = pCurrencyFormat + pMinus + pNumber;
    const pNumberExp = "^(?:(?:" + [p1, p2, p3].join(")|(?:") + "))$";
    const numberRegexp = new RegExp(pNumberExp, "i");
    return numberRegexp;
});
/**
 * Return true if the argument is a "number string".
 *
 * Note that "" (empty string) does not count as a number string
 */
function isNumber(value, locale) {
    if (!value)
        return false;
    // TO DO: add regexp for DATE string format (ex match: "28 02 2020")
    return getNumberRegex(locale).test(value.trim());
}
const getInvaluableSymbolsRegexp = memoize(function getInvaluableSymbolsRegexp(locale) {
    return new RegExp(`[\$€${escapeRegExp(locale.thousandsSeparator || "")}]`, "g");
});
/**
 * Convert a string into a number. It assumes that the string actually represents
 * a number (as determined by the isNumber function)
 *
 * Note that it accepts "" (empty string), even though it does not count as a
 * number from the point of view of the isNumber function.
 */
function parseNumber(str, locale) {
    // remove invaluable characters
    str = str.replace(getInvaluableSymbolsRegexp(locale), "");
    if (locale.decimalSeparator !== ".") {
        str = str.replace(locale.decimalSeparator, ".");
    }
    let n = Number(str);
    if (isNaN(n) && str.includes("%")) {
        n = Number(str.split("%")[0]);
        if (!isNaN(n)) {
            return n / 100;
        }
    }
    return n;
}
function percentile(values, percent, isInclusive) {
    const sortedValues = [...values].sort((a, b) => a - b);
    let percentIndex = (sortedValues.length + (isInclusive ? -1 : 1)) * percent;
    if (!isInclusive) {
        percentIndex--;
    }
    if (Number.isInteger(percentIndex)) {
        return sortedValues[percentIndex];
    }
    const indexSup = Math.ceil(percentIndex);
    const indexLow = Math.floor(percentIndex);
    return (sortedValues[indexSup] * (percentIndex - indexLow) +
        sortedValues[indexLow] * (indexSup - percentIndex));
}

var CellValueType;
(function (CellValueType) {
    CellValueType["boolean"] = "boolean";
    CellValueType["number"] = "number";
    CellValueType["text"] = "text";
    CellValueType["empty"] = "empty";
    CellValueType["error"] = "error";
})(CellValueType || (CellValueType = {}));

var ClipboardMIMEType;
(function (ClipboardMIMEType) {
    ClipboardMIMEType["PlainText"] = "text/plain";
    ClipboardMIMEType["Html"] = "text/html";
})(ClipboardMIMEType || (ClipboardMIMEType = {}));

function isSheetDependent(cmd) {
    return "sheetId" in cmd;
}
function isHeadersDependant(cmd) {
    return "dimension" in cmd && "sheetId" in cmd && "elements" in cmd;
}
function isTargetDependent(cmd) {
    return "target" in cmd && "sheetId" in cmd;
}
function isRangeDependant(cmd) {
    return "ranges" in cmd;
}
function isPositionDependent(cmd) {
    return "col" in cmd && "row" in cmd && "sheetId" in cmd;
}
function isZoneDependent(cmd) {
    return "sheetId" in cmd && "zone" in cmd;
}
const invalidateEvaluationCommands = new Set([
    "RENAME_SHEET",
    "DELETE_SHEET",
    "CREATE_SHEET",
    "DUPLICATE_SHEET",
    "ADD_COLUMNS_ROWS",
    "REMOVE_COLUMNS_ROWS",
    "UNDO",
    "REDO",
    "ADD_MERGE",
    "REMOVE_MERGE",
    "DUPLICATE_SHEET",
    "UPDATE_LOCALE",
    "ADD_PIVOT",
    "UPDATE_PIVOT",
    "INSERT_PIVOT",
    "RENAME_PIVOT",
    "REMOVE_PIVOT",
    "DUPLICATE_PIVOT",
]);
const invalidateChartEvaluationCommands = new Set([
    "EVALUATE_CELLS",
    "UPDATE_CELL",
    "UNHIDE_COLUMNS_ROWS",
    "HIDE_COLUMNS_ROWS",
    "GROUP_HEADERS",
    "UNGROUP_HEADERS",
    "FOLD_ALL_HEADER_GROUPS",
    "FOLD_HEADER_GROUP",
    "FOLD_HEADER_GROUPS_IN_ZONE",
    "UNFOLD_ALL_HEADER_GROUPS",
    "UNFOLD_HEADER_GROUP",
    "UNFOLD_HEADER_GROUPS_IN_ZONE",
    "UPDATE_TABLE",
    "UPDATE_FILTER",
    "UNDO",
    "REDO",
]);
const invalidateDependenciesCommands = new Set(["MOVE_RANGES"]);
const invalidateCFEvaluationCommands = new Set([
    "EVALUATE_CELLS",
    "ADD_CONDITIONAL_FORMAT",
    "REMOVE_CONDITIONAL_FORMAT",
    "CHANGE_CONDITIONAL_FORMAT_PRIORITY",
]);
const invalidateBordersCommands = new Set([
    "AUTOFILL_CELL",
    "SET_BORDER",
    "SET_ZONE_BORDERS",
]);
const readonlyAllowedCommands = new Set([
    "START",
    "ACTIVATE_SHEET",
    "COPY",
    "RESIZE_SHEETVIEW",
    "SET_VIEWPORT_OFFSET",
    "EVALUATE_CELLS",
    "SET_FORMULA_VISIBILITY",
    "UPDATE_FILTER",
]);
const coreTypes = new Set([
    /** CELLS */
    "UPDATE_CELL",
    "UPDATE_CELL_POSITION",
    "CLEAR_CELL",
    "CLEAR_CELLS",
    "DELETE_CONTENT",
    /** GRID SHAPE */
    "ADD_COLUMNS_ROWS",
    "REMOVE_COLUMNS_ROWS",
    "RESIZE_COLUMNS_ROWS",
    "HIDE_COLUMNS_ROWS",
    "UNHIDE_COLUMNS_ROWS",
    "SET_GRID_LINES_VISIBILITY",
    "UNFREEZE_COLUMNS",
    "UNFREEZE_ROWS",
    "FREEZE_COLUMNS",
    "FREEZE_ROWS",
    "UNFREEZE_COLUMNS_ROWS",
    /** MERGE */
    "ADD_MERGE",
    "REMOVE_MERGE",
    /** SHEETS MANIPULATION */
    "CREATE_SHEET",
    "DELETE_SHEET",
    "DUPLICATE_SHEET",
    "MOVE_SHEET",
    "RENAME_SHEET",
    "COLOR_SHEET",
    "HIDE_SHEET",
    "SHOW_SHEET",
    /** RANGES MANIPULATION */
    "MOVE_RANGES",
    /** CONDITIONAL FORMAT */
    "ADD_CONDITIONAL_FORMAT",
    "REMOVE_CONDITIONAL_FORMAT",
    "CHANGE_CONDITIONAL_FORMAT_PRIORITY",
    /** FIGURES */
    "CREATE_FIGURE",
    "DELETE_FIGURE",
    "UPDATE_FIGURE",
    /** FORMATTING */
    "SET_FORMATTING",
    "CLEAR_FORMATTING",
    "SET_BORDER",
    "SET_ZONE_BORDERS",
    /** CHART */
    "CREATE_CHART",
    "UPDATE_CHART",
    /** FILTERS */
    "CREATE_TABLE",
    "REMOVE_TABLE",
    "UPDATE_TABLE",
    "CREATE_TABLE_STYLE",
    "REMOVE_TABLE_STYLE",
    /** IMAGE */
    "CREATE_IMAGE",
    /** HEADER GROUP */
    "GROUP_HEADERS",
    "UNGROUP_HEADERS",
    "UNFOLD_HEADER_GROUP",
    "FOLD_HEADER_GROUP",
    "FOLD_ALL_HEADER_GROUPS",
    "UNFOLD_ALL_HEADER_GROUPS",
    "UNFOLD_HEADER_GROUPS_IN_ZONE",
    "FOLD_HEADER_GROUPS_IN_ZONE",
    /** DATA VALIDATION */
    "ADD_DATA_VALIDATION_RULE",
    "REMOVE_DATA_VALIDATION_RULE",
    /** MISC */
    "UPDATE_LOCALE",
    /** PIVOT */
    "ADD_PIVOT",
    "UPDATE_PIVOT",
    "INSERT_PIVOT",
    "RENAME_PIVOT",
    "REMOVE_PIVOT",
    "DUPLICATE_PIVOT",
]);
function isCoreCommand(cmd) {
    return coreTypes.has(cmd.type);
}
function canExecuteInReadonly(cmd) {
    return readonlyAllowedCommands.has(cmd.type);
}
/**
 * Holds the result of a command dispatch.
 * The command may have been successfully dispatched or cancelled
 * for one or more reasons.
 */
class DispatchResult {
    reasons;
    constructor(results = []) {
        if (!Array.isArray(results)) {
            results = [results];
        }
        results = [...new Set(results)];
        this.reasons = results.filter((result) => result !== "Success" /* CommandResult.Success */);
    }
    /**
     * Static helper which returns a successful DispatchResult
     */
    static get Success() {
        return SUCCESS;
    }
    get isSuccessful() {
        return this.reasons.length === 0;
    }
    /**
     * Check if the dispatch has been cancelled because of
     * the given reason.
     */
    isCancelledBecause(reason) {
        return this.reasons.includes(reason);
    }
}
const SUCCESS = new DispatchResult();
var CommandResult;
(function (CommandResult) {
    CommandResult["Success"] = "Success";
    CommandResult["CancelledForUnknownReason"] = "CancelledForUnknownReason";
    CommandResult["WillRemoveExistingMerge"] = "WillRemoveExistingMerge";
    CommandResult["MergeIsDestructive"] = "MergeIsDestructive";
    CommandResult["CellIsMerged"] = "CellIsMerged";
    CommandResult["InvalidTarget"] = "InvalidTarget";
    CommandResult["EmptyUndoStack"] = "EmptyUndoStack";
    CommandResult["EmptyRedoStack"] = "EmptyRedoStack";
    CommandResult["NotEnoughElements"] = "NotEnoughElements";
    CommandResult["NotEnoughSheets"] = "NotEnoughSheets";
    CommandResult["MissingSheetName"] = "MissingSheetName";
    CommandResult["UnchangedSheetName"] = "UnchangedSheetName";
    CommandResult["DuplicatedSheetName"] = "DuplicatedSheetName";
    CommandResult["DuplicatedSheetId"] = "DuplicatedSheetId";
    CommandResult["ForbiddenCharactersInSheetName"] = "ForbiddenCharactersInSheetName";
    CommandResult["WrongSheetMove"] = "WrongSheetMove";
    CommandResult["WrongSheetPosition"] = "WrongSheetPosition";
    CommandResult["InvalidAnchorZone"] = "InvalidAnchorZone";
    CommandResult["SelectionOutOfBound"] = "SelectionOutOfBound";
    CommandResult["TargetOutOfSheet"] = "TargetOutOfSheet";
    CommandResult["WrongCutSelection"] = "WrongCutSelection";
    CommandResult["WrongPasteSelection"] = "WrongPasteSelection";
    CommandResult["WrongPasteOption"] = "WrongPasteOption";
    CommandResult["WrongFigurePasteOption"] = "WrongFigurePasteOption";
    CommandResult["EmptyClipboard"] = "EmptyClipboard";
    CommandResult["EmptyRange"] = "EmptyRange";
    CommandResult["InvalidRange"] = "InvalidRange";
    CommandResult["InvalidZones"] = "InvalidZones";
    CommandResult["InvalidSheetId"] = "InvalidSheetId";
    CommandResult["InvalidCellId"] = "InvalidCellId";
    CommandResult["InvalidFigureId"] = "InvalidFigureId";
    CommandResult["InputAlreadyFocused"] = "InputAlreadyFocused";
    CommandResult["MaximumRangesReached"] = "MaximumRangesReached";
    CommandResult["MinimumRangesReached"] = "MinimumRangesReached";
    CommandResult["InvalidChartDefinition"] = "InvalidChartDefinition";
    CommandResult["InvalidDataSet"] = "InvalidDataSet";
    CommandResult["InvalidLabelRange"] = "InvalidLabelRange";
    CommandResult["InvalidScorecardKeyValue"] = "InvalidScorecardKeyValue";
    CommandResult["InvalidScorecardBaseline"] = "InvalidScorecardBaseline";
    CommandResult["InvalidGaugeDataRange"] = "InvalidGaugeDataRange";
    CommandResult["EmptyGaugeRangeMin"] = "EmptyGaugeRangeMin";
    CommandResult["GaugeRangeMinNaN"] = "GaugeRangeMinNaN";
    CommandResult["EmptyGaugeRangeMax"] = "EmptyGaugeRangeMax";
    CommandResult["GaugeRangeMaxNaN"] = "GaugeRangeMaxNaN";
    CommandResult["GaugeRangeMinBiggerThanRangeMax"] = "GaugeRangeMinBiggerThanRangeMax";
    CommandResult["GaugeLowerInflectionPointNaN"] = "GaugeLowerInflectionPointNaN";
    CommandResult["GaugeUpperInflectionPointNaN"] = "GaugeUpperInflectionPointNaN";
    CommandResult["GaugeLowerBiggerThanUpper"] = "GaugeLowerBiggerThanUpper";
    CommandResult["InvalidAutofillSelection"] = "InvalidAutofillSelection";
    CommandResult["MinBiggerThanMax"] = "MinBiggerThanMax";
    CommandResult["LowerBiggerThanUpper"] = "LowerBiggerThanUpper";
    CommandResult["MidBiggerThanMax"] = "MidBiggerThanMax";
    CommandResult["MinBiggerThanMid"] = "MinBiggerThanMid";
    CommandResult["FirstArgMissing"] = "FirstArgMissing";
    CommandResult["SecondArgMissing"] = "SecondArgMissing";
    CommandResult["MinNaN"] = "MinNaN";
    CommandResult["MidNaN"] = "MidNaN";
    CommandResult["MaxNaN"] = "MaxNaN";
    CommandResult["ValueUpperInflectionNaN"] = "ValueUpperInflectionNaN";
    CommandResult["ValueLowerInflectionNaN"] = "ValueLowerInflectionNaN";
    CommandResult["MinInvalidFormula"] = "MinInvalidFormula";
    CommandResult["MidInvalidFormula"] = "MidInvalidFormula";
    CommandResult["MaxInvalidFormula"] = "MaxInvalidFormula";
    CommandResult["ValueUpperInvalidFormula"] = "ValueUpperInvalidFormula";
    CommandResult["ValueLowerInvalidFormula"] = "ValueLowerInvalidFormula";
    CommandResult["InvalidSortZone"] = "InvalidSortZone";
    CommandResult["WaitingSessionConfirmation"] = "WaitingSessionConfirmation";
    CommandResult["MergeOverlap"] = "MergeOverlap";
    CommandResult["TooManyHiddenElements"] = "TooManyHiddenElements";
    CommandResult["Readonly"] = "Readonly";
    CommandResult["InvalidViewportSize"] = "InvalidViewportSize";
    CommandResult["InvalidScrollingDirection"] = "InvalidScrollingDirection";
    CommandResult["ViewportScrollLimitsReached"] = "ViewportScrollLimitsReached";
    CommandResult["FigureDoesNotExist"] = "FigureDoesNotExist";
    CommandResult["InvalidConditionalFormatId"] = "InvalidConditionalFormatId";
    CommandResult["InvalidCellPopover"] = "InvalidCellPopover";
    CommandResult["EmptyTarget"] = "EmptyTarget";
    CommandResult["InvalidFreezeQuantity"] = "InvalidFreezeQuantity";
    CommandResult["FrozenPaneOverlap"] = "FrozenPaneOverlap";
    CommandResult["ValuesNotChanged"] = "ValuesNotChanged";
    CommandResult["InvalidFilterZone"] = "InvalidFilterZone";
    CommandResult["TableNotFound"] = "TableNotFound";
    CommandResult["TableOverlap"] = "TableOverlap";
    CommandResult["InvalidTableConfig"] = "InvalidTableConfig";
    CommandResult["InvalidTableStyle"] = "InvalidTableStyle";
    CommandResult["FilterNotFound"] = "FilterNotFound";
    CommandResult["MergeInTable"] = "MergeInTable";
    CommandResult["NonContinuousTargets"] = "NonContinuousTargets";
    CommandResult["DuplicatedFigureId"] = "DuplicatedFigureId";
    CommandResult["InvalidSelectionStep"] = "InvalidSelectionStep";
    CommandResult["DuplicatedChartId"] = "DuplicatedChartId";
    CommandResult["ChartDoesNotExist"] = "ChartDoesNotExist";
    CommandResult["InvalidHeaderIndex"] = "InvalidHeaderIndex";
    CommandResult["InvalidQuantity"] = "InvalidQuantity";
    CommandResult["MoreThanOneColumnSelected"] = "MoreThanOneColumnSelected";
    CommandResult["EmptySplitSeparator"] = "EmptySplitSeparator";
    CommandResult["SplitWillOverwriteContent"] = "SplitWillOverwriteContent";
    CommandResult["NoSplitSeparatorInSelection"] = "NoSplitSeparatorInSelection";
    CommandResult["NoActiveSheet"] = "NoActiveSheet";
    CommandResult["InvalidLocale"] = "InvalidLocale";
    CommandResult["MoreThanOneRangeSelected"] = "MoreThanOneRangeSelected";
    CommandResult["NoColumnsProvided"] = "NoColumnsProvided";
    CommandResult["ColumnsNotIncludedInZone"] = "ColumnsNotIncludedInZone";
    CommandResult["DuplicatesColumnsSelected"] = "DuplicatesColumnsSelected";
    CommandResult["InvalidHeaderGroupStartEnd"] = "InvalidHeaderGroupStartEnd";
    CommandResult["HeaderGroupAlreadyExists"] = "HeaderGroupAlreadyExists";
    CommandResult["UnknownHeaderGroup"] = "UnknownHeaderGroup";
    CommandResult["UnknownDataValidationRule"] = "UnknownDataValidationRule";
    CommandResult["UnknownDataValidationCriterionType"] = "UnknownDataValidationCriterionType";
    CommandResult["InvalidDataValidationCriterionValue"] = "InvalidDataValidationCriterionValue";
    CommandResult["InvalidNumberOfCriterionValues"] = "InvalidNumberOfCriterionValues";
    CommandResult["InvalidCopyPasteSelection"] = "InvalidCopyPasteSelection";
    CommandResult["NoChanges"] = "NoChanges";
    CommandResult["InvalidInputId"] = "InvalidInputId";
    CommandResult["SheetIsHidden"] = "SheetIsHidden";
    CommandResult["InvalidTableResize"] = "InvalidTableResize";
    CommandResult["PivotIdNotFound"] = "PivotIdNotFound";
    CommandResult["PivotInError"] = "PivotInError";
    CommandResult["EmptyName"] = "EmptyName";
    CommandResult["ValueCellIsInvalidFormula"] = "ValueCellIsInvalidFormula";
    CommandResult["InvalidDefinition"] = "InvalidDefinition";
    CommandResult["InvalidColor"] = "InvalidColor";
})(CommandResult || (CommandResult = {}));

const DEFAULT_LOCALES = [
    {
        name: "English (US)",
        code: "en_US",
        thousandsSeparator: ",",
        decimalSeparator: ".",
        weekStart: 7, // Sunday
        dateFormat: "m/d/yyyy",
        timeFormat: "hh:mm:ss a",
        formulaArgSeparator: ",",
    },
    {
        name: "French",
        code: "fr_FR",
        thousandsSeparator: " ",
        decimalSeparator: ",",
        weekStart: 1, // Monday
        dateFormat: "dd/mm/yyyy",
        timeFormat: "hh:mm:ss",
        formulaArgSeparator: ";",
    },
];
const DEFAULT_LOCALE = DEFAULT_LOCALES[0];

const borderStyles = ["thin", "medium", "thick", "dashed", "dotted"];
function isMatrix(x) {
    return Array.isArray(x) && Array.isArray(x[0]);
}
var DIRECTION;
(function (DIRECTION) {
    DIRECTION["UP"] = "up";
    DIRECTION["DOWN"] = "down";
    DIRECTION["LEFT"] = "left";
    DIRECTION["RIGHT"] = "right";
})(DIRECTION || (DIRECTION = {}));

const LAYERS = {
    Background: 0,
    Highlights: 1,
    Clipboard: 2,
    Chart: 4,
    Autofill: 5,
    Selection: 6,
    Headers: 100, // ensure that we end up on  top
};
const OrderedLayers = memoize(() => Object.keys(LAYERS).sort((a, b) => LAYERS[a] - LAYERS[b]));
/**
 *
 * @param layer New layer name
 * @param priority The lower priorities are rendered first
 */
function addRenderingLayer(layer, priority) {
    if (LAYERS[layer]) {
        throw new Error(`Layer ${layer} already exists`);
    }
    LAYERS[layer] = priority;
}

const CellErrorType = {
    NotAvailable: "#N/A",
    InvalidReference: "#REF",
    BadExpression: "#BAD_EXPR",
    CircularDependency: "#CYCLE",
    UnknownFunction: "#NAME?",
    DivisionByZero: "#DIV/0!",
    SpilledBlocked: "#SPILL!",
    GenericError: "#ERROR",
    NullError: "#NULL!",
};
const errorTypes = new Set(Object.values(CellErrorType));
class EvaluationError extends Error {
    value;
    constructor(message = _t("Error"), value = CellErrorType.GenericError) {
        super(message);
        this.value = value;
    }
}
class BadExpressionError extends EvaluationError {
    constructor(message = _t("Invalid expression")) {
        super(message, CellErrorType.BadExpression);
    }
}
class CircularDependencyError extends EvaluationError {
    constructor(message = _t("Circular reference")) {
        super(message, CellErrorType.CircularDependency);
    }
}
class InvalidReferenceError extends EvaluationError {
    constructor(message = _t("Invalid reference")) {
        super(message, CellErrorType.InvalidReference);
    }
}
class NotAvailableError extends EvaluationError {
    constructor(message = _t("Data not available")) {
        super(message, CellErrorType.NotAvailable);
    }
}
class UnknownFunctionError extends EvaluationError {
    constructor(message = _t("Unknown function")) {
        super(message, CellErrorType.UnknownFunction);
    }
}
class SplillBlockedError extends EvaluationError {
    constructor(message = _t("Spill range is not empty")) {
        super(message, CellErrorType.SpilledBlocked);
    }
}

// HELPERS
const SORT_TYPES_ORDER = ["number", "string", "boolean", "undefined"];
function assert(condition, message, value) {
    if (!condition()) {
        throw new EvaluationError(message, value);
    }
}
function inferFormat(data) {
    if (data === undefined) {
        return undefined;
    }
    if (isMatrix(data)) {
        return data[0][0]?.format;
    }
    return data.format;
}
function isEvaluationError(error) {
    return typeof error === "string" && errorTypes.has(error);
}
// -----------------------------------------------------------------------------
// FORMAT FUNCTIONS
// -----------------------------------------------------------------------------
const expectNumberValueError = (value) => _t("The function [[FUNCTION_NAME]] expects a number value, but '%s' is a string, and cannot be coerced to a number.", value);
const expectNumberRangeError = (lowerBound, upperBound, value) => _t("The function [[FUNCTION_NAME]] expects a number value between %s and %s inclusive, but receives %s.", lowerBound.toString(), upperBound.toString(), value.toString());
const expectStringSetError = (stringSet, value) => {
    const stringSetString = stringSet.map((str) => `'${str}'`).join(", ");
    return _t("The function [[FUNCTION_NAME]] has an argument with value '%s'. It should be one of: %s.", value, stringSetString);
};
function toNumber(data, locale) {
    const value = toValue(data);
    switch (typeof value) {
        case "number":
            return value;
        case "boolean":
            return value ? 1 : 0;
        case "string":
            if (isNumber(value, locale) || value === "") {
                return parseNumber(value, locale);
            }
            const internalDate = parseDateTime(value, locale);
            if (internalDate) {
                return internalDate.value;
            }
            throw new EvaluationError(expectNumberValueError(value));
        default:
            return 0;
    }
}
function tryToNumber(value, locale) {
    try {
        return toNumber(value, locale);
    }
    catch (e) {
        return undefined;
    }
}
function toNumberMatrix(data, argName) {
    return toMatrix(data).map((row) => {
        return row.map((cell) => {
            if (typeof cell.value !== "number") {
                throw new EvaluationError(_t("Function [[FUNCTION_NAME]] expects number values for %s, but got a %s.", argName, typeof cell.value));
            }
            return cell.value;
        });
    });
}
function strictToNumber(data, locale) {
    const value = toValue(data);
    if (value === "") {
        throw new EvaluationError(expectNumberValueError(value));
    }
    return toNumber(value, locale);
}
function toInteger(value, locale) {
    return Math.trunc(toNumber(value, locale));
}
function strictToInteger(value, locale) {
    return Math.trunc(strictToNumber(value, locale));
}
function assertNumberGreaterThanOrEqualToOne(value) {
    assert(() => value >= 1, _t("The function [[FUNCTION_NAME]] expects a number value to be greater than or equal to 1, but receives %s.", value.toString()));
}
function assertNotZero(value) {
    assert(() => value !== 0, _t("Evaluation of function [[FUNCTION_NAME]] caused a divide by zero error."), CellErrorType.DivisionByZero);
}
function toString(data) {
    const value = toValue(data);
    switch (typeof value) {
        case "string":
            return value;
        case "number":
            return value.toString();
        case "boolean":
            return value ? "TRUE" : "FALSE";
        default:
            return "";
    }
}
/** Normalize string by setting it to lowercase and replacing accent letters with plain letters */
const normalizeString = memoize(function normalizeString(str) {
    return str
        .toLowerCase()
        .normalize("NFD")
        .replace(/[\u0300-\u036f]/g, "");
});
const expectBooleanValueError = (value) => _t("The function [[FUNCTION_NAME]] expects a boolean value, but '%s' is a text, and cannot be coerced to a boolean.", value);
function toBoolean(data) {
    const value = toValue(data);
    switch (typeof value) {
        case "boolean":
            return value;
        case "string":
            if (value) {
                let uppercaseVal = value.toUpperCase();
                if (uppercaseVal === "TRUE") {
                    return true;
                }
                if (uppercaseVal === "FALSE") {
                    return false;
                }
                throw new EvaluationError(expectBooleanValueError(value));
            }
            else {
                return false;
            }
        case "number":
            return value ? true : false;
        default:
            return false;
    }
}
function strictToBoolean(data) {
    const value = toValue(data);
    if (value === "") {
        throw new EvaluationError(expectBooleanValueError(value));
    }
    return toBoolean(value);
}
function toJsDate(data, locale) {
    const value = toValue(data);
    return numberToJsDate(toNumber(value, locale));
}
function toValue(data) {
    if (typeof data === "object" && data !== null && "value" in data) {
        if (isEvaluationError(data.value)) {
            throw data;
        }
        return data.value;
    }
    if (isEvaluationError(data)) {
        throw new EvaluationError("", data);
    }
    return data;
}
// -----------------------------------------------------------------------------
// VISIT FUNCTIONS
// -----------------------------------------------------------------------------
function visitArgs(args, cellCb, dataCb) {
    for (let arg of args) {
        if (isMatrix(arg)) {
            // arg is ref to a Cell/Range
            const lenRow = arg.length;
            const lenCol = arg[0].length;
            for (let y = 0; y < lenCol; y++) {
                for (let x = 0; x < lenRow; x++) {
                    cellCb(arg[x][y]);
                }
            }
        }
        else {
            // arg is set directly in the formula function
            dataCb(arg);
        }
    }
}
function visitAny(args, cb) {
    visitArgs(args, (cell) => {
        if (isEvaluationError(cell.value)) {
            throw cell;
        }
        cb(cell);
    }, (arg) => {
        if (isEvaluationError(arg?.value)) {
            throw arg;
        }
        cb(arg);
    });
}
function visitNumbers(args, cb, locale) {
    visitArgs(args, (cell) => {
        if (typeof cell?.value === "number") {
            cb(cell);
        }
        if (isEvaluationError(cell?.value)) {
            throw cell;
        }
    }, (arg) => {
        cb({ value: strictToNumber(arg, locale), format: arg?.format });
    });
}
// -----------------------------------------------------------------------------
// REDUCE FUNCTIONS
// -----------------------------------------------------------------------------
function reduceArgs(args, cellCb, dataCb, initialValue, dir = "rowFirst") {
    let val = initialValue;
    for (let arg of args) {
        if (isMatrix(arg)) {
            // arg is ref to a Cell/Range
            const numberOfCols = arg.length;
            const numberOfRows = arg[0].length;
            if (dir === "rowFirst") {
                for (let row = 0; row < numberOfRows; row++) {
                    for (let col = 0; col < numberOfCols; col++) {
                        val = cellCb(val, arg[col][row]);
                    }
                }
            }
            else {
                for (let col = 0; col < numberOfCols; col++) {
                    for (let row = 0; row < numberOfRows; row++) {
                        val = cellCb(val, arg[col][row]);
                    }
                }
            }
        }
        else {
            // arg is set directly in the formula function
            val = dataCb(val, arg);
        }
    }
    return val;
}
function reduceAny(args, cb, initialValue, dir = "rowFirst") {
    return reduceArgs(args, cb, cb, initialValue, dir);
}
function reduceNumbers(args, cb, initialValue, locale) {
    return reduceArgs(args, (acc, arg) => {
        const argValue = arg?.value;
        if (typeof argValue === "number") {
            return cb(acc, argValue);
        }
        else if (isEvaluationError(argValue)) {
            throw arg;
        }
        return acc;
    }, (acc, arg) => {
        return cb(acc, strictToNumber(arg, locale));
    }, initialValue);
}
function reduceNumbersTextAs0(args, cb, initialValue, locale) {
    return reduceArgs(args, (acc, arg) => {
        const argValue = arg?.value;
        if (argValue !== undefined && argValue !== null) {
            if (typeof argValue === "number") {
                return cb(acc, argValue);
            }
            else if (typeof argValue === "boolean") {
                return cb(acc, toNumber(argValue, locale));
            }
            else if (isEvaluationError(argValue)) {
                throw arg;
            }
            else {
                return cb(acc, 0);
            }
        }
        return acc;
    }, (acc, arg) => {
        return cb(acc, toNumber(arg, locale));
    }, initialValue);
}
// -----------------------------------------------------------------------------
// MATRIX FUNCTIONS
// -----------------------------------------------------------------------------
/**
 * Generate a matrix of size nColumns x nRows and apply a callback on each position
 */
function generateMatrix(nColumns, nRows, callback) {
    const returned = Array(nColumns);
    for (let col = 0; col < nColumns; col++) {
        returned[col] = Array(nRows);
        for (let row = 0; row < nRows; row++) {
            returned[col][row] = callback(col, row);
        }
    }
    return returned;
}
function matrixMap(matrix, callback) {
    if (matrix.length === 0) {
        return [];
    }
    return generateMatrix(matrix.length, matrix[0].length, (col, row) => callback(matrix[col][row]));
}
function matrixForEach(matrix, fn) {
    const numberOfCols = matrix.length;
    const numberOfRows = matrix[0]?.length ?? 0;
    for (let col = 0; col < numberOfCols; col++) {
        for (let row = 0; row < numberOfRows; row++) {
            fn(matrix[col][row]);
        }
    }
}
function transposeMatrix(matrix) {
    if (!matrix.length) {
        return [];
    }
    return generateMatrix(matrix[0].length, matrix.length, (i, j) => matrix[j][i]);
}
// -----------------------------------------------------------------------------
// CONDITIONAL EXPLORE FUNCTIONS
// -----------------------------------------------------------------------------
/**
 * This function allows to visit arguments and stop the visit if necessary.
 * It is mainly used to bypass argument evaluation for functions like OR or AND.
 */
function conditionalVisitArgs(args, cellCb, dataCb) {
    for (let arg of args) {
        if (isMatrix(arg)) {
            // arg is ref to a Cell/Range
            const lenRow = arg.length;
            const lenCol = arg[0].length;
            for (let y = 0; y < lenCol; y++) {
                for (let x = 0; x < lenRow; x++) {
                    if (!cellCb(arg[x][y] ?? undefined))
                        return;
                }
            }
        }
        else {
            // arg is set directly in the formula function
            if (!dataCb(arg))
                return;
        }
    }
}
function conditionalVisitBoolean(args, cb) {
    return conditionalVisitArgs(args, (arg) => {
        const argValue = arg?.value;
        if (typeof argValue === "boolean") {
            return cb(argValue);
        }
        if (typeof argValue === "number") {
            return cb(argValue ? true : false);
        }
        if (isEvaluationError(argValue)) {
            throw arg;
        }
        return true;
    }, (arg) => {
        if (arg !== undefined && arg.value !== null) {
            return cb(strictToBoolean(arg));
        }
        return true;
    });
}
function getPredicate(descr, locale) {
    let operator;
    let operand;
    let subString = descr.substring(0, 2);
    if (subString === "<=" || subString === ">=" || subString === "<>") {
        operator = subString;
        operand = descr.substring(2);
    }
    else {
        subString = descr.substring(0, 1);
        if (subString === "<" || subString === ">" || subString === "=") {
            operator = subString;
            operand = descr.substring(1);
        }
        else {
            operator = "=";
            operand = descr;
        }
    }
    if (isNumber(operand, locale) || isDateTime(operand, locale)) {
        operand = toNumber(operand, locale);
    }
    else if (operand === "TRUE" || operand === "FALSE") {
        operand = toBoolean(operand);
    }
    return { operator, operand };
}
/**
 * Converts a search string containing wildcard characters to a regular expression.
 *
 * The function iterates over each character in the input string. If the character is a wildcard
 * character ("?" or "*") and is not preceded by a "~", it is replaced by the corresponding regular
 * expression.
 * If the character is a special regular expression character, it is escaped with "\\".
 */
const wildcardToRegExp = memoize(function wildcardToRegExp(operand) {
    if (operand === "*") {
        return /.+/;
    }
    let exp = "";
    let predecessor = "";
    for (let char of operand) {
        if (char === "?" && predecessor !== "~") {
            exp += ".";
        }
        else if (char === "*" && predecessor !== "~") {
            exp += ".*";
        }
        else {
            if (char === "*" || char === "?") {
                //remove "~"
                exp = exp.slice(0, -1);
            }
            if (["^", ".", "[", "]", "$", "(", ")", "*", "+", "?", "|", "{", "}", "\\"].includes(char)) {
                exp += "\\";
            }
            exp += char;
        }
        predecessor = char;
    }
    return new RegExp("^" + exp + "$", "i");
});
function evaluatePredicate(value = "", criterion, locale) {
    const { operator, operand } = criterion;
    if (operand === undefined || value === null || operand === null) {
        return false;
    }
    if (typeof operand === "number" && operator === "=") {
        if (typeof value === "string" && (isNumber(value, locale) || isDateTime(value, locale))) {
            return toNumber(value, locale) === operand;
        }
        return value === operand;
    }
    if (operator === "<>" || operator === "=") {
        let result;
        if (typeof value === typeof operand) {
            if (typeof value === "string" && typeof operand === "string") {
                result = wildcardToRegExp(operand).test(value);
            }
            else {
                result = value === operand;
            }
        }
        else {
            result = false;
        }
        return operator === "=" ? result : !result;
    }
    if (typeof value === typeof operand) {
        switch (operator) {
            case "<":
                return value < operand;
            case ">":
                return value > operand;
            case "<=":
                return value <= operand;
            case ">=":
                return value >= operand;
        }
    }
    return false;
}
/**
 * Functions used especially for predicate evaluation on ranges.
 *
 * Take ranges with same dimensions and take predicates, one for each range.
 * For (i, j) coordinates, if all elements with coordinates (i, j) of each
 * range correspond to the associated predicate, then the function uses a callback
 * function with the parameters "i" and "j".
 *
 * Syntax:
 * visitMatchingRanges([range1, predicate1, range2, predicate2, ...], cb(i,j), likeSelection)
 *
 * - range1 (range): The range to check against predicate1.
 * - predicate1 (string): The pattern or test to apply to range1.
 * - range2: (range, repeatable) ranges to check.
 * - predicate2 (string, repeatable): Additional pattern or test to apply to range2.
 *
 * - cb(i: number, j: number) => void: the callback function.
 *
 * - isQuery (boolean) indicates if the comparison with a string should be done as a SQL-like query.
 * (Ex1 isQuery = true, predicate = "abc", element = "abcde": predicate match the element),
 * (Ex2 isQuery = false, predicate = "abc", element = "abcde": predicate not match the element).
 * (Ex3 isQuery = true, predicate = "abc", element = "abc": predicate match the element),
 * (Ex4 isQuery = false, predicate = "abc", element = "abc": predicate match the element).
 */
function visitMatchingRanges(args, cb, locale, isQuery = false) {
    const countArg = args.length;
    if (countArg % 2 === 1) {
        throw new EvaluationError(_t("Function [[FUNCTION_NAME]] expects criteria_range and criterion to be in pairs."));
    }
    const firstArg = toMatrix(args[0]);
    const dimRow = firstArg.length;
    const dimCol = firstArg[0].length;
    let predicates = [];
    for (let i = 0; i < countArg - 1; i += 2) {
        const criteriaRange = toMatrix(args[i]);
        if (criteriaRange.length !== dimRow || criteriaRange[0].length !== dimCol) {
            throw new EvaluationError(_t("Function [[FUNCTION_NAME]] expects criteria_range to have the same dimension"));
        }
        const description = toString(args[i + 1]);
        const predicate = getPredicate(description, locale);
        if (isQuery && typeof predicate.operand === "string") {
            predicate.operand += "*";
        }
        predicates.push(predicate);
    }
    for (let i = 0; i < dimRow; i++) {
        for (let j = 0; j < dimCol; j++) {
            let validatedPredicates = true;
            for (let k = 0; k < countArg - 1; k += 2) {
                const criteriaValue = toMatrix(args[k])[i][j].value;
                const criterion = predicates[k / 2];
                validatedPredicates = evaluatePredicate(criteriaValue ?? undefined, criterion, locale);
                if (!validatedPredicates) {
                    break;
                }
            }
            if (validatedPredicates) {
                cb(i, j);
            }
        }
    }
}
// -----------------------------------------------------------------------------
// COMMON FUNCTIONS
// -----------------------------------------------------------------------------
/**
 * Perform a dichotomic search on an array and return the index of the nearest match.
 *
 * The array should be sorted, if not an incorrect value might be returned. In the case where multiple
 * element of the array match the target, the method will return the first match if the array is sorted
 * in descending order, and the last match if the array is in ascending order.
 *
 *
 * @param data the array in which to search.
 * @param target the value to search.
 * @param mode "nextGreater/nextSmaller" : return next greater/smaller value if no exact match is found.
 * @param sortOrder whether the array is sorted in ascending or descending order.
 * @param rangeLength the number of elements to consider in the search array.
 * @param getValueInData function returning the element at index i in the search array.
 */
function dichotomicSearch(data, target, mode, sortOrder, rangeLength, getValueInData) {
    if (target === undefined || target.value === null) {
        return -1;
    }
    if (isEvaluationError(target.value)) {
        throw target;
    }
    const _target = normalizeValue(target.value);
    const targetType = typeof _target;
    let matchVal = undefined;
    let matchValIndex = undefined;
    let indexLeft = 0;
    let indexRight = rangeLength - 1;
    let indexMedian;
    let currentIndex;
    let currentVal;
    let currentType;
    const getValue = sortOrder === "desc"
        ? (i) => normalizeValue(getValueInData(data, rangeLength - i - 1))
        : (i) => normalizeValue(getValueInData(data, i));
    while (indexRight - indexLeft >= 0) {
        indexMedian = Math.floor((indexLeft + indexRight) / 2);
        currentIndex = indexMedian;
        currentVal = getValue(currentIndex);
        currentType = typeof currentVal;
        // 1 - linear search to find value with the same type
        while (indexLeft < currentIndex && targetType !== currentType) {
            currentIndex--;
            currentVal = getValue(currentIndex);
            currentType = typeof currentVal;
        }
        if (currentType !== targetType || currentVal === undefined || currentVal === null) {
            indexLeft = indexMedian + 1;
            continue;
        }
        // 2 - check if value match
        if (mode === "strict" && currentVal === _target) {
            matchVal = currentVal;
            matchValIndex = currentIndex;
        }
        else if (mode === "nextSmaller" && currentVal <= _target) {
            if (matchVal === undefined ||
                matchVal === null ||
                matchVal < currentVal ||
                (matchVal === currentVal && matchValIndex < currentIndex)) {
                matchVal = currentVal;
                matchValIndex = currentIndex;
            }
        }
        else if (mode === "nextGreater" && currentVal >= _target) {
            if (matchVal === undefined ||
                matchVal > currentVal ||
                (matchVal === currentVal && matchValIndex < currentIndex)) {
                matchVal = currentVal;
                matchValIndex = currentIndex;
            }
        }
        // 3 - give new indexes for the Binary search
        if (currentVal > _target || (mode === "strict" && currentVal === _target)) {
            indexRight = currentIndex - 1;
        }
        else {
            indexLeft = indexMedian + 1;
        }
    }
    // note that valMinIndex could be 0
    if (matchValIndex === undefined) {
        return -1;
    }
    return sortOrder === "desc" ? rangeLength - matchValIndex - 1 : matchValIndex;
}
/**
 * Perform a linear search and return the index of the match.
 * -1 is returned if no value is found.
 *
 * Example:
 * - [3, 6, 10], 3 => 0
 * - [3, 6, 10], 6 => 1
 * - [3, 6, 10], 9 => -1
 * - [3, 6, 10], 2 => -1
 *
 * @param data the array to search in.
 * @param target the value to search in the array.
 * @param mode if "strict" return exact match index. "nextGreater" returns the next greater
 * element from the target and "nextSmaller" the next smaller
 * @param numberOfValues the number of elements to consider in the search array.
 * @param getValueInData function returning the element at index i in the search array.
 * @param reverseSearch if true, search in the array starting from the end.

 */
function linearSearch(data, target, mode, numberOfValues, getValueInData, lookupCaches, reverseSearch = false) {
    if (target === undefined || target.value === null) {
        return -1;
    }
    if (isEvaluationError(target.value)) {
        throw target;
    }
    const _target = normalizeValue(target.value);
    const getValue = reverseSearch
        ? (data, i) => normalizeValue(getValueInData(data, numberOfValues - i - 1))
        : (data, i) => normalizeValue(getValueInData(data, i));
    // first check if the target is in the cache
    const isNotWildcardTarget = mode !== "wildcard" ||
        typeof _target !== "string" ||
        !(_target.includes("*") || _target.includes("?"));
    if (lookupCaches && isNotWildcardTarget) {
        const searchMode = reverseSearch ? "reverseSearch" : "forwardSearch";
        let cache = lookupCaches[searchMode].get(data);
        if (cache === undefined) {
            // build the cache for all the values
            cache = new Map();
            for (let i = 0; i < numberOfValues; i++) {
                const value = getValue(data, i) ?? null;
                if (!cache.has(value)) {
                    cache.set(value, i);
                }
            }
            lookupCaches[searchMode].set(data, cache);
        }
        if (cache.has(_target)) {
            const resultIndex = cache.get(_target);
            return reverseSearch ? numberOfValues - resultIndex - 1 : resultIndex;
        }
        if (mode === "strict") {
            return -1;
        }
    }
    // else perform the linear search
    const resultIndex = _linearSearch(data, _target, mode, numberOfValues, getValue);
    return reverseSearch && resultIndex !== -1 ? numberOfValues - resultIndex - 1 : resultIndex;
}
function _linearSearch(data, _target, mode, numberOfValues, getNormalizeValue) {
    let indexMatchTarget = (i) => {
        return getNormalizeValue(data, i) === _target;
    };
    if (mode === "wildcard" &&
        typeof _target === "string" &&
        (_target.includes("*") || _target.includes("?"))) {
        const regExp = wildcardToRegExp(_target);
        indexMatchTarget = (i) => {
            const value = getNormalizeValue(data, i);
            if (typeof value === "string") {
                return regExp.test(value);
            }
            return false;
        };
    }
    let closestMatch = undefined;
    let closestMatchIndex = -1;
    if (mode === "nextSmaller") {
        indexMatchTarget = (i) => {
            const value = getNormalizeValue(data, i);
            if ((!closestMatch && compareCellValues(_target, value) >= 0) ||
                (compareCellValues(_target, value) >= 0 && compareCellValues(value, closestMatch) > 0)) {
                closestMatch = value;
                closestMatchIndex = i;
            }
            return value === _target;
        };
    }
    if (mode === "nextGreater") {
        indexMatchTarget = (i) => {
            const value = getNormalizeValue(data, i);
            if ((!closestMatch && compareCellValues(_target, value) <= 0) ||
                (compareCellValues(_target, value) <= 0 && compareCellValues(value, closestMatch) < 0)) {
                closestMatch = value;
                closestMatchIndex = i;
            }
            return value === _target;
        };
    }
    for (let i = 0; i < numberOfValues; i++) {
        if (indexMatchTarget(i)) {
            return i;
        }
    }
    return closestMatchIndex;
}
/**
 * Normalize a value.
 * If the cell value is a string, this will set it to lowercase and replacing accent letters with plain letters
 */
function normalizeValue(value) {
    return typeof value === "string" ? normalizeString(value) : value;
}
function compareCellValues(left, right) {
    let typeOrder = SORT_TYPES_ORDER.indexOf(typeof left) - SORT_TYPES_ORDER.indexOf(typeof right);
    if (typeOrder === 0) {
        if (typeof left === "string" && typeof right === "string") {
            typeOrder = left.localeCompare(right);
        }
        else if (typeof left === "number" && typeof right === "number") {
            typeOrder = left - right;
        }
        else if (typeof left === "boolean" && typeof right === "boolean") {
            typeOrder = Number(left) - Number(right);
        }
    }
    return typeOrder;
}
function toMatrix(data) {
    if (data === undefined) {
        return [[]];
    }
    return isMatrix(data) ? data : [[data]];
}
/**
 * Flatten an array of items, where each item can be a single value or a 2D array, and apply the
 * callback to each element.
 *
 * The 2D array are flattened row first.
 */
function flattenRowFirst(items, callback) {
    /**/
    return reduceAny(items, (array, val) => {
        array.push(callback(val));
        return array;
    }, [], "rowFirst");
}
function isDataNonEmpty(data) {
    if (data === undefined) {
        return false;
    }
    const { value } = data;
    if (value === null || value === "") {
        return false;
    }
    return true;
}

/**
 * Add the `https` prefix to the url if it's missing
 */
function withHttps(url) {
    return !/^https?:\/\//i.test(url) ? `https://${url}` : url;
}
const urlRegistry = new Registry();
function createWebLink(url, label) {
    url = withHttps(url);
    return {
        url,
        label: label || url,
        isExternal: true,
        isUrlEditable: true,
    };
}
urlRegistry.add("sheet_URL", {
    match: (url) => isSheetUrl(url),
    createLink: (url, label) => {
        return {
            label,
            url,
            isExternal: false,
            isUrlEditable: false,
        };
    },
    urlRepresentation(url, getters) {
        const sheetId = parseSheetUrl(url);
        return getters.tryGetSheetName(sheetId) || _t("Invalid sheet");
    },
    open(url, env) {
        const sheetId = parseSheetUrl(url);
        const result = env.model.dispatch("ACTIVATE_SHEET", {
            sheetIdFrom: env.model.getters.getActiveSheetId(),
            sheetIdTo: sheetId,
        });
        if (result.isCancelledBecause("SheetIsHidden" /* CommandResult.SheetIsHidden */)) {
            env.notifyUser({
                type: "warning",
                sticky: false,
                text: _t("Cannot open the link because the linked sheet is hidden."),
            });
        }
    },
    sequence: 0,
});
const WebUrlSpec = {
    createLink: createWebLink,
    match: (url) => isWebLink(url),
    open: (url) => window.open(url, "_blank"),
    urlRepresentation: (url) => url,
    sequence: 0,
};
function findMatchingSpec(url) {
    return (urlRegistry
        .getAll()
        .sort((a, b) => a.sequence - b.sequence)
        .find((urlType) => urlType.match(url)) || WebUrlSpec);
}
function urlRepresentation(link, getters) {
    return findMatchingSpec(link.url).urlRepresentation(link.url, getters);
}
function openLink(link, env) {
    findMatchingSpec(link.url).open(link.url, env);
}
function detectLink(value) {
    if (typeof value !== "string") {
        return undefined;
    }
    if (isMarkdownLink(value)) {
        const { label, url } = parseMarkdownLink(value);
        return findMatchingSpec(url).createLink(url, label);
    }
    else if (isWebLink(value)) {
        return createWebLink(value);
    }
    return undefined;
}

function tokenizeFormat(str) {
    const chars = new TokenizingChars(str);
    const result = [];
    let currentFormatPart = [];
    result.push(currentFormatPart);
    while (!chars.isOver()) {
        if (chars.current === ";") {
            currentFormatPart = [];
            result.push(currentFormatPart);
            chars.shift();
            continue;
        }
        let token = tokenizeDigit(chars) ||
            tokenizeString$1(chars) ||
            tokenizeEscapedChars(chars) ||
            tokenizeThousandsSeparator(chars) ||
            tokenizeDecimalPoint(chars) ||
            tokenizePercent(chars) ||
            tokenizeDatePart(chars) ||
            tokenizeTextPlaceholder(chars) ||
            tokenizeRepeatedChar(chars);
        if (!token) {
            throw new Error("Unknown token at " + chars.remaining());
        }
        currentFormatPart.push(token);
    }
    return result;
}
function tokenizeString$1(chars) {
    let enfOfStringChar;
    if (chars.current === '"') {
        chars.shift();
        enfOfStringChar = '"';
    }
    else if (chars.currentStartsWith("[$")) {
        chars.advanceBy(2);
        enfOfStringChar = "]";
    }
    if (!enfOfStringChar) {
        return null;
    }
    let letters = "";
    while (chars.current && chars.current !== enfOfStringChar) {
        letters += chars.shift();
    }
    if (chars.current === enfOfStringChar) {
        chars.shift();
    }
    else {
        throw new Error("Unterminated string in format");
    }
    return {
        type: "STRING",
        value: letters,
    };
}
const alwaysEscapedCharsInFormat = new Set("$+-/():!^&~{}<>= ");
function tokenizeEscapedChars(chars) {
    if (chars.current === "\\") {
        chars.shift();
        const escapedChar = chars.shift();
        if (!escapedChar) {
            throw new Error("Unexpected end of format string");
        }
        return {
            type: "CHAR",
            value: escapedChar,
        };
    }
    if (alwaysEscapedCharsInFormat.has(chars.current)) {
        return {
            type: "CHAR",
            value: chars.shift(),
        };
    }
    return null;
}
function tokenizeThousandsSeparator(chars) {
    if (chars.current === ",") {
        chars.shift();
        return { type: "THOUSANDS_SEPARATOR", value: "," };
    }
    return null;
}
function tokenizeTextPlaceholder(chars) {
    if (chars.current === "@") {
        chars.shift();
        return { type: "TEXT_PLACEHOLDER", value: "@" };
    }
    return null;
}
function tokenizeDecimalPoint(chars) {
    if (chars.current === ".") {
        chars.shift();
        return { type: "DECIMAL_POINT", value: "." };
    }
    return null;
}
function tokenizePercent(chars) {
    if (chars.current === "%") {
        chars.shift();
        return { type: "PERCENT", value: "%" };
    }
    return null;
}
function tokenizeDigit(chars) {
    if (chars.current === "0" || chars.current === "#") {
        const value = chars.current;
        chars.shift();
        return { type: "DIGIT", value };
    }
    return null;
}
const dateSymbols = new Set("dmqyhsa");
function tokenizeDatePart(chars) {
    if (!dateSymbols.has(chars.current)) {
        return null;
    }
    const char = chars.current;
    let value = "";
    while (chars.current === char) {
        value += chars.shift();
    }
    return { type: "DATE_PART", value };
}
function tokenizeRepeatedChar(chars) {
    if (chars.current !== "*") {
        return null;
    }
    chars.shift();
    const repeatedChar = chars.shift();
    if (!repeatedChar) {
        throw new Error("Unexpected end of format string");
    }
    return {
        type: "REPEATED_CHAR",
        value: repeatedChar,
    };
}

/**
 *  Constant used to indicate the maximum of digits that is possible to display
 *  in a cell with standard size.
 */
const MAX_DECIMAL_PLACES = 20;
const internalFormatCache = {};
function parseFormat(formatString) {
    let internalFormat = internalFormatCache[formatString];
    if (internalFormat === undefined) {
        internalFormat = convertFormatToInternalFormat(formatString);
        internalFormatCache[formatString] = internalFormat;
    }
    return internalFormat;
}
function convertFormatToInternalFormat(format) {
    const formatParts = tokenizeFormat(format);
    // A format can only have a single REPEATED_CHAR token. The rest are converted to simple CHAR tokens.
    for (const part of formatParts) {
        const repeatedCharTokens = part.filter((token) => token.type === "REPEATED_CHAR");
        for (const repeatedCharToken of repeatedCharTokens.slice(1)) {
            repeatedCharToken.type = "CHAR";
        }
    }
    const positiveFormat = parseDateFormatTokens(formatParts[0]) ||
        parseNumberFormatTokens(formatParts[0]) ||
        tokensToTextInternalFormat(formatParts[0]);
    if (!positiveFormat) {
        throw new Error("Invalid first format part of: " + format);
    }
    if (formatParts.length > 1 && positiveFormat.type === "text") {
        throw new Error("The first format in a multi-part format must be a number format: " + format);
    }
    const negativeFormat = parseDateFormatTokens(formatParts[1]) || parseNumberFormatTokens(formatParts[1]);
    if (formatParts[1]?.length && !negativeFormat) {
        throw new Error("Invalid second format part of: " + format);
    }
    const zeroFormat = parseDateFormatTokens(formatParts[2]) || parseNumberFormatTokens(formatParts[2]);
    if (formatParts[2]?.length && !zeroFormat) {
        throw new Error("Invalid third format part of: " + format);
    }
    const textFormat = tokensToTextInternalFormat(formatParts[3]);
    if (formatParts[3]?.length && !textFormat) {
        throw new Error("Invalid fourth format part of: " + format);
    }
    return { positive: positiveFormat, negative: negativeFormat, zero: zeroFormat, text: textFormat };
}
function areValidDateFormatTokens(tokens) {
    return tokens.every((token) => token.type === "DATE_PART" ||
        token.type === "DECIMAL_POINT" ||
        token.type === "THOUSANDS_SEPARATOR" ||
        token.type === "STRING" ||
        token.type === "CHAR" ||
        token.type === "REPEATED_CHAR");
}
function areValidNumberFormatTokens(tokens) {
    return tokens.every((token) => token.type === "DIGIT" ||
        token.type === "DECIMAL_POINT" ||
        token.type === "THOUSANDS_SEPARATOR" ||
        token.type === "PERCENT" ||
        token.type === "STRING" ||
        token.type === "CHAR" ||
        token.type === "REPEATED_CHAR");
}
function areValidTextFormatTokens(tokens) {
    return tokens.every((token) => token.type === "STRING" ||
        token.type === "TEXT_PLACEHOLDER" ||
        token.type === "CHAR" ||
        token.type === "REPEATED_CHAR");
}
function parseNumberFormatTokens(tokens) {
    if (!tokens || !areValidNumberFormatTokens(tokens)) {
        return undefined;
    }
    const integerPart = [];
    let decimalPart = undefined;
    let parsedPart = integerPart;
    let percentSymbols = 0;
    let magnitude = 0;
    let lastIndexOfDigit = tokens.findLastIndex((token) => token.type === "DIGIT");
    let hasThousandSeparator = false;
    let numberOfDecimalsDigits = 0;
    for (let i = 0; i < tokens.length; i++) {
        const token = tokens[i];
        switch (token.type) {
            case "DIGIT":
                if (parsedPart === integerPart) {
                    parsedPart.push(token);
                }
                else if (numberOfDecimalsDigits < MAX_DECIMAL_PLACES) {
                    parsedPart.push(token);
                    numberOfDecimalsDigits++;
                }
                break;
            case "DECIMAL_POINT":
                if (parsedPart === integerPart) {
                    decimalPart = [];
                    parsedPart = decimalPart;
                }
                else {
                    throw new Error("Multiple decimal points in a number format");
                }
                break;
            case "REPEATED_CHAR":
            case "CHAR":
            case "STRING":
                parsedPart.push(token);
                break;
            case "PERCENT":
                percentSymbols++;
                parsedPart.push(token);
                break;
            // Per OpenXML Spec:
            // - If a comma is between two DIGIT tokens, and in the integer part, a thousand separator is applied in the formatted value.
            // - If a comma is at the end of the number placeholder, the number is divided by a thousand.
            // - Otherwise, it's a string.
            case "THOUSANDS_SEPARATOR":
                if (i - 1 === lastIndexOfDigit) {
                    magnitude += 1;
                    lastIndexOfDigit++; // Can have multiple commas in a row
                    parsedPart.push(token);
                }
                else if (tokens[i + 1]?.type === "DIGIT" && tokens[i - 1]?.type === "DIGIT") {
                    if (parsedPart === integerPart) {
                        hasThousandSeparator = true;
                    }
                    parsedPart.push(token);
                }
                else {
                    parsedPart.push({ type: "CHAR", value: "," });
                }
                break;
        }
    }
    return {
        type: "number",
        integerPart,
        decimalPart,
        percentSymbols,
        thousandsSeparator: hasThousandSeparator,
        magnitude,
    };
}
function parseDateFormatTokens(tokens) {
    const internalFormat = tokens && areValidDateFormatTokens(tokens) ? { type: "date", tokens } : undefined;
    if (!internalFormat) {
        return undefined;
    }
    if (internalFormat.tokens.length &&
        internalFormat.tokens.every((token) => token.type === "DATE_PART" && token.value === "a")) {
        throw new Error("Invalid date format");
    }
    const dateTokens = internalFormat.tokens.map((token) => {
        if (token.type === "THOUSANDS_SEPARATOR" || token.type === "DECIMAL_POINT") {
            return { type: "CHAR", value: token.value };
        }
        return token;
    });
    const convertedTokens = convertTokensToMinutesInDateFormat(dateTokens);
    return { type: "date", tokens: convertedTokens };
}
function tokensToTextInternalFormat(tokens) {
    return tokens && areValidTextFormatTokens(tokens) ? { type: "text", tokens } : undefined;
}
/**
 * Replace in place tokens "mm" and "m" that denote minutes in date format with "MM" to avoid confusion with months.
 *
 * As per OpenXML specification, in date formats if a date token "m" or "mm" is followed by a date token "s" or
 * preceded by a data token "h", then it's not a month but an minute.
 */
function convertTokensToMinutesInDateFormat(tokens) {
    const dateParts = tokens.filter((token) => token.type === "DATE_PART");
    for (let i = 0; i < dateParts.length; i++) {
        if (!dateParts[i].value.startsWith("m") || dateParts[i].value.length > 2) {
            continue;
        }
        if (dateParts[i - 1]?.value.startsWith("h") || dateParts[i + 1]?.value.startsWith("s")) {
            dateParts[i].value = dateParts[i].value.replaceAll("m", "M");
        }
    }
    return tokens;
}
function convertInternalFormatToFormat(internalFormat) {
    return [
        internalFormatPartToFormat(internalFormat.positive),
        internalFormatPartToFormat(internalFormat.negative),
        internalFormatPartToFormat(internalFormat.zero),
        internalFormatPartToFormat(internalFormat.text),
    ]
        .filter(isDefined)
        .join(";");
}
function internalFormatPartToFormat(internalFormat) {
    if (!internalFormat) {
        return undefined;
    }
    let format = "";
    const tokens = internalFormat.type !== "number"
        ? internalFormat.tokens
        : numberInternalFormatToTokenList(internalFormat);
    for (let token of tokens) {
        switch (token.type) {
            case "STRING":
                format += `[$${token.value}]`;
                break;
            case "CHAR":
                format += shouldEscapeFormatChar(token.value) ? `\\${token.value}` : token.value;
                break;
            case "REPEATED_CHAR":
                format += "*" + token.value;
                break;
            default:
                format += token.value;
        }
    }
    return format;
}
function numberInternalFormatToTokenList(internalFormat) {
    let tokens = [...internalFormat.integerPart];
    if (internalFormat.decimalPart) {
        tokens.push({ type: "DECIMAL_POINT", value: "." });
        tokens.push(...internalFormat.decimalPart);
    }
    return tokens;
}
function shouldEscapeFormatChar(char) {
    return !alwaysEscapedCharsInFormat.has(char);
}

/**
 * Number of digits for the default number format. This number of digit make a number fit well in a cell
 * with default size and default font size.
 */
const DEFAULT_FORMAT_NUMBER_OF_DIGITS = 11;
const REPEATED_CHAR_PLACEHOLDER = "REPEATED_CHAR_PLACEHOLDER_";
// TODO in the future : remove these constants MONTHS/DAYS, and use a library such as luxon to handle it
// + possibly handle automatic translation of day/month
const MONTHS = {
    0: _t("January"),
    1: _t("February"),
    2: _t("March"),
    3: _t("April"),
    4: _t("May"),
    5: _t("June"),
    6: _t("July"),
    7: _t("August"),
    8: _t("September"),
    9: _t("October"),
    10: _t("November"),
    11: _t("December"),
};
const DAYS$1 = {
    0: _t("Sunday"),
    1: _t("Monday"),
    2: _t("Tuesday"),
    3: _t("Wednesday"),
    4: _t("Thursday"),
    5: _t("Friday"),
    6: _t("Saturday"),
};
/**
 * Formats a cell value with its format.
 */
function formatValue(value, { format, locale, formatWidth }) {
    if (typeof value === "boolean") {
        value = value ? "TRUE" : "FALSE";
    }
    switch (typeof value) {
        case "string": {
            if (value.includes('\\"')) {
                value = value.replaceAll(/\\"/g, '"');
            }
            if (!format) {
                return value;
            }
            const internalFormat = parseFormat(format);
            let formatToApply = internalFormat.text || internalFormat.positive;
            if (!formatToApply || formatToApply.type !== "text") {
                return value;
            }
            return applyTextInternalFormat(value, formatToApply, formatWidth);
        }
        case "number":
            if (!format) {
                format = createDefaultFormat(value);
            }
            const internalFormat = parseFormat(format);
            if (internalFormat.positive.type === "text") {
                return applyTextInternalFormat(value.toString(), internalFormat.positive, formatWidth);
            }
            let formatToApply = internalFormat.positive;
            if (value < 0 && internalFormat.negative) {
                formatToApply = internalFormat.negative;
                value = -value;
            }
            else if (value === 0 && internalFormat.zero) {
                formatToApply = internalFormat.zero;
            }
            if (formatToApply.type === "date") {
                return repeatCharToFitWidth(applyDateTimeFormat(value, formatToApply), formatWidth);
            }
            const isNegative = value < 0;
            const formatted = repeatCharToFitWidth(applyInternalNumberFormat(Math.abs(value), formatToApply, locale), formatWidth);
            return isNegative ? "-" + formatted : formatted;
        case "object": // case value === null
            return "";
    }
}
function applyTextInternalFormat(value, internalFormat, formatWidth) {
    let formattedValue = "";
    for (const token of internalFormat.tokens) {
        switch (token.type) {
            case "TEXT_PLACEHOLDER":
                formattedValue += value;
                break;
            case "CHAR":
            case "STRING":
                formattedValue += token.value;
                break;
            case "REPEATED_CHAR":
                formattedValue += REPEATED_CHAR_PLACEHOLDER + token.value;
                break;
        }
    }
    return repeatCharToFitWidth(formattedValue, formatWidth);
}
function repeatCharToFitWidth(formattedValue, formatWidth) {
    const placeholderIndex = formattedValue.indexOf(REPEATED_CHAR_PLACEHOLDER);
    if (placeholderIndex === -1) {
        return formattedValue;
    }
    const prefix = formattedValue.slice(0, placeholderIndex);
    const suffix = formattedValue.slice(placeholderIndex + REPEATED_CHAR_PLACEHOLDER.length + 1);
    const repeatedChar = formattedValue[placeholderIndex + REPEATED_CHAR_PLACEHOLDER.length];
    function getTimesToRepeat() {
        if (!formatWidth) {
            return { timesToRepeat: 0, padding: "" };
        }
        const widthTaken = formatWidth.measureText(prefix + suffix);
        const charWidth = formatWidth.measureText(repeatedChar);
        const availableWidth = formatWidth.availableWidth - widthTaken;
        if (availableWidth <= 0) {
            return { timesToRepeat: 0, padding: "" };
        }
        const timesToRepeat = Math.floor(availableWidth / charWidth);
        const remainingWidth = availableWidth - timesToRepeat * charWidth;
        const paddingChar = "\u2009"; // thin space
        const paddingWidth = formatWidth.measureText(paddingChar);
        const padding = paddingChar.repeat(Math.floor(remainingWidth / paddingWidth));
        return { timesToRepeat, padding };
    }
    const { timesToRepeat, padding } = getTimesToRepeat();
    return prefix + repeatedChar.repeat(timesToRepeat) + padding + suffix;
}
function applyInternalNumberFormat(value, format, locale) {
    if (value === Infinity) {
        return "∞" + (format.percentSymbols ? "%" : "");
    }
    const multiplier = format.percentSymbols * 2 - format.magnitude * 3;
    value = value * 10 ** multiplier;
    let maxDecimals = 0;
    if (format.decimalPart !== undefined) {
        maxDecimals = format.decimalPart.filter((token) => token.type === "DIGIT").length;
    }
    const { integerDigits, decimalDigits } = splitNumber(Math.abs(value), maxDecimals);
    let formattedValue = applyIntegerFormat(integerDigits, format, format.thousandsSeparator ? locale.thousandsSeparator : undefined);
    if (format.decimalPart !== undefined) {
        formattedValue += locale.decimalSeparator + applyDecimalFormat(decimalDigits || "", format);
    }
    return formattedValue;
}
function applyIntegerFormat(integerDigits, internalFormat, thousandsSeparator) {
    let tokens = internalFormat.integerPart;
    if (!tokens.some((token) => token.type === "DIGIT")) {
        tokens = [...tokens, { type: "DIGIT", value: "#" }];
    }
    if (integerDigits === "0") {
        integerDigits = "";
    }
    let formattedInteger = "";
    const firstDigitIndex = tokens.findIndex((token) => token.type === "DIGIT");
    let indexInIntegerString = integerDigits.length - 1;
    function appendDigitToFormattedValue(digit, digitType) {
        if (digitType === "0") {
            digit = digit || "0";
        }
        if (!digit)
            return;
        const digitIndex = integerDigits.length - 1 - indexInIntegerString;
        if (thousandsSeparator && digitIndex > 0 && digitIndex % 3 === 0) {
            formattedInteger = digit + thousandsSeparator + formattedInteger;
        }
        else {
            formattedInteger = digit + formattedInteger;
        }
    }
    for (let i = tokens.length - 1; i >= 0; i--) {
        const token = tokens[i];
        switch (token.type) {
            case "DIGIT":
                let digit = integerDigits[indexInIntegerString];
                appendDigitToFormattedValue(digit, token.value);
                indexInIntegerString--;
                // Apply the rest of the integer digits at the first digit character
                if (firstDigitIndex === i) {
                    while (indexInIntegerString >= 0) {
                        appendDigitToFormattedValue(integerDigits[indexInIntegerString], "0");
                        indexInIntegerString--;
                    }
                }
                break;
            case "THOUSANDS_SEPARATOR":
                break;
            case "REPEATED_CHAR":
                formattedInteger = REPEATED_CHAR_PLACEHOLDER + token.value + formattedInteger;
                break;
            default:
                formattedInteger = token.value + formattedInteger;
                break;
        }
    }
    return formattedInteger;
}
function applyDecimalFormat(decimalDigits, internalFormat) {
    if (!internalFormat.decimalPart) {
        return "";
    }
    let formattedDecimals = "";
    let indexInDecimalString = 0;
    for (const token of internalFormat.decimalPart) {
        switch (token.type) {
            case "DIGIT":
                const digit = token.value === "#"
                    ? decimalDigits[indexInDecimalString] || ""
                    : decimalDigits[indexInDecimalString] || "0";
                formattedDecimals += digit;
                indexInDecimalString++;
                break;
            case "THOUSANDS_SEPARATOR":
                break;
            case "REPEATED_CHAR":
                formattedDecimals += REPEATED_CHAR_PLACEHOLDER + token.value;
                break;
            default:
                formattedDecimals += token.value;
                break;
        }
    }
    return formattedDecimals;
}
/**
 * this is a cache that can contains number representation formats
 * from 0 (minimum) to 20 (maximum) digits after the decimal point
 */
const numberRepresentation = [];
/** split a number into two strings that contain respectively:
 * - all digit stored in the integer part of the number
 * - all digit stored in the decimal part of the number
 *
 * The 'maxDecimal' parameter allows to indicate the number of digits to not
 * exceed in the decimal part, in which case digits are rounded.
 *
 **/
function splitNumber(value, maxDecimals = MAX_DECIMAL_PLACES) {
    const asString = value.toString();
    if (asString.includes("e"))
        return splitNumberIntl(value, maxDecimals);
    if (Number.isInteger(value)) {
        return { integerDigits: asString, decimalDigits: undefined };
    }
    const indexOfDot = asString.indexOf(".");
    let integerDigits = asString.substring(0, indexOfDot);
    let decimalDigits = asString.substring(indexOfDot + 1);
    if (maxDecimals === 0) {
        if (Number(decimalDigits[0]) >= 5) {
            integerDigits = (Number(integerDigits) + 1).toString();
        }
        return { integerDigits, decimalDigits: undefined };
    }
    if (decimalDigits.length > maxDecimals) {
        const { integerDigits: roundedIntegerDigits, decimalDigits: roundedDecimalDigits } = limitDecimalDigits(decimalDigits, maxDecimals);
        decimalDigits = roundedDecimalDigits;
        if (roundedIntegerDigits !== "0") {
            integerDigits = (Number(integerDigits) + Number(roundedIntegerDigits)).toString();
        }
    }
    return { integerDigits, decimalDigits: removeTrailingZeroes(decimalDigits || "") };
}
/**
 *  Return the given string minus the trailing "0" characters.
 *
 * @param numberString : a string of integers
 * @returns the numberString, minus the eventual zeroes at the end
 */
function removeTrailingZeroes(numberString) {
    let i = numberString.length - 1;
    while (i >= 0 && numberString[i] === "0") {
        i--;
    }
    return numberString.slice(0, i + 1) || undefined;
}
const leadingZeroesRegexp = /^0+/;
/**
 * Limit the size of the decimal part of a number to the given number of digits.
 */
function limitDecimalDigits(decimalDigits, maxDecimals) {
    let integerDigits = "0";
    let resultDecimalDigits = decimalDigits;
    // Note : we'd want to simply use number.toFixed() to handle the max digits & rounding,
    // but it has very strange behaviour. Ex: 12.345.toFixed(2) => "12.35", but 1.345.toFixed(2) => "1.34"
    let slicedDecimalDigits = decimalDigits.slice(0, maxDecimals);
    const i = maxDecimals;
    if (Number(decimalDigits[i]) < 5) {
        return { integerDigits, decimalDigits: slicedDecimalDigits };
    }
    // round up
    const leadingZeroes = slicedDecimalDigits.match(leadingZeroesRegexp)?.[0] || "";
    const slicedRoundedUp = (Number(slicedDecimalDigits) + 1).toString();
    const withoutLeadingZeroes = slicedDecimalDigits.slice(leadingZeroes.length);
    // e.g. carry over from 99 to 100
    const carryOver = slicedRoundedUp.length > withoutLeadingZeroes.length;
    if (carryOver && !leadingZeroes) {
        integerDigits = "1";
        resultDecimalDigits = undefined;
    }
    else if (carryOver) {
        resultDecimalDigits = leadingZeroes.slice(0, -1) + slicedRoundedUp;
    }
    else {
        resultDecimalDigits = leadingZeroes + slicedRoundedUp;
    }
    return { integerDigits, decimalDigits: resultDecimalDigits };
}
/**
 * Split numbers into decimal/integer digits using Intl.NumberFormat.
 * Supports numbers with a lot of digits that are transformed to scientific notation by
 * number.toString(), but is slow.
 */
function splitNumberIntl(value, maxDecimals = MAX_DECIMAL_PLACES) {
    let formatter = numberRepresentation[maxDecimals];
    if (!formatter) {
        formatter = new Intl.NumberFormat("en-US", {
            maximumFractionDigits: maxDecimals,
            useGrouping: false,
        });
        numberRepresentation[maxDecimals] = formatter;
    }
    const [integerDigits, decimalDigits] = formatter.format(value).split(".");
    return { integerDigits, decimalDigits };
}
/** Convert a number into a string, without scientific notation */
function numberToString(number, decimalSeparator) {
    const { integerDigits, decimalDigits } = splitNumber(number, 20);
    return decimalDigits ? integerDigits + decimalSeparator + decimalDigits : integerDigits;
}
/**
 * Check if the given format is a time, date or date time format. Only check the first part of a multi-part format.
 */
const isDateTimeFormat = memoize(function isDateTimeFormat(format) {
    if (!format) {
        return false;
    }
    try {
        const internalFormat = parseFormat(format);
        return internalFormat.positive.type === "date";
    }
    catch (error) {
        return false;
    }
});
function applyDateTimeFormat(value, internalFormat) {
    const jsDate = numberToJsDate(value);
    const isMeridian = internalFormat.tokens.some((token) => token.type === "DATE_PART" && token.value === "a");
    let currentValue = "";
    for (const token of internalFormat.tokens) {
        switch (token.type) {
            case "DATE_PART":
                currentValue += formatJSDatePart(jsDate, token.value, isMeridian);
                break;
            case "REPEATED_CHAR":
                currentValue += REPEATED_CHAR_PLACEHOLDER + token.value;
                break;
            default:
                currentValue += token.value;
                break;
        }
    }
    return currentValue;
}
function formatJSDatePart(jsDate, tokenValue, isMeridian) {
    switch (tokenValue) {
        case "d":
            return jsDate.getDate();
        case "dd":
            return jsDate.getDate().toString().padStart(2, "0");
        case "ddd":
            return DAYS$1[jsDate.getDay()].slice(0, 3);
        case "dddd":
            // force translation because somehow node 22 doesn't call LazyTranslatedString.toString() whe concatenating it to a string
            return DAYS$1[jsDate.getDay()].toString();
        case "m":
            return jsDate.getMonth() + 1;
        case "mm":
            return String(jsDate.getMonth() + 1).padStart(2, "0");
        case "mmm":
            return MONTHS[jsDate.getMonth()].slice(0, 3);
        case "mmmm":
            return MONTHS[jsDate.getMonth()].toString();
        case "mmmmm":
            return MONTHS[jsDate.getMonth()].slice(0, 1);
        case "qq":
            return _t("Q%(quarter)s", { quarter: jsDate.getQuarter() }).toString();
        case "qqqq":
            return _t("Quarter %(quarter)s", { quarter: jsDate.getQuarter() }).toString();
        case "yy":
            const fullYear = String(jsDate.getFullYear()).replace("-", "").padStart(2, "0");
            return fullYear.slice(fullYear.length - 2);
        case "yyyy":
            return jsDate.getFullYear();
        case "hhhh":
            const elapsedHours = Math.floor((jsDate.getTime() - INITIAL_1900_DAY.getTime()) / (60 * 60 * 1000));
            return elapsedHours.toString();
        case "hh":
            const dateHours = jsDate.getHours();
            let hours = dateHours;
            if (isMeridian) {
                hours = hours === 0 ? 12 : hours > 12 ? hours - 12 : hours;
            }
            return hours.toString().padStart(2, "0");
        case "MM": // "MM" replaces "mm" for minutes during format parsing
            return jsDate.getMinutes().toString().padStart(2, "0");
        case "ss":
            return jsDate.getSeconds().toString().padStart(2, "0");
        case "a":
            return jsDate.getHours() >= 12 ? "PM" : "AM";
        default:
            throw new Error(`invalid date format token: ${tokenValue}`);
    }
}
/**
 * Get a regex matching decimal number based on the locale's thousand separator
 *
 * eg. if the locale's thousand separator is a comma, this will return a regex /[0-9]+,[0-9]/
 */
const getDecimalNumberRegex = memoize(function getDecimalNumberRegex(locale) {
    return new RegExp(`[0-9]+${escapeRegExp(locale.decimalSeparator)}[0-9]`);
});
// -----------------------------------------------------------------------------
// CREATE / MODIFY FORMAT
// -----------------------------------------------------------------------------
/**
 * Create a default format for a number.
 *
 * If possible this will try round the number to have less than DEFAULT_FORMAT_NUMBER_OF_DIGITS characters
 * in the number. This is obviously only possible for number with a big decimal part. For number with a lot
 * of digits in the integer part, keep the number as it is.
 */
function createDefaultFormat(value) {
    let { integerDigits, decimalDigits } = splitNumber(value);
    if (!decimalDigits)
        return "0";
    const digitsInIntegerPart = integerDigits.replace("-", "").length;
    // If there's no space for at least the decimal separator + a decimal digit, don't display decimals
    if (digitsInIntegerPart + 2 > DEFAULT_FORMAT_NUMBER_OF_DIGITS) {
        return "0";
    }
    // -1 for the decimal separator character
    const spaceForDecimalsDigits = DEFAULT_FORMAT_NUMBER_OF_DIGITS - digitsInIntegerPart - 1;
    ({ decimalDigits } = splitNumber(value, Math.min(spaceForDecimalsDigits, decimalDigits.length)));
    return decimalDigits ? "0." + "0".repeat(decimalDigits.length) : "0";
}
function detectDateFormat(content, locale) {
    if (!isDateTime(content, locale)) {
        return undefined;
    }
    const internalDate = parseDateTime(content, locale);
    return internalDate.format;
}
/** use this function only if the content corresponds to a number (means that isNumber(content) return true */
function detectNumberFormat(content) {
    const digitBase = content.includes(".") ? "0.00" : "0";
    const matchedCurrencies = content.match(/[\$€]/);
    if (matchedCurrencies) {
        const matchedFirstDigit = content.match(/[\d]/);
        const currency = "[$" + matchedCurrencies.values().next().value + "]";
        if (matchedFirstDigit.index < matchedCurrencies.index) {
            return "#,##" + digitBase + currency;
        }
        return currency + "#,##" + digitBase;
    }
    if (content.includes("%")) {
        return digitBase + "%";
    }
    return undefined;
}
function createCurrencyFormat(currency) {
    const decimalPlaces = currency.decimalPlaces ?? 2;
    const position = currency.position ?? "before";
    const code = currency.code ?? "";
    const symbol = currency.symbol ?? "";
    const decimalRepresentation = decimalPlaces ? "." + "0".repeat(decimalPlaces) : "";
    const numberFormat = "#,##0" + decimalRepresentation;
    let textExpression = `${code} ${symbol}`.trim();
    if (position === "after" && code) {
        textExpression = " " + textExpression;
    }
    return insertTextInFormat(textExpression, position, numberFormat);
}
function createAccountingFormat(currency) {
    const decimalPlaces = currency.decimalPlaces ?? 2;
    const position = currency.position ?? "before";
    const code = currency.code ?? "";
    const symbol = currency.symbol ?? "";
    const decimalRepresentation = decimalPlaces ? "." + "0".repeat(decimalPlaces) : "";
    const numberFormat = "#,##0" + decimalRepresentation;
    let textExpression = `${code} ${symbol}`.trim();
    if (position === "after" && code) {
        textExpression = " " + textExpression;
    }
    const positivePart = insertTextInAccountingFormat(textExpression, position, ` ${numberFormat} `);
    const negativePart = insertTextInAccountingFormat(textExpression, position, `(${numberFormat})`);
    const zeroPart = insertTextInAccountingFormat(textExpression, position, "  -  ");
    return [positivePart, negativePart, zeroPart].join(";");
}
function insertTextInAccountingFormat(text, position, format) {
    const textExpression = `[$${text}]`;
    return position === "before" ? textExpression + "* " + format : format + "* " + textExpression;
}
function insertTextInFormat(text, position, format) {
    const textExpression = `[$${text}]`;
    return position === "before" ? textExpression + format : format + textExpression;
}
function roundFormat(format) {
    const multiPartFormat = parseFormat(format);
    const roundedInternalFormat = {
        positive: _roundFormat(multiPartFormat.positive),
        negative: multiPartFormat.negative ? _roundFormat(multiPartFormat.negative) : undefined,
        zero: multiPartFormat.zero ? _roundFormat(multiPartFormat.zero) : undefined,
        text: multiPartFormat.text,
    };
    return convertInternalFormatToFormat(roundedInternalFormat);
}
function _roundFormat(internalFormat) {
    if (internalFormat.type !== "number" || !internalFormat.decimalPart) {
        return internalFormat;
    }
    const nonDigitDecimalPart = internalFormat.decimalPart.filter((token) => token.type !== "DIGIT");
    return {
        ...internalFormat,
        decimalPart: undefined,
        integerPart: [...internalFormat.integerPart, ...nonDigitDecimalPart],
    };
}
function humanizeNumber({ value, format }, locale) {
    const numberFormat = formatLargeNumber({
        value,
        format,
    }, undefined, locale);
    return formatValue(value, { format: numberFormat, locale });
}
function formatLargeNumber(arg, unit, locale) {
    let value = 0;
    try {
        value = Math.abs(toNumber(arg?.value, locale));
    }
    catch (e) {
        return "";
    }
    const format = arg?.format;
    if (unit !== undefined) {
        const postFix = unit?.value;
        switch (postFix) {
            case "k":
                return createLargeNumberFormat(format, 1, "k");
            case "m":
                return createLargeNumberFormat(format, 2, "m");
            case "b":
                return createLargeNumberFormat(format, 3, "b");
            default:
                throw new EvaluationError(_t("The formatting unit should be 'k', 'm' or 'b'."));
        }
    }
    if (value < 1e5) {
        return createLargeNumberFormat(format, 0, "");
    }
    else if (value < 1e8) {
        return createLargeNumberFormat(format, 1, "k");
    }
    else if (value < 1e11) {
        return createLargeNumberFormat(format, 2, "m");
    }
    return createLargeNumberFormat(format, 3, "b");
}
function createLargeNumberFormat(format, magnitude, postFix, locale) {
    const multiPartFormat = parseFormat(format || "#,##0");
    const roundedInternalFormat = {
        positive: _createLargeNumberFormat(multiPartFormat.positive, magnitude, postFix),
        negative: multiPartFormat.negative
            ? _createLargeNumberFormat(multiPartFormat.negative, magnitude, postFix)
            : undefined,
        zero: multiPartFormat.zero
            ? _createLargeNumberFormat(multiPartFormat.zero, magnitude, postFix)
            : undefined,
        text: multiPartFormat.text,
    };
    return convertInternalFormatToFormat(roundedInternalFormat);
}
function _createLargeNumberFormat(format, magnitude, postFix) {
    if (format.type !== "number") {
        return format;
    }
    const postFixToken = { type: "STRING", value: postFix };
    let newIntegerPart = [...format.integerPart];
    const lastDigitIndex = newIntegerPart.findLastIndex((token) => token.type === "DIGIT");
    if (lastDigitIndex === -1) {
        throw new Error("Cannot create a large number format from a format with no digit.");
    }
    while (newIntegerPart[lastDigitIndex + 1]?.type === "THOUSANDS_SEPARATOR") {
        newIntegerPart = removeIndexesFromArray(newIntegerPart, [lastDigitIndex + 1]);
    }
    const tokenAfterDigits = newIntegerPart[lastDigitIndex + 1];
    if (tokenAfterDigits?.type === "STRING" && ["m", "k", "b"].includes(tokenAfterDigits.value)) {
        newIntegerPart = replaceItemAtIndex(newIntegerPart, postFixToken, lastDigitIndex + 1);
    }
    else {
        newIntegerPart = insertItemsAtIndex(newIntegerPart, [postFixToken], lastDigitIndex + 1);
    }
    if (magnitude > 0) {
        newIntegerPart = insertItemsAtIndex(newIntegerPart, Array(magnitude).fill({ type: "THOUSANDS_SEPARATOR", value: "," }), lastDigitIndex + 1);
    }
    const missingPercents = format.percentSymbols - newIntegerPart.filter((tk) => tk.type === "PERCENT").length;
    newIntegerPart.push(...new Array(missingPercents).fill({ type: "PERCENT", value: "%" }));
    return { ...format, integerPart: newIntegerPart, decimalPart: undefined, magnitude };
}
function changeDecimalPlaces(format, step) {
    const multiPartFormat = parseFormat(format);
    const newInternalFormat = {
        positive: _changeDecimalPlace(multiPartFormat.positive, step),
        negative: multiPartFormat.negative
            ? _changeDecimalPlace(multiPartFormat.negative, step)
            : undefined,
        zero: multiPartFormat.zero ? _changeDecimalPlace(multiPartFormat.zero, step) : undefined,
        text: multiPartFormat.text,
    };
    // Re-parse the format to make sure we don't break the number of digit limit
    return convertInternalFormatToFormat(parseFormat(convertInternalFormatToFormat(newInternalFormat)));
}
function _changeDecimalPlace(format, step) {
    if (format.type !== "number") {
        return format;
    }
    return (step > 0 ? addDecimalPlaces(format, step) : removeDecimalPlaces(format, Math.abs(step)));
}
function removeDecimalPlaces(format, step) {
    let decimalPart = format.decimalPart;
    if (!decimalPart) {
        return format;
    }
    const indexesToRemove = [];
    let digitCount = 0;
    for (let i = decimalPart.length - 1; i >= 0; i--) {
        if (digitCount >= Math.abs(step)) {
            break;
        }
        if (decimalPart[i].type === "DIGIT") {
            digitCount++;
            indexesToRemove.push(i);
        }
    }
    decimalPart = removeIndexesFromArray(decimalPart, indexesToRemove);
    if (decimalPart.some((token) => token.type === "DIGIT")) {
        return { ...format, decimalPart };
    }
    return {
        ...format,
        decimalPart: undefined,
        integerPart: [...format.integerPart, ...decimalPart],
    };
}
function addDecimalPlaces(format, step) {
    let integerPart = format.integerPart;
    let decimalPart = format.decimalPart;
    if (!decimalPart) {
        const lastDigitIndex = integerPart.findLastIndex((token) => token.type === "DIGIT");
        decimalPart = integerPart.slice(lastDigitIndex + 1);
        integerPart = integerPart.slice(0, lastDigitIndex + 1);
    }
    const digitsToAdd = range(0, step).map(() => ({ type: "DIGIT", value: "0" }));
    const lastDigitIndex = decimalPart.findLastIndex((token) => token.type === "DIGIT");
    if (lastDigitIndex === -1) {
        decimalPart = [...digitsToAdd, ...decimalPart];
    }
    else {
        decimalPart = insertItemsAtIndex(decimalPart, digitsToAdd, lastDigitIndex + 1);
    }
    return { ...format, decimalPart, integerPart };
}
function isExcelCompatible(format) {
    const internalFormat = parseFormat(format);
    for (const part of [internalFormat.positive, internalFormat.negative, internalFormat.zero]) {
        if (part &&
            part.type === "date" &&
            part.tokens.some((token) => token.type === "DATE_PART" && token.value.includes("q"))) {
            return false;
        }
    }
    return true;
}
function isTextFormat(format) {
    if (!format)
        return false;
    try {
        const internalFormat = parseFormat(format);
        return internalFormat.positive.type === "text";
    }
    catch {
        return false;
    }
}

function evaluateLiteral(literalCell, localeFormat) {
    const value = isTextFormat(localeFormat.format) ? literalCell.content : literalCell.parsedValue;
    const functionResult = { value, format: localeFormat.format };
    return createEvaluatedCell(functionResult, localeFormat.locale);
}
function parseLiteral(content, locale) {
    if (content.startsWith("=")) {
        throw new Error(`Cannot parse "${content}" because it's not a literal value. It's a formula`);
    }
    if (content === "") {
        return null;
    }
    if (isNumber(content, DEFAULT_LOCALE)) {
        return parseNumber(content, DEFAULT_LOCALE);
    }
    const internalDate = parseDateTime(content, locale);
    if (internalDate) {
        return internalDate.value;
    }
    if (isBoolean(content)) {
        return content.toUpperCase() === "TRUE" ? true : false;
    }
    return content;
}
function createEvaluatedCell(functionResult, locale = DEFAULT_LOCALE, cell) {
    const link = detectLink(functionResult.value);
    if (!link) {
        return _createEvaluatedCell(functionResult, locale, cell);
    }
    const value = parseLiteral(link.label, locale);
    const format = functionResult.format ||
        (typeof value === "number"
            ? detectDateFormat(link.label, locale) || detectNumberFormat(link.label)
            : undefined);
    const linkPayload = {
        value,
        format,
    };
    return {
        ..._createEvaluatedCell(linkPayload, locale, cell),
        link,
    };
}
function _createEvaluatedCell(functionResult, locale, cell) {
    let { value, format, message } = functionResult;
    format = cell?.format || format;
    const formattedValue = formatValue(value, { format, locale });
    if (isEvaluationError(value)) {
        return errorCell(value, message);
    }
    if (isTextFormat(format)) {
        // TO DO:
        // with the next line, the value of the cell is transformed depending on the format.
        // This shouldn't happen, by doing this, the formulas handling numbers are not able
        // to interpret the value as a number.
        return textCell(toString(value), format, formattedValue);
    }
    if (value === null) {
        return emptyCell(format);
    }
    if (typeof value === "number") {
        if (isDateTimeFormat(format || "")) {
            return dateTimeCell(value, format, formattedValue);
        }
        return numberCell(value, format, formattedValue);
    }
    if (typeof value === "boolean") {
        return booleanCell(value, format, formattedValue);
    }
    return textCell(value, format, formattedValue);
}
function textCell(value, format, formattedValue) {
    return {
        value,
        format,
        formattedValue,
        type: CellValueType.text,
        isAutoSummable: true,
        defaultAlign: "left",
    };
}
function numberCell(value, format, formattedValue) {
    return {
        value: value || 0, // necessary to avoid "-0" and NaN values,
        format,
        formattedValue,
        type: CellValueType.number,
        isAutoSummable: true,
        defaultAlign: "right",
    };
}
const emptyCell = memoize(function emptyCell(format) {
    return {
        value: null,
        format,
        formattedValue: "",
        type: CellValueType.empty,
        isAutoSummable: true,
        defaultAlign: "left",
    };
});
function dateTimeCell(value, format, formattedValue) {
    return {
        value,
        format,
        formattedValue,
        type: CellValueType.number,
        isAutoSummable: false,
        defaultAlign: "right",
    };
}
function booleanCell(value, format, formattedValue) {
    return {
        value,
        format,
        formattedValue,
        type: CellValueType.boolean,
        isAutoSummable: false,
        defaultAlign: "center",
    };
}
function errorCell(value, message) {
    return {
        value,
        formattedValue: value,
        message,
        type: CellValueType.error,
        isAutoSummable: false,
        defaultAlign: "center",
    };
}

function toCriterionDateNumber(dateValue) {
    const today = DateTime.now();
    switch (dateValue) {
        case "today":
            return jsDateToNumber(today);
        case "yesterday":
            return jsDateToNumber(DateTime.fromTimestamp(today.setDate(today.getDate() - 1)));
        case "tomorrow":
            return jsDateToNumber(DateTime.fromTimestamp(today.setDate(today.getDate() + 1)));
        case "lastWeek":
            return jsDateToNumber(DateTime.fromTimestamp(today.setDate(today.getDate() - 7)));
        case "lastMonth":
            return jsDateToNumber(DateTime.fromTimestamp(today.setMonth(today.getMonth() - 1)));
        case "lastYear":
            return jsDateToNumber(DateTime.fromTimestamp(today.setFullYear(today.getFullYear() - 1)));
    }
}
/** Get all the dates values of a criterion converted to numbers, converting date values such as "today" to actual dates  */
function getDateNumberCriterionValues(criterion, locale) {
    if ("dateValue" in criterion && criterion.dateValue !== "exactDate") {
        return [toCriterionDateNumber(criterion.dateValue)];
    }
    return criterion.values.map((value) => valueToDateNumber(value, locale));
}
/** Convert the criterion values to numbers. Return undefined values if they cannot be converted to numbers. */
function getCriterionValuesAsNumber(criterion, locale) {
    return criterion.values.map((value) => tryToNumber(value, locale));
}
function getDateCriterionFormattedValues(values, locale) {
    return values.map((valueStr) => {
        if (valueStr.startsWith("=")) {
            return valueStr;
        }
        const value = parseLiteral(valueStr, locale);
        if (typeof value === "number") {
            return formatValue(value, { format: locale.dateFormat, locale });
        }
        return "";
    });
}

const MAX_DELAY = 140;
const MIN_DELAY = 20;
const ACCELERATION = 0.035;
/**
 * Decreasing exponential function used to determine the "speed" of edge-scrolling
 * as the timeout delay.
 *
 * Returns a timeout delay in milliseconds.
 */
function scrollDelay(value) {
    // decreasing exponential from MAX_DELAY to MIN_DELAY
    return MIN_DELAY + (MAX_DELAY - MIN_DELAY) * Math.exp(-ACCELERATION * (value - 1));
}

class RangeImpl {
    getSheetSize;
    _zone;
    parts;
    invalidXc;
    prefixSheet = false;
    sheetId; // the sheet on which the range is defined
    invalidSheetName; // the name of any sheet that is invalid
    constructor(args, getSheetSize) {
        this.getSheetSize = getSheetSize;
        this._zone = args.zone;
        this.prefixSheet = args.prefixSheet;
        this.invalidXc = args.invalidXc;
        this.sheetId = args.sheetId;
        this.invalidSheetName = args.invalidSheetName;
        let _fixedParts = [...args.parts];
        if (args.parts.length === 1 && getZoneArea(this.zone) > 1) {
            _fixedParts.push({ ...args.parts[0] });
        }
        else if (args.parts.length === 2 && getZoneArea(this.zone) === 1) {
            _fixedParts.pop();
        }
        this.parts = _fixedParts;
    }
    static fromRange(range, getters) {
        if (range instanceof RangeImpl) {
            return range;
        }
        return new RangeImpl(range, getters.getSheetSize);
    }
    get unboundedZone() {
        return this._zone;
    }
    get zone() {
        const { left, top, bottom, right } = this._zone;
        if (right !== undefined && bottom !== undefined) {
            return this._zone;
        }
        else if (bottom === undefined && right !== undefined) {
            return { right, top, left, bottom: this.getSheetSize(this.sheetId).numberOfRows - 1 };
        }
        else if (right === undefined && bottom !== undefined) {
            return { bottom, left, top, right: this.getSheetSize(this.sheetId).numberOfCols - 1 };
        }
        throw new Error(_t("Bad zone format"));
    }
    static getRangeParts(xc, zone) {
        const parts = xc.split(":").map((p) => {
            const isFullRow = isRowReference(p);
            return {
                colFixed: isFullRow ? false : p.startsWith("$"),
                rowFixed: isFullRow ? p.startsWith("$") : p.includes("$", 1),
            };
        });
        const isFullCol = zone.bottom === undefined;
        const isFullRow = zone.right === undefined;
        if (isFullCol) {
            parts[0].rowFixed = parts[0].rowFixed || parts[1].rowFixed;
            parts[1].rowFixed = parts[0].rowFixed || parts[1].rowFixed;
        }
        if (isFullRow) {
            parts[0].colFixed = parts[0].colFixed || parts[1].colFixed;
            parts[1].colFixed = parts[0].colFixed || parts[1].colFixed;
        }
        return parts;
    }
    get isFullCol() {
        return this._zone.bottom === undefined;
    }
    get isFullRow() {
        return this._zone.right === undefined;
    }
    get rangeData() {
        return {
            _zone: this._zone,
            _sheetId: this.sheetId,
        };
    }
    /**
     * Check that a zone is valid regarding the order of top-bottom and left-right.
     * Left should be smaller than right, top should be smaller than bottom.
     * If it's not the case, simply invert them, and invert the linked parts
     */
    orderZone() {
        if (isZoneOrdered(this._zone)) {
            return this;
        }
        const zone = { ...this._zone };
        let parts = this.parts;
        if (zone.right !== undefined && zone.right < zone.left) {
            let right = zone.right;
            zone.right = zone.left;
            zone.left = right;
            parts = [
                {
                    colFixed: parts[1]?.colFixed || false,
                    rowFixed: parts[0]?.rowFixed || false,
                },
                {
                    colFixed: parts[0]?.colFixed || false,
                    rowFixed: parts[1]?.rowFixed || false,
                },
            ];
        }
        if (zone.bottom !== undefined && zone.bottom < zone.top) {
            let bottom = zone.bottom;
            zone.bottom = zone.top;
            zone.top = bottom;
            parts = [
                {
                    colFixed: parts[0]?.colFixed || false,
                    rowFixed: parts[1]?.rowFixed || false,
                },
                {
                    colFixed: parts[1]?.colFixed || false,
                    rowFixed: parts[0]?.rowFixed || false,
                },
            ];
        }
        return this.clone({ zone, parts });
    }
    /**
     *
     * @param rangeParams optional, values to put in the cloned range instead of the current values of the range
     */
    clone(rangeParams) {
        return new RangeImpl({
            zone: rangeParams?.zone ? rangeParams.zone : { ...this._zone },
            sheetId: rangeParams?.sheetId ? rangeParams.sheetId : this.sheetId,
            invalidSheetName: rangeParams && "invalidSheetName" in rangeParams // 'attr in obj' instead of just 'obj.attr' because we accept undefined values
                ? rangeParams.invalidSheetName
                : this.invalidSheetName,
            invalidXc: rangeParams && "invalidXc" in rangeParams ? rangeParams.invalidXc : this.invalidXc,
            parts: rangeParams?.parts
                ? rangeParams.parts
                : this.parts.map((part) => {
                    return { rowFixed: part.rowFixed, colFixed: part.colFixed };
                }),
            prefixSheet: rangeParams?.prefixSheet !== undefined ? rangeParams.prefixSheet : this.prefixSheet,
        }, this.getSheetSize);
    }
}
/**
 * Copy a range. If the range is on the sheetIdFrom, the range will target
 * sheetIdTo.
 */
function copyRangeWithNewSheetId(sheetIdFrom, sheetIdTo, range) {
    const sheetId = range.sheetId === sheetIdFrom ? sheetIdTo : range.sheetId;
    return range.clone({ sheetId });
}
/**
 * Create a range from a xc. If the xc is empty, this function returns undefined.
 */
function createValidRange(getters, sheetId, xc) {
    if (!xc)
        return;
    const range = getters.getRangeFromSheetXC(sheetId, xc);
    return !(range.invalidSheetName || range.invalidXc) ? range : undefined;
}
/**
 * Spread multiple colrows zone to one row/col zone and add a many new input range as needed.
 * For example, A1:B4 will become [A1:A4, B1:B4]
 */
function spreadRange(getters, dataSets) {
    const postProcessedRanges = [];
    for (const dataSet of dataSets) {
        const range = dataSet.dataRange;
        if (!getters.isRangeValid(range)) {
            postProcessedRanges.push(dataSet); // ignore invalid range
            continue;
        }
        const { sheetName } = splitReference(range);
        const sheetPrefix = sheetName ? `${sheetName}!` : "";
        const zone = toUnboundedZone(range);
        if (zone.bottom !== zone.top && zone.left != zone.right) {
            if (zone.right) {
                for (let j = zone.left; j <= zone.right; ++j) {
                    const datasetOptions = j === zone.left ? dataSet : { yAxisId: dataSet.yAxisId };
                    postProcessedRanges.push({
                        ...datasetOptions,
                        dataRange: `${sheetPrefix}${zoneToXc({
                            left: j,
                            right: j,
                            top: zone.top,
                            bottom: zone.bottom,
                        })}`,
                    });
                }
            }
            else {
                for (let j = zone.top; j <= zone.bottom; ++j) {
                    const datasetOptions = j === zone.top ? dataSet : { yAxisId: dataSet.yAxisId };
                    postProcessedRanges.push({
                        ...datasetOptions,
                        dataRange: `${sheetPrefix}${zoneToXc({
                            left: zone.left,
                            right: zone.right,
                            top: j,
                            bottom: j,
                        })}`,
                    });
                }
            }
        }
        else {
            postProcessedRanges.push(dataSet);
        }
    }
    return postProcessedRanges;
}
/**
 * Get all the cell positions in the given ranges. If a cell is in multiple ranges, it will be returned multiple times.
 */
function getCellPositionsInRanges(ranges) {
    const cellPositions = [];
    for (const range of ranges) {
        for (const position of positions(range.zone)) {
            cellPositions.push({ ...position, sheetId: range.sheetId });
        }
    }
    return cellPositions;
}

/** Methods from Odoo Web Utils  */
/**
 * This function computes a score that represent the fact that the
 * string contains the pattern, or not
 *
 * - If the score is 0, the string does not contain the letters of the pattern in
 *   the correct order.
 * - if the score is > 0, it actually contains the letters.
 *
 * Better matches will get a higher score: consecutive letters are better,
 * and a match closer to the beginning of the string is also scored higher.
 */
function fuzzyMatch(pattern, str) {
    pattern = pattern.toLocaleLowerCase();
    str = str.toLocaleLowerCase();
    let totalScore = 0;
    let currentScore = 0;
    let len = str.length;
    let patternIndex = 0;
    for (let i = 0; i < len; i++) {
        if (str[i] === pattern[patternIndex]) {
            patternIndex++;
            currentScore += 100 + currentScore - i / 200;
        }
        else {
            currentScore = 0;
        }
        totalScore = totalScore + currentScore;
    }
    return patternIndex === pattern.length ? totalScore : 0;
}
/**
 * Return a list of things that matches a pattern, ordered by their 'score' (
 * higher score first). An higher score means that the match is better. For
 * example, consecutive letters are considered a better match.
 */
function fuzzyLookup(pattern, list, fn) {
    const results = [];
    list.forEach((data) => {
        const score = fuzzyMatch(pattern, fn(data));
        if (score > 0) {
            results.push({ score, elem: data });
        }
    });
    // we want better matches first
    results.sort((a, b) => b.score - a.score);
    return results.map((r) => r.elem);
}

function createDefaultRows(rowNumber) {
    const rows = [];
    for (let i = 0; i < rowNumber; i++) {
        const row = {
            cells: {},
        };
        rows.push(row);
    }
    return rows;
}
function moveHeaderIndexesOnHeaderAddition(indexHeaderAdded, numberAdded, headers) {
    return headers.map((header) => {
        if (header >= indexHeaderAdded) {
            return header + numberAdded;
        }
        return header;
    });
}
function moveHeaderIndexesOnHeaderDeletion(deletedHeaders, headers) {
    deletedHeaders = [...deletedHeaders].sort((a, b) => b - a);
    return headers
        .map((header) => {
        for (const deletedHeader of deletedHeaders) {
            if (header > deletedHeader) {
                header--;
            }
            else if (header === deletedHeader) {
                return undefined;
            }
        }
        return header;
    })
        .filter(isDefined);
}

function computeTextLinesHeight(textLineHeight, numberOfLines = 1) {
    return numberOfLines * (textLineHeight + MIN_CELL_TEXT_MARGIN) - MIN_CELL_TEXT_MARGIN;
}
/**
 * Get the default height of the cell given its style.
 */
function getDefaultCellHeight(ctx, cell, colSize) {
    if (!cell || (!cell.isFormula && !cell.content)) {
        return DEFAULT_CELL_HEIGHT;
    }
    const maxWidth = cell.style?.wrapping === "wrap" ? colSize - 2 * MIN_CELL_TEXT_MARGIN : undefined;
    const numberOfLines = cell.isFormula
        ? 1
        : splitTextToWidth(ctx, cell.content, cell.style, maxWidth).length;
    const fontSize = computeTextFontSizeInPixels(cell.style);
    return computeTextLinesHeight(fontSize, numberOfLines) + 2 * PADDING_AUTORESIZE_VERTICAL;
}
function getDefaultContextFont(fontSize, bold = false, italic = false) {
    const italicStr = italic ? "italic" : "";
    const weight = bold ? "bold" : "";
    return `${italicStr} ${weight} ${fontSize}px ${DEFAULT_FONT}`;
}
const textWidthCache = {};
function computeTextWidth(context, text, style, fontUnit = "pt") {
    const font = computeTextFont(style, fontUnit);
    context.save();
    context.font = font;
    const width = computeCachedTextWidth(context, text);
    context.restore();
    return width;
}
function computeCachedTextWidth(context, text) {
    const font = context.font;
    if (!textWidthCache[font]) {
        textWidthCache[font] = {};
    }
    if (textWidthCache[font][text] === undefined) {
        const textWidth = context.measureText(text).width;
        textWidthCache[font][text] = textWidth;
    }
    return textWidthCache[font][text];
}
const textDimensionsCache = {};
function computeTextDimension(context, text, style, fontUnit = "pt") {
    const font = computeTextFont(style, fontUnit);
    context.save();
    context.font = font;
    const dimensions = computeCachedTextDimension(context, text);
    context.restore();
    return dimensions;
}
function computeCachedTextDimension(context, text) {
    const font = context.font;
    if (!textDimensionsCache[font]) {
        textDimensionsCache[font] = {};
    }
    if (textDimensionsCache[font][text] === undefined) {
        const measure = context.measureText(text);
        const width = measure.width;
        const height = measure.fontBoundingBoxAscent + measure.fontBoundingBoxDescent;
        textDimensionsCache[font][text] = { width, height };
    }
    return textDimensionsCache[font][text];
}
function fontSizeInPixels(fontSize) {
    return Math.round((fontSize * 96) / 72);
}
function computeTextFont(style, fontUnit = "pt") {
    const italic = style.italic ? "italic " : "";
    const weight = style.bold ? "bold" : DEFAULT_FONT_WEIGHT;
    const size = fontUnit === "pt" ? computeTextFontSizeInPixels(style) : style.fontSize;
    return `${italic}${weight} ${size ?? DEFAULT_FONT_SIZE}px ${DEFAULT_FONT}`;
}
function computeTextFontSizeInPixels(style) {
    const sizeInPt = style?.fontSize || DEFAULT_FONT_SIZE;
    return fontSizeInPixels(sizeInPt);
}
function splitWordToSpecificWidth(ctx, word, width, style) {
    const wordWidth = computeTextWidth(ctx, word, style);
    if (wordWidth <= width) {
        return [word];
    }
    const splitWord = [];
    let wordPart = "";
    for (let l of word) {
        const wordPartWidth = computeTextWidth(ctx, wordPart + l, style);
        if (wordPartWidth > width) {
            splitWord.push(wordPart);
            wordPart = l;
        }
        else {
            wordPart += l;
        }
    }
    splitWord.push(wordPart);
    return splitWord;
}
/**
 * Return the given text, split in multiple lines if needed. The text will be split in multiple
 * line if it contains NEWLINE characters, or if it's longer than the given width.
 */
function splitTextToWidth(ctx, text, style, width) {
    if (!style)
        style = {};
    const brokenText = [];
    // Checking if text contains NEWLINE before split makes it very slightly slower if text contains it,
    // but 5-10x faster if it doesn't
    const lines = text.includes(NEWLINE) ? text.split(NEWLINE) : [text];
    for (const line of lines) {
        const words = line.includes(" ") ? line.split(" ") : [line];
        if (!width) {
            brokenText.push(line);
            continue;
        }
        let textLine = "";
        let availableWidth = width;
        for (let word of words) {
            const splitWord = splitWordToSpecificWidth(ctx, word, width, style);
            const lastPart = splitWord.pop();
            const lastPartWidth = computeTextWidth(ctx, lastPart, style);
            // At this step: "splitWord" is an array composed of parts of word whose
            // length is at most equal to "width".
            // Last part contains the end of the word.
            // Note that: When word length is less than width, then lastPart is equal
            // to word and splitWord is empty
            if (splitWord.length) {
                if (textLine !== "") {
                    brokenText.push(textLine);
                    textLine = "";
                    availableWidth = width;
                }
                splitWord.forEach((wordPart) => {
                    brokenText.push(wordPart);
                });
                textLine = lastPart;
                availableWidth = width - lastPartWidth;
            }
            else {
                // here "lastPart" is equal to "word" and the "word" size is smaller than "width"
                const _word = textLine === "" ? lastPart : " " + lastPart;
                const wordWidth = computeTextWidth(ctx, _word, style);
                if (wordWidth <= availableWidth) {
                    textLine += _word;
                    availableWidth -= wordWidth;
                }
                else {
                    brokenText.push(textLine);
                    textLine = lastPart;
                    availableWidth = width - lastPartWidth;
                }
            }
        }
        if (textLine !== "") {
            brokenText.push(textLine);
        }
    }
    return brokenText;
}
/**
 * Return the font size that makes the width of a text match the given line width.
 * Minimum font size is 1.
 *
 * @param getTextWidth function that takes a fontSize as argument, and return the width of the text with this font size.
 */
function getFontSizeMatchingWidth(lineWidth, maxFontSize, getTextWidth, precision = 0.25) {
    let minFontSize = 1;
    if (getTextWidth(minFontSize) > lineWidth)
        return minFontSize;
    if (getTextWidth(maxFontSize) < lineWidth)
        return maxFontSize;
    // Dichotomic search
    let fontSize = (minFontSize + maxFontSize) / 2;
    let currentTextWidth = getTextWidth(fontSize);
    // Use a maximum number of iterations to be safe, because measuring text isn't 100% precise
    let iterations = 0;
    while (Math.abs(currentTextWidth - lineWidth) > precision && iterations < 20) {
        if (currentTextWidth >= lineWidth) {
            maxFontSize = (minFontSize + maxFontSize) / 2;
        }
        else {
            minFontSize = (minFontSize + maxFontSize) / 2;
        }
        fontSize = (minFontSize + maxFontSize) / 2;
        currentTextWidth = getTextWidth(fontSize);
        iterations++;
    }
    return fontSize;
}
function computeIconWidth(style) {
    return computeTextFontSizeInPixels(style) + 2 * MIN_CF_ICON_MARGIN;
}
/** Transform a string to lower case. If the string is undefined, return an empty string */
function toLowerCase(str) {
    return str ? str.toLowerCase() : "";
}
/**
 * Extract the fontSize from a context font string
 * @param font The (context) font string to parse
 * @returns The fontSize in pixels
 */
const pxRegex = /([0-9\.]*)px/;
function getContextFontSize(font) {
    return Number(font.match(pxRegex)?.[1]);
}
// Inspired from https://stackoverflow.com/a/10511598
function clipTextWithEllipsis(ctx, text, maxWidth) {
    let width = computeCachedTextWidth(ctx, text);
    if (width <= maxWidth) {
        return text;
    }
    const ellipsis = "…";
    const ellipsisWidth = computeCachedTextWidth(ctx, ellipsis);
    if (width <= ellipsisWidth) {
        return text;
    }
    let len = text.length;
    while (width >= maxWidth - ellipsisWidth && len-- > 0) {
        text = text.substring(0, len);
        width = computeCachedTextWidth(ctx, text);
    }
    return text + ellipsis;
}
function drawDecoratedText(context, text, position, underline = false, strikethrough = false, strokeWidth = getContextFontSize(context.font) / 10 //This value is defined to get a good looking stroke
) {
    context.fillText(text, position.x, position.y);
    if (!underline && !strikethrough) {
        return;
    }
    const measure = context.measureText(text);
    const textWidth = measure.width;
    const textHeight = measure.actualBoundingBoxAscent + measure.actualBoundingBoxDescent;
    const boxHeight = measure.fontBoundingBoxAscent + measure.fontBoundingBoxDescent;
    let { x, y } = position;
    let strikeY = y, underlineY = y;
    switch (context.textAlign) {
        case "center":
            x -= textWidth / 2;
            break;
        case "right":
            x -= textWidth;
            break;
    }
    switch (context.textBaseline) {
        case "top":
            underlineY += boxHeight - 2 * strokeWidth;
            strikeY += boxHeight / 2 - strokeWidth;
            break;
        case "middle":
            underlineY += boxHeight / 2 - strokeWidth;
            break;
        case "alphabetic":
            underlineY += 2 * strokeWidth;
            strikeY -= 3 * strokeWidth;
            break;
        case "bottom":
            underlineY = y;
            strikeY -= textHeight / 2 - strokeWidth / 2;
            break;
    }
    if (underline) {
        context.lineWidth = strokeWidth;
        context.strokeStyle = context.fillStyle;
        context.beginPath();
        context.moveTo(x, underlineY);
        context.lineTo(x + textWidth, underlineY);
        context.stroke();
    }
    if (strikethrough) {
        context.lineWidth = strokeWidth;
        context.strokeStyle = context.fillStyle;
        context.beginPath();
        context.moveTo(x, strikeY);
        context.lineTo(x + textWidth, strikeY);
        context.stroke();
    }
}

/*
 * https://stackoverflow.com/questions/105034/create-guid-uuid-in-javascript
 * */
class UuidGenerator {
    isFastIdStrategy = false;
    fastIdStart = 0;
    setIsFastStrategy(isFast) {
        this.isFastIdStrategy = isFast;
    }
    /**
     * Generates a custom UUID using a simple 36^12 method (8-character alphanumeric string with lowercase letters)
     * This has a higher chance of collision than a UUIDv4, but not only faster to generate than an UUIDV4,
     * it also has a smaller size, which is preferable to alleviate the overall data size.
     *
     * This method is preferable when generating uuids for the core data (sheetId, figureId, etc)
     * as they will appear several times in the revisions and local history.
     *
     */
    smallUuid() {
        if (this.isFastIdStrategy) {
            this.fastIdStart++;
            return String(this.fastIdStart);
        }
        else if (window.crypto) {
            return "10000000-1000".replace(/[01]/g, (c) => {
                const n = Number(c);
                return (n ^ (crypto.getRandomValues(new Uint8Array(1))[0] & (15 >> (n / 4)))).toString(16);
            });
        }
        else {
            // mainly for jest and other browsers that do not have the crypto functionality
            return "xxxxxxxx-xxxx".replace(/[xy]/g, function (c) {
                var r = (Math.random() * 16) | 0, v = c == "x" ? r : (r & 0x3) | 0x8;
                return v.toString(16);
            });
        }
    }
    /**
     * Generates an UUIDV4, has astronomically low chance of collision, but is larger in size than the smallUuid.
     * This method should be used when you need to avoid collisions at all costs, like the id of a revision.
     */
    uuidv4() {
        if (this.isFastIdStrategy) {
            this.fastIdStart++;
            return String(this.fastIdStart);
        }
        else if (window.crypto) {
            return "10000000-1000-4000-8000-100000000000".replace(/[018]/g, (c) => {
                const n = Number(c);
                return (n ^ (crypto.getRandomValues(new Uint8Array(1))[0] & (15 >> (n / 4)))).toString(16);
            });
        }
        else {
            // mainly for jest and other browsers that do not have the crypto functionality
            return "xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx".replace(/[xy]/g, function (c) {
                var r = (Math.random() * 16) | 0, v = c == "x" ? r : (r & 0x3) | 0x8;
                return v.toString(16);
            });
        }
    }
}

function getClipboardDataPositions(sheetId, zones) {
    const lefts = new Set(zones.map((z) => z.left));
    const rights = new Set(zones.map((z) => z.right));
    const tops = new Set(zones.map((z) => z.top));
    const bottoms = new Set(zones.map((z) => z.bottom));
    const areZonesCompatible = (tops.size === 1 && bottoms.size === 1) || (lefts.size === 1 && rights.size === 1);
    // In order to don't paste several times the same cells in intersected zones
    // --> we merge zones that have common cells
    const clippedZones = areZonesCompatible
        ? mergeOverlappingZones(zones)
        : [zones[zones.length - 1]];
    const cellsPosition = clippedZones.map((zone) => positions(zone)).flat();
    const columnsIndexes = [...new Set(cellsPosition.map((p) => p.col))].sort((a, b) => a - b);
    const rowsIndexes = [...new Set(cellsPosition.map((p) => p.row))].sort((a, b) => a - b);
    return { sheetId, zones, clippedZones, columnsIndexes, rowsIndexes };
}
/**
 * The clipped zone is copied as many times as it fits in the target.
 * This returns the list of zones where the clipped zone is copy-pasted.
 */
function splitZoneForPaste(selection, splitWidth, splitHeight) {
    const right = Math.max(selection.right - splitWidth + 1, selection.left);
    const bottom = Math.max(selection.bottom - splitHeight + 1, selection.top);
    const zones = [];
    for (let left = selection.left; left <= right; left += splitWidth) {
        for (let top = selection.top; top <= bottom; top += splitHeight) {
            zones.push({
                left,
                top,
                bottom: top + splitHeight - 1,
                right: left + splitWidth - 1,
            });
        }
    }
    return zones;
}
/**
 * Compute the complete zones where to paste the current clipboard
 */
function getPasteZones(target, content) {
    if (!content.length || !content[0].length) {
        return target;
    }
    const width = content[0].length, height = content.length;
    return target.map((t) => splitZoneForPaste(t, width, height)).flat();
}
function parseOSClipboardContent(content) {
    if (!content[ClipboardMIMEType.Html]) {
        return {
            text: content[ClipboardMIMEType.PlainText],
        };
    }
    const htmlDocument = new DOMParser().parseFromString(content[ClipboardMIMEType.Html], "text/html");
    const oSheetClipboardData = htmlDocument
        .querySelector("div")
        ?.getAttribute("data-osheet-clipboard");
    const spreadsheetContent = oSheetClipboardData && JSON.parse(oSheetClipboardData);
    return {
        text: content[ClipboardMIMEType.PlainText],
        data: spreadsheetContent,
    };
}

class ClipboardHandler {
    getters;
    dispatch;
    constructor(getters, dispatch) {
        this.getters = getters;
        this.dispatch = dispatch;
    }
    copy(data) {
        return;
    }
    paste(target, clippedContent, options) { }
    isPasteAllowed(sheetId, target, content, option) {
        return "Success" /* CommandResult.Success */;
    }
    isCutAllowed(data) {
        return "Success" /* CommandResult.Success */;
    }
    getPasteTarget(sheetId, target, content, options) {
        return { zones: [], sheetId };
    }
    convertTextToClipboardData(data) {
        return;
    }
}

class AbstractCellClipboardHandler extends ClipboardHandler {
    copy(data) {
        return;
    }
    pasteFromCopy(sheetId, target, content, options) {
        if (target.length === 1) {
            // in this specific case, due to the isPasteAllowed function:
            // state.cells can contains several cells.
            // So if the target zone is larger than the copied zone,
            // we duplicate each cells as many times as possible to fill the zone.
            for (const zone of getPasteZones(target, content)) {
                this.pasteZone(sheetId, zone.left, zone.top, content, options);
            }
        }
        else {
            // in this case, due to the isPasteAllowed function: state.cells contains
            // only one cell
            for (const zone of recomputeZones(target)) {
                for (let col = zone.left; col <= zone.right; col++) {
                    for (let row = zone.top; row <= zone.bottom; row++) {
                        this.pasteZone(sheetId, col, row, content, options);
                    }
                }
            }
        }
    }
    pasteZone(sheetId, col, row, data, clipboardOptions) { }
}

class BorderClipboardHandler extends AbstractCellClipboardHandler {
    copy(data) {
        const sheetId = data.sheetId;
        if (data.zones.length === 0) {
            return;
        }
        const { rowsIndexes, columnsIndexes } = data;
        const borders = [];
        for (const row of rowsIndexes) {
            const bordersInRow = [];
            for (const col of columnsIndexes) {
                const position = { col, row, sheetId };
                bordersInRow.push(this.getters.getCellBorder(position));
            }
            borders.push(bordersInRow);
        }
        return { borders };
    }
    paste(target, content, options) {
        const sheetId = target.sheetId;
        if (options.pasteOption === "asValue") {
            return;
        }
        const zones = target.zones;
        if (!options.isCutOperation) {
            this.pasteFromCopy(sheetId, zones, content.borders);
        }
        else {
            const { left, top } = zones[0];
            this.pasteZone(sheetId, left, top, content.borders);
        }
    }
    pasteZone(sheetId, col, row, borders) {
        for (const [r, rowBorders] of borders.entries()) {
            for (const [c, originBorders] of rowBorders.entries()) {
                const position = { col: col + c, row: row + r, sheetId };
                this.pasteBorder(originBorders, position);
            }
        }
    }
    /**
     * Paste the border at the given position to the target position
     */
    pasteBorder(originBorders, target) {
        const targetBorders = this.getters.getCellBorder(target);
        const border = {
            ...targetBorders,
            ...originBorders,
        };
        this.dispatch("SET_BORDER", { ...target, border });
    }
}

/**
 * Tokenizer
 *
 * A tokenizer is a piece of code whose job is to transform a string into a list
 * of "tokens". For example, "(12+" is converted into:
 *   [{type: "LEFT_PAREN", value: "("},
 *    {type: "NUMBER", value: "12"},
 *    {type: "OPERATOR", value: "+"}]
 *
 * As the example shows, a tokenizer does not care about the meaning behind those
 * tokens. It only cares about the structure.
 *
 * The tokenizer is usually the first step in a compilation pipeline.  Also, it
 * is useful for the composer, which needs to be able to work with incomplete
 * formulas.
 */
const POSTFIX_UNARY_OPERATORS = ["%"];
const OPERATORS = "+,-,*,/,:,=,<>,>=,>,<=,<,^,&".split(",").concat(POSTFIX_UNARY_OPERATORS);
function tokenize(str, locale = DEFAULT_LOCALE) {
    str = replaceNewLines(str);
    const chars = new TokenizingChars(str);
    const result = [];
    while (!chars.isOver()) {
        let token = tokenizeSpace(chars) ||
            tokenizeArgsSeparator(chars, locale) ||
            tokenizeParenthesis(chars) ||
            tokenizeOperator(chars) ||
            tokenizeString(chars) ||
            tokenizeDebugger(chars) ||
            tokenizeInvalidRange(chars) ||
            tokenizeNumber(chars, locale) ||
            tokenizeSymbol(chars);
        if (!token) {
            token = { type: "UNKNOWN", value: chars.shift() };
        }
        result.push(token);
    }
    return result;
}
function tokenizeDebugger(chars) {
    if (chars.current === "?") {
        chars.shift();
        return { type: "DEBUGGER", value: "?" };
    }
    return null;
}
const parenthesis = {
    "(": { type: "LEFT_PAREN", value: "(" },
    ")": { type: "RIGHT_PAREN", value: ")" },
};
function tokenizeParenthesis(chars) {
    if (chars.current === "(" || chars.current === ")") {
        const value = chars.shift();
        return parenthesis[value];
    }
    return null;
}
function tokenizeArgsSeparator(chars, locale) {
    if (chars.current === locale.formulaArgSeparator) {
        const value = chars.shift();
        const type = "ARG_SEPARATOR";
        return { type, value };
    }
    return null;
}
function tokenizeOperator(chars) {
    for (let op of OPERATORS) {
        if (chars.currentStartsWith(op)) {
            chars.advanceBy(op.length);
            return { type: "OPERATOR", value: op };
        }
    }
    return null;
}
const FIRST_POSSIBLE_NUMBER_CHARS = new Set("0123456789");
function tokenizeNumber(chars, locale) {
    if (!FIRST_POSSIBLE_NUMBER_CHARS.has(chars.current) &&
        chars.current !== locale.decimalSeparator) {
        return null;
    }
    const match = chars.remaining().match(getFormulaNumberRegex(locale.decimalSeparator));
    if (match) {
        chars.advanceBy(match[0].length);
        return { type: "NUMBER", value: match[0] };
    }
    return null;
}
function tokenizeString(chars) {
    if (chars.current === '"') {
        const startChar = chars.shift();
        let letters = startChar;
        while (chars.current && (chars.current !== startChar || letters[letters.length - 1] === "\\")) {
            letters += chars.shift();
        }
        if (chars.current === '"') {
            letters += chars.shift();
        }
        return {
            type: "STRING",
            value: letters,
        };
    }
    return null;
}
const SYMBOL_CHARS = new Set("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789_.!$");
/**
 * A "Symbol" is just basically any word-like element that can appear in a
 * formula, which is not a string. So:
 *   A1
 *   SUM
 *   CEILING.MATH
 *   A$1
 *   Sheet2!A2
 *   'Sheet 2'!A2
 *
 * are examples of symbols
 */
function tokenizeSymbol(chars) {
    let result = "";
    // there are two main cases to manage: either something which starts with
    // a ', like 'Sheet 2'A2, or a word-like element.
    if (chars.current === "'") {
        let lastChar = chars.shift();
        result += lastChar;
        while (chars.current) {
            lastChar = chars.shift();
            result += lastChar;
            if (lastChar === "'") {
                if (chars.current && chars.current === "'") {
                    lastChar = chars.shift();
                    result += lastChar;
                }
                else {
                    break;
                }
            }
        }
        if (lastChar !== "'") {
            return {
                type: "UNKNOWN",
                value: result,
            };
        }
    }
    while (chars.current && SYMBOL_CHARS.has(chars.current)) {
        result += chars.shift();
    }
    if (result.length) {
        const value = result;
        const isReference = rangeReference.test(value);
        if (isReference) {
            return { type: "REFERENCE", value };
        }
        return { type: "SYMBOL", value };
    }
    return null;
}
function tokenizeSpace(chars) {
    let length = 0;
    while (chars.current === NEWLINE) {
        length++;
        chars.shift();
    }
    if (length) {
        return { type: "SPACE", value: NEWLINE.repeat(length) };
    }
    let spaces = "";
    while (chars.current && chars.current.match(whiteSpaceRegexp)) {
        spaces += chars.shift();
    }
    if (spaces) {
        return { type: "SPACE", value: spaces };
    }
    return null;
}
function tokenizeInvalidRange(chars) {
    if (chars.currentStartsWith(CellErrorType.InvalidReference)) {
        chars.advanceBy(CellErrorType.InvalidReference.length);
        return { type: "INVALID_REFERENCE", value: CellErrorType.InvalidReference };
    }
    return null;
}

function isValidLocale(locale) {
    if (!locale ||
        typeof locale !== "object" ||
        !(!locale.thousandsSeparator || typeof locale.thousandsSeparator === "string")) {
        return false;
    }
    for (const property of [
        "code",
        "name",
        "decimalSeparator",
        "dateFormat",
        "timeFormat",
        "formulaArgSeparator",
    ]) {
        if (!locale[property] || typeof locale[property] !== "string") {
            return false;
        }
    }
    if (locale.formulaArgSeparator === locale.decimalSeparator) {
        return false;
    }
    if (locale.thousandsSeparator === locale.decimalSeparator) {
        return false;
    }
    try {
        formatValue(1, { locale, format: "#,##0.00" });
        formatValue(1, { locale, format: locale.dateFormat });
        formatValue(1, { locale, format: locale.timeFormat });
    }
    catch {
        return false;
    }
    return true;
}
/**
 * Change a content string from the given locale to its canonical form (en_US locale). Don't convert date string.
 *
 * @example
 * canonicalizeNumberContent("=SUM(1,5; 02/12/2012)", FR_LOCALE) // "=SUM(1.5, 02/12/2012)"
 * canonicalizeNumberContent("125,9", FR_LOCALE) // "125.9"
 * canonicalizeNumberContent("02/12/2012", FR_LOCALE) // "02/12/2012"
 */
function canonicalizeNumberContent(content, locale) {
    return content.startsWith("=")
        ? canonicalizeFormula$1(content, locale)
        : canonicalizeNumberLiteral(content, locale);
}
/**
 * Change a content string from the given locale to its canonical form (en_US locale). Also convert date string.
 * This is destructive and won't preserve the original format.
 *
 * @example
 * canonicalizeContent("=SUM(1,5; 5)", FR_LOCALE) // "=SUM(1.5, 5)"
 * canonicalizeContent("125,9", FR_LOCALE) // "125.9"
 * canonicalizeContent("02/12/2012", FR_LOCALE) // "12/02/2012"
 * canonicalizeContent("02-12-2012", FR_LOCALE) // "12/02/2012"
 */
function canonicalizeContent(content, locale) {
    return content.startsWith("=")
        ? canonicalizeFormula$1(content, locale)
        : canonicalizeLiteral(content, locale);
}
/**
 * Change a content string from its canonical form (en_US locale) to the given locale. Also convert date string.
 *
 * @example
 * localizeContent("=SUM(1.5, 5)", FR_LOCALE) // "=SUM(1,5; 5)"
 * localizeContent("125.9", FR_LOCALE) // "125,9"
 * localizeContent("12/02/2012", FR_LOCALE) // "02/12/2012"
 */
function localizeContent(content, locale) {
    return content.startsWith("=")
        ? localizeFormula(content, locale)
        : localizeLiteral(content, locale);
}
/** Change a formula to its canonical form (en_US locale) */
function canonicalizeFormula$1(formula, locale) {
    return _localizeFormula$1(formula, locale, DEFAULT_LOCALE);
}
/** Change a formula from the canonical form to the given locale */
function localizeFormula(formula, locale) {
    return _localizeFormula$1(formula, DEFAULT_LOCALE, locale);
}
function _localizeFormula$1(formula, fromLocale, toLocale) {
    if (fromLocale.formulaArgSeparator === toLocale.formulaArgSeparator &&
        fromLocale.decimalSeparator === toLocale.decimalSeparator) {
        return formula;
    }
    const tokens = tokenize(formula, fromLocale);
    let localizedFormula = "";
    for (const token of tokens) {
        if (token.type === "NUMBER") {
            localizedFormula += token.value.replace(fromLocale.decimalSeparator, toLocale.decimalSeparator);
        }
        else if (token.type === "ARG_SEPARATOR") {
            localizedFormula += toLocale.formulaArgSeparator;
        }
        else {
            localizedFormula += token.value;
        }
    }
    return localizedFormula;
}
/**
 * Change a literal string from the given locale to its canonical form (en_US locale). Don't convert date string.
 *
 * @example
 * canonicalizeNumberLiteral("125,9", FR_LOCALE) // "125.9"
 * canonicalizeNumberLiteral("02/12/2012", FR_LOCALE) // "02/12/2012"
 */
function canonicalizeNumberLiteral(content, locale) {
    if (locale.decimalSeparator === "." || !isNumber(content, locale)) {
        return content;
    }
    if (locale.thousandsSeparator) {
        content = content.replaceAll(locale.thousandsSeparator, "");
    }
    return content.replace(locale.decimalSeparator, ".");
}
/**
 * Change a content string from the given locale to its canonical form (en_US locale). Also convert date string.
 * This is destructive and won't preserve the original format.
 *
 * @example
 * canonicalizeLiteral("125,9", FR_LOCALE) // "125.9"
 * canonicalizeLiteral("02/12/2012", FR_LOCALE) // "12/02/2012"
 * canonicalizeLiteral("02-12-2012", FR_LOCALE) // "12/02/2012"
 */
function canonicalizeLiteral(content, locale) {
    if (isDateTime(content, locale)) {
        const dateNumber = toNumber(content, locale);
        let format = DEFAULT_LOCALE.dateFormat;
        if (!Number.isInteger(dateNumber)) {
            format += " " + DEFAULT_LOCALE.timeFormat;
        }
        return formatValue(dateNumber, { locale: DEFAULT_LOCALE, format });
    }
    return canonicalizeNumberLiteral(content, locale);
}
/**
 * Change a literal string from its canonical form (en_US locale) to the given locale. Don't convert date string.
 * This is destructive and won't preserve the original format.
 *
 * @example
 * localizeNumberLiteral("125.9", FR_LOCALE) // "125,9"
 * localizeNumberLiteral("12/02/2012", FR_LOCALE) // "12/02/2012"
 * localizeNumberLiteral("12-02-2012", FR_LOCALE) // "12/02/2012"
 */
function localizeNumberLiteral(literal, locale) {
    if (locale.decimalSeparator === "." || !isNumber(literal, DEFAULT_LOCALE)) {
        return literal;
    }
    const decimalNumberRegex = getDecimalNumberRegex(DEFAULT_LOCALE);
    const localized = literal.replace(decimalNumberRegex, (match) => {
        return match.replace(".", locale.decimalSeparator);
    });
    return localized;
}
/**
 * Change a literal string from its canonical form (en_US locale) to the given locale. Also convert date string.
 *
 * @example
 * localizeLiteral("125.9", FR_LOCALE) // "125,9"
 * localizeLiteral("12/02/2012", FR_LOCALE) // "02/12/2012"
 */
function localizeLiteral(literal, locale) {
    if (isDateTime(literal, DEFAULT_LOCALE)) {
        const dateNumber = toNumber(literal, DEFAULT_LOCALE);
        let format = locale.dateFormat;
        if (!Number.isInteger(dateNumber)) {
            format += " " + locale.timeFormat;
        }
        return formatValue(dateNumber, { locale, format });
    }
    return localizeNumberLiteral(literal, locale);
}
function canonicalizeCFRule(cf, locale) {
    return changeCFRuleLocale(cf, (content) => canonicalizeContent(content, locale));
}
function localizeCFRule(cf, locale) {
    return changeCFRuleLocale(cf, (content) => localizeContent(content, locale));
}
function localizeDataValidationRule(rule, locale) {
    const localizedDVRule = deepCopy(rule);
    localizedDVRule.criterion.values = localizedDVRule.criterion.values.map((content) => localizeContent(content, locale));
    return localizedDVRule;
}
function changeCFRuleLocale(rule, changeContentLocale) {
    rule = deepCopy(rule);
    switch (rule.type) {
        case "CellIsRule":
            // Only change value for number operators
            switch (rule.operator) {
                case "Between":
                case "NotBetween":
                case "Equal":
                case "NotEqual":
                case "GreaterThan":
                case "GreaterThanOrEqual":
                case "LessThan":
                case "LessThanOrEqual":
                    rule.values = rule.values.map((v) => changeContentLocale(v));
                    return rule;
                case "BeginsWith":
                case "ContainsText":
                case "EndsWith":
                case "NotContains":
                case "IsEmpty":
                case "IsNotEmpty":
                    return rule;
            }
        case "DataBarRule":
            return rule;
        case "ColorScaleRule":
            rule.minimum = changeCFRuleThresholdLocale(rule.minimum, changeContentLocale);
            rule.maximum = changeCFRuleThresholdLocale(rule.maximum, changeContentLocale);
            if (rule.midpoint) {
                rule.midpoint = changeCFRuleThresholdLocale(rule.midpoint, changeContentLocale);
            }
            return rule;
        case "IconSetRule":
            rule.lowerInflectionPoint.value = changeContentLocale(rule.lowerInflectionPoint.value);
            rule.upperInflectionPoint.value = changeContentLocale(rule.upperInflectionPoint.value);
            return rule;
    }
}
function changeCFRuleThresholdLocale(threshold, changeContentLocale) {
    if (!threshold?.value) {
        return threshold;
    }
    const value = threshold.type === "formula" ? "=" + threshold.value : threshold.value;
    const modified = changeContentLocale(value);
    const newValue = threshold.type === "formula" ? modified.slice(1) : modified;
    return { ...threshold, value: newValue };
}
function getDateTimeFormat(locale) {
    return locale.dateFormat + " " + locale.timeFormat;
}

/** Change a number string to its canonical form (en_US locale) */
function canonicalizeNumberValue(content, locale) {
    return content.startsWith("=")
        ? canonicalizeFormula(content, locale)
        : canonicalizeNumberLiteral(content, locale);
}
/** Change a formula to its canonical form (en_US locale) */
function canonicalizeFormula(formula, locale) {
    return _localizeFormula(formula, locale, DEFAULT_LOCALE);
}
function _localizeFormula(formula, fromLocale, toLocale) {
    if (fromLocale.formulaArgSeparator === toLocale.formulaArgSeparator &&
        fromLocale.decimalSeparator === toLocale.decimalSeparator) {
        return formula;
    }
    const tokens = tokenize(formula, fromLocale);
    let localizedFormula = "";
    for (const token of tokens) {
        if (token.type === "NUMBER") {
            localizedFormula += token.value.replace(fromLocale.decimalSeparator, toLocale.decimalSeparator);
        }
        else if (token.type === "ARG_SEPARATOR") {
            localizedFormula += toLocale.formulaArgSeparator;
        }
        else {
            localizedFormula += token.value;
        }
    }
    return localizedFormula;
}

function boolAnd(args) {
    let foundBoolean = false;
    let acc = true;
    conditionalVisitBoolean(args, (arg) => {
        foundBoolean = true;
        acc = acc && arg;
        return acc;
    });
    return {
        foundBoolean,
        result: acc,
    };
}
function boolOr(args) {
    let foundBoolean = false;
    let acc = false;
    conditionalVisitBoolean(args, (arg) => {
        foundBoolean = true;
        acc = acc || arg;
        return !acc;
    });
    return {
        foundBoolean,
        result: acc,
    };
}

function sum(values, locale) {
    return reduceNumbers(values, (acc, a) => acc + a, 0, locale);
}
function countUnique(args) {
    return reduceAny(args, (acc, a) => (isDataNonEmpty(a) ? acc.add(a?.value) : acc), new Set()).size;
}

function getUnitMatrix(n) {
    const matrix = Array(n);
    for (let i = 0; i < n; i++) {
        matrix[i] = Array(n).fill(0);
        matrix[i][i] = 1;
    }
    return matrix;
}
/**
 * Invert a matrix and compute its determinant using Gaussian Elimination.
 *
 * The Matrix should be a square matrix, and should be indexed [col][row] instead of the
 * standard mathematical indexing [row][col].
 */
function invertMatrix(M) {
    // Use Gaussian Elimination to calculate the inverse:
    // (1) 'augment' the matrix (left) by the identity (on the right)
    // (2) Turn the matrix on the left into the identity using elementary row operations
    // (3) The matrix on the right becomes the inverse (was the identity matrix)
    //
    // There are 3 elementary row operations:
    // (a) Swap 2 rows. This multiply the determinant by -1.
    // (b) Multiply a row by a scalar. This multiply the determinant by that scalar.
    // (c) Add to a row a multiple of another row. This does not change the determinant.
    if (M.length !== M[0].length) {
        throw new EvaluationError(_t("Function [[FUNCTION_NAME]] invert matrix error, only square matrices are invertible"));
    }
    let determinant = 1;
    const dim = M.length;
    const I = getUnitMatrix(dim);
    const C = M.map((row) => row.slice());
    // Perform elementary row operations
    for (let pivot = 0; pivot < dim; pivot++) {
        let diagonalElement = C[pivot][pivot];
        // if we have a 0 on the diagonal we'll need to swap with a lower row
        if (diagonalElement === 0) {
            //look through every row below the i'th row
            for (let row = pivot + 1; row < dim; row++) {
                //if the ii'th row has a non-0 in the i'th col, swap it with that row
                if (C[pivot][row] != 0) {
                    swapMatrixRows(C, pivot, row);
                    swapMatrixRows(I, pivot, row);
                    determinant *= -1;
                    break;
                }
            }
            diagonalElement = C[pivot][pivot];
            //if it's still 0, matrix isn't invertible
            if (diagonalElement === 0) {
                return { determinant: 0 };
            }
        }
        // Scale this row down by e (so we have a 1 on the diagonal)
        for (let col = 0; col < dim; col++) {
            C[col][pivot] = C[col][pivot] / diagonalElement;
            I[col][pivot] = I[col][pivot] / diagonalElement;
        }
        determinant *= diagonalElement;
        // Subtract a multiple of the current row from ALL of
        // the other rows so that there will be 0's in this column in the
        // rows above and below this one
        for (let row = 0; row < dim; row++) {
            if (row === pivot) {
                continue;
            }
            // We want to change this element to 0
            const e = C[pivot][row];
            // Subtract (the row above(or below) scaled by e) from (the
            // current row) but start at the i'th column and assume all the
            // stuff left of diagonal is 0 (which it should be if we made this
            // algorithm correctly)
            for (let col = 0; col < dim; col++) {
                C[col][row] -= e * C[col][pivot];
                I[col][row] -= e * I[col][pivot];
            }
        }
    }
    // We've done all operations, C should be the identity matrix I should be the inverse
    return { inverted: I, determinant };
}
function swapMatrixRows(matrix, row1, row2) {
    for (let i = 0; i < matrix.length; i++) {
        const tmp = matrix[i][row1];
        matrix[i][row1] = matrix[i][row2];
        matrix[i][row2] = tmp;
    }
}
/**
 * Matrix multiplication of 2 matrices.
 * ex: matrix1 : n x l, matrix2 : m x n => result : m x l
 *
 * Note: we use indexing [col][row] instead of the standard mathematical notation [row][col]
 */
function multiplyMatrices(matrix1, matrix2) {
    if (matrix1.length !== matrix2[0].length) {
        throw new EvaluationError(_t("Cannot multiply matrices : incompatible matrices size."));
    }
    const rowsM1 = matrix1[0].length;
    const colsM2 = matrix2.length;
    const n = matrix1.length;
    const result = Array(colsM2);
    for (let col = 0; col < colsM2; col++) {
        result[col] = Array(rowsM1);
        for (let row = 0; row < rowsM1; row++) {
            let sum = 0;
            for (let k = 0; k < n; k++) {
                sum += matrix1[k][row] * matrix2[col][k];
            }
            result[col][row] = sum;
        }
    }
    return result;
}
/**
 * Return the input if it's a scalar or the first element of the input if it's a matrix.
 */
function toScalar(matrix) {
    if (!isMatrix(matrix)) {
        return matrix;
    }
    if (matrix.length !== 1 || matrix[0].length !== 1) {
        throw new EvaluationError(_t("The value should be a scalar or a 1x1 matrix"));
    }
    return matrix[0][0];
}

function assertSameNumberOfElements(...args) {
    const dims = args[0].length;
    args.forEach((arg, i) => assert(() => arg.length === dims, _t("[[FUNCTION_NAME]] has mismatched dimensions for argument %s (%s vs %s).", i.toString(), dims.toString(), arg.length.toString())));
}
function average(values, locale) {
    let count = 0;
    const sum = reduceNumbers(values, (acc, a) => {
        count += 1;
        return acc + a;
    }, 0, locale);
    assertNotZero(count);
    return sum / count;
}
function countNumbers(values, locale) {
    let count = 0;
    for (let n of values) {
        if (isMatrix(n)) {
            for (let i of n) {
                for (let j of i) {
                    if (typeof j.value === "number") {
                        count += 1;
                    }
                }
            }
        }
        else {
            const value = n?.value;
            if (!isEvaluationError(value) &&
                (typeof value !== "string" || isNumber(value, locale) || parseDateTime(value, locale))) {
                count += 1;
            }
        }
    }
    return count;
}
function countAny(values) {
    return reduceAny(values, (acc, a) => (a !== undefined && a.value !== null ? acc + 1 : acc), 0);
}
function max(values, locale) {
    let max = { value: -Infinity };
    visitNumbers(values, (a) => {
        if (a.value >= max.value) {
            max = a;
        }
    }, locale);
    return max.value === -Infinity ? { value: 0 } : max;
}
function min(values, locale) {
    let min = { value: Infinity };
    visitNumbers(values, (a) => {
        if (a.value <= min.value) {
            min = a;
        }
    }, locale);
    return min.value === Infinity ? { value: 0 } : min;
}
function prepareDataForRegression(X, Y, newX) {
    const _X = X[0].length ? X : [range(1, Y.flat().length + 1)];
    const nVar = _X.length;
    let _newX = newX[0].length ? newX : _X;
    _newX = _newX.length === nVar ? transposeMatrix(_newX) : _newX;
    return { _X, _newX };
}
/*
 * This function performs a linear regression on the data set. It returns an array with two elements.
 * The first element is the slope, and the second element is the intercept.
 * The linear regression line is: y = slope*x + intercept
 * The function use the least squares method to find the best fit for the data set :
 * see https://www.mathsisfun.com/data/least-squares-regression.html
 *     https://www.statology.org/standard-error-of-estimate/
 *     https://agronomy4future.org/?p=16670
 *     https://vitalflux.com/interpreting-f-statistics-in-linear-regression-formula-examples/
 *     https://web.ist.utl.pt/~ist11038/compute/errtheory/,regression/regrthroughorigin.pdf
 */
function fullLinearRegression(X, Y, computeIntercept = true, verbose = false) {
    const y = Y.flat();
    const n = y.length;
    let { _X } = prepareDataForRegression(X, Y, [[]]);
    _X = _X.length === n ? transposeMatrix(_X) : _X.slice();
    assertSameNumberOfElements(_X[0], y);
    const nVar = _X.length;
    const nDeg = n - nVar - (computeIntercept ? 1 : 0);
    const yMatrix = [y];
    const xMatrix = transposeMatrix(_X.reverse());
    let avgX = [];
    for (let i = 0; i < nVar; i++) {
        avgX.push(0);
        if (computeIntercept) {
            for (const xij of _X[i]) {
                avgX[i] += xij;
            }
            avgX[i] /= n;
        }
    }
    let avgY = 0;
    if (computeIntercept) {
        for (const yi of y) {
            avgY += yi;
        }
        avgY /= n;
    }
    const redX = xMatrix.map((row) => row.map((value, i) => value - avgX[i]));
    if (computeIntercept) {
        xMatrix.forEach((row) => row.push(1));
    }
    const coeffs = getLMSCoefficients(xMatrix, yMatrix);
    if (!computeIntercept) {
        coeffs.push([0]);
    }
    if (!verbose) {
        return coeffs;
    }
    const dot1 = multiplyMatrices(redX, transposeMatrix(redX));
    const { inverted: dotInv } = invertMatrix(dot1);
    if (dotInv === undefined) {
        throw new EvaluationError(_t("Matrix is not invertible"));
    }
    let SSE = 0, SSR = 0;
    for (let i = 0; i < n; i++) {
        const yi = y[i] - avgY;
        let temp = 0;
        for (let j = 0; j < nVar; j++) {
            const xi = redX[i][j];
            temp += xi * coeffs[j][0];
        }
        const ei = yi - temp;
        SSE += ei * ei;
        SSR += temp * temp;
    }
    const RMSE = Math.sqrt(SSE / nDeg);
    const r2 = SSR / (SSR + SSE);
    const f_stat = SSR / nVar / (SSE / nDeg);
    const deltaCoeffs = [];
    for (let i = 0; i < nVar; i++) {
        deltaCoeffs.push(RMSE * Math.sqrt(dotInv[i][i]));
    }
    if (computeIntercept) {
        const dot2 = multiplyMatrices(dotInv, [avgX]);
        const dot3 = multiplyMatrices(transposeMatrix([avgX]), dot2);
        deltaCoeffs.push(RMSE * Math.sqrt(dot3[0][0] + 1 / y.length));
    }
    const returned = [
        [coeffs[0][0], deltaCoeffs[0], r2, f_stat, SSR],
        [coeffs[1][0], deltaCoeffs[1], RMSE, nDeg, SSE],
    ];
    for (let i = 2; i < nVar; i++) {
        returned.push([coeffs[i][0], deltaCoeffs[i], "", "", ""]);
    }
    if (computeIntercept) {
        returned.push([coeffs[nVar][0], deltaCoeffs[nVar], "", "", ""]);
    }
    else {
        returned.push([0, "", "", "", ""]);
    }
    return returned;
}
/*
  This function performs a polynomial regression on the data set. It returns the coefficients of
  the polynomial function that best fits the data set.
  The polynomial function is: y = c0 + c1*x + c2*x^2 + ... + cn*x^n, where n is the order (degree)
  of the polynomial. The returned coefficients are then in the form: [c0, c1, c2, ..., cn]
  The function is based on the method of least squares :
  see: https://mathworld.wolfram.com/LeastSquaresFittingPolynomial.html
*/
function polynomialRegression(flatY, flatX, order, intercept) {
    assertSameNumberOfElements(flatX, flatY);
    assert(() => order >= 1, _t("Function [[FUNCTION_NAME]] A regression of order less than 1 cannot be possible."));
    const yMatrix = [flatY];
    const xMatrix = flatX.map((x) => range(0, order).map((i) => Math.pow(x, order - i)));
    if (intercept) {
        xMatrix.forEach((row) => row.push(1));
    }
    const coeffs = getLMSCoefficients(xMatrix, yMatrix);
    if (!intercept) {
        coeffs.push([0]);
    }
    return coeffs;
}
function getLMSCoefficients(xMatrix, yMatrix) {
    const xMatrixT = transposeMatrix(xMatrix);
    const dot1 = multiplyMatrices(xMatrix, xMatrixT);
    const { inverted: dotInv } = invertMatrix(dot1);
    if (dotInv === undefined) {
        throw new EvaluationError(_t("Matrix is not invertible"));
    }
    const dot2 = multiplyMatrices(xMatrix, yMatrix);
    return transposeMatrix(multiplyMatrices(dotInv, dot2));
}
function evaluatePolynomial(coeffs, x, order) {
    return coeffs.reduce((acc, coeff, i) => acc + coeff * Math.pow(x, order - i), 0);
}
function expM(M) {
    return M.map((col) => col.map((cell) => Math.exp(cell)));
}
function logM(M) {
    return M.map((col) => col.map((cell) => Math.log(cell)));
}
function predictLinearValues(Y, X, newX, computeIntercept) {
    const { _X, _newX } = prepareDataForRegression(X, Y, newX);
    const coeffs = fullLinearRegression(_X, Y, computeIntercept, false);
    const nVar = coeffs.length - 1;
    const newY = _newX.map((col) => {
        let value = 0;
        for (let i = 0; i < nVar; i++) {
            value += coeffs[i][0] * col[nVar - i - 1];
        }
        value += coeffs[nVar][0];
        return [value];
    });
    return newY.length === newX.length ? newY : transposeMatrix(newY);
}

const PREVIOUS_VALUE = "(previous)";
const NEXT_VALUE = "(next)";
function getDomainOfParentRow(pivot, domain) {
    const { colDomain, rowDomain } = domainToColRowDomain(pivot, domain);
    return [...colDomain, ...rowDomain.slice(0, rowDomain.length - 1)];
}
function getDomainOfParentCol(pivot, domain) {
    const { colDomain, rowDomain } = domainToColRowDomain(pivot, domain);
    return [...colDomain.slice(0, colDomain.length - 1), ...rowDomain];
}
/**
 * Split a pivot domain into the part related to the rows of the pivot, and the part related to the columns.
 */
function domainToColRowDomain(pivot, domain) {
    const rowFields = pivot.definition.rows.map((c) => c.nameWithGranularity);
    const rowDomain = domain.filter((node) => rowFields.includes(node.field));
    const columnFields = pivot.definition.columns.map((c) => c.nameWithGranularity);
    const colDomain = domain.filter((node) => columnFields.includes(node.field));
    return { colDomain, rowDomain };
}
function getDimensionDomain(pivot, dimension, domain) {
    return dimension === "column"
        ? domainToColRowDomain(pivot, domain).colDomain
        : domainToColRowDomain(pivot, domain).rowDomain;
}
function getFieldValueInDomain(fieldNameWithGranularity, domain) {
    const node = domain.find((n) => n.field === fieldNameWithGranularity);
    return node?.value;
}
function isDomainIsInPivot(pivot, domain) {
    const { rowDomain, colDomain } = domainToColRowDomain(pivot, domain);
    return (checkIfDomainInInTree(rowDomain, pivot.getTableStructure().getRowTree()) &&
        checkIfDomainInInTree(colDomain, pivot.getTableStructure().getColTree()));
}
function checkIfDomainInInTree(domain, tree) {
    return walkDomainTree(domain, tree) !== undefined;
}
/**
 * Given a tree of the col/rows of a pivot, and a domain related to those col/rows, return the node of the tree
 * corresponding to the domain.
 *
 * @param domain The domain to find in the tree
 * @param tree The tree to search in7
 * @param stopAtField If provided, the search will stop at the field with this name
 */
function walkDomainTree(domain, tree, stopAtField) {
    let currentTreeNode = tree;
    for (const node of domain) {
        const child = currentTreeNode.find((n) => n.value === node.value);
        if (!child) {
            return undefined;
        }
        if (child.field === stopAtField) {
            return currentTreeNode;
        }
        currentTreeNode = child.children;
    }
    return currentTreeNode;
}
/**
 * Get the domain parent of the given domain with the field `parentFieldName` as leaf of the domain.
 *
 * In practice, if the `parentFieldName` is a row in the pivot, the helper will return a domain with the same column
 * domain, and with a row domain all groupBys children to `parentFieldName` removed.
 */
function getFieldParentDomain(pivot, parentFieldName, domain) {
    let { rowDomain, colDomain } = domainToColRowDomain(pivot, domain);
    const dimension = getFieldDimensionType(pivot, parentFieldName);
    if (dimension === "row") {
        const index = rowDomain.findIndex((node) => node.field === parentFieldName);
        if (index === -1) {
            return domain;
        }
        rowDomain = rowDomain.slice(0, index + 1);
    }
    else {
        const index = colDomain.findIndex((node) => node.field === parentFieldName);
        if (index === -1) {
            return domain;
        }
        colDomain = colDomain.slice(0, index + 1);
    }
    return [...rowDomain, ...colDomain];
}
/**
 * Replace in the domain the value of the field `fieldNameWithGranularity` with the given `value`
 */
function replaceFieldValueInDomain(domain, fieldNameWithGranularity, value) {
    domain = deepCopy(domain);
    const node = domain.find((n) => n.field === fieldNameWithGranularity);
    if (!node) {
        return domain;
    }
    node.value = value;
    return domain;
}
function isFieldInDomain(nameWithGranularity, domain) {
    return domain.some((node) => node.field === nameWithGranularity);
}
/**
 * Check if the field is in the rows or columns of the pivot
 */
function getFieldDimensionType(pivot, nameWithGranularity) {
    const rowFields = pivot.definition.rows.map((c) => c.nameWithGranularity);
    if (rowFields.includes(nameWithGranularity)) {
        return "row";
    }
    const columnFields = pivot.definition.columns.map((c) => c.nameWithGranularity);
    if (columnFields.includes(nameWithGranularity)) {
        return "column";
    }
    throw new Error(`Field ${nameWithGranularity} not found in pivot`);
}
/**
 * Replace in the given domain the value of the field `fieldNameWithGranularity` with the previous or next value.
 */
function getPreviousOrNextValueDomain(pivot, domain, fieldNameWithGranularity, direction) {
    const dimension = getFieldDimensionType(pivot, fieldNameWithGranularity);
    const tree = dimension === "row"
        ? pivot.getTableStructure().getRowTree()
        : pivot.getTableStructure().getColTree();
    const dimDomain = getDimensionDomain(pivot, dimension, domain);
    const currentTreeNode = walkDomainTree(dimDomain, tree, fieldNameWithGranularity);
    const values = currentTreeNode?.map((n) => n.value) ?? [];
    const value = getFieldValueInDomain(fieldNameWithGranularity, domain);
    if (value === undefined) {
        return undefined;
    }
    const valueIndex = values.indexOf(value);
    if (value === undefined || valueIndex === -1) {
        return undefined;
    }
    const offset = direction === PREVIOUS_VALUE ? -1 : 1;
    const newIndex = clip(valueIndex + offset, 0, values.length - 1);
    return replaceFieldValueInDomain(domain, fieldNameWithGranularity, values[newIndex]);
}
function domainToString(domain) {
    return domain ? domain.map(domainNodeToString).join(", ") : "";
}
function domainNodeToString(domainNode) {
    return domainNode ? `${domainNode.field}=${domainNode.value}` : "";
}
/**
 *
 * For the ranking, the pivot cell values of a column (or row) at the same depth are grouped together before being sorted
 * and ranked.
 *
 * The grouping of a pivot cell is done with both the value of the domain nodes that are parent of the field
 * `fieldNameWithGranularity` and the value of the last node of the domain of the pivot cell, if it's not the field
 * `fieldNameWithGranularity`.
 *
 * For example, let's take a pivot grouped by (Date:year, Stage, User, Product), where we want to rank by "Stage" field.
 * The domain nodes parents of the "Stage" are [Date:year]. The pivot cell with domain:
 * - [Date:year=2021] is not ranked because it does not contain the "Stage" field
 * - [Date:year=2021, Stage=Lead] is grouped with the cells [Date:year=2021, Stage=*, User=None, Product=None],
 *      and then ranked within the group
 * - [Date:year=2021, Stage=Lead, User=Bob] is grouped with the cells [Date:year=2021, Stage=*, User=Bob, Product=None],
 *      and then ranked within the group
 * - [Date:year=2021, Stage=Lead, User=Bob, Product=Table] is grouped with the cells [Date:year=2021, Stage=*, User=*, Product=Table],
 *      and then ranked within the group
 *
 * If we rank the pivot on "User" instead, the parent domain becomes [Date:year, Sage] .The cell with domain:
 * - [Date:year=2021] is not ranked because it does not contain the "Stage" field
 * - [Date:year=2021, Stage=Lead] is not ranked because it does not contain the "User" field
 * - [Date:year=2021, Stage=Lead, User=Bob] is grouped with the cells [Date:year=2021, Stage=Lead, User=Bob, Product=None],
 *      and then ranked within the group
 * - [Date:year=2021, Stage=Lead, User=Bob, Product=Table] is grouped with the cells with [Date:year=2021, Stage=Lead, User=*, Product=Table],
 *     and then ranked within the group
 *
 */
function getRankingDomainKey(domain, fieldNameWithGranularity) {
    const index = domain.findIndex((node) => node.field === fieldNameWithGranularity);
    if (index === -1) {
        return "";
    }
    const parent = domain.slice(0, index);
    const lastNode = domain.at(-1);
    return domainToString(lastNode.field === fieldNameWithGranularity ? parent : [...parent, lastNode]);
}
/**
 * The running total domain is the domain without the field `fieldNameWithGranularity`, ie. we do the running total of
 * all the pivot cells of the column that have any value for the field `fieldNameWithGranularity` and the same value for
 * the other fields.
 */
function getRunningTotalDomainKey(domain, fieldNameWithGranularity) {
    const index = domain.findIndex((node) => node.field === fieldNameWithGranularity);
    if (index === -1) {
        return "";
    }
    return domainToString([...domain.slice(0, index), ...domain.slice(index + 1)]);
}

const pivotTimeAdapterRegistry = new Registry();
function pivotTimeAdapter(granularity) {
    return pivotTimeAdapterRegistry.get(granularity);
}
/**
 * The Time Adapter: Managing Time Periods for Pivot Functions
 *
 * Overview:
 * A time adapter is responsible for managing time periods associated with pivot functions.
 * Each type of period (day, week, month, quarter, etc.) has its own dedicated adapter.
 * The adapter's primary role is to normalize period values between spreadsheet functions,
 * and the pivot.
 * By normalizing the period value, it can be stored consistently in the pivot.
 *
 * Normalization Process:
 * When working with functions in the spreadsheet, the time adapter normalizes
 * the provided period to facilitate accurate lookup of values in the pivot.
 * For instance, if the spreadsheet function represents a day period as a number generated
 * by the DATE function (DATE(2023, 12, 25)), the time adapter will normalize it accordingly.
 *
 */
/**
 * Normalized value: "12/25/2023"
 *
 * Note: Those two format are equivalent:
 * - "MM/dd/yyyy" (luxon format)
 * - "mm/dd/yyyy" (spreadsheet format)
 **/
const dayAdapter = {
    normalizeFunctionValue(value) {
        return toNumber(value, DEFAULT_LOCALE);
    },
    toValueAndFormat(normalizedValue, locale) {
        return {
            value: toNumber(normalizedValue, DEFAULT_LOCALE),
            format: "dd mmm yyyy",
        };
    },
    toFunctionValue(normalizedValue) {
        const date = toNumber(normalizedValue, DEFAULT_LOCALE);
        return `"${formatValue(date, { locale: DEFAULT_LOCALE, format: "mm/dd/yyyy" })}"`;
    },
};
/**
 * normalizes day of month number
 */
const dayOfMonthAdapter = {
    normalizeFunctionValue(value) {
        const day = toNumber(value, DEFAULT_LOCALE);
        if (day < 1 || day > 31) {
            throw new EvaluationError(_t("%s is not a valid day of month (it should be a number between 1 and 31)", day));
        }
        return day;
    },
    toValueAndFormat(normalizedValue) {
        return {
            value: toNumber(normalizedValue, DEFAULT_LOCALE),
            format: "0",
        };
    },
    toFunctionValue(normalizedValue) {
        return `${normalizedValue}`;
    },
};
/**
 * normalizes day of week number
 *
 * The day of week is a bit special as it depends on the locale week start day.
 * =PIVOT.VALUE(1, "xx:day_of_week", 1) will be different depending on the locale
 *  - fr_FR: 1: Monday, 7: Sunday   (weekStart = 1)
 *  - en_US: 1: Sunday, 7: Saturday (weekStart = 7)
 *
 * The function that normalizes the value coming from the function
 * (`normalizeFunctionValue`) will return the day of week (1 based index)
 * depending on the locale week start day.
 * To display the value in the pivot, we need to convert it to retrieve the
 * correct day of week name (1 should be "Monday" in fr_FR and "Sunday" in en_US).
 */
const dayOfWeekAdapter = {
    normalizeFunctionValue(value) {
        const day = toNumber(value, DEFAULT_LOCALE);
        if (day < 1 || day > 7) {
            throw new EvaluationError(_t("%s is not a valid day of week (it should be a number between 1 and 7)", day));
        }
        return day;
    },
    toValueAndFormat(normalizedValue, locale) {
        /**
         * As explain above, normalizedValue is the day of week (1 based index)
         * depending on the locale week start day. To retrieve the correct day name,
         * we need to convert it to a 0 based index with 0 being Sunday. (DAYS is
         * an object of day names with 0 being Sunday)
         */
        const index = (normalizedValue - 1 + (locale || DEFAULT_LOCALE).weekStart) % 7;
        return {
            value: DAYS$1[index].toString(),
            format: "@",
        };
    },
    toFunctionValue(normalizedValue) {
        return `${normalizedValue}`;
    },
};
/**
 * normalizes iso week number
 */
const isoWeekNumberAdapter = {
    normalizeFunctionValue(value) {
        const isoWeek = toNumber(value, DEFAULT_LOCALE);
        if (isoWeek < 0 || isoWeek > 53) {
            throw new EvaluationError(_t("%s is not a valid week (it should be a number between 0 and 53)", isoWeek));
        }
        return isoWeek;
    },
    toValueAndFormat(normalizedValue) {
        return {
            value: toNumber(normalizedValue, DEFAULT_LOCALE),
            format: "0",
        };
    },
    toFunctionValue(normalizedValue) {
        return `${normalizedValue}`;
    },
};
/**
 * normalizes month number
 */
const monthNumberAdapter = {
    normalizeFunctionValue(value) {
        const month = toNumber(value, DEFAULT_LOCALE);
        if (month < 1 || month > 12) {
            throw new EvaluationError(_t("%s is not a valid month (it should be a number between 1 and 12)", month));
        }
        return month;
    },
    toValueAndFormat(normalizedValue) {
        return {
            value: MONTHS[toNumber(normalizedValue, DEFAULT_LOCALE) - 1].toString(),
            format: "@",
        };
    },
    toFunctionValue(normalizedValue) {
        return `${normalizedValue}`;
    },
};
/**
 * normalizes quarter number
 */
const quarterNumberAdapter = {
    normalizeFunctionValue(value) {
        const quarter = toNumber(value, DEFAULT_LOCALE);
        if (quarter < 1 || quarter > 4) {
            throw new EvaluationError(_t("%s is not a valid quarter (it should be a number between 1 and 4)", quarter));
        }
        return quarter;
    },
    toValueAndFormat(normalizedValue) {
        return {
            value: _t("Q%(quarter_number)s", { quarter_number: normalizedValue }),
            format: "@",
        };
    },
    toFunctionValue(normalizedValue) {
        return `${normalizedValue}`;
    },
};
const yearAdapter = {
    normalizeFunctionValue(value) {
        return toNumber(value, DEFAULT_LOCALE);
    },
    toValueAndFormat(normalizedValue) {
        return {
            value: toNumber(normalizedValue, DEFAULT_LOCALE),
            format: "0",
        };
    },
    toFunctionValue(normalizedValue) {
        return `${normalizedValue}`;
    },
};
/**
 * normalizes hour number
 */
const hourNumberAdapter = {
    normalizeFunctionValue(value) {
        const hour = toNumber(value, DEFAULT_LOCALE);
        if (hour < 0 || hour > 23) {
            throw new EvaluationError(_t("%s is not a valid hour (it should be a number between 0 and 23)", hour));
        }
        return hour;
    },
    toValueAndFormat(normalizedValue) {
        return {
            value: _t("%(hour_number)sh", { hour_number: normalizedValue }),
            format: "@",
        };
    },
    toFunctionValue(normalizedValue) {
        return `${normalizedValue}`;
    },
};
/**
 * normalizes hour number
 */
const minuteNumberAdapter = {
    normalizeFunctionValue(value) {
        const minute = toNumber(value, DEFAULT_LOCALE);
        if (minute < 0 || minute > 59) {
            throw new EvaluationError(_t("%s is not a valid minute (it should be a number between 0 and 59)", minute));
        }
        return minute;
    },
    toValueAndFormat(normalizedValue) {
        return {
            value: _t("%(minute_number)s'", { minute_number: normalizedValue }),
            format: "@",
        };
    },
    toFunctionValue(normalizedValue) {
        return `${normalizedValue}`;
    },
};
/**
 * normalizes second number
 */
const secondNumberAdapter = {
    normalizeFunctionValue(value) {
        const second = toNumber(value, DEFAULT_LOCALE);
        if (second < 0 || second > 59) {
            throw new EvaluationError(_t("%s is not a valid second (it should be a number between 0 and 59)", second));
        }
        return second;
    },
    toValueAndFormat(normalizedValue) {
        return {
            value: _t("%(second_number)s''", { second_number: normalizedValue }),
            format: "@",
        };
    },
    toFunctionValue(normalizedValue) {
        return `${normalizedValue}`;
    },
};
/**
 * This function takes an adapter and wraps it with a null handler.
 * null value means that the value is not set.
 */
function nullHandlerDecorator(adapter) {
    return {
        normalizeFunctionValue(value) {
            if (value === null) {
                return null;
            }
            return adapter.normalizeFunctionValue(value);
        },
        toValueAndFormat(normalizedValue, locale) {
            if (normalizedValue === null) {
                return { value: _t("(Undefined)") }; //TODO Return NA ?
            }
            return adapter.toValueAndFormat(normalizedValue, locale);
        },
        toFunctionValue(normalizedValue) {
            if (normalizedValue === null) {
                return "false"; //TODO Return NA ?
            }
            return adapter.toFunctionValue(normalizedValue);
        },
    };
}
pivotTimeAdapterRegistry
    .add("day", nullHandlerDecorator(dayAdapter))
    .add("year", nullHandlerDecorator(yearAdapter))
    .add("day_of_month", nullHandlerDecorator(dayOfMonthAdapter))
    .add("iso_week_number", nullHandlerDecorator(isoWeekNumberAdapter))
    .add("month_number", nullHandlerDecorator(monthNumberAdapter))
    .add("quarter_number", nullHandlerDecorator(quarterNumberAdapter))
    .add("day_of_week", nullHandlerDecorator(dayOfWeekAdapter))
    .add("hour_number", nullHandlerDecorator(hourNumberAdapter))
    .add("minute_number", nullHandlerDecorator(minuteNumberAdapter))
    .add("second_number", nullHandlerDecorator(secondNumberAdapter));

const AGGREGATOR_NAMES = {
    count: _t("Count"),
    count_distinct: _t("Count Distinct"),
    bool_and: _t("Boolean And"),
    bool_or: _t("Boolean Or"),
    max: _t("Maximum"),
    min: _t("Minimum"),
    avg: _t("Average"),
    sum: _t("Sum"),
};
const NUMBER_CHAR_AGGREGATORS = ["max", "min", "avg", "sum", "count_distinct", "count"];
const AGGREGATORS_BY_FIELD_TYPE = {
    integer: NUMBER_CHAR_AGGREGATORS,
    char: NUMBER_CHAR_AGGREGATORS,
    boolean: ["count_distinct", "count", "bool_and", "bool_or"],
};
const AGGREGATORS = {};
for (const type in AGGREGATORS_BY_FIELD_TYPE) {
    AGGREGATORS[type] = {};
    for (const aggregator of AGGREGATORS_BY_FIELD_TYPE[type]) {
        AGGREGATORS[type][aggregator] = AGGREGATOR_NAMES[aggregator];
    }
}
const AGGREGATORS_FN = {
    count: (args) => ({
        value: countAny([args]),
        format: "0",
    }),
    count_distinct: (args) => ({
        value: countUnique([args]),
        format: "0",
    }),
    bool_and: (args) => ({
        value: boolAnd([args]).result,
    }),
    bool_or: (args) => ({
        value: boolOr([args]).result,
    }),
    max: (args, locale) => max([args], locale),
    min: (args, locale) => min([args], locale),
    avg: (args, locale) => ({
        value: average([args], locale),
        format: inferFormat(args),
    }),
    sum: (args, locale) => ({
        value: sum([args], locale),
        format: inferFormat(args),
    }),
};
/**
 * Given an object of form {"1": {...}, "2": {...}, ...} get the maximum ID used
 * in this object
 * If the object has no keys, return 0
 *
 */
function getMaxObjectId(o) {
    const keys = Object.keys(o);
    if (!keys.length) {
        return 0;
    }
    const nums = keys.map((id) => parseInt(id, 10));
    const max = Math.max(...nums);
    return max;
}
const ALL_PERIODS = {
    year: _t("Year"),
    quarter: _t("Quarter & Year"),
    month: _t("Month & Year"),
    week: _t("Week & Year"),
    day: _t("Day"),
    quarter_number: _t("Quarter"),
    month_number: _t("Month"),
    iso_week_number: _t("Week"),
    day_of_month: _t("Day of Month"),
    day_of_week: _t("Day of Week"),
    hour_number: _t("Hour"),
    minute_number: _t("Minute"),
    second_number: _t("Second"),
};
const DATE_FIELDS = ["date", "datetime"];
/**
 * Parse a dimension string into a pivot dimension definition.
 * e.g "create_date:month" => { name: "create_date", granularity: "month" }
 */
function parseDimension(dimension) {
    const [fieldName, granularity] = dimension.split(":");
    if (granularity) {
        return { fieldName, granularity };
    }
    return { fieldName };
}
function isDateOrDatetimeField(field) {
    return DATE_FIELDS.includes(field.type);
}
function generatePivotArgs(formulaId, domain, measure) {
    const args = [formulaId];
    if (measure) {
        args.push(`"${measure}"`);
    }
    for (const { field, value, type } of domain) {
        if (field === "measure") {
            args.push(`"measure"`, `"${value}"`);
            continue;
        }
        const { granularity } = parseDimension(field);
        const formattedValue = toFunctionPivotValue(value, { type, granularity });
        args.push(`"${field}"`, formattedValue);
    }
    return args;
}
/**
 * Check if the fields in the domain part of
 * a pivot function are valid according to the pivot definition.
 * e.g. =PIVOT.VALUE(1,"revenue","country_id",...,"create_date:month",...,"source_id",...)
 */
function areDomainArgsFieldsValid(dimensions, definition) {
    let argIndex = 0;
    let definitionIndex = 0;
    const cols = definition.columns.map((col) => col.nameWithGranularity);
    const rows = definition.rows.map((row) => row.nameWithGranularity);
    while (dimensions[argIndex] !== undefined && dimensions[argIndex] === rows[definitionIndex]) {
        argIndex++;
        definitionIndex++;
    }
    definitionIndex = 0;
    while (dimensions[argIndex] !== undefined && dimensions[argIndex] === cols[definitionIndex]) {
        argIndex++;
        definitionIndex++;
    }
    return dimensions.length === argIndex;
}
function createPivotFormula(formulaId, cell) {
    switch (cell.type) {
        case "HEADER":
            return `=PIVOT.HEADER(${generatePivotArgs(formulaId, cell.domain).join(",")})`;
        case "VALUE":
            return `=PIVOT.VALUE(${generatePivotArgs(formulaId, cell.domain, cell.measure).join(",")})`;
        case "MEASURE_HEADER":
            return `=PIVOT.HEADER(${generatePivotArgs(formulaId, [
                ...cell.domain,
                { field: "measure", value: cell.measure, type: "char" },
            ]).join(",")})`;
    }
    return "";
}
/**
 * Parses the value defining a pivot group in a PIVOT formula
 * e.g. given the following formula PIVOT.VALUE("1", "stage_id", "42", "status", "won"),
 * the two group values are "42" and "won".
 */
function toNormalizedPivotValue(dimension, groupValue) {
    if (groupValue === null || groupValue === "null") {
        return null;
    }
    const groupValueString = typeof groupValue === "boolean"
        ? toString(groupValue).toLocaleLowerCase()
        : toString(groupValue);
    if (groupValueString === "null") {
        return null;
    }
    if (!pivotNormalizationValueRegistry.contains(dimension.type)) {
        throw new EvaluationError(_t("Field %(field)s is not supported because of its type (%(type)s)", {
            field: dimension.displayName,
            type: dimension.type,
        }));
    }
    // represents a field which is not set (=False server side)
    if (groupValueString.toLowerCase() === "false") {
        return false;
    }
    const normalizer = pivotNormalizationValueRegistry.get(dimension.type);
    return normalizer(groupValueString, dimension.granularity);
}
function normalizeDateTime(value, granularity) {
    if (!granularity) {
        throw new Error("Missing granularity");
    }
    return pivotTimeAdapter(granularity).normalizeFunctionValue(value);
}
function toFunctionPivotValue(value, dimension) {
    if (value === null) {
        return `"null"`;
    }
    if (!pivotToFunctionValueRegistry.contains(dimension.type)) {
        return `"${value}"`;
    }
    return pivotToFunctionValueRegistry.get(dimension.type)(value, dimension.granularity);
}
function toFunctionValueDateTime(value, granularity) {
    if (!granularity) {
        throw new Error("Missing granularity");
    }
    return pivotTimeAdapter(granularity).toFunctionValue(value);
}
const pivotNormalizationValueRegistry = new Registry();
pivotNormalizationValueRegistry
    .add("date", normalizeDateTime)
    .add("datetime", normalizeDateTime)
    .add("integer", (value) => toNumber(value, DEFAULT_LOCALE))
    .add("boolean", (value) => toBoolean(value))
    .add("char", (value) => toString(value));
const pivotToFunctionValueRegistry = new Registry();
pivotToFunctionValueRegistry
    .add("date", toFunctionValueDateTime)
    .add("datetime", toFunctionValueDateTime)
    .add("integer", (value) => `${toNumber(value, DEFAULT_LOCALE)}`)
    .add("boolean", (value) => (toBoolean(value) ? "TRUE" : "FALSE"))
    .add("char", (value) => `"${toString(value).replace(/"/g, '\\"')}"`);
function getFieldDisplayName(field) {
    return field.displayName + (field.granularity ? ` (${ALL_PERIODS[field.granularity]})` : "");
}
function addIndentAndAlignToPivotHeader(pivot, domain, functionResult) {
    const { rowDomain, colDomain } = domainToColRowDomain(pivot, domain);
    if (rowDomain.length === 0 && colDomain.length === 0) {
        return functionResult;
    }
    if (rowDomain.length === 0 && colDomain.length > 0) {
        return {
            ...functionResult,
            format: (functionResult.format || "@") + "* ",
        };
    }
    const indent = rowDomain.length - 1;
    const format = functionResult.format || "@";
    return {
        ...functionResult,
        format: `${"    ".repeat(indent)}${format}* `,
    };
}

class CellClipboardHandler extends AbstractCellClipboardHandler {
    isCutAllowed(data) {
        if (data.zones.length !== 1) {
            return "WrongCutSelection" /* CommandResult.WrongCutSelection */;
        }
        return "Success" /* CommandResult.Success */;
    }
    copy(data) {
        const sheetId = data.sheetId;
        const { clippedZones, rowsIndexes, columnsIndexes } = data;
        const clippedCells = [];
        const isCopyingOneCell = rowsIndexes.length == 1 && columnsIndexes.length == 1;
        for (let row of rowsIndexes) {
            let cellsInRow = [];
            for (let col of columnsIndexes) {
                const position = { col, row, sheetId };
                let cell = this.getters.getCell(position);
                const evaluatedCell = this.getters.getEvaluatedCell(position);
                const pivotId = this.getters.getPivotIdFromPosition(position);
                const spreader = this.getters.getArrayFormulaSpreadingOn(position);
                if (pivotId && spreader) {
                    const pivotZone = this.getters.getSpreadZone(spreader);
                    if ((!deepEquals(spreader, position) || !isCopyingOneCell) &&
                        pivotZone &&
                        !data.zones.some((z) => isZoneInside(pivotZone, z))) {
                        const pivotCell = this.getters.getPivotCellFromPosition(position);
                        const formulaPivotId = this.getters.getPivotFormulaId(pivotId);
                        const pivotFormula = createPivotFormula(formulaPivotId, pivotCell);
                        cell = {
                            id: cell?.id || "",
                            style: cell?.style,
                            format: cell?.format,
                            content: pivotFormula,
                            isFormula: false,
                            parsedValue: evaluatedCell.value,
                        };
                    }
                }
                else {
                    if (spreader && !deepEquals(spreader, position)) {
                        const isSpreaderCopied = rowsIndexes.includes(spreader.row) && columnsIndexes.includes(spreader.col);
                        const content = isSpreaderCopied
                            ? ""
                            : formatValue(evaluatedCell.value, { locale: this.getters.getLocale() });
                        cell = {
                            id: cell?.id || "",
                            style: cell?.style,
                            format: evaluatedCell.format,
                            content,
                            isFormula: false,
                            parsedValue: evaluatedCell.value,
                        };
                    }
                }
                cellsInRow.push({
                    content: cell?.content ?? "",
                    style: cell?.style,
                    format: cell?.format,
                    tokens: cell?.isFormula
                        ? cell.compiledFormula.tokens.map(({ value, type }) => ({ value, type }))
                        : [],
                    border: this.getters.getCellBorder(position) || undefined,
                    evaluatedCell,
                    position,
                });
            }
            clippedCells.push(cellsInRow);
        }
        return {
            cells: clippedCells,
            zones: clippedZones,
            sheetId: data.sheetId,
        };
    }
    isPasteAllowed(sheetId, target, content, clipboardOptions) {
        if (!content.cells) {
            return "Success" /* CommandResult.Success */;
        }
        if (clipboardOptions?.isCutOperation && clipboardOptions?.pasteOption !== undefined) {
            // cannot paste only format or only value if the previous operation is a CUT
            return "WrongPasteOption" /* CommandResult.WrongPasteOption */;
        }
        if (target.length > 1) {
            // cannot paste if we have a clipped zone larger than a cell and multiple
            // zones selected
            if (content.cells.length > 1 || content.cells[0].length > 1) {
                return "WrongPasteSelection" /* CommandResult.WrongPasteSelection */;
            }
        }
        const clipboardHeight = content.cells.length;
        const clipboardWidth = content.cells[0].length;
        for (const zone of getPasteZones(target, content.cells)) {
            if (this.getters.doesIntersectMerge(sheetId, zone)) {
                if (target.length > 1 ||
                    !this.getters.isSingleCellOrMerge(sheetId, target[0]) ||
                    clipboardHeight * clipboardWidth !== 1) {
                    return "WillRemoveExistingMerge" /* CommandResult.WillRemoveExistingMerge */;
                }
            }
        }
        return "Success" /* CommandResult.Success */;
    }
    /**
     * Paste the clipboard content in the given target
     */
    paste(target, content, options) {
        const zones = target.zones;
        const sheetId = target.sheetId;
        if (!options.isCutOperation) {
            this.pasteFromCopy(sheetId, zones, content.cells, options);
        }
        else {
            this.pasteFromCut(sheetId, zones, content, options);
        }
    }
    getPasteTarget(sheetId, target, content, options) {
        const width = content.cells[0].length;
        const height = content.cells.length;
        if (options?.isCutOperation) {
            return {
                sheetId,
                zones: [
                    {
                        left: target[0].left,
                        top: target[0].top,
                        right: target[0].left + width - 1,
                        bottom: target[0].top + height - 1,
                    },
                ],
            };
        }
        if (width === 1 && height === 1) {
            return { zones: [], sheetId };
        }
        return { sheetId, zones: getPasteZones(target, content.cells) };
    }
    pasteFromCut(sheetId, target, content, options) {
        this.clearClippedZones(content);
        const selection = target[0];
        this.pasteZone(sheetId, selection.left, selection.top, content.cells, options);
        this.dispatch("MOVE_RANGES", {
            target: content.zones,
            sheetId: content.sheetId,
            targetSheetId: sheetId,
            col: selection.left,
            row: selection.top,
        });
    }
    /**
     * Clear the clipped zones: remove the cells and clear the formatting
     */
    clearClippedZones(content) {
        this.dispatch("CLEAR_CELLS", {
            sheetId: content.sheetId,
            target: content.zones,
        });
        this.dispatch("CLEAR_FORMATTING", {
            sheetId: content.sheetId,
            target: content.zones,
        });
    }
    pasteZone(sheetId, col, row, cells, clipboardOptions) {
        // then, perform the actual paste operation
        for (const [r, rowCells] of cells.entries()) {
            for (const [c, origin] of rowCells.entries()) {
                if (!origin) {
                    continue;
                }
                const position = { col: col + c, row: row + r, sheetId };
                this.pasteCell(origin, position, clipboardOptions);
            }
        }
    }
    /**
     * Paste the cell at the given position to the target position
     */
    pasteCell(origin, target, clipboardOption) {
        const { sheetId, col, row } = target;
        const targetCell = this.getters.getEvaluatedCell(target);
        const originFormat = origin?.format ?? origin.evaluatedCell.format;
        if (clipboardOption?.pasteOption === "asValue") {
            this.dispatch("UPDATE_CELL", {
                ...target,
                content: origin.evaluatedCell.value?.toString() || "",
                format: originFormat,
            });
            return;
        }
        if (clipboardOption?.pasteOption === "onlyFormat") {
            this.dispatch("UPDATE_CELL", {
                ...target,
                style: origin?.style ?? null,
                format: originFormat ?? targetCell.format,
            });
            return;
        }
        let content = origin?.content;
        if (origin?.tokens && origin.tokens.length > 0 && !clipboardOption?.isCutOperation) {
            content = this.getters.getTranslatedCellFormula(sheetId, col - origin.position.col, row - origin.position.row, origin.tokens);
        }
        else if (origin?.tokens && origin.tokens.length > 0) {
            content = this.getters.getFormulaMovedInSheet(origin.position.sheetId, sheetId, origin.tokens);
        }
        if (content !== "" || origin?.format || origin?.style) {
            this.dispatch("UPDATE_CELL", {
                ...target,
                content,
                style: origin?.style || null,
                format: origin?.format,
            });
        }
        else if (targetCell) {
            this.dispatch("CLEAR_CELL", target);
        }
    }
    convertTextToClipboardData(text) {
        const locale = this.getters.getLocale();
        const copiedData = {
            cells: [],
        };
        const values = [];
        let rowLength = 0;
        for (const [i, row] of text.replace(/\r/g, "").split("\n").entries()) {
            values.push(row.split("\t"));
            if (values[i].length > rowLength) {
                rowLength = values[i].length;
            }
        }
        for (const row of values) {
            const cells = [];
            for (let i = 0; i < rowLength; i++) {
                const content = canonicalizeNumberValue(row[i] || "", locale);
                cells.push({
                    content: content,
                    evaluatedCell: {
                        formattedValue: content,
                    },
                });
            }
            copiedData.cells.push(cells);
        }
        return copiedData;
    }
}

class AbstractFigureClipboardHandler extends ClipboardHandler {
    copy(data) {
        return;
    }
}

class ChartClipboardHandler extends AbstractFigureClipboardHandler {
    copy(data) {
        const sheetId = data.sheetId;
        const figure = this.getters.getFigure(sheetId, data.figureId);
        if (!figure) {
            throw new Error(`No figure for the given id: ${data.figureId}`);
        }
        if (figure.tag !== "chart") {
            return;
        }
        const copiedFigure = { ...figure };
        const chart = this.getters.getChart(data.figureId);
        if (!chart) {
            throw new Error(`No chart for the given id: ${data.figureId}`);
        }
        const copiedChart = chart.copyInSheetId(sheetId);
        return {
            figureId: data.figureId,
            copiedFigure,
            copiedChart,
        };
    }
    getPasteTarget(sheetId, target, content, options) {
        const newId = new UuidGenerator().smallUuid();
        return { zones: [], figureId: newId, sheetId };
    }
    paste(target, clippedContent, options) {
        if (!target.figureId) {
            return;
        }
        const { zones, figureId } = target;
        const sheetId = target.sheetId;
        const numCols = this.getters.getNumberCols(sheetId);
        const numRows = this.getters.getNumberRows(sheetId);
        const targetX = this.getters.getColDimensions(sheetId, zones[0].left).start;
        const targetY = this.getters.getRowDimensions(sheetId, zones[0].top).start;
        const maxX = this.getters.getColDimensions(sheetId, numCols - 1).end;
        const maxY = this.getters.getRowDimensions(sheetId, numRows - 1).end;
        const { width, height } = clippedContent.copiedFigure;
        const position = {
            x: maxX < width ? 0 : Math.min(targetX, maxX - width),
            y: maxY < height ? 0 : Math.min(targetY, maxY - height),
        };
        const copy = clippedContent.copiedChart.copyInSheetId(sheetId);
        this.dispatch("CREATE_CHART", {
            id: figureId,
            sheetId,
            position,
            size: { height, width },
            definition: copy.getDefinition(),
        });
        if (options.isCutOperation) {
            this.dispatch("DELETE_FIGURE", {
                sheetId: clippedContent.copiedChart.sheetId,
                id: clippedContent.copiedFigure.id,
            });
        }
        this.dispatch("SELECT_FIGURE", { id: figureId });
    }
    isPasteAllowed(sheetId, target, content, option) {
        if (target.length === 0) {
            return "EmptyTarget" /* CommandResult.EmptyTarget */;
        }
        if (option?.pasteOption !== undefined) {
            return "WrongFigurePasteOption" /* CommandResult.WrongFigurePasteOption */;
        }
        return "Success" /* CommandResult.Success */;
    }
}

class ConditionalFormatClipboardHandler extends AbstractCellClipboardHandler {
    uuidGenerator = new UuidGenerator();
    queuedChanges = {};
    copy(data) {
        if (!data.zones.length) {
            return;
        }
        const { rowsIndexes, columnsIndexes } = data;
        const sheetId = data.sheetId;
        const cfRules = [];
        for (const row of rowsIndexes) {
            const cfRuleInRow = [];
            for (const col of columnsIndexes) {
                const cfRules = Array.from(this.getters.getRulesByCell(sheetId, col, row));
                cfRuleInRow.push({
                    position: { col, row, sheetId },
                    rules: cfRules,
                });
            }
            cfRules.push(cfRuleInRow);
        }
        return { cfRules };
    }
    paste(target, clippedContent, options) {
        this.queuedChanges = {};
        if (options.pasteOption === "asValue") {
            return;
        }
        const zones = target.zones;
        const sheetId = target.sheetId;
        if (!options.isCutOperation) {
            this.pasteFromCopy(sheetId, zones, clippedContent.cfRules, options);
        }
        else {
            this.pasteFromCut(sheetId, zones, clippedContent);
        }
        this.executeQueuedChanges();
    }
    pasteFromCut(sheetId, target, content) {
        const selection = target[0];
        this.pasteZone(sheetId, selection.left, selection.top, content.cfRules, {
            isCutOperation: true,
        });
    }
    pasteZone(sheetId, col, row, cfRules, clipboardOptions) {
        for (const [r, rowCells] of cfRules.entries()) {
            for (const [c, origin] of rowCells.entries()) {
                const position = { col: col + c, row: row + r, sheetId };
                this.pasteCf(origin, position, clipboardOptions?.isCutOperation);
            }
        }
    }
    pasteCf(origin, target, isCutOperation) {
        if (origin?.rules && origin.rules.length > 0) {
            const zone = positionToZone(target);
            for (const rule of origin.rules) {
                const toRemoveZones = [];
                if (isCutOperation) {
                    //remove from current rule
                    toRemoveZones.push(positionToZone(origin.position));
                }
                if (origin.position.sheetId === target.sheetId) {
                    this.adaptCFRules(origin.position.sheetId, rule, [zone], toRemoveZones);
                }
                else {
                    this.adaptCFRules(origin.position.sheetId, rule, [], toRemoveZones);
                    const cfToCopyTo = this.getCFToCopyTo(target.sheetId, rule);
                    this.adaptCFRules(target.sheetId, cfToCopyTo, [zone], []);
                }
            }
        }
    }
    /**
     * Add or remove cells to a given conditional formatting rule.
     */
    adaptCFRules(sheetId, cf, toAdd, toRemove) {
        if (!this.queuedChanges[sheetId]) {
            this.queuedChanges[sheetId] = [];
        }
        const queuedChange = this.queuedChanges[sheetId].find((queued) => queued.cf.id === cf.id);
        if (!queuedChange) {
            this.queuedChanges[sheetId].push({ toAdd, toRemove, cf });
        }
        else {
            queuedChange.toAdd.push(...toAdd);
            queuedChange.toRemove.push(...toRemove);
        }
    }
    executeQueuedChanges() {
        for (const sheetId in this.queuedChanges) {
            for (const { toAdd, toRemove, cf } of this.queuedChanges[sheetId]) {
                const newRangesXc = this.getters.getAdaptedCfRanges(sheetId, cf, toAdd, toRemove);
                if (!newRangesXc) {
                    continue;
                }
                if (newRangesXc.length === 0) {
                    this.dispatch("REMOVE_CONDITIONAL_FORMAT", { id: cf.id, sheetId });
                    continue;
                }
                this.dispatch("ADD_CONDITIONAL_FORMAT", {
                    cf: {
                        id: cf.id,
                        rule: cf.rule,
                        stopIfTrue: cf.stopIfTrue,
                    },
                    ranges: newRangesXc,
                    sheetId,
                });
            }
        }
    }
    getCFToCopyTo(targetSheetId, originCF) {
        let targetCF = this.getters
            .getConditionalFormats(targetSheetId)
            .find((cf) => cf.stopIfTrue === originCF.stopIfTrue && deepEquals(cf.rule, originCF.rule));
        const queuedCfs = this.queuedChanges[targetSheetId];
        if (!targetCF && queuedCfs) {
            targetCF = queuedCfs.find((queued) => queued.cf.stopIfTrue === originCF.stopIfTrue && deepEquals(queued.cf.rule, originCF.rule))?.cf;
        }
        return targetCF || { ...originCF, id: this.uuidGenerator.smallUuid(), ranges: [] };
    }
}

class DataValidationClipboardHandler extends AbstractCellClipboardHandler {
    uuidGenerator = new UuidGenerator();
    queuedChanges = {};
    copy(data) {
        const { rowsIndexes, columnsIndexes } = data;
        const sheetId = data.sheetId;
        const dvRules = [];
        for (const row of rowsIndexes) {
            const dvRuleInRow = [];
            for (const col of columnsIndexes) {
                const position = { sheetId, col, row };
                const rule = this.getters.getValidationRuleForCell(position);
                dvRuleInRow.push({ position, rule });
            }
            dvRules.push(dvRuleInRow);
        }
        return { dvRules };
    }
    paste(target, clippedContent, options) {
        this.queuedChanges = {};
        if (options.pasteOption) {
            return;
        }
        const zones = target.zones;
        const sheetId = target.sheetId;
        if (!options.isCutOperation) {
            this.pasteFromCopy(sheetId, zones, clippedContent.dvRules);
        }
        else {
            this.pasteFromCut(sheetId, zones, clippedContent);
        }
        this.executeQueuedChanges();
    }
    pasteFromCut(sheetId, target, content) {
        const selection = target[0];
        this.pasteZone(sheetId, selection.left, selection.top, content.dvRules, {
            isCutOperation: true,
        });
    }
    pasteZone(sheetId, col, row, dvRules, clipboardOptions) {
        for (const [r, rowCells] of dvRules.entries()) {
            for (const [c, origin] of rowCells.entries()) {
                const position = { col: col + c, row: row + r, sheetId };
                this.pasteDataValidation(origin, position, clipboardOptions?.isCutOperation);
            }
        }
    }
    pasteDataValidation(origin, target, isCutOperation) {
        if (origin) {
            const zone = positionToZone(target);
            const rule = origin.rule;
            if (!rule) {
                const targetRule = this.getters.getValidationRuleForCell(target);
                if (targetRule) {
                    // Remove the data validation rule on the target cell
                    this.adaptDataValidationRule(target.sheetId, targetRule, [], [zone]);
                }
                return;
            }
            const toRemoveZone = [];
            if (isCutOperation) {
                toRemoveZone.push(positionToZone(origin.position));
            }
            if (origin.position.sheetId === target.sheetId) {
                const copyToRule = this.getDataValidationRuleToCopyTo(target.sheetId, rule, false);
                this.adaptDataValidationRule(origin.position.sheetId, copyToRule, [zone], toRemoveZone);
            }
            else {
                const originRule = this.getters.getValidationRuleForCell(origin.position);
                if (originRule) {
                    this.adaptDataValidationRule(origin.position.sheetId, originRule, [], toRemoveZone);
                }
                const copyToRule = this.getDataValidationRuleToCopyTo(target.sheetId, rule);
                this.adaptDataValidationRule(target.sheetId, copyToRule, [zone], []);
            }
        }
    }
    getDataValidationRuleToCopyTo(targetSheetId, originRule, newId = true) {
        let targetRule = this.getters
            .getDataValidationRules(targetSheetId)
            .find((rule) => deepEquals(originRule.criterion, rule.criterion) &&
            originRule.isBlocking === rule.isBlocking);
        const queuedRules = this.queuedChanges[targetSheetId];
        if (!targetRule && queuedRules) {
            targetRule = queuedRules.find((queued) => deepEquals(originRule.criterion, queued.rule.criterion) &&
                originRule.isBlocking === queued.rule.isBlocking)?.rule;
        }
        return (targetRule || {
            ...originRule,
            id: newId ? this.uuidGenerator.smallUuid() : originRule.id,
            ranges: [],
        });
    }
    /**
     * Add or remove XCs to a given data validation rule.
     */
    adaptDataValidationRule(sheetId, rule, toAdd, toRemove) {
        if (!this.queuedChanges[sheetId]) {
            this.queuedChanges[sheetId] = [];
        }
        const queuedChange = this.queuedChanges[sheetId].find((queued) => queued.rule.id === rule.id);
        if (!queuedChange) {
            this.queuedChanges[sheetId].push({ toAdd, toRemove, rule });
        }
        else {
            queuedChange.toAdd.push(...toAdd);
            queuedChange.toRemove.push(...toRemove);
        }
    }
    executeQueuedChanges() {
        for (const sheetId in this.queuedChanges) {
            for (const { toAdd, toRemove, rule: dv } of this.queuedChanges[sheetId]) {
                // Remove the zones first in case the same position is in toAdd and toRemove
                const dvZones = dv.ranges.map((range) => range.zone);
                const withRemovedZones = recomputeZones(dvZones, toRemove);
                const newDvZones = recomputeZones([...withRemovedZones, ...toAdd], []);
                if (newDvZones.length === 0) {
                    this.dispatch("REMOVE_DATA_VALIDATION_RULE", { sheetId, id: dv.id });
                    continue;
                }
                this.dispatch("ADD_DATA_VALIDATION_RULE", {
                    rule: dv,
                    ranges: newDvZones.map((zone) => this.getters.getRangeDataFromZone(sheetId, zone)),
                    sheetId,
                });
            }
        }
    }
}

class ImageClipboardHandler extends AbstractFigureClipboardHandler {
    copy(data) {
        const sheetId = data.sheetId;
        const figure = this.getters.getFigure(sheetId, data.figureId);
        if (!figure) {
            throw new Error(`No figure for the given id: ${data.figureId}`);
        }
        const copiedFigure = { ...figure };
        if (figure.tag !== "image") {
            return;
        }
        const image = this.getters.getImage(data.figureId);
        const copiedImage = deepCopy(image);
        return {
            figureId: data.figureId,
            copiedFigure,
            copiedImage,
            sheetId,
        };
    }
    getPasteTarget(sheetId, target, content, options) {
        const newId = new UuidGenerator().smallUuid();
        return { sheetId, zones: [], figureId: newId };
    }
    paste(target, clippedContent, options) {
        if (!target.figureId) {
            return;
        }
        const { zones, figureId } = target;
        const sheetId = this.getters.getActiveSheetId();
        const numCols = this.getters.getNumberCols(sheetId);
        const numRows = this.getters.getNumberRows(sheetId);
        const targetX = this.getters.getColDimensions(sheetId, zones[0].left).start;
        const targetY = this.getters.getRowDimensions(sheetId, zones[0].top).start;
        const maxX = this.getters.getColDimensions(sheetId, numCols - 1).end;
        const maxY = this.getters.getRowDimensions(sheetId, numRows - 1).end;
        const { width, height } = clippedContent.copiedFigure;
        const position = {
            x: maxX < width ? 0 : Math.min(targetX, maxX - width),
            y: maxY < height ? 0 : Math.min(targetY, maxY - height),
        };
        const copy = deepCopy(clippedContent.copiedImage);
        this.dispatch("CREATE_IMAGE", {
            figureId,
            sheetId,
            position,
            size: { height, width },
            definition: copy,
        });
        if (options.isCutOperation) {
            this.dispatch("DELETE_FIGURE", {
                sheetId: clippedContent.sheetId,
                id: clippedContent.copiedFigure.id,
            });
        }
        this.dispatch("SELECT_FIGURE", { id: figureId });
    }
    isPasteAllowed(sheetId, target, content, option) {
        if (target.length === 0) {
            return "EmptyTarget" /* CommandResult.EmptyTarget */;
        }
        if (option?.pasteOption !== undefined) {
            return "WrongFigurePasteOption" /* CommandResult.WrongFigurePasteOption */;
        }
        return "Success" /* CommandResult.Success */;
    }
}

class MergeClipboardHandler extends AbstractCellClipboardHandler {
    copy(data) {
        const sheetId = this.getters.getActiveSheetId();
        const { rowsIndexes, columnsIndexes } = data;
        const merges = [];
        for (const row of rowsIndexes) {
            const mergesInRow = [];
            for (const col of columnsIndexes) {
                const position = { col, row, sheetId };
                mergesInRow.push(this.getters.getMerge(position));
            }
            merges.push(mergesInRow);
        }
        return { merges };
    }
    /**
     * Paste the clipboard content in the given target
     */
    paste(target, content, options) {
        if (options.isCutOperation) {
            return;
        }
        this.pasteFromCopy(target.sheetId, target.zones, content.merges, options);
    }
    pasteZone(sheetId, col, row, merges) {
        for (const [r, rowMerges] of merges.entries()) {
            for (const [c, originMerge] of rowMerges.entries()) {
                const position = { col: col + c, row: row + r, sheetId };
                this.pasteMerge(originMerge, position);
            }
        }
    }
    pasteMerge(originMerge, target) {
        if (!originMerge) {
            return;
        }
        if (this.getters.isInMerge(target)) {
            return;
        }
        const { sheetId, col, row } = target;
        this.dispatch("ADD_MERGE", {
            sheetId,
            force: true,
            target: [
                {
                    left: col,
                    top: row,
                    right: col + originMerge.right - originMerge.left,
                    bottom: row + originMerge.bottom - originMerge.top,
                },
            ],
        });
    }
}

class SheetClipboardHandler extends AbstractCellClipboardHandler {
    isPasteAllowed(sheetId, target, content, options) {
        if (!("cells" in content)) {
            return "Success" /* CommandResult.Success */;
        }
        const { xSplit, ySplit } = this.getters.getPaneDivisions(sheetId);
        for (const zone of getPasteZones(target, content.cells)) {
            if ((zone.left < xSplit && zone.right >= xSplit) ||
                (zone.top < ySplit && zone.bottom >= ySplit)) {
                return "FrozenPaneOverlap" /* CommandResult.FrozenPaneOverlap */;
            }
        }
        return "Success" /* CommandResult.Success */;
    }
}

class TableClipboardHandler extends AbstractCellClipboardHandler {
    copy(data) {
        const sheetId = data.sheetId;
        const { rowsIndexes, columnsIndexes, zones } = data;
        const copiedTablesIds = new Set();
        const tableCells = [];
        for (let row of rowsIndexes) {
            let tableCellsInRow = [];
            tableCells.push(tableCellsInRow);
            for (let col of columnsIndexes) {
                const position = { col, row, sheetId };
                const table = this.getters.getTable(position);
                if (!table) {
                    tableCellsInRow.push({});
                    continue;
                }
                const coreTable = this.getters.getCoreTable(position);
                const tableZone = coreTable?.range.zone;
                let copiedTable = undefined;
                // Copy whole table
                if (!copiedTablesIds.has(table.id) &&
                    coreTable &&
                    tableZone &&
                    zones.some((z) => isZoneInside(tableZone, z))) {
                    copiedTablesIds.add(table.id);
                    const values = [];
                    for (const col of range(tableZone.left, tableZone.right + 1)) {
                        values.push(this.getters.getFilterHiddenValues({ sheetId, col, row: tableZone.top }));
                    }
                    copiedTable = {
                        range: coreTable.range.rangeData,
                        config: coreTable.config,
                        type: coreTable.type,
                    };
                }
                tableCellsInRow.push({
                    table: copiedTable,
                    style: this.getTableStyleToCopy(position),
                    isWholeTableCopied: copiedTablesIds.has(table.id),
                });
            }
        }
        return {
            tableCells,
            sheetId: data.sheetId,
        };
    }
    /**
     * Get the style to copy for a cell. We need to copy both the table style and the cell style, because
     * UPDATE_CELL replace the whole style of the cell with the style of the command, it doesn't merge the two.
     */
    getTableStyleToCopy(cellPosition) {
        const styleFromTable = this.getters.getCellTableStyle(cellPosition);
        const cellStyle = this.getters.getCellStyle(cellPosition);
        const bordersFromTable = this.getters.getCellTableBorder(cellPosition);
        const cellBorder = this.getters.getCellBorder(cellPosition);
        return {
            style: { ...styleFromTable, ...removeFalsyAttributes(cellStyle) },
            border: { ...bordersFromTable, ...removeFalsyAttributes(cellBorder) },
        };
    }
    paste(target, content, options) {
        const zones = target.zones;
        const sheetId = target.sheetId;
        if (!options.isCutOperation) {
            this.pasteFromCopy(sheetId, zones, content.tableCells, options);
        }
        else {
            this.pasteFromCut(sheetId, zones, content, options);
        }
    }
    pasteFromCut(sheetId, target, content, options) {
        for (const row of content.tableCells) {
            for (const tableCell of row) {
                if (tableCell.table) {
                    this.dispatch("REMOVE_TABLE", {
                        sheetId: content.sheetId,
                        target: [this.getters.getRangeFromRangeData(tableCell.table.range).zone],
                    });
                }
            }
        }
        const selection = target[0];
        this.pasteZone(sheetId, selection.left, selection.top, content.tableCells, options);
    }
    pasteZone(sheetId, col, row, tableCells, clipboardOptions) {
        for (let r = 0; r < tableCells.length; r++) {
            const rowCells = tableCells[r];
            for (let c = 0; c < rowCells.length; c++) {
                const tableCell = rowCells[c];
                if (!tableCell) {
                    continue;
                }
                const position = { col: col + c, row: row + r, sheetId };
                this.pasteTableCell(sheetId, tableCell, position, clipboardOptions);
            }
        }
        if (tableCells.length === 1) {
            for (let c = 0; c < tableCells[0].length; c++) {
                this.dispatch("AUTOFILL_TABLE_COLUMN", { col: col + c, row, sheetId });
            }
        }
    }
    pasteTableCell(sheetId, tableCell, position, options) {
        if (tableCell.table && !options?.pasteOption) {
            const { range: tableRange } = tableCell.table;
            const zoneDims = zoneToDimension(this.getters.getRangeFromRangeData(tableRange).zone);
            const newTableZone = {
                left: position.col,
                top: position.row,
                right: position.col + zoneDims.numberOfCols - 1,
                bottom: position.row + zoneDims.numberOfRows - 1,
            };
            this.dispatch("CREATE_TABLE", {
                sheetId: position.sheetId,
                ranges: [this.getters.getRangeDataFromZone(sheetId, newTableZone)],
                config: tableCell.table.config,
                tableType: tableCell.table.type,
            });
        }
        // We cannot check for dynamic tables, because at this point the paste can have changed the evaluation, and the
        // dynamic tables are not yet computed
        if (this.getters.getCoreTable(position) || options?.pasteOption === "asValue") {
            return;
        }
        if ((!options?.pasteOption && !tableCell.isWholeTableCopied) ||
            options?.pasteOption === "onlyFormat") {
            if (tableCell.style?.style) {
                this.dispatch("UPDATE_CELL", { ...position, style: tableCell.style.style });
            }
            if (tableCell.style?.border) {
                this.dispatch("SET_BORDER", { ...position, border: tableCell.style.border });
            }
        }
    }
}

const clipboardHandlersRegistries = {
    figureHandlers: new Registry(),
    cellHandlers: new Registry(),
};
clipboardHandlersRegistries.figureHandlers
    .add("chart", ChartClipboardHandler)
    .add("image", ImageClipboardHandler);
clipboardHandlersRegistries.cellHandlers
    .add("dataValidation", DataValidationClipboardHandler)
    .add("cell", CellClipboardHandler)
    .add("sheet", SheetClipboardHandler)
    .add("merge", MergeClipboardHandler)
    .add("border", BorderClipboardHandler)
    .add("table", TableClipboardHandler)
    .add("conditionalFormat", ConditionalFormatClipboardHandler);

function transformZone(zone, executed) {
    if (executed.type === "REMOVE_COLUMNS_ROWS") {
        return reduceZoneOnDeletion(zone, executed.dimension === "COL" ? "left" : "top", executed.elements);
    }
    if (executed.type === "ADD_COLUMNS_ROWS") {
        return expandZoneOnInsertion(zone, executed.dimension === "COL" ? "left" : "top", executed.base, executed.position, executed.quantity);
    }
    return { ...zone };
}
function transformRangeData(range, executed) {
    const deletedSheet = executed.type === "DELETE_SHEET" && executed.sheetId;
    if ("sheetId" in executed && range._sheetId !== executed.sheetId) {
        return range;
    }
    else {
        const newZone = transformZone(range._zone, executed);
        if (newZone && deletedSheet !== range._sheetId) {
            return { ...range, _zone: newZone };
        }
    }
    return undefined;
}

/**
 * This is a generic event bus based on the Owl event bus.
 * This bus however ensures type safety across events and subscription callbacks.
 */
class EventBus {
    subscriptions = {};
    /**
     * Add a listener for the 'eventType' events.
     *
     * Note that the 'owner' of this event can be anything, but will more likely
     * be a component or a class. The idea is that the callback will be called with
     * the proper owner bound.
     *
     * Also, the owner should be kind of unique. This will be used to remove the
     * listener.
     */
    on(type, owner, callback) {
        if (!callback) {
            throw new Error("Missing callback");
        }
        if (!this.subscriptions[type]) {
            this.subscriptions[type] = [];
        }
        this.subscriptions[type].push({
            owner,
            callback,
        });
    }
    /**
     * Emit an event of type 'eventType'.  Any extra arguments will be passed to
     * the listeners callback.
     */
    trigger(type, payload) {
        const subs = this.subscriptions[type] || [];
        for (let i = 0, iLen = subs.length; i < iLen; i++) {
            const sub = subs[i];
            sub.callback.call(sub.owner, payload);
        }
    }
    /**
     * Remove a listener
     */
    off(eventType, owner) {
        const subs = this.subscriptions[eventType];
        if (subs) {
            this.subscriptions[eventType] = subs.filter((s) => s.owner !== owner);
        }
    }
    /**
     * Remove all subscriptions.
     */
    clear() {
        this.subscriptions = {};
    }
}

/**
 * A type-safe dependency container
 */
class DependencyContainer extends EventBus {
    dependencies = new Map();
    factory = new StoreFactory(this.get.bind(this));
    /**
     * Injects a store instance in the dependency container.
     * Useful for injecting an external store that is not created by the container.
     * Also useful for mocking a store.
     */
    inject(Store, instance) {
        if (this.dependencies.has(Store) && this.dependencies.get(Store) !== instance) {
            throw new Error(`Store ${Store.name} already has an instance`);
        }
        this.dependencies.set(Store, instance);
    }
    /**
     * Get an instance of a store.
     */
    get(Store) {
        if (!this.dependencies.has(Store)) {
            this.dependencies.set(Store, this.instantiate(Store));
        }
        return this.dependencies.get(Store);
    }
    instantiate(Store, ...args) {
        return this.factory.build(Store, ...args);
    }
    resetStores() {
        this.dependencies.clear();
    }
}
class StoreFactory {
    get;
    pendingBuilds = new Set();
    constructor(get) {
        this.get = get;
    }
    /**
     * Build a store instance and get all its dependencies
     * while detecting and preventing circular dependencies
     */
    build(Store, ...args) {
        if (this.pendingBuilds.has(Store)) {
            throw new Error(`Circular dependency detected: ${[...this.pendingBuilds, Store]
                .map((s) => s.name)
                .join(" -> ")}`);
        }
        this.pendingBuilds.add(Store);
        const instance = new Store(this.get, ...args);
        this.pendingBuilds.delete(Store);
        return instance;
    }
}

/**
 * Create a store to expose an external resource (which is not a store itself)
 * to other stores.
 * The external resource needs to be injected in the store provider to provide
 * the store implementation.
 *
 * @example
 * const MyMetaStore = createAbstractStore("MyStore");
 * const stores = useStoreProvider();
 * stores.inject(MyMetaStore, externalResourceInstance);
 */
function createAbstractStore(storeName) {
    class MetaStore {
        constructor(get) {
            throw new Error(`This is a abstract store for ${storeName}, it cannot be instantiated.
Did you forget to inject your store instance?

const stores = useStoreProvider();
stores.inject(MyMetaStore, storeInstance);
`);
        }
    }
    return MetaStore;
}
class DisposableStore {
    get;
    disposeCallbacks = [];
    constructor(get) {
        this.get = get;
    }
    onDispose(callback) {
        this.disposeCallbacks.push(callback);
    }
    dispose() {
        this.disposeCallbacks.forEach((cb) => cb());
    }
}

/**
 * This hook should be used at the root of your app to provide the store container.
 */
function useStoreProvider() {
    const env = useEnv();
    if (env.__spreadsheet_stores__ instanceof DependencyContainer) {
        return env.__spreadsheet_stores__;
    }
    const container = new DependencyContainer();
    useSubEnv({
        __spreadsheet_stores__: container,
        getStore: (Store) => {
            const store = container.get(Store);
            return proxifyStoreMutation(store, () => container.trigger("store-updated"));
        },
    });
    return container;
}
/**
 * Get the instance of a store.
 */
function useStore(Store) {
    const env = useEnv();
    const container = getDependencyContainer(env);
    const store = container.get(Store);
    return useStoreRenderProxy(container, store);
}
function useLocalStore(Store, ...args) {
    const env = useEnv();
    const container = getDependencyContainer(env);
    const store = container.instantiate(Store, ...args);
    onWillUnmount(() => store.dispose());
    return useStoreRenderProxy(container, store);
}
/**
 * Trigger an event to re-render the app (deep render) when
 * a store is mutated by invoking one of its mutator methods.
 */
function useStoreRenderProxy(container, store) {
    const component = useComponent();
    const proxy = proxifyStoreMutation(store, () => {
        if (status(component) === "mounted") {
            container.trigger("store-updated");
        }
    });
    return proxy;
}
/**
 * Creates a proxied version of a store object with mutation tracking.
 * Whenever a mutator method of the store is called, the provided callback function is invoked.
 */
function proxifyStoreMutation(store, callback) {
    const proxy = new Proxy(store, {
        get(target, property, receiver) {
            const thisStore = target;
            // The third argument is `thisStore` (target) instead of `receiver`.
            // The goal is to always have the same `this` value in getter functions
            // (when `target[property]` is an accessor property).
            // `thisStore` is always the same object reference. `receiver` however is the
            // object on which the property is called, which is the Proxy object which is different for each component.
            const value = Reflect.get(target, property, thisStore);
            if (store.mutators?.includes(property)) {
                const functionProxy = new Proxy(value, {
                    // trap the function call
                    apply(target, thisArg, argArray) {
                        Reflect.apply(target, thisStore, argArray);
                        callback();
                    },
                });
                return functionProxy;
            }
            return value;
        },
    });
    return proxy;
}
function getDependencyContainer(env) {
    const container = env.__spreadsheet_stores__;
    if (!(container instanceof DependencyContainer)) {
        throw new Error("No store provider found. Did you forget to call useStoreProvider()?");
    }
    return container;
}

const ModelStore = createAbstractStore("Model");

class RendererStore {
    mutators = ["register", "unRegister"];
    renderers = {};
    register(renderer) {
        if (!renderer.renderingLayers.length) {
            return;
        }
        for (const layer of renderer.renderingLayers) {
            if (!this.renderers[layer]) {
                this.renderers[layer] = [];
            }
            this.renderers[layer].push(renderer);
        }
    }
    unRegister(renderer) {
        for (const layer of Object.keys(this.renderers)) {
            this.renderers[layer] = this.renderers[layer].filter((r) => r !== renderer);
        }
    }
    drawLayer(context, layer) {
        const renderers = this.renderers[layer];
        if (!renderers) {
            return;
        }
        for (const renderer of renderers) {
            context.ctx.save();
            renderer.drawLayer(context, layer);
            context.ctx.restore();
        }
    }
}

class SpreadsheetStore extends DisposableStore {
    // cast the model store as Model to allow model.dispatch to return the DispatchResult
    model = this.get(ModelStore);
    getters = this.model.getters;
    renderer = this.get(RendererStore);
    constructor(get) {
        super(get);
        this.model.on("command-dispatched", this, this.handle);
        this.model.on("command-finalized", this, this.finalize);
        this.renderer.register(this);
        this.onDispose(() => {
            this.model.off("command-dispatched", this);
            this.model.off("command-finalized", this);
            this.renderer.unRegister(this);
        });
    }
    get renderingLayers() {
        return [];
    }
    handle(cmd) { }
    finalize() { }
    drawLayer(ctx, layer) { }
}

const VOID_COMPOSER = {
    id: "void-composer",
    get editionMode() {
        return "inactive";
    },
    startEdition: () => {
        throw new Error("No composer is registered");
    },
    stopEdition: () => {
        throw new Error("No composer is registered");
    },
    setCurrentContent: () => {
        throw new Error("No composer is registered");
    },
};
class ComposerFocusStore extends SpreadsheetStore {
    mutators = ["focusComposer", "focusActiveComposer"];
    activeComposer = VOID_COMPOSER;
    _focusMode = "inactive";
    get focusMode() {
        return this.activeComposer.editionMode === "inactive" ? "inactive" : this._focusMode;
    }
    focusComposer(listener, args) {
        this.activeComposer = listener;
        if (this.getters.isReadonly()) {
            return;
        }
        this._focusMode = args.focusMode || "contentFocus";
        if (this._focusMode !== "inactive") {
            this.setComposerContent(args);
        }
    }
    focusActiveComposer(args) {
        if (this.getters.isReadonly()) {
            return;
        }
        if (!this.activeComposer) {
            throw new Error("No composer is registered");
        }
        this._focusMode = args.focusMode || "contentFocus";
        if (this._focusMode !== "inactive") {
            this.setComposerContent(args);
        }
    }
    /**
     * Start the edition or update the content if it's already started.
     */
    setComposerContent({ content, selection, }) {
        if (this.activeComposer.editionMode === "inactive") {
            this.activeComposer.startEdition(content, selection);
        }
        else if (content) {
            this.activeComposer.setCurrentContent(content, selection);
        }
    }
}

const TREND_LINE_XAXIS_ID = "x1";
/**
 * This file contains helpers that are common to different charts (mainly
 * line, bar and pie charts)
 */
/**
 * Adapt ranges of a chart which support DataSet (dataSets and LabelRange).
 */
function updateChartRangesWithDataSets(getters, applyChange, chartDataSets, chartLabelRange) {
    let isStale = false;
    const dataSetsWithUndefined = [];
    for (let index in chartDataSets) {
        let ds = chartDataSets[index];
        if (ds.labelCell) {
            const labelCell = adaptChartRange(ds.labelCell, applyChange);
            if (ds.labelCell !== labelCell) {
                isStale = true;
                ds = {
                    ...ds,
                    labelCell: labelCell,
                };
            }
        }
        const dataRange = adaptChartRange(ds.dataRange, applyChange);
        if (dataRange === undefined ||
            getters.getRangeString(dataRange, dataRange.sheetId) === CellErrorType.InvalidReference) {
            isStale = true;
            ds = undefined;
        }
        else if (dataRange !== ds.dataRange) {
            isStale = true;
            ds = {
                ...ds,
                dataRange,
            };
        }
        dataSetsWithUndefined[index] = ds;
    }
    let labelRange = chartLabelRange;
    const range = adaptChartRange(labelRange, applyChange);
    if (range !== labelRange) {
        isStale = true;
        labelRange = range;
    }
    const dataSets = dataSetsWithUndefined.filter(isDefined);
    return {
        isStale,
        dataSets,
        labelRange,
    };
}
/**
 * Copy the dataSets given. All the ranges which are on sheetIdFrom will target
 * sheetIdTo.
 */
function copyDataSetsWithNewSheetId(sheetIdFrom, sheetIdTo, dataSets) {
    return dataSets.map((ds) => {
        return {
            dataRange: copyRangeWithNewSheetId(sheetIdFrom, sheetIdTo, ds.dataRange),
            labelCell: ds.labelCell
                ? copyRangeWithNewSheetId(sheetIdFrom, sheetIdTo, ds.labelCell)
                : undefined,
        };
    });
}
/**
 * Copy a range. If the range is on the sheetIdFrom, the range will target
 * sheetIdTo.
 */
function copyLabelRangeWithNewSheetId(sheetIdFrom, sheetIdTo, range) {
    return range ? copyRangeWithNewSheetId(sheetIdFrom, sheetIdTo, range) : undefined;
}
/**
 * Adapt a single range of a chart
 */
function adaptChartRange(range, applyChange) {
    if (!range) {
        return undefined;
    }
    const change = applyChange(range);
    switch (change.changeType) {
        case "NONE":
            return range;
        case "REMOVE":
            return undefined;
        default:
            return change.range;
    }
}
/**
 * Create the dataSet objects from xcs
 */
function createDataSets(getters, customizedDataSets, sheetId, dataSetsHaveTitle) {
    const dataSets = [];
    for (const dataSet of customizedDataSets) {
        const dataRange = getters.getRangeFromSheetXC(sheetId, dataSet.dataRange);
        const { unboundedZone: zone, sheetId: dataSetSheetId, invalidSheetName, invalidXc } = dataRange;
        if (invalidSheetName || invalidXc) {
            continue;
        }
        // It's a rectangle. We treat all columns (arbitrary) as different data series.
        if (zone.left !== zone.right && zone.top !== zone.bottom) {
            if (zone.right === undefined) {
                // Should never happens because of the allowDispatch of charts, but just making sure
                continue;
            }
            for (let column = zone.left; column <= zone.right; column++) {
                const columnZone = {
                    ...zone,
                    left: column,
                    right: column,
                };
                dataSets.push({
                    ...createDataSet(getters, dataSetSheetId, columnZone, dataSetsHaveTitle
                        ? {
                            top: columnZone.top,
                            bottom: columnZone.top,
                            left: columnZone.left,
                            right: columnZone.left,
                        }
                        : undefined),
                    backgroundColor: dataSet.backgroundColor,
                    rightYAxis: dataSet.yAxisId === "y1",
                    customLabel: dataSet.label,
                });
            }
        }
        else {
            /* 1 cell, 1 row or 1 column */
            dataSets.push({
                ...createDataSet(getters, dataSetSheetId, zone, dataSetsHaveTitle
                    ? {
                        top: zone.top,
                        bottom: zone.top,
                        left: zone.left,
                        right: zone.left,
                    }
                    : undefined),
                backgroundColor: dataSet.backgroundColor,
                rightYAxis: dataSet.yAxisId === "y1",
                customLabel: dataSet.label,
            });
        }
    }
    return dataSets;
}
function createDataSet(getters, sheetId, fullZone, titleZone) {
    if (fullZone.left !== fullZone.right && fullZone.top !== fullZone.bottom) {
        throw new Error(`Zone should be a single column or row: ${zoneToXc(fullZone)}`);
    }
    if (titleZone) {
        const dataXC = zoneToXc(fullZone);
        const labelCellXC = zoneToXc(titleZone);
        return {
            labelCell: getters.getRangeFromSheetXC(sheetId, labelCellXC),
            dataRange: getters.getRangeFromSheetXC(sheetId, dataXC),
        };
    }
    else {
        return {
            labelCell: undefined,
            dataRange: getters.getRangeFromSheetXC(sheetId, zoneToXc(fullZone)),
        };
    }
}
/**
 * Transform a dataSet to a ExcelDataSet
 */
function toExcelDataset(getters, ds) {
    const labelZone = ds.labelCell?.zone;
    let dataZone = ds.dataRange.zone;
    if (labelZone) {
        const { numberOfRows, numberOfCols } = zoneToDimension(dataZone);
        if (numberOfRows === 1) {
            dataZone = { ...dataZone, left: dataZone.left + 1 };
        }
        else if (numberOfCols === 1) {
            dataZone = { ...dataZone, top: dataZone.top + 1 };
        }
    }
    const dataRange = ds.dataRange.clone({ zone: dataZone });
    let label = {};
    if (ds.customLabel) {
        label = {
            text: ds.customLabel,
        };
    }
    else if (ds.labelCell) {
        label = {
            reference: getters.getRangeString(ds.labelCell, "forceSheetReference", {
                useBoundedReference: true,
            }),
        };
    }
    return {
        label,
        range: getters.getRangeString(dataRange, "forceSheetReference", { useBoundedReference: true }),
        backgroundColor: ds.backgroundColor,
        rightYAxis: ds.rightYAxis,
    };
}
function toExcelLabelRange(getters, labelRange, shouldRemoveFirstLabel) {
    if (!labelRange)
        return undefined;
    let zone = {
        ...labelRange.zone,
    };
    if (shouldRemoveFirstLabel && labelRange.zone.bottom > labelRange.zone.top) {
        zone.top = zone.top + 1;
    }
    const range = labelRange.clone({ zone });
    return getters.getRangeString(range, "forceSheetReference", { useBoundedReference: true });
}
/**
 * Transform a chart definition which supports dataSets (dataSets and LabelRange)
 * with an executed command
 */
function transformChartDefinitionWithDataSetsWithZone(definition, executed) {
    let labelRange;
    if (definition.labelRange) {
        const labelZone = transformZone(toUnboundedZone(definition.labelRange), executed);
        labelRange = labelZone ? zoneToXc(labelZone) : undefined;
    }
    const dataSets = definition.dataSets
        .map((ds) => toUnboundedZone(ds.dataRange))
        .map((zone) => transformZone(zone, executed))
        .filter(isDefined)
        .map((xc) => ({ dataRange: zoneToXc(xc) }));
    return {
        ...definition,
        labelRange,
        dataSets,
    };
}
/**
 * Choose a font color based on a background color.
 * The font is white with a dark background.
 */
function chartFontColor(backgroundColor) {
    if (!backgroundColor) {
        return "#000000";
    }
    return relativeLuminance(backgroundColor) < 0.3 ? "#FFFFFF" : "#000000";
}
function checkDataset(definition) {
    if (definition.dataSets) {
        const invalidRanges = definition.dataSets.find((range) => !rangeReference.test(range.dataRange)) !== undefined;
        if (invalidRanges) {
            return "InvalidDataSet" /* CommandResult.InvalidDataSet */;
        }
        const zones = definition.dataSets.map((ds) => toUnboundedZone(ds.dataRange));
        if (zones.some((zone) => zone.top !== zone.bottom && isFullRow(zone))) {
            return "InvalidDataSet" /* CommandResult.InvalidDataSet */;
        }
    }
    return "Success" /* CommandResult.Success */;
}
function checkLabelRange(definition) {
    if (definition.labelRange) {
        const invalidLabels = !rangeReference.test(definition.labelRange || "");
        if (invalidLabels) {
            return "InvalidLabelRange" /* CommandResult.InvalidLabelRange */;
        }
    }
    return "Success" /* CommandResult.Success */;
}
function shouldRemoveFirstLabel(labelRange, dataset, dataSetsHaveTitle) {
    if (!dataSetsHaveTitle)
        return false;
    if (!labelRange)
        return false;
    if (!dataset)
        return true;
    const datasetLength = getZoneArea(dataset.dataRange.zone);
    const labelLength = getZoneArea(labelRange.zone);
    if (labelLength < datasetLength) {
        return false;
    }
    return true;
}
function getChartPositionAtCenterOfViewport(getters, chartSize) {
    const { x, y } = getters.getMainViewportCoordinates();
    const { scrollX, scrollY } = getters.getActiveSheetScrollInfo();
    const { width, height } = getters.getVisibleRect(getters.getActiveMainViewport());
    const position = {
        x: x + scrollX + Math.max(0, (width - chartSize.width) / 2),
        y: y + scrollY + Math.max(0, (height - chartSize.height) / 2),
    }; // Position at the center of the scrollable viewport
    return position;
}
function getChartAxisTitleRuntime(design) {
    if (design?.title?.text) {
        const { text, color, align, italic, bold } = design.title;
        return {
            display: true,
            text,
            color,
            font: {
                style: italic ? "italic" : "normal",
                weight: bold ? "bold" : "normal",
            },
            align: align === "left" ? "start" : align === "right" ? "end" : "center",
        };
    }
    return;
}
function getDefinedAxis(definition) {
    let useLeftAxis = false, useRightAxis = false;
    if ("horizontal" in definition && definition.horizontal) {
        return { useLeftAxis: true, useRightAxis: false };
    }
    for (const design of definition.dataSets || []) {
        if (design.yAxisId === "y1") {
            useRightAxis = true;
        }
        else {
            useLeftAxis = true;
        }
    }
    useLeftAxis ||= !useRightAxis;
    return { useLeftAxis, useRightAxis };
}
function computeChartPadding({ displayTitle, displayLegend, }) {
    let top = 25;
    if (displayTitle) {
        top = 0;
    }
    else if (displayLegend) {
        top = 10;
    }
    return { left: 20, right: 20, top, bottom: 10 };
}
function getTrendDatasetForBarChart(config, dataset) {
    const filteredValues = [];
    const filteredLabels = [];
    const labels = [];
    if (dataset.hidden) {
        return;
    }
    for (let i = 0; i < dataset.data.length; i++) {
        if (typeof dataset.data[i] === "number") {
            filteredValues.push(dataset.data[i]);
            filteredLabels.push(i + 1);
        }
        labels.push(i + 1);
    }
    const newLabels = range(0.5, labels.length + 0.55, 0.2);
    const newValues = interpolateData(config, filteredValues, filteredLabels, newLabels);
    if (!newValues.length) {
        return;
    }
    return getFullTrendingLineDataSet(dataset, config, newValues, newLabels);
}
function getFullTrendingLineDataSet(dataset, config, data, labels) {
    const defaultBorderColor = colorToRGBA(dataset.backgroundColor);
    defaultBorderColor.a = 1;
    const borderColor = config.color || lightenColor(rgbaToHex(defaultBorderColor), 0.5);
    return {
        type: "line",
        xAxisID: TREND_LINE_XAXIS_ID,
        yAxisID: dataset.yAxisID,
        label: dataset.label ? _t("Trend line for %s", dataset.label) : "",
        data: data.map((v, i) => ({ x: labels[i], y: v })),
        order: -1,
        showLine: true,
        pointRadius: 0,
        backgroundColor: borderColor,
        borderColor,
        borderDash: [5, 5],
        borderWidth: undefined,
        fill: false,
        pointBackgroundColor: borderColor,
    };
}
function interpolateData(config, values, labels, newLabels) {
    if (values.length < 2 || labels.length < 2 || newLabels.length === 0) {
        return [];
    }
    const { normalizedLabels, normalizedNewLabels } = normalizeLabels(labels, newLabels, config);
    try {
        switch (config.type) {
            case "polynomial": {
                const order = config.order;
                if (!order) {
                    return Array.from({ length: newLabels.length }, () => NaN);
                }
                if (order === 1) {
                    return predictLinearValues([values], [normalizedLabels], [normalizedNewLabels], true)[0];
                }
                const coeffs = polynomialRegression(values, normalizedLabels, order, true).flat();
                return normalizedNewLabels.map((v) => evaluatePolynomial(coeffs, v, order));
            }
            case "exponential": {
                const positiveLogValues = [];
                const filteredLabels = [];
                for (let i = 0; i < values.length; i++) {
                    if (values[i] > 0) {
                        positiveLogValues.push(Math.log(values[i]));
                        filteredLabels.push(normalizedLabels[i]);
                    }
                }
                if (!filteredLabels.length) {
                    return Array.from({ length: newLabels.length }, () => NaN);
                }
                return expM(predictLinearValues([positiveLogValues], [filteredLabels], [normalizedNewLabels], true))[0];
            }
            case "logarithmic": {
                return predictLinearValues([values], logM([normalizedLabels]), logM([normalizedNewLabels]), true)[0];
            }
            default:
                return [];
        }
    }
    catch (e) {
        return Array.from({ length: newLabels.length }, () => NaN);
    }
}
function normalizeLabels(labels, newLabels, config) {
    let normalizedLabels = [];
    let normalizedNewLabels = [];
    if (config.type === "logarithmic") {
        // Logarithmic trends in charts are used to visualize proportional growth or
        // relative changes. Therefore, we change the normalization technique for
        // logarithmic trend lines for a better fit. The method used here is Max Absolute
        // Scaling. This Technique is ideal for data spanning several orders of magnitude,
        // as it balances differences between small and large values by compressing larger
        // values while preserving proportionality and ensuring all values are scaled relative
        // to the largest magnitude.
        const labelMax = Math.max(...labels.map(Math.abs));
        normalizedLabels = labels.map((l) => l / labelMax);
        normalizedNewLabels = newLabels.map((l) => l / labelMax);
    }
    else {
        const labelMax = Math.max(...labels);
        const labelMin = Math.min(...labels);
        const labelRange = labelMax - labelMin;
        normalizedLabels = labels.map((l) => (l - labelMax) / labelRange);
        normalizedNewLabels = newLabels.map((l) => (l - labelMax) / labelRange);
    }
    return { normalizedLabels, normalizedNewLabels };
}
function formatTickValue(localeFormat) {
    return (value) => {
        value = Number(value);
        if (isNaN(value))
            return value;
        const { locale, format } = localeFormat;
        return formatValue(value, {
            locale,
            format: !format && Math.abs(value) >= 1000 ? "#,##" : format,
        });
    };
}
function getChartColorsGenerator(definition, dataSetsSize) {
    return new ColorGenerator(dataSetsSize, definition.dataSets.map((ds) => ds.backgroundColor));
}
const CHART_AXIS_CHOICES = [
    { value: "left", label: _t("Left") },
    { value: "right", label: _t("Right") },
];

/** This is a chartJS plugin that will draw the values of each data next to the point/bar/pie slice */
const chartShowValuesPlugin = {
    id: "chartShowValuesPlugin",
    afterDatasetsDraw(chart, args, options) {
        if (!options.showValues) {
            return;
        }
        const drawData = chart._metasets?.[0]?.data;
        if (!drawData) {
            return;
        }
        const ctx = chart.ctx;
        ctx.save();
        ctx.textAlign = "center";
        ctx.textBaseline = "middle";
        ctx.miterLimit = 1; // Avoid sharp artifacts on strokeText
        switch (chart.config.type) {
            case "pie":
            case "doughnut":
                drawPieChartValues(chart, options, ctx);
                break;
            case "bar":
            case "line":
                options.horizontal
                    ? drawHorizontalBarChartValues(chart, options, ctx)
                    : drawLineOrBarChartValues(chart, options, ctx);
                break;
        }
        ctx.restore();
    },
};
function drawTextWithBackground(text, x, y, ctx) {
    ctx.lineWidth = 3; // Stroke the text with a big lineWidth width to have some kind of background
    ctx.strokeText(text, x, y);
    ctx.lineWidth = 1;
    ctx.fillText(text, x, y);
}
function drawLineOrBarChartValues(chart, options, ctx) {
    const yMax = chart.chartArea.bottom;
    const yMin = chart.chartArea.top;
    const textsPositions = {};
    for (const dataset of chart._metasets) {
        if (dataset.xAxisID === TREND_LINE_XAXIS_ID) {
            return; // ignore trend lines
        }
        for (let i = 0; i < dataset._parsed.length; i++) {
            const value = dataset._parsed[i].y;
            const point = dataset.data[i];
            const xPosition = point.x;
            let yPosition = 0;
            if (chart.config.type === "line") {
                yPosition = point.y - 10;
            }
            else {
                yPosition = value < 0 ? point.y - point.height / 2 : point.y + point.height / 2;
            }
            yPosition = Math.min(yPosition, yMax);
            yPosition = Math.max(yPosition, yMin);
            // Avoid overlapping texts with same X
            if (!textsPositions[xPosition]) {
                textsPositions[xPosition] = [];
            }
            for (const otherPosition of textsPositions[xPosition] || []) {
                if (Math.abs(otherPosition - yPosition) < 13) {
                    yPosition = otherPosition - 13;
                }
            }
            textsPositions[xPosition].push(yPosition);
            ctx.fillStyle = point.options.backgroundColor;
            ctx.strokeStyle = options.background || "#ffffff";
            drawTextWithBackground(options.callback(value - 0), xPosition, yPosition, ctx);
        }
    }
}
function drawHorizontalBarChartValues(chart, options, ctx) {
    const xMax = chart.chartArea.right;
    const xMin = chart.chartArea.left;
    const textsPositions = {};
    for (const dataset of chart._metasets) {
        if (dataset.xAxisID === TREND_LINE_XAXIS_ID) {
            return; // ignore trend lines
        }
        for (let i = 0; i < dataset._parsed.length; i++) {
            const value = dataset._parsed[i].x;
            const displayValue = options.callback(value - 0);
            const point = dataset.data[i];
            const yPosition = point.y;
            let xPosition = value < 0 ? point.x + point.width / 2 : point.x - point.width / 2;
            xPosition = Math.min(xPosition, xMax);
            xPosition = Math.max(xPosition, xMin);
            // Avoid overlapping texts with same Y
            if (!textsPositions[yPosition]) {
                textsPositions[yPosition] = [];
            }
            const textWidth = computeTextWidth(ctx, displayValue, { fontSize: 12 }, "px");
            for (const otherPosition of textsPositions[yPosition]) {
                if (Math.abs(otherPosition - xPosition) < textWidth) {
                    xPosition = otherPosition + textWidth + 3;
                }
            }
            textsPositions[yPosition].push(xPosition);
            ctx.fillStyle = point.options.backgroundColor;
            ctx.strokeStyle = options.background || "#ffffff";
            drawTextWithBackground(displayValue, xPosition, yPosition, ctx);
        }
    }
}
function drawPieChartValues(chart, options, ctx) {
    for (const dataset of chart._metasets) {
        for (let i = 0; i < dataset._parsed.length; i++) {
            const value = Number(dataset._parsed[i]);
            if (isNaN(value) || value === 0) {
                continue;
            }
            const bar = dataset.data[i];
            const { startAngle, endAngle, innerRadius, outerRadius } = bar;
            const midAngle = (startAngle + endAngle) / 2;
            const midRadius = (innerRadius + outerRadius) / 2;
            const x = bar.x + midRadius * Math.cos(midAngle);
            const y = bar.y + midRadius * Math.sin(midAngle) + 7;
            ctx.fillStyle = chartFontColor(options.background);
            ctx.strokeStyle = options.background || "#ffffff";
            const displayValue = options.callback(value);
            drawTextWithBackground(displayValue, x, y, ctx);
        }
    }
}

/** This is a chartJS plugin that will draw connector lines between the bars of a Waterfall chart */
const waterfallLinesPlugin = {
    id: "waterfallLinesPlugin",
    beforeDraw(chart, args, options) {
        if (!options.showConnectorLines) {
            return;
        }
        // Note: private properties are not in the typing of chartJS (and some of the existing types are missing properties)
        // so we don't type anything in this file
        const drawData = chart._metasets?.[0]?.data;
        if (!drawData) {
            return;
        }
        const ctx = chart.ctx;
        ctx.save();
        ctx.setLineDash([3, 2]);
        for (let i = 0; i < drawData.length; i++) {
            const bar = drawData[i];
            if (bar.height === 0) {
                continue;
            }
            const nextBar = getNextNonEmptyBar(drawData, i);
            if (!nextBar) {
                break;
            }
            const rect = getBarElementRect(bar);
            const nextBarRect = getBarElementRect(nextBar);
            const rawBarValues = bar.$context.raw;
            const value = rawBarValues[1] - rawBarValues[0];
            const lineY = Math.round(value < 0 ? rect.bottom - 1 : rect.top);
            const lineStart = Math.round(rect.right);
            const lineEnd = Math.round(nextBarRect.left);
            ctx.strokeStyle = "#999";
            ctx.beginPath();
            ctx.moveTo(lineStart + 1, lineY + 0.5);
            ctx.lineTo(lineEnd, lineY + 0.5);
            ctx.stroke();
        }
        ctx.restore();
    },
};
function getBarElementRect(bar) {
    const flipped = bar.base < bar.y; // Bar are flipped for negative values in the dataset
    return {
        left: bar.x - bar.width / 2,
        right: bar.x + bar.width / 2,
        bottom: flipped ? bar.base + bar.height : bar.y + bar.height,
        top: flipped ? bar.base : bar.y,
    };
}
function getNextNonEmptyBar(bars, startIndex) {
    return bars.find((bar, i) => i > startIndex && bar.height !== 0);
}

/**
 * Represent a raw XML string
 */
class XMLString {
    xmlString;
    /**
     * @param xmlString should be a well formed, properly escaped XML string
     */
    constructor(xmlString) {
        this.xmlString = xmlString;
    }
    toString() {
        return this.xmlString;
    }
}
const XLSX_CHART_TYPES = [
    "areaChart",
    "area3DChart",
    "lineChart",
    "line3DChart",
    "stockChart",
    "radarChart",
    "scatterChart",
    "pieChart",
    "pie3DChart",
    "doughnutChart",
    "barChart",
    "bar3DChart",
    "ofPieChart",
    "surfaceChart",
    "surface3DChart",
    "bubbleChart",
    "comboChart",
];

/** In XLSX color format (no #)  */
const AUTO_COLOR = "000000";
const XLSX_ICONSET_MAP = {
    arrow: "3Arrows",
    smiley: "3Symbols",
    dot: "3TrafficLights1",
};
const NAMESPACE = {
    styleSheet: "http://schemas.openxmlformats.org/spreadsheetml/2006/main",
    sst: "http://schemas.openxmlformats.org/spreadsheetml/2006/main",
    Relationships: "http://schemas.openxmlformats.org/package/2006/relationships",
    Types: "http://schemas.openxmlformats.org/package/2006/content-types",
    worksheet: "http://schemas.openxmlformats.org/spreadsheetml/2006/main",
    workbook: "http://schemas.openxmlformats.org/spreadsheetml/2006/main",
    drawing: "http://schemas.openxmlformats.org/drawingml/2006/spreadsheetDrawing",
    table: "http://schemas.openxmlformats.org/spreadsheetml/2006/main",
    revision: "http://schemas.microsoft.com/office/spreadsheetml/2014/revision",
    revision3: "http://schemas.microsoft.com/office/spreadsheetml/2016/revision3",
    markupCompatibility: "http://schemas.openxmlformats.org/markup-compatibility/2006",
};
const DRAWING_NS_A = "http://schemas.openxmlformats.org/drawingml/2006/main";
const DRAWING_NS_C = "http://schemas.openxmlformats.org/drawingml/2006/chart";
const CONTENT_TYPES = {
    workbook: "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet.main+xml",
    sheet: "application/vnd.openxmlformats-officedocument.spreadsheetml.worksheet+xml",
    metadata: "application/vnd.openxmlformats-officedocument.spreadsheetml.sheetMetadata+xml",
    sharedStrings: "application/vnd.openxmlformats-officedocument.spreadsheetml.sharedStrings+xml",
    styles: "application/vnd.openxmlformats-officedocument.spreadsheetml.styles+xml",
    drawing: "application/vnd.openxmlformats-officedocument.drawing+xml",
    chart: "application/vnd.openxmlformats-officedocument.drawingml.chart+xml",
    themes: "application/vnd.openxmlformats-officedocument.theme+xml",
    table: "application/vnd.openxmlformats-officedocument.spreadsheetml.table+xml",
    pivot: "application/vnd.openxmlformats-officedocument.spreadsheetml.pivotTable+xml",
    externalLink: "application/vnd.openxmlformats-officedocument.spreadsheetml.externalLink+xml",
};
const XLSX_RELATION_TYPE = {
    document: "http://schemas.openxmlformats.org/officeDocument/2006/relationships/officeDocument",
    sheet: "http://schemas.openxmlformats.org/officeDocument/2006/relationships/worksheet",
    metadata: "http://schemas.openxmlformats.org/officeDocument/2006/relationships/sheetMetadata",
    sharedStrings: "http://schemas.openxmlformats.org/officeDocument/2006/relationships/sharedStrings",
    styles: "http://schemas.openxmlformats.org/officeDocument/2006/relationships/styles",
    drawing: "http://schemas.openxmlformats.org/officeDocument/2006/relationships/drawing",
    chart: "http://schemas.openxmlformats.org/officeDocument/2006/relationships/chart",
    theme: "http://schemas.openxmlformats.org/officeDocument/2006/relationships/theme",
    table: "http://schemas.openxmlformats.org/officeDocument/2006/relationships/table",
    hyperlink: "http://schemas.openxmlformats.org/officeDocument/2006/relationships/hyperlink",
    image: "http://schemas.openxmlformats.org/officeDocument/2006/relationships/image",
};
const ARRAY_FORMULA_URI = "bdbb8cdc-fa1e-496e-a857-3c3f30c029c3";
const RELATIONSHIP_NSR = "http://schemas.openxmlformats.org/officeDocument/2006/relationships";
const HEIGHT_FACTOR = 0.75; // 100px => 75 u
/**
 * Excel says its default column width is 8.43 characters (64px)
 * which makes WIDTH_FACTOR = 0.1317, but it doesn't work well
 * 0.143 is a value from dev's experiments.
 */
const WIDTH_FACTOR = 0.143;
/** unit : maximum number of characters a column can hold at the standard font size. What. */
const EXCEL_DEFAULT_COL_WIDTH = 8.43;
/** unit : points */
const EXCEL_DEFAULT_ROW_HEIGHT = 12.75;
const EXCEL_IMPORT_DEFAULT_NUMBER_OF_COLS = 30;
const EXCEL_IMPORT_DEFAULT_NUMBER_OF_ROWS = 100;
const FIRST_NUMFMT_ID = 164;
const FORCE_DEFAULT_ARGS_FUNCTIONS = {
    FLOOR: [{ type: "NUMBER", value: 1 }],
    CEILING: [{ type: "NUMBER", value: 1 }],
    ROUND: [{ type: "NUMBER", value: 0 }],
    ROUNDUP: [{ type: "NUMBER", value: 0 }],
    ROUNDDOWN: [{ type: "NUMBER", value: 0 }],
};
/**
 * This list contains all "future" functions that are not compatible with older versions of Excel
 * For more information, see https://docs.microsoft.com/en-us/openspecs/office_standards/ms-xlsx/5d1b6d44-6fc1-4ecd-8fef-0b27406cc2bf
 */
const NON_RETROCOMPATIBLE_FUNCTIONS = [
    "ACOT",
    "ACOTH",
    "AGGREGATE",
    "ARABIC",
    "BASE",
    "BETA.DIST",
    "BETA.INV",
    "BINOM.DIST",
    "BINOM.DIST.RANGE",
    "BINOM.INV",
    "BITAND",
    "BITLSHIFT",
    "BITOR",
    "BITRSHIFT",
    "BITXOR",
    "BYCOL",
    "BYROW",
    "CEILING.MATH",
    "CEILING.PRECISE",
    "CHISQ.DIST",
    "CHISQ.DIST.RT",
    "CHISQ.INV",
    "CHISQ.INV.RT",
    "CHISQ.TEST",
    "CHOOSECOLS",
    "CHOOSEROWS",
    "COMBINA",
    "CONCAT",
    "CONFIDENCE.NORM",
    "CONFIDENCE.T",
    "COT",
    "COTH",
    "COVARIANCE.P",
    "COVARIANCE.S",
    "CSC",
    "CSCH",
    "DAYS",
    "DECIMAL",
    "DROP",
    "ERF.PRECISE",
    "ERFC.PRECISE",
    "EXPAND",
    "EXPON.DIST",
    "F.DIST",
    "F.DIST.RT",
    "F.INV",
    "F.INV.RT",
    "F.TEST",
    "FIELDVALUE",
    "FILTERXML",
    "FLOOR.MATH",
    "FLOOR.PRECISE",
    "FORECAST.ETS",
    "FORECAST.ETS.CONFINT",
    "FORECAST.ETS.SEASONALITY",
    "FORECAST.ETS.STAT",
    "FORECAST.LINEAR",
    "FORMULATEXT",
    "GAMMA",
    "GAMMA.DIST",
    "GAMMA.INV",
    "GAMMALN.PRECISE",
    "GAUSS",
    "HSTACK",
    "HYPGEOM.DIST",
    "IFNA",
    "IFS",
    "IMCOSH",
    "IMCOT",
    "IMCSC",
    "IMCSCH",
    "IMSEC",
    "IMSECH",
    "IMSINH",
    "IMTAN",
    "ISFORMULA",
    "ISOMITTED",
    "ISOWEEKNUM",
    "LAMBDA",
    "LET",
    "LOGNORM.DIST",
    "LOGNORM.INV",
    "MAKEARRAY",
    "MAP",
    "MAXIFS",
    "MINIFS",
    "MODE.MULT",
    "MODE.SNGL",
    "MUNIT",
    "NEGBINOM.DIST",
    "NORM.DIST",
    "NORM.INV",
    "NORM.S.DIST",
    "NORM.S.INV",
    "NUMBERVALUE",
    "PDURATION",
    "PERCENTILE.EXC",
    "PERCENTILE.INC",
    "PERCENTRANK.EXC",
    "PERCENTRANK.INC",
    "PERMUTATIONA",
    "PHI",
    "POISSON.DIST",
    "PQSOURCE",
    "PYTHON_STR",
    "PYTHON_TYPE",
    "PYTHON_TYPENAME",
    "QUARTILE.EXC",
    "QUARTILE.INC",
    "QUERYSTRING",
    "RANDARRAY",
    "RANK.AVG",
    "RANK.EQ",
    "REDUCE",
    "RRI",
    "SCAN",
    "SEC",
    "SECH",
    "SEQUENCE",
    "SHEET",
    "SHEETS",
    "SKEW.P",
    "SORTBY",
    "STDEV.P",
    "STDEV.S",
    "SWITCH",
    "T.DIST",
    "T.DIST.2T",
    "T.DIST.RT",
    "T.INV",
    "T.INV.2T",
    "T.TEST",
    "TAKE",
    "TEXTAFTER",
    "TEXTBEFORE",
    "TEXTJOIN",
    "TEXTSPLIT",
    "TOCOL",
    "TOROW",
    "UNICHAR",
    "UNICODE",
    "UNIQUE",
    "VAR.P",
    "VAR.S",
    "VSTACK",
    "WEBSERVICE",
    "WEIBULL.DIST",
    "WRAPCOLS",
    "WRAPROWS",
    "XLOOKUP",
    "XOR",
    "Z.TEST",
];
const CONTENT_TYPES_FILE = "[Content_Types].xml";

/**
 * Registry to draw icons on cells
 */
const iconsOnCellRegistry = new Registry();

/**
 * This file is largely inspired by owl 1.
 * `css` tag has been removed from owl 2 without workaround to manage css.
 * So, the solution was to import the behavior of owl 1 directly in our
 * codebase, with one difference: the css is added to the sheet as soon as the
 * css tag is executed. In owl 1, the css was added as soon as a Component was
 * created for the first time.
 */
const STYLESHEETS = {};
let nextId = 0;
/**
 * CSS tag helper for defining inline stylesheets.  With this, one can simply define
 * an inline stylesheet with just the following code:
 * ```js
 *     css`.component-a { color: red; }`;
 * ```
 */
function css(strings, ...args) {
    const name = `__sheet__${nextId++}`;
    const value = String.raw(strings, ...args);
    registerSheet(name, value);
    activateSheet(name);
    return name;
}
function processSheet(str) {
    const tokens = str.split(/(\{|\}|;)/).map((s) => s.trim());
    const selectorStack = [];
    const parts = [];
    let rules = [];
    function generateSelector(stackIndex, parentSelector) {
        const parts = [];
        for (const selector of selectorStack[stackIndex]) {
            let part = (parentSelector && parentSelector + " " + selector) || selector;
            if (part.includes("&")) {
                part = selector.replace(/&/g, parentSelector || "");
            }
            if (stackIndex < selectorStack.length - 1) {
                part = generateSelector(stackIndex + 1, part);
            }
            parts.push(part);
        }
        return parts.join(", ");
    }
    function generateRules() {
        if (rules.length) {
            parts.push(generateSelector(0) + " {");
            parts.push(...rules);
            parts.push("}");
            rules = [];
        }
    }
    while (tokens.length) {
        let token = tokens.shift();
        if (token === "}") {
            generateRules();
            selectorStack.pop();
        }
        else {
            if (tokens[0] === "{") {
                generateRules();
                selectorStack.push(token.split(/\s*,\s*/));
                tokens.shift();
            }
            if (tokens[0] === ";") {
                rules.push("  " + token + ";");
            }
        }
    }
    return parts.join("\n");
}
function registerSheet(id, css) {
    const sheet = document.createElement("style");
    sheet.textContent = processSheet(css);
    STYLESHEETS[id] = sheet;
}
function activateSheet(id) {
    const sheet = STYLESHEETS[id];
    sheet.setAttribute("component", id);
    document.head.appendChild(sheet);
}
function getTextDecoration({ strikethrough, underline, }) {
    if (!strikethrough && !underline) {
        return "none";
    }
    return `${strikethrough ? "line-through" : ""} ${underline ? "underline" : ""}`;
}
/**
 * Convert the cell style to CSS properties.
 */
function cellStyleToCss(style) {
    const attributes = cellTextStyleToCss(style);
    if (!style)
        return attributes;
    if (style.fillColor) {
        attributes["background"] = style.fillColor;
    }
    return attributes;
}
/**
 * Convert the cell text style to CSS properties.
 */
function cellTextStyleToCss(style) {
    const attributes = {};
    if (!style)
        return attributes;
    if (style.bold) {
        attributes["font-weight"] = "bold";
    }
    if (style.italic) {
        attributes["font-style"] = "italic";
    }
    if (style.strikethrough || style.underline) {
        let decoration = style.strikethrough ? "line-through" : "";
        decoration = style.underline ? decoration + " underline" : decoration;
        attributes["text-decoration"] = decoration;
    }
    if (style.textColor) {
        attributes["color"] = style.textColor;
    }
    return attributes;
}
/**
 * Transform CSS properties into a CSS string.
 */
function cssPropertiesToCss(attributes) {
    let styleStr = "";
    for (const attName in attributes) {
        if (!attributes[attName]) {
            continue;
        }
        styleStr += `${attName}:${attributes[attName]}; `;
    }
    return styleStr;
}
function getElementMargins(el) {
    const style = window.getComputedStyle(el);
    const margins = {
        top: parseInt(style.marginTop, 10) || 0,
        bottom: parseInt(style.marginBottom, 10) || 0,
        left: parseInt(style.marginLeft, 10) || 0,
        right: parseInt(style.marginRight, 10) || 0,
    };
    return margins;
}

css /* scss */ `
  .o-spreadsheet {
    .o-icon {
      display: flex;
      align-items: center;
      justify-content: center;
      width: ${ICON_EDGE_LENGTH}px;
      height: ${ICON_EDGE_LENGTH}px;
      font-size: ${ICON_EDGE_LENGTH}px;
      vertical-align: middle;

      .small-text {
        font: bold 9px sans-serif;
      }
      .heavy-text {
        font: bold 16px sans-serif;
      }
    }
    .fa-small {
      font-size: 14px;
    }
  }
`;
// -----------------------------------------------------------------------------
// We need here the svg of the icons that we need to convert to images for the renderer
// -----------------------------------------------------------------------------
const ARROW_DOWN = '<svg class="o-icon arrow-down" width="10" height="10" focusable="false" viewBox="0 0 448 512"><path fill="#E06666" d="M413.1 222.5l22.2 22.2c9.4 9.4 9.4 24.6 0 33.9L241 473c-9.4 9.4-24.6 9.4-33.9 0L12.7 278.6c-9.4-9.4-9.4-24.6 0-33.9l22.2-22.2c9.5-9.5 25-9.3 34.3.4L184 343.4V56c0-13.3 10.7-24 24-24h32c13.3 0 24 10.7 24 24v287.4l114.8-120.5c9.3-9.8 24.8-10 34.3-.4z"></path></svg>';
const ARROW_UP = '<svg class="o-icon arrow-up" width="10" height="10" focusable="false" viewBox="0 0 448 512"><path fill="#6AA84F" d="M34.9 289.5l-22.2-22.2c-9.4-9.4-9.4-24.6 0-33.9L207 39c9.4-9.4 24.6-9.4 33.9 0l194.3 194.3c9.4 9.4 9.4 24.6 0 33.9L413 289.4c-9.5 9.5-25 9.3-34.3-.4L264 168.6V456c0 13.3-10.7 24-24 24h-32c-13.3 0-24-10.7-24-24V168.6L69.2 289.1c-9.3 9.8-24.8 10-34.3.4z"></path></svg>';
const ARROW_RIGHT = '<svg class="o-icon arrow-right" width="10" height="10" focusable="false" viewBox="0 0 448 512"><path fill="#F0AD4E" d="M190.5 66.9l22.2-22.2c9.4-9.4 24.6-9.4 33.9 0L441 239c9.4 9.4 9.4 24.6 0 33.9L246.6 467.3c-9.4 9.4-24.6 9.4-33.9 0l-22.2-22.2c-9.5-9.5-9.3-25 .4-34.3L311.4 296H24c-13.3 0-24-10.7-24-24v-32c0-13.3 10.7-24 24-24h287.4L190.9 101.2c-9.8-9.3-10-24.8-.4-34.3z"></path></svg>';
const SMILE = '<svg class="o-icon smile" width="10" height="10" focusable="false" viewBox="0 0 496 512"><path fill="#6AA84F" d="M248 8C111 8 0 119 0 256s111 248 248 248 248-111 248-248S385 8 248 8zm0 448c-110.3 0-200-89.7-200-200S137.7 56 248 56s200 89.7 200 200-89.7 200-200 200zm-80-216c17.7 0 32-14.3 32-32s-14.3-32-32-32-32 14.3-32 32 14.3 32 32 32zm160 0c17.7 0 32-14.3 32-32s-14.3-32-32-32-32 14.3-32 32 14.3 32 32 32zm4 72.6c-20.8 25-51.5 39.4-84 39.4s-63.2-14.3-84-39.4c-8.5-10.2-23.7-11.5-33.8-3.1-10.2 8.5-11.5 23.6-3.1 33.8 30 36 74.1 56.6 120.9 56.6s90.9-20.6 120.9-56.6c8.5-10.2 7.1-25.3-3.1-33.8-10.1-8.4-25.3-7.1-33.8 3.1z"></path></svg>';
const MEH = '<svg class="o-icon meh" width="10" height="10" focusable="false" viewBox="0 0 496 512"><path fill="#F0AD4E" d="M248 8C111 8 0 119 0 256s111 248 248 248 248-111 248-248S385 8 248 8zm0 448c-110.3 0-200-89.7-200-200S137.7 56 248 56s200 89.7 200 200-89.7 200-200 200zm-80-216c17.7 0 32-14.3 32-32s-14.3-32-32-32-32 14.3-32 32 14.3 32 32 32zm160-64c-17.7 0-32 14.3-32 32s14.3 32 32 32 32-14.3 32-32-14.3-32-32-32zm8 144H160c-13.2 0-24 10.8-24 24s10.8 24 24 24h176c13.2 0 24-10.8 24-24s-10.8-24-24-24z"></path></svg>';
const FROWN = '<svg class="o-icon frown" width="10" height="10" focusable="false" viewBox="0 0 496 512"><path fill="#E06666" d="M248 8C111 8 0 119 0 256s111 248 248 248 248-111 248-248S385 8 248 8zm0 448c-110.3 0-200-89.7-200-200S137.7 56 248 56s200 89.7 200 200-89.7 200-200 200zm-80-216c17.7 0 32-14.3 32-32s-14.3-32-32-32-32 14.3-32 32 14.3 32 32 32zm160-64c-17.7 0-32 14.3-32 32s14.3 32 32 32 32-14.3 32-32-14.3-32-32-32zm-80 128c-40.2 0-78 17.7-103.8 48.6-8.5 10.2-7.1 25.3 3.1 33.8 10.2 8.4 25.3 7.1 33.8-3.1 16.6-19.9 41-31.4 66.9-31.4s50.3 11.4 66.9 31.4c8.1 9.7 23.1 11.9 33.8 3.1 10.2-8.5 11.5-23.6 3.1-33.8C326 321.7 288.2 304 248 304z"></path></svg>';
const GREEN_DOT = '<svg class="o-icon green-dot" width="10" height="10" focusable="false" viewBox="0 0 512 512"><path fill="#6AA84F" d="M256 8C119 8 8 119 8 256s111 248 248 248 248-111 248-248S393 8 256 8z"></path></svg>';
const YELLOW_DOT = '<svg class="o-icon yellow-dot" width="10" height="10" focusable="false" viewBox="0 0 512 512"><path fill="#F0AD4E" d="M256 8C119 8 8 119 8 256s111 248 248 248 248-111 248-248S393 8 256 8z"></path></svg>';
const RED_DOT = '<svg class="o-icon red-dot" width="10" height="10" focusable="false" viewBox="0 0 512 512"><path fill="#E06666" d="M256 8C119 8 8 119 8 256s111 248 248 248 248-111 248-248S393 8 256 8z"></path></svg>';
function getIconSrc(svg) {
    /** We have to add xmlns, as it's not added by owl in the canvas */
    svg = `<svg xmlns="http://www.w3.org/2000/svg" ${svg.slice(4)}`;
    return "data:image/svg+xml; charset=utf8, " + encodeURIComponent(svg);
}
const ICONS = {
    arrowGood: {
        template: "ARROW_UP",
        img: getIconSrc(ARROW_UP),
    },
    arrowNeutral: {
        template: "ARROW_RIGHT",
        img: getIconSrc(ARROW_RIGHT),
    },
    arrowBad: {
        template: "ARROW_DOWN",
        img: getIconSrc(ARROW_DOWN),
    },
    smileyGood: {
        template: "SMILE",
        img: getIconSrc(SMILE),
    },
    smileyNeutral: {
        template: "MEH",
        img: getIconSrc(MEH),
    },
    smileyBad: {
        template: "FROWN",
        img: getIconSrc(FROWN),
    },
    dotGood: {
        template: "GREEN_DOT",
        img: getIconSrc(GREEN_DOT),
    },
    dotNeutral: {
        template: "YELLOW_DOT",
        img: getIconSrc(YELLOW_DOT),
    },
    dotBad: {
        template: "RED_DOT",
        img: getIconSrc(RED_DOT),
    },
};
const ICON_SETS = {
    arrows: {
        good: "arrowGood",
        neutral: "arrowNeutral",
        bad: "arrowBad",
    },
    smiley: {
        good: "smileyGood",
        neutral: "smileyNeutral",
        bad: "smileyBad",
    },
    dots: {
        good: "dotGood",
        neutral: "dotNeutral",
        bad: "dotBad",
    },
};
iconsOnCellRegistry.add("conditional_formatting", (getters, position) => {
    const icon = getters.getConditionalIcon(position);
    if (icon) {
        return ICONS[icon].img;
    }
});

/**
 * Map of the different types of conversions warnings and their name in error messages
 */
var WarningTypes;
(function (WarningTypes) {
    WarningTypes["DiagonalBorderNotSupported"] = "Diagonal Borders";
    WarningTypes["BorderStyleNotSupported"] = "Border style";
    WarningTypes["FillStyleNotSupported"] = "Fill Style";
    WarningTypes["FontNotSupported"] = "Font";
    WarningTypes["HorizontalAlignmentNotSupported"] = "Horizontal Alignment";
    WarningTypes["VerticalAlignmentNotSupported"] = "Vertical Alignments";
    WarningTypes["MultipleRulesCfNotSupported"] = "Multiple rules conditional formats";
    WarningTypes["CfTypeNotSupported"] = "Conditional format type";
    WarningTypes["CfFormatBorderNotSupported"] = "Borders in conditional formats";
    WarningTypes["CfFormatAlignmentNotSupported"] = "Alignment in conditional formats";
    WarningTypes["CfFormatNumFmtNotSupported"] = "Num formats in conditional formats";
    WarningTypes["CfIconSetEmptyIconNotSupported"] = "IconSets with empty icons";
    WarningTypes["BadlyFormattedHyperlink"] = "Badly formatted hyperlink";
    WarningTypes["NumFmtIdNotSupported"] = "Number format";
    WarningTypes["TimeDataValidationNotSupported"] = "Time data validation rules";
    WarningTypes["TextLengthDataValidationNotSupported"] = "Text length data validation rules";
    WarningTypes["WholeNumberDataValidationNotSupported"] = "Whole number data validation rules";
    WarningTypes["NotEqualDateDataValidationNotSupported"] = "Not equal date data validation rules";
})(WarningTypes || (WarningTypes = {}));
class XLSXImportWarningManager {
    _parsingWarnings = new Set();
    _conversionWarnings = new Set();
    addParsingWarning(warning) {
        this._parsingWarnings.add(warning);
    }
    addConversionWarning(warning) {
        this._conversionWarnings.add(warning);
    }
    get warnings() {
        return [...this._parsingWarnings, ...this._conversionWarnings];
    }
    /**
     * Add a warning "... is not supported" to the manager.
     *
     * @param type the type of the warning to add
     * @param name optional, name of the element that was not supported
     * @param supported optional, list of the supported elements
     */
    generateNotSupportedWarning(type, name, supported) {
        let warning = `${type} ${name ? '"' + name + '" is' : "are"} not yet supported. `;
        if (supported) {
            warning += `Only ${supported.join(", ")} are currently supported.`;
        }
        if (!this._conversionWarnings.has(warning)) {
            this._conversionWarnings.add(warning);
        }
    }
}

const SUPPORTED_BORDER_STYLES = ["thin", "medium", "thick", "dashed", "dotted"];
const SUPPORTED_HORIZONTAL_ALIGNMENTS = [
    "general",
    "left",
    "center",
    "right",
];
const SUPPORTED_VERTICAL_ALIGNMENTS = ["top", "center", "bottom"];
const SUPPORTED_FONTS = ["Arial"];
const SUPPORTED_FILL_PATTERNS = ["solid"];
const SUPPORTED_CF_TYPES = [
    "expression",
    "cellIs",
    "colorScale",
    "iconSet",
    "containsText",
    "notContainsText",
    "beginsWith",
    "endsWith",
    "containsBlanks",
    "notContainsBlanks",
];
/** Map between cell type in XLSX file and human readable cell type  */
const CELL_TYPE_CONVERSION_MAP = {
    b: "boolean",
    d: "date",
    e: "error",
    inlineStr: "inlineStr",
    n: "number",
    s: "sharedString",
    str: "str",
};
/** Conversion map Border Style in XLSX <=> Border style in o_spreadsheet*/
const BORDER_STYLE_CONVERSION_MAP = {
    dashDot: "thin",
    dashDotDot: "thin",
    dashed: "dashed",
    dotted: "dotted",
    double: "thin",
    hair: "thin",
    medium: "medium",
    mediumDashDot: "thin",
    mediumDashDotDot: "thin",
    mediumDashed: "thin",
    none: undefined,
    slantDashDot: "thin",
    thick: "thick",
    thin: "thin",
};
/** Conversion map Horizontal Alignment in XLSX <=> Horizontal Alignment in o_spreadsheet*/
const H_ALIGNMENT_CONVERSION_MAP = {
    general: undefined,
    left: "left",
    center: "center",
    right: "right",
    fill: "left",
    justify: "left",
    centerContinuous: "center",
    distributed: "center",
};
/** Conversion map Vertical Alignment in XLSX => Vertical Alignment in o_spreadsheet */
const V_ALIGNMENT_CONVERSION_MAP = {
    top: "top",
    center: "middle",
    bottom: "bottom",
    justify: "middle",
    distributed: "middle",
};
/** Conversion map Vertical Alignment in o-spreadsheet => Vertical Alignment in XLSX */
const V_ALIGNMENT_EXPORT_CONVERSION_MAP = {
    top: "top",
    middle: "center",
    bottom: "bottom",
};
/** Convert the "CellIs" cf operator.
 * We have all the operators that the xlsx have, but ours begin with a uppercase character */
function convertCFCellIsOperator(xlsxCfOperator) {
    return (xlsxCfOperator.slice(0, 1).toUpperCase() +
        xlsxCfOperator.slice(1));
}
/** Conversion map CF types in XLSX <=> Cf types in o_spreadsheet */
const CF_TYPE_CONVERSION_MAP = {
    aboveAverage: undefined,
    expression: undefined,
    cellIs: undefined, // exist but isn't an operator in o_spreadsheet
    colorScale: undefined, // exist but isn't an operator in o_spreadsheet
    dataBar: undefined,
    iconSet: undefined, // exist but isn't an operator in o_spreadsheet
    top10: undefined,
    uniqueValues: undefined,
    duplicateValues: undefined,
    containsText: "ContainsText",
    notContainsText: "NotContains",
    beginsWith: "BeginsWith",
    endsWith: "EndsWith",
    containsBlanks: "IsEmpty",
    notContainsBlanks: "IsNotEmpty",
    containsErrors: undefined,
    notContainsErrors: undefined,
    timePeriod: undefined,
};
/** Conversion map CF thresholds types in XLSX <=> Cf thresholds types in o_spreadsheet */
const CF_THRESHOLD_CONVERSION_MAP = {
    num: "number",
    percent: "percentage",
    max: "value",
    min: "value",
    percentile: "percentile",
    formula: "formula",
};
/**
 * Conversion map between Excels IconSets and our own IconSets. The string is the key of the iconset in the ICON_SETS constant.
 *
 * NoIcons is undefined instead of an empty string because we don't support it and need to mange it separately.
 */
const ICON_SET_CONVERSION_MAP = {
    NoIcons: undefined,
    "3Arrows": "arrows",
    "3ArrowsGray": "arrows",
    "3Symbols": "smiley",
    "3Symbols2": "smiley",
    "3Signs": "dots",
    "3Flags": "dots",
    "3TrafficLights1": "dots",
    "3TrafficLights2": "dots",
    "4Arrows": "arrows",
    "4ArrowsGray": "arrows",
    "4RedToBlack": "dots",
    "4Rating": "smiley",
    "4TrafficLights": "dots",
    "5Arrows": "arrows",
    "5ArrowsGray": "arrows",
    "5Rating": "smiley",
    "5Quarters": "dots",
    "3Stars": "smiley",
    "3Triangles": "arrows",
    "5Boxes": "dots",
};
/** Map between legend position in XLSX file and human readable position  */
const DRAWING_LEGEND_POSITION_CONVERSION_MAP = {
    b: "bottom",
    t: "top",
    l: "left",
    r: "right",
    tr: "right",
};
/** Conversion map chart types in XLSX <=> Cf chart types o_spreadsheet (undefined for unsupported chart types)*/
const CHART_TYPE_CONVERSION_MAP = {
    areaChart: undefined,
    area3DChart: undefined,
    lineChart: "line",
    line3DChart: undefined,
    stockChart: undefined,
    radarChart: undefined,
    scatterChart: "scatter",
    pieChart: "pie",
    pie3DChart: undefined,
    doughnutChart: "pie",
    barChart: "bar",
    bar3DChart: undefined,
    ofPieChart: undefined,
    surfaceChart: undefined,
    surface3DChart: undefined,
    bubbleChart: undefined,
    comboChart: "combo",
};
/** Conversion map for the SUBTOTAL(index, formula) function in xlsx, index <=> actual function*/
const SUBTOTAL_FUNCTION_CONVERSION_MAP = {
    "1": "AVERAGE",
    "2": "COUNT",
    "3": "COUNTA",
    "4": "MAX",
    "5": "MIN",
    "6": "PRODUCT",
    "7": "STDEV",
    "8": "STDEVP",
    "9": "SUM",
    "10": "VAR",
    "11": "VARP",
    "101": "AVERAGE",
    "102": "COUNT",
    "103": "COUNTA",
    "104": "MAX",
    "105": "MIN",
    "106": "PRODUCT",
    "107": "STDEV",
    "108": "STDEVP",
    "109": "SUM",
    "110": "VAR",
    "111": "VARP",
};
/** Mapping between Excel format indexes (see XLSX_FORMAT_MAP) and some supported formats  */
const XLSX_FORMATS_CONVERSION_MAP = {
    0: "",
    1: "0",
    2: "0.00",
    3: "#,#00",
    4: "#,##0.00",
    9: "0%",
    10: "0.00%",
    11: undefined,
    12: undefined,
    13: undefined,
    14: "m/d/yyyy",
    15: "m/d/yyyy",
    16: "m/d/yyyy",
    17: "m/d/yyyy",
    18: "hh:mm:ss a",
    19: "hh:mm:ss a",
    20: "hhhh:mm:ss",
    21: "hhhh:mm:ss",
    22: "m/d/yy h:mm",
    37: undefined,
    38: undefined,
    39: undefined,
    40: undefined,
    45: "hhhh:mm:ss",
    46: "hhhh:mm:ss",
    47: "hhhh:mm:ss",
    48: undefined,
    49: "@",
};
/**
 * Mapping format index to format defined by default
 *
 * OpenXML $18.8.30
 * */
const XLSX_FORMAT_MAP = {
    "0": 1,
    "0.00": 2,
    "#,#00": 3,
    "#,##0.00": 4,
    "0%": 9,
    "0.00%": 10,
    "0.00E+00": 11,
    "# ?/?": 12,
    "# ??/??": 13,
    "mm-dd-yy": 14,
    "d-mm-yy": 15,
    "mm-yy": 16,
    "mmm-yy": 17,
    "h:mm AM/PM": 18,
    "h:mm:ss AM/PM": 19,
    "h:mm": 20,
    "h:mm:ss": 21,
    "m/d/yy h:mm": 22,
    "#,##0 ;(#,##0)": 37,
    "#,##0 ;[Red](#,##0)": 38,
    "#,##0.00;(#,##0.00)": 39,
    "#,##0.00;[Red](#,##0.00)": 40,
    "mm:ss": 45,
    "[h]:mm:ss": 46,
    "mmss.0": 47,
    "##0.0E+0": 48,
    "@": 49,
    "hh:mm:ss a": 19, // TODO: discuss: this format is not recognized by excel for example (doesn't follow their guidelines I guess)
};
/** OpenXML $18.8.27 */
const XLSX_INDEXED_COLORS = {
    0: "000000",
    1: "FFFFFF",
    2: "FF0000",
    3: "00FF00",
    4: "0000FF",
    5: "FFFF00",
    6: "FF00FF",
    7: "00FFFF",
    8: "000000",
    9: "FFFFFF",
    10: "FF0000",
    11: "00FF00",
    12: "0000FF",
    13: "FFFF00",
    14: "FF00FF",
    15: "00FFFF",
    16: "800000",
    17: "008000",
    18: "000080",
    19: "808000",
    20: "800080",
    21: "008080",
    22: "C0C0C0",
    23: "808080",
    24: "9999FF",
    25: "993366",
    26: "FFFFCC",
    27: "CCFFFF",
    28: "660066",
    29: "FF8080",
    30: "0066CC",
    31: "CCCCFF",
    32: "000080",
    33: "FF00FF",
    34: "FFFF00",
    35: "00FFFF",
    36: "800080",
    37: "800000",
    38: "008080",
    39: "0000FF",
    40: "00CCFF",
    41: "CCFFFF",
    42: "CCFFCC",
    43: "FFFF99",
    44: "99CCFF",
    45: "FF99CC",
    46: "CC99FF",
    47: "FFCC99",
    48: "3366FF",
    49: "33CCCC",
    50: "99CC00",
    51: "FFCC00",
    52: "FF9900",
    53: "FF6600",
    54: "666699",
    55: "969696",
    56: "003366",
    57: "339966",
    58: "003300",
    59: "333300",
    60: "993300",
    61: "993366",
    62: "333399",
    63: "333333",
    64: "000000", // system foreground
    65: "FFFFFF", // system background
};
const IMAGE_MIMETYPE_TO_EXTENSION_MAPPING = {
    "image/avif": "avif",
    "image/bmp": "bmp",
    "image/gif": "gif",
    "image/vnd.microsoft.icon": "ico",
    "image/jpeg": "jpeg",
    "image/png": "png",
    "image/tiff": "tiff",
    "image/webp": "webp",
};
const IMAGE_EXTENSION_TO_MIMETYPE_MAPPING = {
    avif: "image/avif",
    bmp: "image/bmp",
    gif: "image/gif",
    ico: "image/vnd.microsoft.icon",
    jpeg: "image/jpeg",
    png: "image/png",
    tiff: "image/tiff",
    webp: "image/webp",
    jpg: "image/jpeg",
};
const XLSX_DV_DECIMAL_OPERATOR_MAPPING = {
    between: "isBetween",
    notBetween: "isNotBetween",
    equal: "isEqual",
    notEqual: "isNotEqual",
    greaterThan: "isGreaterThan",
    greaterThanOrEqual: "isGreaterOrEqualTo",
    lessThan: "isLessThan",
    lessThanOrEqual: "isLessOrEqualTo",
};
const XLSX_DV_DATE_OPERATOR_TO_DV_TYPE_MAPPING = {
    between: "dateIsBetween",
    notBetween: "dateIsNotBetween",
    equal: "dateIs",
    greaterThan: "dateIsAfter",
    greaterThanOrEqual: "dateIsOnOrAfter",
    lessThan: "dateIsBefore",
    lessThanOrEqual: "dateIsOnOrBefore",
};

/**
 * Most of the functions could stay private, but are exported for testing purposes
 */
/**
 *
 * Extract the color referenced inside of an XML element and return it as an hex string #RRGGBBAA (or #RRGGBB
 * if alpha = FF)
 *
 *  The color is an attribute of the element that can be :
 *  - rgb : an rgb string
 *  - theme : a reference to a theme element
 *  - auto : automatic coloring. Return const AUTO_COLOR in constants.ts.
 *  - indexed : a legacy indexing scheme for colors. The only value that should be present in a xlsx is
 *      64 = System Foreground, that we can replace with AUTO_COLOR.
 */
function convertColor(xlsxColor) {
    if (!xlsxColor) {
        return undefined;
    }
    let rgb;
    if (xlsxColor.rgb) {
        rgb = xlsxColor.rgb;
    }
    else if (xlsxColor.auto) {
        rgb = AUTO_COLOR;
    }
    else if (xlsxColor.indexed) {
        rgb = XLSX_INDEXED_COLORS[xlsxColor.indexed];
    }
    else {
        return undefined;
    }
    rgb = xlsxColorToHEXA(rgb);
    if (xlsxColor.tint) {
        rgb = applyTint(rgb, xlsxColor.tint);
    }
    rgb = rgb.toUpperCase();
    // Remove unnecessary alpha
    if (rgb.length === 9 && rgb.endsWith("FF")) {
        rgb = rgb.slice(0, 7);
    }
    return rgb;
}
/**
 * Convert a hex color AARRGGBB (or RRGGBB)(representation inside XLSX Xmls) to a standard js color
 * representation #RRGGBBAA
 */
function xlsxColorToHEXA(color) {
    if (color.length === 6)
        return "#" + color + "FF";
    return "#" + color.slice(2) + color.slice(0, 2);
}
/**
 *  Apply tint to a color (see OpenXml spec §18.3.1.15);
 */
function applyTint(color, tint) {
    const rgba = colorToRGBA(color);
    const hsla = rgbaToHSLA(rgba);
    if (tint < 0) {
        hsla.l = hsla.l * (1 + tint);
    }
    if (tint > 0) {
        hsla.l = hsla.l * (1 - tint) + (100 - 100 * (1 - tint));
    }
    return rgbaToHex(hslaToRGBA(hsla));
}
/**
 * Convert a hex + alpha color string to an integer representation. Also remove the alpha.
 *
 * eg. #FF0000FF => 4278190335
 */
function hexaToInt(hex) {
    if (hex.length === 9) {
        hex = hex.slice(0, 7);
    }
    return parseInt(hex.replace("#", ""), 16);
}
/**
 * When defining style (fontColor, borderColor for instance)
 * Excel will specify rgb="FF000000"
 * In that case, We should not consider this value as user-defined but
 * rather like an instruction: "Use your system default"
 */
const DEFAULT_SYSTEM_COLOR = "FF000000";

/**
 * Get the relative path between two files
 *
 * Eg.:
 * from "folder1/file1.txt" to "folder2/file2.txt" => "../folder2/file2.txt"
 */
function getRelativePath(from, to) {
    const fromPathParts = from.split("/");
    const toPathParts = to.split("/");
    let relPath = "";
    let startIndex = 0;
    for (let i = 0; i < fromPathParts.length - 1; i++) {
        if (fromPathParts[i] === toPathParts[i]) {
            startIndex++;
        }
        else {
            relPath += "../";
        }
    }
    relPath += toPathParts.slice(startIndex).join("/");
    return relPath;
}
/**
 * Convert an array of element into an object where the objects keys were the elements position in the array.
 * Can give an offset as argument, and all the array indexes will we shifted by this offset in the returned object.
 *
 * eg. : ["a", "b"] => {0:"a", 1:"b"}
 */
function arrayToObject(array, indexOffset = 0) {
    const obj = {};
    for (let i = 0; i < array.length; i++) {
        if (array[i]) {
            obj[i + indexOffset] = array[i];
        }
    }
    return obj;
}
/**
 * In xlsx we can have string with unicode characters with the format _x00fa_.
 * Replace with characters understandable by JS
 */
function fixXlsxUnicode(str) {
    return str.replace(/_x([0-9a-zA-Z]{4})_/g, (match, code) => {
        return String.fromCharCode(parseInt(code, 16));
    });
}
/** Get a header in the SheetData. Create the header if it doesn't exist in the SheetData */
function getSheetDataHeader(sheetData, dimension, index) {
    if (dimension === "COL") {
        if (!sheetData.cols[index]) {
            sheetData.cols[index] = {};
        }
        return sheetData.cols[index];
    }
    if (!sheetData.rows[index]) {
        sheetData.rows[index] = {};
    }
    return sheetData.rows[index];
}

const XLSX_DATE_FORMAT_REGEX = /^(yy|yyyy|m{1,5}|d{1,4}|h{1,2}|s{1,2}|am\/pm|a\/m|\s|-|\/|\.|:)+$/i;
/**
 * Convert excel format to o_spreadsheet format
 *
 * Excel format are defined in openXML §18.8.31
 */
function convertXlsxFormat(numFmtId, formats, warningManager) {
    if (numFmtId === 0) {
        return undefined;
    }
    // Format is either defined in the imported data, or the formatId is defined in openXML §18.8.30
    let format = XLSX_FORMATS_CONVERSION_MAP[numFmtId] || formats.find((f) => f.id === numFmtId)?.format;
    if (format) {
        try {
            let convertedFormat = format.replace(/\[(.*)-[A-Z0-9]{3}\]/g, "[$1]"); // remove currency and locale/date system/number system info (ECMA §18.8.31)
            convertedFormat = convertedFormat.replace(/\[\$\]/g, ""); // remove empty bocks
            convertedFormat = convertedFormat.replace(/_.{1}/g, ""); // _ === ignore width of next char for align purposes. Not supported ATM
            convertedFormat = convertedFormat.replace(/\*.{1}/g, ""); // * === repeat next character enough to fill the line. Not supported ATM
            if (isXlsxDateFormat(convertedFormat)) {
                convertedFormat = convertDateFormat$1(convertedFormat);
            }
            if (isFormatSupported(convertedFormat)) {
                return convertedFormat;
            }
        }
        catch (e) { }
    }
    warningManager.generateNotSupportedWarning(WarningTypes.NumFmtIdNotSupported, format || `nmFmtId ${numFmtId}`);
    return undefined;
}
function isFormatSupported(format) {
    try {
        formatValue(0, { format, locale: DEFAULT_LOCALE });
        return true;
    }
    catch (e) {
        return false;
    }
}
function isXlsxDateFormat(format) {
    return XLSX_DATE_FORMAT_REGEX.test(format);
}
function convertDateFormat$1(format) {
    // Some of these aren't defined neither in the OpenXML spec not the Xlsx extension of OpenXML,
    // but can still occur and are supported by Excel/Google sheets
    format = format.toLowerCase();
    format = format.replace(/mmmmm/g, "mmm");
    format = format.replace(/am\/pm|a\/m/g, "a");
    format = format.replace(/hhhh/g, "hh");
    format = format.replace(/\bh\b/g, "hh");
    return format;
}

function convertBorders(data, warningManager) {
    const borderArray = data.borders.map((border) => {
        addBorderWarnings(border, warningManager);
        const b = {
            top: convertBorderDescr$1(border.top, warningManager),
            bottom: convertBorderDescr$1(border.bottom, warningManager),
            left: convertBorderDescr$1(border.left, warningManager),
            right: convertBorderDescr$1(border.right, warningManager),
        };
        Object.keys(b).forEach((key) => b[key] === undefined && delete b[key]);
        return b;
    });
    return arrayToObject(borderArray, 1);
}
function convertBorderDescr$1(borderDescr, warningManager) {
    if (!borderDescr)
        return undefined;
    addBorderDescrWarnings(borderDescr, warningManager);
    const style = BORDER_STYLE_CONVERSION_MAP[borderDescr.style];
    return style ? { style, color: convertColor(borderDescr.color) } : undefined;
}
function convertStyles(data, warningManager) {
    const stylesArray = data.styles.map((style) => {
        return convertStyle({
            fontStyle: data.fonts[style.fontId],
            fillStyle: data.fills[style.fillId],
            alignment: style.alignment,
        }, warningManager);
    });
    return arrayToObject(stylesArray, 1);
}
function convertStyle(styleStruct, warningManager) {
    addStyleWarnings(styleStruct?.fontStyle, styleStruct?.fillStyle, warningManager);
    addHorizontalAlignmentWarnings(styleStruct?.alignment?.horizontal, warningManager);
    addVerticalAlignmentWarnings(styleStruct?.alignment?.vertical, warningManager);
    return {
        bold: styleStruct.fontStyle?.bold,
        italic: styleStruct.fontStyle?.italic,
        strikethrough: styleStruct.fontStyle?.strike,
        underline: styleStruct.fontStyle?.underline,
        verticalAlign: styleStruct.alignment?.vertical
            ? V_ALIGNMENT_CONVERSION_MAP[styleStruct.alignment.vertical]
            : undefined,
        align: styleStruct.alignment?.horizontal
            ? H_ALIGNMENT_CONVERSION_MAP[styleStruct.alignment.horizontal]
            : undefined,
        // In xlsx fills, bgColor is the color of the fill, and fgColor is the color of the pattern above the background, except in solid fills
        fillColor: styleStruct.fillStyle?.patternType === "solid"
            ? convertColor(styleStruct.fillStyle?.fgColor)
            : convertColor(styleStruct.fillStyle?.bgColor),
        textColor: convertColor(styleStruct.fontStyle?.color),
        fontSize: styleStruct.fontStyle?.size,
        wrapping: styleStruct.alignment?.wrapText ? "wrap" : "overflow",
    };
}
function convertFormats(data, warningManager) {
    const formats = [];
    for (let style of data.styles) {
        const format = convertXlsxFormat(style.numFmtId, data.numFmts, warningManager);
        if (format) {
            formats[style.numFmtId] = format;
        }
    }
    return arrayToObject(formats, 1);
}
// ---------------------------------------------------------------------------
// Warnings
// ---------------------------------------------------------------------------
function addStyleWarnings(font, fill, warningManager) {
    if (font && font.name && !SUPPORTED_FONTS.includes(font.name)) {
        warningManager.generateNotSupportedWarning(WarningTypes.FontNotSupported, font.name, SUPPORTED_FONTS);
    }
    if (fill && fill.patternType && !SUPPORTED_FILL_PATTERNS.includes(fill.patternType)) {
        warningManager.generateNotSupportedWarning(WarningTypes.FillStyleNotSupported, fill.patternType, SUPPORTED_FILL_PATTERNS);
    }
}
function addBorderDescrWarnings(borderDescr, warningManager) {
    if (!SUPPORTED_BORDER_STYLES.includes(borderDescr.style)) {
        warningManager.generateNotSupportedWarning(WarningTypes.BorderStyleNotSupported, borderDescr.style, SUPPORTED_BORDER_STYLES);
    }
}
function addBorderWarnings(border, warningManager) {
    if (border.diagonal) {
        warningManager.generateNotSupportedWarning(WarningTypes.DiagonalBorderNotSupported);
    }
}
function addHorizontalAlignmentWarnings(alignment, warningManager) {
    if (alignment && !SUPPORTED_HORIZONTAL_ALIGNMENTS.includes(alignment)) {
        warningManager.generateNotSupportedWarning(WarningTypes.HorizontalAlignmentNotSupported, alignment, SUPPORTED_HORIZONTAL_ALIGNMENTS);
    }
}
function addVerticalAlignmentWarnings(alignment, warningManager) {
    if (alignment && !SUPPORTED_VERTICAL_ALIGNMENTS.includes(alignment)) {
        warningManager.generateNotSupportedWarning(WarningTypes.VerticalAlignmentNotSupported, alignment, SUPPORTED_VERTICAL_ALIGNMENTS);
    }
}

function convertConditionalFormats(xlsxCfs, dxfs, warningManager) {
    const cfs = [];
    let cfId = 1;
    for (let cf of xlsxCfs) {
        if (cf.cfRules.length === 0)
            continue;
        addCfConversionWarnings(cf, dxfs, warningManager);
        const rule = cf.cfRules[0];
        let operator;
        const values = [];
        if (rule.dxfId === undefined && !(rule.type === "colorScale" || rule.type === "iconSet"))
            continue;
        switch (rule.type) {
            case "aboveAverage":
            case "containsErrors":
            case "notContainsErrors":
            case "dataBar":
            case "duplicateValues":
            case "expression":
            case "top10":
            case "uniqueValues":
            case "timePeriod":
                // Not supported
                continue;
            case "colorScale":
                const colorScale = convertColorScale(cfId++, cf);
                if (colorScale) {
                    cfs.push(colorScale);
                }
                continue;
            case "iconSet":
                const iconSet = convertIconSet(cfId++, cf, warningManager);
                if (iconSet) {
                    cfs.push(iconSet);
                }
                continue;
            case "containsText":
            case "notContainsText":
            case "beginsWith":
            case "endsWith":
                if (!rule.text)
                    continue;
                operator = CF_TYPE_CONVERSION_MAP[rule.type];
                values.push(rule.text);
                break;
            case "containsBlanks":
            case "notContainsBlanks":
                operator = CF_TYPE_CONVERSION_MAP[rule.type];
                break;
            case "cellIs":
                if (!rule.operator || !rule.formula || rule.formula.length === 0)
                    continue;
                operator = convertCFCellIsOperator(rule.operator);
                values.push(rule.formula[0]);
                if (rule.formula.length === 2) {
                    values.push(rule.formula[1]);
                }
                break;
        }
        if (operator && rule.dxfId !== undefined) {
            cfs.push({
                id: (cfId++).toString(),
                ranges: cf.sqref,
                stopIfTrue: rule.stopIfTrue,
                rule: {
                    type: "CellIsRule",
                    operator: operator,
                    values: values,
                    style: convertStyle({ fontStyle: dxfs[rule.dxfId].font, fillStyle: dxfs[rule.dxfId].fill }, warningManager),
                },
            });
        }
    }
    return cfs;
}
function convertColorScale(id, xlsxCf) {
    const scale = xlsxCf.cfRules[0].colorScale;
    if (!scale ||
        scale.cfvos.length !== scale.colors.length ||
        scale.cfvos.length < 2 ||
        scale.cfvos.length > 3) {
        return undefined;
    }
    const thresholds = [];
    for (let i = 0; i < scale.cfvos.length; i++) {
        thresholds.push({
            color: hexaToInt(convertColor(scale.colors[i]) || "#FFFFFF"),
            type: CF_THRESHOLD_CONVERSION_MAP[scale.cfvos[i].type],
            value: scale.cfvos[i].value,
        });
    }
    const minimum = thresholds[0];
    const maximum = thresholds.length === 2 ? thresholds[1] : thresholds[2];
    const midpoint = thresholds.length === 3 ? thresholds[1] : undefined;
    return {
        id: id.toString(),
        stopIfTrue: xlsxCf.cfRules[0].stopIfTrue,
        ranges: xlsxCf.sqref,
        rule: { type: "ColorScaleRule", minimum, midpoint, maximum },
    };
}
/**
 * Convert Icons Sets.
 *
 * In the Xlsx extension of OpenXml, the IconSets can either be simply an IconSet, or a list of Icons
 *  (ie. their respective IconSet and their id in this set).
 *
 * In the case of a list of icons :
 *  - The order of the icons is lower => middle => upper
 *  - The their ids are :  0 : bad, 1 : neutral, 2 : good
 */
function convertIconSet(id, xlsxCf, warningManager) {
    const xlsxIconSet = xlsxCf.cfRules[0].iconSet;
    if (!xlsxIconSet)
        return undefined;
    let cfVos = xlsxIconSet.cfvos;
    let cfIcons = xlsxIconSet.cfIcons;
    if (cfVos.length < 3 || (cfIcons && cfIcons.length < 3)) {
        return undefined;
    }
    // We don't support icon sets with more than 3 icons, so take the extrema and the middle.
    if (cfVos.length > 3) {
        cfVos = [cfVos[0], cfVos[Math.floor(cfVos.length / 2)], cfVos[cfVos.length - 1]];
    }
    if (cfIcons && cfIcons.length > 3) {
        cfIcons = [cfIcons[0], cfIcons[Math.floor(cfIcons.length / 2)], cfIcons[cfIcons.length - 1]];
    }
    // In xlsx, the thresholds are NOT in the first cfVo, but on the second and third
    const thresholds = [];
    for (let i = 1; i <= 2; i++) {
        const type = CF_THRESHOLD_CONVERSION_MAP[cfVos[i].type];
        if (type === "value") {
            return undefined;
        }
        thresholds.push({
            value: cfVos[i].value || "",
            operator: cfVos[i].gte ? "ge" : "gt",
            type: type,
        });
    }
    let icons = {
        lower: cfIcons
            ? convertIcons(cfIcons[0].iconSet, cfIcons[0].iconId)
            : convertIcons(xlsxIconSet.iconSet, 0),
        middle: cfIcons
            ? convertIcons(cfIcons[1].iconSet, cfIcons[1].iconId)
            : convertIcons(xlsxIconSet.iconSet, 1),
        upper: cfIcons
            ? convertIcons(cfIcons[2].iconSet, cfIcons[2].iconId)
            : convertIcons(xlsxIconSet.iconSet, 2),
    };
    if (xlsxIconSet.reverse) {
        icons = { upper: icons.lower, middle: icons.middle, lower: icons.upper };
    }
    // We don't support empty icons in an IconSet, put a dot icon instead
    for (let key of Object.keys(icons)) {
        if (!icons[key]) {
            warningManager.generateNotSupportedWarning(WarningTypes.CfIconSetEmptyIconNotSupported);
            switch (key) {
                case "upper":
                    icons[key] = ICON_SETS.dots.good;
                    break;
                case "middle":
                    icons[key] = ICON_SETS.dots.neutral;
                    break;
                case "lower":
                    icons[key] = ICON_SETS.dots.bad;
                    break;
            }
        }
    }
    return {
        id: id.toString(),
        stopIfTrue: xlsxCf.cfRules[0].stopIfTrue,
        ranges: xlsxCf.sqref,
        rule: {
            type: "IconSetRule",
            icons: icons,
            upperInflectionPoint: thresholds[1],
            lowerInflectionPoint: thresholds[0],
        },
    };
}
/**
 * Convert an icon from a XLSX.
 *
 * The indexes are : 0 : bad, 1 : neutral, 2 : good
 */
function convertIcons(xlsxIconSet, index) {
    const iconSet = ICON_SET_CONVERSION_MAP[xlsxIconSet];
    if (!iconSet)
        return "";
    return index === 0
        ? ICON_SETS[iconSet].bad
        : index === 1
            ? ICON_SETS[iconSet].neutral
            : ICON_SETS[iconSet].good;
}
// ---------------------------------------------------------------------------
// Warnings
// ---------------------------------------------------------------------------
function addCfConversionWarnings(cf, dxfs, warningManager) {
    if (cf.cfRules.length > 1) {
        warningManager.generateNotSupportedWarning(WarningTypes.MultipleRulesCfNotSupported);
    }
    if (!SUPPORTED_CF_TYPES.includes(cf.cfRules[0].type)) {
        warningManager.generateNotSupportedWarning(WarningTypes.CfTypeNotSupported, cf.cfRules[0].type);
    }
    if (cf.cfRules[0].dxfId) {
        const dxf = dxfs[cf.cfRules[0].dxfId];
        if (dxf.border) {
            warningManager.generateNotSupportedWarning(WarningTypes.CfFormatBorderNotSupported);
        }
        if (dxf.alignment) {
            warningManager.generateNotSupportedWarning(WarningTypes.CfFormatAlignmentNotSupported);
        }
        if (dxf.numFmt) {
            warningManager.generateNotSupportedWarning(WarningTypes.CfFormatNumFmtNotSupported);
        }
    }
}

// -------------------------------------
//            CF HELPERS
// -------------------------------------
/**
 * Convert the conditional formatting o-spreadsheet operator to
 * the corresponding excel operator.
 * */
function convertOperator(operator) {
    switch (operator) {
        case "IsNotEmpty":
            return "notContainsBlanks";
        case "IsEmpty":
            return "containsBlanks";
        case "NotContains":
            return "notContainsBlanks";
        default:
            return operator.charAt(0).toLowerCase() + operator.slice(1);
    }
}
// -------------------------------------
//        WORKSHEET HELPERS
// -------------------------------------
function getCellType(value) {
    switch (typeof value) {
        case "boolean":
            return "b";
        case "string":
            return "str";
        case "number":
            return "n";
        default:
            return undefined;
    }
}
function convertHeightToExcel(height) {
    return Math.round(HEIGHT_FACTOR * height * 100) / 100;
}
function convertWidthToExcel(width) {
    return Math.round(WIDTH_FACTOR * width * 100) / 100;
}
function convertHeightFromExcel(height) {
    if (!height)
        return height;
    return Math.round((height / HEIGHT_FACTOR) * 100) / 100;
}
function convertWidthFromExcel(width) {
    if (!width)
        return width;
    return Math.round((width / WIDTH_FACTOR) * 100) / 100;
}
function extractStyle(cell, data) {
    let style = {};
    if (cell.style) {
        style = data.styles[cell.style];
    }
    const format = extractFormat(cell, data);
    const styles = {
        font: {
            size: style?.fontSize || DEFAULT_FONT_SIZE,
            color: { rgb: style?.textColor ? style.textColor : "000000" },
            family: 2,
            name: "Arial",
        },
        fill: style?.fillColor
            ? {
                fgColor: { rgb: style.fillColor },
            }
            : { reservedAttribute: "none" },
        numFmt: format ? { format: format, id: 0 /* id not used for export */ } : undefined,
        border: cell.border || 0,
        alignment: {
            horizontal: style.align,
            vertical: style.verticalAlign
                ? V_ALIGNMENT_EXPORT_CONVERSION_MAP[style.verticalAlign]
                : undefined,
            wrapText: style.wrapping === "wrap" || cell.content?.includes(NEWLINE) ? true : undefined,
        },
    };
    styles.font["strike"] = !!style?.strikethrough || undefined;
    styles.font["underline"] = !!style?.underline || undefined;
    styles.font["bold"] = !!style?.bold || undefined;
    styles.font["italic"] = !!style?.italic || undefined;
    return styles;
}
function extractFormat(cell, data) {
    if (cell.format) {
        return data.formats[cell.format];
    }
    return undefined;
}
function normalizeStyle(construct, styles) {
    // Normalize this
    const numFmtId = convertFormat(styles["numFmt"], construct.numFmts);
    const style = {
        fontId: pushElement(styles.font, construct.fonts),
        fillId: pushElement(styles.fill, construct.fills),
        borderId: styles.border,
        numFmtId,
        alignment: {
            vertical: styles.alignment.vertical,
            horizontal: styles.alignment.horizontal,
            wrapText: styles.alignment.wrapText,
        },
    };
    return pushElement(style, construct.styles);
}
function convertFormat(format, numFmtStructure) {
    if (!format) {
        return 0;
    }
    let formatId = XLSX_FORMAT_MAP[format.format];
    if (!formatId) {
        formatId = pushElement(format, numFmtStructure) + FIRST_NUMFMT_ID;
    }
    return formatId;
}
/**
 * Add a relation to the given file and return its id.
 */
function addRelsToFile(relsFiles, path, rel) {
    let relsFile = relsFiles.find((file) => file.path === path);
    // the id is a one-based int casted as string
    let id;
    if (!relsFile) {
        id = "rId1";
        relsFiles.push({ path, rels: [{ ...rel, id }] });
    }
    else {
        id = `rId${(relsFile.rels.length + 1).toString()}`;
        relsFile.rels.push({
            ...rel,
            id,
        });
    }
    return id;
}
const globalReverseLookup = new WeakMap();
function pushElement(property, propertyList) {
    let reverseLookup = globalReverseLookup.get(propertyList);
    if (!reverseLookup) {
        reverseLookup = new Map();
        for (let i = 0; i < propertyList.length; i++) {
            const canonical = getCanonicalRepresentation(propertyList[i]);
            reverseLookup.set(canonical, i);
        }
        globalReverseLookup.set(propertyList, reverseLookup);
    }
    const canonical = getCanonicalRepresentation(property);
    if (reverseLookup.has(canonical)) {
        return reverseLookup.get(canonical);
    }
    const maxId = propertyList.length;
    propertyList.push(property);
    reverseLookup.set(canonical, maxId);
    return maxId;
}
const chartIds = [];
/**
 * Convert a chart o-spreadsheet id to a xlsx id which
 * are unsigned integers (starting from 1).
 */
function convertChartId(chartId) {
    const xlsxId = chartIds.findIndex((id) => id === chartId);
    if (xlsxId === -1) {
        chartIds.push(chartId);
        return chartIds.length;
    }
    return xlsxId + 1;
}
const imageIds = [];
/**
 * Convert a image o-spreadsheet id to a xlsx id which
 * are unsigned integers (starting from 1).
 */
function convertImageId(imageId) {
    const xlsxId = imageIds.findIndex((id) => id === imageId);
    if (xlsxId === -1) {
        imageIds.push(imageId);
        return imageIds.length;
    }
    return xlsxId + 1;
}
/**
 * Convert a value expressed in dot to EMU.
 * EMU = English Metrical Unit
 * There are 914400 EMU per inch.
 *
 * /!\ A value expressed in EMU cannot be fractional.
 * See https://docs.microsoft.com/en-us/windows/win32/vml/msdn-online-vml-units#other-units-of-measurement
 */
function convertDotValueToEMU(value) {
    const DPI = 96;
    return Math.round((value * 914400) / DPI);
}
function getRangeSize(reference, defaultSheetIndex, data) {
    let xc = reference;
    let sheetName = undefined;
    ({ xc, sheetName } = splitReference(reference));
    let rangeSheetIndex;
    if (sheetName) {
        const index = data.sheets.findIndex((sheet) => sheet.name === sheetName);
        if (index < 0) {
            throw new Error("Unable to find a sheet with the name " + sheetName);
        }
        rangeSheetIndex = index;
    }
    else {
        rangeSheetIndex = Number(defaultSheetIndex);
    }
    const zone = toUnboundedZone(xc);
    if (zone.right === undefined) {
        zone.right = data.sheets[rangeSheetIndex].colNumber;
    }
    if (zone.bottom === undefined) {
        zone.bottom = data.sheets[rangeSheetIndex].rowNumber;
    }
    return (zone.right - zone.left + 1) * (zone.bottom - zone.top + 1);
}
function convertEMUToDotValue(value) {
    const DPI = 96;
    return Math.round((value * DPI) / 914400);
}
/**
 * Get the position of the start of a column in Excel (in px).
 */
function getColPosition(colIndex, sheetData) {
    let position = 0;
    for (let i = 0; i < colIndex; i++) {
        const colAtIndex = sheetData.cols.find((col) => i >= col.min && i <= col.max);
        if (colAtIndex?.width) {
            position += colAtIndex.width;
        }
        else if (sheetData.sheetFormat?.defaultColWidth) {
            position += sheetData.sheetFormat.defaultColWidth;
        }
        else {
            position += EXCEL_DEFAULT_COL_WIDTH;
        }
    }
    return position / WIDTH_FACTOR;
}
/**
 * Get the position of the start of a row in Excel (in px).
 */
function getRowPosition(rowIndex, sheetData) {
    let position = 0;
    for (let i = 0; i < rowIndex; i++) {
        const rowAtIndex = sheetData.rows[i];
        if (rowAtIndex?.height) {
            position += rowAtIndex.height;
        }
        else if (sheetData.sheetFormat?.defaultRowHeight) {
            position += sheetData.sheetFormat.defaultRowHeight;
        }
        else {
            position += EXCEL_DEFAULT_ROW_HEIGHT;
        }
    }
    return position / HEIGHT_FACTOR;
}
/**
 * Convert the o-spreadsheet data validation decimal
 * criterion type to the corresponding excel operator.
 */
function convertDecimalCriterionTypeToExcelOperator(operator) {
    return Object.keys(XLSX_DV_DECIMAL_OPERATOR_MAPPING).find((key) => XLSX_DV_DECIMAL_OPERATOR_MAPPING[key] === operator);
}
/**
 * Convert the o-spreadsheet data validation date
 * criterion type to the corresponding excel operator.
 */
function convertDateCriterionTypeToExcelOperator(operator) {
    return Object.keys(XLSX_DV_DATE_OPERATOR_TO_DV_TYPE_MAPPING).find((key) => XLSX_DV_DATE_OPERATOR_TO_DV_TYPE_MAPPING[key] === operator);
}

function convertFigures(sheetData) {
    let id = 1;
    return sheetData.figures
        .map((figure) => convertFigure(figure, (id++).toString(), sheetData))
        .filter(isDefined);
}
function convertFigure(figure, id, sheetData) {
    let x1, y1;
    let height, width;
    if (figure.anchors.length === 1) {
        // one cell anchor
        ({ x: x1, y: y1 } = getPositionFromAnchor(figure.anchors[0], sheetData));
        width = convertEMUToDotValue(figure.figureSize.cx);
        height = convertEMUToDotValue(figure.figureSize.cy);
    }
    else {
        ({ x: x1, y: y1 } = getPositionFromAnchor(figure.anchors[0], sheetData));
        const { x: x2, y: y2 } = getPositionFromAnchor(figure.anchors[1], sheetData);
        width = x2 - x1;
        height = y2 - y1;
    }
    const figureData = { id, x: x1, y: y1 };
    if (isChartData(figure.data)) {
        return {
            ...figureData,
            width,
            height,
            tag: "chart",
            data: convertChartData(figure.data),
        };
    }
    else if (isImageData(figure.data)) {
        return {
            ...figureData,
            width: convertEMUToDotValue(figure.data.size.cx),
            height: convertEMUToDotValue(figure.data.size.cy),
            tag: "image",
            data: {
                path: figure.data.imageSrc,
                mimetype: figure.data.mimetype,
            },
        };
    }
    return undefined;
}
function isChartData(data) {
    return "dataSets" in data && data.dataSets.length > 0;
}
function isImageData(data) {
    return "imageSrc" in data;
}
function convertChartData(chartData) {
    const dataSetsHaveTitle = chartData.dataSets.some((ds) => "reference" in (ds.label ?? {}));
    const labelRange = chartData.labelRange
        ? convertExcelRangeToSheetXC(chartData.labelRange, dataSetsHaveTitle)
        : undefined;
    const dataSets = chartData.dataSets.map((data) => {
        let label = undefined;
        if (data.label && "text" in data.label) {
            label = data.label.text;
        }
        return {
            dataRange: convertExcelRangeToSheetXC(data.range, dataSetsHaveTitle),
            label,
            backgroundColor: data.backgroundColor,
        };
    });
    // For doughnut charts, in chartJS first dataset = outer dataset, in excel first dataset = inner dataset
    if (chartData.type === "pie") {
        dataSets.reverse();
    }
    return {
        dataSets,
        dataSetsHaveTitle,
        labelRange,
        title: chartData.title ?? { text: "" },
        type: chartData.type,
        background: convertColor({ rgb: chartData.backgroundColor }) || "#FFFFFF",
        legendPosition: chartData.legendPosition,
        stacked: chartData.stacked || false,
        aggregated: false,
        cumulative: chartData.cumulative || false,
        labelsAsText: false,
    };
}
function convertExcelRangeToSheetXC(range, dataSetsHaveTitle) {
    let { sheetName, xc } = splitReference(range);
    let zone = toUnboundedZone(xc);
    if (dataSetsHaveTitle && zone.bottom !== undefined && zone.right !== undefined) {
        const height = zone.bottom - zone.top + 1;
        const width = zone.right - zone.left + 1;
        if (height === 1) {
            zone = { ...zone, left: zone.left - 1 };
        }
        else if (width === 1) {
            zone = { ...zone, top: zone.top - 1 };
        }
    }
    const dataXC = zoneToXc(zone);
    return getFullReference(sheetName, dataXC);
}
function getPositionFromAnchor(anchor, sheetData) {
    return {
        x: getColPosition(anchor.col, sheetData) + convertEMUToDotValue(anchor.colOffset),
        y: getRowPosition(anchor.row, sheetData) + convertEMUToDotValue(anchor.rowOffset),
    };
}

function convertDataValidationRules(xlsxDataValidations, warningManager) {
    const dvRules = [];
    let dvId = 1;
    for (const dv of xlsxDataValidations) {
        if (!dv) {
            continue;
        }
        switch (dv.type) {
            case "time":
                warningManager.generateNotSupportedWarning(WarningTypes.TimeDataValidationNotSupported);
                break;
            case "textLength":
                warningManager.generateNotSupportedWarning(WarningTypes.TextLengthDataValidationNotSupported);
                break;
            case "whole":
                warningManager.generateNotSupportedWarning(WarningTypes.WholeNumberDataValidationNotSupported);
                break;
            case "decimal":
                const decimalRule = convertDecimalRule(dvId++, dv);
                dvRules.push(decimalRule);
                break;
            case "list":
                const listRule = convertListrule(dvId++, dv);
                dvRules.push(listRule);
                break;
            case "date":
                if (dv.operator === "notEqual") {
                    warningManager.generateNotSupportedWarning(WarningTypes.NotEqualDateDataValidationNotSupported);
                    break;
                }
                const dateRule = convertDateRule(dvId++, dv);
                dvRules.push(dateRule);
                break;
            case "custom":
                const customRule = convertCustomRule(dvId++, dv);
                dvRules.push(customRule);
                break;
        }
    }
    return dvRules;
}
function convertDecimalRule(id, dv) {
    const values = [dv.formula1.toString()];
    if (dv.formula2) {
        values.push(dv.formula2.toString());
    }
    return {
        id: id.toString(),
        ranges: dv.sqref,
        isBlocking: dv.errorStyle !== "warning",
        criterion: {
            type: XLSX_DV_DECIMAL_OPERATOR_MAPPING[dv.operator],
            values,
        },
    };
}
function convertListrule(id, dv) {
    const formula1 = dv.formula1.toString();
    const isRangeRule = rangeReference.test(formula1);
    return {
        id: id.toString(),
        ranges: dv.sqref,
        isBlocking: dv.errorStyle !== "warning",
        criterion: {
            type: isRangeRule ? "isValueInRange" : "isValueInList",
            values: isRangeRule ? [formula1] : formula1.replaceAll('"', "").split(","),
            displayStyle: "arrow",
        },
    };
}
function convertDateRule(id, dv) {
    let criterion;
    const values = [dv.formula1.toString()];
    if (dv.formula2) {
        values.push(dv.formula2.toString());
        criterion = {
            type: XLSX_DV_DATE_OPERATOR_TO_DV_TYPE_MAPPING[dv.operator],
            values: getDateCriterionFormattedValues(values, DEFAULT_LOCALE),
        };
    }
    else {
        criterion = {
            type: XLSX_DV_DATE_OPERATOR_TO_DV_TYPE_MAPPING[dv.operator],
            values: getDateCriterionFormattedValues(values, DEFAULT_LOCALE),
            dateValue: "exactDate",
        };
    }
    return {
        id: id.toString(),
        ranges: dv.sqref,
        isBlocking: dv.errorStyle !== "warning",
        criterion: criterion,
    };
}
function convertCustomRule(id, dv) {
    return {
        id: id.toString(),
        ranges: dv.sqref,
        isBlocking: dv.errorStyle !== "warning",
        criterion: {
            type: "customFormula",
            values: [`=${dv.formula1.toString()}`],
        },
    };
}

/**
 * Match external reference (ex. '[1]Sheet 3'!$B$4)
 *
 * First match group is the external reference id
 * Second match group is the sheet id
 * Third match group is the reference of the cell
 */
const externalReferenceRegex = new RegExp(/'?\[([0-9]*)\](.*)'?!(\$?[a-zA-Z]*\$?[0-9]*)/g);
const subtotalRegex = new RegExp(/SUBTOTAL\(([0-9]*),/g);
const cellRegex = new RegExp(cellReference.source, "ig");
function convertFormulasContent(sheet, data) {
    const sfMap = getSharedFormulasMap(sheet);
    for (let cell of sheet.rows.map((row) => row.cells).flat()) {
        if (cell?.formula) {
            cell.formula.content =
                cell.formula.sharedIndex !== undefined && !cell.formula.content
                    ? "=" + adaptFormula(cell.xc, sfMap[cell.formula.sharedIndex])
                    : "=" + cell.formula.content;
            cell.formula.content = convertFormula(cell.formula.content, data);
        }
    }
}
function getSharedFormulasMap(sheet) {
    const formulas = {};
    for (let row of sheet.rows) {
        for (let cell of row.cells) {
            if (cell.formula && cell.formula.sharedIndex !== undefined && cell.formula.content) {
                formulas[cell.formula.sharedIndex] = { refCellXc: cell.xc, formula: cell.formula.content };
            }
        }
    }
    return formulas;
}
/**
 * Convert an XLSX formula into something we can evaluate.
 * - remove _xlfn. flags before function names
 * - convert the SUBTOTAL(index, formula) function to the function given by its index
 * - change #REF! into #REF
 * - convert external references into their value
 */
function convertFormula(formula, data) {
    formula = formula.replace("_xlfn.", "");
    formula = formula.replace(/#REF!/g, "#REF");
    // SUBOTOTAL function, eg. =SUBTOTAL(3, {formula})
    formula = formula.replace(subtotalRegex, (match, functionId) => {
        const convertedFunction = SUBTOTAL_FUNCTION_CONVERSION_MAP[functionId];
        return convertedFunction ? convertedFunction + "(" : match;
    });
    // External references, eg. ='[1]Sheet 3'!$B$4
    formula = formula.replace(externalReferenceRegex, (match, externalRefId, sheetName, cellRef) => {
        externalRefId = Number(externalRefId) - 1;
        cellRef = cellRef.replace(/\$/g, "");
        const sheetIndex = data.externalBooks[externalRefId].sheetNames.findIndex((name) => name === sheetName);
        if (sheetIndex === -1) {
            return match;
        }
        const externalDataset = data.externalBooks[externalRefId].datasets.find((dataset) => dataset.sheetId === sheetIndex)?.data;
        if (!externalDataset) {
            return match;
        }
        const datasetValue = externalDataset && externalDataset[cellRef];
        const convertedValue = Number(datasetValue) ? datasetValue : `"${datasetValue}"`;
        return convertedValue || match;
    });
    return formula;
}
/**
 * Transform a shared formula for the given target.
 *
 * This will compute the offset between the original cell of the shared formula and the target cell,
 * then apply this offset to all the ranges in the formula (taking fixed references into account)
 */
function adaptFormula(targetCell, sf) {
    const refPosition = toCartesian(sf.refCellXc);
    let newFormula = sf.formula.slice();
    let match;
    do {
        match = cellRegex.exec(newFormula);
        if (match) {
            const formulaPosition = toCartesian(match[0].replace("$", ""));
            const targetPosition = toCartesian(targetCell);
            const rangePart = {
                colFixed: match[0].startsWith("$"),
                rowFixed: match[0].includes("$", 1),
            };
            const offset = {
                col: targetPosition.col - refPosition.col,
                row: targetPosition.row - refPosition.row,
            };
            const offsettedPosition = {
                col: rangePart.colFixed ? formulaPosition.col : formulaPosition.col + offset.col,
                row: rangePart.rowFixed ? formulaPosition.row : formulaPosition.row + offset.row,
            };
            newFormula =
                newFormula.slice(0, match.index) +
                    toXC(offsettedPosition.col, offsettedPosition.row, rangePart) +
                    newFormula.slice(match.index + match[0].length);
        }
    } while (match);
    return newFormula;
}

function convertSheets(data, warningManager) {
    return data.sheets.map((sheet) => {
        convertFormulasContent(sheet, data);
        const sheetDims = getSheetDims(sheet);
        const sheetOptions = sheet.sheetViews[0];
        const rowHeaderGroups = convertHeaderGroup(sheet, "ROW", sheetDims[1]);
        const colHeaderGroups = convertHeaderGroup(sheet, "COL", sheetDims[0]);
        return {
            id: sheet.sheetName,
            areGridLinesVisible: sheetOptions ? sheetOptions.showGridLines : true,
            name: sheet.sheetName,
            colNumber: sheetDims[0],
            rowNumber: sheetDims[1],
            ...convertCells(sheet, data, sheetDims, warningManager),
            merges: sheet.merges,
            cols: convertCols(sheet, sheetDims[0], colHeaderGroups),
            rows: convertRows(sheet, sheetDims[1], rowHeaderGroups),
            conditionalFormats: convertConditionalFormats(sheet.cfs, data.dxfs, warningManager),
            dataValidationRules: convertDataValidationRules(sheet.dataValidations, warningManager),
            figures: convertFigures(sheet),
            isVisible: sheet.isVisible,
            panes: sheetOptions
                ? { xSplit: sheetOptions.pane.xSplit, ySplit: sheetOptions.pane.ySplit }
                : { xSplit: 0, ySplit: 0 },
            tables: [],
            headerGroups: { COL: colHeaderGroups, ROW: rowHeaderGroups },
            color: convertColor(sheet.sheetProperties?.tabColor),
        };
    });
}
function convertCols(sheet, numberOfCols, headerGroups) {
    const cols = {};
    // Excel begins indexes at 1
    for (let i = 1; i < numberOfCols + 1; i++) {
        const col = sheet.cols.find((col) => col.min <= i && i <= col.max);
        let colSize;
        if (col && col.width)
            colSize = col.width;
        else if (sheet.sheetFormat?.defaultColWidth)
            colSize = sheet.sheetFormat.defaultColWidth;
        else
            colSize = EXCEL_DEFAULT_COL_WIDTH;
        // In xlsx there is no difference between hidden columns and columns inside a folded group.
        // But in o-spreadsheet folded columns are not considered hidden.
        const colIndex = i - 1;
        const isColFolded = headerGroups.some((group) => group.isFolded && group.start <= colIndex && colIndex <= group.end);
        cols[colIndex] = {
            size: convertWidthFromExcel(colSize),
            isHidden: !isColFolded && col?.hidden,
        };
    }
    return cols;
}
function convertRows(sheet, numberOfRows, headerGroups) {
    const rows = {};
    // Excel begins indexes at 1
    for (let i = 1; i < numberOfRows + 1; i++) {
        const row = sheet.rows.find((row) => row.index === i);
        let rowSize;
        if (row && row.height)
            rowSize = row.height;
        else if (sheet.sheetFormat?.defaultRowHeight)
            rowSize = sheet.sheetFormat.defaultRowHeight;
        else
            rowSize = EXCEL_DEFAULT_ROW_HEIGHT;
        // In xlsx there is no difference between hidden rows and rows inside a folded group.
        // But in o-spreadsheet folded rows are not considered hidden.
        const rowIndex = i - 1;
        const isRowFolded = headerGroups.some((group) => group.isFolded && group.start <= rowIndex && rowIndex <= group.end);
        rows[rowIndex] = {
            size: convertHeightFromExcel(rowSize),
            isHidden: !isRowFolded && row?.hidden,
        };
    }
    return rows;
}
function convertSharedStrings(xlsxSharedStrings) {
    return xlsxSharedStrings.map(replaceNewLines);
}
function convertCells(sheet, data, sheetDims, warningManager) {
    const cells = {};
    const styles = {};
    const formats = {};
    const borders = {};
    const sharedStrings = convertSharedStrings(data.sharedStrings);
    const hyperlinkMap = sheet.hyperlinks.reduce((map, link) => {
        map[link.xc] = link;
        return map;
    }, {});
    for (let row of sheet.rows) {
        for (let cell of row.cells) {
            cells[cell.xc] = {
                content: getCellValue(cell, hyperlinkMap, sharedStrings, warningManager),
            };
            if (cell.styleIndex) {
                // + 1 : our indexes for normalized values begin at 1 and not 0
                styles[cell.xc] = cell.styleIndex + 1;
                formats[cell.xc] = data.styles[cell.styleIndex].numFmtId + 1;
                borders[cell.xc] = data.styles[cell.styleIndex].borderId + 1;
            }
        }
    }
    // Apply row style
    for (let row of sheet.rows.filter((row) => row.styleIndex)) {
        for (let colIndex = 1; colIndex <= sheetDims[0]; colIndex++) {
            const xc = toXC(colIndex - 1, row.index - 1); // Excel indexes start at 1
            let cell = cells[xc];
            if (!cell) {
                cell = {};
                cells[xc] = cell;
            }
            styles[xc] ??= row.styleIndex + 1;
            borders[xc] ??= data.styles[row.styleIndex].borderId + 1;
            formats[xc] ??= data.styles[row.styleIndex].numFmtId + 1;
        }
    }
    // Apply col style
    for (let col of sheet.cols.filter((col) => col.styleIndex)) {
        for (let colIndex = col.min; colIndex <= Math.min(col.max, sheetDims[0]); colIndex++) {
            for (let rowIndex = 1; rowIndex <= sheetDims[1]; rowIndex++) {
                const xc = toXC(colIndex - 1, rowIndex - 1); // Excel indexes start at 1
                let cell = cells[xc];
                if (!cell) {
                    cell = {};
                    cells[xc] = cell;
                }
                styles[xc] ??= col.styleIndex + 1;
                borders[xc] ??= data.styles[col.styleIndex].borderId + 1;
                formats[xc] ??= data.styles[col.styleIndex].numFmtId + 1;
            }
        }
    }
    return { cells, styles, formats, borders };
}
function getCellValue(cell, hyperLinksMap, sharedStrings, warningManager) {
    let cellValue;
    switch (cell.type) {
        case "sharedString":
            const ssIndex = parseInt(cell.value, 10);
            cellValue = sharedStrings[ssIndex];
            break;
        case "boolean":
            cellValue = Number(cell.value) ? "TRUE" : "FALSE";
            break;
        case "date": // I'm not sure where this is used rather than a number with a format
        case "error": // I don't think Excel really uses this
        case "inlineStr":
        case "number":
        case "str":
            cellValue = cell.value;
            break;
    }
    if (cellValue && hyperLinksMap[cell.xc]) {
        cellValue = convertHyperlink(hyperLinksMap[cell.xc], cellValue, warningManager);
    }
    if (cell.formula) {
        cellValue = cell.formula.content;
    }
    return cellValue;
}
function convertHyperlink(link, cellValue, warningManager) {
    const label = link.display || cellValue;
    if (!link.relTarget && !link.location) {
        warningManager.generateNotSupportedWarning(WarningTypes.BadlyFormattedHyperlink);
    }
    const url = link.relTarget
        ? link.relTarget
        : buildSheetLink(splitReference(link.location).sheetName);
    return markdownLink(label, url);
}
function getSheetDims(sheet) {
    const dims = [0, 0];
    for (let row of sheet.rows) {
        dims[0] = Math.max(dims[0], largeMax(row.cells.map((cell) => toCartesian(cell.xc).col)));
        dims[1] = Math.max(dims[1], row.index);
    }
    dims[0] = Math.max(dims[0], EXCEL_IMPORT_DEFAULT_NUMBER_OF_COLS);
    dims[1] = Math.max(dims[1], EXCEL_IMPORT_DEFAULT_NUMBER_OF_ROWS);
    return dims;
}
/**
 * Get the header groups from the XLS file.
 *
 * See ASCII art in HeaderGroupingPlugin.exportForExcel() for details on how the groups are defined in the xlsx.
 */
function convertHeaderGroup(sheet, dim, numberOfHeaders) {
    const outlineProperties = sheet?.sheetProperties?.outlinePr;
    const headerGroups = [];
    let currentLayer = 0;
    for (let i = 0; i < numberOfHeaders; i++) {
        const header = getHeader(sheet, dim, i);
        const headerLayer = header?.outlineLevel || 0;
        if (headerLayer > currentLayer) {
            // Whether the flag indicating if the group is collapsed is on the header before or after the group. Default is after.
            const collapseFlagAfter = (dim === "ROW" ? outlineProperties?.summaryBelow : outlineProperties?.summaryRight) ?? true;
            const group = computeHeaderGroup(sheet, dim, i, collapseFlagAfter);
            if (group) {
                headerGroups.push(group);
            }
        }
        currentLayer = headerLayer;
    }
    return headerGroups;
}
function computeHeaderGroup(sheet, dim, startIndex, collapseFlagAfter) {
    const startHeader = getHeader(sheet, dim, startIndex);
    const startLayer = startHeader?.outlineLevel;
    if (!startLayer || !startLayer) {
        return undefined;
    }
    let currentLayer = startLayer;
    let currentIndex = startIndex;
    let currentHeader = startHeader;
    while (currentHeader && currentLayer >= startLayer) {
        currentIndex++;
        currentHeader = getHeader(sheet, dim, currentIndex);
        currentLayer = currentHeader?.outlineLevel || 0;
    }
    const start = startIndex;
    const end = currentIndex - 1;
    const collapseFlagHeader = collapseFlagAfter
        ? getHeader(sheet, dim, end + 1)
        : getHeader(sheet, dim, start - 1);
    const isFolded = collapseFlagHeader?.collapsed || false;
    return { start: start - 1, end: end - 1, isFolded }; // -1 because indices start at 1 in excel and 0 in o-spreadsheet
}
function getHeader(sheet, dim, index) {
    return "COL" === dim
        ? sheet.cols.find((col) => col.min <= index && index <= col.max)
        : sheet.rows.find((row) => row.index === index);
}

const TABLE_STYLE_CATEGORIES = {
    light: _t("Light"),
    medium: _t("Medium"),
    dark: _t("Dark"),
    custom: _t("Custom"),
};
const DEFAULT_TABLE_CONFIG = {
    hasFilters: true,
    totalRow: false,
    firstColumn: false,
    lastColumn: false,
    numberOfHeaders: 1,
    bandedRows: true,
    bandedColumns: false,
    automaticAutofill: true,
    styleId: "TableStyleMedium2",
};
function generateTableColorSet(name, highlightColor) {
    return {
        coloredText: darkenColor(highlightColor, 0.3),
        light: lightenColor(highlightColor, 0.8),
        medium: lightenColor(highlightColor, 0.6),
        dark: darkenColor(highlightColor, 0.3),
        mediumBorder: lightenColor(highlightColor, 0.45),
        highlight: highlightColor,
        name,
    };
}
const COLOR_SETS = {
    black: {
        name: _t("Black"),
        coloredText: "#000000",
        light: "#D9D9D9",
        medium: "#A6A6A6",
        dark: "#404040",
        mediumBorder: "#000000",
        highlight: "#000000",
    },
    lightBlue: generateTableColorSet(_t("Light blue"), "#346B90"),
    red: generateTableColorSet(_t("Red"), "#C53628"),
    lightGreen: generateTableColorSet(_t("Light green"), "#748747"),
    purple: generateTableColorSet(_t("Purple"), "#6C4E65"),
    gray: {
        name: _t("Gray"),
        coloredText: "#666666",
        light: "#EEEEEE",
        medium: "#DDDDDD",
        dark: "#767676",
        mediumBorder: "#D0D0D0",
        highlight: "#A9A9A9",
    },
    orange: generateTableColorSet(_t("Orange"), "#C37034"),
};
const DARK_COLOR_SETS = {
    black: COLOR_SETS.black,
    orangeBlue: { ...COLOR_SETS.lightBlue, highlight: COLOR_SETS.orange.highlight },
    purpleGreen: { ...COLOR_SETS.lightGreen, highlight: COLOR_SETS.purple.highlight },
    redBlue: { ...COLOR_SETS.lightBlue, highlight: COLOR_SETS.red.highlight },
};
const lightColoredText = (colorSet) => ({
    category: "light",
    templateName: "lightColoredText",
    primaryColor: colorSet.highlight,
    wholeTable: {
        style: { textColor: colorSet.coloredText },
        border: {
            top: { color: colorSet.highlight, style: "thin" },
            bottom: { color: colorSet.highlight, style: "thin" },
        },
    },
    headerRow: { border: { bottom: { color: colorSet.highlight, style: "thin" } } },
    totalRow: { border: { top: { color: colorSet.highlight, style: "thin" } } },
    firstRowStripe: { style: { fillColor: colorSet.light } },
});
const lightWithHeader = (colorSet) => ({
    category: "light",
    templateName: "lightWithHeader",
    primaryColor: colorSet.highlight,
    wholeTable: {
        border: {
            top: { color: colorSet.highlight, style: "thin" },
            bottom: { color: colorSet.highlight, style: "thin" },
            left: { color: colorSet.highlight, style: "thin" },
            right: { color: colorSet.highlight, style: "thin" },
        },
    },
    headerRow: {
        style: { fillColor: colorSet.highlight, textColor: "#FFFFFF" },
        border: { bottom: { color: colorSet.highlight, style: "thin" } },
    },
    totalRow: { border: { top: { color: colorSet.highlight, style: "medium" } } }, // @compatibility: should be double line
    firstRowStripe: { border: { bottom: { color: colorSet.highlight, style: "thin" } } },
    secondRowStripe: { border: { bottom: { color: colorSet.highlight, style: "thin" } } },
});
const lightAllBorders = (colorSet) => ({
    category: "light",
    templateName: "lightAllBorders",
    primaryColor: colorSet.highlight,
    wholeTable: {
        border: {
            top: { color: colorSet.highlight, style: "thin" },
            bottom: { color: colorSet.highlight, style: "thin" },
            left: { color: colorSet.highlight, style: "thin" },
            right: { color: colorSet.highlight, style: "thin" },
            horizontal: { color: colorSet.highlight, style: "thin" },
            vertical: { color: colorSet.highlight, style: "thin" },
        },
    },
    headerRow: { border: { bottom: { color: colorSet.highlight, style: "medium" } } },
    totalRow: { border: { top: { color: colorSet.highlight, style: "medium" } } }, // @compatibility: should be double line
    firstRowStripe: { style: { fillColor: colorSet.light } },
    firstColumnStripe: { style: { fillColor: colorSet.light } },
});
const mediumBandedBorders = (colorSet) => ({
    category: "medium",
    templateName: "mediumBandedBorders",
    primaryColor: colorSet.highlight,
    wholeTable: {
        border: {
            top: { color: colorSet.mediumBorder, style: "thin" },
            bottom: { color: colorSet.mediumBorder, style: "thin" },
            left: { color: colorSet.mediumBorder, style: "thin" },
            right: { color: colorSet.mediumBorder, style: "thin" },
            horizontal: { color: colorSet.mediumBorder, style: "thin" },
        },
    },
    headerRow: {
        style: { fillColor: colorSet.highlight, textColor: "#FFFFFF" },
    },
    totalRow: { border: { top: { color: colorSet.highlight, style: "medium" } } }, // @compatibility: should be double line
    firstRowStripe: { style: { fillColor: colorSet.light } },
    firstColumnStripe: { style: { fillColor: colorSet.light } },
});
const mediumWhiteBorders = (colorSet) => ({
    category: "medium",
    templateName: "mediumWhiteBorders",
    primaryColor: colorSet.highlight,
    wholeTable: {
        border: {
            horizontal: { color: "#FFFFFF", style: "thin" },
            vertical: { color: "#FFFFFF", style: "thin" },
        },
        style: { fillColor: colorSet.light },
    },
    headerRow: {
        border: { bottom: { color: "#FFFFFF", style: "thick" } },
        style: { fillColor: colorSet.highlight, textColor: "#FFFFFF" },
    },
    totalRow: {
        border: { top: { color: "#FFFFFF", style: "thick" } },
        style: { fillColor: colorSet.highlight, textColor: "#FFFFFF" },
    },
    firstColumn: { style: { fillColor: colorSet.highlight, textColor: "#FFFFFF" } },
    lastColumn: { style: { fillColor: colorSet.highlight, textColor: "#FFFFFF" } },
    firstRowStripe: { style: { fillColor: colorSet.medium } },
    firstColumnStripe: { style: { fillColor: colorSet.medium } },
});
const mediumMinimalBorders = (colorSet) => ({
    category: "medium",
    templateName: "mediumMinimalBorders",
    primaryColor: colorSet.highlight,
    wholeTable: {
        border: {
            top: { color: "#000000", style: "medium" },
            bottom: { color: "#000000", style: "medium" },
        },
    },
    totalRow: { border: { top: { color: "#000000", style: "medium" } } }, // @compatibility: should be double line
    headerRow: {
        style: { fillColor: colorSet.highlight, textColor: "#FFFFFF" },
        border: { bottom: { color: "#000000", style: "medium" } },
    },
    firstColumn: { style: { fillColor: colorSet.highlight, textColor: "#FFFFFF" } },
    lastColumn: { style: { fillColor: colorSet.highlight, textColor: "#FFFFFF" } },
    firstRowStripe: { style: { fillColor: COLOR_SETS.black.light } },
    firstColumnStripe: { style: { fillColor: COLOR_SETS.black.light } },
});
const mediumAllBorders = (colorSet) => ({
    category: "medium",
    templateName: "mediumAllBorders",
    primaryColor: colorSet.highlight,
    wholeTable: {
        border: {
            top: { color: colorSet.mediumBorder, style: "thin" },
            bottom: { color: colorSet.mediumBorder, style: "thin" },
            left: { color: colorSet.mediumBorder, style: "thin" },
            right: { color: colorSet.mediumBorder, style: "thin" },
            horizontal: { color: colorSet.mediumBorder, style: "thin" },
            vertical: { color: colorSet.mediumBorder, style: "thin" },
        },
        style: { fillColor: colorSet.light },
    },
    totalRow: { border: { top: { color: colorSet.highlight, style: "medium" } } }, // @compatibility: should be double line
    firstRowStripe: { style: { fillColor: colorSet.medium } },
    firstColumnStripe: { style: { fillColor: colorSet.medium } },
});
const dark = (colorSet) => ({
    category: "dark",
    templateName: "dark",
    primaryColor: colorSet.highlight,
    wholeTable: { style: { fillColor: colorSet.highlight, textColor: "#FFFFFF" } },
    totalRow: {
        style: { fillColor: colorSet.dark, textColor: "#FFFFFF" },
        border: { top: { color: "#FFFFFF", style: "thick" } },
    },
    headerRow: {
        style: { fillColor: "#000000" },
        border: { bottom: { color: "#FFFFFF", style: "thick" } },
    },
    firstColumn: {
        style: { fillColor: colorSet.dark },
        border: { right: { color: "#FFFFFF", style: "thick" } },
    },
    lastColumn: {
        style: { fillColor: colorSet.dark },
        border: { left: { color: "#FFFFFF", style: "thick" } },
    },
    firstRowStripe: { style: { fillColor: colorSet.dark } },
    firstColumnStripe: { style: { fillColor: colorSet.dark } },
});
const darkNoBorders = (colorSet) => ({
    category: "dark",
    templateName: "darkNoBorders",
    primaryColor: colorSet.highlight,
    wholeTable: { style: { fillColor: colorSet.light } },
    totalRow: { border: { top: { color: "#000000", style: "medium" } } }, // @compatibility: should be double line
    headerRow: { style: { fillColor: colorSet.highlight, textColor: "#FFFFFF" } },
    firstRowStripe: { style: { fillColor: colorSet.medium } },
    firstColumnStripe: { style: { fillColor: colorSet.medium } },
});
const darkTemplateInBlack = dark(COLOR_SETS.black);
darkTemplateInBlack.wholeTable.style.fillColor = "#737373";
const mediumMinimalBordersInBlack = mediumMinimalBorders(COLOR_SETS.black);
mediumMinimalBordersInBlack.wholeTable.border = {
    ...mediumMinimalBordersInBlack.wholeTable.border,
    left: { color: "#000000", style: "thin" },
    right: { color: "#000000", style: "thin" },
    horizontal: { color: "#000000", style: "thin" },
    vertical: { color: "#000000", style: "thin" },
};
function buildPreset(name, template, colorSet) {
    return { ...template(colorSet), displayName: `${colorSet.name}, ${name}` };
}
const TABLE_PRESETS = {
    None: { category: "light", templateName: "none", primaryColor: "", displayName: "none" },
    TableStyleLight1: buildPreset("TableStyleLight1", lightColoredText, COLOR_SETS.black),
    TableStyleLight2: buildPreset("TableStyleLight2", lightColoredText, COLOR_SETS.lightBlue),
    TableStyleLight3: buildPreset("TableStyleLight3", lightColoredText, COLOR_SETS.red),
    TableStyleLight4: buildPreset("TableStyleLight4", lightColoredText, COLOR_SETS.lightGreen),
    TableStyleLight5: buildPreset("TableStyleLight5", lightColoredText, COLOR_SETS.purple),
    TableStyleLight6: buildPreset("TableStyleLight6", lightColoredText, COLOR_SETS.gray),
    TableStyleLight7: buildPreset("TableStyleLight7", lightColoredText, COLOR_SETS.orange),
    TableStyleLight8: buildPreset("TableStyleLight8", lightWithHeader, COLOR_SETS.black),
    TableStyleLight9: buildPreset("TableStyleLight9", lightWithHeader, COLOR_SETS.lightBlue),
    TableStyleLight10: buildPreset("TableStyleLight10", lightWithHeader, COLOR_SETS.red),
    TableStyleLight11: buildPreset("TableStyleLight11", lightWithHeader, COLOR_SETS.lightGreen),
    TableStyleLight12: buildPreset("TableStyleLight12", lightWithHeader, COLOR_SETS.purple),
    TableStyleLight13: buildPreset("TableStyleLight13", lightWithHeader, COLOR_SETS.gray),
    TableStyleLight14: buildPreset("TableStyleLight14", lightWithHeader, COLOR_SETS.orange),
    TableStyleLight15: buildPreset("TableStyleLight15", lightAllBorders, COLOR_SETS.black),
    TableStyleLight16: buildPreset("TableStyleLight16", lightAllBorders, COLOR_SETS.lightBlue),
    TableStyleLight17: buildPreset("TableStyleLight17", lightAllBorders, COLOR_SETS.red),
    TableStyleLight18: buildPreset("TableStyleLight18", lightAllBorders, COLOR_SETS.lightGreen),
    TableStyleLight19: buildPreset("TableStyleLight19", lightAllBorders, COLOR_SETS.purple),
    TableStyleLight20: buildPreset("TableStyleLight20", lightAllBorders, COLOR_SETS.gray),
    TableStyleLight21: buildPreset("TableStyleLight21", lightAllBorders, COLOR_SETS.orange),
    TableStyleMedium1: buildPreset("TableStyleMedium1", mediumBandedBorders, COLOR_SETS.black),
    TableStyleMedium2: buildPreset("TableStyleMedium2", mediumBandedBorders, COLOR_SETS.lightBlue),
    TableStyleMedium3: buildPreset("TableStyleMedium3", mediumBandedBorders, COLOR_SETS.red),
    TableStyleMedium4: buildPreset("TableStyleMedium4", mediumBandedBorders, COLOR_SETS.lightGreen),
    TableStyleMedium5: buildPreset("TableStyleMedium5", mediumBandedBorders, COLOR_SETS.purple),
    TableStyleMedium6: buildPreset("TableStyleMedium6", mediumBandedBorders, COLOR_SETS.gray),
    TableStyleMedium7: buildPreset("TableStyleMedium7", mediumBandedBorders, COLOR_SETS.orange),
    TableStyleMedium8: buildPreset("TableStyleMedium8", mediumWhiteBorders, COLOR_SETS.black),
    TableStyleMedium9: buildPreset("TableStyleMedium9", mediumWhiteBorders, COLOR_SETS.lightBlue),
    TableStyleMedium10: buildPreset("TableStyleMedium10", mediumWhiteBorders, COLOR_SETS.red),
    TableStyleMedium11: buildPreset("TableStyleMedium11", mediumWhiteBorders, COLOR_SETS.lightGreen),
    TableStyleMedium12: buildPreset("TableStyleMedium12", mediumWhiteBorders, COLOR_SETS.purple),
    TableStyleMedium13: buildPreset("TableStyleMedium13", mediumWhiteBorders, COLOR_SETS.gray),
    TableStyleMedium14: buildPreset("TableStyleMedium14", mediumWhiteBorders, COLOR_SETS.orange),
    TableStyleMedium15: { ...mediumMinimalBordersInBlack, displayName: "Black, TableStyleMedium15" },
    TableStyleMedium16: buildPreset("TableStyleMedium16", mediumMinimalBorders, COLOR_SETS.lightBlue),
    TableStyleMedium17: buildPreset("TableStyleMedium17", mediumMinimalBorders, COLOR_SETS.red),
    TableStyleMedium18: buildPreset("TableStyleMedium18", mediumMinimalBorders, COLOR_SETS.lightGreen),
    TableStyleMedium19: buildPreset("TableStyleMedium19", mediumMinimalBorders, COLOR_SETS.purple),
    TableStyleMedium20: buildPreset("TableStyleMedium20", mediumMinimalBorders, COLOR_SETS.gray),
    TableStyleMedium21: buildPreset("TableStyleMedium21", mediumMinimalBorders, COLOR_SETS.orange),
    TableStyleMedium22: buildPreset("TableStyleMedium22", mediumAllBorders, COLOR_SETS.black),
    TableStyleMedium23: buildPreset("TableStyleMedium23", mediumAllBorders, COLOR_SETS.lightBlue),
    TableStyleMedium24: buildPreset("TableStyleMedium24", mediumAllBorders, COLOR_SETS.red),
    TableStyleMedium25: buildPreset("TableStyleMedium25", mediumAllBorders, COLOR_SETS.lightGreen),
    TableStyleMedium26: buildPreset("TableStyleMedium26", mediumAllBorders, COLOR_SETS.purple),
    TableStyleMedium27: buildPreset("TableStyleMedium27", mediumAllBorders, COLOR_SETS.gray),
    TableStyleMedium28: buildPreset("TableStyleMedium28", mediumAllBorders, COLOR_SETS.orange),
    TableStyleDark1: { ...darkTemplateInBlack, displayName: "Black, TableStyleDark1" },
    TableStyleDark2: buildPreset("TableStyleDark2", dark, COLOR_SETS.lightBlue),
    TableStyleDark3: buildPreset("TableStyleDark3", dark, COLOR_SETS.red),
    TableStyleDark4: buildPreset("TableStyleDark4", dark, COLOR_SETS.lightGreen),
    TableStyleDark5: buildPreset("TableStyleDark5", dark, COLOR_SETS.purple),
    TableStyleDark6: buildPreset("TableStyleDark6", dark, COLOR_SETS.gray),
    TableStyleDark7: buildPreset("TableStyleDark7", dark, COLOR_SETS.orange),
    TableStyleDark8: buildPreset("TableStyleDark8", darkNoBorders, DARK_COLOR_SETS.black),
    TableStyleDark9: buildPreset("TableStyleDark9", darkNoBorders, DARK_COLOR_SETS.redBlue),
    TableStyleDark10: buildPreset("TableStyleDark10", darkNoBorders, DARK_COLOR_SETS.purpleGreen),
    TableStyleDark11: buildPreset("TableStyleDark11", darkNoBorders, DARK_COLOR_SETS.orangeBlue),
};
const TABLE_STYLES_TEMPLATES = {
    none: () => ({ category: "none", templateName: "none", primaryColor: "", name: "none" }),
    lightColoredText: lightColoredText,
    lightAllBorders: lightAllBorders,
    mediumAllBorders: mediumAllBorders,
    lightWithHeader: lightWithHeader,
    mediumBandedBorders: mediumBandedBorders,
    mediumMinimalBorders: mediumMinimalBorders,
    darkNoBorders: darkNoBorders,
    mediumWhiteBorders: mediumWhiteBorders,
    dark: dark,
};
function buildTableStyle(name, templateName, primaryColor) {
    const colorSet = generateTableColorSet("", primaryColor);
    return {
        ...TABLE_STYLES_TEMPLATES[templateName](colorSet),
        category: "custom",
        displayName: name,
    };
}

/**
 * Convert the imported XLSX tables and pivots convert the table-specific formula references into standard references.
 *
 * Change the converted data in-place.
 */
function convertTables(convertedData, xlsxData) {
    for (const xlsxSheet of xlsxData.sheets) {
        const sheet = convertedData.sheets.find((sheet) => sheet.name === xlsxSheet.sheetName);
        if (!sheet)
            continue;
        if (!sheet.tables)
            sheet.tables = [];
        for (const table of xlsxSheet.tables) {
            sheet.tables.push({ range: table.ref, config: convertTableConfig(table) });
        }
        for (const pivotTable of xlsxSheet.pivotTables) {
            sheet.tables.push({
                range: pivotTable.location.ref,
                config: convertPivotTableConfig(pivotTable),
            });
        }
    }
    convertTableFormulaReferences(convertedData.sheets, xlsxData.sheets);
}
function convertTableConfig(table) {
    const styleId = table.style?.name || "";
    return {
        hasFilters: table.autoFilter !== undefined,
        numberOfHeaders: table.headerRowCount,
        totalRow: table.totalsRowCount > 0,
        firstColumn: table.style?.showFirstColumn || false,
        lastColumn: table.style?.showLastColumn || false,
        bandedRows: table.style?.showRowStripes || false,
        bandedColumns: table.style?.showColumnStripes || false,
        styleId: TABLE_PRESETS[styleId] ? styleId : DEFAULT_TABLE_CONFIG.styleId,
    };
}
function convertPivotTableConfig(pivotTable) {
    return {
        hasFilters: false,
        numberOfHeaders: pivotTable.location.firstDataRow,
        totalRow: pivotTable.rowGrandTotals,
        firstColumn: true,
        lastColumn: pivotTable.style?.showLastColumn || false,
        bandedRows: pivotTable.style?.showRowStripes || false,
        bandedColumns: pivotTable.style?.showColStripes || false,
        styleId: DEFAULT_TABLE_CONFIG.styleId,
    };
}
/**
 * In all the sheets, replace the table-only references in the formula cells with standard references.
 */
function convertTableFormulaReferences(convertedSheets, xlsxSheets) {
    for (let tableSheet of convertedSheets) {
        const tables = xlsxSheets.find((s) => s.sheetName === tableSheet.name).tables;
        for (let table of tables) {
            const tabRef = table.name + "[";
            for (let sheet of convertedSheets) {
                for (let xc in sheet.cells) {
                    const cell = sheet.cells[xc];
                    if (cell && cell.content && cell.content.startsWith("=")) {
                        let refIndex;
                        while ((refIndex = cell.content.indexOf(tabRef)) !== -1) {
                            let endIndex = refIndex + tabRef.length;
                            let openBrackets = 1;
                            while (openBrackets > 0 && endIndex < cell.content.length) {
                                if (cell.content[endIndex] === "[") {
                                    openBrackets++;
                                }
                                else if (cell.content[endIndex] === "]") {
                                    openBrackets--;
                                }
                                endIndex++;
                            }
                            let reference = cell.content.slice(refIndex + tabRef.length, endIndex - 1);
                            const sheetPrefix = tableSheet.id === sheet.id ? "" : tableSheet.name + "!";
                            const convertedRef = convertTableReference(sheetPrefix, reference, table, xc);
                            cell.content =
                                cell.content.slice(0, refIndex) + convertedRef + cell.content.slice(endIndex);
                        }
                    }
                }
            }
        }
    }
}
/**
 * Convert table-specific references in formulas into standard references. A table reference is composed of columns names,
 * and of keywords determining the rows of the table to reference.
 *
 * A reference in a table can have the form (only the part between brackets should be given to this function):
 *  - tableName[colName] : reference to the whole column "colName"
 *  - tableName[#keyword] : reference to the whatever row the keyword refers to
 *  - tableName[[#keyword], [colName]] : reference to some of the element(s) of the column colName
 *  - tableName[[#keyword], [colName]:[col2Name]] : reference to some of the element(s) of the columns colName to col2Name
 *  - tableName[[#keyword1], [#keyword2], [colName]] : reference to all the rows referenced by the keywords in the column colName
 *  - tableName[[#keyword1], [colName], [#keyword2]]: the keywords and colName can be in any order
 *
 *
 * The available keywords are :
 * - #All : all the column (including totals)
 * - #Data : only the column data (no headers/totals)
 * - #Headers : only the header of the column
 * - #Totals : only the totals of the column
 * - #This Row : only the element in the same row as the cell
 *
 * Note that the only valid combination of multiple keywords are #Data + #Totals and #Headers + #Data.
 */
function convertTableReference(sheetPrefix, expr, table, cellXc) {
    // TODO: Ideally we'd want to make a real tokenizer, this simple approach won't work if for example the column name
    // contain # or , characters. But that's probably an edge case that we can ignore for now.
    const parts = expr.split(",").map((part) => part.trim());
    const tableZone = toZone(table.ref);
    const colIndexes = [];
    const rowIndexes = [];
    const foundKeywords = [];
    for (const part of parts) {
        if (removeBrackets(part).startsWith("#")) {
            const keyWord = removeBrackets(part);
            foundKeywords.push(keyWord);
            switch (keyWord) {
                case "#All":
                    rowIndexes.push(tableZone.top, tableZone.bottom);
                    break;
                case "#Data":
                    const top = table.headerRowCount ? tableZone.top + table.headerRowCount : tableZone.top;
                    const bottom = table.totalsRowCount
                        ? tableZone.bottom - table.totalsRowCount
                        : tableZone.bottom;
                    rowIndexes.push(top, bottom);
                    break;
                case "#This Row":
                    rowIndexes.push(toCartesian(cellXc).row);
                    break;
                case "#Headers":
                    if (!table.headerRowCount) {
                        return CellErrorType.InvalidReference;
                    }
                    rowIndexes.push(tableZone.top);
                    break;
                case "#Totals":
                    if (!table.totalsRowCount) {
                        return CellErrorType.InvalidReference;
                    }
                    rowIndexes.push(tableZone.bottom);
                    break;
            }
        }
        else {
            const columns = part
                .split(":")
                .map((part) => part.trim())
                .map(removeBrackets);
            if (colIndexes.length) {
                return CellErrorType.InvalidReference;
            }
            const colRelativeIndex = table.cols.findIndex((col) => col.name === columns[0]);
            if (colRelativeIndex === -1) {
                return CellErrorType.InvalidReference;
            }
            colIndexes.push(colRelativeIndex + tableZone.left);
            if (columns[1]) {
                const colRelativeIndex2 = table.cols.findIndex((col) => col.name === columns[1]);
                if (colRelativeIndex2 === -1) {
                    return CellErrorType.InvalidReference;
                }
                colIndexes.push(colRelativeIndex2 + tableZone.left);
            }
        }
    }
    if (!areKeywordsCompatible(foundKeywords)) {
        return CellErrorType.InvalidReference;
    }
    if (rowIndexes.length === 0) {
        const top = table.headerRowCount ? tableZone.top + table.headerRowCount : tableZone.top;
        const bottom = table.totalsRowCount
            ? tableZone.bottom - table.totalsRowCount
            : tableZone.bottom;
        rowIndexes.push(top, bottom);
    }
    if (colIndexes.length === 0) {
        colIndexes.push(tableZone.left, tableZone.right);
    }
    const refZone = {
        top: Math.min(...rowIndexes),
        left: Math.min(...colIndexes),
        bottom: Math.max(...rowIndexes),
        right: Math.max(...colIndexes),
    };
    return sheetPrefix + zoneToXc(refZone);
}
function removeBrackets(str) {
    return str.startsWith("[") && str.endsWith("]") ? str.slice(1, str.length - 1) : str;
}
function areKeywordsCompatible(keywords) {
    if (keywords.length < 2) {
        return true;
    }
    else if (keywords.length > 2) {
        return false;
    }
    else if (keywords.includes("#Data") && keywords.includes("#Totals")) {
        return true;
    }
    else if (keywords.includes("#Headers") && keywords.includes("#Data")) {
        return true;
    }
    return false;
}

// -------------------------------------
//            XML HELPERS
// -------------------------------------
function createXMLFile(doc, path, contentType) {
    return {
        content: new XMLSerializer().serializeToString(doc),
        path,
        contentType,
    };
}
function xmlEscape(str) {
    return (String(str)
        .replace(/\&/g, "&amp;")
        .replace(/\</g, "&lt;")
        .replace(/\>/g, "&gt;")
        .replace(/\"/g, "&quot;")
        .replace(/\'/g, "&apos;")
        // Delete all ASCII control characters except for TAB (\x09), LF (\x0A) and CR (\x0D)
        // They are not valid at all in XML 1.0 (even escaped)
        .replace(/[\x00-\x08\x0B\x0C\x0E-\x1F]/g, ""));
}
function formatAttributes(attrs) {
    return new XMLString(attrs.map(([key, val]) => `${key}="${xmlEscape(val)}"`).join(" "));
}
function parseXML(xmlString, mimeType = "text/xml") {
    const document = new DOMParser().parseFromString(xmlString.toString(), mimeType);
    const parserError = document.querySelector("parsererror");
    if (parserError) {
        const errorString = parserError.innerHTML;
        const lineNumber = parseInt(errorString.split(":")[0], 10);
        const xmlStringArray = xmlString.toString().trim().split("\n");
        const xmlPreview = xmlStringArray
            .slice(Math.max(lineNumber - 3, 0), Math.min(lineNumber + 2, xmlStringArray.length))
            .join("\n");
        throw new Error(`XML string could not be parsed: ${errorString}\n${xmlPreview}`);
    }
    return document;
}
function convertBorderDescr(descr) {
    if (!descr) {
        return undefined;
    }
    return {
        style: descr.style,
        color: { rgb: descr.color },
    };
}
function getDefaultXLSXStructure(data) {
    const xlsxBorders = Object.values(data.borders).map((border) => {
        return {
            left: convertBorderDescr(border.left),
            right: convertBorderDescr(border.right),
            bottom: convertBorderDescr(border.bottom),
            top: convertBorderDescr(border.top),
        };
    });
    const borders = [{}, ...xlsxBorders];
    return {
        relsFiles: [],
        sharedStrings: [],
        // default Values that will always be part of the style sheet
        styles: [
            {
                fontId: 0,
                fillId: 0,
                numFmtId: 0,
                borderId: 0,
                alignment: {},
            },
        ],
        fonts: [
            {
                size: DEFAULT_FONT_SIZE,
                family: 2,
                color: { rgb: "000000" },
                name: "Arial",
            },
        ],
        fills: [{ reservedAttribute: "none" }, { reservedAttribute: "gray125" }],
        borders,
        numFmts: [],
        dxfs: [],
    };
}
function createOverride(partName, contentType) {
    return escapeXml /*xml*/ `
    <Override ContentType="${contentType}" PartName="${partName}" />
  `;
}
function createDefaultXMLElement(extension, contentType) {
    return escapeXml /*xml*/ `
    <Default Extension="${extension}" ContentType="${contentType}" />
  `;
}
function joinXmlNodes(xmlNodes) {
    return new XMLString(xmlNodes.join("\n"));
}
/**
 * Escape interpolated values except if the value is already
 * a properly escaped XML string.
 *
 * ```
 * escapeXml`<t>${"This will be escaped"}</t>`
 * ```
 */
function escapeXml(strings, ...expressions) {
    let str = [strings[0]];
    for (let i = 0; i < expressions.length; i++) {
        const value = expressions[i] instanceof XMLString ? expressions[i] : xmlEscape(expressions[i]);
        str.push(value + strings[i + 1]);
    }
    return new XMLString(concat(str));
}
/**
 * Removes the escaped namespace of all the xml tags in the string.
 *
 * Eg. : "NAMESPACEnsNAMESPACEtest a" => "test a"
 */
function removeTagEscapedNamespaces(tag) {
    return tag.replace(/NAMESPACE.*NAMESPACE(.*)/, "$1");
}
/**
 * Encase the namespaces in the element's tags with NAMESPACE string
 *
 * e.g. <x:foo> becomes <NAMESPACExNAMESPACEFoo>
 *
 * That's useful because namespaces aren't supported by the HTML specification, so it's arbitrary whether a HTML parser/querySelector
 * implementation will support namespaces in the tags or not.
 */
function escapeTagNamespaces(str) {
    return str.replaceAll(/(<\/?)([a-zA-Z0-9]+):([a-zA-Z0-9]+)/g, "$1" + "NAMESPACE" + "$2" + "NAMESPACE" + "$3");
}
function escapeQueryNameSpaces(query) {
    return query.replaceAll(/([a-zA-Z0-9]+):([a-zA-Z0-9]+)/g, "NAMESPACE" + "$1" + "NAMESPACE" + "$2");
}

class AttributeValue {
    value;
    constructor(value) {
        this.value = value;
    }
    asString() {
        return fixXlsxUnicode(String(this.value));
    }
    asBool() {
        if (this.value === "true")
            return true; // for files exported from Libre Office
        if (this.value === "false")
            return false;
        return Boolean(Number(this.value));
    }
    asNum() {
        return Number(this.value);
    }
}
class XlsxBaseExtractor {
    rootFile;
    xlsxFileStructure;
    warningManager;
    relationships;
    // The xml file we are currently parsing. We should have one Extractor class by XLSXImportFile, but
    // the XLSXImportFile contains both the main .xml file, and the .rels file
    currentFile = undefined;
    /**
     * /!\ Important : There should be no namespaces in the tags of the XML files.
     *
     * This class use native querySelector and querySelectorAll, that's used for HTML (not XML). These aren't supposed to
     * handled namespaces, as they are not supported by the HTML specification. Some implementations (most browsers) do
     * actually support namespaces, but some don't (e.g. jsdom).
     *
     * The namespace should be escaped as with NAMESPACE string (eg. <t:foo> => <NAMESPACEtNAMESPACEfoo>).
     */
    constructor(rootFile, xlsxStructure, warningManager) {
        this.rootFile = rootFile;
        this.currentFile = rootFile.file.fileName;
        this.xlsxFileStructure = xlsxStructure;
        this.warningManager = warningManager;
        this.relationships = {};
        if (rootFile.rels) {
            this.extractRelationships(rootFile.rels).map((rel) => {
                this.relationships[rel.id] = rel;
            });
        }
    }
    /**
     * Extract all the relationships inside a .xml.rels file
     */
    extractRelationships(relFile) {
        return this.mapOnElements({ parent: relFile.xml, query: "Relationship" }, (relationshipElement) => {
            return {
                id: this.extractAttr(relationshipElement, "Id", { required: true }).asString(),
                target: this.extractAttr(relationshipElement, "Target", { required: true }).asString(),
                type: this.extractAttr(relationshipElement, "Type", { required: true }).asString(),
            };
        });
    }
    /**
     * Get the list of all the XLSX files in the XLSX file structure
     */
    getListOfXMLFiles() {
        const XMLFiles = Object.entries(this.xlsxFileStructure)
            .filter(([key]) => key !== "images")
            .map(([_, value]) => value)
            .flat()
            .filter(isDefined);
        return XMLFiles;
    }
    /**
     * Return an array containing the return value of the given function applied to all the XML elements
     * found using the MapOnElementArgs.
     *
     * The arguments contains :
     *  - query : a QuerySelector string to find the elements to apply the function to
     *  - parent : an XML element or XML document in which to find the queried elements
     *  - children : if true, the function is applied on the direct children of the queried element
     *
     * This method will also handle the errors thrown in the argument function.
     */
    mapOnElements(args, fct) {
        const ret = [];
        const oldWorkingDocument = this.currentFile;
        let elements;
        if (args.children) {
            const children = this.querySelector(args.parent, args.query)?.children;
            elements = children ? children : [];
        }
        else {
            elements = this.querySelectorAll(args.parent, args.query);
        }
        if (elements) {
            for (let element of elements) {
                try {
                    ret.push(fct(element));
                }
                catch (e) {
                    this.catchErrorOnElement(e, element);
                }
            }
        }
        this.currentFile = oldWorkingDocument;
        return ret;
    }
    /**
     * Log an error caught when parsing an element in the warningManager.
     */
    catchErrorOnElement(error, onElement) {
        const errorMsg = onElement
            ? `Error when parsing an element <${onElement.tagName}> of file ${this.currentFile}, skip this element. \n${error.stack}`
            : `Error when parsing file ${this.currentFile}.`;
        this.warningManager.addParsingWarning([errorMsg, error.message].join("\n"));
    }
    /**
     * Extract an attribute from an Element.
     *
     * If the attribute is required but was not found, will add a warning in the warningManager if it was given a default
     * value, and throw an error if no default value was given.
     *
     * Can only return undefined value for non-required attributes without default value.
     */
    extractAttr(e, attName, optionalArgs) {
        const attribute = e.attributes[attName];
        if (!attribute)
            this.handleMissingValue(e, `attribute "${attName}"`, optionalArgs);
        const value = attribute?.value ? attribute.value : optionalArgs?.default;
        return (value === undefined ? undefined : new AttributeValue(value));
    }
    /**
     * Extract the text content of an Element.
     *
     * If the text content is required but was not found, will add a warning in the warningManager if it was given a default
     * value, and throw an error if no default value was given.
     *
     * Can only return undefined value for non-required text content without default value.
     */
    extractTextContent(element, optionalArgs) {
        if (optionalArgs?.default !== undefined && typeof optionalArgs.default !== "string") {
            throw new Error("extractTextContent default value should be a string");
        }
        const shouldPreserveSpaces = element?.attributes["xml:space"]?.value === "preserve";
        let textContent = element?.textContent;
        if (!element || textContent === null) {
            this.handleMissingValue(element, `text content`, optionalArgs);
        }
        if (textContent) {
            textContent = shouldPreserveSpaces ? textContent : textContent.trim();
        }
        return (textContent ? fixXlsxUnicode(textContent) : optionalArgs?.default);
    }
    /**
     * Extract an attribute of a child of the given element.
     *
     * The reference of a child can be a string (tag of the child) or an number (index in the list of children of the element)
     *
     * If the attribute is required but either the attribute or the referenced child element was not found, it will
     * will add a warning in the warningManager if it was given a default value, and throw an error if no default value was given.
     *
     * Can only return undefined value for non-required attributes without default value.
     */
    extractChildAttr(e, childRef, attName, optionalArgs) {
        let child;
        if (typeof childRef === "number") {
            child = e.children[childRef];
        }
        else {
            child = this.querySelector(e, childRef);
        }
        if (!child) {
            this.handleMissingValue(e, typeof childRef === "number" ? `child at index ${childRef}` : `child <${childRef}>`, optionalArgs);
        }
        const value = child
            ? this.extractAttr(child, attName, optionalArgs)?.asString()
            : optionalArgs?.default;
        return (value !== undefined ? new AttributeValue(value) : undefined);
    }
    /**
     * Extract the text content of a child of the given element.
     *
     * If the text content is required but either the text content or the referenced child element was not found, it will
     * will add a warning in the warningManager if it was given a default value, and throw an error if no default value was given.
     *
     * Can only return undefined value for non-required text content without default value.
     */
    extractChildTextContent(e, childRef, optionalArgs) {
        if (optionalArgs?.default !== undefined && typeof optionalArgs.default !== "string") {
            throw new Error("extractTextContent default value should be a string");
        }
        let child = this.querySelector(e, childRef);
        if (!child) {
            this.handleMissingValue(e, `child <${childRef}>`, optionalArgs);
        }
        return (child ? this.extractTextContent(child, optionalArgs) : optionalArgs?.default);
    }
    /**
     * Should be called if a extractAttr/extractTextContent doesn't find the element it needs to extract.
     *
     * If the extractable was required, this function will add a warning in the warningManager if there was a default value,
     * and throw an error if no default value was given.
     */
    handleMissingValue(parentElement, missingElementName, optionalArgs) {
        if (optionalArgs?.required) {
            if (optionalArgs?.default) {
                this.warningManager.addParsingWarning(`Missing required ${missingElementName} in element <${parentElement.tagName}> of ${this.currentFile}, replacing it by the default value ${optionalArgs.default}`);
            }
            else {
                throw new Error(`Missing required ${missingElementName} in element <${parentElement.tagName}> of ${this.currentFile}, and no default value was set`);
            }
        }
    }
    /**
     * Extract a color, extracting it from the theme if needed.
     *
     * Will throw an error if the element references a theme, but no theme was provided or the theme it doesn't contain the color.
     */
    extractColor(colorElement, theme, defaultColor) {
        if (!colorElement) {
            return defaultColor ? { rgb: defaultColor } : undefined;
        }
        const themeIndex = this.extractAttr(colorElement, "theme")?.asString();
        let rgb;
        if (themeIndex !== undefined) {
            if (!theme || !theme.clrScheme) {
                throw new Error("Color referencing a theme but no theme was provided");
            }
            rgb = this.getThemeColor(themeIndex, theme.clrScheme);
        }
        else {
            rgb = this.extractAttr(colorElement, "rgb")?.asString();
            rgb = rgb === DEFAULT_SYSTEM_COLOR ? undefined : rgb;
        }
        const color = {
            rgb: rgb || defaultColor,
            auto: this.extractAttr(colorElement, "auto")?.asBool(),
            indexed: this.extractAttr(colorElement, "indexed")?.asNum(),
            tint: this.extractAttr(colorElement, "tint")?.asNum(),
        };
        return color;
    }
    /**
     * Returns the xml file targeted by a relationship.
     */
    getTargetXmlFile(relationship) {
        if (!relationship)
            throw new Error("Undefined target file");
        const target = this.processRelationshipTargetName(relationship.target);
        // Use "endsWith" because targets are relative paths, and we know the files by their absolute path.
        const f = this.getListOfXMLFiles().find((f) => f.file.fileName.endsWith(target));
        if (!f || !f.file)
            throw new Error("Cannot find target file");
        return f;
    }
    /**
     * Returns the image parameters targeted by a relationship.
     */
    getTargetImageFile(relationship) {
        if (!relationship)
            throw new Error("Undefined target file");
        const target = this.processRelationshipTargetName(relationship.target);
        // Use "endsWith" because targets are relative paths, and we know the files by their absolute path.
        const f = this.xlsxFileStructure.images.find((f) => f.fileName.endsWith(target));
        if (!f)
            throw new Error("Cannot find target file");
        return f;
    }
    querySelector(element, query) {
        const escapedQuery = escapeQueryNameSpaces(query);
        return element.querySelector(escapedQuery);
    }
    querySelectorAll(element, query) {
        const escapedQuery = escapeQueryNameSpaces(query);
        return element.querySelectorAll(escapedQuery);
    }
    /**
     * Get a color from its id in the Theme's colorScheme.
     *
     * Note that Excel don't use the colors from the theme but from its own internal theme, so the displayed
     * colors will be different in the import than in excel.
     * .
     */
    getThemeColor(colorId, clrScheme) {
        switch (colorId) {
            case "0": // 0 : sysColor window text
                return "FFFFFF";
            case "1": // 1 : sysColor window background
                return "000000";
            // Don't ask me why these 2 are inverted, I cannot find any documentation for it but everyone does it
            case "2":
                return clrScheme["3"].value;
            case "3":
                return clrScheme["2"].value;
            default:
                return clrScheme[colorId].value;
        }
    }
    /** Remove signs of relative path. */
    processRelationshipTargetName(targetName) {
        return targetName.replace(/\.+\//, "");
    }
}

/**
 * XLSX Extractor class that can be used for either sharedString XML files or theme XML files.
 *
 * Since they both are quite simple, it make sense to make a single class to manage them all, to avoid unnecessary file
 * cluttering.
 */
class XlsxMiscExtractor extends XlsxBaseExtractor {
    getTheme() {
        const clrScheme = this.mapOnElements({ query: "a:clrScheme", parent: this.rootFile.file.xml, children: true }, (element) => {
            return {
                name: element.tagName,
                value: this.extractChildAttr(element, 0, "val", {
                    required: true,
                    default: AUTO_COLOR,
                }).asString(),
                lastClr: this.extractChildAttr(element, 0, "lastClr", {
                    default: AUTO_COLOR,
                }).asString(),
            };
        });
        return { clrScheme };
    }
    /**
     * Get the array of shared strings of the XLSX.
     *
     * Worth noting that running a prettier on the xml can mess up some strings, since there is an option in the
     * xmls to keep the spacing and not trim the string.
     */
    getSharedStrings() {
        return this.mapOnElements({ parent: this.rootFile.file.xml, query: "si" }, (ssElement) => {
            // Shared string can either be a simple text, or a rich text (text with formatting, possibly in multiple parts)
            // We don't support rich text formatting, we'll only extract the text
            return this.mapOnElements({ parent: ssElement, query: "t" }, (textElement) => {
                return this.extractTextContent(textElement) || "";
            }).join("");
        });
    }
}

class XlsxCfExtractor extends XlsxBaseExtractor {
    theme;
    constructor(sheetFile, xlsxStructure, warningManager, theme) {
        super(sheetFile, xlsxStructure, warningManager);
        this.theme = theme;
    }
    extractConditionalFormattings() {
        const cfs = this.mapOnElements({ parent: this.rootFile.file.xml, query: "worksheet > conditionalFormatting" }, (cfElement) => {
            return {
                // sqref = ranges on which the cf applies, separated by spaces
                sqref: this.extractAttr(cfElement, "sqref", { required: true }).asString().split(" "),
                pivot: this.extractAttr(cfElement, "pivot")?.asBool(),
                cfRules: this.extractCFRules(cfElement, this.theme),
            };
        });
        // XLSX extension to OpenXml
        cfs.push(...this.mapOnElements({ parent: this.rootFile.file.xml, query: "extLst x14:conditionalFormatting" }, (cfElement) => {
            return {
                sqref: this.extractChildTextContent(cfElement, "xm:sqref", { required: true }).split(" "),
                pivot: this.extractAttr(cfElement, "xm:pivot")?.asBool(),
                cfRules: this.extractCFRules(cfElement, this.theme),
            };
        }));
        return cfs;
    }
    extractCFRules(cfElement, theme) {
        return this.mapOnElements({ parent: cfElement, query: "cfRule, x14:cfRule" }, (cfRuleElement) => {
            const cfType = this.extractAttr(cfRuleElement, "type", {
                required: true,
            }).asString();
            if (cfType === "dataBar") {
                // Databars are an extension to OpenXml and have a different format (XLSX §2.6.30). Do'nt bother
                // extracting them as we don't support them.
                throw new Error("Databars conditional formats are not supported.");
            }
            return {
                type: cfType,
                priority: this.extractAttr(cfRuleElement, "priority", { required: true }).asNum(),
                colorScale: this.extractCfColorScale(cfRuleElement, theme),
                formula: this.extractCfFormula(cfRuleElement),
                iconSet: this.extractCfIconSet(cfRuleElement),
                dxfId: this.extractAttr(cfRuleElement, "dxfId")?.asNum(),
                stopIfTrue: this.extractAttr(cfRuleElement, "stopIfTrue")?.asBool(),
                aboveAverage: this.extractAttr(cfRuleElement, "aboveAverage")?.asBool(),
                percent: this.extractAttr(cfRuleElement, "percent")?.asBool(),
                bottom: this.extractAttr(cfRuleElement, "bottom")?.asBool(),
                operator: this.extractAttr(cfRuleElement, "operator")?.asString(),
                text: this.extractAttr(cfRuleElement, "text")?.asString(),
                timePeriod: this.extractAttr(cfRuleElement, "timePeriod")?.asString(),
                rank: this.extractAttr(cfRuleElement, "rank")?.asNum(),
                stdDev: this.extractAttr(cfRuleElement, "stdDev")?.asNum(),
                equalAverage: this.extractAttr(cfRuleElement, "equalAverage")?.asBool(),
            };
        });
    }
    extractCfFormula(cfRulesElement) {
        return this.mapOnElements({ parent: cfRulesElement, query: "formula" }, (cfFormulaElements) => {
            return this.extractTextContent(cfFormulaElements, { required: true });
        });
    }
    extractCfColorScale(cfRulesElement, theme) {
        const colorScaleElement = this.querySelector(cfRulesElement, "colorScale");
        if (!colorScaleElement)
            return undefined;
        return {
            colors: this.mapOnElements({ parent: colorScaleElement, query: "color" }, (colorElement) => {
                return this.extractColor(colorElement, theme, "ffffff");
            }),
            cfvos: this.extractCFVos(colorScaleElement),
        };
    }
    extractCfIconSet(cfRulesElement) {
        const iconSetElement = this.querySelector(cfRulesElement, "iconSet, x14:iconSet");
        if (!iconSetElement)
            return undefined;
        return {
            iconSet: this.extractAttr(iconSetElement, "iconSet", {
                default: "3TrafficLights1",
            }).asString(),
            showValue: this.extractAttr(iconSetElement, "showValue", { default: true }).asBool(),
            percent: this.extractAttr(iconSetElement, "percent", { default: true }).asBool(),
            reverse: this.extractAttr(iconSetElement, "reverse")?.asBool(),
            custom: this.extractAttr(iconSetElement, "custom")?.asBool(),
            cfvos: this.extractCFVos(iconSetElement),
            cfIcons: this.extractCfIcons(iconSetElement),
        };
    }
    extractCfIcons(iconSetElement) {
        const icons = this.mapOnElements({ parent: iconSetElement, query: "cfIcon, x14:cfIcon" }, (cfIconElement) => {
            return {
                iconSet: this.extractAttr(cfIconElement, "iconSet", {
                    required: true,
                }).asString(),
                iconId: this.extractAttr(cfIconElement, "iconId", { required: true }).asNum(),
            };
        });
        return icons.length === 0 ? undefined : icons;
    }
    extractCFVos(parent) {
        return this.mapOnElements({ parent, query: "cfvo, x14:cfvo" }, (cfVoElement) => {
            return {
                type: this.extractAttr(cfVoElement, "type", {
                    required: true,
                }).asString(),
                gte: this.extractAttr(cfVoElement, "gte", { default: true })?.asBool(),
                value: cfVoElement.attributes["val"]
                    ? this.extractAttr(cfVoElement, "val")?.asString()
                    : this.extractChildTextContent(cfVoElement, "f, xm:f"),
            };
        });
    }
}

class XlsxDataValidationExtractor extends XlsxBaseExtractor {
    theme;
    constructor(sheetFile, xlsxStructure, warningManager, theme) {
        super(sheetFile, xlsxStructure, warningManager);
        this.theme = theme;
    }
    extractDataValidations() {
        const dataValidations = this.mapOnElements({ parent: this.rootFile.file.xml, query: "worksheet > dataValidations > dataValidation" }, (dvElement) => {
            return {
                type: this.extractAttr(dvElement, "type", { required: true }).asString(),
                operator: this.extractAttr(dvElement, "operator", {
                    default: "between",
                })?.asString(),
                sqref: this.extractAttr(dvElement, "sqref", { required: true }).asString().split(" "),
                errorStyle: this.extractAttr(dvElement, "errorStyle")?.asString(),
                formula1: this.extractDataValidationFormula(dvElement, 1)[0],
                formula2: this.extractDataValidationFormula(dvElement, 2)[0],
                showErrorMessage: this.extractAttr(dvElement, "showErrorMessage")?.asBool(),
                errorTitle: this.extractAttr(dvElement, "errorTitle")?.asString(),
                error: this.extractAttr(dvElement, "error")?.asString(),
                showInputMessage: this.extractAttr(dvElement, "showInputMessage")?.asBool(),
                promptTitle: this.extractAttr(dvElement, "promptTitle")?.asString(),
                prompt: this.extractAttr(dvElement, "prompt")?.asString(),
                allowBlank: this.extractAttr(dvElement, "allowBlank")?.asBool(),
            };
        });
        return dataValidations;
    }
    extractDataValidationFormula(dvElement, index) {
        return this.mapOnElements({ parent: dvElement, query: `formula${index}` }, (cfFormulaElements) => {
            return this.extractTextContent(cfFormulaElements, { required: true });
        });
    }
}

class XlsxChartExtractor extends XlsxBaseExtractor {
    extractChart() {
        return this.mapOnElements({ parent: this.rootFile.file.xml, query: "c:chartSpace" }, (rootChartElement) => {
            const chartType = this.getChartType(rootChartElement);
            if (!CHART_TYPE_CONVERSION_MAP[chartType]) {
                throw new Error(`Unsupported chart type ${chartType}`);
            }
            if (CHART_TYPE_CONVERSION_MAP[chartType] === "combo") {
                return this.extractComboChart(rootChartElement);
            }
            // Title can be separated into multiple xml elements (for styling and such), we only import the text
            const chartTitle = this.mapOnElements({ parent: rootChartElement, query: "c:chart > c:title a:t" }, (textElement) => {
                return textElement.textContent || "";
            }).join("");
            const barChartGrouping = this.extractChildAttr(rootChartElement, "c:grouping", "val", {
                default: "clustered",
            }).asString();
            return {
                title: { text: chartTitle },
                type: CHART_TYPE_CONVERSION_MAP[chartType],
                dataSets: this.extractChartDatasets(this.querySelectorAll(rootChartElement, `c:${chartType}`), chartType),
                labelRange: this.extractLabelRange(chartType, rootChartElement),
                backgroundColor: this.extractChildAttr(rootChartElement, "c:chartSpace > c:spPr a:srgbClr", "val", {
                    default: "ffffff",
                }).asString(),
                legendPosition: DRAWING_LEGEND_POSITION_CONVERSION_MAP[this.extractChildAttr(rootChartElement, "c:legendPos", "val", {
                    default: "b",
                }).asString()],
                stacked: barChartGrouping === "stacked",
                fontColor: "000000",
            };
        })[0];
    }
    extractLabelRange(chartType, rootChartElement) {
        if (chartType === "scatterChart") {
            return (this.extractChildTextContent(rootChartElement, `c:ser c:strRef c:f`) ||
                this.extractChildTextContent(rootChartElement, `c:ser c:numRef c:f`));
        }
        return this.extractChildTextContent(rootChartElement, `c:ser c:cat c:f`);
    }
    extractComboChart(chartElement) {
        // Title can be separated into multiple xml elements (for styling and such), we only import the text
        const chartTitle = this.mapOnElements({ parent: chartElement, query: "c:title a:t" }, (textElement) => {
            return textElement.textContent || "";
        }).join("");
        const barChartGrouping = this.extractChildAttr(chartElement, "c:grouping", "val", {
            default: "clustered",
        }).asString();
        return {
            title: { text: chartTitle },
            type: "combo",
            dataSets: [
                ...this.extractChartDatasets(this.querySelectorAll(chartElement, `c:barChart`), "comboChart"),
                ...this.extractChartDatasets(this.querySelectorAll(chartElement, `c:lineChart`), "comboChart"),
            ],
            labelRange: this.extractChildTextContent(chartElement, "c:ser c:cat c:f"),
            backgroundColor: this.extractChildAttr(chartElement, "c:chartSpace > c:spPr a:srgbClr", "val", {
                default: "ffffff",
            }).asString(),
            legendPosition: DRAWING_LEGEND_POSITION_CONVERSION_MAP[this.extractChildAttr(chartElement, "c:legendPos", "val", {
                default: "b",
            }).asString()],
            stacked: barChartGrouping === "stacked",
            fontColor: "000000",
        };
    }
    extractChartDatasets(chartElements, chartType) {
        return Array.from(chartElements)
            .map((element) => {
            if (chartType === "scatterChart") {
                return this.extractScatterChartDatasets(element);
            }
            return this.mapOnElements({ parent: element, query: "c:ser" }, (chartDataElement) => {
                let label = {};
                const reference = this.extractChildTextContent(chartDataElement, "c:tx c:f");
                if (reference) {
                    label = { reference };
                }
                else {
                    const text = this.extractChildTextContent(chartDataElement, "c:tx c:v");
                    if (text) {
                        label = { text };
                    }
                }
                const color = this.extractChildAttr(chartDataElement, "c:spPr a:solidFill a:srgbClr", "val");
                return {
                    label,
                    range: this.extractChildTextContent(chartDataElement, "c:val c:f", {
                        required: true,
                    }),
                    backgroundColor: color ? `${toHex(color.asString())}` : undefined,
                };
            });
        })
            .flat();
    }
    extractScatterChartDatasets(chartElement) {
        return this.mapOnElements({ parent: chartElement, query: "c:ser" }, (chartDataElement) => {
            let label = {};
            const reference = this.extractChildTextContent(chartDataElement, "c:tx c:f");
            if (reference) {
                label = { reference };
            }
            else {
                const text = this.extractChildTextContent(chartDataElement, "c:tx c:v");
                if (text) {
                    label = { text };
                }
            }
            return {
                label,
                range: this.extractChildTextContent(chartDataElement, "c:yVal c:f", { required: true }),
            };
        });
    }
    /**
     * The chart type in the XML isn't explicitly defined, but there is an XML element that define the
     * chart, and this element tag name tells us which type of chart it is. We just need to find this XML element.
     */
    getChartType(chartElement) {
        const plotAreaElement = this.querySelector(chartElement, "c:plotArea");
        if (!plotAreaElement) {
            throw new Error("Missing plot area in the chart definition.");
        }
        let globalTag = undefined;
        for (let child of plotAreaElement.children) {
            const tag = removeTagEscapedNamespaces(child.tagName);
            if (XLSX_CHART_TYPES.some((chartType) => chartType === tag)) {
                if (!globalTag) {
                    globalTag = tag;
                }
                else if (globalTag !== tag) {
                    globalTag = "comboChart";
                }
            }
        }
        if (globalTag) {
            return globalTag;
        }
        throw new Error("Unknown chart type");
    }
}

const ONE_CELL_ANCHOR = "oneCellAnchor";
const TWO_CELL_ANCHOR = "twoCellAnchor";
class XlsxFigureExtractor extends XlsxBaseExtractor {
    extractFigures() {
        return this.mapOnElements({ parent: this.rootFile.file.xml, query: "xdr:wsDr", children: true }, (figureElement) => {
            const anchorType = removeTagEscapedNamespaces(figureElement.tagName);
            const anchors = this.extractFigureAnchorsByType(figureElement, anchorType);
            const chartElement = this.querySelector(figureElement, "c:chart");
            const imageElement = this.querySelector(figureElement, "a:blip");
            if (!chartElement && !imageElement) {
                throw new Error("Only chart and image figures are currently supported.");
            }
            return {
                anchors,
                data: chartElement ? this.extractChart(chartElement) : this.extractImage(figureElement),
                figureSize: anchorType === ONE_CELL_ANCHOR
                    ? this.extractFigureSizeFromSizeTag(figureElement, "xdr:ext")
                    : undefined,
            };
        });
    }
    extractFigureAnchorsByType(figureElement, anchorType) {
        switch (anchorType) {
            case ONE_CELL_ANCHOR:
                return [this.extractFigureAnchor("xdr:from", figureElement)];
            case TWO_CELL_ANCHOR:
                return [
                    this.extractFigureAnchor("xdr:from", figureElement),
                    this.extractFigureAnchor("xdr:to", figureElement),
                ];
            default:
                throw new Error(`${anchorType} is not supported for xlsx drawings. `);
        }
    }
    extractFigureSizeFromSizeTag(figureElement, sizeTag) {
        const sizeElement = this.querySelector(figureElement, sizeTag);
        if (!sizeElement) {
            throw new Error(`Missing size element '${sizeTag}'`);
        }
        return {
            cx: this.extractAttr(sizeElement, "cx", { required: true }).asNum(),
            cy: this.extractAttr(sizeElement, "cy", { required: true }).asNum(),
        };
    }
    extractFigureAnchor(anchorTag, figureElement) {
        const anchor = this.querySelector(figureElement, anchorTag);
        if (!anchor) {
            throw new Error(`Missing anchor element ${anchorTag}`);
        }
        return {
            col: Number(this.extractChildTextContent(anchor, "xdr:col", { required: true })),
            colOffset: Number(this.extractChildTextContent(anchor, "xdr:colOff", { required: true })),
            row: Number(this.extractChildTextContent(anchor, "xdr:row", { required: true })),
            rowOffset: Number(this.extractChildTextContent(anchor, "xdr:rowOff", { required: true })),
        };
    }
    extractChart(chartElement) {
        const chartId = this.extractAttr(chartElement, "r:id", { required: true }).asString();
        const chartFile = this.getTargetXmlFile(this.relationships[chartId]);
        const chartDefinition = new XlsxChartExtractor(chartFile, this.xlsxFileStructure, this.warningManager).extractChart();
        if (!chartDefinition) {
            throw new Error("Unable to extract chart definition");
        }
        return chartDefinition;
    }
    extractImage(figureElement) {
        const imageElement = this.querySelector(figureElement, "a:blip");
        const imageId = this.extractAttr(imageElement, "r:embed", { required: true }).asString();
        const image = this.getTargetImageFile(this.relationships[imageId]);
        if (!image) {
            throw new Error("Unable to extract image");
        }
        const extension = image.fileName.split(".").at(-1);
        const anchorType = removeTagEscapedNamespaces(figureElement.tagName);
        const sizeElement = anchorType === TWO_CELL_ANCHOR ? this.querySelector(figureElement, "a:xfrm") : figureElement;
        const sizeTag = anchorType === TWO_CELL_ANCHOR ? "a:ext" : "xdr:ext";
        const size = this.extractFigureSizeFromSizeTag(sizeElement, sizeTag);
        return {
            imageSrc: image.imageSrc,
            mimetype: extension ? IMAGE_EXTENSION_TO_MIMETYPE_MAPPING[extension] : undefined,
            size,
        };
    }
}

/**
 * We don't really support pivot tables, we'll just extract them as Tables.
 */
class XlsxPivotExtractor extends XlsxBaseExtractor {
    getPivotTable() {
        return this.mapOnElements(
        // Use :root instead of "pivotTableDefinition" because others pivotTableDefinition elements are present inside the root
        // pivotTableDefinition elements.
        { query: ":root", parent: this.rootFile.file.xml }, (pivotElement) => {
            return {
                name: this.extractAttr(pivotElement, "name", { required: true }).asString(),
                rowGrandTotals: this.extractAttr(pivotElement, "rowGrandTotals", {
                    default: true,
                }).asBool(),
                location: this.extractPivotLocation(pivotElement),
                style: this.extractPivotStyleInfo(pivotElement),
            };
        })[0];
    }
    extractPivotLocation(pivotElement) {
        return this.mapOnElements({ query: "location", parent: pivotElement }, (pivotStyleElement) => {
            return {
                ref: this.extractAttr(pivotStyleElement, "ref", { required: true }).asString(),
                firstHeaderRow: this.extractAttr(pivotStyleElement, "firstHeaderRow", {
                    required: true,
                }).asNum(),
                firstDataRow: this.extractAttr(pivotStyleElement, "firstDataRow", {
                    required: true,
                }).asNum(),
                firstDataCol: this.extractAttr(pivotStyleElement, "firstDataCol", {
                    required: true,
                }).asNum(),
            };
        })[0];
    }
    extractPivotStyleInfo(pivotElement) {
        return this.mapOnElements({ query: "pivotTableStyleInfo", parent: pivotElement }, (pivotStyleElement) => {
            return {
                name: this.extractAttr(pivotStyleElement, "name", { required: true }).asString(),
                showRowHeaders: this.extractAttr(pivotStyleElement, "showRowHeaders", {
                    required: true,
                }).asBool(),
                showColHeaders: this.extractAttr(pivotStyleElement, "showColHeaders", {
                    required: true,
                }).asBool(),
                showRowStripes: this.extractAttr(pivotStyleElement, "showRowStripes", {
                    required: true,
                }).asBool(),
                showColStripes: this.extractAttr(pivotStyleElement, "showColStripes", {
                    required: true,
                }).asBool(),
                showLastColumn: this.extractAttr(pivotStyleElement, "showLastColumn")?.asBool(),
            };
        })[0];
    }
}

class XlsxTableExtractor extends XlsxBaseExtractor {
    getTable() {
        return this.mapOnElements({ query: "table", parent: this.rootFile.file.xml }, (tableElement) => {
            return {
                displayName: this.extractAttr(tableElement, "displayName", {
                    required: true,
                }).asString(),
                name: this.extractAttr(tableElement, "name")?.asString(),
                id: this.extractAttr(tableElement, "id", { required: true }).asString(),
                ref: this.extractAttr(tableElement, "ref", { required: true }).asString(),
                headerRowCount: this.extractAttr(tableElement, "headerRowCount", {
                    default: 1,
                }).asNum(),
                totalsRowCount: this.extractAttr(tableElement, "totalsRowCount", {
                    default: 0,
                }).asNum(),
                cols: this.extractTableCols(tableElement),
                style: this.extractTableStyleInfo(tableElement),
                autoFilter: this.extractTableAutoFilter(tableElement),
            };
        })[0];
    }
    extractTableCols(tableElement) {
        return this.mapOnElements({ query: "tableColumn", parent: tableElement }, (tableColElement) => {
            return {
                id: this.extractAttr(tableColElement, "id", { required: true }).asString(),
                name: this.extractAttr(tableColElement, "name", { required: true }).asString(),
                colFormula: this.extractChildTextContent(tableColElement, "calculatedColumnFormula"),
            };
        });
    }
    extractTableStyleInfo(tableElement) {
        return this.mapOnElements({ query: "tableStyleInfo", parent: tableElement }, (tableStyleElement) => {
            return {
                name: this.extractAttr(tableStyleElement, "name")?.asString(),
                showFirstColumn: this.extractAttr(tableStyleElement, "showFirstColumn")?.asBool(),
                showLastColumn: this.extractAttr(tableStyleElement, "showLastColumn")?.asBool(),
                showRowStripes: this.extractAttr(tableStyleElement, "showRowStripes")?.asBool(),
                showColumnStripes: this.extractAttr(tableStyleElement, "showColumnStripes")?.asBool(),
            };
        })[0];
    }
    extractTableAutoFilter(tableElement) {
        return this.mapOnElements({ query: "autoFilter", parent: tableElement }, (autoFilterElement) => {
            return {
                columns: this.extractFilterColumns(autoFilterElement),
                zone: this.extractAttr(autoFilterElement, "ref", { required: true }).asString(),
            };
        })[0];
    }
    extractFilterColumns(autoFilterElement) {
        return this.mapOnElements({ query: "tableColumn", parent: autoFilterElement }, (filterColumnElement) => {
            return {
                colId: this.extractAttr(autoFilterElement, "colId", { required: true }).asNum(),
                hiddenButton: this.extractAttr(autoFilterElement, "hiddenButton", {
                    default: false,
                }).asBool(),
                filters: this.extractSimpleFilter(filterColumnElement),
            };
        });
    }
    extractSimpleFilter(filterColumnElement) {
        return this.mapOnElements({ query: "filter", parent: filterColumnElement }, (filterColumnElement) => {
            return {
                val: this.extractAttr(filterColumnElement, "val", { required: true }).asString(),
            };
        });
    }
}

class XlsxSheetExtractor extends XlsxBaseExtractor {
    theme;
    constructor(sheetFile, xlsxStructure, warningManager, theme) {
        super(sheetFile, xlsxStructure, warningManager);
        this.theme = theme;
    }
    getSheet() {
        return this.mapOnElements({ query: "worksheet", parent: this.rootFile.file.xml }, (sheetElement) => {
            const sheetWorkbookInfo = this.getSheetWorkbookInfo();
            return {
                sheetName: this.extractSheetName(),
                sheetViews: this.extractSheetViews(sheetElement),
                sheetFormat: this.extractSheetFormat(sheetElement),
                sheetProperties: this.extractSheetProperties(sheetElement),
                cols: this.extractCols(sheetElement),
                rows: this.extractRows(sheetElement),
                sharedFormulas: this.extractSharedFormulas(sheetElement),
                merges: this.extractMerges(sheetElement),
                cfs: this.extractConditionalFormats(),
                dataValidations: this.extractDataValidations(),
                figures: this.extractFigures(sheetElement),
                hyperlinks: this.extractHyperLinks(sheetElement),
                tables: this.extractTables(sheetElement),
                pivotTables: this.extractPivotTables(),
                isVisible: sheetWorkbookInfo.state === "visible" ? true : false,
            };
        })[0];
    }
    extractSheetViews(worksheet) {
        return this.mapOnElements({ parent: worksheet, query: "sheetView" }, (sheetViewElement) => {
            const paneElement = this.querySelector(sheetViewElement, "pane");
            return {
                tabSelected: this.extractAttr(sheetViewElement, "tabSelected", {
                    default: false,
                }).asBool(),
                showFormulas: this.extractAttr(sheetViewElement, "showFormulas", {
                    default: false,
                }).asBool(),
                showGridLines: this.extractAttr(sheetViewElement, "showGridLines", {
                    default: true,
                }).asBool(),
                showRowColHeaders: this.extractAttr(sheetViewElement, "showRowColHeaders", {
                    default: true,
                }).asBool(),
                pane: {
                    xSplit: paneElement
                        ? this.extractAttr(paneElement, "xSplit", { default: 0 }).asNum()
                        : 0,
                    ySplit: paneElement
                        ? this.extractAttr(paneElement, "ySplit", { default: 0 }).asNum()
                        : 0,
                },
            };
        });
    }
    extractSheetName() {
        const relativePath = getRelativePath(this.xlsxFileStructure.workbook.file.fileName, this.rootFile.file.fileName);
        const workbookRels = this.extractRelationships(this.xlsxFileStructure.workbook.rels);
        const relId = workbookRels.find((rel) => rel.target === relativePath).id;
        // Having a namespace in the attributes names mess with the querySelector, and the behavior is not the same
        // for every XML parser. So we'll search manually instead of using a querySelector to search for an attribute value.
        for (let sheetElement of this.querySelectorAll(this.xlsxFileStructure.workbook.file.xml, "sheet")) {
            if (sheetElement.attributes["r:id"].value === relId) {
                return sheetElement.attributes["name"].value;
            }
        }
        throw new Error("Missing sheet name");
    }
    getSheetWorkbookInfo() {
        const relativePath = getRelativePath(this.xlsxFileStructure.workbook.file.fileName, this.rootFile.file.fileName);
        const workbookRels = this.extractRelationships(this.xlsxFileStructure.workbook.rels);
        const relId = workbookRels.find((rel) => rel.target === relativePath).id;
        const workbookSheets = this.mapOnElements({ parent: this.xlsxFileStructure.workbook.file.xml, query: "sheet" }, (sheetElement) => {
            return {
                relationshipId: this.extractAttr(sheetElement, "r:id", { required: true }).asString(),
                sheetId: this.extractAttr(sheetElement, "sheetId", { required: true }).asString(),
                sheetName: this.extractAttr(sheetElement, "name", { required: true }).asString(),
                state: this.extractAttr(sheetElement, "state", {
                    default: "visible",
                }).asString(),
            };
        });
        const info = workbookSheets.find((info) => info.relationshipId === relId);
        if (!info) {
            throw new Error("Cannot find corresponding workbook sheet");
        }
        return info;
    }
    extractConditionalFormats() {
        return new XlsxCfExtractor(this.rootFile, this.xlsxFileStructure, this.warningManager, this.theme).extractConditionalFormattings();
    }
    extractDataValidations() {
        return new XlsxDataValidationExtractor(this.rootFile, this.xlsxFileStructure, this.warningManager, this.theme).extractDataValidations();
    }
    extractFigures(worksheet) {
        const figures = this.mapOnElements({ parent: worksheet, query: "drawing" }, (drawingElement) => {
            const drawingId = this.extractAttr(drawingElement, "r:id", { required: true })?.asString();
            const drawingFile = this.getTargetXmlFile(this.relationships[drawingId]);
            const figures = new XlsxFigureExtractor(drawingFile, this.xlsxFileStructure, this.warningManager).extractFigures();
            return figures;
        })[0];
        return figures || [];
    }
    extractTables(worksheet) {
        return this.mapOnElements({ query: "tablePart", parent: worksheet }, (tablePartElement) => {
            const tableId = this.extractAttr(tablePartElement, "r:id", { required: true })?.asString();
            const tableFile = this.getTargetXmlFile(this.relationships[tableId]);
            const tableExtractor = new XlsxTableExtractor(tableFile, this.xlsxFileStructure, this.warningManager);
            return tableExtractor.getTable();
        });
    }
    extractPivotTables() {
        try {
            return Object.values(this.relationships)
                .filter((relationship) => relationship.type.endsWith("pivotTable"))
                .map((pivotRelationship) => {
                const pivotFile = this.getTargetXmlFile(pivotRelationship);
                const pivot = new XlsxPivotExtractor(pivotFile, this.xlsxFileStructure, this.warningManager).getPivotTable();
                return pivot;
            });
        }
        catch (e) {
            this.catchErrorOnElement(e);
            return [];
        }
    }
    extractMerges(worksheet) {
        return this.mapOnElements({ parent: worksheet, query: "mergeCell" }, (mergeElement) => {
            return this.extractAttr(mergeElement, "ref", { required: true }).asString();
        });
    }
    extractSheetFormat(worksheet) {
        const formatElement = this.querySelector(worksheet, "sheetFormatPr");
        if (!formatElement)
            return undefined;
        return {
            defaultColWidth: this.extractAttr(formatElement, "defaultColWidth", {
                default: EXCEL_DEFAULT_COL_WIDTH.toString(),
            }).asNum(),
            defaultRowHeight: this.extractAttr(formatElement, "defaultRowHeight", {
                default: EXCEL_DEFAULT_ROW_HEIGHT.toString(),
            }).asNum(),
        };
    }
    extractSheetProperties(worksheet) {
        const propertiesElement = this.querySelector(worksheet, "sheetPr");
        if (!propertiesElement)
            return undefined;
        return {
            outlinePr: this.extractSheetOutlineProperties(propertiesElement),
            tabColor: this.extractColor(this.querySelector(propertiesElement, "tabColor"), this.theme),
        };
    }
    extractSheetOutlineProperties(sheetProperties) {
        const properties = this.querySelector(sheetProperties, "outlinePr");
        if (!properties)
            return undefined;
        return {
            summaryBelow: this.extractAttr(properties, "summaryBelow", { default: true }).asBool(),
            summaryRight: this.extractAttr(properties, "summaryRight", { default: true }).asBool(),
        };
    }
    extractCols(worksheet) {
        return this.mapOnElements({ parent: worksheet, query: "cols col" }, (colElement) => {
            return {
                width: this.extractAttr(colElement, "width")?.asNum(),
                customWidth: this.extractAttr(colElement, "customWidth")?.asBool(),
                bestFit: this.extractAttr(colElement, "bestFit")?.asBool(),
                hidden: this.extractAttr(colElement, "hidden")?.asBool(),
                min: this.extractAttr(colElement, "min", { required: true })?.asNum(),
                max: this.extractAttr(colElement, "max", { required: true })?.asNum(),
                styleIndex: this.extractAttr(colElement, "style")?.asNum(),
                outlineLevel: this.extractAttr(colElement, "outlineLevel")?.asNum(),
                collapsed: this.extractAttr(colElement, "collapsed")?.asBool(),
            };
        });
    }
    extractRows(worksheet) {
        return this.mapOnElements({ parent: worksheet, query: "sheetData row" }, (rowElement) => {
            return {
                index: this.extractAttr(rowElement, "r", { required: true })?.asNum(),
                cells: this.extractCells(rowElement),
                height: this.extractAttr(rowElement, "ht")?.asNum(),
                customHeight: this.extractAttr(rowElement, "customHeight")?.asBool(),
                hidden: this.extractAttr(rowElement, "hidden")?.asBool(),
                styleIndex: this.extractAttr(rowElement, "s")?.asNum(),
                outlineLevel: this.extractAttr(rowElement, "outlineLevel")?.asNum(),
                collapsed: this.extractAttr(rowElement, "collapsed")?.asBool(),
            };
        });
    }
    extractCells(row) {
        return this.mapOnElements({ parent: row, query: "c" }, (cellElement) => {
            return {
                xc: this.extractAttr(cellElement, "r", { required: true })?.asString(),
                styleIndex: this.extractAttr(cellElement, "s")?.asNum(),
                type: CELL_TYPE_CONVERSION_MAP[this.extractAttr(cellElement, "t", { default: "n" })?.asString()],
                value: this.extractChildTextContent(cellElement, "v"),
                formula: this.extractCellFormula(cellElement),
            };
        });
    }
    extractCellFormula(cellElement) {
        const formulaElement = this.querySelector(cellElement, "f");
        if (!formulaElement)
            return undefined;
        return {
            content: this.extractTextContent(formulaElement),
            sharedIndex: this.extractAttr(formulaElement, "si")?.asNum(),
            ref: this.extractAttr(formulaElement, "ref")?.asString(),
        };
    }
    extractHyperLinks(worksheet) {
        return this.mapOnElements({ parent: worksheet, query: "hyperlink" }, (linkElement) => {
            const relId = this.extractAttr(linkElement, "r:id")?.asString();
            return {
                xc: this.extractAttr(linkElement, "ref", { required: true })?.asString(),
                location: this.extractAttr(linkElement, "location")?.asString(),
                display: this.extractAttr(linkElement, "display")?.asString(),
                relTarget: relId ? this.relationships[relId].target : undefined,
            };
        });
    }
    extractSharedFormulas(worksheet) {
        const sfElements = this.querySelectorAll(worksheet, `f[si][ref]`);
        const sfMap = {};
        for (let sfElement of sfElements) {
            const index = this.extractAttr(sfElement, "si", { required: true }).asNum();
            const formula = this.extractTextContent(sfElement, { required: true });
            sfMap[index] = formula;
        }
        const sfs = [];
        for (let i = 0; i < Object.keys(sfMap).length; i++) {
            if (!sfMap[i]) {
                this.warningManager.addParsingWarning(`Missing shared formula ${i}, replacing it by empty formula`);
                sfs.push("");
            }
            else {
                sfs.push(sfMap[i]);
            }
        }
        return sfs;
    }
}

class XlsxStyleExtractor extends XlsxBaseExtractor {
    theme;
    constructor(xlsxStructure, warningManager, theme) {
        super(xlsxStructure.styles, xlsxStructure, warningManager);
        this.theme = theme;
    }
    getNumFormats() {
        return this.mapOnElements({ parent: this.rootFile.file.xml, query: "numFmt" }, (numFmtElement) => {
            return this.extractNumFormats(numFmtElement);
        });
    }
    extractNumFormats(numFmtElement) {
        return {
            id: this.extractAttr(numFmtElement, "numFmtId", {
                required: true,
            }).asNum(),
            format: this.extractAttr(numFmtElement, "formatCode", {
                required: true,
                default: "",
            }).asString(),
        };
    }
    getFonts() {
        return this.mapOnElements({ parent: this.rootFile.file.xml, query: "font" }, (font) => {
            return this.extractFont(font);
        });
    }
    extractFont(fontElement) {
        const name = this.extractChildAttr(fontElement, "name", "val", {
            default: "Arial",
        }).asString();
        const size = this.extractChildAttr(fontElement, "sz", "val", {
            default: DEFAULT_FONT_SIZE.toString(),
        }).asNum();
        const color = this.extractColor(this.querySelector(fontElement, `color`), this.theme);
        // The behavior for these is kinda strange. The text is italic if there is either a "italic" tag with no "val"
        // attribute, or a tag with a "val" attribute = "1" (boolean).
        const italicElement = this.querySelector(fontElement, `i`) || undefined;
        const italic = italicElement && italicElement.attributes["val"]?.value !== "0";
        const boldElement = this.querySelector(fontElement, `b`) || undefined;
        const bold = boldElement && boldElement.attributes["val"]?.value !== "0";
        const strikeElement = this.querySelector(fontElement, `strike`) || undefined;
        const strike = strikeElement && strikeElement.attributes["val"]?.value !== "0";
        const underlineElement = this.querySelector(fontElement, `u`) || undefined;
        const underline = underlineElement && underlineElement.attributes["val"]?.value !== "none";
        return { name, size, color, italic, bold, underline, strike };
    }
    getFills() {
        return this.mapOnElements({ parent: this.rootFile.file.xml, query: "fill" }, (fillElement) => {
            return this.extractFill(fillElement);
        });
    }
    extractFill(fillElement) {
        // Fills are either patterns of gradients
        const fillChild = fillElement.children[0];
        if (fillChild.tagName === "patternFill") {
            return {
                patternType: fillChild.attributes["patternType"]?.value,
                bgColor: this.extractColor(this.querySelector(fillChild, "bgColor"), this.theme),
                fgColor: this.extractColor(this.querySelector(fillChild, "fgColor"), this.theme),
            };
        }
        else {
            // We don't support gradients. Take the second gradient color as fill color
            return {
                patternType: "solid",
                fgColor: this.extractColor(this.querySelectorAll(fillChild, "color")[1], this.theme),
            };
        }
    }
    getBorders() {
        return this.mapOnElements({ parent: this.rootFile.file.xml, query: "border" }, (borderElement) => {
            return this.extractBorder(borderElement);
        });
    }
    extractBorder(borderElement) {
        const border = {
            left: this.extractSingleBorder(borderElement, "left", this.theme),
            right: this.extractSingleBorder(borderElement, "right", this.theme),
            top: this.extractSingleBorder(borderElement, "top", this.theme),
            bottom: this.extractSingleBorder(borderElement, "bottom", this.theme),
            diagonal: this.extractSingleBorder(borderElement, "diagonal", this.theme),
        };
        if (border.diagonal) {
            border.diagonalUp = this.extractAttr(borderElement, "diagonalUp")?.asBool();
            border.diagonalDown = this.extractAttr(borderElement, "diagonalDown")?.asBool();
        }
        return border;
    }
    extractSingleBorder(borderElement, direction, theme) {
        const directionElement = this.querySelector(borderElement, direction);
        if (!directionElement || !directionElement.attributes["style"])
            return undefined;
        return {
            style: this.extractAttr(directionElement, "style", {
                required: true,
                default: "thin",
            }).asString(),
            color: this.extractColor(directionElement.children[0], theme, "000000"),
        };
    }
    extractAlignment(alignmentElement) {
        return {
            horizontal: this.extractAttr(alignmentElement, "horizontal", {
                default: "general",
            }).asString(),
            vertical: this.extractAttr(alignmentElement, "vertical", {
                default: "bottom",
            }).asString(),
            textRotation: this.extractAttr(alignmentElement, "textRotation")?.asNum(),
            wrapText: this.extractAttr(alignmentElement, "wrapText")?.asBool(),
            indent: this.extractAttr(alignmentElement, "indent")?.asNum(),
            relativeIndent: this.extractAttr(alignmentElement, "relativeIndent")?.asNum(),
            justifyLastLine: this.extractAttr(alignmentElement, "justifyLastLine")?.asBool(),
            shrinkToFit: this.extractAttr(alignmentElement, "shrinkToFit")?.asBool(),
            readingOrder: this.extractAttr(alignmentElement, "readingOrder")?.asNum(),
        };
    }
    getDxfs() {
        return this.mapOnElements({ query: "dxf", parent: this.rootFile.file.xml }, (dxfElement) => {
            const fontElement = this.querySelector(dxfElement, "font");
            const fillElement = this.querySelector(dxfElement, "fill");
            const borderElement = this.querySelector(dxfElement, "border");
            const numFmtElement = this.querySelector(dxfElement, "numFmt");
            const alignmentElement = this.querySelector(dxfElement, "alignment");
            return {
                font: fontElement ? this.extractFont(fontElement) : undefined,
                fill: fillElement ? this.extractFill(fillElement) : undefined,
                numFmt: numFmtElement ? this.extractNumFormats(numFmtElement) : undefined,
                alignment: alignmentElement ? this.extractAlignment(alignmentElement) : undefined,
                border: borderElement ? this.extractBorder(borderElement) : undefined,
            };
        });
    }
    getStyles() {
        return this.mapOnElements({ query: "cellXfs xf", parent: this.rootFile.file.xml }, (styleElement) => {
            const alignmentElement = this.querySelector(styleElement, "alignment");
            return {
                fontId: this.extractAttr(styleElement, "fontId", {
                    required: true,
                    default: 0,
                }).asNum(),
                fillId: this.extractAttr(styleElement, "fillId", {
                    required: true,
                    default: 0,
                }).asNum(),
                borderId: this.extractAttr(styleElement, "borderId", {
                    required: true,
                    default: 0,
                }).asNum(),
                numFmtId: this.extractAttr(styleElement, "numFmtId", {
                    required: true,
                    default: 0,
                }).asNum(),
                alignment: alignmentElement ? this.extractAlignment(alignmentElement) : undefined,
            };
        });
    }
}

class XlsxExternalBookExtractor extends XlsxBaseExtractor {
    getExternalBook() {
        return this.mapOnElements({ parent: this.rootFile.file.xml, query: "externalBook" }, (bookElement) => {
            return {
                rId: this.extractAttr(bookElement, "r:id", { required: true }).asString(),
                sheetNames: this.mapOnElements({ parent: bookElement, query: "sheetName" }, (sheetNameElement) => {
                    return this.extractAttr(sheetNameElement, "val", { required: true }).asString();
                }),
                datasets: this.extractExternalSheetData(bookElement),
            };
        })[0];
    }
    extractExternalSheetData(externalBookElement) {
        return this.mapOnElements({ parent: externalBookElement, query: "sheetData" }, (sheetDataElement) => {
            const cellsData = this.mapOnElements({ parent: sheetDataElement, query: "cell" }, (cellElement) => {
                return {
                    xc: this.extractAttr(cellElement, "r", { required: true }).asString(),
                    value: this.extractChildTextContent(cellElement, "v", { required: true }),
                };
            });
            const dataMap = {};
            for (let cell of cellsData) {
                dataMap[cell.xc] = cell.value;
            }
            return {
                sheetId: this.extractAttr(sheetDataElement, "sheetId", { required: true }).asNum(),
                data: dataMap,
            };
        });
    }
}

/**
 * Return all the xmls converted to XLSXImportFile corresponding to the given content type.
 */
function getXLSXFilesOfType(contentType, xmls) {
    const paths = getPathsOfContent(contentType, xmls);
    return getXlsxFile(paths, xmls);
}
/**
 * From an array of file path, return the equivalents XLSXFiles. An XLSX File is composed of an XML,
 * and optionally of a relationships XML.
 */
function getXlsxFile(files, xmls) {
    const ret = [];
    for (let file of files) {
        const rels = getRelationFile(file, xmls);
        ret.push({
            file: { fileName: file, xml: xmls[file] },
            rels: rels ? { fileName: rels, xml: xmls[rels] } : undefined,
        });
    }
    return ret;
}
/**
 * Return all the path of the files in a XLSX directory that have content of the given type.
 */
function getPathsOfContent(contentType, xmls) {
    const xml = xmls[CONTENT_TYPES_FILE];
    const sheetItems = xml.querySelectorAll(`Override[ContentType="${contentType}"]`);
    const paths = [];
    for (let item of sheetItems) {
        const file = item?.attributes["PartName"].value;
        paths.push(file.substring(1)); // Remove the heading "/"
    }
    return paths;
}
/**
 * Get the corresponding relationship file for a given xml file in a XLSX directory.
 */
function getRelationFile(file, xmls) {
    if (file === CONTENT_TYPES_FILE) {
        return "_rels/.rels";
    }
    let relsFile = "";
    const pathParts = file.split("/");
    for (let i = 0; i < pathParts.length - 1; i++) {
        relsFile += pathParts[i] + "/";
    }
    relsFile += "_rels/";
    relsFile += pathParts[pathParts.length - 1] + ".rels";
    if (!xmls[relsFile]) {
        relsFile = undefined;
    }
    return relsFile;
}

const EXCEL_IMPORT_VERSION = 21;
class XlsxReader {
    warningManager;
    xmls;
    images;
    constructor(files) {
        this.warningManager = new XLSXImportWarningManager();
        this.xmls = {};
        this.images = [];
        for (let key of Object.keys(files)) {
            // Random files can be in xlsx (like a bin file for printer settings)
            if (key.endsWith(".xml") || key.endsWith(".rels")) {
                const contentString = escapeTagNamespaces(files[key]);
                this.xmls[key] = parseXML(new XMLString(contentString));
            }
            else if (key.includes("media/image")) {
                this.images.push({
                    fileName: key,
                    imageSrc: files[key]["imageSrc"],
                });
            }
        }
    }
    convertXlsx() {
        const xlsxData = this.getXlsxData();
        const convertedData = this.convertImportedData(xlsxData);
        return convertedData;
    }
    // ---------------------------------------------------------------------------
    // Parsing XMLs
    // ---------------------------------------------------------------------------
    getXlsxData() {
        const xlsxFileStructure = this.buildXlsxFileStructure();
        const theme = xlsxFileStructure.theme
            ? new XlsxMiscExtractor(xlsxFileStructure.theme, xlsxFileStructure, this.warningManager).getTheme()
            : undefined;
        const sharedStrings = xlsxFileStructure.sharedStrings
            ? new XlsxMiscExtractor(xlsxFileStructure.sharedStrings, xlsxFileStructure, this.warningManager).getSharedStrings()
            : [];
        // Sort sheets by file name : the sheets will always be named sheet1.xml, sheet2.xml, ... in order
        const sheets = xlsxFileStructure.sheets
            .sort((a, b) => a.file.fileName.localeCompare(b.file.fileName, undefined, { numeric: true }))
            .map((sheetFile) => {
            return new XlsxSheetExtractor(sheetFile, xlsxFileStructure, this.warningManager, theme).getSheet();
        });
        const externalBooks = xlsxFileStructure.externalLinks.map((externalLinkFile) => {
            return new XlsxExternalBookExtractor(externalLinkFile, xlsxFileStructure, this.warningManager).getExternalBook();
        });
        const styleExtractor = new XlsxStyleExtractor(xlsxFileStructure, this.warningManager, theme);
        return {
            fonts: styleExtractor.getFonts(),
            fills: styleExtractor.getFills(),
            borders: styleExtractor.getBorders(),
            dxfs: styleExtractor.getDxfs(),
            numFmts: styleExtractor.getNumFormats(),
            styles: styleExtractor.getStyles(),
            sheets: sheets,
            sharedStrings,
            externalBooks,
        };
    }
    buildXlsxFileStructure() {
        const xlsxFileStructure = {
            sheets: getXLSXFilesOfType(CONTENT_TYPES.sheet, this.xmls),
            workbook: getXLSXFilesOfType(CONTENT_TYPES.workbook, this.xmls)[0],
            styles: getXLSXFilesOfType(CONTENT_TYPES.styles, this.xmls)[0],
            sharedStrings: getXLSXFilesOfType(CONTENT_TYPES.sharedStrings, this.xmls)[0],
            theme: getXLSXFilesOfType(CONTENT_TYPES.themes, this.xmls)[0],
            charts: getXLSXFilesOfType(CONTENT_TYPES.chart, this.xmls),
            figures: getXLSXFilesOfType(CONTENT_TYPES.drawing, this.xmls),
            tables: getXLSXFilesOfType(CONTENT_TYPES.table, this.xmls),
            pivots: getXLSXFilesOfType(CONTENT_TYPES.pivot, this.xmls),
            externalLinks: getXLSXFilesOfType(CONTENT_TYPES.externalLink, this.xmls),
            images: this.images,
        };
        if (!xlsxFileStructure.workbook.rels) {
            throw Error(_t("Cannot find workbook relations file"));
        }
        return xlsxFileStructure;
    }
    // ---------------------------------------------------------------------------
    // Conversion
    // ---------------------------------------------------------------------------
    convertImportedData(data) {
        const convertedData = {
            version: EXCEL_IMPORT_VERSION,
            sheets: convertSheets(data, this.warningManager),
            styles: convertStyles(data, this.warningManager),
            formats: convertFormats(data, this.warningManager),
            borders: convertBorders(data, this.warningManager),
            revisionId: DEFAULT_REVISION_ID,
        };
        convertTables(convertedData, data);
        // Remove falsy attributes in styles. Not mandatory, but make objects more readable when debugging
        Object.keys(data.styles).map((key) => {
            data.styles[key] = removeFalsyAttributes(data.styles[key]);
        });
        return convertedData;
    }
}

var State;
(function (State) {
    /**
     * Initial state.
     * Expecting any reference for the left part of a range
     * e.g. "A1", "1", "A", "Sheet1!A1", "Sheet1!A"
     */
    State[State["LeftRef"] = 0] = "LeftRef";
    /**
     * Expecting any reference for the right part of a range
     * e.g. "A1", "1", "A", "Sheet1!A1", "Sheet1!A"
     */
    State[State["RightRef"] = 1] = "RightRef";
    /**
     * Expecting the separator without any constraint on the right part
     */
    State[State["Separator"] = 2] = "Separator";
    /**
     * Expecting the separator for a full column range
     */
    State[State["FullColumnSeparator"] = 3] = "FullColumnSeparator";
    /**
     * Expecting the separator for a full row range
     */
    State[State["FullRowSeparator"] = 4] = "FullRowSeparator";
    /**
     * Expecting the right part of a full column range
     * e.g. "1", "A1"
     */
    State[State["RightColumnRef"] = 5] = "RightColumnRef";
    /**
     * Expecting the right part of a full row range
     * e.g. "A", "A1"
     */
    State[State["RightRowRef"] = 6] = "RightRowRef";
    /**
     * Final state. A range has been matched
     */
    State[State["Found"] = 7] = "Found";
})(State || (State = {}));
const goTo = (state, guard = () => true) => [
    {
        goTo: state,
        guard,
    },
];
const goToMulti = (state, guard = () => true) => ({
    goTo: state,
    guard,
});
const machine = {
    [State.LeftRef]: {
        REFERENCE: goTo(State.Separator),
        NUMBER: goTo(State.FullRowSeparator),
        SYMBOL: [
            goToMulti(State.FullColumnSeparator, (token) => isColReference(token.value)),
            goToMulti(State.FullRowSeparator, (token) => isRowReference(token.value)),
        ],
    },
    [State.FullColumnSeparator]: {
        SPACE: goTo(State.FullColumnSeparator),
        OPERATOR: goTo(State.RightColumnRef, (token) => token.value === ":"),
    },
    [State.FullRowSeparator]: {
        SPACE: goTo(State.FullRowSeparator),
        OPERATOR: goTo(State.RightRowRef, (token) => token.value === ":"),
    },
    [State.Separator]: {
        SPACE: goTo(State.Separator),
        OPERATOR: goTo(State.RightRef, (token) => token.value === ":"),
    },
    [State.RightRef]: {
        SPACE: goTo(State.RightRef),
        NUMBER: goTo(State.Found),
        REFERENCE: goTo(State.Found, (token) => isSingleCellReference(token.value)),
        SYMBOL: goTo(State.Found, (token) => isColHeader(token.value) || isRowHeader(token.value)),
    },
    [State.RightColumnRef]: {
        SPACE: goTo(State.RightColumnRef),
        SYMBOL: goTo(State.Found, (token) => isColHeader(token.value)),
        REFERENCE: goTo(State.Found, (token) => isSingleCellReference(token.value)),
    },
    [State.RightRowRef]: {
        SPACE: goTo(State.RightRowRef),
        NUMBER: goTo(State.Found),
        REFERENCE: goTo(State.Found, (token) => isSingleCellReference(token.value)),
        SYMBOL: goTo(State.Found, (token) => isRowHeader(token.value)),
    },
    [State.Found]: {},
};
/**
 * Check if the list of tokens starts with a sequence of tokens representing
 * a range.
 * If a range is found, the sequence is removed from the list and is returned
 * as a single token.
 */
function matchReference(tokens) {
    let head = 0;
    let transitions = machine[State.LeftRef];
    let matchedTokens = "";
    while (transitions !== undefined) {
        const token = tokens[head++];
        if (!token) {
            return null;
        }
        const transition = transitions[token.type]?.find((transition) => transition.guard(token));
        const nextState = transition ? transition.goTo : undefined;
        switch (nextState) {
            case undefined:
                return null;
            case State.Found:
                matchedTokens += token.value;
                tokens.splice(0, head);
                return {
                    type: "REFERENCE",
                    value: matchedTokens,
                };
            default:
                transitions = machine[nextState];
                matchedTokens += token.value;
                break;
        }
    }
    return null;
}
/**
 * Take the result of the tokenizer and transform it to be usable in the
 * manipulations of range
 *
 * @param formula
 */
function rangeTokenize(formula, locale = DEFAULT_LOCALE) {
    const tokens = tokenize(formula, locale);
    const result = [];
    while (tokens.length) {
        result.push(matchReference(tokens) || tokens.shift());
    }
    return result;
}

/**
 * parses a formula (as a string) into the same formula,
 * but with the references to other cells extracted
 *
 * =sum(a3:b1) + c3 --> =sum(|0|) + |1|
 *
 * @param formula
 */
function normalizeV9(formula) {
    const tokens = rangeTokenize(formula);
    let dependencies = [];
    let noRefFormula = "".concat(...tokens.map((token) => {
        if (token.type === "REFERENCE" && cellReference.test(token.value)) {
            const value = token.value.trim();
            if (!dependencies.includes(value)) {
                dependencies.push(value);
            }
            return `${FORMULA_REF_IDENTIFIER}${dependencies.indexOf(value)}${FORMULA_REF_IDENTIFIER}`;
        }
        else {
            return token.value;
        }
    }));
    return { text: noRefFormula, dependencies };
}

// FIXME: Remove this map when Firefox supports getWeekInfo
// https:developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Intl/Locale/getWeekInfo
const WEEK_START = {
    am_ET: 7,
    ar_001: 6,
    ar_SY: 6,
    az_AZ: 1,
    eu_ES: 1,
    be_BY: 1,
    bn_IN: 1,
    bs_BA: 1,
    bg_BG: 1,
    ca_ES: 1,
    zh_CN: 7,
    zh_HK: 7,
    zh_TW: 7,
    hr_HR: 1,
    cs_CZ: 1,
    da_DK: 1,
    nl_BE: 1,
    nl_NL: 1,
    en_AU: 7,
    en_CA: 7,
    en_GB: 1,
    en_IN: 7,
    en_NZ: 7,
    et_EE: 1,
    fi_FI: 1,
    fr_BE: 1,
    fr_CA: 7,
    fr_CH: 1,
    fr_FR: 1,
    gl_ES: 1,
    ka_GE: 1,
    de_DE: 1,
    de_CH: 1,
    el_GR: 1,
    gu_IN: 7,
    he_IL: 7,
    hi_IN: 7,
    hu_HU: 1,
    id_ID: 7,
    it_IT: 1,
    ja_JP: 7,
    kab_DZ: 6,
    km_KH: 7,
    ko_KP: 1,
    ko_KR: 7,
    lo_LA: 7,
    lv_LV: 1,
    lt_LT: 1,
    lb_LU: 1,
    mk_MK: 1,
    ml_IN: 1,
    mn_MN: 7,
    ms_MY: 1,
    nb_NO: 1,
    fa_IR: 6,
    pl_PL: 1,
    pt_AO: 1,
    pt_BR: 7,
    pt_PT: 1,
    ro_RO: 1,
    ru_RU: 1,
    sr_RS: 7,
    "sr@latin": 7,
    sk_SK: 1,
    sl_SI: 1,
    es_AR: 7,
    es_BO: 1,
    es_CL: 1,
    es_CO: 7,
    es_CR: 1,
    es_DO: 1,
    es_EC: 1,
    es_GT: 7,
    es_MX: 7,
    es_PA: 7,
    es_PE: 7,
    es_PY: 7,
    es_UY: 1,
    es_VE: 7,
    sw: 1,
    sv_SE: 1,
    th_TH: 7,
    tl_PH: 1,
    tr_TR: 1,
    uk_UA: 1,
    vi_VN: 1,
    sq_AL: 1,
    te_IN: 7,
    en_US: 7,
    my_MM: 7,
    es_ES: 1,
    es_419: 1,
};

const migrationStepRegistry = new Registry();
migrationStepRegistry
    .add("migration_1", {
    // add the `activeSheet` field on data
    versionFrom: "1",
    migrate(data) {
        if (data.sheets && data.sheets[0]) {
            data.activeSheet = data.sheets[0].name;
        }
        return data;
    },
})
    .add("migration_2", {
    // add an id field in each sheet
    versionFrom: "2",
    migrate(data) {
        if (data.sheets && data.sheets.length) {
            for (let sheet of data.sheets) {
                sheet.id = sheet.id || sheet.name;
            }
        }
        return data;
    },
})
    .add("migration_3", {
    // activeSheet is now an id, not the name of a sheet
    versionFrom: "3",
    migrate(data) {
        if (data.sheets && data.activeSheet) {
            const activeSheet = data.sheets.find((s) => s.name === data.activeSheet);
            data.activeSheet = activeSheet.id;
        }
        return data;
    },
})
    .add("migration_4", {
    // add figures object in each sheets
    versionFrom: "4",
    migrate(data) {
        for (let sheet of data.sheets || []) {
            sheet.figures = sheet.figures || [];
        }
        return data;
    },
})
    .add("migration_5", {
    // normalize the content of the cell if it is a formula to avoid parsing all the formula that vary only by the cells they use
    versionFrom: "5",
    migrate(data) {
        for (let sheet of data.sheets || []) {
            for (let xc in sheet.cells || []) {
                const cell = sheet.cells[xc];
                if (cell.content && cell.content.startsWith("=")) {
                    cell.formula = normalizeV9(cell.content);
                }
            }
        }
        return data;
    },
})
    .add("migration_6", {
    // transform chart data structure
    versionFrom: "6",
    migrate(data) {
        for (let sheet of data.sheets || []) {
            for (let f in sheet.figures || []) {
                const { dataSets, ...newData } = sheet.figures[f].data;
                const newDataSets = [];
                for (let ds of dataSets) {
                    if (ds.labelCell) {
                        const dataRange = toZone(ds.dataRange);
                        const newRange = ds.labelCell + ":" + toXC(dataRange.right, dataRange.bottom);
                        newDataSets.push(newRange);
                    }
                    else {
                        newDataSets.push(ds.dataRange);
                    }
                }
                newData.dataSetsHaveTitle = Boolean(dataSets[0].labelCell);
                newData.dataSets = newDataSets;
                sheet.figures[f].data = newData;
            }
        }
        return data;
    },
})
    .add("migration_7", {
    // remove single quotes in sheet names
    versionFrom: "7",
    migrate(data) {
        const namesTaken = [];
        for (let sheet of data.sheets || []) {
            if (!sheet.name) {
                continue;
            }
            const oldName = sheet.name;
            const escapedName = sanitizeSheetName(oldName, "_");
            let i = 1;
            let newName = escapedName;
            while (namesTaken.includes(newName)) {
                newName = `${escapedName}${i}`;
                i++;
            }
            sheet.name = newName;
            namesTaken.push(newName);
            const replaceName = (str) => {
                if (str === undefined) {
                    return str;
                }
                // replaceAll is only available in next Typescript version
                let newString = str.replace(oldName, newName);
                let currentString = str;
                while (currentString !== newString) {
                    currentString = newString;
                    newString = currentString.replace(oldName, newName);
                }
                return currentString;
            };
            //cells
            for (let xc in sheet.cells) {
                const cell = sheet.cells[xc];
                if (cell.formula) {
                    cell.formula.dependencies = cell.formula.dependencies.map(replaceName);
                }
            }
            //charts
            for (let figure of sheet.figures || []) {
                if (figure.type === "chart") {
                    const dataSets = figure.data.dataSets.map(replaceName);
                    const labelRange = replaceName(figure.data.labelRange);
                    figure.data = { ...figure.data, dataSets, labelRange };
                }
            }
            //ConditionalFormats
            for (let cf of sheet.conditionalFormats || []) {
                cf.ranges = cf.ranges.map(replaceName);
                for (const thresholdName of [
                    "minimum",
                    "maximum",
                    "midpoint",
                    "upperInflectionPoint",
                    "lowerInflectionPoint",
                ]) {
                    if (cf.rule[thresholdName]?.type === "formula") {
                        cf.rule[thresholdName].value = replaceName(cf.rule[thresholdName].value);
                    }
                }
            }
        }
        return data;
    },
})
    .add("migration_8", {
    // transform chart data structure with design attributes
    versionFrom: "8",
    migrate(data) {
        for (const sheet of data.sheets || []) {
            for (const chart of sheet.figures || []) {
                chart.data.background = BACKGROUND_CHART_COLOR;
                chart.data.verticalAxisPosition = "left";
                chart.data.legendPosition = "top";
                chart.data.stacked = false;
            }
        }
        return data;
    },
})
    .add("migration_9", {
    // de-normalize formula to reduce exported json size (~30%)
    versionFrom: "9",
    migrate(data) {
        for (let sheet of data.sheets || []) {
            for (let xc in sheet.cells || []) {
                const cell = sheet.cells[xc];
                if (cell.formula) {
                    let { text, dependencies } = cell.formula;
                    for (let [index, d] of Object.entries(dependencies)) {
                        const stringPosition = `\\${FORMULA_REF_IDENTIFIER}${index}\\${FORMULA_REF_IDENTIFIER}`;
                        text = text.replace(new RegExp(stringPosition, "g"), d);
                    }
                    cell.content = text;
                    delete cell.formula;
                }
            }
        }
        return data;
    },
})
    .add("migration_10", {
    // normalize the formats of the cells
    versionFrom: "10",
    migrate(data) {
        const formats = {};
        for (let sheet of data.sheets || []) {
            for (let xc in sheet.cells || []) {
                const cell = sheet.cells[xc];
                if (cell.format) {
                    cell.format = getItemId(cell.format, formats);
                }
            }
        }
        data.formats = formats;
        return data;
    },
})
    .add("migration_11", {
    // Add isVisible to sheets
    versionFrom: "11",
    migrate(data) {
        for (let sheet of data.sheets || []) {
            sheet.isVisible = true;
        }
        return data;
    },
})
    .add("migration_12", {
    // Fix data filter duplication
    versionFrom: "12",
    migrate(data) {
        return fixOverlappingFilters(data);
    },
})
    .add("migration_12_5", {
    // Change Border description structure
    versionFrom: "12.5",
    migrate(data) {
        for (const borderId in data.borders) {
            const border = data.borders[borderId];
            for (const position in border) {
                if (Array.isArray(border[position])) {
                    border[position] = {
                        style: border[position][0],
                        color: border[position][1],
                    };
                }
            }
        }
        return data;
    },
})
    .add("migration_13", {
    // Add locale to spreadsheet settings
    versionFrom: "13",
    migrate(data) {
        if (!data.settings) {
            data.settings = {};
        }
        if (!data.settings.locale) {
            data.settings.locale = DEFAULT_LOCALE;
        }
        return data;
    },
})
    .add("migration_14", {
    // Fix datafilter duplication (post saas-17.1)
    versionFrom: "14",
    migrate(data) {
        return fixOverlappingFilters(data);
    },
})
    .add("migration_14_5", {
    // Rename filterTable to tables
    versionFrom: "14.5",
    migrate(data) {
        for (const sheetData of data.sheets || []) {
            sheetData.tables = sheetData.tables || sheetData.filterTables || [];
            delete sheetData.filterTables;
        }
        return data;
    },
})
    .add("migration_15", {
    // Add pivots
    versionFrom: "15",
    migrate(data) {
        if (!data.pivots) {
            data.pivots = {};
        }
        if (!data.pivotNextId) {
            data.pivotNextId = getMaxObjectId(data.pivots) + 1;
        }
        return data;
    },
})
    .add("migration_16", {
    // transform chart data structure (2)
    versionFrom: "16",
    migrate(data) {
        for (const sheet of data.sheets || []) {
            for (const f in sheet.figures || []) {
                const figure = sheet.figures[f];
                if ("title" in figure.data && typeof figure.data.title === "string") {
                    figure.data.title = { text: figure.data.title };
                }
                const figureType = figure.data.type;
                if (!["line", "bar", "pie", "scatter", "waterfall", "combo"].includes(figureType)) {
                    continue;
                }
                const { dataSets, ...newData } = sheet.figures[f].data;
                const newDataSets = dataSets.map((dataRange) => ({ dataRange }));
                newData.dataSets = newDataSets;
                sheet.figures[f].data = newData;
            }
        }
        return data;
    },
})
    .add("migration_17", {
    // Empty migration to allow external modules to add their own migration steps
    // before this version
    versionFrom: "17",
    migrate(data) {
        return data;
    },
})
    .add("migration_18", {
    // Change measures and dimensions `name` to `fieldName`
    // Add id to measures
    versionFrom: "18",
    migrate(data) {
        for (const pivot of Object.values(data.pivots || {})) {
            pivot.measures = pivot.measures.map((measure) => ({
                id: measure.name, //Do not set name + aggregator, to support old formulas
                fieldName: measure.name,
                aggregator: measure.aggregator,
            }));
            pivot.columns = pivot.columns.map((column) => ({
                fieldName: column.name,
                order: column.order,
                granularity: column.granularity,
            }));
            pivot.rows = pivot.rows.map((row) => ({
                fieldName: row.name,
                order: row.order,
                granularity: row.granularity,
            }));
        }
        return data;
    },
})
    .add("migration_19", {
    // "Add weekStart to locale",
    versionFrom: "19",
    migrate(data) {
        const locale = data.settings?.locale;
        if (locale) {
            const code = locale.code;
            locale.weekStart = WEEK_START[code] || 1; // Default to Monday;
        }
        return data;
    },
})
    .add("migration_20", {
    // group style and format into zones,
    versionFrom: "20",
    migrate(data) {
        for (const sheet of data.sheets || []) {
            sheet.styles = {};
            sheet.formats = {};
            sheet.borders = {};
            for (const xc in sheet.cells) {
                sheet.styles[xc] = sheet.cells[xc].style;
                sheet.formats[xc] = sheet.cells[xc].format;
                sheet.borders[xc] = sheet.cells[xc].border;
                delete sheet.cells[xc].style;
                delete sheet.cells[xc].format;
                delete sheet.cells[xc].border;
            }
        }
        return data;
    },
})
    .add("migration_21", {
    // "Add operator in gauge inflection points",
    versionFrom: "21",
    migrate(data) {
        for (const sheet of data.sheets || []) {
            for (const figure of sheet.figures || []) {
                if (figure.tag !== "chart" || figure.data.type !== "gauge") {
                    continue;
                }
                const gaugeData = figure.data;
                if (gaugeData?.sectionRule?.lowerInflectionPoint) {
                    gaugeData.sectionRule.lowerInflectionPoint.operator = "<=";
                }
                if (gaugeData?.sectionRule?.upperInflectionPoint) {
                    gaugeData.sectionRule.upperInflectionPoint.operator = "<=";
                }
            }
        }
        return data;
    },
});
function fixOverlappingFilters(data) {
    for (let sheet of data.sheets || []) {
        let knownDataFilterZones = [];
        for (let filterTable of sheet.filterTables || []) {
            const zone = toZone(filterTable.range);
            // See commit message of https://github.com/odoo/o-spreadsheet/pull/3632 of more details
            const intersectZoneIndex = knownDataFilterZones.findIndex((knownZone) => overlap(knownZone, zone));
            if (intersectZoneIndex !== -1) {
                knownDataFilterZones[intersectZoneIndex] = zone;
            }
            else {
                knownDataFilterZones.push(zone);
            }
        }
        sheet.filterTables = knownDataFilterZones.map((zone) => ({
            range: zoneToXc(zone),
        }));
    }
    return data;
}

/**
 * This is the current state version number. It should be incremented each time
 * a breaking change is made in the way the state is handled, and an upgrade
 * function should be defined
 */
const CURRENT_VERSION = 22;
const INITIAL_SHEET_ID = "Sheet1";
/**
 * This function tries to load anything that could look like a valid
 * workbookData object. It applies any migrations, if needed, and return a
 * current, complete workbookData object.
 *
 * It also ensures that there is at least one sheet.
 */
function load(data, verboseImport) {
    if (!data) {
        return createEmptyWorkbookData();
    }
    console.debug("### Loading data ###");
    const start = performance.now();
    if (data["[Content_Types].xml"]) {
        const reader = new XlsxReader(data);
        data = reader.convertXlsx();
        if (verboseImport) {
            for (let parsingError of reader.warningManager.warnings.sort()) {
                console.warn(parsingError);
            }
        }
    }
    // apply migrations, if needed
    if ("version" in data) {
        if (data.version < CURRENT_VERSION) {
            console.debug("Migrating data from version", data.version);
            data = migrate(data);
        }
    }
    data = repairData(data);
    console.debug("Data loaded in", performance.now() - start, "ms");
    console.debug("###");
    return data;
}
// -----------------------------------------------------------------------------
// Migrations
// -----------------------------------------------------------------------------
function compareVersions(v1, v2) {
    const version1 = v1.split(".").map(Number);
    const version2 = v2.split(".").map(Number);
    for (let i = 0; i < Math.max(version1.length, version2.length); i++) {
        const part1 = version1[i] || 0;
        const part2 = version2[i] || 0;
        if (part1 > part2) {
            return 1;
        }
        if (part1 < part2) {
            return -1;
        }
    }
    return 0;
}
function migrate(data) {
    const start = performance.now();
    const steps = migrationStepRegistry
        .getAll()
        .sort((a, b) => compareVersions(a.versionFrom, b.versionFrom));
    const index = steps.findIndex((step) => step.versionFrom === data.version.toString());
    for (let i = index; i < steps.length; i++) {
        data = steps[i].migrate(data);
    }
    console.debug("Data migrated in", performance.now() - start, "ms");
    return data;
}
/**
 * This function is used to repair faulty data independently of the migration.
 */
function repairData(data) {
    data = forceUnicityOfFigure(data);
    data = setDefaults(data);
    return data;
}
/**
 * Force the unicity of figure ids accross sheets
 */
function forceUnicityOfFigure(data) {
    if (data.uniqueFigureIds) {
        return data;
    }
    const figureIds = new Set();
    const uuidGenerator = new UuidGenerator();
    for (const sheet of data.sheets || []) {
        for (const figure of sheet.figures || []) {
            if (figureIds.has(figure.id)) {
                figure.id += uuidGenerator.uuidv4();
            }
            figureIds.add(figure.id);
        }
    }
    data.uniqueFigureIds = true;
    return data;
}
/**
 * sanity check: try to fix missing fields/corrupted state by providing
 * sensible default values
 */
function setDefaults(partialData) {
    const data = Object.assign(createEmptyWorkbookData(), partialData, {
        version: CURRENT_VERSION,
    });
    data.sheets = data.sheets
        ? data.sheets.map((s, i) => Object.assign(createEmptySheet(`Sheet${i + 1}`, `Sheet${i + 1}`), s))
        : [];
    if (data.sheets.length === 0) {
        data.sheets.push(createEmptySheet(INITIAL_SHEET_ID, "Sheet1"));
    }
    if (!isValidLocale(data.settings.locale)) {
        data.settings.locale = DEFAULT_LOCALE;
    }
    return data;
}
/**
 * The goal of this function is to repair corrupted/wrong initial messages caused by
 * a bug.
 * The bug should obviously be fixed, but it's too late for existing spreadsheet.
 */
function repairInitialMessages(data, initialMessages) {
    initialMessages = fixTranslatedSheetIds(data, initialMessages);
    initialMessages = dropCommands(initialMessages, "SORT_CELLS");
    initialMessages = dropCommands(initialMessages, "SET_DECIMAL");
    initialMessages = fixChartDefinitions(data, initialMessages);
    return initialMessages;
}
/**
 * When the workbook data is originally empty, a new one is generated on-the-fly.
 * A bug caused the sheet id to be non-deterministic. The sheet id was propagated in
 * commands.
 * This function repairs initial commands with a wrong sheetId.
 */
function fixTranslatedSheetIds(data, initialMessages) {
    // the fix is only needed when the workbook is generated on-the-fly
    if (Object.keys(data).length !== 0) {
        return initialMessages;
    }
    const sheetIds = [];
    const messages = [];
    const fixSheetId = (cmd) => {
        if (cmd.type === "CREATE_SHEET") {
            sheetIds.push(cmd.sheetId);
        }
        else if ("sheetId" in cmd && !sheetIds.includes(cmd.sheetId)) {
            return { ...cmd, sheetId: INITIAL_SHEET_ID };
        }
        return cmd;
    };
    for (const message of initialMessages) {
        if (message.type === "REMOTE_REVISION") {
            messages.push({
                ...message,
                commands: message.commands.map(fixSheetId),
            });
        }
        else {
            messages.push(message);
        }
    }
    return messages;
}
function dropCommands(initialMessages, commandType) {
    const messages = [];
    for (const message of initialMessages) {
        if (message.type === "REMOTE_REVISION") {
            messages.push({
                ...message,
                commands: message.commands.filter((command) => command.type !== commandType),
            });
        }
        else {
            messages.push(message);
        }
    }
    return messages;
}
function fixChartDefinitions(data, initialMessages) {
    const messages = [];
    const map = {};
    for (const sheet of data.sheets || []) {
        sheet.figures?.forEach((figure) => {
            if (figure.tag === "chart") {
                // chart definition
                map[figure.id] = figure.data;
            }
        });
    }
    for (const message of initialMessages) {
        if (message.type === "REMOTE_REVISION") {
            const commands = [];
            for (const cmd of message.commands) {
                let command = cmd;
                switch (cmd.type) {
                    case "CREATE_CHART":
                        map[cmd.id] = cmd.definition;
                        break;
                    case "UPDATE_CHART":
                        if (!map[cmd.id]) {
                            /** the chart does not exist on the map, it might have been created after a duplicate sheet.
                             * We don't have access to the definition, so we skip the command.
                             */
                            console.log(`Fix chart definition: chart with id ${cmd.id} not found.`);
                            continue;
                        }
                        const definition = map[cmd.id];
                        const newDefinition = { ...definition, ...cmd.definition };
                        command = { ...cmd, definition: newDefinition };
                        map[cmd.id] = newDefinition;
                        break;
                }
                commands.push(command);
            }
            messages.push({
                ...message,
                commands,
            });
        }
        else {
            messages.push(message);
        }
    }
    return messages;
}
// -----------------------------------------------------------------------------
// Helpers
// -----------------------------------------------------------------------------
function createEmptySheet(sheetId, name) {
    return {
        id: sheetId,
        name,
        colNumber: 26,
        rowNumber: 100,
        cells: {},
        styles: {},
        formats: {},
        borders: {},
        cols: {},
        rows: {},
        merges: [],
        conditionalFormats: [],
        dataValidationRules: [],
        figures: [],
        tables: [],
        isVisible: true,
    };
}
function createEmptyWorkbookData(sheetName = "Sheet1") {
    const data = {
        version: CURRENT_VERSION,
        sheets: [createEmptySheet(INITIAL_SHEET_ID, sheetName)],
        styles: {},
        formats: {},
        borders: {},
        revisionId: DEFAULT_REVISION_ID,
        uniqueFigureIds: true,
        settings: { locale: DEFAULT_LOCALE },
        pivots: {},
        pivotNextId: 1,
        customTableStyles: {},
    };
    return data;
}
function createEmptyExcelSheet(sheetId, name) {
    return {
        ...createEmptySheet(sheetId, name),
        charts: [],
        images: [],
    };
}
function createEmptyExcelWorkbookData() {
    return {
        ...createEmptyWorkbookData(),
        sheets: [createEmptyExcelSheet(INITIAL_SHEET_ID, "Sheet1")],
    };
}

const PasteInteractiveContent = {
    wrongPasteSelection: _t("This operation is not allowed with multiple selections."),
    willRemoveExistingMerge: _t("This operation is not possible due to a merge. Please remove the merges first than try again."),
    wrongFigurePasteOption: _t("Cannot do a special paste of a figure."),
    frozenPaneOverlap: _t("This operation is not allowed due to an overlapping frozen pane."),
};
function handlePasteResult(env, result) {
    if (!result.isSuccessful) {
        if (result.reasons.includes("WrongPasteSelection" /* CommandResult.WrongPasteSelection */)) {
            env.raiseError(PasteInteractiveContent.wrongPasteSelection);
        }
        else if (result.reasons.includes("WillRemoveExistingMerge" /* CommandResult.WillRemoveExistingMerge */)) {
            env.raiseError(PasteInteractiveContent.willRemoveExistingMerge);
        }
        else if (result.reasons.includes("WrongFigurePasteOption" /* CommandResult.WrongFigurePasteOption */)) {
            env.raiseError(PasteInteractiveContent.wrongFigurePasteOption);
        }
        else if (result.reasons.includes("FrozenPaneOverlap" /* CommandResult.FrozenPaneOverlap */)) {
            env.raiseError(PasteInteractiveContent.frozenPaneOverlap);
        }
    }
}
function interactivePaste(env, target, pasteOption) {
    const result = env.model.dispatch("PASTE", { target, pasteOption });
    handlePasteResult(env, result);
}
function interactivePasteFromOS(env, target, clipboardContent, pasteOption) {
    let result;
    // We do not trust the clipboard content to be accurate and comprehensive.
    // Therefore, to ensure reliability, we handle unexpected errors that may
    // arise from content that would not be suitable for the current version.
    try {
        result = env.model.dispatch("PASTE_FROM_OS_CLIPBOARD", {
            target,
            clipboardContent,
            pasteOption,
        });
    }
    catch (error) {
        const parsedSpreadsheetContent = clipboardContent.data;
        if (parsedSpreadsheetContent?.version !== CURRENT_VERSION) {
            env.raiseError(_t("An unexpected error occurred while pasting content.\
          This is probably due to a spreadsheet version mismatch."));
        }
        result = env.model.dispatch("PASTE_FROM_OS_CLIPBOARD", {
            target,
            clipboardContent: {
                text: clipboardContent.text,
            },
            pasteOption,
        });
    }
    handlePasteResult(env, result);
}

const CfTerms = {
    Errors: {
        ["InvalidRange" /* CommandResult.InvalidRange */]: _t("The range is invalid"),
        ["FirstArgMissing" /* CommandResult.FirstArgMissing */]: _t("The argument is missing. Please provide a value"),
        ["SecondArgMissing" /* CommandResult.SecondArgMissing */]: _t("The second argument is missing. Please provide a value"),
        ["MinNaN" /* CommandResult.MinNaN */]: _t("The minpoint must be a number"),
        ["MidNaN" /* CommandResult.MidNaN */]: _t("The midpoint must be a number"),
        ["MaxNaN" /* CommandResult.MaxNaN */]: _t("The maxpoint must be a number"),
        ["ValueUpperInflectionNaN" /* CommandResult.ValueUpperInflectionNaN */]: _t("The first value must be a number"),
        ["ValueLowerInflectionNaN" /* CommandResult.ValueLowerInflectionNaN */]: _t("The second value must be a number"),
        ["MinBiggerThanMax" /* CommandResult.MinBiggerThanMax */]: _t("Minimum must be smaller then Maximum"),
        ["MinBiggerThanMid" /* CommandResult.MinBiggerThanMid */]: _t("Minimum must be smaller then Midpoint"),
        ["MidBiggerThanMax" /* CommandResult.MidBiggerThanMax */]: _t("Midpoint must be smaller then Maximum"),
        ["LowerBiggerThanUpper" /* CommandResult.LowerBiggerThanUpper */]: _t("Lower inflection point must be smaller than upper inflection point"),
        ["MinInvalidFormula" /* CommandResult.MinInvalidFormula */]: _t("Invalid Minpoint formula"),
        ["MaxInvalidFormula" /* CommandResult.MaxInvalidFormula */]: _t("Invalid Maxpoint formula"),
        ["MidInvalidFormula" /* CommandResult.MidInvalidFormula */]: _t("Invalid Midpoint formula"),
        ["ValueUpperInvalidFormula" /* CommandResult.ValueUpperInvalidFormula */]: _t("Invalid upper inflection point formula"),
        ["ValueLowerInvalidFormula" /* CommandResult.ValueLowerInvalidFormula */]: _t("Invalid lower inflection point formula"),
        ["EmptyRange" /* CommandResult.EmptyRange */]: _t("A range needs to be defined"),
        ["ValueCellIsInvalidFormula" /* CommandResult.ValueCellIsInvalidFormula */]: _t("At least one of the provided values is an invalid formula"),
        Unexpected: _t("The rule is invalid for an unknown reason"),
    },
    ColorScale: _t("Color scale"),
    IconSet: _t("Icon set"),
    DataBar: _t("Data bar"),
};
const CellIsOperators = {
    IsEmpty: _t("Is empty"),
    IsNotEmpty: _t("Is not empty"),
    ContainsText: _t("Contains"),
    NotContains: _t("Does not contain"),
    BeginsWith: _t("Starts with"),
    EndsWith: _t("Ends with"),
    Equal: _t("Is equal to"),
    NotEqual: _t("Is not equal to"),
    GreaterThan: _t("Is greater than"),
    GreaterThanOrEqual: _t("Is greater than or equal to"),
    LessThan: _t("Is less than"),
    LessThanOrEqual: _t("Is less than or equal to"),
    Between: _t("Is between"),
    NotBetween: _t("Is not between"),
};
const ChartTerms = {
    Series: _t("Series"),
    BackgroundColor: _t("Background color"),
    StackedBarChart: _t("Stacked bar chart"),
    StackedLineChart: _t("Stacked line chart"),
    StackedAreaChart: _t("Stacked area chart"),
    StackedColumnChart: _t("Stacked column chart"),
    CumulativeData: _t("Cumulative data"),
    TreatLabelsAsText: _t("Treat labels as text"),
    AggregatedChart: _t("Aggregate"),
    Errors: {
        Unexpected: _t("The chart definition is invalid for an unknown reason"),
        // BASIC CHART ERRORS (LINE | BAR | PIE)
        ["InvalidDataSet" /* CommandResult.InvalidDataSet */]: _t("The dataset is invalid"),
        ["InvalidLabelRange" /* CommandResult.InvalidLabelRange */]: _t("Labels are invalid"),
        // SCORECARD CHART ERRORS
        ["InvalidScorecardKeyValue" /* CommandResult.InvalidScorecardKeyValue */]: _t("The key value is invalid"),
        ["InvalidScorecardBaseline" /* CommandResult.InvalidScorecardBaseline */]: _t("The baseline value is invalid"),
        // GAUGE CHART ERRORS
        ["InvalidGaugeDataRange" /* CommandResult.InvalidGaugeDataRange */]: _t("The data range is invalid"),
        ["EmptyGaugeRangeMin" /* CommandResult.EmptyGaugeRangeMin */]: _t("A minimum range limit value is needed"),
        ["GaugeRangeMinNaN" /* CommandResult.GaugeRangeMinNaN */]: _t("The minimum range limit value must be a number"),
        ["EmptyGaugeRangeMax" /* CommandResult.EmptyGaugeRangeMax */]: _t("A maximum range limit value is needed"),
        ["GaugeRangeMaxNaN" /* CommandResult.GaugeRangeMaxNaN */]: _t("The maximum range limit value must be a number"),
        ["GaugeRangeMinBiggerThanRangeMax" /* CommandResult.GaugeRangeMinBiggerThanRangeMax */]: _t("Minimum range limit must be smaller than maximum range limit"),
        ["GaugeLowerInflectionPointNaN" /* CommandResult.GaugeLowerInflectionPointNaN */]: _t("The lower inflection point value must be a number"),
        ["GaugeUpperInflectionPointNaN" /* CommandResult.GaugeUpperInflectionPointNaN */]: _t("The upper inflection point value must be a number"),
    },
};
const CustomCurrencyTerms = {
    Custom: _t("Custom"),
};
const MergeErrorMessage = _t("Merged cells are preventing this operation. Unmerge those cells and try again.");
const SplitToColumnsTerms = {
    Errors: {
        Unexpected: _t("Cannot split the selection for an unknown reason"),
        ["NoSplitSeparatorInSelection" /* CommandResult.NoSplitSeparatorInSelection */]: _t("There is no match for the selected separator in the selection"),
        ["MoreThanOneColumnSelected" /* CommandResult.MoreThanOneColumnSelected */]: _t("Only a selection from a single column can be split"),
        ["SplitWillOverwriteContent" /* CommandResult.SplitWillOverwriteContent */]: _t("Splitting will overwrite existing content"),
    },
};
const RemoveDuplicateTerms = {
    Errors: {
        Unexpected: _t("Cannot remove duplicates for an unknown reason"),
        ["MoreThanOneRangeSelected" /* CommandResult.MoreThanOneRangeSelected */]: _t("Please select only one range of cells"),
        ["EmptyTarget" /* CommandResult.EmptyTarget */]: _t("Please select a range of cells containing values."),
        ["NoColumnsProvided" /* CommandResult.NoColumnsProvided */]: _t("Please select at latest one column to analyze."),
        //TODO: Remove it when accept to copy and paste merge cells
        ["WillRemoveExistingMerge" /* CommandResult.WillRemoveExistingMerge */]: PasteInteractiveContent.willRemoveExistingMerge,
    },
};
const DVTerms = {
    DateIs: {
        today: _t("today"),
        yesterday: _t("yesterday"),
        tomorrow: _t("tomorrow"),
        lastWeek: _t("in the past week"),
        lastMonth: _t("in the past month"),
        lastYear: _t("in the past year"),
    },
    DateIsBefore: {
        today: _t("today"),
        yesterday: _t("yesterday"),
        tomorrow: _t("tomorrow"),
        lastWeek: _t("one week ago"),
        lastMonth: _t("one month ago"),
        lastYear: _t("one year ago"),
    },
    CriterionError: {
        notEmptyValue: _t("The value must not be empty"),
        numberValue: _t("The value must be a number"),
        dateValue: _t("The value must be a date"),
        validRange: _t("The value must be a valid range"),
    },
};
const TableTerms = {
    Errors: {
        Unexpected: _t("The table zone is invalid for an unknown reason"),
        ["TableOverlap" /* CommandResult.TableOverlap */]: _t("You cannot create overlapping tables."),
        ["NonContinuousTargets" /* CommandResult.NonContinuousTargets */]: _t("A table can only be created on a continuous selection."),
        ["InvalidRange" /* CommandResult.InvalidRange */]: _t("The range is invalid"),
        ["TargetOutOfSheet" /* CommandResult.TargetOutOfSheet */]: _t("The range is out of the sheet"),
    },
    Checkboxes: {
        hasFilters: _t("Filter button"),
        headerRow: _t("Header row(s)"),
        bandedRows: _t("Banded rows"),
        firstColumn: _t("First column"),
        lastColumn: _t("Last column"),
        bandedColumns: _t("Banded columns"),
        automaticAutofill: _t("Automatically autofill formulas"),
        totalRow: _t("Total row"),
        isDynamic: _t("Auto-adjust to formula result"),
    },
    Tooltips: {
        filterWithoutHeader: _t("Cannot have filters without a header row"),
        isDynamic: _t("For tables based on array formulas only"),
    },
};
const measureDisplayTerms = {
    labels: {
        no_calculations: _t("No calculations"),
        "%_of_grand_total": _t("% of grand total"),
        "%_of_col_total": _t("% of column total"),
        "%_of_row_total": _t("% of row total"),
        "%_of": _t("% of"),
        "%_of_parent_row_total": _t("% of parent row total"),
        "%_of_parent_col_total": _t("% of parent column total"),
        "%_of_parent_total": _t("% of parent total"),
        difference_from: _t("Difference from"),
        "%_difference_from": _t("% difference from"),
        running_total: _t("Running total"),
        "%_running_total": _t("% Running total"),
        rank_asc: _t("Rank smallest to largest"),
        rank_desc: _t("Rank largest to smallest"),
        index: _t("Index"),
    },
    descriptions: {
        "%_of_grand_total": () => _t("Displayed as % of grand total"),
        "%_of_col_total": () => _t("Displayed as % of column total"),
        "%_of_row_total": () => _t("Displayed as % of row total"),
        "%_of": (field) => _t('Displayed as % of "%s"', field),
        "%_of_parent_row_total": (field) => _t('Displayed as % of parent row total of "%s"', field),
        "%_of_parent_col_total": () => _t("Displayed as % of parent column total"),
        "%_of_parent_total": (field) => _t('Displayed as % of parent "%s" total', field),
        difference_from: (field) => _t('Displayed as difference from "%s"', field),
        "%_difference_from": (field) => _t('Displayed as % difference from "%s"', field),
        running_total: (field) => _t('Displayed as running total based on "%s"', field),
        "%_running_total": (field) => _t('Displayed as % running total based on "%s"', field),
        rank_asc: (field) => _t('Displayed as rank from smallest to largest based on "%s"', field),
        rank_desc: (field) => _t('Displayed as rank largest to smallest based on "%s"', field),
        index: () => _t("Displayed as index"),
    },
    documentation: {
        no_calculations: _t("Displays the value that is entered in the field."),
        "%_of_grand_total": _t("Displays values as a percentage of the grand total of all the values or data points in the report."),
        "%_of_col_total": _t("Displays all the values in each column or series as a percentage of the total for the column or series."),
        "%_of_row_total": _t("Displays the value in each row or category as a percentage of the total for the row or category."),
        "%_of": _t("Displays values as a percentage of the value of the Base item in the Base field."),
        "%_of_parent_row_total": _t("Calculates values as follows:\n(value for the item) / (value for the parent item on rows)"),
        "%_of_parent_col_total": _t("Calculates values as follows:\n(value for the item) / (value for the parent item on columns)"),
        "%_of_parent_total": _t("Calculates values as follows:\n(value for the item) / (value for the parent item of the selected Base field)"),
        difference_from: _t("Displays values as the difference from the value of the Base item in the Base field."),
        "%_difference_from": _t("Displays values as the percentage difference from the value of the Base item in the Base field."),
        running_total: _t("Displays the value for successive items in the Base field as a running total."),
        "%_running_total": _t("Calculates the value as a percentage for successive items in the Base field that are displayed as a running total."),
        rank_asc: _t("Displays the rank of selected values in a specific field, listing the smallest item in the field as 1, and each larger value with a higher rank value."),
        rank_desc: _t("Displays the rank of selected values in a specific field, listing the largest item in the field as 1, and each smaller value with a higher rank value."),
        index: _t("Calculates values as follows:\n((value in cell) x (Grand Total of Grand Totals)) / ((Grand Row Total) x (Grand Column Total))"),
    },
};

const GAUGE_PADDING_SIDE = 30;
const GAUGE_PADDING_TOP = 10;
const GAUGE_PADDING_BOTTOM = 20;
const GAUGE_LABELS_FONT_SIZE = 12;
const GAUGE_DEFAULT_VALUE_FONT_SIZE = 80;
const GAUGE_BACKGROUND_COLOR = "#F3F2F1";
const GAUGE_TEXT_COLOR = "#666666";
const GAUGE_TEXT_COLOR_HIGH_CONTRAST = "#C8C8C8";
const GAUGE_INFLECTION_MARKER_COLOR = "#666666aa";
const GAUGE_INFLECTION_LABEL_BOTTOM_MARGIN = 6;
const GAUGE_TITLE_SECTION_HEIGHT = 25;
const GAUGE_TITLE_FONT_SIZE = SCORECARD_GAUGE_CHART_FONT_SIZE;
const GAUGE_TITLE_PADDING_LEFT = SCORECARD_GAUGE_CHART_PADDING;
const GAUGE_TITLE_PADDING_TOP = SCORECARD_GAUGE_CHART_PADDING;
function drawGaugeChart(canvas, runtime) {
    const canvasBoundingRect = canvas.getBoundingClientRect();
    canvas.width = canvasBoundingRect.width;
    canvas.height = canvasBoundingRect.height;
    const ctx = canvas.getContext("2d");
    const config = getGaugeRenderingConfig(canvasBoundingRect, runtime, ctx);
    drawBackground(ctx, config);
    drawGauge(ctx, config);
    drawInflectionValues(ctx, config);
    drawLabels(ctx, config);
    drawTitle(ctx, config);
}
function drawGauge(ctx, config) {
    ctx.save();
    const gauge = config.gauge;
    const arcCenterX = gauge.rect.x + gauge.rect.width / 2;
    const arcCenterY = gauge.rect.y + gauge.rect.height;
    const arcRadius = gauge.rect.height - gauge.arcWidth / 2;
    if (arcRadius < 0) {
        return;
    }
    const gaugeAngle = gauge.percentage === 1 ? 0 : Math.PI * (1 + gauge.percentage);
    // Gauge background
    ctx.strokeStyle = GAUGE_BACKGROUND_COLOR;
    ctx.beginPath();
    ctx.lineWidth = gauge.arcWidth;
    ctx.arc(arcCenterX, arcCenterY, arcRadius, gaugeAngle, 0);
    ctx.stroke();
    // Gauge value
    ctx.strokeStyle = gauge.color;
    ctx.beginPath();
    ctx.arc(arcCenterX, arcCenterY, arcRadius, Math.PI, gaugeAngle);
    ctx.stroke();
    ctx.restore();
}
function drawBackground(ctx, config) {
    ctx.save();
    ctx.fillStyle = config.backgroundColor;
    ctx.fillRect(0, 0, config.width, config.height);
    ctx.restore();
}
function drawLabels(ctx, config) {
    for (const label of [config.minLabel, config.maxLabel, config.gaugeValue]) {
        ctx.save();
        ctx.textAlign = "center";
        ctx.fillStyle = label.color;
        ctx.font = `${label.fontSize}px ${DEFAULT_FONT}`;
        ctx.fillText(label.label, label.textPosition.x, label.textPosition.y);
        ctx.restore();
    }
}
function drawInflectionValues(ctx, config) {
    const { x: rectX, y: rectY, width, height } = config.gauge.rect;
    for (const inflectionValue of config.inflectionValues) {
        ctx.save();
        ctx.translate(rectX + width / 2 - 0.5, rectY + height - 0.5); // -0.5 for sharper lines. see RendererPlugin.drawBorders comment
        ctx.rotate(Math.PI / 2 - inflectionValue.rotation);
        ctx.lineWidth = 2;
        ctx.strokeStyle = GAUGE_INFLECTION_MARKER_COLOR;
        ctx.beginPath();
        ctx.moveTo(0, -(height - config.gauge.arcWidth));
        ctx.lineTo(0, -height - 3);
        ctx.stroke();
        ctx.textAlign = "center";
        ctx.font = `${inflectionValue.fontSize}px ${DEFAULT_FONT}`;
        ctx.fillStyle = inflectionValue.color;
        const textY = -height - GAUGE_INFLECTION_LABEL_BOTTOM_MARGIN - inflectionValue.offset;
        ctx.fillText(inflectionValue.label, 0, textY);
        ctx.restore();
    }
}
function drawTitle(ctx, config) {
    ctx.save();
    const title = config.title;
    ctx.font = getDefaultContextFont(title.fontSize, title.bold, title.italic);
    ctx.textBaseline = "middle";
    ctx.fillStyle = title.color;
    ctx.fillText(title.label, title.textPosition.x, title.textPosition.y);
    ctx.restore();
}
function getGaugeRenderingConfig(boundingRect, runtime, ctx) {
    const maxValue = runtime.maxValue;
    const minValue = runtime.minValue;
    const gaugeValue = runtime.gaugeValue;
    const gaugeRect = getGaugeRect(boundingRect, runtime.title.text);
    const gaugeArcWidth = gaugeRect.width / 6;
    const gaugePercentage = gaugeValue
        ? (gaugeValue.value - minValue.value) / (maxValue.value - minValue.value)
        : 0;
    const gaugeValuePosition = {
        x: boundingRect.width / 2,
        y: gaugeRect.y + gaugeRect.height - gaugeRect.height / 12,
    };
    let gaugeValueFontSize = GAUGE_DEFAULT_VALUE_FONT_SIZE;
    // Scale down the font size if the gaugeRect is too small
    if (gaugeRect.height < 300) {
        gaugeValueFontSize = gaugeValueFontSize * (gaugeRect.height / 300);
    }
    // Scale down the font size if the text is too long
    const maxTextWidth = gaugeRect.width / 2;
    const gaugeLabel = gaugeValue?.label || "-";
    if (computeTextWidth(ctx, gaugeLabel, { fontSize: gaugeValueFontSize }, "px") > maxTextWidth) {
        gaugeValueFontSize = getFontSizeMatchingWidth(maxTextWidth, gaugeValueFontSize, (fontSize) => computeTextWidth(ctx, gaugeLabel, { fontSize }, "px"));
    }
    const minLabelPosition = {
        x: gaugeRect.x + gaugeArcWidth / 2,
        y: gaugeRect.y + gaugeRect.height + GAUGE_LABELS_FONT_SIZE,
    };
    const maxLabelPosition = {
        x: gaugeRect.x + gaugeRect.width - gaugeArcWidth / 2,
        y: gaugeRect.y + gaugeRect.height + GAUGE_LABELS_FONT_SIZE,
    };
    const textColor = getContrastedTextColor(runtime.background);
    const inflectionValues = getInflectionValues(runtime, gaugeRect, textColor, ctx);
    let x = 0, titleWidth = 0, titleHeight = 0;
    if (runtime.title.text) {
        ({ width: titleWidth, height: titleHeight } = computeTextDimension(ctx, runtime.title.text, { ...runtime.title, fontSize: GAUGE_TITLE_FONT_SIZE }, "px"));
    }
    switch (runtime.title.align) {
        case "right":
            x = boundingRect.width - titleWidth - GAUGE_TITLE_PADDING_LEFT;
            break;
        case "center":
            x = (boundingRect.width - titleWidth) / 2;
            break;
        case "left":
        default:
            x = GAUGE_TITLE_PADDING_LEFT;
            break;
    }
    return {
        width: boundingRect.width,
        height: boundingRect.height,
        title: {
            label: runtime.title.text ?? "",
            fontSize: GAUGE_TITLE_FONT_SIZE,
            textPosition: {
                x,
                y: GAUGE_TITLE_PADDING_TOP + titleHeight / 2,
            },
            color: runtime.title.color ?? textColor,
            bold: runtime.title.bold,
            italic: runtime.title.italic,
        },
        backgroundColor: runtime.background,
        gauge: {
            rect: gaugeRect,
            arcWidth: gaugeArcWidth,
            percentage: clip(gaugePercentage, 0, 1),
            color: getGaugeColor(runtime),
        },
        inflectionValues,
        gaugeValue: {
            label: gaugeLabel,
            textPosition: gaugeValuePosition,
            fontSize: gaugeValueFontSize,
            color: textColor,
        },
        minLabel: {
            label: runtime.minValue.label,
            textPosition: minLabelPosition,
            fontSize: GAUGE_LABELS_FONT_SIZE,
            color: textColor,
        },
        maxLabel: {
            label: runtime.maxValue.label,
            textPosition: maxLabelPosition,
            fontSize: GAUGE_LABELS_FONT_SIZE,
            color: textColor,
        },
    };
}
/**
 * Get the rectangle in which the gauge will be drawn, based on the bounding rectangle of the canvas and leaving
 * space for the title and labels.
 */
function getGaugeRect(boundingRect, title) {
    const titleHeight = title ? GAUGE_TITLE_SECTION_HEIGHT : 0;
    const drawHeight = boundingRect.height - GAUGE_PADDING_BOTTOM - titleHeight - GAUGE_PADDING_TOP;
    const drawWidth = boundingRect.width - GAUGE_PADDING_SIDE * 2;
    let gaugeWidth;
    let gaugeHeight;
    if (drawWidth > 2 * drawHeight) {
        gaugeWidth = 2 * drawHeight;
        gaugeHeight = drawHeight;
    }
    else {
        gaugeWidth = drawWidth;
        gaugeHeight = drawWidth / 2;
    }
    const gaugeX = GAUGE_PADDING_SIDE + (drawWidth - gaugeWidth) / 2;
    const gaugeY = titleHeight + GAUGE_PADDING_TOP + (drawHeight - gaugeHeight) / 2;
    return {
        x: gaugeX,
        y: gaugeY,
        width: gaugeWidth,
        height: gaugeHeight,
    };
}
/**
 * Get the infliction values of the gauge, and where to draw them (the angle from the center of the gauge at which they are drawn).
 *
 * Also compute an offset for the text so that it doesn't overlap with other text.
 */
function getInflectionValues(runtime, gaugeRect, textColor, ctx) {
    const maxValue = runtime.maxValue;
    const minValue = runtime.minValue;
    const gaugeCircleCenter = {
        x: gaugeRect.x + gaugeRect.width / 2,
        y: gaugeRect.y + gaugeRect.height,
    };
    const textStyle = { fontSize: GAUGE_LABELS_FONT_SIZE };
    const inflectionValues = [];
    const inflectionValuesTextRects = [];
    for (const inflectionValue of runtime.inflectionValues) {
        const percentage = (inflectionValue.value - minValue.value) / (maxValue.value - minValue.value);
        const labelWidth = computeTextWidth(ctx, inflectionValue.label, textStyle, "px");
        const angle = Math.PI - Math.PI * percentage;
        const textRect = getRectangleTangentToCircle(angle, // angle between X axis and the point where the rectangle is tangent to the circle
        gaugeRect.height + GAUGE_INFLECTION_LABEL_BOTTOM_MARGIN, // radius of the gauge circle + margin below text
        gaugeCircleCenter.x, // center of the gauge circle
        gaugeCircleCenter.y, // center of the gauge circle
        labelWidth + 2, // width of the text + some margin
        GAUGE_LABELS_FONT_SIZE // height of the text
        );
        let offset = inflectionValuesTextRects.some((rect) => doRectanglesIntersect(rect, textRect))
            ? GAUGE_LABELS_FONT_SIZE
            : 0;
        inflectionValuesTextRects.push(textRect);
        inflectionValues.push({
            rotation: angle,
            label: inflectionValue.label,
            fontSize: GAUGE_LABELS_FONT_SIZE,
            color: textColor,
            offset,
        });
    }
    return inflectionValues;
}
function getGaugeColor(runtime) {
    const gaugeValue = runtime.gaugeValue?.value;
    if (gaugeValue === undefined) {
        return GAUGE_BACKGROUND_COLOR;
    }
    for (let i = 0; i < runtime.inflectionValues.length; i++) {
        const inflectionValue = runtime.inflectionValues[i];
        if (inflectionValue.operator === "<" && gaugeValue < inflectionValue.value) {
            return runtime.colors[i];
        }
        else if (inflectionValue.operator === "<=" && gaugeValue <= inflectionValue.value) {
            return runtime.colors[i];
        }
    }
    return runtime.colors.at(-1);
}
function getContrastedTextColor(backgroundColor) {
    return relativeLuminance(backgroundColor) > 0.3
        ? GAUGE_TEXT_COLOR
        : GAUGE_TEXT_COLOR_HIGH_CONTRAST;
}
function getSegmentsOfRectangle(rectangle) {
    return [
        { start: rectangle.topLeft, end: rectangle.topRight },
        { start: rectangle.topRight, end: rectangle.bottomRight },
        { start: rectangle.bottomRight, end: rectangle.bottomLeft },
        { start: rectangle.bottomLeft, end: rectangle.topLeft },
    ];
}
/**
 * Check if two segment intersect. The case where the segments are colinear (both segments on the same line)
 * is not handled.
 */
function doSegmentIntersect(segment1, segment2) {
    const A = segment1.start;
    const B = segment1.end;
    const C = segment2.start;
    const D = segment2.end;
    /**
     * Line segment intersection algorithm
     * https://bryceboe.com/2006/10/23/line-segment-intersection-algorithm/
     */
    function ccw(a, b, c) {
        return (c.y - a.y) * (b.x - a.x) > (b.y - a.y) * (c.x - a.x);
    }
    return ccw(A, C, D) !== ccw(B, C, D) && ccw(A, B, C) !== ccw(A, B, D);
}
function doRectanglesIntersect(rect1, rect2) {
    const segments1 = getSegmentsOfRectangle(rect1);
    const segments2 = getSegmentsOfRectangle(rect2);
    for (const segment1 of segments1) {
        for (const segment2 of segments2) {
            if (doSegmentIntersect(segment1, segment2)) {
                return true;
            }
        }
    }
    return false;
}
/**
 *  Get the rectangle that is tangent to a circle at a given angle.
 *
 * @param angle angle between X axis and the point where the rectangle is tangent to the circle
 */
function getRectangleTangentToCircle(angle, radius, circleCenterX, circleCenterY, rectWidth, rectHeight) {
    const cos = Math.cos(angle);
    const sin = Math.sin(angle);
    // x, y are the distance from the center of the circle to the point where the rectangle is tangent to the circle
    const x = cos * radius;
    const y = sin * radius;
    // x2, y2 are the distance from the point the rectangle is tangent to the circle to the bottom left corner of the rectangle
    const x2 = sin * (rectWidth / 2); // cos(angle + 90°) = sin(angle)
    const y2 = cos * (rectWidth / 2);
    const bottomRight = {
        x: x + x2 + circleCenterX,
        y: circleCenterY - (y - y2),
    };
    const bottomLeft = {
        x: x - x2 + circleCenterX,
        y: circleCenterY - (y + y2),
    };
    // Same as above but for the top corners of the rectangle (radius + rectangle height instead of radius)
    const xp = cos * (radius + rectHeight);
    const yp = sin * (radius + rectHeight);
    const topLeft = {
        x: xp - x2 + circleCenterX,
        y: circleCenterY - (yp + y2),
    };
    const topRight = {
        x: xp + x2 + circleCenterX,
        y: circleCenterY - (yp - y2),
    };
    return { bottomLeft, bottomRight, topRight, topLeft };
}

/**
 * AbstractChart is the class from which every Chart should inherit.
 * The role of this class is to maintain the state of each chart.
 */
class AbstractChart {
    sheetId;
    title;
    getters;
    constructor(definition, sheetId, getters) {
        this.title = definition.title;
        this.sheetId = sheetId;
        this.getters = getters;
    }
    /**
     * Validate the chart definition given as arguments. This function will be
     * called from allowDispatch function
     */
    static validateChartDefinition(validator, definition) {
        throw new Error("This method should be implemented by sub class");
    }
    /**
     * Get a new chart definition transformed with the executed command. This
     * functions will be called during operational transform process
     */
    static transformDefinition(definition, executed) {
        throw new Error("This method should be implemented by sub class");
    }
    /**
     * Get an empty definition based on the given context
     */
    static getDefinitionFromContextCreation(context) {
        throw new Error("This method should be implemented by sub class");
    }
}

function getBaselineText(baseline, keyValue, baselineMode, humanize, locale) {
    if (!baseline) {
        return "";
    }
    else if (baselineMode === "text" ||
        keyValue?.type !== CellValueType.number ||
        baseline.type !== CellValueType.number) {
        if (humanize) {
            return humanizeNumber(baseline, locale);
        }
        return baseline.formattedValue;
    }
    let { value, format } = baseline;
    if (baselineMode === "progress") {
        value = keyValue.value / value;
        format = "0.0%";
    }
    else {
        value = Math.abs(keyValue.value - value);
        if (baselineMode === "percentage" && value !== 0) {
            value = value / baseline.value;
        }
        if (baselineMode === "percentage") {
            format = "0.0%";
        }
        if (!format) {
            value = Math.round(value * 100) / 100;
        }
    }
    if (humanize) {
        return humanizeNumber({ value, format }, locale);
    }
    return formatValue(value, { format, locale });
}
function getKeyValueText(keyValueCell, humanize, locale) {
    if (!keyValueCell) {
        return "";
    }
    if (humanize) {
        return humanizeNumber(keyValueCell, locale);
    }
    return keyValueCell.formattedValue ?? String(keyValueCell.value ?? "");
}
function getBaselineColor(baseline, baselineMode, keyValue, colorUp, colorDown) {
    if (baselineMode === "text" ||
        baselineMode === "progress" ||
        baseline?.type !== CellValueType.number ||
        keyValue?.type !== CellValueType.number) {
        return undefined;
    }
    const diff = keyValue.value - baseline.value;
    if (diff > 0) {
        return colorUp;
    }
    else if (diff < 0) {
        return colorDown;
    }
    return undefined;
}
function getBaselineArrowDirection(baseline, keyValue, baselineMode) {
    if (baselineMode === "text" ||
        baseline?.type !== CellValueType.number ||
        keyValue?.type !== CellValueType.number) {
        return "neutral";
    }
    const diff = keyValue.value - baseline.value;
    if (diff > 0) {
        return "up";
    }
    else if (diff < 0) {
        return "down";
    }
    return "neutral";
}
function checkKeyValue(definition) {
    return definition.keyValue && !rangeReference.test(definition.keyValue)
        ? "InvalidScorecardKeyValue" /* CommandResult.InvalidScorecardKeyValue */
        : "Success" /* CommandResult.Success */;
}
function checkBaseline(definition) {
    return definition.baseline && !rangeReference.test(definition.baseline)
        ? "InvalidScorecardBaseline" /* CommandResult.InvalidScorecardBaseline */
        : "Success" /* CommandResult.Success */;
}
const arrowDownPath = new window.Path2D("M8.6 4.8a.5.5 0 0 1 0 .75l-3.9 3.9a.5 .5 0 0 1 -.75 0l-3.8 -3.9a.5 .5 0 0 1 0 -.75l.4-.4a.5.5 0 0 1 .75 0l2.3 2.4v-5.7c0-.25.25-.5.5-.5h.6c.25 0 .5.25.5.5v5.8l2.3 -2.4a.5.5 0 0 1 .75 0z");
const arrowUpPath = new window.Path2D("M8.7 5.5a.5.5 0 0 0 0-.75l-3.8-4a.5.5 0 0 0-.75 0l-3.8 4a.5.5 0 0 0 0 .75l.4.4a.5.5 0 0 0 .75 0l2.3-2.4v5.8c0 .25.25.5.5.5h.6c.25 0 .5-.25.5-.5v-5.8l2.2 2.4a.5.5 0 0 0 .75 0z");
let ScorecardChart$1 = class ScorecardChart extends AbstractChart {
    keyValue;
    baseline;
    baselineMode;
    baselineDescr;
    progressBar = false;
    background;
    baselineColorUp;
    baselineColorDown;
    fontColor;
    humanize;
    type = "scorecard";
    constructor(definition, sheetId, getters) {
        super(definition, sheetId, getters);
        this.keyValue = createValidRange(getters, sheetId, definition.keyValue);
        this.baseline = createValidRange(getters, sheetId, definition.baseline);
        this.baselineMode = definition.baselineMode;
        this.baselineDescr = definition.baselineDescr;
        this.background = definition.background;
        this.baselineColorUp = definition.baselineColorUp ?? DEFAULT_SCORECARD_BASELINE_COLOR_UP;
        this.baselineColorDown = definition.baselineColorDown ?? DEFAULT_SCORECARD_BASELINE_COLOR_DOWN;
        this.humanize = definition.humanize ?? false;
    }
    static validateChartDefinition(validator, definition) {
        return validator.checkValidations(definition, checkKeyValue, checkBaseline);
    }
    static getDefinitionFromContextCreation(context) {
        return {
            background: context.background,
            type: "scorecard",
            keyValue: context.range ? context.range[0].dataRange : undefined,
            title: context.title || { text: "" },
            baselineMode: DEFAULT_SCORECARD_BASELINE_MODE,
            baselineColorUp: DEFAULT_SCORECARD_BASELINE_COLOR_UP,
            baselineColorDown: DEFAULT_SCORECARD_BASELINE_COLOR_DOWN,
            baseline: context.auxiliaryRange || "",
        };
    }
    static transformDefinition(definition, executed) {
        let baselineZone;
        let keyValueZone;
        if (definition.baseline) {
            baselineZone = transformZone(toUnboundedZone(definition.baseline), executed);
        }
        if (definition.keyValue) {
            keyValueZone = transformZone(toUnboundedZone(definition.keyValue), executed);
        }
        return {
            ...definition,
            baseline: baselineZone ? zoneToXc(baselineZone) : undefined,
            keyValue: keyValueZone ? zoneToXc(keyValueZone) : undefined,
        };
    }
    copyForSheetId(sheetId) {
        const baseline = copyLabelRangeWithNewSheetId(this.sheetId, sheetId, this.baseline);
        const keyValue = copyLabelRangeWithNewSheetId(this.sheetId, sheetId, this.keyValue);
        const definition = this.getDefinitionWithSpecificRanges(baseline, keyValue, sheetId);
        return new ScorecardChart(definition, sheetId, this.getters);
    }
    copyInSheetId(sheetId) {
        const definition = this.getDefinitionWithSpecificRanges(this.baseline, this.keyValue, sheetId);
        return new ScorecardChart(definition, sheetId, this.getters);
    }
    getDefinition() {
        return this.getDefinitionWithSpecificRanges(this.baseline, this.keyValue);
    }
    getContextCreation() {
        return {
            ...this,
            range: this.keyValue
                ? [{ dataRange: this.getters.getRangeString(this.keyValue, this.sheetId) }]
                : undefined,
            auxiliaryRange: this.baseline
                ? this.getters.getRangeString(this.baseline, this.sheetId)
                : undefined,
        };
    }
    getDefinitionWithSpecificRanges(baseline, keyValue, targetSheetId) {
        return {
            baselineColorDown: this.baselineColorDown,
            baselineColorUp: this.baselineColorUp,
            baselineMode: this.baselineMode,
            title: this.title,
            type: "scorecard",
            background: this.background,
            baseline: baseline
                ? this.getters.getRangeString(baseline, targetSheetId || this.sheetId)
                : undefined,
            baselineDescr: this.baselineDescr,
            keyValue: keyValue
                ? this.getters.getRangeString(keyValue, targetSheetId || this.sheetId)
                : undefined,
            humanize: this.humanize,
        };
    }
    getDefinitionForExcel() {
        // This kind of graph is not exportable in Excel
        return undefined;
    }
    updateRanges(applyChange) {
        const baseline = adaptChartRange(this.baseline, applyChange);
        const keyValue = adaptChartRange(this.keyValue, applyChange);
        if (this.baseline === baseline && this.keyValue === keyValue) {
            return this;
        }
        const definition = this.getDefinitionWithSpecificRanges(baseline, keyValue);
        return new ScorecardChart(definition, this.sheetId, this.getters);
    }
};
function drawScoreChart(structure, canvas) {
    const ctx = canvas.getContext("2d");
    canvas.width = structure.canvas.width;
    const availableWidth = canvas.width - DEFAULT_CHART_PADDING;
    canvas.height = structure.canvas.height;
    ctx.fillStyle = structure.canvas.backgroundColor;
    ctx.fillRect(0, 0, structure.canvas.width, structure.canvas.height);
    if (structure.title) {
        ctx.font = structure.title.style.font;
        ctx.fillStyle = structure.title.style.color;
        const baseline = ctx.textBaseline;
        ctx.textBaseline = "middle";
        ctx.fillText(clipTextWithEllipsis(ctx, structure.title.text, availableWidth - structure.title.position.x), structure.title.position.x, structure.title.position.y);
        ctx.textBaseline = baseline;
    }
    if (structure.baseline) {
        ctx.font = structure.baseline.style.font;
        ctx.fillStyle = structure.baseline.style.color;
        drawDecoratedText(ctx, structure.baseline.text, structure.baseline.position, structure.baseline.style.underline, structure.baseline.style.strikethrough);
    }
    if (structure.baselineArrow && structure.baselineArrow.style.size > 0) {
        ctx.save();
        ctx.fillStyle = structure.baselineArrow.style.color;
        ctx.translate(structure.baselineArrow.position.x, structure.baselineArrow.position.y);
        // This ratio is computed according to the original svg size and the final size we want
        const ratio = structure.baselineArrow.style.size / 10;
        ctx.scale(ratio, ratio);
        switch (structure.baselineArrow.direction) {
            case "down": {
                ctx.fill(arrowDownPath);
                break;
            }
            case "up": {
                ctx.fill(arrowUpPath);
                break;
            }
        }
        ctx.restore();
    }
    if (structure.baselineDescr) {
        const descr = structure.baselineDescr[0];
        ctx.font = descr.style.font;
        ctx.fillStyle = descr.style.color;
        for (const description of structure.baselineDescr) {
            ctx.fillText(clipTextWithEllipsis(ctx, description.text, availableWidth - description.position.x), description.position.x, description.position.y);
        }
    }
    if (structure.key) {
        ctx.font = structure.key.style.font;
        ctx.fillStyle = structure.key.style.color;
        drawDecoratedText(ctx, clipTextWithEllipsis(ctx, structure.key.text, availableWidth - structure.key.position.x), structure.key.position, structure.key.style.underline, structure.key.style.strikethrough);
    }
    if (structure.progressBar) {
        ctx.fillStyle = structure.progressBar.style.backgroundColor;
        ctx.beginPath();
        ctx.roundRect(structure.progressBar.position.x, structure.progressBar.position.y, structure.progressBar.dimension.width, structure.progressBar.dimension.height, structure.progressBar.dimension.height / 2);
        ctx.fill();
        ctx.fillStyle = structure.progressBar.style.color;
        ctx.beginPath();
        if (structure.progressBar.value > 0) {
            ctx.roundRect(structure.progressBar.position.x, structure.progressBar.position.y, structure.progressBar.dimension.width *
                Math.max(0, Math.min(1.0, structure.progressBar.value)), structure.progressBar.dimension.height, structure.progressBar.dimension.height / 2);
        }
        else {
            const width = structure.progressBar.dimension.width *
                Math.max(0, Math.min(1.0, -structure.progressBar.value));
            ctx.roundRect(structure.progressBar.position.x + structure.progressBar.dimension.width - width, structure.progressBar.position.y, width, structure.progressBar.dimension.height, structure.progressBar.dimension.height / 2);
        }
        ctx.fill();
    }
}
function createScorecardChartRuntime(chart, getters) {
    let formattedKeyValue = "";
    let keyValueCell;
    const locale = getters.getLocale();
    if (chart.keyValue) {
        const keyValuePosition = {
            sheetId: chart.keyValue.sheetId,
            col: chart.keyValue.zone.left,
            row: chart.keyValue.zone.top,
        };
        keyValueCell = getters.getEvaluatedCell(keyValuePosition);
        formattedKeyValue = getKeyValueText(keyValueCell, chart.humanize ?? false, locale);
    }
    let baselineCell;
    const baseline = chart.baseline;
    if (baseline) {
        const baselinePosition = {
            sheetId: baseline.sheetId,
            col: baseline.zone.left,
            row: baseline.zone.top,
        };
        baselineCell = getters.getEvaluatedCell(baselinePosition);
    }
    const { background, fontColor } = getters.getStyleOfSingleCellChart(chart.background, chart.keyValue);
    const baselineDisplay = getBaselineText(baselineCell, keyValueCell, chart.baselineMode, chart.humanize ?? false, locale);
    const baselineValue = chart.baselineMode === "progress" && isNumber(baselineDisplay, locale)
        ? toNumber(baselineDisplay, locale)
        : 0;
    return {
        title: {
            ...chart.title,
            // chart titles are extracted from .json files and they are translated at runtime here
            text: chart.title.text ? _t(chart.title.text) : "",
        },
        keyValue: formattedKeyValue,
        baselineDisplay,
        baselineArrow: getBaselineArrowDirection(baselineCell, keyValueCell, chart.baselineMode),
        baselineColor: getBaselineColor(baselineCell, chart.baselineMode, keyValueCell, chart.baselineColorUp, chart.baselineColorDown),
        baselineDescr: chart.baselineMode !== "progress" && chart.baselineDescr
            ? _t(chart.baselineDescr) // descriptions are extracted from .json files and they are translated at runtime here
            : "",
        fontColor,
        background,
        baselineStyle: chart.baselineMode !== "percentage" && chart.baselineMode !== "progress" && baseline
            ? getters.getCellStyle({
                sheetId: baseline.sheetId,
                col: baseline.zone.left,
                row: baseline.zone.top,
            })
            : undefined,
        keyValueStyle: chart.keyValue
            ? getters.getCellStyle({
                sheetId: chart.keyValue.sheetId,
                col: chart.keyValue.zone.left,
                row: chart.keyValue.zone.top,
            })
            : undefined,
        progressBar: chart.baselineMode === "progress"
            ? {
                value: baselineValue,
                color: baselineValue > 0 ? chart.baselineColorUp : chart.baselineColorDown,
            }
            : undefined,
    };
}

/* Padding at the border of the chart */
const CHART_PADDING = SCORECARD_GAUGE_CHART_PADDING;
const BOTTOM_PADDING_RATIO = 0.05;
/* Maximum font sizes of each element */
const CHART_TITLE_FONT_SIZE = SCORECARD_GAUGE_CHART_FONT_SIZE;
const KEY_VALUE_FONT_SIZE = 32;
const BASELINE_MAX_FONT_SIZE = 16;
function formatBaselineDescr(baselineDescr, baseline) {
    const _baselineDescr = baselineDescr || "";
    return baseline && _baselineDescr ? " " + _baselineDescr : _baselineDescr;
}
function getScorecardConfiguration({ width, height }, runtime) {
    const designer = new ScorecardChartConfigBuilder({ width, height }, runtime);
    return designer.computeDesign();
}
class ScorecardChartConfigBuilder {
    runtime;
    context;
    width;
    height;
    constructor({ width, height }, runtime) {
        this.runtime = runtime;
        const canvas = document.createElement("canvas");
        this.width = canvas.width = width;
        this.height = canvas.height = height;
        this.context = canvas.getContext("2d");
    }
    computeDesign() {
        const structure = {
            canvas: {
                width: this.width,
                height: this.height,
                backgroundColor: this.backgroundColor,
            },
        };
        const style = this.getTextStyles();
        let titleHeight = 0;
        if (this.title) {
            let x, titleWidth;
            ({ height: titleHeight, width: titleWidth } = this.getFullTextDimensions(this.title, style.title.font));
            switch (this.runtime.title.align) {
                case "center":
                    x = (this.width - titleWidth) / 2;
                    break;
                case "right":
                    x = this.width - titleWidth - CHART_PADDING;
                    break;
                case "left":
                default:
                    x = CHART_PADDING;
            }
            structure.title = {
                text: this.title,
                style: style.title,
                position: {
                    x,
                    y: CHART_PADDING + titleHeight / 2,
                },
            };
        }
        const baselineArrowSize = style.baselineArrow?.size ?? 0;
        let { height: baselineHeight, width: baselineWidth } = this.getTextDimensions(this.baseline, style.baselineValue.font);
        if (!this.baseline) {
            baselineHeight = this.getTextDimensions(this.baselineDescr, style.baselineDescr.font).height;
        }
        const baselineDescrWidth = this.getTextDimensions(this.baselineDescr, style.baselineDescr.font).width;
        structure.baseline = {
            text: this.baseline,
            style: style.baselineValue,
            position: {
                x: (this.width - baselineWidth - baselineDescrWidth + baselineArrowSize) / 2,
                y: this.keyValue
                    ? this.height * (1 - BOTTOM_PADDING_RATIO * (this.runtime.progressBar ? 1 : 2))
                    : this.height - (this.height - titleHeight - baselineHeight) / 2 - CHART_PADDING,
            },
        };
        const minimalBaselinePosition = baselineArrowSize + DEFAULT_CHART_PADDING;
        if (structure.baseline.position.x < minimalBaselinePosition) {
            structure.baseline.position.x = minimalBaselinePosition;
        }
        if (style.baselineArrow && !this.runtime.progressBar) {
            structure.baselineArrow = {
                direction: this.baselineArrow,
                style: style.baselineArrow,
                position: {
                    x: structure.baseline.position.x - baselineArrowSize,
                    y: structure.baseline.position.y - (baselineHeight + baselineArrowSize) / 2,
                },
            };
        }
        if (this.baselineDescr) {
            const position = {
                x: structure.baseline.position.x + baselineWidth,
                y: structure.baseline.position.y,
            };
            structure.baselineDescr = [
                {
                    text: this.baselineDescr,
                    style: style.baselineDescr,
                    position,
                },
            ];
        }
        let progressBarHeight = 0;
        if (this.runtime.progressBar) {
            progressBarHeight = this.height * 0.05;
            structure.progressBar = {
                position: {
                    x: 2 * CHART_PADDING,
                    y: this.height * (1 - 2 * BOTTOM_PADDING_RATIO) - baselineHeight - progressBarHeight,
                },
                dimension: {
                    height: progressBarHeight,
                    width: this.width - 4 * CHART_PADDING,
                },
                value: this.runtime.progressBar.value,
                style: {
                    color: this.runtime.progressBar.color,
                    backgroundColor: this.secondaryFontColor,
                },
            };
        }
        const { width: keyWidth, height: keyHeight } = this.getFullTextDimensions(this.keyValue, style.keyValue.font);
        if (this.keyValue) {
            structure.key = {
                text: this.keyValue,
                style: style.keyValue,
                position: {
                    x: Math.max(CHART_PADDING, (this.width - keyWidth) / 2),
                    y: this.height * (0.5 - BOTTOM_PADDING_RATIO * 2) +
                        CHART_PADDING / 2 +
                        (titleHeight + keyHeight / 2) / 2,
                },
            };
        }
        return structure;
    }
    get title() {
        return this.runtime.title.text ?? "";
    }
    get keyValue() {
        return this.runtime.keyValue;
    }
    get baseline() {
        return this.runtime.baselineDisplay;
    }
    get baselineDescr() {
        return formatBaselineDescr(this.runtime.baselineDescr, this.baseline);
    }
    get baselineArrow() {
        return this.runtime.baselineArrow;
    }
    get backgroundColor() {
        return this.runtime.background;
    }
    get secondaryFontColor() {
        return relativeLuminance(this.backgroundColor) > 0.3 ? "#525252" : "#C8C8C8";
    }
    getTextDimensions(text, font) {
        this.context.font = font;
        const measure = this.context.measureText(text);
        return {
            width: measure.width,
            height: measure.actualBoundingBoxAscent + measure.actualBoundingBoxDescent,
        };
    }
    getFullTextDimensions(text, font) {
        this.context.font = font;
        const measure = this.context.measureText(text);
        return {
            width: measure.width,
            height: measure.fontBoundingBoxAscent + measure.fontBoundingBoxDescent,
        };
    }
    getTextStyles() {
        let baselineValueFontSize = BASELINE_MAX_FONT_SIZE;
        const baselineDescrFontSize = Math.floor(0.9 * baselineValueFontSize);
        if (this.runtime.progressBar) {
            baselineValueFontSize /= 1.5;
        }
        return {
            title: {
                font: getDefaultContextFont(CHART_TITLE_FONT_SIZE, this.runtime.title.bold, this.runtime.title.italic),
                color: this.runtime.title.color ?? this.secondaryFontColor,
            },
            keyValue: {
                color: this.runtime.keyValueStyle?.textColor || this.runtime.fontColor,
                font: getDefaultContextFont(KEY_VALUE_FONT_SIZE, this.runtime.keyValueStyle?.bold, this.runtime.keyValueStyle?.italic),
                strikethrough: this.runtime.keyValueStyle?.strikethrough,
                underline: this.runtime.keyValueStyle?.underline,
            },
            baselineValue: {
                font: getDefaultContextFont(baselineValueFontSize, this.runtime.baselineStyle?.bold, this.runtime.baselineStyle?.italic),
                strikethrough: this.runtime.baselineStyle?.strikethrough,
                underline: this.runtime.baselineStyle?.underline,
                color: this.runtime.baselineStyle?.textColor ||
                    this.runtime.baselineColor ||
                    this.secondaryFontColor,
            },
            baselineDescr: {
                font: getDefaultContextFont(baselineDescrFontSize),
                color: this.secondaryFontColor,
            },
            baselineArrow: this.baselineArrow === "neutral" || this.runtime.progressBar
                ? undefined
                : {
                    size: this.keyValue ? 0.8 * baselineValueFontSize : 0,
                    color: this.runtime.baselineColor || this.secondaryFontColor,
                },
        };
    }
}

/**
 * This file contains helpers that are common to different runtime charts (mainly
 * line, bar and pie charts)
 */
/**
 * Get the data from a dataSet
 */
function getData(getters, ds) {
    if (ds.dataRange) {
        const labelCellZone = ds.labelCell ? [ds.labelCell.zone] : [];
        const dataZone = recomputeZones([ds.dataRange.zone], labelCellZone)[0];
        if (dataZone === undefined) {
            return [];
        }
        const dataRange = getters.getRangeFromZone(ds.dataRange.sheetId, dataZone);
        return getters.getRangeValues(dataRange).map((value) => (value === "" ? undefined : value));
    }
    return [];
}
function filterEmptyDataPoints(labels, datasets) {
    const numberOfDataPoints = Math.max(labels.length, ...datasets.map((dataset) => dataset.data?.length || 0));
    const dataPointsIndexes = range(0, numberOfDataPoints).filter((dataPointIndex) => {
        const label = labels[dataPointIndex];
        const values = datasets.map((dataset) => dataset.data?.[dataPointIndex]);
        return label || values.some((value) => value === 0 || Boolean(value));
    });
    return {
        labels: dataPointsIndexes.map((i) => labels[i] || ""),
        dataSetsValues: datasets.map((dataset) => ({
            ...dataset,
            data: dataPointsIndexes.map((i) => dataset.data[i]),
        })),
    };
}
/**
 * Aggregates data based on labels
 */
function aggregateDataForLabels(labels, datasets) {
    const parseNumber = (value) => (typeof value === "number" ? value : 0);
    const labelSet = new Set(labels);
    const labelMap = {};
    labelSet.forEach((label) => {
        labelMap[label] = new Array(datasets.length).fill(0);
    });
    for (const indexOfLabel of range(0, labels.length)) {
        const label = labels[indexOfLabel];
        for (const indexOfDataset of range(0, datasets.length)) {
            labelMap[label][indexOfDataset] += parseNumber(datasets[indexOfDataset].data[indexOfLabel]);
        }
    }
    return {
        labels: Array.from(labelSet),
        dataSetsValues: datasets.map((dataset, indexOfDataset) => ({
            ...dataset,
            data: Array.from(labelSet).map((label) => labelMap[label][indexOfDataset]),
        })),
    };
}
function truncateLabel(label) {
    if (!label) {
        return "";
    }
    if (label.length > MAX_CHAR_LABEL) {
        return label.substring(0, MAX_CHAR_LABEL) + "…";
    }
    return label;
}
/**
 * Get a default chart js configuration
 */
function getDefaultChartJsRuntime(chart, labels, fontColor, { format, locale, truncateLabels = true, horizontalChart, }) {
    const chartTitle = chart.title.text ? chart.title : { ...chart.title, content: "" };
    const options = {
        // https://www.chartjs.org/docs/latest/general/responsive.html
        responsive: true, // will resize when its container is resized
        maintainAspectRatio: false, // doesn't maintain the aspect ration (width/height =2 by default) so the user has the choice of the exact layout
        layout: {
            padding: {
                left: DEFAULT_CHART_PADDING,
                right: DEFAULT_CHART_PADDING,
                top: chartTitle.text ? DEFAULT_CHART_PADDING / 2 : DEFAULT_CHART_PADDING + 5,
                bottom: DEFAULT_CHART_PADDING,
            },
        },
        elements: {
            line: {
                fill: false, // do not fill the area under line charts
            },
            point: {
                hitRadius: 15, // increased hit radius to display point tooltip when hovering nearby
            },
        },
        animation: false,
        plugins: {
            title: {
                display: !!chartTitle.text,
                text: _t(chartTitle.text),
                color: chartTitle?.color ?? fontColor,
                align: chartTitle.align === "center" ? "center" : chartTitle.align === "right" ? "end" : "start",
                font: {
                    size: DEFAULT_CHART_FONT_SIZE,
                    weight: chartTitle.bold ? "bold" : "normal",
                    style: chartTitle.italic ? "italic" : "normal",
                },
            },
            legend: {
                // Disable default legend onClick (show/hide dataset), to allow us to set a global onClick on the chart container.
                // If we want to re-enable this in the future, we need to override the default onClick to stop the event propagation
                onClick: () => { },
            },
            tooltip: {
                callbacks: {
                    label: function (tooltipItem) {
                        const xLabel = tooltipItem.dataset?.label || tooltipItem.label;
                        // tooltipItem.parsed can be an object or a number for pie charts
                        let yLabel = horizontalChart ? tooltipItem.parsed.x : tooltipItem.parsed.y;
                        if (yLabel === undefined || yLabel === null) {
                            yLabel = tooltipItem.parsed;
                        }
                        const toolTipFormat = !format && Math.abs(yLabel) >= 1000 ? "#,##" : format;
                        const yLabelStr = formatValue(yLabel, { format: toolTipFormat, locale });
                        return xLabel ? `${xLabel}: ${yLabelStr}` : yLabelStr;
                    },
                },
            },
        },
    };
    return {
        type: chart.type,
        options,
        data: {
            labels: truncateLabels ? labels.map(truncateLabel) : labels,
            datasets: [],
        },
        platform: undefined, // This key is optional and will be set by chart.js
        plugins: [],
    };
}
function getChartLabelFormat(getters, range, shouldRemoveFirstLabel) {
    if (!range)
        return undefined;
    const { sheetId, zone } = range;
    const formats = positions(zone).map((position) => getters.getEvaluatedCell({ sheetId, ...position }).format);
    if (shouldRemoveFirstLabel) {
        formats.shift();
    }
    return formats.find((format) => format !== undefined);
}
function getChartLabelValues(getters, dataSets, labelRange) {
    let labels = { values: [], formattedValues: [] };
    if (labelRange) {
        const { left } = labelRange.zone;
        if (!labelRange.invalidXc &&
            !labelRange.invalidSheetName &&
            !getters.isColHidden(labelRange.sheetId, left)) {
            labels = {
                formattedValues: getters.getRangeFormattedValues(labelRange),
                values: getters.getRangeValues(labelRange).map((val) => String(val ?? "")),
            };
        }
        else if (dataSets[0]) {
            const ranges = getData(getters, dataSets[0]);
            labels = {
                formattedValues: range(0, ranges.length).map((r) => r.toString()),
                values: labels.formattedValues,
            };
        }
    }
    else if (dataSets.length === 1) {
        for (let i = 0; i < getData(getters, dataSets[0]).length; i++) {
            labels.formattedValues.push("");
            labels.values.push("");
        }
    }
    else {
        if (dataSets[0]) {
            const ranges = getData(getters, dataSets[0]);
            labels = {
                formattedValues: range(0, ranges.length).map((r) => r.toString()),
                values: labels.formattedValues,
            };
        }
    }
    return labels;
}
/**
 * Get the format to apply to the the dataset values. This format is defined as the first format
 * found in the dataset ranges that isn't a date format.
 */
function getChartDatasetFormat(getters, dataSets) {
    for (const ds of dataSets) {
        const formatsInDataset = getters.getRangeFormats(ds.dataRange);
        const format = formatsInDataset.find((f) => f !== undefined && !isDateTimeFormat(f));
        if (format)
            return format;
    }
    return undefined;
}
function getChartDatasetValues(getters, dataSets) {
    const datasetValues = [];
    for (const [dsIndex, ds] of Object.entries(dataSets)) {
        let label;
        let hidden = getters.isColHidden(ds.dataRange.sheetId, ds.dataRange.zone.left);
        if (ds.labelCell) {
            const labelRange = ds.labelCell;
            const cell = labelRange
                ? getters.getEvaluatedCell({
                    sheetId: labelRange.sheetId,
                    col: labelRange.zone.left,
                    row: labelRange.zone.top,
                })
                : undefined;
            label =
                cell && labelRange
                    ? truncateLabel(cell.formattedValue)
                    : (label = `${ChartTerms.Series} ${parseInt(dsIndex) + 1}`);
        }
        else {
            label = `${ChartTerms.Series} ${parseInt(dsIndex) + 1}`;
        }
        let data = ds.dataRange ? getData(getters, ds) : [];
        if (data.every((e) => typeof e === "string" && !isEvaluationError(e)) &&
            data.some((e) => e !== "")) {
            // In this case, we want a chart based on the string occurrences count
            // This will be done by associating each string with a value of 1 and
            // then using the classical aggregation method to sum the values.
            data.fill(1);
        }
        else if (data.every((cell) => cell === undefined || cell === null || !isNumber(cell.toString(), DEFAULT_LOCALE))) {
            hidden = true;
        }
        datasetValues.push({ data, label, hidden });
    }
    return datasetValues;
}
/**
 * If the chart is a stacked area chart, we want to fill until the next dataset.
 * If the chart is a simple area chart, we want to fill until the origin (bottom axis).
 *
 * See https://www.chartjs.org/docs/latest/charts/area.html#filling-modes
 */
function getFillingMode(index, stackedChart) {
    if (!stackedChart) {
        return "origin";
    }
    return index === 0 ? "origin" : "-1";
}
function chartToImage(runtime, figure, type) {
    // wrap the canvas in a div with a fixed size because chart.js would
    // fill the whole page otherwise
    const div = document.createElement("div");
    div.style.width = `${figure.width}px`;
    div.style.height = `${figure.height}px`;
    const canvas = document.createElement("canvas");
    div.append(canvas);
    canvas.setAttribute("width", figure.width.toString());
    canvas.setAttribute("height", figure.height.toString());
    // we have to add the canvas to the DOM otherwise it won't be rendered
    document.body.append(div);
    if ("chartJsConfig" in runtime) {
        const config = deepCopy(runtime.chartJsConfig);
        config.plugins = [backgroundColorChartJSPlugin];
        const Chart = getChartJSConstructor();
        const chart = new Chart(canvas, config);
        const imgContent = chart.toBase64Image();
        chart.destroy();
        div.remove();
        return imgContent;
    }
    else if (type === "scorecard") {
        const design = getScorecardConfiguration(figure, runtime);
        drawScoreChart(design, canvas);
        const imgContent = canvas.toDataURL();
        div.remove();
        return imgContent;
    }
    else if (type === "gauge") {
        drawGaugeChart(canvas, runtime);
        const imgContent = canvas.toDataURL();
        div.remove();
        return imgContent;
    }
    return undefined;
}
/**
 * Custom chart.js plugin to set the background color of the canvas
 * https://github.com/chartjs/Chart.js/blob/8fdf76f8f02d31684d34704341a5d9217e977491/docs/configuration/canvas-background.md
 */
const backgroundColorChartJSPlugin = {
    id: "customCanvasBackgroundColor",
    beforeDraw: (chart) => {
        const { ctx } = chart;
        ctx.save();
        ctx.globalCompositeOperation = "destination-over";
        ctx.fillStyle = "#ffffff";
        ctx.fillRect(0, 0, chart.width, chart.height);
        ctx.restore();
    },
};
function getChartJsLegend(fontColor, legend = {}) {
    return {
        ...legend,
        labels: {
            color: fontColor,
            filter: (legendItem, data) => {
                return "datasetIndex" in legendItem
                    ? !data.datasets[legendItem.datasetIndex].hidden
                    : true;
            },
            ...legend.labels,
        },
    };
}
/** Return window.Chart, making sure all our extensions are loaded in ChartJS */
function getChartJSConstructor() {
    if (window.Chart && !window.Chart?.registry.plugins.get("chartShowValuesPlugin")) {
        window.Chart.register(chartShowValuesPlugin);
        window.Chart.register(waterfallLinesPlugin);
    }
    return window.Chart;
}

class ChartJsComponent extends Component {
    static template = "o-spreadsheet-ChartJsComponent";
    static props = {
        figure: Object,
    };
    canvas = useRef("graphContainer");
    chart;
    currentRuntime;
    get background() {
        return this.chartRuntime.background;
    }
    get canvasStyle() {
        return `background-color: ${this.background}`;
    }
    get chartRuntime() {
        const runtime = this.env.model.getters.getChartRuntime(this.props.figure.id);
        if (!("chartJsConfig" in runtime)) {
            throw new Error("Unsupported chart runtime");
        }
        return runtime;
    }
    setup() {
        onMounted(() => {
            const runtime = this.chartRuntime;
            this.currentRuntime = runtime;
            // Note: chartJS modify the runtime in place, so it's important to give it a copy
            this.createChart(deepCopy(runtime.chartJsConfig));
        });
        onWillUnmount(() => this.chart?.destroy());
        useEffect(() => {
            const runtime = this.chartRuntime;
            if (runtime !== this.currentRuntime) {
                if (runtime.chartJsConfig.type !== this.currentRuntime.chartJsConfig.type) {
                    this.chart?.destroy();
                    this.createChart(deepCopy(runtime.chartJsConfig));
                }
                else {
                    this.updateChartJs(deepCopy(runtime));
                }
                this.currentRuntime = runtime;
            }
        });
    }
    createChart(chartData) {
        const canvas = this.canvas.el;
        const ctx = canvas.getContext("2d");
        const Chart = getChartJSConstructor();
        this.chart = new Chart(ctx, chartData);
    }
    updateChartJs(chartRuntime) {
        const chartData = chartRuntime.chartJsConfig;
        if (chartData.data && chartData.data.datasets) {
            this.chart.data = chartData.data;
            if (chartData.options?.plugins?.title) {
                this.chart.config.options.plugins.title = chartData.options.plugins.title;
            }
        }
        else {
            this.chart.data.datasets = [];
        }
        this.chart.config.options = chartData.options;
        this.chart.update();
    }
}

class ScorecardChart extends Component {
    static template = "o-spreadsheet-ScorecardChart";
    static props = {
        figure: Object,
    };
    canvas = useRef("chartContainer");
    get runtime() {
        return this.env.model.getters.getChartRuntime(this.props.figure.id);
    }
    get title() {
        const title = this.env.model.getters.getChartDefinition(this.props.figure.id).title.text ?? "";
        // chart titles are extracted from .json files and they are translated at runtime here
        return _t(title);
    }
    setup() {
        useEffect(this.createChart.bind(this), () => {
            const canvas = this.canvas.el;
            const rect = canvas.getBoundingClientRect();
            return [rect.width, rect.height, this.runtime, this.canvas.el];
        });
    }
    createChart() {
        const canvas = this.canvas.el;
        const config = getScorecardConfiguration(canvas.getBoundingClientRect(), this.runtime);
        drawScoreChart(config, canvas);
    }
}

const autoCompleteProviders = new Registry();

autoCompleteProviders.add("dataValidation", {
    displayAllOnInitialContent: true,
    getProposals(tokenAtCursor, content) {
        if (content.startsWith("=")) {
            return [];
        }
        if (!this.composer.currentEditedCell) {
            return [];
        }
        const position = this.composer.currentEditedCell;
        const rule = this.getters.getValidationRuleForCell(position);
        if (!rule ||
            (rule.criterion.type !== "isValueInList" && rule.criterion.type !== "isValueInRange")) {
            return [];
        }
        let values;
        if (rule.criterion.type === "isValueInList") {
            values = rule.criterion.values;
        }
        else {
            const range = this.getters.getRangeFromSheetXC(position.sheetId, rule.criterion.values[0]);
            values = Array.from(new Set(this.getters
                .getRangeValues(range)
                .filter(isNotNull)
                .map((value) => value.toString())
                .filter((val) => val !== "")));
        }
        return values.map((value) => ({ text: value }));
    },
    selectProposal(tokenAtCursor, value) {
        this.composer.setCurrentContent(value);
        this.composer.stopEdition();
    },
});

function getHtmlContentFromPattern(pattern, value, highlightColor, className) {
    const pendingHtmlContent = [];
    pattern = pattern.toLowerCase();
    for (const patternChar of pattern) {
        const index = value.toLocaleLowerCase().indexOf(patternChar);
        if (index === -1) {
            continue;
        }
        pendingHtmlContent.push({ value: value.slice(0, index), color: "" }, { value: value[index], color: highlightColor, class: className });
        value = value.slice(index + 1);
    }
    pendingHtmlContent.push({ value });
    const htmlContent = pendingHtmlContent.filter((content) => content.value);
    return htmlContent;
}

//------------------------------------------------------------------------------
// Arg description DSL
//------------------------------------------------------------------------------
const ARG_REGEXP = /(.*?)\((.*?)\)(.*)/;
const ARG_TYPES = [
    "ANY",
    "BOOLEAN",
    "DATE",
    "NUMBER",
    "STRING",
    "RANGE",
    "RANGE<BOOLEAN>",
    "RANGE<DATE>",
    "RANGE<NUMBER>",
    "RANGE<STRING>",
    "META",
];
function arg(definition, description = "") {
    return makeArg(definition, description);
}
function makeArg(str, description) {
    let parts = str.match(ARG_REGEXP);
    let name = parts[1].trim();
    if (!name) {
        throw new Error(`Function argument definition is missing a name: '${str}'.`);
    }
    let types = [];
    let isOptional = false;
    let isRepeating = false;
    let defaultValue;
    for (let param of parts[2].split(",")) {
        const key = param.trim().toUpperCase();
        let type = ARG_TYPES.find((t) => key === t);
        if (type) {
            types.push(type);
        }
        else if (key === "RANGE<ANY>") {
            types.push("RANGE");
        }
        else if (key === "OPTIONAL") {
            isOptional = true;
        }
        else if (key === "REPEATING") {
            isRepeating = true;
        }
        else if (key.startsWith("DEFAULT=")) {
            defaultValue = param.trim().slice(8);
        }
    }
    const result = {
        name,
        description,
        type: types,
    };
    const acceptErrors = types.includes("ANY") || types.includes("RANGE");
    if (acceptErrors) {
        result.acceptErrors = true;
    }
    if (isOptional) {
        result.optional = true;
    }
    if (isRepeating) {
        result.repeating = true;
    }
    if (defaultValue !== undefined) {
        result.default = true;
        result.defaultValue = defaultValue;
    }
    if (types.some((t) => t.startsWith("RANGE"))) {
        result.acceptMatrix = true;
    }
    if (types.every((t) => t.startsWith("RANGE"))) {
        result.acceptMatrixOnly = true;
    }
    return result;
}
/**
 * This function adds on description more general information derived from the
 * arguments.
 *
 * This information is useful during compilation.
 */
function addMetaInfoFromArg(addDescr) {
    let countArg = 0;
    let minArg = 0;
    let repeatingArg = 0;
    for (let arg of addDescr.args) {
        countArg++;
        if (!arg.optional && !arg.repeating && !arg.default) {
            minArg++;
        }
        if (arg.repeating) {
            repeatingArg++;
        }
    }
    const descr = addDescr;
    descr.minArgRequired = minArg;
    descr.maxArgPossible = repeatingArg ? Infinity : countArg;
    descr.nbrArgRepeating = repeatingArg;
    descr.getArgToFocus = argTargeting(countArg, repeatingArg);
    descr.hidden = addDescr.hidden || false;
    return descr;
}
/**
 * Returns a function allowing finding which argument corresponds a position
 * in a function. This is particularly useful for functions with repeatable
 * arguments.
 *
 * Indeed the function makes it possible to etablish corespondance between
 * arguments when the number of arguments supplied is greater than the number of
 * arguments defined by the function.
 *
 * Ex:
 *
 * in the formula "=SUM(11, 55, 66)" which is defined like this "SUM(value1, [value2, ...])"
 * - 11 corresponds to the value1 argument => position will be 1
 * - 55 corresponds to the [value2, ...] argument => position will be 2
 * - 66 corresponds to the [value2, ...] argument => position will be 2
 *
 * in the formula "=AVERAGE.WEIGHTED(1, 2, 3, 4, 5, 6)" which is defined like this
 * "AVERAGE.WEIGHTED(values, weights, [additional_values, ...], [additional_weights, ...])"
 * - 1 corresponds to the values argument => position will be 1
 * - 2 corresponds to the weights argument => position will be 2
 * - 3 corresponds to the [additional_values, ...] argument => position will be 3
 * - 4 corresponds to the [additional_weights, ...] argument => position will be 4
 * - 5 corresponds to the [additional_values, ...] argument => position will be 3
 * - 6 corresponds to the [additional_weights, ...] argument => position will be 4
 */
function argTargeting(countArg, repeatingArg) {
    if (!repeatingArg) {
        return (argPosition) => argPosition;
    }
    if (repeatingArg === 1) {
        return (argPosition) => Math.min(argPosition, countArg);
    }
    const argBeforeRepeat = countArg - repeatingArg;
    return (argPosition) => {
        if (argPosition <= argBeforeRepeat) {
            return argPosition;
        }
        const argAfterRepeat = (argPosition - argBeforeRepeat) % repeatingArg || repeatingArg;
        return argBeforeRepeat + argAfterRepeat;
    };
}
//------------------------------------------------------------------------------
// Argument validation
//------------------------------------------------------------------------------
function validateArguments(args) {
    let previousArgRepeating = false;
    let previousArgOptional = false;
    let previousArgDefault = false;
    for (let current of args) {
        if (current.type.includes("META") && current.type.length > 1) {
            throw new Error(_t("Function ${name} has an argument that has been declared with more than one type whose type 'META'. The 'META' type can only be declared alone."));
        }
        if (previousArgRepeating && !current.repeating) {
            throw new Error(_t("Function ${name} has no-repeatable arguments declared after repeatable ones. All repeatable arguments must be declared last."));
        }
        const previousIsOptional = previousArgOptional || previousArgRepeating || previousArgDefault;
        const currentIsntOptional = !(current.optional || current.repeating || current.default);
        if (previousIsOptional && currentIsntOptional) {
            throw new Error(_t("Function ${name} has at mandatory arguments declared after optional ones. All optional arguments must be after all mandatory arguments."));
        }
        previousArgRepeating = current.repeating;
        previousArgOptional = current.optional;
        previousArgDefault = current.default;
    }
}

function assertSingleColOrRow(errorStr, arg) {
    assert(() => arg.length === 1 || arg[0].length === 1, errorStr);
}
function assertSameDimensions(errorStr, ...args) {
    if (args.every(isMatrix)) {
        const cols = args[0].length;
        const rows = args[0][0].length;
        for (const arg of args) {
            assert(() => arg.length === cols && arg[0].length === rows, errorStr);
        }
        return;
    }
    if (args.some((arg) => Array.isArray(arg) && (arg.length !== 1 || arg[0].length !== 1))) {
        throw new EvaluationError(errorStr);
    }
}
function assertPositive(errorStr, arg) {
    assert(() => arg > 0, errorStr);
}
function assertSquareMatrix(errorStr, arg) {
    assert(() => arg.length === arg[0].length, errorStr);
}

// -----------------------------------------------------------------------------
// ARRAY_CONSTRAIN
// -----------------------------------------------------------------------------
const ARRAY_CONSTRAIN = {
    description: _t("Returns a result array constrained to a specific width and height."),
    args: [
        arg("input_range (any, range<any>)", _t("The range to constrain.")),
        arg("rows (number)", _t("The number of rows in the constrained array.")),
        arg("columns (number)", _t("The number of columns in the constrained array.")),
    ],
    compute: function (array, rows, columns) {
        const _array = toMatrix(array);
        const _rowsArg = toInteger(rows?.value, this.locale);
        const _columnsArg = toInteger(columns?.value, this.locale);
        assertPositive(_t("The rows argument (%s) must be strictly positive.", _rowsArg.toString()), _rowsArg);
        assertPositive(_t("The columns argument (%s) must be strictly positive.", _rowsArg.toString()), _columnsArg);
        const _nbRows = Math.min(_rowsArg, _array[0].length);
        const _nbColumns = Math.min(_columnsArg, _array.length);
        return generateMatrix(_nbColumns, _nbRows, (col, row) => _array[col][row]);
    },
    isExported: false,
};
// -----------------------------------------------------------------------------
// CHOOSECOLS
// -----------------------------------------------------------------------------
const CHOOSECOLS = {
    description: _t("Creates a new array from the selected columns in the existing range."),
    args: [
        arg("array (any, range<any>)", _t("The array that contains the columns to be returned.")),
        arg("col_num (number, range<number>)", _t("The first column index of the columns to be returned.")),
        arg("col_num2 (number, range<number>, repeating)", _t("The columns indexes of the columns to be returned.")),
    ],
    compute: function (array, ...columns) {
        const _array = toMatrix(array);
        const _columns = flattenRowFirst(columns, (item) => toInteger(item?.value, this.locale));
        const argOutOfRange = _columns.filter((col) => col === 0 || _array.length < Math.abs(col));
        assert(() => argOutOfRange.length === 0, _t("The columns arguments must be between -%s and %s (got %s), excluding 0.", _array.length.toString(), _array.length.toString(), argOutOfRange.join(",")));
        const result = Array(_columns.length);
        for (let col = 0; col < _columns.length; col++) {
            if (_columns[col] > 0) {
                result[col] = _array[_columns[col] - 1]; // -1 because columns arguments are 1-indexed
            }
            else {
                result[col] = _array[_array.length + _columns[col]];
            }
        }
        return result;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// CHOOSEROWS
// -----------------------------------------------------------------------------
const CHOOSEROWS = {
    description: _t("Creates a new array from the selected rows in the existing range."),
    args: [
        arg("array (any, range<any>)", _t("The array that contains the rows to be returned.")),
        arg("row_num (number, range<number>)", _t("The first row index of the rows to be returned.")),
        arg("row_num2 (number, range<number>, repeating)", _t("The rows indexes of the rows to be returned.")),
    ],
    compute: function (array, ...rows) {
        const _array = toMatrix(array);
        const _rows = flattenRowFirst(rows, (item) => toInteger(item?.value, this.locale));
        const _nbColumns = _array.length;
        const argOutOfRange = _rows.filter((row) => row === 0 || _array[0].length < Math.abs(row));
        assert(() => argOutOfRange.length === 0, _t("The rows arguments must be between -%s and %s (got %s), excluding 0.", _array[0].length.toString(), _array[0].length.toString(), argOutOfRange.join(",")));
        return generateMatrix(_nbColumns, _rows.length, (col, row) => {
            if (_rows[row] > 0) {
                return _array[col][_rows[row] - 1]; // -1 because columns arguments are 1-indexed
            }
            return _array[col][_array[col].length + _rows[row]];
        });
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// EXPAND
// -----------------------------------------------------------------------------
const EXPAND = {
    description: _t("Expands or pads an array to specified row and column dimensions."),
    args: [
        arg("array (any, range<any>)", _t("The array to expand.")),
        arg("rows (number)", _t("The number of rows in the expanded array. If missing, rows will not be expanded.")),
        arg("columns (number, optional)", _t("The number of columns in the expanded array. If missing, columns will not be expanded.")),
        arg("pad_with (any, default=0)", _t("The value with which to pad.")), // @compatibility: on Excel, pad with #N/A
    ],
    compute: function (arg, rows, columns, padWith = { value: 0 } // TODO : Replace with #N/A errors once it's supported
    ) {
        const _array = toMatrix(arg);
        const _nbRows = toInteger(rows?.value, this.locale);
        const _nbColumns = columns !== undefined ? toInteger(columns.value, this.locale) : _array.length;
        assert(() => _nbRows >= _array[0].length, _t("The rows arguments (%s) must be greater or equal than the number of rows of the array.", _nbRows.toString()));
        assert(() => _nbColumns >= _array.length, _t("The columns arguments (%s) must be greater or equal than the number of columns of the array.", _nbColumns.toString()));
        return generateMatrix(_nbColumns, _nbRows, (col, row) => col >= _array.length || row >= _array[col].length ? padWith : _array[col][row]);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// FLATTEN
// -----------------------------------------------------------------------------
const FLATTEN = {
    description: _t("Flattens all the values from one or more ranges into a single column."),
    args: [
        arg("range (any, range<any>)", _t("The first range to flatten.")),
        arg("range2 (any, range<any>, repeating)", _t("Additional ranges to flatten.")),
    ],
    compute: function (...ranges) {
        return [flattenRowFirst(ranges, (val) => (val === undefined ? { value: "" } : val))];
    },
    isExported: false,
};
// -----------------------------------------------------------------------------
// FREQUENCY
// -----------------------------------------------------------------------------
const FREQUENCY = {
    description: _t("Calculates the frequency distribution of a range."),
    args: [
        arg("data (range<number>)", _t("The array of ranges containing the values to be counted.")),
        arg("classes (number, range<number>)", _t("The range containing the set of classes.")),
    ],
    compute: function (data, classes) {
        const _data = flattenRowFirst([data], (data) => data.value).filter((val) => typeof val === "number");
        const _classes = flattenRowFirst([classes], (data) => data.value).filter((val) => typeof val === "number");
        /**
         * Returns the frequency distribution of the data in the classes, ie. the number of elements in the range
         * between each classes.
         *
         * For example:
         * - data = [1, 3, 2, 5, 4]
         * - classes = [3, 5, 1]
         *
         * The result will be:
         * - 2 ==> number of elements 1 > el >= 3
         * - 2 ==> number of elements 3 > el >= 5
         * - 1 ==> number of elements <= 1
         * - 0 ==> number of elements > 5
         *
         * @compatibility: GSheet sort the input classes. We do the implemntation of Excel, where we kee the classes unsorted.
         */
        const sortedClasses = _classes
            .map((value, index) => ({ initialIndex: index, value, count: 0 }))
            .sort((a, b) => a.value - b.value);
        sortedClasses.push({ initialIndex: sortedClasses.length, value: Infinity, count: 0 });
        const sortedData = _data.sort((a, b) => a - b);
        let index = 0;
        for (const val of sortedData) {
            while (val > sortedClasses[index].value && index < sortedClasses.length - 1) {
                index++;
            }
            sortedClasses[index].count++;
        }
        const result = sortedClasses
            .sort((a, b) => a.initialIndex - b.initialIndex)
            .map((val) => val.count);
        return [result];
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// HSTACK
// -----------------------------------------------------------------------------
const HSTACK = {
    description: _t("Appends ranges horizontally and in sequence to return a larger array."),
    args: [
        arg("range1 (any, range<any>)", _t("The first range to be appended.")),
        arg("range2 (any, range<any>, repeating)", _t("Additional ranges to add to range1.")),
    ],
    compute: function (...ranges) {
        const nbRows = Math.max(...ranges.map((r) => r?.[0]?.length ?? 0));
        const result = [];
        for (const range of ranges) {
            const _range = toMatrix(range);
            for (let col = 0; col < _range.length; col++) {
                //TODO: fill with #N/A for unavailable values instead of zeroes
                const array = Array(nbRows).fill({ value: null });
                for (let row = 0; row < _range[col].length; row++) {
                    array[row] = _range[col][row];
                }
                result.push(array);
            }
        }
        return result;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// MDETERM
// -----------------------------------------------------------------------------
const MDETERM = {
    description: _t("Returns the matrix determinant of a square matrix."),
    args: [
        arg("square_matrix (number, range<number>)", _t("An range with an equal number of rows and columns representing a matrix whose determinant will be calculated.")),
    ],
    compute: function (matrix) {
        const _matrix = toNumberMatrix(matrix, "square_matrix");
        assertSquareMatrix(_t("The argument square_matrix must have the same number of columns and rows."), _matrix);
        return invertMatrix(_matrix).determinant;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// MINVERSE
// -----------------------------------------------------------------------------
const MINVERSE = {
    description: _t("Returns the multiplicative inverse of a square matrix."),
    args: [
        arg("square_matrix (number, range<number>)", _t("An range with an equal number of rows and columns representing a matrix whose multiplicative inverse will be calculated.")),
    ],
    compute: function (matrix) {
        const _matrix = toNumberMatrix(matrix, "square_matrix");
        assertSquareMatrix(_t("The argument square_matrix must have the same number of columns and rows."), _matrix);
        const { inverted } = invertMatrix(_matrix);
        if (!inverted) {
            throw new EvaluationError(_t("The matrix is not invertible."));
        }
        return inverted;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// MMULT
// -----------------------------------------------------------------------------
const MMULT = {
    description: _t("Calculates the matrix product of two matrices."),
    args: [
        arg("matrix1 (number, range<number>)", _t("The first matrix in the matrix multiplication operation.")),
        arg("matrix2 (number, range<number>)", _t("The second matrix in the matrix multiplication operation.")),
    ],
    compute: function (matrix1, matrix2) {
        const _matrix1 = toNumberMatrix(matrix1, "matrix1");
        const _matrix2 = toNumberMatrix(matrix2, "matrix2");
        assert(() => _matrix1.length === _matrix2[0].length, _t("In [[FUNCTION_NAME]], the number of columns of the first matrix (%s) must be equal to the \
        number of rows of the second matrix (%s).", _matrix1.length.toString(), _matrix2[0].length.toString()));
        return multiplyMatrices(_matrix1, _matrix2);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// SUMPRODUCT
// -----------------------------------------------------------------------------
const SUMPRODUCT = {
    description: _t("Calculates the sum of the products of corresponding entries in equal-sized ranges."),
    args: [
        arg("range1 (number, range<number>)", _t("The first range whose entries will be multiplied with corresponding entries in the other ranges.")),
        arg("range2 (number, range<number>, repeating)", _t("The other range whose entries will be multiplied with corresponding entries in the other ranges.")),
    ],
    compute: function (...args) {
        assertSameDimensions(_t("All the ranges must have the same dimensions."), ...args);
        const _args = args.map(toMatrix);
        let result = 0;
        for (let col = 0; col < _args[0].length; col++) {
            for (let row = 0; row < _args[0][col].length; row++) {
                if (!_args.every((range) => typeof range[col][row].value === "number")) {
                    continue;
                }
                let product = 1;
                for (const range of _args) {
                    product *= toNumber(range[col][row], this.locale);
                }
                result += product;
            }
        }
        return result;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// SUMX2MY2
// -----------------------------------------------------------------------------
/**
 * Return the sum of the callback applied to each pair of values in the two arrays.
 *
 * Ignore the pairs X,Y where one of the value isn't a number. Throw an error if no pair of numbers is found.
 */
function getSumXAndY(arrayX, arrayY, cb) {
    assertSameDimensions("The arguments array_x and array_y must have the same dimensions.", arrayX, arrayY);
    const _arrayX = toMatrix(arrayX);
    const _arrayY = toMatrix(arrayY);
    let validPairFound = false;
    let result = 0;
    for (const col in _arrayX) {
        for (const row in _arrayX[col]) {
            const arrayXValue = _arrayX[col][row].value;
            const arrayYValue = _arrayY[col][row].value;
            if (typeof arrayXValue !== "number" || typeof arrayYValue !== "number") {
                continue;
            }
            validPairFound = true;
            result += cb(arrayXValue, arrayYValue);
        }
    }
    if (!validPairFound) {
        throw new EvaluationError(_t("The arguments array_x and array_y must contain at least one pair of numbers."));
    }
    return result;
}
const SUMX2MY2 = {
    description: _t("Calculates the sum of the difference of the squares of the values in two array."),
    args: [
        arg("array_x (number, range<number>)", _t("The array or range of values whose squares will be reduced by the squares of corresponding entries in array_y and added together.")),
        arg("array_y (number, range<number>)", _t("The array or range of values whose squares will be subtracted from the squares of corresponding entries in array_x and added together.")),
    ],
    compute: function (arrayX, arrayY) {
        return getSumXAndY(arrayX, arrayY, (x, y) => x ** 2 - y ** 2);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// SUMX2PY2
// -----------------------------------------------------------------------------
const SUMX2PY2 = {
    description: _t("Calculates the sum of the sum of the squares of the values in two array."),
    args: [
        arg("array_x (number, range<number>)", _t("The array or range of values whose squares will be added to the squares of corresponding entries in array_y and added together.")),
        arg("array_y (number, range<number>)", _t("The array or range of values whose squares will be added to the squares of corresponding entries in array_x and added together.")),
    ],
    compute: function (arrayX, arrayY) {
        return getSumXAndY(arrayX, arrayY, (x, y) => x ** 2 + y ** 2);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// SUMXMY2
// -----------------------------------------------------------------------------
const SUMXMY2 = {
    description: _t("Calculates the sum of squares of the differences of values in two array."),
    args: [
        arg("array_x (number, range<number>)", _t("The array or range of values that will be reduced by corresponding entries in array_y, squared, and added together.")),
        arg("array_y (number, range<number>)", _t("The array or range of values that will be subtracted from corresponding entries in array_x, the result squared, and all such results added together.")),
    ],
    compute: function (arrayX, arrayY) {
        return getSumXAndY(arrayX, arrayY, (x, y) => (x - y) ** 2);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// TOCOL
// -----------------------------------------------------------------------------
const TO_COL_ROW_DEFAULT_IGNORE = 0;
const TO_COL_ROW_DEFAULT_SCAN = false;
const TO_COL_ROW_ARGS = [
    arg("array (any, range<any>)", _t("The array which will be transformed.")),
    arg(`ignore (number, default=${TO_COL_ROW_DEFAULT_IGNORE})`, _t("The control to ignore blanks and errors. 0 (default) is to keep all values, 1 is to ignore blanks, 2 is to ignore errors, and 3 is to ignore blanks and errors.")),
    arg(`scan_by_column (number, default=${TO_COL_ROW_DEFAULT_SCAN})`, _t("Whether the array should be scanned by column. True scans the array by column and false (default) \
      scans the array by row.")),
];
function shouldKeepValue(ignore) {
    const _ignore = Math.trunc(ignore);
    if (_ignore === 0) {
        return () => true;
    }
    if (_ignore === 1) {
        return (data) => data.value !== null;
    }
    if (_ignore === 2) {
        return (data) => !isEvaluationError(data.value);
    }
    if (_ignore === 3) {
        return (data) => data.value !== null && !isEvaluationError(data.value);
    }
    throw new EvaluationError(_t("Argument ignore must be between 0 and 3"));
}
const TOCOL = {
    description: _t("Transforms a range of cells into a single column."),
    args: TO_COL_ROW_ARGS,
    compute: function (array, ignore = { value: TO_COL_ROW_DEFAULT_IGNORE }, scanByColumn = { value: TO_COL_ROW_DEFAULT_SCAN }) {
        const _array = toMatrix(array);
        const _ignore = toNumber(ignore.value, this.locale);
        const _scanByColumn = toBoolean(scanByColumn.value);
        const result = (_scanByColumn ? _array : transposeMatrix(_array))
            .flat()
            .filter(shouldKeepValue(_ignore));
        if (result.length === 0) {
            throw new NotAvailableError(_t("No results for the given arguments of TOCOL."));
        }
        return [result];
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// TOROW
// -----------------------------------------------------------------------------
const TOROW = {
    description: _t("Transforms a range of cells into a single row."),
    args: TO_COL_ROW_ARGS,
    compute: function (array, ignore = { value: TO_COL_ROW_DEFAULT_IGNORE }, scanByColumn = { value: TO_COL_ROW_DEFAULT_SCAN }) {
        const _array = toMatrix(array);
        const _ignore = toNumber(ignore.value, this.locale);
        const _scanByColumn = toBoolean(scanByColumn.value);
        const result = (_scanByColumn ? _array : transposeMatrix(_array))
            .flat()
            .filter(shouldKeepValue(_ignore))
            .map((item) => [item]);
        if (result.length === 0 || result[0].length === 0) {
            throw new NotAvailableError(_t("No results for the given arguments of TOROW."));
        }
        return result;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// TRANSPOSE
// -----------------------------------------------------------------------------
const TRANSPOSE = {
    description: _t("Transposes the rows and columns of a range."),
    args: [arg("range (any, range<any>)", _t("The range to be transposed."))],
    compute: function (arg) {
        const _array = toMatrix(arg);
        const nbColumns = _array[0].length;
        const nbRows = _array.length;
        return generateMatrix(nbColumns, nbRows, (col, row) => _array[row][col]);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// VSTACK
// -----------------------------------------------------------------------------
const VSTACK = {
    description: _t("Appends ranges vertically and in sequence to return a larger array."),
    args: [
        arg("range1 (any, range<any>)", _t("The first range to be appended.")),
        arg("range2 (any, range<any>, repeating)", _t("Additional ranges to add to range1.")),
    ],
    compute: function (...ranges) {
        const nbColumns = Math.max(...ranges.map((range) => toMatrix(range).length));
        const nbRows = ranges.reduce((acc, range) => acc + toMatrix(range)[0].length, 0);
        const result = Array(nbColumns)
            .fill([])
            .map(() => Array(nbRows).fill({ value: 0 })); // TODO fill with #N/A
        let currentRow = 0;
        for (const range of ranges) {
            const _array = toMatrix(range);
            for (let col = 0; col < _array.length; col++) {
                for (let row = 0; row < _array[col].length; row++) {
                    result[col][currentRow + row] = _array[col][row];
                }
            }
            currentRow += _array[0].length;
        }
        return result;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// WRAPCOLS
// -----------------------------------------------------------------------------
const WRAPCOLS = {
    description: _t("Wraps the provided row or column of cells by columns after a specified number of elements to form a new array."),
    args: [
        arg("range (any, range<any>)", _t("The range to wrap.")),
        arg("wrap_count (number)", _t("The maximum number of cells for each column, rounded down to the nearest whole number.")),
        arg("pad_with  (any, default=0)", // TODO : replace with #N/A
        _t("The value with which to fill the extra cells in the range.")),
    ],
    compute: function (range, wrapCount, padWith = { value: 0 }) {
        const _array = toMatrix(range);
        const nbRows = toInteger(wrapCount?.value, this.locale);
        assertSingleColOrRow(_t("Argument range must be a single row or column."), _array);
        const array = _array.flat();
        const nbColumns = Math.ceil(array.length / nbRows);
        return generateMatrix(nbColumns, nbRows, (col, row) => {
            const index = col * nbRows + row;
            return index < array.length ? array[index] : padWith;
        });
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// WRAPROWS
// -----------------------------------------------------------------------------
const WRAPROWS = {
    description: _t("Wraps the provided row or column of cells by rows after a specified number of elements to form a new array."),
    args: [
        arg("range (any, range<any>)", _t("The range to wrap.")),
        arg("wrap_count (number)", _t("The maximum number of cells for each row, rounded down to the nearest whole number.")),
        arg("pad_with  (any, default=0)", // TODO : replace with #N/A
        _t("The value with which to fill the extra cells in the range.")),
    ],
    compute: function (range, wrapCount, padWith = { value: 0 }) {
        const _array = toMatrix(range);
        const nbColumns = toInteger(wrapCount?.value, this.locale);
        assertSingleColOrRow(_t("Argument range must be a single row or column."), _array);
        const array = _array.flat();
        const nbRows = Math.ceil(array.length / nbColumns);
        return generateMatrix(nbColumns, nbRows, (col, row) => {
            const index = row * nbColumns + col;
            return index < array.length ? array[index] : padWith;
        });
    },
    isExported: true,
};

var array = /*#__PURE__*/Object.freeze({
    __proto__: null,
    ARRAY_CONSTRAIN: ARRAY_CONSTRAIN,
    CHOOSECOLS: CHOOSECOLS,
    CHOOSEROWS: CHOOSEROWS,
    EXPAND: EXPAND,
    FLATTEN: FLATTEN,
    FREQUENCY: FREQUENCY,
    HSTACK: HSTACK,
    MDETERM: MDETERM,
    MINVERSE: MINVERSE,
    MMULT: MMULT,
    SUMPRODUCT: SUMPRODUCT,
    SUMX2MY2: SUMX2MY2,
    SUMX2PY2: SUMX2PY2,
    SUMXMY2: SUMXMY2,
    TOCOL: TOCOL,
    TOROW: TOROW,
    TRANSPOSE: TRANSPOSE,
    VSTACK: VSTACK,
    WRAPCOLS: WRAPCOLS,
    WRAPROWS: WRAPROWS
});

// -----------------------------------------------------------------------------
// FORMAT.LARGE.NUMBER
// -----------------------------------------------------------------------------
const FORMAT_LARGE_NUMBER = {
    description: _t("Apply a large number format"),
    args: [
        arg("value (number)", _t("The number.")),
        arg("unit (string, optional)", _t("The formatting unit. Use 'k', 'm', or 'b' to force the unit")),
    ],
    compute: function (value, unite) {
        return {
            value: toNumber(value, this.locale),
            format: formatLargeNumber(value, unite, this.locale),
        };
    },
};

var misc = /*#__PURE__*/Object.freeze({
    __proto__: null,
    FORMAT_LARGE_NUMBER: FORMAT_LARGE_NUMBER
});

const DEFAULT_FACTOR = 1;
const DEFAULT_MODE = 0;
const DEFAULT_PLACES = 0;
const DEFAULT_SIGNIFICANCE = 1;
const DECIMAL_REPRESENTATION = /^-?[a-z0-9]+$/i;
// -----------------------------------------------------------------------------
// ABS
// -----------------------------------------------------------------------------
const ABS = {
    description: _t("Absolute value of a number."),
    args: [arg("value (number)", _t("The number of which to return the absolute value."))],
    compute: function (value) {
        return Math.abs(toNumber(value, this.locale));
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// ACOS
// -----------------------------------------------------------------------------
const ACOS = {
    description: _t("Inverse cosine of a value, in radians."),
    args: [
        arg("value (number)", _t("The value for which to calculate the inverse cosine. Must be between -1 and 1, inclusive.")),
    ],
    compute: function (value) {
        const _value = toNumber(value, this.locale);
        assert(() => Math.abs(_value) <= 1, _t("The value (%s) must be between -1 and 1 inclusive.", _value.toString()));
        return Math.acos(_value);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// ACOSH
// -----------------------------------------------------------------------------
const ACOSH = {
    description: _t("Inverse hyperbolic cosine of a number."),
    args: [
        arg("value (number)", _t("The value for which to calculate the inverse hyperbolic cosine. Must be greater than or equal to 1.")),
    ],
    compute: function (value) {
        const _value = toNumber(value, this.locale);
        assert(() => _value >= 1, _t("The value (%s) must be greater than or equal to 1.", _value.toString()));
        return Math.acosh(_value);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// ACOT
// -----------------------------------------------------------------------------
const ACOT = {
    description: _t("Inverse cotangent of a value."),
    args: [arg("value (number)", _t("The value for which to calculate the inverse cotangent."))],
    compute: function (value) {
        const _value = toNumber(value, this.locale);
        const sign = Math.sign(_value) || 1;
        // ACOT has two possible configurations:
        // @compatibility Excel: return Math.PI / 2 - Math.atan(toNumber(_value, this.locale));
        // @compatibility Google: return sign * Math.PI / 2 - Math.atan(toNumber(_value, this.locale));
        return (sign * Math.PI) / 2 - Math.atan(_value);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// ACOTH
// -----------------------------------------------------------------------------
const ACOTH = {
    description: _t("Inverse hyperbolic cotangent of a value."),
    args: [
        arg("value (number)", _t("The value for which to calculate the inverse hyperbolic cotangent. Must not be between -1 and 1, inclusive.")),
    ],
    compute: function (value) {
        const _value = toNumber(value, this.locale);
        assert(() => Math.abs(_value) > 1, _t("The value (%s) cannot be between -1 and 1 inclusive.", _value.toString()));
        return Math.log((_value + 1) / (_value - 1)) / 2;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// ASIN
// -----------------------------------------------------------------------------
const ASIN = {
    description: _t("Inverse sine of a value, in radians."),
    args: [
        arg("value (number)", _t("The value for which to calculate the inverse sine. Must be between -1 and 1, inclusive.")),
    ],
    compute: function (value) {
        const _value = toNumber(value, this.locale);
        assert(() => Math.abs(_value) <= 1, _t("The value (%s) must be between -1 and 1 inclusive.", _value.toString()));
        return Math.asin(_value);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// ASINH
// -----------------------------------------------------------------------------
const ASINH = {
    description: _t("Inverse hyperbolic sine of a number."),
    args: [
        arg("value (number)", _t("The value for which to calculate the inverse hyperbolic sine.")),
    ],
    compute: function (value) {
        return Math.asinh(toNumber(value, this.locale));
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// ATAN
// -----------------------------------------------------------------------------
const ATAN = {
    description: _t("Inverse tangent of a value, in radians."),
    args: [arg("value (number)", _t("The value for which to calculate the inverse tangent."))],
    compute: function (value) {
        return Math.atan(toNumber(value, this.locale));
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// ATAN2
// -----------------------------------------------------------------------------
const ATAN2 = {
    description: _t("Angle from the X axis to a point (x,y), in radians."),
    args: [
        arg("x (number)", _t("The x coordinate of the endpoint of the line segment for which to calculate the angle from the x-axis.")),
        arg("y (number)", _t("The y coordinate of the endpoint of the line segment for which to calculate the angle from the x-axis.")),
    ],
    compute: function (x, y) {
        const _x = toNumber(x, this.locale);
        const _y = toNumber(y, this.locale);
        assert(() => _x !== 0 || _y !== 0, _t("Function [[FUNCTION_NAME]] caused a divide by zero error."), CellErrorType.DivisionByZero);
        return Math.atan2(_y, _x);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// ATANH
// -----------------------------------------------------------------------------
const ATANH = {
    description: _t("Inverse hyperbolic tangent of a number."),
    args: [
        arg("value (number)", _t("The value for which to calculate the inverse hyperbolic tangent. Must be between -1 and 1, exclusive.")),
    ],
    compute: function (value) {
        const _value = toNumber(value, this.locale);
        assert(() => Math.abs(_value) < 1, _t("The value (%s) must be between -1 and 1 exclusive.", _value.toString()));
        return Math.atanh(_value);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// CEILING
// -----------------------------------------------------------------------------
const CEILING = {
    description: _t("Rounds number up to nearest multiple of factor."),
    args: [
        arg("value (number)", _t("The value to round up to the nearest integer multiple of factor.")),
        arg(`factor (number, default=${DEFAULT_FACTOR})`, _t("The number to whose multiples value will be rounded.")),
    ],
    compute: function (value, factor = { value: DEFAULT_FACTOR }) {
        const _value = toNumber(value, this.locale);
        const _factor = toNumber(factor, this.locale);
        assert(() => _factor >= 0 || _value <= 0, _t("The factor (%s) must be positive when the value (%s) is positive.", _factor.toString(), _value.toString()));
        return {
            value: _factor ? Math.ceil(_value / _factor) * _factor : 0,
            format: value?.format,
        };
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// CEILING.MATH
// -----------------------------------------------------------------------------
function ceilingMath(number, significance, mode = 0) {
    if (significance === 0) {
        return 0;
    }
    significance = Math.abs(significance);
    if (number >= 0) {
        return Math.ceil(number / significance) * significance;
    }
    if (mode === 0) {
        return -Math.floor(Math.abs(number) / significance) * significance;
    }
    return -Math.ceil(Math.abs(number) / significance) * significance;
}
const CEILING_MATH = {
    description: _t("Rounds number up to nearest multiple of factor."),
    args: [
        arg("number (number)", _t("The value to round up to the nearest integer multiple of significance.")),
        arg(`significance (number, default=${DEFAULT_SIGNIFICANCE})`, _t("The number to whose multiples number will be rounded. The sign of significance will be ignored.")),
        arg(`mode (number, default=${DEFAULT_MODE})`, _t("If number is negative, specifies the rounding direction. If 0 or blank, it is rounded towards zero. Otherwise, it is rounded away from zero.")),
    ],
    compute: function (number, significance = { value: DEFAULT_SIGNIFICANCE }, mode = { value: DEFAULT_MODE }) {
        const _significance = toNumber(significance, this.locale);
        const _number = toNumber(number, this.locale);
        const _mode = toNumber(mode, this.locale);
        return {
            value: ceilingMath(_number, _significance, _mode),
            format: number?.format,
        };
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// CEILING.PRECISE
// -----------------------------------------------------------------------------
const CEILING_PRECISE = {
    description: _t("Rounds number up to nearest multiple of factor."),
    args: [
        arg("number (number)", _t("The value to round up to the nearest integer multiple of significance.")),
        arg(`significance (number, default=${DEFAULT_SIGNIFICANCE})`, _t("The number to whose multiples number will be rounded.")),
    ],
    compute: function (number, significance = { value: DEFAULT_SIGNIFICANCE }) {
        const _significance = toNumber(significance, this.locale);
        const _number = toNumber(number, this.locale);
        return {
            value: ceilingMath(_number, _significance),
            format: number?.format,
        };
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// COS
// -----------------------------------------------------------------------------
const COS = {
    description: _t("Cosine of an angle provided in radians."),
    args: [arg("angle (number)", _t("The angle to find the cosine of, in radians."))],
    compute: function (angle) {
        return Math.cos(toNumber(angle, this.locale));
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// COSH
// -----------------------------------------------------------------------------
const COSH = {
    description: _t("Hyperbolic cosine of any real number."),
    args: [arg("value (number)", _t("Any real value to calculate the hyperbolic cosine of."))],
    compute: function (value) {
        return Math.cosh(toNumber(value, this.locale));
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// COT
// -----------------------------------------------------------------------------
const COT = {
    description: _t("Cotangent of an angle provided in radians."),
    args: [arg("angle (number)", _t("The angle to find the cotangent of, in radians."))],
    compute: function (angle) {
        const _angle = toNumber(angle, this.locale);
        assertNotZero(_angle);
        return 1 / Math.tan(_angle);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// COTH
// -----------------------------------------------------------------------------
const COTH = {
    description: _t("Hyperbolic cotangent of any real number."),
    args: [arg("value (number)", _t("Any real value to calculate the hyperbolic cotangent of."))],
    compute: function (value) {
        const _value = toNumber(value, this.locale);
        assertNotZero(_value);
        return 1 / Math.tanh(_value);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// COUNTBLANK
// -----------------------------------------------------------------------------
const COUNTBLANK = {
    description: _t("Number of empty values."),
    args: [
        arg("value1 (any, range)", _t("The first value or range in which to count the number of blanks.")),
        arg("value2 (any, range, repeating)", _t("Additional values or ranges in which to count the number of blanks.")),
    ],
    compute: function (...args) {
        return reduceAny(args, (acc, a) => {
            if (a === undefined) {
                return acc + 1;
            }
            if (a.value === null) {
                return acc + 1;
            }
            if (a.value === "") {
                return acc + 1;
            }
            return acc;
        }, 0);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// COUNTIF
// -----------------------------------------------------------------------------
const COUNTIF = {
    description: _t("A conditional count across a range."),
    args: [
        arg("range (range)", _t("The range that is tested against criterion.")),
        arg("criterion (string)", _t("The pattern or test to apply to range.")),
    ],
    compute: function (...args) {
        let count = 0;
        visitMatchingRanges(args, (i, j) => {
            count += 1;
        }, this.locale);
        return count;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// COUNTIFS
// -----------------------------------------------------------------------------
const COUNTIFS = {
    description: _t("Count values depending on multiple criteria."),
    args: [
        arg("criteria_range1 (range)", _t("The range to check against criterion1.")),
        arg("criterion1 (string)", _t("The pattern or test to apply to criteria_range1.")),
        arg("criteria_range2 (any, range, repeating)", _t("Additional ranges over which to evaluate the additional criteria. The filtered set will be the intersection of the sets produced by each criterion-range pair.")),
        arg("criterion2 (string, repeating)", _t("Additional criteria to check.")),
    ],
    compute: function (...args) {
        let count = 0;
        visitMatchingRanges(args, (i, j) => {
            count += 1;
        }, this.locale);
        return count;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// COUNTUNIQUE
// -----------------------------------------------------------------------------
const COUNTUNIQUE = {
    description: _t("Counts number of unique values in a range."),
    args: [
        arg("value1 (any, range)", _t("The first value or range to consider for uniqueness.")),
        arg("value2 (any, range, repeating)", _t("Additional values or ranges to consider for uniqueness.")),
    ],
    compute: function (...args) {
        return countUnique(args);
    },
};
// -----------------------------------------------------------------------------
// COUNTUNIQUEIFS
// -----------------------------------------------------------------------------
const COUNTUNIQUEIFS = {
    description: _t("Counts number of unique values in a range, filtered by a set of criteria."),
    args: [
        arg("range (range)", _t("The range of cells from which the number of unique values will be counted.")),
        arg("criteria_range1 (range)", _t("The range of cells over which to evaluate criterion1.")),
        arg("criterion1 (string)", _t("The pattern or test to apply to criteria_range1, such that each cell that evaluates to TRUE will be included in the filtered set.")),
        arg("criteria_range2 (any, range, repeating)", _t("Additional ranges over which to evaluate the additional criteria. The filtered set will be the intersection of the sets produced by each criterion-range pair.")),
        arg("criterion2 (string, repeating)", _t("The pattern or test to apply to criteria_range2.")),
    ],
    compute: function (range, ...args) {
        let uniqueValues = new Set();
        visitMatchingRanges(args, (i, j) => {
            const data = range[i]?.[j];
            if (isDataNonEmpty(data)) {
                uniqueValues.add(data.value);
            }
        }, this.locale);
        return uniqueValues.size;
    },
};
// -----------------------------------------------------------------------------
// CSC
// -----------------------------------------------------------------------------
const CSC = {
    description: _t("Cosecant of an angle provided in radians."),
    args: [arg("angle (number)", _t("The angle to find the cosecant of, in radians."))],
    compute: function (angle) {
        const _angle = toNumber(angle, this.locale);
        assertNotZero(_angle);
        return 1 / Math.sin(_angle);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// CSCH
// -----------------------------------------------------------------------------
const CSCH = {
    description: _t("Hyperbolic cosecant of any real number."),
    args: [arg("value (number)", _t("Any real value to calculate the hyperbolic cosecant of."))],
    compute: function (value) {
        const _value = toNumber(value, this.locale);
        assertNotZero(_value);
        return 1 / Math.sinh(_value);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// DECIMAL
// -----------------------------------------------------------------------------
const DECIMAL = {
    description: _t("Converts from another base to decimal."),
    args: [
        arg("value (string)", _t("The number to convert.")),
        arg("base (number)", _t("The base to convert the value from.")),
    ],
    compute: function (value, base) {
        let _base = toNumber(base, this.locale);
        _base = Math.floor(_base);
        assert(() => 2 <= _base && _base <= 36, _t("The base (%s) must be between 2 and 36 inclusive.", _base.toString()));
        const _value = toString(value);
        if (_value === "") {
            return 0;
        }
        /**
         * @compatibility: on Google sheets, expects the parameter 'value' to be positive.
         * Return error if 'value' is positive.
         * Remove '-?' in the next regex to catch this error.
         */
        assert(() => !!DECIMAL_REPRESENTATION.test(_value), _t("The value (%s) must be a valid base %s representation.", _value, _base.toString()));
        const deci = parseInt(_value, _base);
        assert(() => !isNaN(deci), _t("The value (%s) must be a valid base %s representation.", _value, _base.toString()));
        return deci;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// DEGREES
// -----------------------------------------------------------------------------
const DEGREES = {
    description: _t("Converts an angle value in radians to degrees."),
    args: [arg("angle (number)", _t("The angle to convert from radians to degrees."))],
    compute: function (angle) {
        return (toNumber(angle, this.locale) * 180) / Math.PI;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// EXP
// -----------------------------------------------------------------------------
const EXP = {
    description: _t("Euler's number, e (~2.718) raised to a power."),
    args: [arg("value (number)", _t("The exponent to raise e."))],
    compute: function (value) {
        return Math.exp(toNumber(value, this.locale));
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// FLOOR
// -----------------------------------------------------------------------------
const FLOOR = {
    description: _t("Rounds number down to nearest multiple of factor."),
    args: [
        arg("value (number)", _t("The value to round down to the nearest integer multiple of factor.")),
        arg(`factor (number, default=${DEFAULT_FACTOR})`, _t("The number to whose multiples value will be rounded.")),
    ],
    compute: function (value, factor = { value: DEFAULT_FACTOR }) {
        const _value = toNumber(value, this.locale);
        const _factor = toNumber(factor, this.locale);
        assert(() => _factor >= 0 || _value <= 0, _t("The factor (%s) must be positive when the value (%s) is positive.", _factor.toString(), _value.toString()));
        return {
            value: _factor ? Math.floor(_value / _factor) * _factor : 0,
            format: value?.format,
        };
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// FLOOR.MATH
// -----------------------------------------------------------------------------
function floorMath(number, significance, mode = 0) {
    if (significance === 0) {
        return 0;
    }
    significance = Math.abs(significance);
    if (number >= 0) {
        return Math.floor(number / significance) * significance;
    }
    if (mode === 0) {
        return -Math.ceil(Math.abs(number) / significance) * significance;
    }
    return -Math.floor(Math.abs(number) / significance) * significance;
}
const FLOOR_MATH = {
    description: _t("Rounds number down to nearest multiple of factor."),
    args: [
        arg("number (number)", _t("The value to round down to the nearest integer multiple of significance.")),
        arg(`significance (number, default=${DEFAULT_SIGNIFICANCE})`, _t("The number to whose multiples number will be rounded. The sign of significance will be ignored.")),
        arg(`mode (number, default=${DEFAULT_MODE})`, _t("If number is negative, specifies the rounding direction. If 0 or blank, it is rounded away from zero. Otherwise, it is rounded towards zero.")),
    ],
    compute: function (number, significance = { value: DEFAULT_SIGNIFICANCE }, mode = { value: DEFAULT_MODE }) {
        const _significance = toNumber(significance, this.locale);
        const _number = toNumber(number, this.locale);
        const _mode = toNumber(mode, this.locale);
        return {
            value: floorMath(_number, _significance, _mode),
            format: number?.format,
        };
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// FLOOR.PRECISE
// -----------------------------------------------------------------------------
const FLOOR_PRECISE = {
    description: _t("Rounds number down to nearest multiple of factor."),
    args: [
        arg("number (number)", _t("The value to round down to the nearest integer multiple of significance.")),
        arg(`significance (number, default=${DEFAULT_SIGNIFICANCE})`, _t("The number to whose multiples number will be rounded.")),
    ],
    compute: function (number, significance = { value: DEFAULT_SIGNIFICANCE }) {
        const _significance = toNumber(significance, this.locale);
        const _number = toNumber(number, this.locale);
        return {
            value: floorMath(_number, _significance),
            format: number?.format,
        };
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// ISEVEN
// -----------------------------------------------------------------------------
const ISEVEN = {
    description: _t("Whether the provided value is even."),
    args: [arg("value (number)", _t("The value to be verified as even."))],
    compute: function (value) {
        const _value = strictToNumber(value, this.locale);
        return Math.floor(Math.abs(_value)) & 1 ? false : true;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// ISO.CEILING
// -----------------------------------------------------------------------------
const ISO_CEILING = {
    description: _t("Rounds number up to nearest multiple of factor."),
    args: [
        arg("number (number)", _t("The value to round up to the nearest integer multiple of significance.")),
        arg(`significance (number, default=${DEFAULT_SIGNIFICANCE})`, _t("The number to whose multiples number will be rounded.")),
    ],
    compute: function (number, significance = { value: DEFAULT_SIGNIFICANCE }) {
        const _number = toNumber(number, this.locale);
        const _significance = toNumber(significance, this.locale);
        return {
            value: ceilingMath(_number, _significance),
            format: number?.format,
        };
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// ISODD
// -----------------------------------------------------------------------------
const ISODD = {
    description: _t("Whether the provided value is even."),
    args: [arg("value (number)", _t("The value to be verified as even."))],
    compute: function (value) {
        const _value = strictToNumber(value, this.locale);
        return Math.floor(Math.abs(_value)) & 1 ? true : false;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// LN
// -----------------------------------------------------------------------------
const LN = {
    description: _t("The logarithm of a number, base e (euler's number)."),
    args: [arg("value (number)", _t("The value for which to calculate the logarithm, base e."))],
    compute: function (value) {
        const _value = toNumber(value, this.locale);
        assert(() => _value > 0, _t("The value (%s) must be strictly positive.", _value.toString()));
        return Math.log(_value);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// LOG
// -----------------------------------------------------------------------------
const LOG = {
    description: _t("The logarithm of a number, for a given base."),
    args: [
        arg("value (number)", _t("The value for which to calculate the logarithm.")),
        arg("base (number, default=10)", _t("The base of the logarithm.")),
    ],
    compute: function (value, base = { value: 10 }) {
        const _value = toNumber(value, this.locale);
        const _base = toNumber(base, this.locale);
        assert(() => _value > 0, _t("The value (%s) must be strictly positive.", _value.toString()));
        assert(() => _base > 0, _t("The base (%s) must be strictly positive.", _base.toString()));
        assert(() => _base !== 1, _t("The base must be different from 1."));
        return Math.log10(_value) / Math.log10(_base);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// MOD
// -----------------------------------------------------------------------------
function mod(dividend, divisor) {
    assert(() => divisor !== 0, _t("The divisor must be different from 0."), CellErrorType.DivisionByZero);
    const modulus = dividend % divisor;
    // -42 % 10 = -2 but we want 8, so need the code below
    if ((modulus > 0 && divisor < 0) || (modulus < 0 && divisor > 0)) {
        return modulus + divisor;
    }
    return modulus;
}
const MOD = {
    description: _t("Modulo (remainder) operator."),
    args: [
        arg("dividend (number)", _t("The number to be divided to find the remainder.")),
        arg("divisor (number)", _t("The number to divide by.")),
    ],
    compute: function (dividend, divisor) {
        const _divisor = toNumber(divisor, this.locale);
        const _dividend = toNumber(dividend, this.locale);
        return {
            value: mod(_dividend, _divisor),
            format: dividend?.format,
        };
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// MUNIT
// -----------------------------------------------------------------------------
const MUNIT = {
    description: _t("Returns a n x n unit matrix, where n is the input dimension."),
    args: [
        arg("dimension (number)", _t("An integer specifying the dimension size of the unit matrix. It must be positive.")),
    ],
    compute: function (n) {
        const _n = toInteger(n, this.locale);
        assertPositive(_t("The argument dimension must be positive"), _n);
        return getUnitMatrix(_n);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// ODD
// -----------------------------------------------------------------------------
const ODD = {
    description: _t("Rounds a number up to the nearest odd integer."),
    args: [arg("value (number)", _t("The value to round to the next greatest odd number."))],
    compute: function (value) {
        const _value = toNumber(value, this.locale);
        let temp = Math.ceil(Math.abs(_value));
        temp = temp & 1 ? temp : temp + 1;
        return {
            value: _value < 0 ? -temp : temp,
            format: value?.format,
        };
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// PI
// -----------------------------------------------------------------------------
const PI = {
    description: _t("The number pi."),
    args: [],
    compute: function () {
        return Math.PI;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// POWER
// -----------------------------------------------------------------------------
const POWER = {
    description: _t("A number raised to a power."),
    args: [
        arg("base (number)", _t("The number to raise to the exponent power.")),
        arg("exponent (number)", _t("The exponent to raise base to.")),
    ],
    compute: function (base, exponent) {
        const _base = toNumber(base, this.locale);
        const _exponent = toNumber(exponent, this.locale);
        assert(() => _base >= 0 || Number.isInteger(_exponent), _t("The exponent (%s) must be an integer when the base is negative.", _exponent.toString()));
        return { value: Math.pow(_base, _exponent), format: base?.format };
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// PRODUCT
// -----------------------------------------------------------------------------
const PRODUCT = {
    description: _t("Result of multiplying a series of numbers together."),
    args: [
        arg("factor1 (number, range<number>)", _t("The first number or range to calculate for the product.")),
        arg("factor2 (number, range<number>, repeating)", _t("More numbers or ranges to calculate for the product.")),
    ],
    compute: function (...factors) {
        let count = 0;
        let acc = 1;
        for (let n of factors) {
            if (isMatrix(n)) {
                for (let i of n) {
                    for (let j of i) {
                        const f = j.value;
                        if (typeof f === "number") {
                            acc *= f;
                            count += 1;
                        }
                        if (isEvaluationError(f)) {
                            throw j;
                        }
                    }
                }
            }
            else if (n !== undefined && n.value !== null) {
                acc *= strictToNumber(n, this.locale);
                count += 1;
            }
        }
        return {
            value: count === 0 ? 0 : acc,
            format: inferFormat(factors[0]),
        };
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// RAND
// -----------------------------------------------------------------------------
const RAND = {
    description: _t("A random number between 0 inclusive and 1 exclusive."),
    args: [],
    compute: function () {
        return Math.random();
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// RANDARRAY
// -----------------------------------------------------------------------------
const RANDARRAY = {
    description: _t("Returns a grid of random numbers between 0 inclusive and 1 exclusive."),
    args: [
        arg("rows (number, default=1)", _t("The number of rows to be returned.")),
        arg("columns (number, default=1)", _t("The number of columns to be returned.")),
        arg("min (number, default=0)", _t("The minimum number you would like returned.")),
        arg("max (number, default=1)", _t("The maximum number you would like returned.")),
        arg("whole_number (number, default=FALSE)", _t("Return a whole number or a decimal value.")),
    ],
    compute: function (rows = { value: 1 }, columns = { value: 1 }, min = { value: 0 }, max = { value: 1 }, wholeNumber = { value: false }) {
        const _cols = toInteger(columns, this.locale);
        const _rows = toInteger(rows, this.locale);
        const _min = toNumber(min, this.locale);
        const _max = toNumber(max, this.locale);
        const _whole_number = toBoolean(wholeNumber);
        assertPositive(_t("The number of columns (%s) must be positive.", _cols.toString()), _cols);
        assertPositive(_t("The number of rows (%s) must be positive.", _rows.toString()), _rows);
        assert(() => _min <= _max, _t("The maximum (%s) must be greater than or equal to the minimum (%s).", _max.toString(), _min.toString()));
        if (_whole_number) {
            assert(() => Number.isInteger(_min) && Number.isInteger(_max), _t("The maximum (%s) and minimum (%s) must be integers when whole_number is TRUE.", _max.toString(), _min.toString()));
        }
        const result = Array(_cols);
        for (let col = 0; col < _cols; col++) {
            result[col] = Array(_rows);
            for (let row = 0; row < _rows; row++) {
                if (!_whole_number) {
                    result[col][row] = _min + Math.random() * (_max - _min);
                }
                else {
                    result[col][row] = Math.floor(Math.random() * (_max - _min + 1) + _min);
                }
            }
        }
        return result;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// RANDBETWEEN
// -----------------------------------------------------------------------------
const RANDBETWEEN = {
    description: _t("Random integer between two values, inclusive."),
    args: [
        arg("low (number)", _t("The low end of the random range.")),
        arg("high (number)", _t("The high end of the random range.")),
    ],
    compute: function (low, high) {
        let _low = toNumber(low, this.locale);
        if (!Number.isInteger(_low)) {
            _low = Math.ceil(_low);
        }
        let _high = toNumber(high, this.locale);
        if (!Number.isInteger(_high)) {
            _high = Math.floor(_high);
        }
        assert(() => _low <= _high, _t("The high (%s) must be greater than or equal to the low (%s).", _high.toString(), _low.toString()));
        return {
            value: _low + Math.ceil((_high - _low + 1) * Math.random()) - 1,
            format: low?.format,
        };
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// ROUND
// -----------------------------------------------------------------------------
const ROUND = {
    description: _t("Rounds a number according to standard rules."),
    args: [
        arg("value (number)", _t("The value to round to places number of places.")),
        arg(`places (number, default=${DEFAULT_PLACES})`, _t("The number of decimal places to which to round.")),
    ],
    compute: function (value, places = { value: DEFAULT_PLACES }) {
        const _value = toNumber(value, this.locale);
        let _places = toNumber(places, this.locale);
        const absValue = Math.abs(_value);
        let tempResult;
        if (_places === 0) {
            tempResult = Math.round(absValue);
        }
        else {
            if (!Number.isInteger(_places)) {
                _places = Math.trunc(_places);
            }
            tempResult = Math.round(absValue * Math.pow(10, _places)) / Math.pow(10, _places);
        }
        return {
            value: _value >= 0 ? tempResult : -tempResult,
            format: value?.format,
        };
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// ROUNDDOWN
// -----------------------------------------------------------------------------
const ROUNDDOWN = {
    description: _t("Rounds down a number."),
    args: [
        arg("value (number)", _t("The value to round to places number of places, always rounding down.")),
        arg(`places (number, default=${DEFAULT_PLACES})`, _t("The number of decimal places to which to round.")),
    ],
    compute: function (value, places = { value: DEFAULT_PLACES }) {
        const _value = toNumber(value, this.locale);
        let _places = toNumber(places, this.locale);
        const absValue = Math.abs(_value);
        let tempResult;
        if (_places === 0) {
            tempResult = Math.floor(absValue);
        }
        else {
            if (!Number.isInteger(_places)) {
                _places = Math.trunc(_places);
            }
            tempResult = Math.floor(absValue * Math.pow(10, _places)) / Math.pow(10, _places);
        }
        return {
            value: _value >= 0 ? tempResult : -tempResult,
            format: value?.format,
        };
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// ROUNDUP
// -----------------------------------------------------------------------------
const ROUNDUP = {
    description: _t("Rounds up a number."),
    args: [
        arg("value (number)", _t("The value to round to places number of places, always rounding up.")),
        arg(`places (number, default=${DEFAULT_PLACES})`, _t("The number of decimal places to which to round.")),
    ],
    compute: function (value, places = { value: DEFAULT_PLACES }) {
        const _value = toNumber(value, this.locale);
        let _places = toNumber(places, this.locale);
        const absValue = Math.abs(_value);
        let tempResult;
        if (_places === 0) {
            tempResult = Math.ceil(absValue);
        }
        else {
            if (!Number.isInteger(_places)) {
                _places = Math.trunc(_places);
            }
            tempResult = Math.ceil(absValue * Math.pow(10, _places)) / Math.pow(10, _places);
        }
        return {
            value: _value >= 0 ? tempResult : -tempResult,
            format: value?.format,
        };
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// SEC
// -----------------------------------------------------------------------------
const SEC = {
    description: _t("Secant of an angle provided in radians."),
    args: [arg("angle (number)", _t("The angle to find the secant of, in radians."))],
    compute: function (angle) {
        return 1 / Math.cos(toNumber(angle, this.locale));
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// SECH
// -----------------------------------------------------------------------------
const SECH = {
    description: _t("Hyperbolic secant of any real number."),
    args: [arg("value (number)", _t("Any real value to calculate the hyperbolic secant of."))],
    compute: function (value) {
        return 1 / Math.cosh(toNumber(value, this.locale));
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// SEQUENCE
// -----------------------------------------------------------------------------
const SEQUENCE = {
    description: _t("Returns a sequence of numbers."),
    args: [
        arg("rows (number)", _t("The number of rows to return")),
        arg("columns (number, optional, default=1)", _t("The number of columns to return")),
        arg("start (number, optional, default=1)", _t("The first number in the sequence")),
        arg("step (number, optional, default=1)", _t("The amount to increment each value in the sequence")),
    ],
    compute: function (rows, columns = { value: 1 }, start = { value: 1 }, step = { value: 1 }) {
        const _start = toNumber(start, this.locale);
        const _step = toNumber(step, this.locale);
        const _rows = toInteger(rows, this.locale);
        const _columns = toInteger(columns, this.locale);
        assertPositive(_t("The number of columns (%s) must be positive.", _columns), _columns);
        assertPositive(_t("The number of rows (%s) must be positive.", _rows), _rows);
        return generateMatrix(_columns, _rows, (col, row) => {
            return {
                value: _start + row * _columns * _step + col * _step,
            };
        });
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// SIN
// -----------------------------------------------------------------------------
const SIN = {
    description: _t("Sine of an angle provided in radians."),
    args: [arg("angle (number)", _t("The angle to find the sine of, in radians."))],
    compute: function (angle) {
        return Math.sin(toNumber(angle, this.locale));
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// SINH
// -----------------------------------------------------------------------------
const SINH = {
    description: _t("Hyperbolic sine of any real number."),
    args: [arg("value (number)", _t("Any real value to calculate the hyperbolic sine of."))],
    compute: function (value) {
        return Math.sinh(toNumber(value, this.locale));
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// SQRT
// -----------------------------------------------------------------------------
const SQRT = {
    description: _t("Positive square root of a positive number."),
    args: [arg("value (number)", _t("The number for which to calculate the positive square root."))],
    compute: function (value) {
        const _value = toNumber(value, this.locale);
        assert(() => _value >= 0, _t("The value (%s) must be positive or null.", _value.toString()));
        return { value: Math.sqrt(_value), format: value?.format };
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// SUM
// -----------------------------------------------------------------------------
const SUM = {
    description: _t("Sum of a series of numbers and/or cells."),
    args: [
        arg("value1 (number, range<number>)", _t("The first number or range to add together.")),
        arg("value2 (number, range<number>, repeating)", _t("Additional numbers or ranges to add to value1.")),
    ],
    compute: function (...values) {
        const v1 = values[0];
        return {
            value: sum(values, this.locale),
            format: inferFormat(v1),
        };
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// SUMIF
// -----------------------------------------------------------------------------
const SUMIF = {
    description: _t("A conditional sum across a range."),
    args: [
        arg("criteria_range (range)", _t("The range which is tested against criterion.")),
        arg("criterion (string)", _t("The pattern or test to apply to range.")),
        arg("sum_range (range, default=criteria_range)", _t("The range to be summed, if different from range.")),
    ],
    compute: function (criteriaRange, criterion, sumRange) {
        if (sumRange === undefined) {
            sumRange = criteriaRange;
        }
        let sum = 0;
        visitMatchingRanges([criteriaRange, criterion], (i, j) => {
            const value = sumRange[i]?.[j]?.value;
            if (typeof value === "number") {
                sum += value;
            }
        }, this.locale);
        return sum;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// SUMIFS
// -----------------------------------------------------------------------------
const SUMIFS = {
    description: _t("Sums a range depending on multiple criteria."),
    args: [
        arg("sum_range (range)", _t("The range to sum.")),
        arg("criteria_range1 (range)", _t("The range to check against criterion1.")),
        arg("criterion1 (string)", _t("The pattern or test to apply to criteria_range1.")),
        arg("criteria_range2 (any, range, repeating)", _t("Additional ranges to check.")),
        arg("criterion2 (string, repeating)", _t("Additional criteria to check.")),
    ],
    compute: function (sumRange, ...criters) {
        let sum = 0;
        visitMatchingRanges(criters, (i, j) => {
            const value = sumRange[i]?.[j]?.value;
            if (typeof value === "number") {
                sum += value;
            }
        }, this.locale);
        return sum;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// TAN
// -----------------------------------------------------------------------------
const TAN = {
    description: _t("Tangent of an angle provided in radians."),
    args: [arg("angle (number)", _t("The angle to find the tangent of, in radians."))],
    compute: function (angle) {
        return Math.tan(toNumber(angle, this.locale));
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// TANH
// -----------------------------------------------------------------------------
const TANH = {
    description: _t("Hyperbolic tangent of any real number."),
    args: [arg("value (number)", _t("Any real value to calculate the hyperbolic tangent of."))],
    compute: function (value) {
        return Math.tanh(toNumber(value, this.locale));
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// TRUNC
// -----------------------------------------------------------------------------
function trunc(value, places) {
    if (places === 0) {
        return Math.trunc(value);
    }
    if (!Number.isInteger(places)) {
        places = Math.trunc(places);
    }
    return Math.trunc(value * Math.pow(10, places)) / Math.pow(10, places);
}
const TRUNC = {
    description: _t("Truncates a number."),
    args: [
        arg("value (number)", _t("The value to be truncated.")),
        arg(`places (number, default=${DEFAULT_PLACES})`, _t("The number of significant digits to the right of the decimal point to retain.")),
    ],
    compute: function (value, places = { value: DEFAULT_PLACES }) {
        const _value = toNumber(value, this.locale);
        const _places = toNumber(places, this.locale);
        return { value: trunc(_value, _places), format: value?.format };
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// INT
// -----------------------------------------------------------------------------
const INT = {
    description: _t("Rounds a number down to the nearest integer that is less than or equal to it."),
    args: [arg("value (number)", _t("The number to round down to the nearest integer."))],
    compute: function (value) {
        return Math.floor(toNumber(value, this.locale));
    },
    isExported: true,
};

var math = /*#__PURE__*/Object.freeze({
    __proto__: null,
    ABS: ABS,
    ACOS: ACOS,
    ACOSH: ACOSH,
    ACOT: ACOT,
    ACOTH: ACOTH,
    ASIN: ASIN,
    ASINH: ASINH,
    ATAN: ATAN,
    ATAN2: ATAN2,
    ATANH: ATANH,
    CEILING: CEILING,
    CEILING_MATH: CEILING_MATH,
    CEILING_PRECISE: CEILING_PRECISE,
    COS: COS,
    COSH: COSH,
    COT: COT,
    COTH: COTH,
    COUNTBLANK: COUNTBLANK,
    COUNTIF: COUNTIF,
    COUNTIFS: COUNTIFS,
    COUNTUNIQUE: COUNTUNIQUE,
    COUNTUNIQUEIFS: COUNTUNIQUEIFS,
    CSC: CSC,
    CSCH: CSCH,
    DECIMAL: DECIMAL,
    DEGREES: DEGREES,
    EXP: EXP,
    FLOOR: FLOOR,
    FLOOR_MATH: FLOOR_MATH,
    FLOOR_PRECISE: FLOOR_PRECISE,
    INT: INT,
    ISEVEN: ISEVEN,
    ISODD: ISODD,
    ISO_CEILING: ISO_CEILING,
    LN: LN,
    LOG: LOG,
    MOD: MOD,
    MUNIT: MUNIT,
    ODD: ODD,
    PI: PI,
    POWER: POWER,
    PRODUCT: PRODUCT,
    RAND: RAND,
    RANDARRAY: RANDARRAY,
    RANDBETWEEN: RANDBETWEEN,
    ROUND: ROUND,
    ROUNDDOWN: ROUNDDOWN,
    ROUNDUP: ROUNDUP,
    SEC: SEC,
    SECH: SECH,
    SEQUENCE: SEQUENCE,
    SIN: SIN,
    SINH: SINH,
    SQRT: SQRT,
    SUM: SUM,
    SUMIF: SUMIF,
    SUMIFS: SUMIFS,
    TAN: TAN,
    TANH: TANH,
    TRUNC: TRUNC
});

function filterAndFlatData(dataY, dataX) {
    const _flatDataY = [];
    const _flatDataX = [];
    let lenY = 0;
    let lenX = 0;
    visitAny([dataY], (y) => {
        _flatDataY.push(y);
        lenY += 1;
    });
    visitAny([dataX], (x) => {
        _flatDataX.push(x);
        lenX += 1;
    });
    assert(() => lenY === lenX, _t("[[FUNCTION_NAME]] has mismatched argument count %s vs %s.", lenY, lenX));
    const flatDataX = [];
    const flatDataY = [];
    for (let i = 0; i < lenY; i++) {
        const valueY = _flatDataY[i]?.value;
        const valueX = _flatDataX[i]?.value;
        if (typeof valueY === "number" && typeof valueX === "number") {
            flatDataY.push(valueY);
            flatDataX.push(valueX);
        }
    }
    return { flatDataX, flatDataY };
}
// Note: dataY and dataX may not have the same dimension
function covariance(dataY, dataX, isSample) {
    const { flatDataX, flatDataY } = filterAndFlatData(dataY, dataX);
    const count = flatDataY.length;
    assert(() => count !== 0 && (!isSample || count !== 1), _t("Evaluation of function [[FUNCTION_NAME]] caused a divide by zero error."), CellErrorType.DivisionByZero);
    let sumY = 0;
    let sumX = 0;
    for (let i = 0; i < count; i++) {
        sumY += flatDataY[i];
        sumX += flatDataX[i];
    }
    const averageY = sumY / count;
    const averageX = sumX / count;
    let acc = 0;
    for (let i = 0; i < count; i++) {
        acc += (flatDataY[i] - averageY) * (flatDataX[i] - averageX);
    }
    return acc / (count - (isSample ? 1 : 0));
}
function variance(args, isSample, textAs0, locale) {
    let count = 0;
    let sum = 0;
    const reduceFunction = textAs0 ? reduceNumbersTextAs0 : reduceNumbers;
    sum = reduceFunction(args, (acc, a) => {
        count += 1;
        return acc + a;
    }, 0, locale);
    assert(() => count !== 0 && (!isSample || count !== 1), _t("Evaluation of function [[FUNCTION_NAME]] caused a divide by zero error."), CellErrorType.DivisionByZero);
    const average = sum / count;
    return (reduceFunction(args, (acc, a) => acc + Math.pow(a - average, 2), 0, locale) /
        (count - (isSample ? 1 : 0)));
}
function centile(data, percent, isInclusive, locale) {
    const _percent = toNumber(percent, locale);
    assert(() => (isInclusive ? 0 <= _percent && _percent <= 1 : 0 < _percent && _percent < 1), _t("Function [[FUNCTION_NAME]] parameter 2 value is out of range."));
    let sortedArray = [];
    let index;
    let count = 0;
    visitAny(data, (d) => {
        const value = d?.value;
        if (typeof value === "number") {
            index = dichotomicSearch(sortedArray, d, "nextSmaller", "asc", sortedArray.length, (array, i) => array[i]);
            sortedArray.splice(index + 1, 0, value);
            count++;
        }
    });
    assert(() => count !== 0, _t("[[FUNCTION_NAME]] has no valid input data."));
    if (!isInclusive) {
        // 2nd argument must be between 1/(n+1) and n/(n+1) with n the number of data
        assert(() => 1 / (count + 1) <= _percent && _percent <= count / (count + 1), _t("Function [[FUNCTION_NAME]] parameter 2 value is out of range."));
    }
    return percentile(sortedArray, _percent, isInclusive);
}
// -----------------------------------------------------------------------------
// AVEDEV
// -----------------------------------------------------------------------------
const AVEDEV = {
    description: _t("Average magnitude of deviations from mean."),
    args: [
        arg("value1 (number, range<number>)", _t("The first value or range of the sample.")),
        arg("value2 (number, range<number>, repeating)", _t("Additional values or ranges to include in the sample.")),
    ],
    compute: function (...values) {
        let count = 0;
        const sum = reduceNumbers(values, (acc, a) => {
            count += 1;
            return acc + a;
        }, 0, this.locale);
        assertNotZero(count);
        const average = sum / count;
        return reduceNumbers(values, (acc, a) => acc + Math.abs(average - a), 0, this.locale) / count;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// AVERAGE
// -----------------------------------------------------------------------------
const AVERAGE = {
    description: _t("Numerical average value in a dataset, ignoring text."),
    args: [
        arg("value1 (number, range<number>)", _t("The first value or range to consider when calculating the average value.")),
        arg("value2 (number, range<number>, repeating)", _t("Additional values or ranges to consider when calculating the average value.")),
    ],
    compute: function (...values) {
        return {
            value: average(values, this.locale),
            format: inferFormat(values[0]),
        };
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// AVERAGE.WEIGHTED
// -----------------------------------------------------------------------------
const rangeError = _t("[[FUNCTION_NAME]] has mismatched range sizes.");
const negativeWeightError = _t("[[FUNCTION_NAME]] expects the weight to be positive or equal to 0.");
const AVERAGE_WEIGHTED = {
    description: _t("Weighted average."),
    args: [
        arg("values (number, range<number>)", _t("Values to average.")),
        arg("weights (number, range<number>)", _t("Weights for each corresponding value.")),
        arg("additional_values (number, range<number>, repeating)", _t("Additional values to average.")),
        arg("additional_weights (number, range<number>, repeating)", _t("Additional weights.")),
    ],
    compute: function (...args) {
        let sum = 0;
        let count = 0;
        for (let n = 0; n < args.length - 1; n += 2) {
            const argN = args[n];
            const argN1 = args[n + 1];
            assertSameDimensions(rangeError, argN, argN1);
            if (isMatrix(argN)) {
                for (let i = 0; i < argN.length; i++) {
                    for (let j = 0; j < argN[0].length; j++) {
                        const value = argN[i][j].value;
                        const weight = isMatrix(argN1) ? argN1?.[i][j].value : toNumber(argN1, this.locale);
                        const valueIsNumber = typeof value === "number";
                        const weightIsNumber = typeof weight === "number";
                        if (valueIsNumber && weightIsNumber) {
                            assert(() => weight >= 0, negativeWeightError);
                            sum += value * weight;
                            count += weight;
                            continue;
                        }
                        assert(() => valueIsNumber === weightIsNumber, _t("[[FUNCTION_NAME]] expects number values."));
                    }
                }
            }
            else {
                const value = toNumber(argN, this.locale);
                const weight = isMatrix(argN1) ? argN1?.[0][0].value : toNumber(argN1, this.locale);
                if (typeof weight === "number") {
                    assert(() => weight >= 0, negativeWeightError);
                    sum += value * weight;
                    count += weight;
                }
            }
        }
        assertNotZero(count);
        return { value: sum / count, format: inferFormat(args[0]) };
    },
};
// -----------------------------------------------------------------------------
// AVERAGEA
// -----------------------------------------------------------------------------
const AVERAGEA = {
    description: _t("Numerical average value in a dataset."),
    args: [
        arg("value1 (number, range<number>)", _t("The first value or range to consider when calculating the average value.")),
        arg("value2 (number, range<number>, repeating)", _t("Additional values or ranges to consider when calculating the average value.")),
    ],
    compute: function (...args) {
        let count = 0;
        const sum = reduceNumbersTextAs0(args, (acc, a) => {
            count += 1;
            return acc + a;
        }, 0, this.locale);
        assertNotZero(count);
        return {
            value: sum / count,
            format: inferFormat(args[0]),
        };
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// AVERAGEIF
// -----------------------------------------------------------------------------
const AVERAGEIF = {
    description: _t("Average of values depending on criteria."),
    args: [
        arg("criteria_range (number, range<number>)", _t("The range to check against criterion.")),
        arg("criterion (string)", _t("The pattern or test to apply to criteria_range.")),
        arg("average_range (number, range<number>, default=criteria_range)", _t("The range to average. If not included, criteria_range is used for the average instead.")),
    ],
    compute: function (criteriaRange, criterion, averageRange) {
        const _averageRange = averageRange === undefined ? toMatrix(criteriaRange) : toMatrix(averageRange);
        let count = 0;
        let sum = 0;
        visitMatchingRanges([criteriaRange, criterion], (i, j) => {
            const value = _averageRange[i]?.[j]?.value;
            if (typeof value === "number") {
                count += 1;
                sum += value;
            }
        }, this.locale);
        assertNotZero(count);
        return sum / count;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// AVERAGEIFS
// -----------------------------------------------------------------------------
const AVERAGEIFS = {
    description: _t("Average of values depending on multiple criteria."),
    args: [
        arg("average_range (range)", _t("The range to average.")),
        arg("criteria_range1 (range)", _t("The range to check against criterion1.")),
        arg("criterion1 (string)", _t("The pattern or test to apply to criteria_range1.")),
        arg("criteria_range2 (any, range, repeating)", _t("Additional criteria_range and criterion to check.")),
        arg("criterion2 (string, repeating)", _t("The pattern or test to apply to criteria_range2.")),
    ],
    compute: function (averageRange, ...args) {
        const _averageRange = toMatrix(averageRange);
        let count = 0;
        let sum = 0;
        visitMatchingRanges(args, (i, j) => {
            const value = _averageRange[i]?.[j]?.value;
            if (typeof value === "number") {
                count += 1;
                sum += value;
            }
        }, this.locale);
        assertNotZero(count);
        return sum / count;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// COUNT
// -----------------------------------------------------------------------------
const COUNT = {
    description: _t("The number of numeric values in dataset."),
    args: [
        arg("value1 (number, any, range<number>)", _t("The first value or range to consider when counting.")),
        arg("value2 (number, any, range<number>, repeating)", _t("Additional values or ranges to consider when counting.")),
    ],
    compute: function (...values) {
        return countNumbers(values, this.locale);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// COUNTA
// -----------------------------------------------------------------------------
const COUNTA = {
    description: _t("The number of values in a dataset."),
    args: [
        arg("value1 (any, range)", _t("The first value or range to consider when counting.")),
        arg("value2 (any, range, repeating)", _t("Additional values or ranges to consider when counting.")),
    ],
    compute: function (...values) {
        return countAny(values);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// COVAR
// -----------------------------------------------------------------------------
// Note: Unlike the VAR function which corresponds to the variance over a sample (VAR.S),
// the COVAR function corresponds to the covariance over an entire population (COVAR.P)
const COVAR = {
    description: _t("The covariance of a dataset."),
    args: [
        arg("data_y (any, range)", _t("The range representing the array or matrix of dependent data.")),
        arg("data_x (any, range)", _t("The range representing the array or matrix of independent data.")),
    ],
    compute: function (dataY, dataX) {
        return covariance(dataY, dataX, false);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// COVARIANCE.P
// -----------------------------------------------------------------------------
const COVARIANCE_P = {
    description: _t("The covariance of a dataset."),
    args: [
        arg("data_y (any, range)", _t("The range representing the array or matrix of dependent data.")),
        arg("data_x (any, range)", _t("The range representing the array or matrix of independent data.")),
    ],
    compute: function (dataY, dataX) {
        return covariance(dataY, dataX, false);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// COVARIANCE.S
// -----------------------------------------------------------------------------
const COVARIANCE_S = {
    description: _t("The sample covariance of a dataset."),
    args: [
        arg("data_y (any, range)", _t("The range representing the array or matrix of dependent data.")),
        arg("data_x (any, range)", _t("The range representing the array or matrix of independent data.")),
    ],
    compute: function (dataY, dataX) {
        return covariance(dataY, dataX, true);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// FORECAST
// -----------------------------------------------------------------------------
const FORECAST = {
    description: _t("Calculates the expected y-value for a specified x based on a linear regression of a dataset."),
    args: [
        arg("x (number, range<number>)", _t("The value(s) on the x-axis to forecast.")),
        arg("data_y (range<number>)", _t("The range representing the array or matrix of dependent data.")),
        arg("data_x (range<number>)", _t("The range representing the array or matrix of independent data.")),
    ],
    compute: function (x, dataY, dataX) {
        const { flatDataX, flatDataY } = filterAndFlatData(dataY, dataX);
        return predictLinearValues([flatDataY], [flatDataX], matrixMap(toMatrix(x), (value) => toNumber(value, this.locale)), true);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// GROWTH
// -----------------------------------------------------------------------------
const GROWTH = {
    description: _t("Fits points to exponential growth trend."),
    args: [
        arg("known_data_y (range<number>)", _t("The array or range containing dependent (y) values that are already known, used to curve fit an ideal exponential growth curve.")),
        arg("known_data_x (range<number>, default={1;2;3;...})", _t("The values of the independent variable(s) corresponding with known_data_y.")),
        arg("new_data_x (any, range, default=known_data_x)", _t("The data points to return the y values for on the ideal curve fit.")),
        arg("b (boolean, default=TRUE)", _t("Given a general exponential form of y = b*m^x for a curve fit, calculates b if TRUE or forces b to be 1 and only calculates the m values if FALSE.")),
    ],
    compute: function (knownDataY, knownDataX = [[]], newDataX = [[]], b = { value: true }) {
        return expM(predictLinearValues(logM(toNumberMatrix(knownDataY, "the first argument (known_data_y)")), toNumberMatrix(knownDataX, "the second argument (known_data_x)"), toNumberMatrix(newDataX, "the third argument (new_data_y)"), toBoolean(b)));
    },
};
// -----------------------------------------------------------------------------
// INTERCEPT
// -----------------------------------------------------------------------------
const INTERCEPT = {
    description: _t("Compute the intercept of the linear regression."),
    args: [
        arg("data_y (range<number>)", _t("The range representing the array or matrix of dependent data.")),
        arg("data_x (range<number>)", _t("The range representing the array or matrix of independent data.")),
    ],
    compute: function (dataY, dataX) {
        const { flatDataX, flatDataY } = filterAndFlatData(dataY, dataX);
        const [[], [intercept]] = fullLinearRegression([flatDataX], [flatDataY]);
        return intercept;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// LARGE
// -----------------------------------------------------------------------------
const LARGE = {
    description: _t("Nth largest element from a data set."),
    args: [
        arg("data (any, range)", _t("Array or range containing the dataset to consider.")),
        arg("n (number)", _t("The rank from largest to smallest of the element to return.")),
    ],
    compute: function (data, n) {
        const _n = Math.trunc(toNumber(n?.value, this.locale));
        let largests = [];
        let index;
        let count = 0;
        visitAny([data], (d) => {
            if (typeof d?.value === "number") {
                index = dichotomicSearch(largests, d, "nextSmaller", "asc", largests.length, (array, i) => array[i].value);
                largests.splice(index + 1, 0, d);
                count++;
                if (count > _n) {
                    largests.shift();
                    count--;
                }
            }
        });
        const result = largests.shift();
        assert(() => result !== undefined, _t("[[FUNCTION_NAME]] has no valid input data."));
        assert(() => count >= _n, _t("Function [[FUNCTION_NAME]] parameter 2 value (%s) is out of range.", _n));
        return result;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// LINEST
// -----------------------------------------------------------------------------
const LINEST = {
    description: _t("Given partial data about a linear trend, calculates various parameters about the ideal linear trend using the least-squares method."),
    args: [
        arg("data_y (range<number>)", _t("The range representing the array or matrix of dependent data.")),
        arg("data_x (range<number>, default={1;2;3;...})", _t("The range representing the array or matrix of independent data.")),
        arg("calculate_b (boolean, default=TRUE)", _t("A flag specifying wheter to compute the slope or not")),
        arg("verbose (boolean, default=FALSE)", _t("A flag specifying whether to return additional regression statistics or only the linear coefficients and the y-intercept")),
    ],
    compute: function (dataY, dataX = [[]], calculateB = { value: true }, verbose = { value: false }) {
        return fullLinearRegression(toNumberMatrix(dataX, "the first argument (data_y)"), toNumberMatrix(dataY, "the second argument (data_x)"), toBoolean(calculateB), toBoolean(verbose));
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// LOGEST
// -----------------------------------------------------------------------------
const LOGEST = {
    description: _t("Given partial data about an exponential growth curve, calculates various parameters about the best fit ideal exponential growth curve."),
    args: [
        arg("data_y (range<number>)", _t("The range representing the array or matrix of dependent data.")),
        arg("data_x (range<number>, optional, default={1;2;3;...})", _t("The range representing the array or matrix of independent data.")),
        arg("calculate_b (boolean, default=TRUE)", _t("A flag specifying wheter to compute the slope or not")),
        arg("verbose (boolean, default=FALSE)", _t("A flag specifying whether to return additional regression statistics or only the linear coefficients and the y-intercept")),
    ],
    compute: function (dataY, dataX = [[]], calculateB = { value: true }, verbose = { value: false }) {
        const coeffs = fullLinearRegression(toNumberMatrix(dataX, "the second argument (data_x)"), logM(toNumberMatrix(dataY, "the first argument (data_y)")), toBoolean(calculateB), toBoolean(verbose));
        for (let i = 0; i < coeffs.length; i++) {
            coeffs[i][0] = Math.exp(coeffs[i][0]);
        }
        return coeffs;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// MATTHEWS
// -----------------------------------------------------------------------------
const MATTHEWS = {
    description: _t("Compute the Matthews correlation coefficient of a dataset."),
    args: [
        arg("data_x (range)", _t("The range representing the array or matrix of observed data.")),
        arg("data_y (range)", _t("The range representing the array or matrix of predicted data.")),
    ],
    compute: function (dataX, dataY) {
        const flatX = dataX.flat();
        const flatY = dataY.flat();
        assertSameNumberOfElements(flatX, flatY);
        if (flatX.length === 0) {
            throw new EvaluationError(_t("[[FUNCTION_NAME]] expects non-empty ranges for both parameters."));
        }
        const n = flatX.length;
        let trueN = 0, trueP = 0, falseP = 0, falseN = 0;
        for (let i = 0; i < n; ++i) {
            const isTrue1 = toBoolean(flatX[i]);
            const isTrue2 = toBoolean(flatY[i]);
            if (isTrue1 === isTrue2) {
                if (isTrue1) {
                    trueP++;
                }
                else {
                    trueN++;
                }
            }
            else {
                if (isTrue1) {
                    falseN++;
                }
                else {
                    falseP++;
                }
            }
        }
        return ((trueP * trueN - falseP * falseN) /
            Math.sqrt((trueP + falseP) * (trueP + falseN) * (trueN + falseP) * (trueN + falseN)));
    },
    isExported: false,
};
// -----------------------------------------------------------------------------
// MAX
// -----------------------------------------------------------------------------
const MAX = {
    description: _t("Maximum value in a numeric dataset."),
    args: [
        arg("value1 (number, range<number>)", _t("The first value or range to consider when calculating the maximum value.")),
        arg("value2 (number, range<number>, repeating)", _t("Additional values or ranges to consider when calculating the maximum value.")),
    ],
    compute: function (...values) {
        return max(values, this.locale);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// MAXA
// -----------------------------------------------------------------------------
const MAXA = {
    description: _t("Maximum numeric value in a dataset."),
    args: [
        arg("value1 (any, range)", _t("The first value or range to consider when calculating the maximum value.")),
        arg("value2 (any, range, repeating)", _t("Additional values or ranges to consider when calculating the maximum value.")),
    ],
    compute: function (...args) {
        const maxa = reduceNumbersTextAs0(args, (acc, a) => {
            return Math.max(a, acc);
        }, -Infinity, this.locale);
        return { value: maxa === -Infinity ? 0 : maxa, format: inferFormat(args[0]) };
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// MAXIFS
// -----------------------------------------------------------------------------
const MAXIFS = {
    description: _t("Returns the maximum value in a range of cells, filtered by a set of criteria."),
    args: [
        arg("range (range)", _t("The range of cells from which the maximum will be determined.")),
        arg("criteria_range1 (range)", _t("The range of cells over which to evaluate criterion1.")),
        arg("criterion1 (string)", _t("The pattern or test to apply to criteria_range1, such that each cell that evaluates to TRUE will be included in the filtered set.")),
        arg("criteria_range2 (any, range, repeating)", _t("Additional ranges over which to evaluate the additional criteria. The filtered set will be the intersection of the sets produced by each criterion-range pair.")),
        arg("criterion2 (string, repeating)", _t("The pattern or test to apply to criteria_range2.")),
    ],
    compute: function (range, ...args) {
        let result = -Infinity;
        visitMatchingRanges(args, (i, j) => {
            const value = range[i]?.[j]?.value;
            if (typeof value === "number") {
                result = result < value ? value : result;
            }
        }, this.locale);
        return result === -Infinity ? 0 : result;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// MEDIAN
// -----------------------------------------------------------------------------
const MEDIAN = {
    description: _t("Median value in a numeric dataset."),
    args: [
        arg("value1 (any, range)", _t("The first value or range to consider when calculating the median value.")),
        arg("value2 (any, range, repeating)", _t("Additional values or ranges to consider when calculating the median value.")),
    ],
    compute: function (...values) {
        let data = [];
        visitNumbers(values, (value) => {
            data.push(value);
        }, this.locale);
        return {
            value: centile(data, { value: 0.5 }, true, this.locale),
            format: inferFormat(data[0]),
        };
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// MIN
// -----------------------------------------------------------------------------
const MIN = {
    description: _t("Minimum value in a numeric dataset."),
    args: [
        arg("value1 (number, range<number>)", _t("The first value or range to consider when calculating the minimum value.")),
        arg("value2 (number, range<number>, repeating)", _t("Additional values or ranges to consider when calculating the minimum value.")),
    ],
    compute: function (...values) {
        return min(values, this.locale);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// MINA
// -----------------------------------------------------------------------------
const MINA = {
    description: _t("Minimum numeric value in a dataset."),
    args: [
        arg("value1 (number, range<number>)", _t("The first value or range to consider when calculating the minimum value.")),
        arg("value2 (number, range<number>, repeating)", _t("Additional values or ranges to consider when calculating the minimum value.")),
    ],
    compute: function (...args) {
        const mina = reduceNumbersTextAs0(args, (acc, a) => {
            return Math.min(a, acc);
        }, Infinity, this.locale);
        return { value: mina === Infinity ? 0 : mina, format: inferFormat(args[0]) };
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// MINIFS
// -----------------------------------------------------------------------------
const MINIFS = {
    description: _t("Returns the minimum value in a range of cells, filtered by a set of criteria."),
    args: [
        arg("range (range)", _t("The range of cells from which the minimum will be determined.")),
        arg("criteria_range1 (range)", _t("The range of cells over which to evaluate criterion1.")),
        arg("criterion1 (string)", _t("The pattern or test to apply to criteria_range1, such that each cell that evaluates to TRUE will be included in the filtered set.")),
        arg("criteria_range2 (any, range, repeating)", _t("Additional ranges over which to evaluate the additional criteria. The filtered set will be the intersection of the sets produced by each criterion-range pair.")),
        arg("criterion2 (string, repeating)", _t("The pattern or test to apply to criteria_range2.")),
    ],
    compute: function (range, ...args) {
        let result = Infinity;
        visitMatchingRanges(args, (i, j) => {
            const value = range[i]?.[j]?.value;
            if (typeof value === "number") {
                result = result > value ? value : result;
            }
        }, this.locale);
        return result === Infinity ? 0 : result;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// PEARSON
// -----------------------------------------------------------------------------
function pearson(dataY, dataX) {
    const { flatDataX, flatDataY } = filterAndFlatData(dataY, dataX);
    if (flatDataX.length === 0) {
        throw new EvaluationError(_t("[[FUNCTION_NAME]] expects non-empty ranges for both parameters."));
    }
    if (flatDataX.length < 2) {
        throw new EvaluationError(_t("[[FUNCTION_NAME]] needs at least two values for both parameters."));
    }
    const n = flatDataX.length;
    let sumX = 0, sumY = 0, sumXY = 0, sumXX = 0, sumYY = 0;
    for (let i = 0; i < n; i++) {
        const xij = flatDataX[i];
        const yij = flatDataY[i];
        sumX += xij;
        sumY += yij;
        sumXY += xij * yij;
        sumXX += xij * xij;
        sumYY += yij * yij;
    }
    return ((n * sumXY - sumX * sumY) / Math.sqrt((n * sumXX - sumX * sumX) * (n * sumYY - sumY * sumY)));
}
const PEARSON = {
    description: _t("Compute the Pearson product-moment correlation coefficient of a dataset."),
    args: [
        arg("data_y (range<number>)", _t("The range representing the array or matrix of dependent data.")),
        arg("data_x (range<number>)", _t("The range representing the array or matrix of independent data.")),
    ],
    compute: function (dataY, dataX) {
        return pearson(dataY, dataX);
    },
    isExported: true,
};
// CORREL
// In GSheet, CORREL is just an alias to PEARSON
const CORREL = PEARSON;
// -----------------------------------------------------------------------------
// PERCENTILE
// -----------------------------------------------------------------------------
const PERCENTILE = {
    description: _t("Value at a given percentile of a dataset."),
    args: [
        arg("data (any, range)", _t("The array or range containing the dataset to consider.")),
        arg("percentile (number)", _t("The percentile whose value within data will be calculated and returned.")),
    ],
    compute: function (data, percentile) {
        return PERCENTILE_INC.compute.bind(this)(data, percentile);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// PERCENTILE.EXC
// -----------------------------------------------------------------------------
const PERCENTILE_EXC = {
    description: _t("Value at a given percentile of a dataset exclusive of 0 and 1."),
    args: [
        arg("data (any, range)", _t("The array or range containing the dataset to consider.")),
        arg("percentile (number)", _t("The percentile, exclusive of 0 and 1, whose value within 'data' will be calculated and returned.")),
    ],
    compute: function (data, percentile) {
        return {
            value: centile([data], percentile, false, this.locale),
            format: inferFormat(data),
        };
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// PERCENTILE.INC
// -----------------------------------------------------------------------------
const PERCENTILE_INC = {
    description: _t("Value at a given percentile of a dataset."),
    args: [
        arg("data (any, range)", _t("The array or range containing the dataset to consider.")),
        arg("percentile (number)", _t("The percentile whose value within data will be calculated and returned.")),
    ],
    compute: function (data, percentile) {
        return {
            value: centile([data], percentile, true, this.locale),
            format: inferFormat(data),
        };
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// POLYFIT
// -----------------------------------------------------------------------------
const POLYFIT_COEFFS = {
    description: _t("Compute the coefficients of polynomial regression of the dataset."),
    args: [
        arg("data_y (range<number>)", _t("The range representing the array or matrix of dependent data.")),
        arg("data_x (range<number>)", _t("The range representing the array or matrix of independent data.")),
        arg("order (number)", _t("The order of the polynomial to fit the data, between 1 and 6.")),
        arg("intercept (boolean, default=TRUE)", _t("A flag specifying whether to compute the intercept or not.")),
    ],
    compute: function (dataY, dataX, order, intercept = { value: true }) {
        const { flatDataX, flatDataY } = filterAndFlatData(dataY, dataX);
        return polynomialRegression(flatDataY, flatDataX, toNumber(order, this.locale), toBoolean(intercept));
    },
    isExported: false,
};
// -----------------------------------------------------------------------------
// POLYFIT.FORECAST
// -----------------------------------------------------------------------------
const POLYFIT_FORECAST = {
    description: _t("Predict value by computing a polynomial regression of the dataset."),
    args: [
        arg("x (number, range<number>)", _t("The value(s) on the x-axis to forecast.")),
        arg("data_y (range<number>)", _t("The range representing the array or matrix of dependent data.")),
        arg("data_x (range<number>)", _t("The range representing the array or matrix of independent data.")),
        arg("order (number)", _t("The order of the polynomial to fit the data, between 1 and 6.")),
        arg("intercept (boolean, default=TRUE)", _t("A flag specifying whether to compute the intercept or not.")),
    ],
    compute: function (x, dataY, dataX, order, intercept = { value: true }) {
        const _order = toNumber(order, this.locale);
        const { flatDataX, flatDataY } = filterAndFlatData(dataY, dataX);
        const coeffs = polynomialRegression(flatDataY, flatDataX, _order, toBoolean(intercept)).flat();
        return matrixMap(toMatrix(x), (xij) => evaluatePolynomial(coeffs, toNumber(xij, this.locale), _order));
    },
    isExported: false,
};
// -----------------------------------------------------------------------------
// QUARTILE
// -----------------------------------------------------------------------------
const QUARTILE = {
    description: _t("Value nearest to a specific quartile of a dataset."),
    args: [
        arg("data (any, range)", _t("The array or range containing the dataset to consider.")),
        arg("quartile_number (number)", _t("Which quartile value to return.")),
    ],
    compute: function (data, quartileNumber) {
        return QUARTILE_INC.compute.bind(this)(data, quartileNumber);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// QUARTILE.EXC
// -----------------------------------------------------------------------------
const QUARTILE_EXC = {
    description: _t("Value nearest to a specific quartile of a dataset exclusive of 0 and 4."),
    args: [
        arg("data (any, range)", _t("The array or range containing the dataset to consider.")),
        arg("quartile_number (number)", _t("Which quartile value, exclusive of 0 and 4, to return.")),
    ],
    compute: function (data, quartileNumber) {
        const _quartileNumber = Math.trunc(toNumber(quartileNumber, this.locale));
        const percent = { value: 0.25 * _quartileNumber };
        return {
            value: centile([data], percent, false, this.locale),
            format: inferFormat(data),
        };
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// QUARTILE.INC
// -----------------------------------------------------------------------------
const QUARTILE_INC = {
    description: _t("Value nearest to a specific quartile of a dataset."),
    args: [
        arg("data (any, range)", _t("The array or range containing the dataset to consider.")),
        arg("quartile_number (number)", _t("Which quartile value to return.")),
    ],
    compute: function (data, quartileNumber) {
        const percent = { value: 0.25 * Math.trunc(toNumber(quartileNumber, this.locale)) };
        return {
            value: centile([data], percent, true, this.locale),
            format: inferFormat(data),
        };
    },
    isExported: true,
};
// RANK
// -----------------------------------------------------------------------------
const RANK = {
    description: _t("Returns the rank of a specified value in a dataset."),
    args: [
        arg("value (number)", _t("The value whose rank will be determined.")),
        arg("data (range)", _t("The range containing the dataset to consider.")),
        arg("is_ascending (boolean, default=FALSE)", _t("Whether to consider the values in data in descending or ascending order.")),
    ],
    compute: function (value, data, isAscending = { value: false }) {
        const _isAscending = toBoolean(isAscending);
        const _value = toNumber(value, this.locale);
        let rank = 1;
        let found = false;
        for (const row of data) {
            for (const cell of row) {
                if (typeof cell.value !== "number") {
                    continue;
                }
                const _cell = toNumber(cell, this.locale);
                if (_cell === _value) {
                    found = true;
                }
                else if (_cell > _value !== _isAscending) {
                    rank++;
                }
            }
        }
        if (!found) {
            throw new NotAvailableError(_t("Value not found in the given data."));
        }
        return rank;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// RSQ
// -----------------------------------------------------------------------------
const RSQ = {
    description: _t("Compute the square of r, the Pearson product-moment correlation coefficient of a dataset."),
    args: [
        arg("data_y (range<number>)", _t("The range representing the array or matrix of dependent data.")),
        arg("data_x (range<number>)", _t("The range representing the array or matrix of independent data.")),
    ],
    compute: function (dataY, dataX) {
        return Math.pow(pearson(dataX, dataY), 2.0);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// SLOPE
// -----------------------------------------------------------------------------
const SLOPE = {
    description: _t("Compute the slope of the linear regression."),
    args: [
        arg("data_y (range<number>)", _t("The range representing the array or matrix of dependent data.")),
        arg("data_x (range<number>)", _t("The range representing the array or matrix of independent data.")),
    ],
    compute: function (dataY, dataX) {
        const { flatDataX, flatDataY } = filterAndFlatData(dataY, dataX);
        const [[slope]] = fullLinearRegression([flatDataX], [flatDataY]);
        return slope;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// SMALL
// -----------------------------------------------------------------------------
const SMALL = {
    description: _t("Nth smallest element in a data set."),
    args: [
        arg("data (any, range)", _t("The array or range containing the dataset to consider.")),
        arg("n (number)", _t("The rank from smallest to largest of the element to return.")),
    ],
    compute: function (data, n) {
        const _n = Math.trunc(toNumber(n?.value, this.locale));
        let largests = [];
        let index;
        let count = 0;
        visitAny([data], (d) => {
            if (typeof d?.value === "number") {
                index = dichotomicSearch(largests, d, "nextSmaller", "asc", largests.length, (array, i) => array[i].value);
                largests.splice(index + 1, 0, d);
                count++;
                if (count > _n) {
                    largests.pop();
                    count--;
                }
            }
        });
        const result = largests.pop();
        assert(() => result !== undefined, _t("[[FUNCTION_NAME]] has no valid input data."));
        assert(() => count >= _n, _t("Function [[FUNCTION_NAME]] parameter 2 value (%s) is out of range.", _n));
        return result;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// SPEARMAN
// -----------------------------------------------------------------------------
const SPEARMAN = {
    description: _t("Compute the Spearman rank correlation coefficient of a dataset."),
    args: [
        arg("data_y (range<number>)", _t("The range representing the array or matrix of dependent data.")),
        arg("data_x (range<number>)", _t("The range representing the array or matrix of independent data.")),
    ],
    compute: function (dataX, dataY) {
        const { flatDataX, flatDataY } = filterAndFlatData(dataY, dataX);
        const n = flatDataX.length;
        const order = flatDataX.map((e, i) => [e, flatDataY[i]]);
        order.sort((a, b) => a[0] - b[0]);
        for (let i = 0; i < n; ++i) {
            order[i][0] = i;
        }
        order.sort((a, b) => a[1] - b[1]);
        let sum = 0.0;
        for (let i = 0; i < n; ++i) {
            sum += (order[i][0] - i) ** 2;
        }
        return 1 - (6 * sum) / (n ** 3 - n);
    },
    isExported: false,
};
// -----------------------------------------------------------------------------
// STDEV
// -----------------------------------------------------------------------------
const STDEV = {
    description: _t("Standard deviation."),
    args: [
        arg("value1 (number, range<number>)", _t("The first value or range of the sample.")),
        arg("value2 (number, range<number>, repeating)", _t("Additional values or ranges to include in the sample.")),
    ],
    compute: function (...args) {
        return Math.sqrt(VAR.compute.bind(this)(...args));
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// STDEV.P
// -----------------------------------------------------------------------------
const STDEV_P = {
    description: _t("Standard deviation of entire population."),
    args: [
        arg("value1 (number, range<number>)", _t("The first value or range of the population.")),
        arg("value2 (number, range<number>, repeating)", _t("Additional values or ranges to include in the population.")),
    ],
    compute: function (...args) {
        return Math.sqrt(VAR_P.compute.bind(this)(...args));
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// STDEV.S
// -----------------------------------------------------------------------------
const STDEV_S = {
    description: _t("Standard deviation."),
    args: [
        arg("value1 (number, range<number>)", _t("The first value or range of the sample.")),
        arg("value2 (number, range<number>, repeating)", _t("Additional values or ranges to include in the sample.")),
    ],
    compute: function (...args) {
        return Math.sqrt(VAR_S.compute.bind(this)(...args));
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// STDEVA
// -----------------------------------------------------------------------------
const STDEVA = {
    description: _t("Standard deviation of sample (text as 0)."),
    args: [
        arg("value1 (number, range<number>)", _t("The first value or range of the sample.")),
        arg("value2 (number, range<number>, repeating)", _t("Additional values or ranges to include in the sample.")),
    ],
    compute: function (...args) {
        return Math.sqrt(VARA.compute.bind(this)(...args));
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// STDEVP
// -----------------------------------------------------------------------------
const STDEVP = {
    description: _t("Standard deviation of entire population."),
    args: [
        arg("value1 (number, range<number>)", _t("The first value or range of the population.")),
        arg("value2 (number, range<number>, repeating)", _t("Additional values or ranges to include in the population.")),
    ],
    compute: function (...args) {
        return Math.sqrt(VARP.compute.bind(this)(...args));
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// STDEVPA
// -----------------------------------------------------------------------------
const STDEVPA = {
    description: _t("Standard deviation of entire population (text as 0)."),
    args: [
        arg("value1 (number, range<number>)", _t("The first value or range of the population.")),
        arg("value2 (number, range<number>, repeating)", _t("Additional values or ranges to include in the population.")),
    ],
    compute: function (...args) {
        return Math.sqrt(VARPA.compute.bind(this)(...args));
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// STEYX
// -----------------------------------------------------------------------------
const STEYX = {
    description: _t("Calculates the standard error of the predicted y-value for each x in the regression of a dataset."),
    args: [
        arg("data_y (range<number>)", _t("The range representing the array or matrix of dependent data.")),
        arg("data_x (range<number>)", _t("The range representing the array or matrix of independent data.")),
    ],
    compute: function (dataY, dataX) {
        const { flatDataX, flatDataY } = filterAndFlatData(dataY, dataX);
        const data = fullLinearRegression([flatDataX], [flatDataY], true, true);
        return data[1][2];
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// TREND
// -----------------------------------------------------------------------------
const TREND = {
    description: _t("Fits points to linear trend derived via least-squares."),
    args: [
        arg("known_data_y (number, range<number>)", _t("The array or range containing dependent (y) values that are already known, used to curve fit an ideal linear trend.")),
        arg("known_data_x (number, range<number>, optional, default={1;2;3;...})", _t("The values of the independent variable(s) corresponding with known_data_y.")),
        arg("new_data_x (number, range<number>, optional, default=known_data_x)", _t("The data points to return the y values for on the ideal curve fit.")),
        arg("b (boolean, optional, default=TRUE)", _t("Given a general linear form of y = m*x+b for a curve fit, calculates b if TRUE or forces b to be 0 and only calculates the m values if FALSE, i.e. forces the curve fit to pass through the origin.")),
    ],
    compute: function (knownDataY, knownDataX = [[]], newDataX = [[]], b = { value: true }) {
        return predictLinearValues(toNumberMatrix(knownDataY, "the first argument (known_data_y)"), toNumberMatrix(knownDataX, "the second argument (known_data_x)"), toNumberMatrix(newDataX, "the third argument (new_data_y)"), toBoolean(b));
    },
};
// -----------------------------------------------------------------------------
// VAR
// -----------------------------------------------------------------------------
const VAR = {
    description: _t("Variance."),
    args: [
        arg("value1 (number, range<number>)", _t("The first value or range of the sample.")),
        arg("value2 (number, range<number>, repeating)", _t("Additional values or ranges to include in the sample.")),
    ],
    compute: function (...args) {
        return variance(args, true, false, this.locale);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// VAR.P
// -----------------------------------------------------------------------------
const VAR_P = {
    description: _t("Variance of entire population."),
    args: [
        arg("value1 (number, range<number>)", _t("The first value or range of the population.")),
        arg("value2 (number, range<number>, repeating)", _t("Additional values or ranges to include in the population.")),
    ],
    compute: function (...args) {
        return variance(args, false, false, this.locale);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// VAR.S
// -----------------------------------------------------------------------------
const VAR_S = {
    description: _t("Variance."),
    args: [
        arg("value1 (number, range<number>)", _t("The first value or range of the sample.")),
        arg("value2 (number, range<number>, repeating)", _t("Additional values or ranges to include in the sample.")),
    ],
    compute: function (...args) {
        return variance(args, true, false, this.locale);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// VARA
// -----------------------------------------------------------------------------
const VARA = {
    description: _t("Variance of sample (text as 0)."),
    args: [
        arg("value1 (number, range<number>)", _t("The first value or range of the sample.")),
        arg("value2 (number, range<number>, repeating)", _t("Additional values or ranges to include in the sample.")),
    ],
    compute: function (...args) {
        return variance(args, true, true, this.locale);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// VARP
// -----------------------------------------------------------------------------
const VARP = {
    description: _t("Variance of entire population."),
    args: [
        arg("value1 (number, range<number>)", _t("The first value or range of the population.")),
        arg("value2 (number, range<number>, repeating)", _t("Additional values or ranges to include in the population.")),
    ],
    compute: function (...args) {
        return variance(args, false, false, this.locale);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// VARPA
// -----------------------------------------------------------------------------
const VARPA = {
    description: _t("Variance of entire population (text as 0)."),
    args: [
        arg("value1 (number, range<number>)", _t("The first value or range of the population.")),
        arg("value2 (number, range<number>, repeating)", _t("Additional values or ranges to include in the population.")),
    ],
    compute: function (...args) {
        return variance(args, false, true, this.locale);
    },
    isExported: true,
};

var statistical = /*#__PURE__*/Object.freeze({
    __proto__: null,
    AVEDEV: AVEDEV,
    AVERAGE: AVERAGE,
    AVERAGEA: AVERAGEA,
    AVERAGEIF: AVERAGEIF,
    AVERAGEIFS: AVERAGEIFS,
    AVERAGE_WEIGHTED: AVERAGE_WEIGHTED,
    CORREL: CORREL,
    COUNT: COUNT,
    COUNTA: COUNTA,
    COVAR: COVAR,
    COVARIANCE_P: COVARIANCE_P,
    COVARIANCE_S: COVARIANCE_S,
    FORECAST: FORECAST,
    GROWTH: GROWTH,
    INTERCEPT: INTERCEPT,
    LARGE: LARGE,
    LINEST: LINEST,
    LOGEST: LOGEST,
    MATTHEWS: MATTHEWS,
    MAX: MAX,
    MAXA: MAXA,
    MAXIFS: MAXIFS,
    MEDIAN: MEDIAN,
    MIN: MIN,
    MINA: MINA,
    MINIFS: MINIFS,
    PEARSON: PEARSON,
    PERCENTILE: PERCENTILE,
    PERCENTILE_EXC: PERCENTILE_EXC,
    PERCENTILE_INC: PERCENTILE_INC,
    POLYFIT_COEFFS: POLYFIT_COEFFS,
    POLYFIT_FORECAST: POLYFIT_FORECAST,
    QUARTILE: QUARTILE,
    QUARTILE_EXC: QUARTILE_EXC,
    QUARTILE_INC: QUARTILE_INC,
    RANK: RANK,
    RSQ: RSQ,
    SLOPE: SLOPE,
    SMALL: SMALL,
    SPEARMAN: SPEARMAN,
    STDEV: STDEV,
    STDEVA: STDEVA,
    STDEVP: STDEVP,
    STDEVPA: STDEVPA,
    STDEV_P: STDEV_P,
    STDEV_S: STDEV_S,
    STEYX: STEYX,
    TREND: TREND,
    VAR: VAR,
    VARA: VARA,
    VARP: VARP,
    VARPA: VARPA,
    VAR_P: VAR_P,
    VAR_S: VAR_S
});

function getMatchingCells(database, field, criteria, locale) {
    // Example
    // # DATABASE             # CRITERIA          # field = "C"
    //
    // | A | B | C |          | A | C |
    // |===========|          |=======|
    // | 1 | x | j |          |<2 | j |
    // | 1 | Z | k |          |   | 7 |
    // | 5 | y | 7 |
    // 1 - Select coordinates of database columns ----------------------------------------------------
    const indexColNameDB = new Map();
    const dimRowDB = database.length;
    for (let indexCol = dimRowDB - 1; indexCol >= 0; indexCol--) {
        indexColNameDB.set(toString(database[indexCol][0]).toUpperCase(), indexCol);
    }
    // Example continuation: indexColNameDB = {"A" => 0, "B" => 1, "C" => 2}
    // 2 - Check if the field parameter exists in the column names of the database -------------------
    // field may either be a text label corresponding to a column header in the
    // first row of database or a numeric index indicating which column to consider,
    // where the first column has the value 1.
    const fieldValue = field?.value;
    if (typeof fieldValue !== "number" && typeof fieldValue !== "string") {
        throw new EvaluationError(_t("The field must be a number or a string"));
    }
    let index;
    if (typeof fieldValue === "number") {
        index = Math.trunc(fieldValue) - 1;
        if (index < 0 || dimRowDB - 1 < index) {
            throw new EvaluationError(_t("The field (%(fieldValue)s) must be one of %(dimRowDB)s or must be a number between 1 and %s inclusive.", {
                fieldValue: fieldValue.toString(),
                dimRowDB: dimRowDB.toString(),
            }));
        }
    }
    else {
        const colName = toString(field).toUpperCase();
        index = indexColNameDB.get(colName) ?? -1;
        if (index === -1) {
            throw new EvaluationError(_t("The field (%s) must be one of %s.", toString(field), [...indexColNameDB.keys()].toString()));
        }
    }
    // Example continuation: index = 2
    // 3 - For each criteria row, find database row that correspond ----------------------------------
    const dimColCriteria = criteria[0].length;
    if (dimColCriteria < 2) {
        throw new EvaluationError(_t("The criteria range contains %s row, it must be at least 2 rows.", dimColCriteria.toString()));
    }
    let matchingRows = new Set();
    const dimColDB = database[0].length;
    for (let indexRow = 1; indexRow < dimColCriteria; indexRow++) {
        let args = [];
        let existColNameDB = true;
        for (let indexCol = 0; indexCol < criteria.length; indexCol++) {
            const currentName = toString(criteria[indexCol][0]).toUpperCase();
            const indexColDB = indexColNameDB.get(currentName);
            const criter = criteria[indexCol][indexRow];
            if (criter.value !== null) {
                if (indexColDB !== undefined) {
                    args.push([database[indexColDB].slice(1, dimColDB)]);
                    args.push(criter);
                }
                else {
                    existColNameDB = false;
                    break;
                }
            }
        }
        // Example continuation: args1 = [[1,1,5], "<2", ["j","k",7], "j"]
        // Example continuation: args2 = [["j","k",7], "7"]
        if (existColNameDB) {
            if (args.length > 0) {
                visitMatchingRanges(args, (i, j) => {
                    matchingRows.add(j);
                }, locale, true);
            }
            else {
                // return indices of each database row when a criteria table row is void
                matchingRows = new Set(Array(dimColDB - 1).keys());
                break;
            }
        }
    }
    // Example continuation: matchingRows = {0, 2}
    // 4 - return for each database row corresponding, the cells corresponding to the field parameter
    const fieldCol = database[index];
    // Example continuation:: fieldCol = ["C", "j", "k", 7]
    const matchingCells = [...matchingRows].map((x) => fieldCol[x + 1]);
    // Example continuation:: matchingCells = ["j", 7]
    return matchingCells;
}
const databaseArgs = [
    arg("database (range)", _t("The array or range containing the data to consider, structured in such a way that the first row contains the labels for each column's values.")),
    arg("field (number, string)", _t("Indicates which column in database contains the values to be extracted and operated on.")),
    arg("criteria (range)", _t("An array or range containing zero or more criteria to filter the database values by before operating.")),
];
// -----------------------------------------------------------------------------
// DAVERAGE
// -----------------------------------------------------------------------------
const DAVERAGE = {
    description: _t("Average of a set of values from a table-like range."),
    args: databaseArgs,
    compute: function (database, field, criteria) {
        const cells = getMatchingCells(database, field, criteria, this.locale);
        return AVERAGE.compute.bind(this)([cells]);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// DCOUNT
// -----------------------------------------------------------------------------
const DCOUNT = {
    description: _t("Counts values from a table-like range."),
    args: databaseArgs,
    compute: function (database, field, criteria) {
        const cells = getMatchingCells(database, field, criteria, this.locale);
        return COUNT.compute.bind(this)([cells]);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// DCOUNTA
// -----------------------------------------------------------------------------
const DCOUNTA = {
    description: _t("Counts values and text from a table-like range."),
    args: databaseArgs,
    compute: function (database, field, criteria) {
        const cells = getMatchingCells(database, field, criteria, this.locale);
        return COUNTA.compute.bind(this)([cells]);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// DGET
// -----------------------------------------------------------------------------
const DGET = {
    description: _t("Single value from a table-like range."),
    args: databaseArgs,
    compute: function (database, field, criteria) {
        const cells = getMatchingCells(database, field, criteria, this.locale);
        assert(() => cells.length === 1, _t("More than one match found in DGET evaluation."));
        return cells[0];
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// DMAX
// -----------------------------------------------------------------------------
const DMAX = {
    description: _t("Maximum of values from a table-like range."),
    args: databaseArgs,
    compute: function (database, field, criteria) {
        const cells = getMatchingCells(database, field, criteria, this.locale);
        return MAX.compute.bind(this)([cells]);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// DMIN
// -----------------------------------------------------------------------------
const DMIN = {
    description: _t("Minimum of values from a table-like range."),
    args: databaseArgs,
    compute: function (database, field, criteria) {
        const cells = getMatchingCells(database, field, criteria, this.locale);
        return MIN.compute.bind(this)([cells]);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// DPRODUCT
// -----------------------------------------------------------------------------
const DPRODUCT = {
    description: _t("Product of values from a table-like range."),
    args: databaseArgs,
    compute: function (database, field, criteria) {
        const cells = getMatchingCells(database, field, criteria, this.locale);
        return PRODUCT.compute.bind(this)([cells]);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// DSTDEV
// -----------------------------------------------------------------------------
const DSTDEV = {
    description: _t("Standard deviation of population sample from table."),
    args: databaseArgs,
    compute: function (database, field, criteria) {
        const cells = getMatchingCells(database, field, criteria, this.locale);
        return STDEV.compute.bind(this)([cells]);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// DSTDEVP
// -----------------------------------------------------------------------------
const DSTDEVP = {
    description: _t("Standard deviation of entire population from table."),
    args: databaseArgs,
    compute: function (database, field, criteria) {
        const cells = getMatchingCells(database, field, criteria, this.locale);
        return STDEVP.compute.bind(this)([cells]);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// DSUM
// -----------------------------------------------------------------------------
const DSUM = {
    description: _t("Sum of values from a table-like range."),
    args: databaseArgs,
    compute: function (database, field, criteria) {
        const cells = getMatchingCells(database, field, criteria, this.locale);
        return SUM.compute.bind(this)([cells]);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// DVAR
// -----------------------------------------------------------------------------
const DVAR = {
    description: _t("Variance of population sample from table-like range."),
    args: databaseArgs,
    compute: function (database, field, criteria) {
        const cells = getMatchingCells(database, field, criteria, this.locale);
        return VAR.compute.bind(this)([cells]);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// DVARP
// -----------------------------------------------------------------------------
const DVARP = {
    description: _t("Variance of a population from a table-like range."),
    args: databaseArgs,
    compute: function (database, field, criteria) {
        const cells = getMatchingCells(database, field, criteria, this.locale);
        return VARP.compute.bind(this)([cells]);
    },
    isExported: true,
};

var database = /*#__PURE__*/Object.freeze({
    __proto__: null,
    DAVERAGE: DAVERAGE,
    DCOUNT: DCOUNT,
    DCOUNTA: DCOUNTA,
    DGET: DGET,
    DMAX: DMAX,
    DMIN: DMIN,
    DPRODUCT: DPRODUCT,
    DSTDEV: DSTDEV,
    DSTDEVP: DSTDEVP,
    DSUM: DSUM,
    DVAR: DVAR,
    DVARP: DVARP
});

const DEFAULT_TYPE = 1;
const DEFAULT_WEEKEND = 1;
var TIME_UNIT;
(function (TIME_UNIT) {
    TIME_UNIT["WHOLE_YEARS"] = "Y";
    TIME_UNIT["WHOLE_MONTHS"] = "M";
    TIME_UNIT["WHOLE_DAYS"] = "D";
    TIME_UNIT["DAYS_WITHOUT_WHOLE_MONTHS"] = "MD";
    TIME_UNIT["MONTH_WITHOUT_WHOLE_YEARS"] = "YM";
    TIME_UNIT["DAYS_BETWEEN_NO_MORE_THAN_ONE_YEAR"] = "YD";
})(TIME_UNIT || (TIME_UNIT = {}));
// -----------------------------------------------------------------------------
// DATE
// -----------------------------------------------------------------------------
const DATE = {
    description: _t("Converts year/month/day into a date."),
    args: [
        arg("year (number)", _t("The year component of the date.")),
        arg("month (number)", _t("The month component of the date.")),
        arg("day (number)", _t("The day component of the date.")),
    ],
    compute: function (year, month, day) {
        let _year = Math.trunc(toNumber(year, this.locale));
        const _month = Math.trunc(toNumber(month, this.locale));
        const _day = Math.trunc(toNumber(day, this.locale));
        // For years less than 0 or greater than 10000, return #ERROR.
        assert(() => 0 <= _year && _year <= 9999, _t("The year (%s) must be between 0 and 9999 inclusive.", _year.toString()));
        // Between 0 and 1899, we add that value to 1900 to calculate the year
        if (_year < 1900) {
            _year += 1900;
        }
        const jsDate = new DateTime(_year, _month - 1, _day);
        const result = jsDateToRoundNumber(jsDate);
        assert(() => result >= 0, _t("The function [[FUNCTION_NAME]] result must be greater than or equal 01/01/1900."));
        return {
            value: result,
            format: this.locale.dateFormat,
        };
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// DATEDIF
// -----------------------------------------------------------------------------
const DATEDIF = {
    description: _t("Calculates the number of days, months, or years between two dates."),
    args: [
        arg("start_date (date)", _t("The start date to consider in the calculation. Must be a reference to a cell containing a DATE, a function returning a DATE type, or a number.")),
        arg("end_date (date)", _t("The end date to consider in the calculation. Must be a reference to a cell containing a DATE, a function returning a DATE type, or a number.")),
        arg("unit (string)", _t('A text abbreviation for unit of time. Accepted values are "Y" (the number of whole years between start_date and end_date), "M" (the number of whole months between start_date and end_date), "D" (the number of days between start_date and end_date), "MD" (the number of days between start_date and end_date after subtracting whole months), "YM" (the number of whole months between start_date and end_date after subtracting whole years), "YD" (the number of days between start_date and end_date, assuming start_date and end_date were no more than one year apart).')),
    ],
    compute: function (startDate, endDate, unit) {
        const _unit = toString(unit).toUpperCase();
        assert(() => Object.values(TIME_UNIT).includes(_unit), expectStringSetError(Object.values(TIME_UNIT), toString(unit)));
        const _startDate = Math.trunc(toNumber(startDate, this.locale));
        const _endDate = Math.trunc(toNumber(endDate, this.locale));
        const jsStartDate = numberToJsDate(_startDate);
        const jsEndDate = numberToJsDate(_endDate);
        assert(() => _endDate >= _startDate, _t("start_date (%s) should be on or before end_date (%s).", jsStartDate.toLocaleDateString(), jsEndDate.toLocaleDateString()));
        switch (_unit) {
            case TIME_UNIT.WHOLE_YEARS:
                return getTimeDifferenceInWholeYears(jsStartDate, jsEndDate);
            case TIME_UNIT.WHOLE_MONTHS:
                return getTimeDifferenceInWholeMonths(jsStartDate, jsEndDate);
            case TIME_UNIT.WHOLE_DAYS: {
                return getTimeDifferenceInWholeDays(jsStartDate, jsEndDate);
            }
            case TIME_UNIT.MONTH_WITHOUT_WHOLE_YEARS: {
                return (getTimeDifferenceInWholeMonths(jsStartDate, jsEndDate) -
                    getTimeDifferenceInWholeYears(jsStartDate, jsEndDate) * 12);
            }
            case TIME_UNIT.DAYS_WITHOUT_WHOLE_MONTHS:
                // Using "MD" may get incorrect result in Excel
                // See: https://support.microsoft.com/en-us/office/datedif-function-25dba1a4-2812-480b-84dd-8b32a451b35c
                let days = jsEndDate.getDate() - jsStartDate.getDate();
                if (days < 0) {
                    const monthBeforeEndMonth = new DateTime(jsEndDate.getFullYear(), jsEndDate.getMonth() - 1, 1);
                    const daysInMonthBeforeEndMonth = getDaysInMonth(monthBeforeEndMonth);
                    days = daysInMonthBeforeEndMonth - Math.abs(days);
                }
                return days;
            case TIME_UNIT.DAYS_BETWEEN_NO_MORE_THAN_ONE_YEAR: {
                if (areTwoDatesWithinOneYear(_startDate, _endDate)) {
                    return getTimeDifferenceInWholeDays(jsStartDate, jsEndDate);
                }
                const endDateWithinOneYear = new DateTime(jsStartDate.getFullYear(), jsEndDate.getMonth(), jsEndDate.getDate());
                let days = getTimeDifferenceInWholeDays(jsStartDate, endDateWithinOneYear);
                if (days < 0) {
                    endDateWithinOneYear.setFullYear(jsStartDate.getFullYear() + 1);
                    days = getTimeDifferenceInWholeDays(jsStartDate, endDateWithinOneYear);
                }
                return days;
            }
        }
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// DATEVALUE
// -----------------------------------------------------------------------------
const DATEVALUE = {
    description: _t("Converts a date string to a date value."),
    args: [arg("date_string (string)", _t("The string representing the date."))],
    compute: function (dateString) {
        const _dateString = toString(dateString);
        const internalDate = parseDateTime(_dateString, this.locale);
        assert(() => internalDate !== null, _t("The date_string (%s) cannot be parsed to date/time.", _dateString.toString()));
        return Math.trunc(internalDate.value);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// DAY
// -----------------------------------------------------------------------------
const DAY = {
    description: _t("Day of the month that a specific date falls on."),
    args: [arg("date (string)", _t("The date from which to extract the day."))],
    compute: function (date) {
        return toJsDate(date, this.locale).getDate();
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// DAYS
// -----------------------------------------------------------------------------
const DAYS = {
    description: _t("Number of days between two dates."),
    args: [
        arg("end_date (date)", _t("The end of the date range.")),
        arg("start_date (date)", _t("The start of the date range.")),
    ],
    compute: function (endDate, startDate) {
        const _endDate = toJsDate(endDate, this.locale);
        const _startDate = toJsDate(startDate, this.locale);
        const dateDif = _endDate.getTime() - _startDate.getTime();
        return Math.round(dateDif / MS_PER_DAY);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// DAYS360
// -----------------------------------------------------------------------------
const DEFAULT_DAY_COUNT_METHOD = 0;
const DAYS360 = {
    description: _t("Number of days between two dates on a 360-day year (months of 30 days)."),
    args: [
        arg("start_date (date)", _t("The start date to consider in the calculation.")),
        arg("end_date (date)", _t("The end date to consider in the calculation.")),
        arg(`method (number, default=${DEFAULT_DAY_COUNT_METHOD})`, _t("An indicator of what day count method to use. (0) US NASD method (1) European method")),
    ],
    compute: function (startDate, endDate, method = { value: DEFAULT_DAY_COUNT_METHOD }) {
        const _startDate = Math.trunc(toNumber(startDate, this.locale));
        const _endDate = Math.trunc(toNumber(endDate, this.locale));
        const dayCountConvention = toBoolean(method) ? 4 : 0;
        const yearFrac = getYearFrac(_startDate, _endDate, dayCountConvention);
        return Math.sign(_endDate - _startDate) * Math.round(yearFrac * 360);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// EDATE
// -----------------------------------------------------------------------------
const EDATE = {
    description: _t("Date a number of months before/after another date."),
    args: [
        arg("start_date (date)", _t("The date from which to calculate the result.")),
        arg("months (number)", _t("The number of months before (negative) or after (positive) 'start_date' to calculate.")),
    ],
    compute: function (startDate, months) {
        const _startDate = toJsDate(startDate, this.locale);
        const _months = Math.trunc(toNumber(months, this.locale));
        const jsDate = addMonthsToDate(_startDate, _months, false);
        return {
            value: jsDateToRoundNumber(jsDate),
            format: this.locale.dateFormat,
        };
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// EOMONTH
// -----------------------------------------------------------------------------
const EOMONTH = {
    description: _t("Last day of a month before or after a date."),
    args: [
        arg("start_date (date)", _t("The date from which to calculate the result.")),
        arg("months (number)", _t("The number of months before (negative) or after (positive) 'start_date' to consider.")),
    ],
    compute: function (startDate, months) {
        const _startDate = toJsDate(startDate, this.locale);
        const _months = Math.trunc(toNumber(months, this.locale));
        const yStart = _startDate.getFullYear();
        const mStart = _startDate.getMonth();
        const jsDate = new DateTime(yStart, mStart + _months + 1, 0);
        return {
            value: jsDateToRoundNumber(jsDate),
            format: this.locale.dateFormat,
        };
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// HOUR
// -----------------------------------------------------------------------------
const HOUR = {
    description: _t("Hour component of a specific time."),
    args: [arg("time (date)", _t("The time from which to calculate the hour component."))],
    compute: function (date) {
        return toJsDate(date, this.locale).getHours();
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// ISOWEEKNUM
// -----------------------------------------------------------------------------
const ISOWEEKNUM = {
    description: _t("ISO week number of the year."),
    args: [
        arg("date (date)", _t("The date for which to determine the ISO week number. Must be a reference to a cell containing a date, a function returning a date type, or a number.")),
    ],
    compute: function (date) {
        const _date = toJsDate(date, this.locale);
        const y = _date.getFullYear();
        // 1 - As the 1st week of a year can start the previous year or after the 1st
        // january we first look if the date is in the weeks of the current year, previous
        // year or year after.
        // A - We look for the current year, the first days of the first week
        // and the last days of the last week
        // The first week of the year is the week that contains the first
        // Thursday of the year.
        let firstThursday = 1;
        while (new DateTime(y, 0, firstThursday).getDay() !== 4) {
            firstThursday += 1;
        }
        const firstDayOfFirstWeek = new DateTime(y, 0, firstThursday - 3);
        // The last week of the year is the week that contains the last Thursday of
        // the year.
        let lastThursday = 31;
        while (new DateTime(y, 11, lastThursday).getDay() !== 4) {
            lastThursday -= 1;
        }
        const lastDayOfLastWeek = new DateTime(y, 11, lastThursday + 3);
        // B - If our date > lastDayOfLastWeek then it's in the weeks of the year after
        // If our date < firstDayOfFirstWeek then it's in the weeks of the year before
        let offsetYear;
        if (firstDayOfFirstWeek.getTime() <= _date.getTime()) {
            if (_date.getTime() <= lastDayOfLastWeek.getTime()) {
                offsetYear = 0;
            }
            else {
                offsetYear = 1;
            }
        }
        else {
            offsetYear = -1;
        }
        // 2 - now that the year is known, we are looking at the difference between
        // the first day of this year and the date. The difference in days divided by
        // 7 gives us the week number
        let firstDay;
        switch (offsetYear) {
            case 0:
                firstDay = firstDayOfFirstWeek;
                break;
            case 1:
                // firstDay is the 1st day of the 1st week of the year after
                // firstDay = lastDayOfLastWeek + 1 Day
                firstDay = new DateTime(y, 11, lastThursday + 3 + 1);
                break;
            case -1:
                // firstDay is the 1st day of the 1st week of the previous year.
                // The first week of the previous year is the week that contains the
                // first Thursday of the previous year.
                let firstThursdayPreviousYear = 1;
                while (new DateTime(y - 1, 0, firstThursdayPreviousYear).getDay() !== 4) {
                    firstThursdayPreviousYear += 1;
                }
                firstDay = new DateTime(y - 1, 0, firstThursdayPreviousYear - 3);
                break;
        }
        const diff = (_date.getTime() - firstDay.getTime()) / MS_PER_DAY;
        return Math.floor(diff / 7) + 1;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// MINUTE
// -----------------------------------------------------------------------------
const MINUTE = {
    description: _t("Minute component of a specific time."),
    args: [arg("time (date)", _t("The time from which to calculate the minute component."))],
    compute: function (date) {
        return toJsDate(date, this.locale).getMinutes();
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// MONTH
// -----------------------------------------------------------------------------
const MONTH = {
    description: _t("Month of the year a specific date falls in"),
    args: [arg("date (date)", _t("The date from which to extract the month."))],
    compute: function (date) {
        return toJsDate(date, this.locale).getMonth() + 1;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// NETWORKDAYS
// -----------------------------------------------------------------------------
const NETWORKDAYS = {
    description: _t("Net working days between two provided days."),
    args: [
        arg("start_date (date)", _t("The start date of the period from which to calculate the number of net working days.")),
        arg("end_date (date)", _t("The end date of the period from which to calculate the number of net working days.")),
        arg("holidays (date, range<date>, optional)", _t("A range or array constant containing the date serial numbers to consider holidays.")),
    ],
    compute: function (startDate, endDate, holidays) {
        return NETWORKDAYS_INTL.compute.bind(this)(startDate, endDate, { value: 1 }, holidays);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// NETWORKDAYS.INTL
// -----------------------------------------------------------------------------
/**
 * Transform weekend Spreadsheet information into Date Day JavaScript information.
 * Take string (String method) or number (Number method), return array of numbers.
 *
 * String method: weekends can be specified using seven 0’s and 1’s, where the
 * first number in the set represents Monday and the last number is for Sunday.
 * A zero means that the day is a work day, a 1 means that the day is a weekend.
 * For example, “0000011” would mean Saturday and Sunday are weekends.
 *
 * Number method: instead of using the string method above, a single number can
 * be used. 1 = Saturday/Sunday are weekends, 2 = Sunday/Monday, and this pattern
 * repeats until 7 = Friday/Saturday. 11 = Sunday is the only weekend, 12 = Monday
 * is the only weekend, and this pattern repeats until 17 = Saturday is the only
 * weekend.
 *
 * Example:
 * - 11 return [0] (correspond to Sunday)
 * - 12 return [1] (correspond to Monday)
 * - 3 return [1,2] (correspond to Monday and Tuesday)
 * - "0101010" return [2,4,6] (correspond to Tuesday, Thursday and Saturday)
 */
function weekendToDayNumber(data) {
    const weekend = data?.value;
    // case "string"
    if (typeof weekend === "string") {
        assert(() => {
            if (weekend.length !== 7) {
                return false;
            }
            for (let day of weekend) {
                if (day !== "0" && day !== "1") {
                    return false;
                }
            }
            return true;
        }, _t('When weekend is a string (%s) it must be composed of "0" or "1".', weekend));
        let result = [];
        for (let i = 0; i < 7; i++) {
            if (weekend[i] === "1") {
                result.push((i + 1) % 7);
            }
        }
        return result;
    }
    //case "number"
    if (typeof weekend === "number") {
        assert(() => (1 <= weekend && weekend <= 7) || (11 <= weekend && weekend <= 17), _t("The weekend (%s) must be a string or a number in the range 1-7 or 11-17.", weekend.toString()));
        // case 1 <= weekend <= 7
        if (weekend <= 7) {
            // 1 = Saturday/Sunday are weekends
            // 2 = Sunday/Monday
            // ...
            // 7 = Friday/Saturday.
            return [weekend - 2 === -1 ? 6 : weekend - 2, weekend - 1];
        }
        // case 11 <= weekend <= 17
        // 11 = Sunday is the only weekend
        // 12 = Monday is the only weekend
        // ...
        // 17 = Saturday is the only weekend.
        return [weekend - 11];
    }
    throw new EvaluationError(_t("The weekend must be a number or a string."));
}
const NETWORKDAYS_INTL = {
    description: _t("Net working days between two dates (specifying weekends)."),
    args: [
        arg("start_date (date)", _t("The start date of the period from which to calculate the number of net working days.")),
        arg("end_date (date)", _t("The end date of the period from which to calculate the number of net working days.")),
        arg(`weekend (any, default=${DEFAULT_WEEKEND})`, _t("A number or string representing which days of the week are considered weekends.")),
        arg("holidays (date, range<date>, optional)", _t("A range or array constant containing the dates to consider as holidays.")),
    ],
    compute: function (startDate, endDate, weekend = { value: DEFAULT_WEEKEND }, holidays) {
        const _startDate = toJsDate(startDate, this.locale);
        const _endDate = toJsDate(endDate, this.locale);
        const daysWeekend = weekendToDayNumber(weekend);
        let timesHoliday = new Set();
        if (holidays !== undefined) {
            visitAny([holidays], (h) => {
                const holiday = toJsDate(h, this.locale);
                timesHoliday.add(holiday.getTime());
            });
        }
        const invertDate = _startDate.getTime() > _endDate.getTime();
        const stopDate = DateTime.fromTimestamp((invertDate ? _startDate : _endDate).getTime());
        let stepDate = DateTime.fromTimestamp((invertDate ? _endDate : _startDate).getTime());
        const timeStopDate = stopDate.getTime();
        let timeStepDate = stepDate.getTime();
        let netWorkingDay = 0;
        while (timeStepDate <= timeStopDate) {
            if (!daysWeekend.includes(stepDate.getDay()) && !timesHoliday.has(timeStepDate)) {
                netWorkingDay += 1;
            }
            stepDate.setDate(stepDate.getDate() + 1);
            timeStepDate = stepDate.getTime();
        }
        return invertDate ? -netWorkingDay : netWorkingDay;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// NOW
// -----------------------------------------------------------------------------
const NOW = {
    description: _t("Current date and time as a date value."),
    args: [],
    compute: function () {
        const today = DateTime.now();
        const delta = today.getTime() - INITIAL_1900_DAY.getTime();
        const time = today.getHours() / 24 + today.getMinutes() / 1440 + today.getSeconds() / 86400;
        return {
            value: Math.floor(delta / MS_PER_DAY) + time,
            format: getDateTimeFormat(this.locale),
        };
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// SECOND
// -----------------------------------------------------------------------------
const SECOND = {
    description: _t("Minute component of a specific time."),
    args: [arg("time (date)", _t("The time from which to calculate the second component."))],
    compute: function (date) {
        return toJsDate(date, this.locale).getSeconds();
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// TIME
// -----------------------------------------------------------------------------
const TIME = {
    description: _t("Converts hour/minute/second into a time."),
    args: [
        arg("hour (number)", _t("The hour component of the time.")),
        arg("minute (number)", _t("The minute component of the time.")),
        arg("second (number)", _t("The second component of the time.")),
    ],
    compute: function (hour, minute, second) {
        let _hour = Math.trunc(toNumber(hour, this.locale));
        let _minute = Math.trunc(toNumber(minute, this.locale));
        let _second = Math.trunc(toNumber(second, this.locale));
        _minute += Math.floor(_second / 60);
        _second = (_second % 60) + (_second < 0 ? 60 : 0);
        _hour += Math.floor(_minute / 60);
        _minute = (_minute % 60) + (_minute < 0 ? 60 : 0);
        _hour %= 24;
        assert(() => _hour >= 0, _t("The function [[FUNCTION_NAME]] result cannot be negative"));
        return {
            value: _hour / 24 + _minute / (24 * 60) + _second / (24 * 60 * 60),
            format: this.locale.timeFormat,
        };
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// TIMEVALUE
// -----------------------------------------------------------------------------
const TIMEVALUE = {
    description: _t("Converts a time string into its serial number representation."),
    args: [arg("time_string (string)", _t("The string that holds the time representation."))],
    compute: function (timeString) {
        const _timeString = toString(timeString);
        const internalDate = parseDateTime(_timeString, this.locale);
        assert(() => internalDate !== null, _t("The time_string (%s) cannot be parsed to date/time.", _timeString));
        const result = internalDate.value - Math.trunc(internalDate.value);
        return result < 0 ? 1 + result : result;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// TODAY
// -----------------------------------------------------------------------------
const TODAY = {
    description: _t("Current date as a date value."),
    args: [],
    compute: function () {
        const today = DateTime.now();
        const jsDate = new DateTime(today.getFullYear(), today.getMonth(), today.getDate());
        return {
            value: jsDateToRoundNumber(jsDate),
            format: this.locale.dateFormat,
        };
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// WEEKDAY
// -----------------------------------------------------------------------------
const WEEKDAY = {
    description: _t("Day of the week of the date provided (as number)."),
    args: [
        arg("date (date)", _t("The date for which to determine the day of the week. Must be a reference to a cell containing a date, a function returning a date type, or a number.")),
        arg(`type (number, default=${DEFAULT_TYPE})`, _t("A number indicating which numbering system to use to represent weekdays. By default, counts starting with Sunday = 1.")),
    ],
    compute: function (date, type = { value: DEFAULT_TYPE }) {
        const _date = toJsDate(date, this.locale);
        const _type = Math.round(toNumber(type, this.locale));
        const m = _date.getDay();
        assert(() => [1, 2, 3].includes(_type), _t("The type (%s) must be 1, 2 or 3.", _type.toString()));
        if (_type === 1)
            return m + 1;
        if (_type === 2)
            return m === 0 ? 7 : m;
        return m === 0 ? 6 : m - 1;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// WEEKNUM
// -----------------------------------------------------------------------------
const WEEKNUM = {
    description: _t("Week number of the year."),
    args: [
        arg("date (date)", _t("The date for which to determine the week number. Must be a reference to a cell containing a date, a function returning a date type, or a number.")),
        arg(`type (number, default=${DEFAULT_TYPE})`, _t("A number representing the day that a week starts on. Sunday = 1.")),
    ],
    compute: function (date, type = { value: DEFAULT_TYPE }) {
        const _date = toJsDate(date, this.locale);
        const _type = Math.round(toNumber(type, this.locale));
        assert(() => _type === 1 || _type === 2 || (11 <= _type && _type <= 17) || _type === 21, _t("The type (%s) is out of range.", _type.toString()));
        if (_type === 21) {
            return ISOWEEKNUM.compute.bind(this)(date);
        }
        let startDayOfWeek;
        if (_type === 1 || _type === 2) {
            startDayOfWeek = _type - 1;
        }
        else {
            // case 11 <= _type <= 17
            startDayOfWeek = _type - 10 === 7 ? 0 : _type - 10;
        }
        const y = _date.getFullYear();
        let dayStart = 1;
        let startDayOfFirstWeek = new DateTime(y, 0, dayStart);
        while (startDayOfFirstWeek.getDay() !== startDayOfWeek) {
            dayStart += 1;
            startDayOfFirstWeek = new DateTime(y, 0, dayStart);
        }
        const dif = (_date.getTime() - startDayOfFirstWeek.getTime()) / MS_PER_DAY;
        if (dif < 0) {
            return 1;
        }
        return Math.floor(dif / 7) + (dayStart === 1 ? 1 : 2);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// WORKDAY
// -----------------------------------------------------------------------------
const WORKDAY = {
    description: _t("Date after a number of workdays."),
    args: [
        arg("start_date (date)", _t("The date from which to begin counting.")),
        arg("num_days (number)", _t("The number of working days to advance from start_date. If negative, counts backwards.")),
        arg("holidays (date, range<date>, optional)", _t("A range or array constant containing the dates to consider holidays.")),
    ],
    compute: function (startDate, numDays, holidays = { value: null }) {
        return WORKDAY_INTL.compute.bind(this)(startDate, numDays, { value: 1 }, holidays);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// WORKDAY.INTL
// -----------------------------------------------------------------------------
const WORKDAY_INTL = {
    description: _t("Date after a number of workdays (specifying weekends)."),
    args: [
        arg("start_date (date)", _t("The date from which to begin counting.")),
        arg("num_days (number)", _t("The number of working days to advance from start_date. If negative, counts backwards.")),
        arg(`weekend (any, default=${DEFAULT_WEEKEND})`, _t("A number or string representing which days of the week are considered weekends.")),
        arg("holidays (date, range<date>, optional)", _t("A range or array constant containing the dates to consider holidays.")),
    ],
    compute: function (startDate, numDays, weekend = { value: DEFAULT_WEEKEND }, holidays) {
        let _startDate = toJsDate(startDate, this.locale);
        let _numDays = Math.trunc(toNumber(numDays, this.locale));
        if (typeof weekend.value === "string") {
            assert(() => weekend.value !== "1111111", _t("The weekend must be different from '1111111'."));
        }
        const daysWeekend = weekendToDayNumber(weekend);
        let timesHoliday = new Set();
        if (holidays !== undefined) {
            visitAny([holidays], (h) => {
                const holiday = toJsDate(h, this.locale);
                timesHoliday.add(holiday.getTime());
            });
        }
        let stepDate = DateTime.fromTimestamp(_startDate.getTime());
        let timeStepDate = stepDate.getTime();
        const unitDay = Math.sign(_numDays);
        let stepDay = Math.abs(_numDays);
        while (stepDay > 0) {
            stepDate.setDate(stepDate.getDate() + unitDay);
            timeStepDate = stepDate.getTime();
            if (!daysWeekend.includes(stepDate.getDay()) && !timesHoliday.has(timeStepDate)) {
                stepDay -= 1;
            }
        }
        const delta = timeStepDate - INITIAL_1900_DAY.getTime();
        return {
            value: Math.round(delta / MS_PER_DAY),
            format: this.locale.dateFormat,
        };
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// YEAR
// -----------------------------------------------------------------------------
const YEAR = {
    description: _t("Year specified by a given date."),
    args: [arg("date (date)", _t("The date from which to extract the year."))],
    compute: function (date) {
        return toJsDate(date, this.locale).getFullYear();
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// YEARFRAC
// -----------------------------------------------------------------------------
const DEFAULT_DAY_COUNT_CONVENTION$1 = 0;
const YEARFRAC = {
    description: _t("Exact number of years between two dates."),
    args: [
        arg("start_date (date)", _t("The start date to consider in the calculation. Must be a reference to a cell containing a date, a function returning a date type, or a number.")),
        arg("end_date (date)", _t("The end date to consider in the calculation. Must be a reference to a cell containing a date, a function returning a date type, or a number.")),
        arg(`day_count_convention (number, default=${DEFAULT_DAY_COUNT_CONVENTION$1})`, _t("An indicator of what day count method to use.")),
    ],
    compute: function (startDate, endDate, dayCountConvention = { value: DEFAULT_DAY_COUNT_CONVENTION$1 }) {
        let _startDate = Math.trunc(toNumber(startDate, this.locale));
        let _endDate = Math.trunc(toNumber(endDate, this.locale));
        const _dayCountConvention = Math.trunc(toNumber(dayCountConvention, this.locale));
        assert(() => _startDate >= 0, _t("The start_date (%s) must be positive or null.", _startDate.toString()));
        assert(() => _endDate >= 0, _t("The end_date (%s) must be positive or null.", _endDate.toString()));
        assert(() => 0 <= _dayCountConvention && _dayCountConvention <= 4, _t("The day_count_convention (%s) must be between 0 and 4 inclusive.", _dayCountConvention.toString()));
        return getYearFrac(_startDate, _endDate, _dayCountConvention);
    },
};
// -----------------------------------------------------------------------------
// MONTH.START
// -----------------------------------------------------------------------------
const MONTH_START = {
    description: _t("First day of the month preceding a date."),
    args: [arg("date (date)", _t("The date from which to calculate the result."))],
    compute: function (date) {
        const _startDate = toJsDate(date, this.locale);
        const yStart = _startDate.getFullYear();
        const mStart = _startDate.getMonth();
        const jsDate = new DateTime(yStart, mStart, 1);
        return {
            value: jsDateToRoundNumber(jsDate),
            format: this.locale.dateFormat,
        };
    },
};
// -----------------------------------------------------------------------------
// MONTH.END
// -----------------------------------------------------------------------------
const MONTH_END = {
    description: _t("Last day of the month following a date."),
    args: [arg("date (date)", _t("The date from which to calculate the result."))],
    compute: function (date) {
        return EOMONTH.compute.bind(this)(date, { value: 0 });
    },
};
// -----------------------------------------------------------------------------
// QUARTER
// -----------------------------------------------------------------------------
const QUARTER = {
    description: _t("Quarter of the year a specific date falls in"),
    args: [arg("date (date)", _t("The date from which to extract the quarter."))],
    compute: function (date) {
        return Math.ceil((toJsDate(date, this.locale).getMonth() + 1) / 3);
    },
};
// -----------------------------------------------------------------------------
// QUARTER.START
// -----------------------------------------------------------------------------
const QUARTER_START = {
    description: _t("First day of the quarter of the year a specific date falls in."),
    args: [arg("date (date)", _t("The date from which to calculate the start of quarter."))],
    compute: function (date) {
        const quarter = QUARTER.compute.bind(this)(date);
        const year = YEAR.compute.bind(this)(date);
        const jsDate = new DateTime(year, (quarter - 1) * 3, 1);
        return {
            value: jsDateToRoundNumber(jsDate),
            format: this.locale.dateFormat,
        };
    },
};
// -----------------------------------------------------------------------------
// QUARTER.END
// -----------------------------------------------------------------------------
const QUARTER_END = {
    description: _t("Last day of the quarter of the year a specific date falls in."),
    args: [arg("date (date)", _t("The date from which to calculate the end of quarter."))],
    compute: function (date) {
        const quarter = QUARTER.compute.bind(this)(date);
        const year = YEAR.compute.bind(this)(date);
        const jsDate = new DateTime(year, quarter * 3, 0);
        return {
            value: jsDateToRoundNumber(jsDate),
            format: this.locale.dateFormat,
        };
    },
};
// -----------------------------------------------------------------------------
// YEAR.START
// -----------------------------------------------------------------------------
const YEAR_START = {
    description: _t("First day of the year a specific date falls in."),
    args: [arg("date (date)", _t("The date from which to calculate the start of the year."))],
    compute: function (date) {
        const year = YEAR.compute.bind(this)(date);
        const jsDate = new DateTime(year, 0, 1);
        return {
            value: jsDateToRoundNumber(jsDate),
            format: this.locale.dateFormat,
        };
    },
};
// -----------------------------------------------------------------------------
// YEAR.END
// -----------------------------------------------------------------------------
const YEAR_END = {
    description: _t("Last day of the year a specific date falls in."),
    args: [arg("date (date)", _t("The date from which to calculate the end of the year."))],
    compute: function (date) {
        const year = YEAR.compute.bind(this)(date);
        const jsDate = new DateTime(year + 1, 0, 0);
        return {
            value: jsDateToRoundNumber(jsDate),
            format: this.locale.dateFormat,
        };
    },
};

var date = /*#__PURE__*/Object.freeze({
    __proto__: null,
    DATE: DATE,
    DATEDIF: DATEDIF,
    DATEVALUE: DATEVALUE,
    DAY: DAY,
    DAYS: DAYS,
    DAYS360: DAYS360,
    EDATE: EDATE,
    EOMONTH: EOMONTH,
    HOUR: HOUR,
    ISOWEEKNUM: ISOWEEKNUM,
    MINUTE: MINUTE,
    MONTH: MONTH,
    MONTH_END: MONTH_END,
    MONTH_START: MONTH_START,
    NETWORKDAYS: NETWORKDAYS,
    NETWORKDAYS_INTL: NETWORKDAYS_INTL,
    NOW: NOW,
    QUARTER: QUARTER,
    QUARTER_END: QUARTER_END,
    QUARTER_START: QUARTER_START,
    SECOND: SECOND,
    TIME: TIME,
    TIMEVALUE: TIMEVALUE,
    TODAY: TODAY,
    WEEKDAY: WEEKDAY,
    WEEKNUM: WEEKNUM,
    WORKDAY: WORKDAY,
    WORKDAY_INTL: WORKDAY_INTL,
    YEAR: YEAR,
    YEARFRAC: YEARFRAC,
    YEAR_END: YEAR_END,
    YEAR_START: YEAR_START
});

const DEFAULT_DELTA_ARG = 0;
// -----------------------------------------------------------------------------
// DELTA
// -----------------------------------------------------------------------------
const DELTA = {
    description: _t("Compare two numeric values, returning 1 if they're equal."),
    args: [
        arg("number1 (number)", _t("The first number to compare.")),
        arg(`number2 (number, default=${DEFAULT_DELTA_ARG})`, _t("The second number to compare.")),
    ],
    compute: function (number1, number2 = { value: DEFAULT_DELTA_ARG }) {
        const _number1 = toNumber(number1, this.locale);
        const _number2 = toNumber(number2, this.locale);
        return _number1 === _number2 ? 1 : 0;
    },
    isExported: true,
};

var engineering = /*#__PURE__*/Object.freeze({
    __proto__: null,
    DELTA: DELTA
});

const SORT_TYPES = [
    CellValueType.number,
    CellValueType.error,
    CellValueType.text,
    CellValueType.boolean,
];
function cellsSortingCriterion(sortingOrder) {
    const inverse = sortingOrder === "ascending" ? 1 : -1;
    return (left, right) => {
        if (left.type === CellValueType.empty) {
            return right.type === CellValueType.empty ? 0 : 1;
        }
        else if (right.type === CellValueType.empty) {
            return -1;
        }
        let typeOrder = SORT_TYPES.indexOf(left.type) - SORT_TYPES.indexOf(right.type);
        if (typeOrder === 0) {
            if (left.type === CellValueType.text || left.type === CellValueType.error) {
                typeOrder = left.value.localeCompare(right.value);
            }
            else {
                typeOrder = left.value - right.value;
            }
        }
        return inverse * typeOrder;
    };
}
function sortCells(cells, sortDirection, emptyCellAsZero) {
    const cellsWithIndex = cells.map((cell, index) => ({
        index,
        type: cell.type,
        value: cell.value,
    }));
    const cellsToSort = emptyCellAsZero
        ? cellsWithIndex.map((cell) => cell.type === CellValueType.empty ? { ...cell, type: CellValueType.number, value: 0 } : cell)
        : cellsWithIndex;
    return cellsToSort.sort(cellsSortingCriterion(sortDirection));
}
function interactiveSortSelection(env, sheetId, anchor, zone, sortDirection) {
    let result = DispatchResult.Success;
    //several columns => bypass the contiguity check
    let multiColumns = zone.right > zone.left;
    if (env.model.getters.doesIntersectMerge(sheetId, zone)) {
        multiColumns = false;
        let table;
        for (let row = zone.top; row <= zone.bottom; row++) {
            table = [];
            for (let col = zone.left; col <= zone.right; col++) {
                let merge = env.model.getters.getMerge({ sheetId, col, row });
                if (merge && !table.includes(merge.id.toString())) {
                    table.push(merge.id.toString());
                }
            }
            if (table.length >= 2) {
                multiColumns = true;
                break;
            }
        }
    }
    const { col, row } = anchor;
    if (multiColumns) {
        result = env.model.dispatch("SORT_CELLS", { sheetId, col, row, zone, sortDirection });
    }
    else {
        // check contiguity
        const contiguousZone = env.model.getters.getContiguousZone(sheetId, zone);
        if (isEqual(contiguousZone, zone)) {
            // merge as it is
            result = env.model.dispatch("SORT_CELLS", {
                sheetId,
                col,
                row,
                zone,
                sortDirection,
            });
        }
        else {
            env.askConfirmation(_t("We found data next to your selection. Since this data was not selected, it will not be sorted. Do you want to extend your selection?"), () => {
                zone = contiguousZone;
                result = env.model.dispatch("SORT_CELLS", {
                    sheetId,
                    col,
                    row,
                    zone,
                    sortDirection,
                });
            }, () => {
                result = env.model.dispatch("SORT_CELLS", {
                    sheetId,
                    col,
                    row,
                    zone,
                    sortDirection,
                });
            });
        }
    }
    if (result.isCancelledBecause("InvalidSortZone" /* CommandResult.InvalidSortZone */)) {
        const { col, row } = anchor;
        env.model.selection.selectZone({ cell: { col, row }, zone });
        env.raiseError(_t("Cannot sort. To sort, select only cells or only merges that have the same size."));
    }
}

function sortMatrix(matrix, locale, ...criteria) {
    for (const [i, value] of criteria.entries()) {
        assert(() => value !== undefined, _t("Value for parameter %d is missing, while the function [[FUNCTION_NAME]] expect a number or a range.", i + 1));
    }
    const sortingOrders = [];
    const sortColumns = [];
    const nRows = matrix.length;
    for (let i = 0; i < criteria.length; i += 2) {
        sortingOrders.push(toBoolean(toScalar(criteria[i + 1])?.value) ? "ascending" : "descending");
        const sortColumn = criteria[i];
        if (isMatrix(sortColumn) && (sortColumn.length > 1 || sortColumn[0].length > 1)) {
            assert(() => sortColumn.length === 1 && sortColumn[0].length === nRows, _t("Wrong size for %s. Expected a range of size 1x%s. Got %sx%s.", `sort_column${i + 1}`, nRows, sortColumn.length, sortColumn[0].length));
            sortColumns.push(sortColumn.flat().map((c) => c.value));
        }
        else {
            const colIndex = toNumber(toScalar(sortColumn)?.value, locale);
            if (colIndex < 1 || colIndex > matrix[0].length) {
                return matrix;
            }
            sortColumns.push(matrix.map((row) => row[colIndex - 1].value));
        }
    }
    if (sortColumns.length === 0) {
        for (let i = 0; i < matrix[0].length; i++) {
            sortColumns.push(matrix.map((row) => row[i].value));
            sortingOrders.push("ascending");
        }
    }
    const sortingCriteria = {
        descending: cellsSortingCriterion("descending"),
        ascending: cellsSortingCriterion("ascending"),
    };
    const indexes = range(0, matrix.length);
    indexes.sort((a, b) => {
        for (const [i, sortColumn] of sortColumns.entries()) {
            const left = sortColumn[a];
            const right = sortColumn[b];
            const leftCell = {
                value: left,
                type: left === null
                    ? CellValueType.empty
                    : typeof left === "string"
                        ? CellValueType.text
                        : typeof left,
            };
            const rightCell = {
                value: right,
                type: right === null
                    ? CellValueType.empty
                    : typeof right === "string"
                        ? CellValueType.text
                        : typeof right,
            };
            const result = sortingCriteria[sortingOrders[i]](leftCell, rightCell);
            if (result !== 0) {
                return result;
            }
        }
        return 0;
    });
    return indexes.map((i) => matrix[i]);
}
// -----------------------------------------------------------------------------
// FILTER
// -----------------------------------------------------------------------------
const FILTER = {
    description: _t("Returns a filtered version of the source range, returning only rows or columns that meet the specified conditions."),
    // TODO modify args description when vectorization on formulas is available
    args: [
        arg("range (any, range<any>)", _t("The data to be filtered.")),
        arg("condition1 (boolean, range<boolean>)", _t("A column or row containing true or false values corresponding to the first column or row of range.")),
        arg("condition2 (boolean, range<boolean>, repeating)", _t("Additional column or row containing true or false values.")),
    ],
    compute: function (range, ...conditions) {
        let _array = toMatrix(range);
        const _conditionsMatrices = conditions.map((cond) => matrixMap(toMatrix(cond), (data) => data.value));
        _conditionsMatrices.map((c) => assertSingleColOrRow(_t("The arguments condition must be a single column or row."), c));
        assertSameDimensions(_t("The arguments conditions must have the same dimensions."), ...conditions);
        const _conditions = _conditionsMatrices.map((c) => c.flat());
        const mode = _conditionsMatrices[0].length === 1 ? "row" : "col";
        _array = mode === "row" ? transposeMatrix(_array) : _array;
        assert(() => _conditions.every((cond) => cond.length === _array.length), _t("FILTER has mismatched sizes on the range and conditions."));
        const result = [];
        for (let i = 0; i < _array.length; i++) {
            const row = _array[i];
            if (_conditions.every((c) => (typeof c[i] === "boolean" || typeof c[i] === "number") && c[i])) {
                result.push(row);
            }
        }
        if (!result.length) {
            throw new NotAvailableError(_t("No match found in FILTER evaluation"));
        }
        return mode === "row" ? transposeMatrix(result) : result;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// SORT
// -----------------------------------------------------------------------------
const SORT = {
    description: _t("Sorts the rows of a given array or range by the values in one or more columns."),
    args: [
        arg("range (range)", _t("The data to be sorted.")),
        arg("sort_column (any, range<number>, repeating)", _t("The index of the column in range or a range outside of range containing the values by which to sort.")),
        arg("is_ascending (boolean, repeating)", _t("TRUE or FALSE indicating whether to sort sort_column in ascending order. FALSE sorts in descending order.")),
    ],
    compute: function (range, ...sortingCriteria) {
        const _range = transposeMatrix(range);
        return transposeMatrix(sortMatrix(_range, this.locale, ...sortingCriteria));
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// SORTN
// -----------------------------------------------------------------------------
const SORTN = {
    description: _t("Returns the first n items in a data set after performing a sort."),
    args: [
        arg("range (range)", _t("The data to be sorted.")),
        arg("n (number, default=1)", _t("The number of items to return.")),
        arg("display_ties_mode (number, default=0)", _t("A number representing the way to display ties.")),
        arg("sort_column (number, range<number>, repeating)", _t("The index of the column in range or a range outside of range containing the values by which to sort.")),
        arg("is_ascending (boolean, repeating)", _t("TRUE or FALSE indicating whether to sort sort_column in ascending order. FALSE sorts in descending order.")),
    ],
    compute: function (range, n, displayTiesMode, ...sortingCriteria) {
        const _n = toNumber(n?.value ?? 1, this.locale);
        assert(() => _n >= 0, _t("Wrong value of 'n'. Expected a positive number. Got %s.", _n));
        const _displayTiesMode = toNumber(displayTiesMode?.value ?? 0, this.locale);
        assert(() => _displayTiesMode >= 0 && _displayTiesMode <= 3, _t("Wrong value of 'display_ties_mode'. Expected a positive number between 0 and 3. Got %s.", _displayTiesMode));
        const sortedData = sortMatrix(transposeMatrix(range), this.locale, ...sortingCriteria);
        const sameRows = (i, j) => JSON.stringify(sortedData[i].map((c) => c.value)) ===
            JSON.stringify(sortedData[j].map((c) => c.value));
        /*
         * displayTiesMode determine how ties (equal values) are dealt with:
         * 0 - ignore ties and show first n rows only
         * 1 - show first n rows plus any additional ties with nth row
         * 2 - show n rows but remove duplicates
         * 3 - show first n unique rows and all duplicates of these rows
         */
        switch (_displayTiesMode) {
            case 0:
                return transposeMatrix(sortedData.slice(0, _n));
            case 1:
                for (let i = _n; i < sortedData.length; i++) {
                    if (!sameRows(i, _n - 1)) {
                        return transposeMatrix(sortedData.slice(0, i));
                    }
                }
                return transposeMatrix(sortedData);
            case 2: {
                const uniques = [sortedData[0]];
                for (let i = 1; i < sortedData.length; i++) {
                    for (let j = 0; j < i; j++) {
                        if (sameRows(i, j)) {
                            break;
                        }
                        if (j === i - 1) {
                            uniques.push(sortedData[i]);
                        }
                    }
                }
                return transposeMatrix(uniques.slice(0, _n));
            }
            case 3: {
                const uniques = [sortedData[0]];
                let counter = 1;
                for (let i = 1; i < sortedData.length; i++) {
                    if (!sameRows(i, i - 1)) {
                        counter++;
                    }
                    if (counter > _n) {
                        break;
                    }
                    uniques.push(sortedData[i]);
                }
                return transposeMatrix(uniques);
            }
        }
    },
    isExported: false,
};
// -----------------------------------------------------------------------------
// UNIQUE
// -----------------------------------------------------------------------------
const UNIQUE = {
    description: _t("Unique rows in the provided source range."),
    args: [
        arg("range (any, range<any>)", _t("The data to filter by unique entries.")),
        arg("by_column (boolean, default=FALSE)", _t("Whether to filter the data by columns or by rows.")),
        arg("exactly_once (boolean, default=FALSE)", _t("Whether to return only entries with no duplicates.")),
    ],
    compute: function (range = { value: "" }, byColumn, exactlyOnce) {
        if (!isMatrix(range)) {
            return [[range]];
        }
        const _byColumn = toBoolean(byColumn?.value) || false;
        const _exactlyOnce = toBoolean(exactlyOnce?.value) || false;
        if (!_byColumn) {
            range = transposeMatrix(range);
        }
        const map = new Map();
        for (const data of range) {
            const key = JSON.stringify(data.map((item) => item.value));
            const occurrence = map.get(key);
            if (!occurrence) {
                map.set(key, { data, count: 1 });
            }
            else {
                occurrence.count++;
            }
        }
        const result = [];
        for (const row of map.values()) {
            if (_exactlyOnce && row.count > 1) {
                continue;
            }
            result.push(row.data);
        }
        if (!result.length)
            throw new EvaluationError(_t("No unique values found"));
        return _byColumn ? result : transposeMatrix(result);
    },
    isExported: true,
};

var filter = /*#__PURE__*/Object.freeze({
    __proto__: null,
    FILTER: FILTER,
    SORT: SORT,
    SORTN: SORTN,
    UNIQUE: UNIQUE
});

/** Assert maturity date > settlement date */
function assertMaturityAndSettlementDatesAreValid(settlement, maturity) {
    assert(() => settlement < maturity, _t("The maturity (%s) must be strictly greater than the settlement (%s).", maturity.toString(), settlement.toString()));
}
/** Assert settlement date > issue date */
function assertSettlementAndIssueDatesAreValid(settlement, issue) {
    assert(() => issue < settlement, _t("The settlement date (%s) must be strictly greater than the issue date (%s).", settlement.toString(), issue.toString()));
}
/** Assert coupon frequency is in [1, 2, 4] */
function assertCouponFrequencyIsValid(frequency) {
    assert(() => [1, 2, 4].includes(frequency), _t("The frequency (%s) must be one of %s", frequency.toString(), [1, 2, 4].toString()));
}
/** Assert dayCountConvention is between 0 and 4 */
function assertDayCountConventionIsValid(dayCountConvention) {
    assert(() => 0 <= dayCountConvention && dayCountConvention <= 4, _t("The day_count_convention (%s) must be between 0 and 4 inclusive.", dayCountConvention.toString()));
}
function assertRedemptionStrictlyPositive(redemption) {
    assert(() => redemption > 0, _t("The redemption (%s) must be strictly positive.", redemption.toString()));
}
function assertPriceStrictlyPositive(price) {
    assert(() => price > 0, _t("The price (%s) must be strictly positive.", price.toString()));
}
function assertNumberOfPeriodsStrictlyPositive(nPeriods) {
    assert(() => nPeriods > 0, _t("The number_of_periods (%s) must be greater than 0.", nPeriods.toString()));
}
function assertRateStrictlyPositive(rate) {
    assert(() => rate > 0, _t("The rate (%s) must be strictly positive.", rate.toString()));
}
function assertLifeStrictlyPositive(life) {
    assert(() => life > 0, _t("The life (%s) must be strictly positive.", life.toString()));
}
function assertCostStrictlyPositive(cost) {
    assert(() => cost > 0, _t("The cost (%s) must be strictly positive.", cost.toString()));
}
function assertPurchaseDatePositiveOrZero(purchaseDate) {
    assert(() => purchaseDate >= 0, _t("The purchase_date (%s) must be positive or null.", purchaseDate.toString()));
}
function assertIssuePositiveOrZero(issue) {
    assert(() => issue >= 0, _t("The issue (%s) must be positive or null.", issue.toString()));
}
function assertCostPositiveOrZero(cost) {
    assert(() => cost >= 0, _t("The cost (%s) must be positive or null.", cost.toString()));
}
function assertPeriodStrictlyPositive(period) {
    assert(() => period > 0, _t("The period (%s) must be strictly positive.", period.toString()));
}
function assertPeriodPositiveOrZero(period) {
    assert(() => period >= 0, _t("The period (%s) must be positive or null.", period.toString()));
}
function assertSalvagePositiveOrZero(salvage) {
    assert(() => salvage >= 0, _t("The salvage (%s) must be positive or null.", salvage.toString()));
}
function assertSalvageSmallerOrEqualThanCost(salvage, cost) {
    assert(() => salvage <= cost, _t("The salvage (%s) must be smaller or equal than the cost (%s).", salvage.toString(), cost.toString()));
}
function assertPresentValueStrictlyPositive(pv) {
    assert(() => pv > 0, _t("The present value (%s) must be strictly positive.", pv.toString()));
}
function assertPeriodSmallerOrEqualToLife(period, life) {
    assert(() => period <= life, _t("The period (%s) must be less than or equal life (%s).", period.toString(), life.toString()));
}
function assertInvestmentStrictlyPositive(investment) {
    assert(() => investment > 0, _t("The investment (%s) must be strictly positive.", investment.toString()));
}
function assertDiscountStrictlyPositive(discount) {
    assert(() => discount > 0, _t("The discount (%s) must be strictly positive.", discount.toString()));
}
function assertDiscountStrictlySmallerThanOne(discount) {
    assert(() => discount < 1, _t("The discount (%s) must be smaller than 1.", discount.toString()));
}
function assertDeprecationFactorStrictlyPositive(factor) {
    assert(() => factor > 0, _t("The depreciation factor (%s) must be strictly positive.", factor.toString()));
}
function assertSettlementLessThanOneYearBeforeMaturity(settlement, maturity, locale) {
    const startDate = toJsDate(settlement, locale);
    const endDate = toJsDate(maturity, locale);
    const startDatePlusOneYear = toJsDate(settlement, locale);
    startDatePlusOneYear.setFullYear(startDate.getFullYear() + 1);
    assert(() => endDate.getTime() <= startDatePlusOneYear.getTime(), _t("The settlement date (%s) must at most one year after the maturity date (%s).", settlement.toString(), maturity.toString()));
}
/**
 * Check if the given periods are valid. This will assert :
 *
 * - 0 < numberOfPeriods
 * - 0 < firstPeriod <= lastPeriod
 * - 0 < lastPeriod <= numberOfPeriods
 *
 */
function assertFirstAndLastPeriodsAreValid(firstPeriod, lastPeriod, numberOfPeriods) {
    assertNumberOfPeriodsStrictlyPositive(numberOfPeriods);
    assert(() => firstPeriod > 0, _t("The first_period (%s) must be strictly positive.", firstPeriod.toString()));
    assert(() => lastPeriod > 0, _t("The last_period (%s) must be strictly positive.", lastPeriod.toString()));
    assert(() => firstPeriod <= lastPeriod, _t("The first_period (%s) must be smaller or equal to the last_period (%s).", firstPeriod.toString(), lastPeriod.toString()));
    assert(() => lastPeriod <= numberOfPeriods, _t("The last_period (%s) must be smaller or equal to the number_of_periods (%s).", firstPeriod.toString(), numberOfPeriods.toString()));
}
/**
 * Check if the given periods are valid. This will assert :
 *
 * - 0 < life
 * - 0 <= startPeriod <= endPeriod
 * - 0 <= endPeriod <= life
 *
 */
function assertStartAndEndPeriodAreValid(startPeriod, endPeriod, life) {
    assertLifeStrictlyPositive(life);
    assert(() => startPeriod >= 0, _t("The start_period (%s) must be greater or equal than 0.", startPeriod.toString()));
    assert(() => endPeriod >= 0, _t("The end_period (%s) must be greater or equal than 0.", endPeriod.toString()));
    assert(() => startPeriod <= endPeriod, _t("The start_period (%s) must be smaller or equal to the end_period (%s).", startPeriod.toString(), endPeriod.toString()));
    assert(() => endPeriod <= life, _t("The end_period (%s) must be smaller or equal to the life (%s).", startPeriod.toString(), life.toString()));
}
function assertRateGuessStrictlyGreaterThanMinusOne(guess) {
    assert(() => guess > -1, _t("The rate_guess (%s) must be strictly greater than -1.", guess.toString()));
}
function assertCashFlowsAndDatesHaveSameDimension(cashFlows, dates) {
    assert(() => cashFlows.length === dates.length && cashFlows[0].length === dates[0].length, _t("The cashflow_amounts and cashflow_dates ranges must have the same dimensions."));
}
function assertCashFlowsHavePositiveAndNegativesValues(cashFlow) {
    assert(() => cashFlow.some((val) => val > 0) && cashFlow.some((val) => val < 0), _t("There must be both positive and negative values in cashflow_amounts."));
}
function assertEveryDateGreaterThanFirstDateOfCashFlowDates(dates) {
    assert(() => dates.every((date) => date >= dates[0]), _t("All the dates should be greater or equal to the first date in cashflow_dates (%s).", dates[0].toString()));
}

const DEFAULT_DAY_COUNT_CONVENTION = 0;
const DEFAULT_END_OR_BEGINNING = 0;
const DEFAULT_FUTURE_VALUE = 0;
const COUPON_FUNCTION_ARGS = [
    arg("settlement (date)", _t("The settlement date of the security, the date after issuance when the security is delivered to the buyer.")),
    arg("maturity (date)", _t("The maturity or end date of the security, when it can be redeemed at face, or par value.")),
    arg("frequency (number)", _t("The number of interest or coupon payments per year (1, 2, or 4).")),
    arg(`day_count_convention (number, default=${DEFAULT_DAY_COUNT_CONVENTION} )`, _t("An indicator of what day count method to use.")),
];
/**
 * Use the Newton–Raphson method to find a root of the given function in an iterative manner.
 *
 * @param func the function to find a root of
 * @param derivFunc the derivative of the function
 * @param startValue the initial value for the first iteration of the algorithm
 * @param maxIterations the maximum number of iterations
 * @param epsMax the epsilon for the root
 * @param nanFallback a function giving a fallback value to use if func(x) returns NaN. Useful if the
 *                       function is not defined for some range, but we know approximately where the root is when the Newton
 *                       algorithm ends up in this range.
 */
function newtonMethod(func, derivFunc, startValue, maxIterations, epsMax = 1e-10, nanFallback) {
    let x = startValue;
    let newX;
    let xDelta;
    let y;
    let yEqual0 = false;
    let count = 0;
    let previousFallback = undefined;
    do {
        y = func(x);
        if (isNaN(y)) {
            assert(() => count < maxIterations && nanFallback !== undefined, _t("Function [[FUNCTION_NAME]] didn't find any result."));
            count++;
            x = nanFallback(previousFallback);
            previousFallback = x;
            continue;
        }
        newX = x - y / derivFunc(x);
        xDelta = Math.abs(newX - x);
        x = newX;
        yEqual0 = xDelta < epsMax || Math.abs(y) < epsMax;
        assert(() => count < maxIterations, _t("Function [[FUNCTION_NAME]] didn't find any result."));
        count++;
    } while (!yEqual0);
    return x;
}
// -----------------------------------------------------------------------------
// ACCRINTM
// -----------------------------------------------------------------------------
const ACCRINTM = {
    description: _t("Accrued interest of security paying at maturity."),
    args: [
        arg("issue (date)", _t("The date the security was initially issued.")),
        arg("maturity (date)", _t("The maturity date of the security.")),
        arg("rate (number)", _t("The annualized rate of interest.")),
        arg("redemption (number)", _t("The redemption amount per 100 face value, or par.")),
        arg(`day_count_convention (number, default=${DEFAULT_DAY_COUNT_CONVENTION} )`, _t("An indicator of what day count method to use.")),
    ],
    compute: function (issue, maturity, rate, redemption, dayCountConvention = { value: DEFAULT_DAY_COUNT_CONVENTION }) {
        const start = Math.trunc(toNumber(issue, this.locale));
        const end = Math.trunc(toNumber(maturity, this.locale));
        const _redemption = toNumber(redemption, this.locale);
        const _rate = toNumber(rate, this.locale);
        const _dayCountConvention = Math.trunc(toNumber(dayCountConvention, this.locale));
        assertIssuePositiveOrZero(start);
        assertSettlementAndIssueDatesAreValid(end, start);
        assertDayCountConventionIsValid(_dayCountConvention);
        assertRedemptionStrictlyPositive(_redemption);
        assertRateStrictlyPositive(_rate);
        const yearFrac = getYearFrac(start, end, _dayCountConvention);
        return _redemption * _rate * yearFrac;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// AMORLINC
// -----------------------------------------------------------------------------
const AMORLINC = {
    description: _t("Depreciation for an accounting period."),
    args: [
        arg("cost (number)", _t("The initial cost of the asset.")),
        arg("purchase_date (date)", _t("The date the asset was purchased.")),
        arg("first_period_end (date)", _t("The date the first period ended.")),
        arg("salvage (number)", _t("The value of the asset at the end of depreciation.")),
        arg("period (number)", _t("The single period within life for which to calculate depreciation.")),
        arg("rate (number)", _t("The deprecation rate.")),
        arg("day_count_convention (number, optional)", _t("An indicator of what day count method to use.")),
    ],
    compute: function (cost, purchaseDate, firstPeriodEnd, salvage, period, rate, dayCountConvention = { value: DEFAULT_DAY_COUNT_CONVENTION }) {
        dayCountConvention = dayCountConvention || 0;
        const _cost = toNumber(cost, this.locale);
        const _purchaseDate = Math.trunc(toNumber(purchaseDate, this.locale));
        const _firstPeriodEnd = Math.trunc(toNumber(firstPeriodEnd, this.locale));
        const _salvage = toNumber(salvage, this.locale);
        const _period = toNumber(period, this.locale);
        const _rate = toNumber(rate, this.locale);
        const _dayCountConvention = Math.trunc(toNumber(dayCountConvention, this.locale));
        assertCostStrictlyPositive(_cost);
        assertPurchaseDatePositiveOrZero(_purchaseDate);
        assertSalvagePositiveOrZero(_salvage);
        assertSalvageSmallerOrEqualThanCost(_salvage, _cost);
        assertPeriodPositiveOrZero(_period);
        assertRateStrictlyPositive(_rate);
        assertDayCountConventionIsValid(_dayCountConvention);
        assert(() => _purchaseDate <= _firstPeriodEnd, _t("The purchase_date (%s) must be before the first_period_end (%s).", _purchaseDate.toString(), _firstPeriodEnd.toString()));
        /**
         * https://wiki.documentfoundation.org/Documentation/Calc_Functions/AMORLINC
         *
         * AMORLINC period 0 = cost * rate * YEARFRAC(purchase date, first period end)
         * AMORLINC period n = cost * rate
         * AMORLINC at the last period is such that the remaining deprecated cost is equal to the salvage value.
         *
         * The period is and rounded to 1 if < 1 truncated if > 1,
         *
         * Compatibility note :
         * If (purchase date) === (first period end), on GSheet the deprecation at the first period is 0, and on Excel
         * it is a full period deprecation. We choose to use the Excel behaviour.
         */
        const roundedPeriod = _period < 1 && _period > 0 ? 1 : Math.trunc(_period);
        const deprec = _cost * _rate;
        const yearFrac = getYearFrac(_purchaseDate, _firstPeriodEnd, _dayCountConvention);
        const firstDeprec = _purchaseDate === _firstPeriodEnd ? deprec : deprec * yearFrac;
        const valueAtPeriod = _cost - firstDeprec - deprec * roundedPeriod;
        if (valueAtPeriod >= _salvage) {
            return roundedPeriod === 0 ? firstDeprec : deprec;
        }
        return _salvage - valueAtPeriod < deprec ? deprec - (_salvage - valueAtPeriod) : 0;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// COUPDAYS
// -----------------------------------------------------------------------------
const COUPDAYS = {
    description: _t("Days in coupon period containing settlement date."),
    args: COUPON_FUNCTION_ARGS,
    compute: function (settlement, maturity, frequency, dayCountConvention = { value: DEFAULT_DAY_COUNT_CONVENTION }) {
        dayCountConvention = dayCountConvention || 0;
        const start = Math.trunc(toNumber(settlement, this.locale));
        const end = Math.trunc(toNumber(maturity, this.locale));
        const _frequency = Math.trunc(toNumber(frequency, this.locale));
        const _dayCountConvention = Math.trunc(toNumber(dayCountConvention, this.locale));
        assertMaturityAndSettlementDatesAreValid(start, end);
        assertCouponFrequencyIsValid(_frequency);
        assertDayCountConventionIsValid(_dayCountConvention);
        // https://wiki.documentfoundation.org/Documentation/Calc_Functions/COUPDAYS
        if (_dayCountConvention === 1) {
            const before = COUPPCD.compute.bind(this)(settlement, maturity, frequency, dayCountConvention).value;
            const after = COUPNCD.compute.bind(this)(settlement, maturity, frequency, dayCountConvention).value;
            return after - before;
        }
        const daysInYear = _dayCountConvention === 3 ? 365 : 360;
        return daysInYear / _frequency;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// COUPDAYBS
// -----------------------------------------------------------------------------
const COUPDAYBS = {
    description: _t("Days from settlement until next coupon."),
    args: COUPON_FUNCTION_ARGS,
    compute: function (settlement, maturity, frequency, dayCountConvention = { value: DEFAULT_DAY_COUNT_CONVENTION }) {
        dayCountConvention = dayCountConvention || 0;
        const start = Math.trunc(toNumber(settlement, this.locale));
        const end = Math.trunc(toNumber(maturity, this.locale));
        const _frequency = Math.trunc(toNumber(frequency, this.locale));
        const _dayCountConvention = Math.trunc(toNumber(dayCountConvention, this.locale));
        assertMaturityAndSettlementDatesAreValid(start, end);
        assertCouponFrequencyIsValid(_frequency);
        assertDayCountConventionIsValid(_dayCountConvention);
        const couponBeforeStart = COUPPCD.compute.bind(this)(settlement, maturity, frequency, dayCountConvention).value;
        if ([1, 2, 3].includes(_dayCountConvention)) {
            return start - couponBeforeStart;
        }
        if (_dayCountConvention === 4) {
            const yearFrac = getYearFrac(couponBeforeStart, start, _dayCountConvention);
            return Math.round(yearFrac * 360);
        }
        const startDate = toJsDate(start, this.locale);
        const dateCouponBeforeStart = toJsDate(couponBeforeStart, this.locale);
        const y1 = dateCouponBeforeStart.getFullYear();
        const y2 = startDate.getFullYear();
        const m1 = dateCouponBeforeStart.getMonth() + 1; // +1 because months in js start at 0 and it's confusing
        const m2 = startDate.getMonth() + 1;
        let d1 = dateCouponBeforeStart.getDate();
        let d2 = startDate.getDate();
        /**
         * Rules based on https://en.wikipedia.org/wiki/Day_count_convention#30/360_US
         *
         * These are slightly modified (no mention of if investment is EOM and rules order is modified),
         * but from my testing this seems the rules used by Excel/GSheet.
         */
        if (m1 === 2 &&
            m2 === 2 &&
            isLastDayOfMonth(dateCouponBeforeStart) &&
            isLastDayOfMonth(startDate)) {
            d2 = 30;
        }
        if (d2 === 31 && (d1 === 30 || d1 === 31)) {
            d2 = 30;
        }
        if (m1 === 2 && isLastDayOfMonth(dateCouponBeforeStart)) {
            d1 = 30;
        }
        if (d1 === 31) {
            d1 = 30;
        }
        return (y2 - y1) * 360 + (m2 - m1) * 30 + (d2 - d1);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// COUPDAYSNC
// -----------------------------------------------------------------------------
const COUPDAYSNC = {
    description: _t("Days from settlement until next coupon."),
    args: COUPON_FUNCTION_ARGS,
    compute: function (settlement, maturity, frequency, dayCountConvention = { value: DEFAULT_DAY_COUNT_CONVENTION }) {
        dayCountConvention = dayCountConvention || 0;
        const start = Math.trunc(toNumber(settlement, this.locale));
        const end = Math.trunc(toNumber(maturity, this.locale));
        const _frequency = Math.trunc(toNumber(frequency, this.locale));
        const _dayCountConvention = Math.trunc(toNumber(dayCountConvention, this.locale));
        assertMaturityAndSettlementDatesAreValid(start, end);
        assertCouponFrequencyIsValid(_frequency);
        assertDayCountConventionIsValid(_dayCountConvention);
        const couponAfterStart = COUPNCD.compute.bind(this)(settlement, maturity, frequency, dayCountConvention).value;
        if ([1, 2, 3].includes(_dayCountConvention)) {
            return couponAfterStart - start;
        }
        if (_dayCountConvention === 4) {
            const yearFrac = getYearFrac(start, couponAfterStart, _dayCountConvention);
            return Math.round(yearFrac * 360);
        }
        const coupDayBs = COUPDAYBS.compute.bind(this)(settlement, maturity, frequency, dayCountConvention);
        const coupDays = COUPDAYS.compute.bind(this)(settlement, maturity, frequency, dayCountConvention);
        return coupDays - coupDayBs;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// COUPNCD
// -----------------------------------------------------------------------------
const COUPNCD = {
    description: _t("Next coupon date after the settlement date."),
    args: COUPON_FUNCTION_ARGS,
    compute: function (settlement, maturity, frequency, dayCountConvention = { value: DEFAULT_DAY_COUNT_CONVENTION }) {
        dayCountConvention = dayCountConvention || 0;
        const start = Math.trunc(toNumber(settlement, this.locale));
        const end = Math.trunc(toNumber(maturity, this.locale));
        const _frequency = Math.trunc(toNumber(frequency, this.locale));
        const _dayCountConvention = Math.trunc(toNumber(dayCountConvention, this.locale));
        assertMaturityAndSettlementDatesAreValid(start, end);
        assertCouponFrequencyIsValid(_frequency);
        assertDayCountConventionIsValid(_dayCountConvention);
        const monthsPerPeriod = 12 / _frequency;
        const coupNum = COUPNUM.compute.bind(this)(settlement, maturity, frequency, dayCountConvention);
        const date = addMonthsToDate(toJsDate(end, this.locale), -(coupNum - 1) * monthsPerPeriod, true);
        return {
            value: jsDateToRoundNumber(date),
            format: this.locale.dateFormat,
        };
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// COUPNUM
// -----------------------------------------------------------------------------
const COUPNUM = {
    description: _t("Number of coupons between settlement and maturity."),
    args: COUPON_FUNCTION_ARGS,
    compute: function (settlement, maturity, frequency, dayCountConvention = { value: DEFAULT_DAY_COUNT_CONVENTION }) {
        dayCountConvention = dayCountConvention || 0;
        const start = Math.trunc(toNumber(settlement, this.locale));
        const end = Math.trunc(toNumber(maturity, this.locale));
        const _frequency = Math.trunc(toNumber(frequency, this.locale));
        const _dayCountConvention = Math.trunc(toNumber(dayCountConvention, this.locale));
        assertMaturityAndSettlementDatesAreValid(start, end);
        assertCouponFrequencyIsValid(_frequency);
        assertDayCountConventionIsValid(_dayCountConvention);
        let num = 1;
        let currentDate = end;
        const monthsPerPeriod = 12 / _frequency;
        while (currentDate > start) {
            currentDate = jsDateToRoundNumber(addMonthsToDate(toJsDate(currentDate, this.locale), -monthsPerPeriod, false));
            num++;
        }
        return num - 1;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// COUPPCD
// -----------------------------------------------------------------------------
const COUPPCD = {
    description: _t("Last coupon date prior to or on the settlement date."),
    args: COUPON_FUNCTION_ARGS,
    compute: function (settlement, maturity, frequency, dayCountConvention = { value: DEFAULT_DAY_COUNT_CONVENTION }) {
        dayCountConvention = dayCountConvention || 0;
        const start = Math.trunc(toNumber(settlement, this.locale));
        const end = Math.trunc(toNumber(maturity, this.locale));
        const _frequency = Math.trunc(toNumber(frequency, this.locale));
        const _dayCountConvention = Math.trunc(toNumber(dayCountConvention, this.locale));
        assertMaturityAndSettlementDatesAreValid(start, end);
        assertCouponFrequencyIsValid(_frequency);
        assertDayCountConventionIsValid(_dayCountConvention);
        const monthsPerPeriod = 12 / _frequency;
        const coupNum = COUPNUM.compute.bind(this)(settlement, maturity, frequency, dayCountConvention);
        const date = addMonthsToDate(toJsDate(end, this.locale), -coupNum * monthsPerPeriod, true);
        return {
            value: jsDateToRoundNumber(date),
            format: this.locale.dateFormat,
        };
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// CUMIPMT
// -----------------------------------------------------------------------------
const CUMIPMT = {
    description: _t("Cumulative interest paid over a set of periods."),
    args: [
        arg("rate (number)", _t("The interest rate.")),
        arg("number_of_periods (number)", _t("The number of payments to be made.")),
        arg("present_value (number)", _t("The current value of the annuity.")),
        arg("first_period (number)", _t("The number of the payment period to begin the cumulative calculation.")),
        arg("last_period (number)", _t("The number of the payment period to end the cumulative calculation.")),
        arg(`end_or_beginning (number, default=${DEFAULT_END_OR_BEGINNING})`, _t("Whether payments are due at the end (0) or beginning (1) of each period.")),
    ],
    compute: function (rate, numberOfPeriods, presentValue, firstPeriod, lastPeriod, endOrBeginning = { value: DEFAULT_END_OR_BEGINNING }) {
        const first = toNumber(firstPeriod, this.locale);
        const last = toNumber(lastPeriod, this.locale);
        const r = toNumber(rate, this.locale);
        const pv = toNumber(presentValue, this.locale);
        const n = toNumber(numberOfPeriods, this.locale);
        const type = toBoolean(endOrBeginning) ? 1 : 0;
        assertFirstAndLastPeriodsAreValid(first, last, n);
        assertRateStrictlyPositive(r);
        assertPresentValueStrictlyPositive(pv);
        let cumSum = 0;
        for (let i = first; i <= last; i++) {
            cumSum += impt(r, i, n, pv, 0, type);
        }
        return cumSum;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// CUMPRINC
// -----------------------------------------------------------------------------
const CUMPRINC = {
    description: _t("Cumulative principal paid over a set of periods."),
    args: [
        arg("rate (number)", _t("The interest rate.")),
        arg("number_of_periods (number)", _t("The number of payments to be made.")),
        arg("present_value (number)", _t("The current value of the annuity.")),
        arg("first_period (number)", _t("The number of the payment period to begin the cumulative calculation.")),
        arg("last_period (number)", _t("The number of the payment period to end the cumulative calculation.")),
        arg(`end_or_beginning (number, default=${DEFAULT_END_OR_BEGINNING})`, _t("Whether payments are due at the end (0) or beginning (1) of each period.")),
    ],
    compute: function (rate, numberOfPeriods, presentValue, firstPeriod, lastPeriod, endOrBeginning = { value: DEFAULT_END_OR_BEGINNING }) {
        const first = toNumber(firstPeriod, this.locale);
        const last = toNumber(lastPeriod, this.locale);
        const r = toNumber(rate, this.locale);
        const pv = toNumber(presentValue, this.locale);
        const n = toNumber(numberOfPeriods, this.locale);
        const type = toBoolean(endOrBeginning) ? 1 : 0;
        assertFirstAndLastPeriodsAreValid(first, last, n);
        assertRateStrictlyPositive(r);
        assertPresentValueStrictlyPositive(pv);
        let cumSum = 0;
        for (let i = first; i <= last; i++) {
            cumSum += ppmt(r, i, n, pv, 0, type);
        }
        return cumSum;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// DB
// -----------------------------------------------------------------------------
const DB = {
    description: _t("Depreciation via declining balance method."),
    args: [
        arg("cost (number)", _t("The initial cost of the asset.")),
        arg("salvage (number)", _t("The value of the asset at the end of depreciation.")),
        arg("life (number)", _t("The number of periods over which the asset is depreciated.")),
        arg("period (number)", _t("The single period within life for which to calculate depreciation.")),
        arg("month (number, optional)", _t("The number of months in the first year of depreciation.")),
    ],
    // to do: replace by dollar format
    compute: function (cost, salvage, life, period, ...args) {
        const _cost = toNumber(cost, this.locale);
        const _salvage = toNumber(salvage, this.locale);
        const _life = toNumber(life, this.locale);
        const _period = Math.trunc(toNumber(period, this.locale));
        const _month = args.length ? Math.trunc(toNumber(args[0], this.locale)) : 12;
        const lifeLimit = _life + (_month === 12 ? 0 : 1);
        assertCostPositiveOrZero(_cost);
        assertSalvagePositiveOrZero(_salvage);
        assertPeriodStrictlyPositive(_period);
        assertLifeStrictlyPositive(_life);
        assert(() => 1 <= _month && _month <= 12, _t("The month (%s) must be between 1 and 12 inclusive.", _month.toString()));
        assert(() => _period <= lifeLimit, _t("The period (%s) must be less than or equal to %s.", _period.toString(), lifeLimit.toString()));
        const monthPart = _month / 12;
        let rate = 1 - Math.pow(_salvage / _cost, 1 / _life);
        // round to 3 decimal places
        rate = Math.round(rate * 1000) / 1000;
        let before = _cost;
        let after = _cost * (1 - rate * monthPart);
        for (let i = 1; i < _period; i++) {
            before = after;
            after = before * (1 - rate);
            if (i === _life) {
                after = before * (1 - rate * (1 - monthPart));
            }
        }
        return {
            value: before - after,
            format: "#,##0.00",
        };
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// DDB
// -----------------------------------------------------------------------------
const DEFAULT_DDB_DEPRECIATION_FACTOR = 2;
function ddb(cost, salvage, life, period, factor) {
    assertCostPositiveOrZero(cost);
    assertSalvagePositiveOrZero(salvage);
    assertPeriodStrictlyPositive(period);
    assertLifeStrictlyPositive(life);
    assertPeriodSmallerOrEqualToLife(period, life);
    assertDeprecationFactorStrictlyPositive(factor);
    if (cost === 0 || salvage >= cost)
        return 0;
    const deprecFactor = factor / life;
    if (deprecFactor > 1) {
        return period === 1 ? cost - salvage : 0;
    }
    if (period <= 1) {
        return cost * deprecFactor;
    }
    const previousCost = cost * Math.pow(1 - deprecFactor, period - 1);
    const nextCost = cost * Math.pow(1 - deprecFactor, period);
    const deprec = nextCost < salvage ? previousCost - salvage : previousCost - nextCost;
    return Math.max(deprec, 0);
}
const DDB = {
    description: _t("Depreciation via double-declining balance method."),
    args: [
        arg("cost (number)", _t("The initial cost of the asset.")),
        arg("salvage (number)", _t("The value of the asset at the end of depreciation.")),
        arg("life (number)", _t("The number of periods over which the asset is depreciated.")),
        arg("period (number)", _t("The single period within life for which to calculate depreciation.")),
        arg(`factor (number, default=${DEFAULT_DDB_DEPRECIATION_FACTOR})`, _t("The factor by which depreciation decreases.")),
    ],
    compute: function (cost, salvage, life, period, factor = { value: DEFAULT_DDB_DEPRECIATION_FACTOR }) {
        const _cost = toNumber(cost, this.locale);
        const _salvage = toNumber(salvage, this.locale);
        const _life = toNumber(life, this.locale);
        const _period = toNumber(period, this.locale);
        const _factor = toNumber(factor, this.locale);
        return {
            value: ddb(_cost, _salvage, _life, _period, _factor),
            format: "#,##0.00",
        };
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// DISC
// -----------------------------------------------------------------------------
const DISC = {
    description: _t("Discount rate of a security based on price."),
    args: [
        arg("settlement (date)", _t("The settlement date of the security, the date after issuance when the security is delivered to the buyer.")),
        arg("maturity (date)", _t("The maturity or end date of the security, when it can be redeemed at face, or par value.")),
        arg("price (number)", _t("The price at which the security is bought per 100 face value.")),
        arg("redemption (number)", _t("The redemption amount per 100 face value, or par.")),
        arg(`day_count_convention (number, default=${DEFAULT_DAY_COUNT_CONVENTION} )`, _t("An indicator of what day count method to use.")),
    ],
    compute: function (settlement, maturity, price, redemption, dayCountConvention = { value: DEFAULT_DAY_COUNT_CONVENTION }) {
        dayCountConvention = dayCountConvention || 0;
        const _settlement = Math.trunc(toNumber(settlement, this.locale));
        const _maturity = Math.trunc(toNumber(maturity, this.locale));
        const _price = toNumber(price, this.locale);
        const _redemption = toNumber(redemption, this.locale);
        const _dayCountConvention = Math.trunc(toNumber(dayCountConvention, this.locale));
        assertMaturityAndSettlementDatesAreValid(_settlement, _maturity);
        assertDayCountConventionIsValid(_dayCountConvention);
        assertPriceStrictlyPositive(_price);
        assertRedemptionStrictlyPositive(_redemption);
        /**
         * https://support.microsoft.com/en-us/office/disc-function-71fce9f3-3f05-4acf-a5a3-eac6ef4daa53
         *
         * B = number of days in year, depending on year basis
         * DSM = number of days from settlement to maturity
         *
         *        redemption - price          B
         * DISC = ____________________  *    ____
         *            redemption             DSM
         */
        const yearsFrac = getYearFrac(_settlement, _maturity, _dayCountConvention);
        return (_redemption - _price) / _redemption / yearsFrac;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// DOLLARDE
// -----------------------------------------------------------------------------
const DOLLARDE = {
    description: _t("Convert a decimal fraction to decimal value."),
    args: [
        arg("fractional_price (number)", _t("The price quotation given using fractional decimal conventions.")),
        arg("unit (number)", _t("The units of the fraction, e.g. 8 for 1/8ths or 32 for 1/32nds.")),
    ],
    compute: function (fractionalPrice, unit) {
        const price = toNumber(fractionalPrice, this.locale);
        const _unit = Math.trunc(toNumber(unit, this.locale));
        assert(() => _unit > 0, _t("The unit (%s) must be strictly positive.", _unit.toString()));
        const truncatedPrice = Math.trunc(price);
        const priceFractionalPart = price - truncatedPrice;
        const frac = 10 ** Math.ceil(Math.log10(_unit)) / _unit;
        return truncatedPrice + priceFractionalPart * frac;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// DOLLARFR
// -----------------------------------------------------------------------------
const DOLLARFR = {
    description: _t("Convert a decimal value to decimal fraction."),
    args: [
        arg("decimal_price (number)", _t("The price quotation given as a decimal value.")),
        arg("unit (number)", _t("The units of the desired fraction, e.g. 8 for 1/8ths or 32 for 1/32nds.")),
    ],
    compute: function (decimalPrice, unit) {
        const price = toNumber(decimalPrice, this.locale);
        const _unit = Math.trunc(toNumber(unit, this.locale));
        assert(() => _unit > 0, _t("The unit (%s) must be strictly positive.", _unit.toString()));
        const truncatedPrice = Math.trunc(price);
        const priceFractionalPart = price - truncatedPrice;
        const frac = _unit / 10 ** Math.ceil(Math.log10(_unit));
        return truncatedPrice + priceFractionalPart * frac;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// DURATION
// -----------------------------------------------------------------------------
const DURATION = {
    description: _t("Number of periods for an investment to reach a value."),
    args: [
        arg("settlement (date)", _t("The settlement date of the security, the date after issuance when the security is delivered to the buyer.")),
        arg("maturity (date)", _t("The maturity or end date of the security, when it can be redeemed at face, or par value.")),
        arg("rate (number)", _t("The annualized rate of interest.")),
        arg("yield (number)", _t("The expected annual yield of the security.")),
        arg("frequency (number)", _t("The number of interest or coupon payments per year (1, 2, or 4).")),
        arg(`day_count_convention (number, default=${DEFAULT_DAY_COUNT_CONVENTION} )`, _t("An indicator of what day count method to use.")),
    ],
    compute: function (settlement, maturity, rate, securityYield, frequency, dayCountConvention = { value: DEFAULT_DAY_COUNT_CONVENTION }) {
        const start = Math.trunc(toNumber(settlement, this.locale));
        const end = Math.trunc(toNumber(maturity, this.locale));
        const _rate = toNumber(rate, this.locale);
        const _yield = toNumber(securityYield, this.locale);
        const _frequency = Math.trunc(toNumber(frequency, this.locale));
        const _dayCountConvention = Math.trunc(toNumber(dayCountConvention, this.locale));
        assertMaturityAndSettlementDatesAreValid(start, end);
        assertCouponFrequencyIsValid(_frequency);
        assertDayCountConventionIsValid(_dayCountConvention);
        assert(() => _rate >= 0, _t("The rate (%s) must be positive or null.", _rate.toString()));
        assert(() => _yield >= 0, _t("The yield (%s) must be positive or null.", _yield.toString()));
        const years = getYearFrac(start, end, _dayCountConvention);
        const timeFirstYear = years - Math.trunc(years) || 1 / _frequency;
        const nbrCoupons = Math.ceil(years * _frequency);
        // The DURATION function return the Macaulay duration
        // See example: https://en.wikipedia.org/wiki/Bond_duration#Formulas
        const cashFlowFromCoupon = _rate / _frequency;
        const yieldPerPeriod = _yield / _frequency;
        let count = 0;
        let sum = 0;
        for (let i = 1; i <= nbrCoupons; i++) {
            const cashFlowPerPeriod = cashFlowFromCoupon + (i === nbrCoupons ? 1 : 0);
            const presentValuePerPeriod = cashFlowPerPeriod / (1 + yieldPerPeriod) ** i;
            sum += (timeFirstYear + (i - 1) / _frequency) * presentValuePerPeriod;
            count += presentValuePerPeriod;
        }
        return count === 0 ? 0 : sum / count;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// EFFECT
// -----------------------------------------------------------------------------
const EFFECT = {
    description: _t("Annual effective interest rate."),
    args: [
        arg("nominal_rate (number)", _t("The nominal interest rate per year.")),
        arg("periods_per_year (number)", _t("The number of compounding periods per year.")),
    ],
    compute: function (nominal_rate, periods_per_year) {
        const nominal = toNumber(nominal_rate, this.locale);
        const periods = Math.trunc(toNumber(periods_per_year, this.locale));
        assert(() => nominal > 0, _t("The nominal rate (%s) must be strictly greater than 0.", nominal.toString()));
        assert(() => periods > 0, _t("The number of periods by year (%s) must strictly greater than 0.", periods.toString()));
        // https://en.wikipedia.org/wiki/Nominal_interest_rate#Nominal_versus_effective_interest_rate
        return Math.pow(1 + nominal / periods, periods) - 1;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// FV
// -----------------------------------------------------------------------------
const DEFAULT_PRESENT_VALUE = 0;
function fv(r, n, p, pv, t) {
    if (r === 0) {
        return -(pv + p * n);
    }
    return -pv * (1 + r) ** n - (p * (1 + r * t) * ((1 + r) ** n - 1)) / r;
}
const FV = {
    description: _t("Future value of an annuity investment."),
    args: [
        arg("rate (number)", _t("The interest rate.")),
        arg("number_of_periods (number)", _t("The number of payments to be made.")),
        arg("payment_amount (number)", _t("The amount per period to be paid.")),
        arg(`present_value (number, default=${DEFAULT_PRESENT_VALUE})`, _t("The current value of the annuity.")),
        arg(`end_or_beginning (number, default=${DEFAULT_END_OR_BEGINNING})`, _t("Whether payments are due at the end (0) or beginning (1) of each period.")),
    ],
    // to do: replace by dollar format
    compute: function (rate, numberOfPeriods, paymentAmount, presentValue = { value: DEFAULT_PRESENT_VALUE }, endOrBeginning = { value: DEFAULT_END_OR_BEGINNING }) {
        presentValue = presentValue || 0;
        endOrBeginning = endOrBeginning || 0;
        const r = toNumber(rate, this.locale);
        const n = toNumber(numberOfPeriods, this.locale);
        const p = toNumber(paymentAmount, this.locale);
        const pv = toNumber(presentValue, this.locale);
        const type = toBoolean(endOrBeginning) ? 1 : 0;
        return {
            value: fv(r, n, p, pv, type),
            format: "#,##0.00",
        };
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// FVSCHEDULE
// -----------------------------------------------------------------------------
const FVSCHEDULE = {
    description: _t("Future value of principal from series of rates."),
    args: [
        arg("principal (number)", _t("The amount of initial capital or value to compound against.")),
        arg("rate_schedule (number, range<number>)", _t("A series of interest rates to compound against the principal.")),
    ],
    compute: function (principalAmount, rateSchedule) {
        const principal = toNumber(principalAmount, this.locale);
        return reduceAny([rateSchedule], (acc, rate) => acc * (1 + toNumber(rate, this.locale)), principal);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// INTRATE
// -----------------------------------------------------------------------------
const INTRATE = {
    description: _t("Calculates effective interest rate."),
    args: [
        arg("settlement (date)", _t("The settlement date of the security, the date after issuance when the security is delivered to the buyer.")),
        arg("maturity (date)", _t("The maturity or end date of the security, when it can be redeemed at face, or par value.")),
        arg("investment (number)", _t("The amount invested in the security.")),
        arg("redemption (number)", _t("The amount to be received at maturity.")),
        arg(`day_count_convention (number, default=${DEFAULT_DAY_COUNT_CONVENTION} )`, _t("An indicator of what day count method to use.")),
    ],
    compute: function (settlement, maturity, investment, redemption, dayCountConvention = { value: DEFAULT_DAY_COUNT_CONVENTION }) {
        const _settlement = Math.trunc(toNumber(settlement, this.locale));
        const _maturity = Math.trunc(toNumber(maturity, this.locale));
        const _redemption = toNumber(redemption, this.locale);
        const _investment = toNumber(investment, this.locale);
        const _dayCountConvention = Math.trunc(toNumber(dayCountConvention, this.locale));
        assertMaturityAndSettlementDatesAreValid(_settlement, _maturity);
        assertInvestmentStrictlyPositive(_investment);
        assertRedemptionStrictlyPositive(_redemption);
        assertDayCountConventionIsValid(_dayCountConvention);
        /**
         * https://wiki.documentfoundation.org/Documentation/Calc_Functions/INTRATE
         *
         *             (Redemption  - Investment) / Investment
         * INTRATE =  _________________________________________
         *              YEARFRAC(settlement, maturity, basis)
         */
        const yearFrac = getYearFrac(_settlement, _maturity, _dayCountConvention);
        return (_redemption - _investment) / _investment / yearFrac;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// IPMT
// -----------------------------------------------------------------------------
function impt(r, per, n, pv, fv, type) {
    return pmt(r, n, pv, fv, type) - ppmt(r, per, n, pv, fv, type);
}
const IPMT = {
    description: _t("Payment on the principal of an investment."),
    args: [
        arg("rate (number)", _t("The annualized rate of interest.")),
        arg("period (number)", _t("The amortization period, in terms of number of periods.")),
        arg("number_of_periods (number)", _t("The number of payments to be made.")),
        arg("present_value (number)", _t("The current value of the annuity.")),
        arg(`future_value (number, default=${DEFAULT_FUTURE_VALUE})`, _t("The future value remaining after the final payment has been made.")),
        arg(`end_or_beginning (number, default=${DEFAULT_END_OR_BEGINNING})`, _t("Whether payments are due at the end (0) or beginning (1) of each period.")),
    ],
    compute: function (rate, currentPeriod, numberOfPeriods, presentValue, futureValue = { value: DEFAULT_FUTURE_VALUE }, endOrBeginning = { value: DEFAULT_END_OR_BEGINNING }) {
        const r = toNumber(rate, this.locale);
        const period = toNumber(currentPeriod, this.locale);
        const n = toNumber(numberOfPeriods, this.locale);
        const pv = toNumber(presentValue, this.locale);
        const fv = toNumber(futureValue, this.locale);
        const type = toBoolean(endOrBeginning) ? 1 : 0;
        return {
            value: impt(r, period, n, pv, fv, type),
            format: "#,##0.00",
        };
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// IRR
// -----------------------------------------------------------------------------
const DEFAULT_RATE_GUESS = 0.1;
const IRR = {
    description: _t("Internal rate of return given periodic cashflows."),
    args: [
        arg("cashflow_amounts (number, range<number>)", _t("An array or range containing the income or payments associated with the investment.")),
        arg(`rate_guess (number, default=${DEFAULT_RATE_GUESS})`, _t("An estimate for what the internal rate of return will be.")),
    ],
    compute: function (cashFlowAmounts, rateGuess = { value: DEFAULT_RATE_GUESS }) {
        const _rateGuess = toNumber(rateGuess, this.locale);
        assertRateGuessStrictlyGreaterThanMinusOne(_rateGuess);
        // check that values contains at least one positive value and one negative value
        // and extract number present in the cashFlowAmount argument
        let positive = false;
        let negative = false;
        let amounts = [];
        visitNumbers([cashFlowAmounts], ({ value: amount }) => {
            if (amount > 0)
                positive = true;
            if (amount < 0)
                negative = true;
            amounts.push(amount);
        }, this.locale);
        assert(() => positive && negative, _t("The cashflow_amounts must include negative and positive values."));
        const firstAmount = amounts.shift();
        // The result of IRR is the rate at which the NPV() function will return zero with the given values.
        // This algorithm uses the Newton's method on the NPV function to determine the result
        // Newton's method: https://en.wikipedia.org/wiki/Newton%27s_method
        // As the NPV function isn't continuous, we apply the Newton's method on the numerator of the NPV formula.
        function npvNumerator(rate, startValue, values) {
            const nbrValue = values.length;
            let i = 0;
            return values.reduce((acc, v) => {
                i++;
                return acc + v * rate ** (nbrValue - i);
            }, startValue * rate ** nbrValue);
        }
        function npvNumeratorDeriv(rate, startValue, values) {
            const nbrValue = values.length;
            let i = 0;
            return values.reduce((acc, v) => {
                i++;
                return acc + v * (nbrValue - i) * rate ** (nbrValue - i - 1);
            }, startValue * nbrValue * rate ** (nbrValue - 1));
        }
        function func(x) {
            return npvNumerator(x, firstAmount, amounts);
        }
        function derivFunc(x) {
            return npvNumeratorDeriv(x, firstAmount, amounts);
        }
        return {
            value: newtonMethod(func, derivFunc, _rateGuess + 1, 20, 1e-5) - 1,
            format: "0%",
        };
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// ISPMT
// -----------------------------------------------------------------------------
const ISPMT = {
    description: _t("Returns the interest paid at a particular period of an investment."),
    args: [
        arg("rate (number)", _t("The interest rate.")),
        arg("period (number)", _t("The period for which you want to view the interest payment.")),
        arg("number_of_periods (number)", _t("The number of payments to be made.")),
        arg("present_value (number)", _t("The current value of the annuity.")),
    ],
    compute: function (rate, currentPeriod, numberOfPeriods, presentValue) {
        const interestRate = toNumber(rate, this.locale);
        const period = toNumber(currentPeriod, this.locale);
        const nOfPeriods = toNumber(numberOfPeriods, this.locale);
        const investment = toNumber(presentValue, this.locale);
        assert(() => nOfPeriods !== 0, _t("The number of periods must be different than 0.", nOfPeriods.toString()));
        const currentInvestment = investment - investment * (period / nOfPeriods);
        return -1 * currentInvestment * interestRate;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// MDURATION
// -----------------------------------------------------------------------------
const MDURATION = {
    description: _t("Modified Macaulay duration."),
    args: [
        arg("settlement (date)", _t("The settlement date of the security, the date after issuance when the security is delivered to the buyer.")),
        arg("maturity (date)", _t("The maturity or end date of the security, when it can be redeemed at face, or par value.")),
        arg("rate (number)", _t("The annualized rate of interest.")),
        arg("yield (number)", _t("The expected annual yield of the security.")),
        arg("frequency (number)", _t("The number of interest or coupon payments per year (1, 2, or 4).")),
        arg(`day_count_convention (number, default=${DEFAULT_DAY_COUNT_CONVENTION} )`, _t("An indicator of what day count method to use.")),
    ],
    compute: function (settlement, maturity, rate, securityYield, frequency, dayCountConvention = { value: DEFAULT_DAY_COUNT_CONVENTION }) {
        const duration = DURATION.compute.bind(this)(settlement, maturity, rate, securityYield, frequency, dayCountConvention);
        const y = toNumber(securityYield, this.locale);
        const k = Math.trunc(toNumber(frequency, this.locale));
        return duration / (1 + y / k);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// MIRR
// -----------------------------------------------------------------------------
const MIRR = {
    description: _t("Modified internal rate of return."),
    args: [
        arg("cashflow_amounts (range<number>)", _t("A range containing the income or payments associated with the investment. The array should contain bot payments and incomes.")),
        arg("financing_rate (number)", _t("The interest rate paid on funds invested.")),
        arg("reinvestment_return_rate (number)", _t("The return (as a percentage) earned on reinvestment of income received from the investment.")),
    ],
    compute: function (cashflowAmount, financingRate, reinvestmentRate) {
        const fRate = toNumber(financingRate, this.locale);
        const rRate = toNumber(reinvestmentRate, this.locale);
        const cashFlow = transposeMatrix(cashflowAmount)
            .flat()
            .filter((t) => t.value !== null)
            .map((val) => toNumber(val, this.locale));
        const n = cashFlow.length;
        /**
         * https://en.wikipedia.org/wiki/Modified_internal_rate_of_return
         *
         *         /  FV(positive cash flows, reinvestment rate) \  ^ (1 / (n - 1))
         * MIRR = |  ___________________________________________  |                 - 1
         *         \   - PV(negative cash flows, finance rate)   /
         *
         * with n the number of cash flows.
         *
         * You can compute FV and PV as :
         *
         * FV =    SUM      [ (cashFlow[i]>0 ? cashFlow[i] : 0) * (1 + rRate)**(n - i-1) ]
         *       i= 0 => n
         *
         * PV =    SUM      [ (cashFlow[i]<0 ? cashFlow[i] : 0) / (1 + fRate)**i ]
         *       i= 0 => n
         */
        let fv = 0;
        let pv = 0;
        for (const i of range(0, n)) {
            const amount = cashFlow[i];
            if (amount >= 0) {
                fv += amount * (rRate + 1) ** (n - i - 1);
            }
            else {
                pv += amount / (fRate + 1) ** i;
            }
        }
        assert(() => pv !== 0 && fv !== 0, _t("There must be both positive and negative values in cashflow_amounts."));
        const exponent = 1 / (n - 1);
        return (-fv / pv) ** exponent - 1;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// NOMINAL
// -----------------------------------------------------------------------------
const NOMINAL = {
    description: _t("Annual nominal interest rate."),
    args: [
        arg("effective_rate (number)", _t("The effective interest rate per year.")),
        arg("periods_per_year (number)", _t("The number of compounding periods per year.")),
    ],
    compute: function (effective_rate, periods_per_year) {
        const effective = toNumber(effective_rate, this.locale);
        const periods = Math.trunc(toNumber(periods_per_year, this.locale));
        assert(() => effective > 0, _t("The effective rate (%s) must must strictly greater than 0.", effective.toString()));
        assert(() => periods > 0, _t("The number of periods by year (%s) must strictly greater than 0.", periods.toString()));
        // https://en.wikipedia.org/wiki/Nominal_interest_rate#Nominal_versus_effective_interest_rate
        return (Math.pow(effective + 1, 1 / periods) - 1) * periods;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// NPER
// -----------------------------------------------------------------------------
const NPER = {
    description: _t("Number of payment periods for an investment."),
    args: [
        arg("rate (number)", _t("The interest rate.")),
        arg("payment_amount (number)", _t("The amount of each payment made.")),
        arg("present_value (number)", _t("The current value of the annuity.")),
        arg(`future_value (number, default=${DEFAULT_FUTURE_VALUE})`, _t("The future value remaining after the final payment has been made.")),
        arg(`end_or_beginning (number, default=${DEFAULT_END_OR_BEGINNING})`, _t("Whether payments are due at the end (0) or beginning (1) of each period.")),
    ],
    compute: function (rate, paymentAmount, presentValue, futureValue = { value: DEFAULT_FUTURE_VALUE }, endOrBeginning = { value: DEFAULT_END_OR_BEGINNING }) {
        futureValue = futureValue || 0;
        endOrBeginning = endOrBeginning || 0;
        const r = toNumber(rate, this.locale);
        const p = toNumber(paymentAmount, this.locale);
        const pv = toNumber(presentValue, this.locale);
        const fv = toNumber(futureValue, this.locale);
        const t = toBoolean(endOrBeginning) ? 1 : 0;
        /**
         * https://wiki.documentfoundation.org/Documentation/Calc_Functions/NPER
         *
         * 0 = pv * (1 + r)^N + fv + [ p * (1 + r * t) * ((1 + r)^N - 1) ] / r
         *
         * We solve the equation for N:
         *
         * with C = [ p * (1 + r * t)] / r and
         *      R = 1 + r
         *
         * => 0 = pv * R^N + C * R^N - C + fv
         * <=> (C - fv) = R^N * (pv + C)
         * <=> log[(C - fv) / (pv + C)] = N * log(R)
         */
        if (r === 0) {
            return -(fv + pv) / p;
        }
        const c = (p * (1 + r * t)) / r;
        return Math.log((c - fv) / (pv + c)) / Math.log(1 + r);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// NPV
// -----------------------------------------------------------------------------
function npvResult(r, startValue, values, locale) {
    let i = 0;
    return reduceNumbers(values, (acc, v) => {
        i++;
        return acc + v / (1 + r) ** i;
    }, startValue, locale);
}
const NPV = {
    description: _t("The net present value of an investment based on a series of periodic cash flows and a discount rate."),
    args: [
        arg("discount (number)", _t("The discount rate of the investment over one period.")),
        arg("cashflow1 (number, range<number>)", _t("The first future cash flow.")),
        arg("cashflow2 (number, range<number>, repeating)", _t("Additional future cash flows.")),
    ],
    // to do: replace by dollar format
    compute: function (discount, ...values) {
        const _discount = toNumber(discount, this.locale);
        assert(() => _discount !== -1, _t("The discount (%s) must be different from -1.", _discount.toString()));
        return {
            value: npvResult(_discount, 0, values, this.locale),
            format: "#,##0.00",
        };
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// PDURATION
// -----------------------------------------------------------------------------
const PDURATION = {
    description: _t("Computes the number of periods needed for an investment to reach a value."),
    args: [
        arg("rate (number)", _t("The rate at which the investment grows each period.")),
        arg("present_value (number)", _t("The investment's current value.")),
        arg("future_value (number)", _t("The investment's desired future value.")),
    ],
    compute: function (rate, presentValue, futureValue) {
        const _rate = toNumber(rate, this.locale);
        const _presentValue = toNumber(presentValue, this.locale);
        const _futureValue = toNumber(futureValue, this.locale);
        assertRateStrictlyPositive(_rate);
        assert(() => _presentValue > 0, _t("The present_value (%s) must be strictly positive.", _presentValue.toString()));
        assert(() => _futureValue > 0, _t("The future_value (%s) must be strictly positive.", _futureValue.toString()));
        return (Math.log(_futureValue) - Math.log(_presentValue)) / Math.log(1 + _rate);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// PMT
// -----------------------------------------------------------------------------
function pmt(r, n, pv, fv, t) {
    assertNumberOfPeriodsStrictlyPositive(n);
    /**
     * https://wiki.documentfoundation.org/Documentation/Calc_Functions/PMT
     *
     * 0 = pv * (1 + r)^N + fv + [ p * (1 + r * t) * ((1 + r)^N - 1) ] / r
     *
     * We simply the equation for p
     */
    if (r === 0) {
        return -(fv + pv) / n;
    }
    let payment = -(pv * (1 + r) ** n + fv);
    payment = (payment * r) / ((1 + r * t) * ((1 + r) ** n - 1));
    return payment;
}
const PMT = {
    description: _t("Periodic payment for an annuity investment."),
    args: [
        arg("rate (number)", _t("The annualized rate of interest.")),
        arg("number_of_periods (number)", _t("The number of payments to be made.")),
        arg("present_value (number)", _t("The current value of the annuity.")),
        arg(`future_value (number, default=${DEFAULT_FUTURE_VALUE})`, _t("The future value remaining after the final payment has been made.")),
        arg(`end_or_beginning (number, default=${DEFAULT_END_OR_BEGINNING})`, _t("Whether payments are due at the end (0) or beginning (1) of each period.")),
    ],
    compute: function (rate, numberOfPeriods, presentValue, futureValue = { value: DEFAULT_FUTURE_VALUE }, endOrBeginning = { value: DEFAULT_END_OR_BEGINNING }) {
        const n = toNumber(numberOfPeriods, this.locale);
        const r = toNumber(rate, this.locale);
        const t = toBoolean(endOrBeginning) ? 1 : 0;
        const fv = toNumber(futureValue, this.locale);
        const pv = toNumber(presentValue, this.locale);
        return { value: pmt(r, n, pv, fv, t), format: "#,##0.00" };
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// PPMT
// -----------------------------------------------------------------------------
function ppmt(r, per, n, pValue, fValue, t) {
    assertNumberOfPeriodsStrictlyPositive(n);
    assert(() => per > 0 && per <= n, _t("The period must be between 1 and number_of_periods (%s)", n));
    const payment = pmt(r, n, pValue, fValue, t);
    if (t === 1 && per === 1)
        return payment;
    const eqPeriod = t === 0 ? per - 1 : per - 2;
    const eqPv = pValue + payment * t;
    const capitalAtPeriod = -fv(r, eqPeriod, payment, eqPv, 0);
    const currentInterest = capitalAtPeriod * r;
    return payment + currentInterest;
}
const PPMT = {
    description: _t("Payment on the principal of an investment."),
    args: [
        arg("rate (number)", _t("The annualized rate of interest.")),
        arg("period (number)", _t("The amortization period, in terms of number of periods.")),
        arg("number_of_periods (number)", _t("The number of payments to be made.")),
        arg("present_value (number)", _t("The current value of the annuity.")),
        arg(`future_value (number, default=${DEFAULT_FUTURE_VALUE})`, _t("The future value remaining after the final payment has been made.")),
        arg(`end_or_beginning (number, default=${DEFAULT_END_OR_BEGINNING})`, _t("Whether payments are due at the end (0) or beginning (1) of each period.")),
    ],
    compute: function (rate, currentPeriod, numberOfPeriods, presentValue, futureValue = { value: DEFAULT_FUTURE_VALUE }, endOrBeginning = { value: DEFAULT_END_OR_BEGINNING }) {
        const n = toNumber(numberOfPeriods, this.locale);
        const r = toNumber(rate, this.locale);
        const period = toNumber(currentPeriod, this.locale);
        const type = toBoolean(endOrBeginning) ? 1 : 0;
        const fv = toNumber(futureValue, this.locale);
        const pv = toNumber(presentValue, this.locale);
        return {
            value: ppmt(r, period, n, pv, fv, type),
            format: "#,##0.00",
        };
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// PV
// -----------------------------------------------------------------------------
const PV = {
    description: _t("Present value of an annuity investment."),
    args: [
        arg("rate (number)", _t("The interest rate.")),
        arg("number_of_periods (number)", _t("The number of payments to be made.")),
        arg("payment_amount (number)", _t("The amount per period to be paid.")),
        arg(`future_value (number, default=${DEFAULT_FUTURE_VALUE})`, _t("The future value remaining after the final payment has been made.")),
        arg(`end_or_beginning (number, default=${DEFAULT_END_OR_BEGINNING})`, _t("Whether payments are due at the end (0) or beginning (1) of each period.")),
    ],
    // to do: replace by dollar format
    compute: function (rate, numberOfPeriods, paymentAmount, futureValue = { value: DEFAULT_FUTURE_VALUE }, endOrBeginning = { value: DEFAULT_END_OR_BEGINNING }) {
        futureValue = futureValue || 0;
        endOrBeginning = endOrBeginning || 0;
        const r = toNumber(rate, this.locale);
        const n = toNumber(numberOfPeriods, this.locale);
        const p = toNumber(paymentAmount, this.locale);
        const fv = toNumber(futureValue, this.locale);
        const type = toBoolean(endOrBeginning) ? 1 : 0;
        // https://wiki.documentfoundation.org/Documentation/Calc_Functions/PV
        return {
            value: r
                ? -((p * (1 + r * type) * ((1 + r) ** n - 1)) / r + fv) / (1 + r) ** n
                : -(fv + p * n),
            format: "#,##0.00",
        };
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// PRICE
// -----------------------------------------------------------------------------
const PRICE = {
    description: _t("Price of a security paying periodic interest."),
    args: [
        arg("settlement (date)", _t("The settlement date of the security, the date after issuance when the security is delivered to the buyer.")),
        arg("maturity (date)", _t("The maturity or end date of the security, when it can be redeemed at face, or par value.")),
        arg("rate (number)", _t("The annualized rate of interest.")),
        arg("yield (number)", _t("The expected annual yield of the security.")),
        arg("redemption (number)", _t("The redemption amount per 100 face value, or par.")),
        arg("frequency (number)", _t("The number of interest or coupon payments per year (1, 2, or 4).")),
        arg(`day_count_convention (number, default=${DEFAULT_DAY_COUNT_CONVENTION} )`, _t("An indicator of what day count method to use.")),
    ],
    compute: function (settlement, maturity, rate, securityYield, redemption, frequency, dayCountConvention = { value: DEFAULT_DAY_COUNT_CONVENTION }) {
        dayCountConvention = dayCountConvention || 0;
        const _settlement = Math.trunc(toNumber(settlement, this.locale));
        const _maturity = Math.trunc(toNumber(maturity, this.locale));
        const _rate = toNumber(rate, this.locale);
        const _yield = toNumber(securityYield, this.locale);
        const _redemption = toNumber(redemption, this.locale);
        const _frequency = Math.trunc(toNumber(frequency, this.locale));
        const _dayCountConvention = Math.trunc(toNumber(dayCountConvention, this.locale));
        assertMaturityAndSettlementDatesAreValid(_settlement, _maturity);
        assertCouponFrequencyIsValid(_frequency);
        assertDayCountConventionIsValid(_dayCountConvention);
        assert(() => _rate >= 0, _t("The rate (%s) must be positive or null.", _rate.toString()));
        assert(() => _yield >= 0, _t("The yield (%s) must be positive or null.", _yield.toString()));
        assertRedemptionStrictlyPositive(_redemption);
        const years = getYearFrac(_settlement, _maturity, _dayCountConvention);
        const nbrRealCoupons = years * _frequency;
        const nbrFullCoupons = Math.ceil(nbrRealCoupons);
        const timeFirstCoupon = nbrRealCoupons - Math.floor(nbrRealCoupons) || 1;
        const yieldFactorPerPeriod = 1 + _yield / _frequency;
        const cashFlowFromCoupon = (100 * _rate) / _frequency;
        if (nbrFullCoupons === 1) {
            return ((cashFlowFromCoupon + _redemption) / ((timeFirstCoupon * _yield) / _frequency + 1) -
                cashFlowFromCoupon * (1 - timeFirstCoupon));
        }
        let cashFlowsPresentValue = 0;
        for (let i = 1; i <= nbrFullCoupons; i++) {
            cashFlowsPresentValue +=
                cashFlowFromCoupon / yieldFactorPerPeriod ** (i - 1 + timeFirstCoupon);
        }
        const redemptionPresentValue = _redemption / yieldFactorPerPeriod ** (nbrFullCoupons - 1 + timeFirstCoupon);
        return (redemptionPresentValue + cashFlowsPresentValue - cashFlowFromCoupon * (1 - timeFirstCoupon));
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// PRICEDISC
// -----------------------------------------------------------------------------
const PRICEDISC = {
    description: _t("Price of a discount security."),
    args: [
        arg("settlement (date)", _t("The settlement date of the security, the date after issuance when the security is delivered to the buyer.")),
        arg("maturity (date)", _t("The maturity or end date of the security, when it can be redeemed at face, or par value.")),
        arg("discount (number)", _t("The discount rate of the security at time of purchase.")),
        arg("redemption (number)", _t("The redemption amount per 100 face value, or par.")),
        arg(`day_count_convention (number, default=${DEFAULT_DAY_COUNT_CONVENTION} )`, _t("An indicator of what day count method to use.")),
    ],
    compute: function (settlement, maturity, discount, redemption, dayCountConvention = { value: DEFAULT_DAY_COUNT_CONVENTION }) {
        dayCountConvention = dayCountConvention || 0;
        const _settlement = Math.trunc(toNumber(settlement, this.locale));
        const _maturity = Math.trunc(toNumber(maturity, this.locale));
        const _discount = toNumber(discount, this.locale);
        const _redemption = toNumber(redemption, this.locale);
        const _dayCountConvention = Math.trunc(toNumber(dayCountConvention, this.locale));
        assertMaturityAndSettlementDatesAreValid(_settlement, _maturity);
        assertDayCountConventionIsValid(_dayCountConvention);
        assertDiscountStrictlyPositive(_discount);
        assertRedemptionStrictlyPositive(_redemption);
        /**
         * https://support.microsoft.com/en-us/office/pricedisc-function-d06ad7c1-380e-4be7-9fd9-75e3079acfd3
         *
         * B = number of days in year, depending on year basis
         * DSM = number of days from settlement to maturity
         *
         * PRICEDISC = redemption - discount * redemption * (DSM/B)
         */
        const yearsFrac = getYearFrac(_settlement, _maturity, _dayCountConvention);
        return _redemption - _discount * _redemption * yearsFrac;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// PRICEMAT
// -----------------------------------------------------------------------------
const PRICEMAT = {
    description: _t("Calculates the price of a security paying interest at maturity, based on expected yield."),
    args: [
        arg("settlement (date)", _t("The settlement date of the security, the date after issuance when the security is delivered to the buyer.")),
        arg("maturity (date)", _t("The maturity or end date of the security, when it can be redeemed at face, or par value.")),
        arg("issue (date)", _t("The date the security was initially issued.")),
        arg("rate (number)", _t("The annualized rate of interest.")),
        arg("yield (number)", _t("The expected annual yield of the security.")),
        arg(`day_count_convention (number, default=${DEFAULT_DAY_COUNT_CONVENTION} )`, _t("An indicator of what day count method to use.")),
    ],
    compute: function (settlement, maturity, issue, rate, securityYield, dayCountConvention = { value: DEFAULT_DAY_COUNT_CONVENTION }) {
        dayCountConvention = dayCountConvention || 0;
        const _settlement = Math.trunc(toNumber(settlement, this.locale));
        const _maturity = Math.trunc(toNumber(maturity, this.locale));
        const _issue = Math.trunc(toNumber(issue, this.locale));
        const _rate = toNumber(rate, this.locale);
        const _yield = toNumber(securityYield, this.locale);
        const _dayCount = Math.trunc(toNumber(dayCountConvention, this.locale));
        assertSettlementAndIssueDatesAreValid(_settlement, _issue);
        assertMaturityAndSettlementDatesAreValid(_settlement, _maturity);
        assertDayCountConventionIsValid(_dayCount);
        assert(() => _rate >= 0, _t("The rate (%s) must be positive or null.", _rate.toString()));
        assert(() => _yield >= 0, _t("The yield (%s) must be positive or null.", _yield.toString()));
        /**
         * https://support.microsoft.com/en-us/office/pricemat-function-52c3b4da-bc7e-476a-989f-a95f675cae77
         *
         * B = number of days in year, depending on year basis
         * DSM = number of days from settlement to maturity
         * DIM = number of days from issue to maturity
         * DIS = number of days from issue to settlement
         *
         *             100 + (DIM/B * rate * 100)
         *  PRICEMAT =  __________________________   - (DIS/B * rate * 100)
         *              1 + (DSM/B * yield)
         *
         * The ratios number_of_days / days_in_year are computed using the YEARFRAC function, that handle
         * differences due to day count conventions.
         *
         * Compatibility note :
         *
         * Contrary to GSheet and OpenOffice, Excel doesn't seems to always use its own YEARFRAC function
         * to compute PRICEMAT, and give different values for some combinations of dates and day count
         * conventions ( notably for leap years and dayCountConvention = 1 (Actual/Actual)).
         *
         * Our function PRICEMAT give us the same results as LibreOffice Calc.
         * Google Sheet use the formula with YEARFRAC, but its YEARFRAC function results are different
         * from the results of Excel/LibreOffice, thus we get different values with PRICEMAT.
         *
         */
        const settlementToMaturity = getYearFrac(_settlement, _maturity, _dayCount);
        const issueToSettlement = getYearFrac(_settlement, _issue, _dayCount);
        const issueToMaturity = getYearFrac(_issue, _maturity, _dayCount);
        const numerator = 100 + issueToMaturity * _rate * 100;
        const denominator = 1 + settlementToMaturity * _yield;
        const term2 = issueToSettlement * _rate * 100;
        return numerator / denominator - term2;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// RATE
// -----------------------------------------------------------------------------
const RATE_GUESS_DEFAULT = 0.1;
const RATE = {
    description: _t("Interest rate of an annuity investment."),
    args: [
        arg("number_of_periods (number)", _t("The number of payments to be made.")),
        arg("payment_per_period (number)", _t("The amount per period to be paid.")),
        arg("present_value (number)", _t("The current value of the annuity.")),
        arg(`future_value (number, default=${DEFAULT_FUTURE_VALUE})`, _t("The future value remaining after the final payment has been made.")),
        arg(`end_or_beginning (number, default=${DEFAULT_END_OR_BEGINNING})`, _t("Whether payments are due at the end (0) or beginning (1) of each period.")),
        arg(`rate_guess (number, default=${RATE_GUESS_DEFAULT})`, _t("An estimate for what the interest rate will be.")),
    ],
    compute: function (numberOfPeriods, paymentPerPeriod, presentValue, futureValue = { value: DEFAULT_FUTURE_VALUE }, endOrBeginning = { value: DEFAULT_END_OR_BEGINNING }, rateGuess = { value: RATE_GUESS_DEFAULT }) {
        const n = toNumber(numberOfPeriods, this.locale);
        const payment = toNumber(paymentPerPeriod, this.locale);
        const type = toBoolean(endOrBeginning) ? 1 : 0;
        const guess = toNumber(rateGuess, this.locale) || RATE_GUESS_DEFAULT;
        let fv = toNumber(futureValue, this.locale);
        let pv = toNumber(presentValue, this.locale);
        assertNumberOfPeriodsStrictlyPositive(n);
        assert(() => [payment, pv, fv].some((val) => val > 0) && [payment, pv, fv].some((val) => val < 0), _t("There must be both positive and negative values in [payment_amount, present_value, future_value].", n.toString()));
        assertRateGuessStrictlyGreaterThanMinusOne(guess);
        fv -= payment * type;
        pv += payment * type;
        // https://github.com/apache/openoffice/blob/trunk/main/sc/source/core/tool/interpr2.cxx
        const func = (rate) => {
            const powN = Math.pow(1 + rate, n);
            const intResult = (powN - 1) / rate;
            return fv + pv * powN + payment * intResult;
        };
        const derivFunc = (rate) => {
            const powNMinus1 = Math.pow(1 + rate, n - 1);
            const powN = Math.pow(1 + rate, n);
            const intResult = (powN - 1) / rate;
            const intResultDeriv = (n * powNMinus1) / rate - intResult / rate;
            const fTermDerivation = pv * n * powNMinus1 + payment * intResultDeriv;
            return fTermDerivation;
        };
        return {
            value: newtonMethod(func, derivFunc, guess, 40, 1e-5),
            format: "0%",
        };
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// RECEIVED
// -----------------------------------------------------------------------------
const RECEIVED = {
    description: _t("Amount received at maturity for a security."),
    args: [
        arg("settlement (date)", _t("The settlement date of the security, the date after issuance when the security is delivered to the buyer.")),
        arg("maturity (date)", _t("The maturity or end date of the security, when it can be redeemed at face, or par value.")),
        arg("investment (number)", _t("The amount invested (irrespective of face value of each security).")),
        arg("discount (number)", _t("The discount rate of the security invested in.")),
        arg(`day_count_convention (number, default=${DEFAULT_DAY_COUNT_CONVENTION} )`, _t("An indicator of what day count method to use.")),
    ],
    compute: function (settlement, maturity, investment, discount, dayCountConvention = { value: DEFAULT_DAY_COUNT_CONVENTION }) {
        dayCountConvention = dayCountConvention || 0;
        const _settlement = Math.trunc(toNumber(settlement, this.locale));
        const _maturity = Math.trunc(toNumber(maturity, this.locale));
        const _investment = toNumber(investment, this.locale);
        const _discount = toNumber(discount, this.locale);
        const _dayCountConvention = Math.trunc(toNumber(dayCountConvention, this.locale));
        assertMaturityAndSettlementDatesAreValid(_settlement, _maturity);
        assertDayCountConventionIsValid(_dayCountConvention);
        assertInvestmentStrictlyPositive(_investment);
        assertDiscountStrictlyPositive(_discount);
        /**
         * https://support.microsoft.com/en-us/office/received-function-7a3f8b93-6611-4f81-8576-828312c9b5e5
         *
         *                    investment
         * RECEIVED = _________________________
         *              1 - discount * DSM / B
         *
         * with DSM = number of days from settlement to maturity and B = number of days in a year
         *
         * The ratio DSM/B can be computed with the YEARFRAC function to take the dayCountConvention into account.
         */
        const yearsFrac = getYearFrac(_settlement, _maturity, _dayCountConvention);
        return _investment / (1 - _discount * yearsFrac);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// RRI
// -----------------------------------------------------------------------------
const RRI = {
    description: _t("Computes the rate needed for an investment to reach a specific value within a specific number of periods."),
    args: [
        arg("number_of_periods (number)", _t("The number of periods.")),
        arg("present_value (number)", _t("The present value of the investment.")),
        arg("future_value (number)", _t("The future value of the investment.")),
    ],
    compute: function (numberOfPeriods, presentValue, futureValue) {
        const n = toNumber(numberOfPeriods, this.locale);
        const pv = toNumber(presentValue, this.locale);
        const fv = toNumber(futureValue, this.locale);
        assertNumberOfPeriodsStrictlyPositive(n);
        /**
         * https://support.microsoft.com/en-us/office/rri-function-6f5822d8-7ef1-4233-944c-79e8172930f4
         *
         * RRI = (future value / present value) ^ (1 / number of periods) - 1
         */
        return (fv / pv) ** (1 / n) - 1;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// SLN
// -----------------------------------------------------------------------------
const SLN = {
    description: _t("Depreciation of an asset using the straight-line method."),
    args: [
        arg("cost (number)", _t("The initial cost of the asset.")),
        arg("salvage (number)", _t("The value of the asset at the end of depreciation.")),
        arg("life (number)", _t("The number of periods over which the asset is depreciated.")),
    ],
    compute: function (cost, salvage, life) {
        const _cost = toNumber(cost, this.locale);
        const _salvage = toNumber(salvage, this.locale);
        const _life = toNumber(life, this.locale);
        // No assertion is done on the values of the arguments to be compatible with Excel/Gsheet that don't check the values.
        // It's up to the user to make sure the arguments make sense, which is good design because the user is smart.
        return {
            value: (_cost - _salvage) / _life,
            format: "#,##0.00",
        };
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// SYD
// -----------------------------------------------------------------------------
const SYD = {
    description: _t("Depreciation via sum of years digit method."),
    args: [
        arg("cost (number)", _t("The initial cost of the asset.")),
        arg("salvage (number)", _t("The value of the asset at the end of depreciation.")),
        arg("life (number)", _t("The number of periods over which the asset is depreciated.")),
        arg("period (number)", _t("The single period within life for which to calculate depreciation.")),
    ],
    compute: function (cost, salvage, life, period) {
        const _cost = toNumber(cost, this.locale);
        const _salvage = toNumber(salvage, this.locale);
        const _life = toNumber(life, this.locale);
        const _period = toNumber(period, this.locale);
        assertPeriodStrictlyPositive(_period);
        assertLifeStrictlyPositive(_life);
        assertPeriodSmallerOrEqualToLife(_period, _life);
        /**
         * This deprecation method use the sum of digits of the periods of the life as the deprecation factor.
         * For example for a life = 5, we have a deprecation factor or 1 + 2 + 3 + 4 + 5 = 15 = life * (life + 1) / 2 = F.
         *
         * The deprecation for a period p is then computed based on F and the remaining lifetime at the period P.
         *
         * deprecation = (cost - salvage) * (number of remaining periods / F)
         */
        const deprecFactor = (_life * (_life + 1)) / 2;
        const remainingPeriods = _life - _period + 1;
        return {
            value: (_cost - _salvage) * (remainingPeriods / deprecFactor),
            format: "#,##0.00",
        };
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// TBILLPRICE
// -----------------------------------------------------------------------------
function tBillPrice(start, end, disc) {
    /**
     * https://support.microsoft.com/en-us/office/tbillprice-function-eacca992-c29d-425a-9eb8-0513fe6035a2
     *
     * TBILLPRICE = 100 * (1 - discount * DSM / 360)
     *
     * with DSM = number of days from settlement to maturity
     *
     * The ratio DSM/360 can be computed with the YEARFRAC function with dayCountConvention = 2 (actual/360).
     */
    const yearFrac = getYearFrac(start, end, 2);
    return 100 * (1 - disc * yearFrac);
}
const TBILLPRICE = {
    description: _t("Price of a US Treasury bill."),
    args: [
        arg("settlement (date)", _t("The settlement date of the security, the date after issuance when the security is delivered to the buyer.")),
        arg("maturity (date)", _t("The maturity or end date of the security, when it can be redeemed at face, or par value.")),
        arg("discount (number)", _t("The discount rate of the bill at time of purchase.")),
    ],
    compute: function (settlement, maturity, discount) {
        const start = Math.trunc(toNumber(settlement, this.locale));
        const end = Math.trunc(toNumber(maturity, this.locale));
        const disc = toNumber(discount, this.locale);
        assertMaturityAndSettlementDatesAreValid(start, end);
        assertSettlementLessThanOneYearBeforeMaturity(start, end, this.locale);
        assertDiscountStrictlyPositive(disc);
        assertDiscountStrictlySmallerThanOne(disc);
        return tBillPrice(start, end, disc);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// TBILLEQ
// -----------------------------------------------------------------------------
const TBILLEQ = {
    description: _t("Equivalent rate of return for a US Treasury bill."),
    args: [
        arg("settlement (date)", _t("The settlement date of the security, the date after issuance when the security is delivered to the buyer.")),
        arg("maturity (date)", _t("The maturity or end date of the security, when it can be redeemed at face, or par value.")),
        arg("discount (number)", _t("The discount rate of the bill at time of purchase.")),
    ],
    compute: function (settlement, maturity, discount) {
        const start = Math.trunc(toNumber(settlement, this.locale));
        const end = Math.trunc(toNumber(maturity, this.locale));
        const disc = toNumber(discount, this.locale);
        assertMaturityAndSettlementDatesAreValid(start, end);
        assertSettlementLessThanOneYearBeforeMaturity(start, end, this.locale);
        assertDiscountStrictlyPositive(disc);
        assertDiscountStrictlySmallerThanOne(disc);
        /**
         * https://support.microsoft.com/en-us/office/tbilleq-function-2ab72d90-9b4d-4efe-9fc2-0f81f2c19c8c
         *
         *               365 * discount
         * TBILLEQ = ________________________
         *            360 - discount * DSM
         *
         * with DSM = number of days from settlement to maturity
         *
         * What is not indicated in the Excel documentation is that this formula only works for duration between settlement
         * and maturity that are less than 6 months (182 days). This is because US Treasury bills use semi-annual interest,
         * and thus we have to take into account the compound interest for the calculation.
         *
         * For this case, the formula becomes (Treasury Securities and Derivatives, by Frank J. Fabozzi, page 49)
         *
         *            -2X + 2* SQRT[ X² - (2X - 1) * (1 - 100/p) ]
         * TBILLEQ = ________________________________________________
         *                            2X - 1
         *
         * with X = DSM / (number of days in a year),
         *  and p is the price, computed with TBILLPRICE
         *
         * Note that from my tests in Excel, we take (number of days in a year) = 366 ONLY if DSM is 366, not if
         * the settlement year is a leap year.
         *
         */
        const nDays = DAYS.compute.bind(this)({ value: end }, { value: start });
        if (nDays <= 182) {
            return (365 * disc) / (360 - disc * nDays);
        }
        const p = tBillPrice(start, end, disc) / 100;
        const daysInYear = nDays === 366 ? 366 : 365;
        const x = nDays / daysInYear;
        const num = -2 * x + 2 * Math.sqrt(x ** 2 - (2 * x - 1) * (1 - 1 / p));
        const denom = 2 * x - 1;
        return num / denom;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// TBILLYIELD
// -----------------------------------------------------------------------------
const TBILLYIELD = {
    description: _t("The yield of a US Treasury bill based on price."),
    args: [
        arg("settlement (date)", _t("The settlement date of the security, the date after issuance when the security is delivered to the buyer.")),
        arg("maturity (date)", _t("The maturity or end date of the security, when it can be redeemed at face, or par value.")),
        arg("price (number)", _t("The price at which the security is bought per 100 face value.")),
    ],
    compute: function (settlement, maturity, price) {
        const start = Math.trunc(toNumber(settlement, this.locale));
        const end = Math.trunc(toNumber(maturity, this.locale));
        const p = toNumber(price, this.locale);
        assertMaturityAndSettlementDatesAreValid(start, end);
        assertSettlementLessThanOneYearBeforeMaturity(start, end, this.locale);
        assertPriceStrictlyPositive(p);
        /**
         * https://support.microsoft.com/en-us/office/tbillyield-function-6d381232-f4b0-4cd5-8e97-45b9c03468ba
         *
         *              100 - price     360
         * TBILLYIELD = ____________ * _____
         *                 price        DSM
         *
         * with DSM = number of days from settlement to maturity
         *
         * The ratio DSM/360 can be computed with the YEARFRAC function with dayCountConvention = 2 (actual/360).
         *
         */
        const yearFrac = getYearFrac(start, end, 2);
        return ((100 - p) / p) * (1 / yearFrac);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// VDB
// -----------------------------------------------------------------------------
const DEFAULT_VDB_NO_SWITCH = false;
const VDB = {
    description: _t("Variable declining balance. WARNING : does not handle decimal periods."),
    args: [
        arg("cost (number)", _t("The initial cost of the asset.")),
        arg("salvage (number)", _t("The value of the asset at the end of depreciation.")),
        arg("life (number)", _t("The number of periods over which the asset is depreciated.")),
        arg("start (number)", _t("Starting period to calculate depreciation.")),
        arg("end (number)", _t("Ending period to calculate depreciation.")),
        arg(`factor (number, default=${DEFAULT_DDB_DEPRECIATION_FACTOR})`, _t("The number of months in the first year of depreciation.")),
        arg(`no_switch (number, default=${DEFAULT_VDB_NO_SWITCH})`, _t("Whether to switch to straight-line depreciation when the depreciation is greater than the declining balance calculation.")),
    ],
    compute: function (cost, salvage, life, startPeriod, endPeriod, factor = { value: DEFAULT_DDB_DEPRECIATION_FACTOR }, noSwitch = { value: DEFAULT_VDB_NO_SWITCH }) {
        factor = factor || 0;
        const _cost = toNumber(cost, this.locale);
        const _salvage = toNumber(salvage, this.locale);
        const _life = toNumber(life, this.locale);
        /* TODO : handle decimal periods
         * on end_period it looks like it is a simple linear function, but I cannot understand exactly how
         * decimals periods are handled with start_period.
         */
        const _startPeriod = Math.trunc(toNumber(startPeriod, this.locale));
        const _endPeriod = Math.trunc(toNumber(endPeriod, this.locale));
        const _factor = toNumber(factor, this.locale);
        const _noSwitch = toBoolean(noSwitch);
        assertCostPositiveOrZero(_cost);
        assertSalvagePositiveOrZero(_salvage);
        assertStartAndEndPeriodAreValid(_startPeriod, _endPeriod, _life);
        assertDeprecationFactorStrictlyPositive(_factor);
        if (_cost === 0)
            return 0;
        if (_salvage >= _cost) {
            return _startPeriod < 1 ? _cost - _salvage : 0;
        }
        const doubleDeprecFactor = _factor / _life;
        if (doubleDeprecFactor >= 1) {
            return _startPeriod < 1 ? _cost - _salvage : 0;
        }
        let previousCost = _cost;
        let currentDeprec = 0;
        let resultDeprec = 0;
        let isLinearDeprec = false;
        for (let i = 0; i < _endPeriod; i++) {
            // compute the current deprecation, or keep the last one if we reached a stage of linear deprecation
            if (!isLinearDeprec || _noSwitch) {
                const doubleDeprec = previousCost * doubleDeprecFactor;
                const remainingPeriods = _life - i;
                const linearDeprec = (previousCost - _salvage) / remainingPeriods;
                if (!_noSwitch && linearDeprec > doubleDeprec) {
                    isLinearDeprec = true;
                    currentDeprec = linearDeprec;
                }
                else {
                    currentDeprec = doubleDeprec;
                }
            }
            const nextCost = Math.max(previousCost - currentDeprec, _salvage);
            if (i >= _startPeriod) {
                resultDeprec += previousCost - nextCost;
            }
            previousCost = nextCost;
        }
        return resultDeprec;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// XIRR
// -----------------------------------------------------------------------------
const XIRR = {
    description: _t("Internal rate of return given non-periodic cash flows."),
    args: [
        arg("cashflow_amounts (range<number>)", _t("An range containing the income or payments associated with the investment.")),
        arg("cashflow_dates (range<number>)", _t("An range with dates corresponding to the cash flows in cashflow_amounts.")),
        arg(`rate_guess (number, default=${RATE_GUESS_DEFAULT})`, _t("An estimate for what the internal rate of return will be.")),
    ],
    compute: function (cashflowAmounts, cashflowDates, rateGuess = { value: RATE_GUESS_DEFAULT }) {
        const guess = toNumber(rateGuess, this.locale);
        const _cashFlows = cashflowAmounts.flat().map((val) => toNumber(val, this.locale));
        const _dates = cashflowDates.flat().map((val) => toNumber(val, this.locale));
        assertCashFlowsAndDatesHaveSameDimension(cashflowAmounts, cashflowDates);
        assertCashFlowsHavePositiveAndNegativesValues(_cashFlows);
        assertEveryDateGreaterThanFirstDateOfCashFlowDates(_dates);
        assertRateGuessStrictlyGreaterThanMinusOne(guess);
        const map = new Map();
        for (const i of range(0, _dates.length)) {
            const date = _dates[i];
            if (map.has(date))
                map.set(date, map.get(date) + _cashFlows[i]);
            else
                map.set(date, _cashFlows[i]);
        }
        const dates = Array.from(map.keys());
        const values = dates.map((date) => map.get(date));
        /**
         * https://support.microsoft.com/en-us/office/xirr-function-de1242ec-6477-445b-b11b-a303ad9adc9d
         *
         * The rate is computed iteratively by trying to solve the equation
         *
         *
         * 0 =    SUM     [ P_i * (1 + rate) ^((d_0 - d_i) / 365) ]  + P_0
         *     i = 1 => n
         *
         * with P_i = price number i
         *      d_i = date number i
         *
         * This function is not defined for rate < -1. For the case where we get rates < -1 in the Newton method, add
         * a fallback for a number very close to -1 to continue the Newton method.
         *
         */
        const func = (rate) => {
            let value = values[0];
            for (const i of range(1, values.length)) {
                const dateDiff = (dates[0] - dates[i]) / 365;
                value += values[i] * (1 + rate) ** dateDiff;
            }
            return value;
        };
        const derivFunc = (rate) => {
            let deriv = 0;
            for (const i of range(1, values.length)) {
                const dateDiff = (dates[0] - dates[i]) / 365;
                deriv += dateDiff * values[i] * (1 + rate) ** (dateDiff - 1);
            }
            return deriv;
        };
        const nanFallback = (previousFallback) => {
            // -0.9 => -0.99 => -0.999 => ...
            if (!previousFallback)
                return -0.9;
            return previousFallback / 10 - 0.9;
        };
        return newtonMethod(func, derivFunc, guess, 40, 1e-5, nanFallback);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// XNPV
// -----------------------------------------------------------------------------
const XNPV = {
    description: _t("Net present value given to non-periodic cash flows.."),
    args: [
        arg("discount (number)", _t("The discount rate of the investment over one period.")),
        arg("cashflow_amounts (number, range<number>)", _t("An range containing the income or payments associated with the investment.")),
        arg("cashflow_dates (number, range<number>)", _t("An range with dates corresponding to the cash flows in cashflow_amounts.")),
    ],
    compute: function (discount, cashflowAmounts, cashflowDates) {
        const rate = toNumber(discount, this.locale);
        const _cashFlows = isMatrix(cashflowAmounts)
            ? cashflowAmounts.flat().map((data) => strictToNumber(data, this.locale))
            : [strictToNumber(cashflowAmounts, this.locale)];
        const _dates = isMatrix(cashflowDates)
            ? cashflowDates.flat().map((data) => strictToNumber(data, this.locale))
            : [strictToNumber(cashflowDates, this.locale)];
        if (isMatrix(cashflowDates) && isMatrix(cashflowAmounts)) {
            assertCashFlowsAndDatesHaveSameDimension(cashflowAmounts, cashflowDates);
        }
        else {
            assert(() => _cashFlows.length === _dates.length, _t("There must be the same number of values in cashflow_amounts and cashflow_dates."));
        }
        assertEveryDateGreaterThanFirstDateOfCashFlowDates(_dates);
        assertRateStrictlyPositive(rate);
        if (_cashFlows.length === 1)
            return _cashFlows[0];
        // aggregate values of the same date
        const map = new Map();
        for (const i of range(0, _dates.length)) {
            const date = _dates[i];
            if (map.has(date))
                map.set(date, map.get(date) + _cashFlows[i]);
            else
                map.set(date, _cashFlows[i]);
        }
        const dates = Array.from(map.keys());
        const values = dates.map((date) => map.get(date));
        /**
         * https://support.microsoft.com/en-us/office/xirr-function-de1242ec-6477-445b-b11b-a303ad9adc9d
         *
         * The present value is computed using
         *
         *
         * NPV =    SUM     [ P_i *(1 + rate) ^((d_0 - d_i) / 365) ]  + P_0
         *       i = 1 => n
         *
         * with P_i = price number i
         *      d_i = date number i
         *
         *
         */
        let pv = values[0];
        for (const i of range(1, values.length)) {
            const dateDiff = (dates[0] - dates[i]) / 365;
            pv += values[i] * (1 + rate) ** dateDiff;
        }
        return pv;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// YIELD
// -----------------------------------------------------------------------------
const YIELD = {
    description: _t("Annual yield of a security paying periodic interest."),
    args: [
        arg("settlement (date)", _t("The settlement date of the security, the date after issuance when the security is delivered to the buyer.")),
        arg("maturity (date)", _t("The maturity or end date of the security, when it can be redeemed at face, or par value.")),
        arg("rate (number)", _t("The annualized rate of interest.")),
        arg("price (number)", _t("The price at which the security is bought per 100 face value.")),
        arg("redemption (number)", _t("The redemption amount per 100 face value, or par.")),
        arg("frequency (number)", _t("The number of interest or coupon payments per year (1, 2, or 4).")),
        arg(`day_count_convention (number, default=${DEFAULT_DAY_COUNT_CONVENTION} )`, _t("An indicator of what day count method to use.")),
    ],
    compute: function (settlement, maturity, rate, price, redemption, frequency, dayCountConvention = { value: DEFAULT_DAY_COUNT_CONVENTION }) {
        dayCountConvention = dayCountConvention || 0;
        const _settlement = Math.trunc(toNumber(settlement, this.locale));
        const _maturity = Math.trunc(toNumber(maturity, this.locale));
        const _rate = toNumber(rate, this.locale);
        const _price = toNumber(price, this.locale);
        const _redemption = toNumber(redemption, this.locale);
        const _frequency = Math.trunc(toNumber(frequency, this.locale));
        const _dayCountConvention = Math.trunc(toNumber(dayCountConvention, this.locale));
        assertMaturityAndSettlementDatesAreValid(_settlement, _maturity);
        assertCouponFrequencyIsValid(_frequency);
        assertDayCountConventionIsValid(_dayCountConvention);
        assert(() => _rate >= 0, _t("The rate (%s) must be positive or null.", _rate.toString()));
        assertPriceStrictlyPositive(_price);
        assertRedemptionStrictlyPositive(_redemption);
        const years = getYearFrac(_settlement, _maturity, _dayCountConvention);
        const nbrRealCoupons = years * _frequency;
        const nbrFullCoupons = Math.ceil(nbrRealCoupons);
        const timeFirstCoupon = nbrRealCoupons - Math.floor(nbrRealCoupons) || 1;
        const cashFlowFromCoupon = (100 * _rate) / _frequency;
        if (nbrFullCoupons === 1) {
            const subPart = _price + cashFlowFromCoupon * (1 - timeFirstCoupon);
            return (((_redemption + cashFlowFromCoupon - subPart) * _frequency * (1 / timeFirstCoupon)) /
                subPart);
        }
        // The result of YIELD function is the yield at which the PRICE function will return the given price.
        // This algorithm uses the Newton's method on the PRICE function to determine the result.
        // Newton's method: https://en.wikipedia.org/wiki/Newton%27s_method
        // As the PRICE function isn't continuous, we apply the Newton's method on the numerator of the PRICE formula.
        // For simplicity, it is not yield but yieldFactorPerPeriod (= 1 + yield / frequency) which will be calibrated in Newton's method.
        // yield can be deduced from yieldFactorPerPeriod in sequence.
        function priceNumerator(price, timeFirstCoupon, nbrFullCoupons, yieldFactorPerPeriod, cashFlowFromCoupon, redemption) {
            let result = redemption -
                (price + cashFlowFromCoupon * (1 - timeFirstCoupon)) *
                    yieldFactorPerPeriod ** (nbrFullCoupons - 1 + timeFirstCoupon);
            for (let i = 1; i <= nbrFullCoupons; i++) {
                result += cashFlowFromCoupon * yieldFactorPerPeriod ** (i - 1);
            }
            return result;
        }
        function priceNumeratorDeriv(price, timeFirstCoupon, nbrFullCoupons, yieldFactorPerPeriod, cashFlowFromCoupon) {
            let result = -(price + cashFlowFromCoupon * (1 - timeFirstCoupon)) *
                (nbrFullCoupons - 1 + timeFirstCoupon) *
                yieldFactorPerPeriod ** (nbrFullCoupons - 2 + timeFirstCoupon);
            for (let i = 1; i <= nbrFullCoupons; i++) {
                result += cashFlowFromCoupon * (i - 1) * yieldFactorPerPeriod ** (i - 2);
            }
            return result;
        }
        function func(x) {
            return priceNumerator(_price, timeFirstCoupon, nbrFullCoupons, x, cashFlowFromCoupon, _redemption);
        }
        function derivFunc(x) {
            return priceNumeratorDeriv(_price, timeFirstCoupon, nbrFullCoupons, x, cashFlowFromCoupon);
        }
        const initYield = _rate + 1;
        const initYieldFactorPerPeriod = 1 + initYield / _frequency;
        const methodResult = newtonMethod(func, derivFunc, initYieldFactorPerPeriod, 100, 1e-5);
        return (methodResult - 1) * _frequency;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// YIELDDISC
// -----------------------------------------------------------------------------
const YIELDDISC = {
    description: _t("Annual yield of a discount security."),
    args: [
        arg("settlement (date)", _t("The settlement date of the security, the date after issuance when the security is delivered to the buyer.")),
        arg("maturity (date)", _t("The maturity or end date of the security, when it can be redeemed at face, or par value.")),
        arg("price (number)", _t("The price at which the security is bought per 100 face value.")),
        arg("redemption (number)", _t("The redemption amount per 100 face value, or par.")),
        arg(`day_count_convention (number, default=${DEFAULT_DAY_COUNT_CONVENTION} )`, _t("An indicator of what day count method to use.")),
    ],
    compute: function (settlement, maturity, price, redemption, dayCountConvention = { value: DEFAULT_DAY_COUNT_CONVENTION }) {
        dayCountConvention = dayCountConvention || 0;
        const _settlement = Math.trunc(toNumber(settlement, this.locale));
        const _maturity = Math.trunc(toNumber(maturity, this.locale));
        const _price = toNumber(price, this.locale);
        const _redemption = toNumber(redemption, this.locale);
        const _dayCountConvention = Math.trunc(toNumber(dayCountConvention, this.locale));
        assertMaturityAndSettlementDatesAreValid(_settlement, _maturity);
        assertDayCountConventionIsValid(_dayCountConvention);
        assertPriceStrictlyPositive(_price);
        assertRedemptionStrictlyPositive(_redemption);
        /**
         * https://wiki.documentfoundation.org/Documentation/Calc_Functions/YIELDDISC
         *
         *                    (redemption / price) - 1
         * YIELDDISC = _____________________________________
         *             YEARFRAC(settlement, maturity, basis)
         */
        const yearFrac = getYearFrac(_settlement, _maturity, _dayCountConvention);
        return (_redemption / _price - 1) / yearFrac;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// YIELDMAT
// -----------------------------------------------------------------------------
const YIELDMAT = {
    description: _t("Annual yield of a security paying interest at maturity."),
    args: [
        arg("settlement (date)", _t("The settlement date of the security, the date after issuance when the security is delivered to the buyer.")),
        arg("maturity (date)", _t("The maturity or end date of the security, when it can be redeemed at face, or par value.")),
        arg("issue (date)", _t("The date the security was initially issued.")),
        arg("rate (number)", _t("The annualized rate of interest.")),
        arg("price (number)", _t("The price at which the security is bought.")),
        arg(`day_count_convention (number, default=${DEFAULT_DAY_COUNT_CONVENTION} )`, _t("An indicator of what day count method to use.")),
    ],
    compute: function (settlement, maturity, issue, rate, price, dayCountConvention = { value: DEFAULT_DAY_COUNT_CONVENTION }) {
        dayCountConvention = dayCountConvention || 0;
        const _settlement = Math.trunc(toNumber(settlement, this.locale));
        const _maturity = Math.trunc(toNumber(maturity, this.locale));
        const _issue = Math.trunc(toNumber(issue, this.locale));
        const _rate = toNumber(rate, this.locale);
        const _price = toNumber(price, this.locale);
        const _dayCountConvention = Math.trunc(toNumber(dayCountConvention, this.locale));
        assertMaturityAndSettlementDatesAreValid(_settlement, _maturity);
        assertDayCountConventionIsValid(_dayCountConvention);
        assert(() => _settlement >= _issue, _t("The settlement (%s) must be greater than or equal to the issue (%s).", _settlement.toString(), _issue.toString()));
        assert(() => _rate >= 0, _t("The rate (%s) must be positive or null.", _rate.toString()));
        assertPriceStrictlyPositive(_price);
        const issueToMaturity = getYearFrac(_issue, _maturity, _dayCountConvention);
        const issueToSettlement = getYearFrac(_issue, _settlement, _dayCountConvention);
        const settlementToMaturity = getYearFrac(_settlement, _maturity, _dayCountConvention);
        const numerator = (100 * (1 + _rate * issueToMaturity)) / (_price + 100 * _rate * issueToSettlement) - 1;
        return numerator / settlementToMaturity;
    },
    isExported: true,
};

var financial = /*#__PURE__*/Object.freeze({
    __proto__: null,
    ACCRINTM: ACCRINTM,
    AMORLINC: AMORLINC,
    COUPDAYBS: COUPDAYBS,
    COUPDAYS: COUPDAYS,
    COUPDAYSNC: COUPDAYSNC,
    COUPNCD: COUPNCD,
    COUPNUM: COUPNUM,
    COUPPCD: COUPPCD,
    CUMIPMT: CUMIPMT,
    CUMPRINC: CUMPRINC,
    DB: DB,
    DDB: DDB,
    DISC: DISC,
    DOLLARDE: DOLLARDE,
    DOLLARFR: DOLLARFR,
    DURATION: DURATION,
    EFFECT: EFFECT,
    FV: FV,
    FVSCHEDULE: FVSCHEDULE,
    INTRATE: INTRATE,
    IPMT: IPMT,
    IRR: IRR,
    ISPMT: ISPMT,
    MDURATION: MDURATION,
    MIRR: MIRR,
    NOMINAL: NOMINAL,
    NPER: NPER,
    NPV: NPV,
    PDURATION: PDURATION,
    PMT: PMT,
    PPMT: PPMT,
    PRICE: PRICE,
    PRICEDISC: PRICEDISC,
    PRICEMAT: PRICEMAT,
    PV: PV,
    RATE: RATE,
    RECEIVED: RECEIVED,
    RRI: RRI,
    SLN: SLN,
    SYD: SYD,
    TBILLEQ: TBILLEQ,
    TBILLPRICE: TBILLPRICE,
    TBILLYIELD: TBILLYIELD,
    VDB: VDB,
    XIRR: XIRR,
    XNPV: XNPV,
    YIELD: YIELD,
    YIELDDISC: YIELDDISC,
    YIELDMAT: YIELDMAT
});

const functionRegex = /[a-zA-Z0-9\_]+(\.[a-zA-Z0-9\_]+)*/;
const UNARY_OPERATORS_PREFIX = ["-", "+"];
const UNARY_OPERATORS_POSTFIX = ["%"];
const ASSOCIATIVE_OPERATORS = ["*", "+", "&"];
const OP_PRIORITY = {
    "^": 30,
    "%": 30,
    "*": 20,
    "/": 20,
    "+": 15,
    "-": 15,
    "&": 13,
    ">": 10,
    "<>": 10,
    ">=": 10,
    "<": 10,
    "<=": 10,
    "=": 10,
};
/**
 * Parse the next operand in an arithmetic expression.
 * e.g.
 *  for 1+2*3, the next operand is 1
 *  for (1+2)*3, the next operand is (1+2)
 *  for SUM(1,2)+3, the next operand is SUM(1,2)
 */
function parseOperand(tokens) {
    const current = tokens.shift();
    if (!current) {
        throw new BadExpressionError();
    }
    switch (current.type) {
        case "DEBUGGER":
            const next = parseExpression(tokens, 1000);
            next.debug = true;
            return next;
        case "NUMBER":
            return { type: "NUMBER", value: parseNumber(current.value, DEFAULT_LOCALE) };
        case "STRING":
            return { type: "STRING", value: removeStringQuotes(current.value) };
        case "INVALID_REFERENCE":
            return {
                type: "REFERENCE",
                value: CellErrorType.InvalidReference,
            };
        case "REFERENCE":
            if (tokens[0]?.value === ":" && tokens[1]?.type === "REFERENCE") {
                tokens.shift();
                const rightReference = tokens.shift();
                return {
                    type: "REFERENCE",
                    value: `${current.value}:${rightReference?.value}`,
                };
            }
            return {
                type: "REFERENCE",
                value: current.value,
            };
        case "SYMBOL":
            const value = current.value;
            const nextToken = tokens[0];
            if (nextToken?.type === "LEFT_PAREN" &&
                functionRegex.test(current.value) &&
                value === unquote(value, "'")) {
                const args = parseFunctionArgs(tokens);
                return { type: "FUNCALL", value: value, args };
            }
            const upperCaseValue = value.toUpperCase();
            if (upperCaseValue === "TRUE" || upperCaseValue === "FALSE") {
                return { type: "BOOLEAN", value: upperCaseValue === "TRUE" };
            }
            return { type: "SYMBOL", value: unquote(current.value, "'") };
        case "LEFT_PAREN":
            const result = parseExpression(tokens);
            consumeOrThrow(tokens, "RIGHT_PAREN", _t("Missing closing parenthesis"));
            return result;
        case "OPERATOR":
            const operator = current.value;
            if (UNARY_OPERATORS_PREFIX.includes(operator)) {
                return {
                    type: "UNARY_OPERATION",
                    value: operator,
                    operand: parseExpression(tokens, OP_PRIORITY[operator]),
                };
            }
            throw new BadExpressionError(_t("Unexpected token: %s", current.value));
        default:
            throw new BadExpressionError(_t("Unexpected token: %s", current.value));
    }
}
function parseFunctionArgs(tokens) {
    consumeOrThrow(tokens, "LEFT_PAREN", _t("Missing opening parenthesis"));
    const nextToken = tokens[0];
    if (nextToken?.type === "RIGHT_PAREN") {
        consumeOrThrow(tokens, "RIGHT_PAREN");
        return [];
    }
    const args = [];
    args.push(parseOneFunctionArg(tokens));
    while (tokens[0]?.type !== "RIGHT_PAREN") {
        consumeOrThrow(tokens, "ARG_SEPARATOR", _t("Wrong function call"));
        args.push(parseOneFunctionArg(tokens));
    }
    consumeOrThrow(tokens, "RIGHT_PAREN");
    return args;
}
function parseOneFunctionArg(tokens) {
    const nextToken = tokens[0];
    if (nextToken?.type === "ARG_SEPARATOR" || nextToken?.type === "RIGHT_PAREN") {
        // arg is empty: "sum(1,,2)" "sum(,1)" "sum(1,)"
        return { type: "EMPTY", value: "" };
    }
    return parseExpression(tokens);
}
function consumeOrThrow(tokens, type, message) {
    const token = tokens.shift();
    if (!token || token.type !== type) {
        throw new BadExpressionError(message);
    }
}
function parseExpression(tokens, parent_priority = 0) {
    if (tokens.length === 0) {
        throw new BadExpressionError();
    }
    let left = parseOperand(tokens);
    // as long as we have operators with higher priority than the parent one,
    // continue parsing the expression because it is a child sub-expression
    while (tokens[0]?.type === "OPERATOR" && OP_PRIORITY[tokens[0].value] > parent_priority) {
        const operator = tokens.shift().value;
        if (UNARY_OPERATORS_POSTFIX.includes(operator)) {
            left = {
                type: "UNARY_OPERATION",
                value: operator,
                operand: left,
                postfix: true,
            };
        }
        else {
            const right = parseExpression(tokens, OP_PRIORITY[operator]);
            left = {
                type: "BIN_OPERATION",
                value: operator,
                left,
                right,
            };
        }
    }
    return left;
}
/**
 * Parse an expression (as a string) into an AST.
 */
function parse(str) {
    return parseTokens(rangeTokenize(str));
}
function parseTokens(tokens) {
    tokens = tokens.filter((x) => x.type !== "SPACE");
    if (tokens[0]?.value === "=") {
        tokens.splice(0, 1);
    }
    const result = parseExpression(tokens);
    if (tokens.length) {
        throw new BadExpressionError();
    }
    return result;
}
/**
 * Allows to visit all nodes of an AST and apply a mapping function
 * to nodes of a specific type.
 * Useful if you want to convert some part of a formula.
 *
 * @example
 * convertAstNodes(ast, "FUNCALL", convertFormulaToExcel)
 *
 * function convertFormulaToExcel(ast: ASTFuncall) {
 *   // ...
 *   return modifiedAst
 * }
 */
function convertAstNodes(ast, type, fn) {
    return mapAst(ast, (ast) => {
        if (ast.type === type) {
            return fn(ast);
        }
        return ast;
    });
}
function iterateAstNodes(ast) {
    return Array.from(astIterator(ast));
}
function* astIterator(ast) {
    yield ast;
    switch (ast.type) {
        case "FUNCALL":
            for (const arg of ast.args) {
                yield* astIterator(arg);
            }
            break;
        case "UNARY_OPERATION":
            yield* astIterator(ast.operand);
            break;
        case "BIN_OPERATION":
            yield* astIterator(ast.left);
            yield* astIterator(ast.right);
            break;
    }
}
function mapAst(ast, fn) {
    ast = fn(ast);
    switch (ast.type) {
        case "FUNCALL":
            return {
                ...ast,
                args: ast.args.map((child) => mapAst(child, fn)),
            };
        case "UNARY_OPERATION":
            return {
                ...ast,
                operand: mapAst(ast.operand, fn),
            };
        case "BIN_OPERATION":
            return {
                ...ast,
                right: mapAst(ast.right, fn),
                left: mapAst(ast.left, fn),
            };
        default:
            return ast;
    }
}
/**
 * Converts an ast formula to the corresponding string
 */
function astToFormula(ast) {
    switch (ast.type) {
        case "FUNCALL":
            const args = ast.args.map((arg) => astToFormula(arg));
            return `${ast.value}(${args.join(",")})`;
        case "NUMBER":
            return ast.value.toString();
        case "REFERENCE":
            return ast.value;
        case "STRING":
            return `"${ast.value}"`;
        case "BOOLEAN":
            return ast.value ? "TRUE" : "FALSE";
        case "UNARY_OPERATION":
            return ast.postfix
                ? leftOperandToFormula(ast) + ast.value
                : ast.value + rightOperandToFormula(ast);
        case "BIN_OPERATION":
            return leftOperandToFormula(ast) + ast.value + rightOperandToFormula(ast);
        default:
            return ast.value;
    }
}
/**
 * Convert the left operand of a binary operation to the corresponding string
 * and enclose the result inside parenthesis if necessary.
 */
function leftOperandToFormula(operationAST) {
    const mainOperator = operationAST.value;
    const leftOperation = "left" in operationAST ? operationAST.left : operationAST.operand;
    const leftOperator = leftOperation.value;
    const needParenthesis = leftOperation.type === "BIN_OPERATION" && OP_PRIORITY[leftOperator] < OP_PRIORITY[mainOperator];
    return needParenthesis ? `(${astToFormula(leftOperation)})` : astToFormula(leftOperation);
}
/**
 * Convert the right operand of a binary or unary operation to the corresponding string
 * and enclose the result inside parenthesis if necessary.
 */
function rightOperandToFormula(operationAST) {
    const mainOperator = operationAST.value;
    const rightOperation = "right" in operationAST ? operationAST.right : operationAST.operand;
    const rightPriority = OP_PRIORITY[rightOperation.value];
    const mainPriority = OP_PRIORITY[mainOperator];
    let needParenthesis = false;
    if (rightOperation.type !== "BIN_OPERATION") {
        needParenthesis = false;
    }
    else if (rightPriority < mainPriority) {
        needParenthesis = true;
    }
    else if (rightPriority === mainPriority && !ASSOCIATIVE_OPERATORS.includes(mainOperator)) {
        needParenthesis = true;
    }
    return needParenthesis ? `(${astToFormula(rightOperation)})` : astToFormula(rightOperation);
}

/**
 * Add the following information on tokens:
 * - length
 * - start
 * - end
 */
function enrichTokens(tokens) {
    let current = 0;
    return tokens.map((x) => {
        const len = x.value.toString().length;
        const token = Object.assign({}, x, {
            start: current,
            end: current + len,
            length: len,
        });
        current = token.end;
        return token;
    });
}
/**
 * add on each token the length, start and end
 * also matches the opening to its closing parenthesis (using the same number)
 */
function mapParenthesis(tokens) {
    let maxParen = 1;
    const stack = [];
    return tokens.map((token) => {
        if (token.type === "LEFT_PAREN") {
            stack.push(maxParen);
            token.parenIndex = maxParen;
            maxParen++;
        }
        else if (token.type === "RIGHT_PAREN") {
            token.parenIndex = stack.pop();
        }
        return token;
    });
}
/**
 * add on each token its parent function and the index corresponding to
 * its position as an argument of the function.
 * In this example "=MIN(42,SUM(MAX(1,2),3))":
 * - the parent function of the token correspond to number 42 is the MIN function
 * - the argument position of the token correspond to number 42 is 0
 * - the parent function of the token correspond to number 3 is the SUM function
 * - the argument position of the token correspond to number 3 is 1
 */
function mapParentFunction(tokens) {
    let stack = [];
    let functionStarted = "";
    function pushTokenToFunctionContext(token) {
        if (stack.length === 0) {
            return;
        }
        const functionContext = stack.at(-1);
        if (functionContext && functionContext.argsTokens) {
            const { argsTokens, argPosition } = functionContext;
            if (!argsTokens[argPosition]) {
                argsTokens[argPosition] = [];
            }
            argsTokens[argPosition].push({ value: token.value, type: token.type });
        }
    }
    const res = tokens.map((token, i) => {
        if (!["SPACE", "LEFT_PAREN"].includes(token.type)) {
            functionStarted = "";
        }
        switch (token.type) {
            case "SYMBOL":
                pushTokenToFunctionContext(token);
                functionStarted = token.value;
                break;
            case "LEFT_PAREN":
                stack.push({ parent: functionStarted, argPosition: 0, argsTokens: [], args: [] });
                pushTokenToFunctionContext(token);
                functionStarted = "";
                break;
            case "RIGHT_PAREN":
                const child = stack.pop();
                child?.argsTokens?.flat().forEach(pushTokenToFunctionContext);
                pushTokenToFunctionContext(token);
                break;
            case "ARG_SEPARATOR":
                pushTokenToFunctionContext(token);
                if (stack.length) {
                    // increment position on current function
                    stack[stack.length - 1].argPosition++;
                }
                break;
            default:
                pushTokenToFunctionContext(token);
                break;
        }
        if (stack.length) {
            const functionContext = stack[stack.length - 1];
            if (functionContext.parent) {
                token.functionContext = Object.assign({}, functionContext);
            }
        }
        return token;
    });
    return res;
}
/**
 * Parse the list of tokens that compose the arguments of a function to
 * their AST representation.
 */
function addArgsAST(tokens) {
    for (const token of tokens) {
        if (token.functionContext) {
            const { argsTokens, args } = token.functionContext;
            // remove argsTokens from the context to remove noise
            // The business logic should not need it, it is only used temporarily
            // to build the arguments ASTs.
            delete token.functionContext.argsTokens;
            if (args.length || !argsTokens) {
                // function context already process at a previous token
                continue;
            }
            if (argsTokens[0]?.[0]?.type === "LEFT_PAREN") {
                // remove the parenthesis leading the first argument
                argsTokens[0] = argsTokens[0].slice(1);
            }
            for (const argTokens of argsTokens) {
                let tokens = argTokens;
                if (tokens.at(-1)?.type === "ARG_SEPARATOR") {
                    tokens = tokens.slice(0, -1);
                }
                try {
                    args.push(parseTokens(tokens));
                }
                catch (error) {
                    args.push(undefined);
                }
            }
        }
    }
    return tokens;
}
/**
 * Take the result of the tokenizer and transform it to be usable in the composer.
 *
 * @param formula
 */
function composerTokenize(formula, locale) {
    const tokens = rangeTokenize(formula, locale);
    return addArgsAST(mapParentFunction(mapParenthesis(enrichTokens(tokens))));
}

/**
 * Change the reference types inside the given token, if the token represent a range or a cell
 *
 * Eg. :
 *   A1 => $A$1 => A$1 => $A1 => A1
 *   A1:$B$1 => $A$1:B$1 => A$1:$B1 => $A1:B1 => A1:$B$1
 */
function loopThroughReferenceType(token) {
    if (token.type !== "REFERENCE")
        return token;
    const { xc, sheetName } = splitReference(token.value);
    const [left, right] = xc.split(":");
    const updatedLeft = getTokenNextReferenceType(left);
    const updatedRight = right ? `:${getTokenNextReferenceType(right)}` : "";
    return { ...token, value: getFullReference(sheetName, updatedLeft + updatedRight) };
}
/**
 * Get a new token with a changed type of reference from the given cell token symbol.
 * Undefined behavior if given a token other than a cell or if the Xc contains a sheet reference
 *
 * A1 => $A$1 => A$1 => $A1 => A1
 */
function getTokenNextReferenceType(xc) {
    switch (getReferenceType(xc)) {
        case "none":
            xc = setXcToFixedReferenceType(xc, "colrow");
            break;
        case "colrow":
            xc = setXcToFixedReferenceType(xc, "row");
            break;
        case "row":
            xc = setXcToFixedReferenceType(xc, "col");
            break;
        case "col":
            xc = setXcToFixedReferenceType(xc, "none");
            break;
    }
    return xc;
}
/**
 * Returns the given XC with the given reference type. The XC string should not contain a sheet name.
 */
function setXcToFixedReferenceType(xc, referenceType) {
    if (xc.includes("!")) {
        throw new Error("The given XC should not contain a sheet name");
    }
    xc = xc.replace(/\$/g, "");
    let indexOfNumber;
    switch (referenceType) {
        case "col":
            return "$" + xc;
        case "row":
            indexOfNumber = xc.search(/[0-9]/);
            return xc.slice(0, indexOfNumber) + "$" + xc.slice(indexOfNumber);
        case "colrow":
            indexOfNumber = xc.search(/[0-9]/);
            if (indexOfNumber === -1 || indexOfNumber === 0) {
                // no row number (eg. A) or no column (eg. 1)
                return "$" + xc;
            }
            xc = xc.slice(0, indexOfNumber) + "$" + xc.slice(indexOfNumber);
            return "$" + xc;
        case "none":
            return xc;
    }
}
/**
 * Return the type of reference used in the given XC of a cell.
 * Undefined behavior if the XC have a sheet reference
 */
function getReferenceType(xcCell) {
    if (isColAndRowFixed(xcCell)) {
        return "colrow";
    }
    else if (isColFixed(xcCell)) {
        return "col";
    }
    else if (isRowFixed(xcCell)) {
        return "row";
    }
    return "none";
}
function isColFixed(xc) {
    return xc.startsWith("$");
}
function isRowFixed(xc) {
    return xc.includes("$", 1);
}
function isColAndRowFixed(xc) {
    return xc.startsWith("$") && xc.length > 1 && xc.slice(1).includes("$");
}
/**
 * Return the cycled reference if any (A1 -> $A$1 -> A$1 -> $A1 -> A1)
 */
function cycleFixedReference(selection, content, locale) {
    const currentTokens = content.startsWith("=")
        ? composerTokenize(content, locale)
        : [];
    const tokens = currentTokens.filter((t) => (t.start <= selection.start && t.end >= selection.start) ||
        (t.start >= selection.start && t.start < selection.end));
    const refTokens = tokens.filter((token) => token.type === "REFERENCE");
    if (refTokens.length === 0) {
        return;
    }
    const updatedReferences = tokens
        .map(loopThroughReferenceType)
        .map((token) => token.value)
        .join("");
    const start = tokens[0].start;
    const end = tokens[tokens.length - 1].end;
    const newContent = content.slice(0, start) + updatedReferences + content.slice(end);
    const lengthDiff = newContent.length - content.length;
    const startOfTokens = refTokens[0].start;
    const endOfTokens = refTokens[refTokens.length - 1].end + lengthDiff;
    const newSelection = { start: startOfTokens, end: endOfTokens };
    if (refTokens.length === 1 && selection.start === selection.end) {
        newSelection.start = newSelection.end;
    }
    return { content: newContent, selection: newSelection };
}

// -----------------------------------------------------------------------------
// CELL
// -----------------------------------------------------------------------------
// NOTE: missing from Excel: "color", "filename", "parentheses", "prefix", "protect" and "width"
const CELL_INFO_TYPES = ["address", "col", "contents", "format", "row", "type"];
const CELL = {
    description: _t("Gets information about a cell."),
    args: [
        arg("info_type (string)", _t("The type of information requested. Can be one of %s", CELL_INFO_TYPES.join(", "))),
        arg("reference (meta)", _t("The reference to the cell.")),
    ],
    compute: function (info, reference) {
        const _info = toString(info).toLowerCase();
        assert(() => CELL_INFO_TYPES.includes(_info), _t("The info_type should be one of %s.", CELL_INFO_TYPES.join(", ")));
        const sheetId = this.__originSheetId;
        const _reference = toString(reference);
        const topLeftReference = _reference.includes(":") ? _reference.split(":")[0] : _reference;
        let { sheetName, xc } = splitReference(topLeftReference);
        // only put the sheet name if the referenced range is in another sheet than the cell the formula is on
        sheetName = sheetName === this.getters.getSheetName(sheetId) ? undefined : sheetName;
        const fixedRef = getFullReference(sheetName, setXcToFixedReferenceType(xc, "colrow"));
        const range = this.getters.getRangeFromSheetXC(sheetId, fixedRef);
        switch (_info) {
            case "address":
                return this.getters.getRangeString(range, sheetId);
            case "col":
                return range.zone.left + 1;
            case "contents": {
                const position = { sheetId: range.sheetId, col: range.zone.left, row: range.zone.top };
                return this.getters.getEvaluatedCell(position).value;
            }
            case "format": {
                const position = { sheetId: range.sheetId, col: range.zone.left, row: range.zone.top };
                return this.getters.getEvaluatedCell(position).format || "";
            }
            case "row":
                return range.zone.top + 1;
            case "type": {
                const position = { sheetId: range.sheetId, col: range.zone.left, row: range.zone.top };
                const type = this.getters.getEvaluatedCell(position).type;
                if (type === CellValueType.empty) {
                    return "b"; // blank
                }
                else if (type === CellValueType.text) {
                    return "l"; // label
                }
                else {
                    return "v"; // value
                }
            }
        }
        return "";
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// ISERR
// -----------------------------------------------------------------------------
const ISERR = {
    description: _t("Whether a value is an error other than #N/A."),
    args: [arg("value (any)", _t("The value to be verified as an error type."))],
    compute: function (data) {
        const value = data?.value;
        return isEvaluationError(value) && value !== CellErrorType.NotAvailable;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// ISERROR
// -----------------------------------------------------------------------------
const ISERROR = {
    description: _t("Whether a value is an error."),
    args: [arg("value (any)", _t("The value to be verified as an error type."))],
    compute: function (data) {
        const value = data?.value;
        return isEvaluationError(value);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// ISLOGICAL
// -----------------------------------------------------------------------------
const ISLOGICAL = {
    description: _t("Whether a value is `true` or `false`."),
    args: [arg("value (any)", _t("The value to be verified as a logical TRUE or FALSE."))],
    compute: function (value) {
        return typeof value?.value === "boolean";
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// ISNA
// -----------------------------------------------------------------------------
const ISNA = {
    description: _t("Whether a value is the error #N/A."),
    args: [arg("value (any)", _t("The value to be verified as an error type."))],
    compute: function (data) {
        return data?.value === CellErrorType.NotAvailable;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// ISNONTEXT
// -----------------------------------------------------------------------------
const ISNONTEXT = {
    description: _t("Whether a value is non-textual."),
    args: [arg("value (any)", _t("The value to be checked."))],
    compute: function (value) {
        return !ISTEXT.compute.bind(this)(value);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// ISNUMBER
// -----------------------------------------------------------------------------
const ISNUMBER = {
    description: _t("Whether a value is a number."),
    args: [arg("value (any)", _t("The value to be verified as a number."))],
    compute: function (value) {
        return typeof value?.value === "number";
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// ISTEXT
// -----------------------------------------------------------------------------
const ISTEXT = {
    description: _t("Whether a value is text."),
    args: [arg("value (any)", _t("The value to be verified as text."))],
    compute: function (value) {
        return typeof value?.value === "string" && isEvaluationError(value?.value) === false;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// ISBLANK
// -----------------------------------------------------------------------------
const ISBLANK = {
    description: _t("Whether the referenced cell is empty"),
    args: [arg("value (any)", _t("Reference to the cell that will be checked for emptiness."))],
    compute: function (value) {
        return value?.value === null;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// NA
// -----------------------------------------------------------------------------
const NA = {
    description: _t("Returns the error value #N/A."),
    args: [],
    compute: function () {
        return { value: CellErrorType.NotAvailable };
    },
    isExported: true,
};

var info = /*#__PURE__*/Object.freeze({
    __proto__: null,
    CELL: CELL,
    ISBLANK: ISBLANK,
    ISERR: ISERR,
    ISERROR: ISERROR,
    ISLOGICAL: ISLOGICAL,
    ISNA: ISNA,
    ISNONTEXT: ISNONTEXT,
    ISNUMBER: ISNUMBER,
    ISTEXT: ISTEXT,
    NA: NA
});

// -----------------------------------------------------------------------------
// AND
// -----------------------------------------------------------------------------
const AND = {
    description: _t("Logical `and` operator."),
    args: [
        arg("logical_expression1 (boolean, range<boolean>)", _t("An expression or reference to a cell containing an expression that represents some logical value, i.e. TRUE or FALSE, or an expression that can be coerced to a logical value.")),
        arg("logical_expression2 (boolean, range<boolean>, repeating)", _t("More expressions that represent logical values.")),
    ],
    compute: function (...logicalExpressions) {
        const { result, foundBoolean } = boolAnd(logicalExpressions);
        assert(() => foundBoolean, _t("[[FUNCTION_NAME]] has no valid input data."));
        return result;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// FALSE
// -----------------------------------------------------------------------------
const FALSE = {
    description: _t("Logical value `false`."),
    args: [],
    compute: function () {
        return false;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// IF
// -----------------------------------------------------------------------------
const IF = {
    description: _t("Returns value depending on logical expression."),
    args: [
        arg("logical_expression (boolean)", _t("An expression or reference to a cell containing an expression that represents some logical value, i.e. TRUE or FALSE.")),
        arg("value_if_true (any)", _t("The value the function returns if logical_expression is TRUE.")),
        arg("value_if_false (any, default=FALSE)", _t("The value the function returns if logical_expression is FALSE.")),
    ],
    compute: function (logicalExpression, valueIfTrue, valueIfFalse) {
        const result = toBoolean(logicalExpression?.value) ? valueIfTrue : valueIfFalse;
        if (result === undefined) {
            return { value: "" };
        }
        if (result.value === null) {
            result.value = "";
        }
        return result;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// IFERROR
// -----------------------------------------------------------------------------
const IFERROR = {
    description: _t("Value if it is not an error, otherwise 2nd argument."),
    args: [
        arg("value (any)", _t("The value to return if value itself is not an error.")),
        arg(`value_if_error (any, default="empty")`, _t("The value the function returns if value is an error.")),
    ],
    compute: function (value, valueIfError = { value: "" }) {
        const result = isEvaluationError(value?.value) ? valueIfError : value;
        if (result === undefined) {
            return { value: "" };
        }
        if (result.value === null) {
            result.value = "";
        }
        return result;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// IFNA
// -----------------------------------------------------------------------------
const IFNA = {
    description: _t("Value if it is not an #N/A error, otherwise 2nd argument."),
    args: [
        arg("value (any)", _t("The value to return if value itself is not #N/A an error.")),
        arg(`value_if_error (any, default="empty")`, _t("The value the function returns if value is an #N/A error.")),
    ],
    compute: function (value, valueIfError = { value: "" }) {
        const result = value?.value === CellErrorType.NotAvailable ? valueIfError : value;
        if (result === undefined) {
            return { value: "" };
        }
        if (result.value === null) {
            result.value = "";
        }
        return result;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// IFS
// -----------------------------------------------------------------------------
const IFS = {
    description: _t("Returns a value depending on multiple logical expressions."),
    args: [
        arg("condition1 (boolean)", _t("The first condition to be evaluated. This can be a boolean, a number, an array, or a reference to any of those.")),
        arg("value1 (any)", _t("The returned value if condition1 is TRUE.")),
        arg("condition2 (boolean, any, repeating)", _t("Additional conditions to be evaluated if the previous ones are FALSE.")),
        arg("value2 (any, repeating)", _t("Additional values to be returned if their corresponding conditions are TRUE.")),
    ],
    compute: function (...values) {
        assert(() => values.length % 2 === 0, _t("Wrong number of arguments. Expected an even number of arguments."));
        for (let n = 0; n < values.length - 1; n += 2) {
            if (toBoolean(values[n]?.value)) {
                const result = values[n + 1];
                if (result === undefined) {
                    return { value: "" };
                }
                if (result.value === null) {
                    result.value = "";
                }
                return result;
            }
        }
        throw new EvaluationError(_t("No match."));
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// NOT
// -----------------------------------------------------------------------------
const NOT = {
    description: _t("Returns opposite of provided logical value."),
    args: [
        arg("logical_expression (boolean)", _t("An expression or reference to a cell holding an expression that represents some logical value.")),
    ],
    compute: function (logicalExpression) {
        return !toBoolean(logicalExpression);
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// OR
// -----------------------------------------------------------------------------
const OR = {
    description: _t("Logical `or` operator."),
    args: [
        arg("logical_expression1 (boolean, range<boolean>)", _t("An expression or reference to a cell containing an expression that represents some logical value, i.e. TRUE or FALSE, or an expression that can be coerced to a logical value.")),
        arg("logical_expression2 (boolean, range<boolean>, repeating)", _t("More expressions that evaluate to logical values.")),
    ],
    compute: function (...logicalExpressions) {
        const { result, foundBoolean } = boolOr(logicalExpressions);
        assert(() => foundBoolean, _t("[[FUNCTION_NAME]] has no valid input data."));
        return result;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// TRUE
// -----------------------------------------------------------------------------
const TRUE = {
    description: _t("Logical value `true`."),
    args: [],
    compute: function () {
        return true;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// XOR
// -----------------------------------------------------------------------------
const XOR = {
    description: _t("Logical `xor` operator."),
    args: [
        arg("logical_expression1 (boolean, range<boolean>)", _t("An expression or reference to a cell containing an expression that represents some logical value, i.e. TRUE or FALSE, or an expression that can be coerced to a logical value.")),
        arg("logical_expression2 (boolean, range<boolean>, repeating)", _t("More expressions that evaluate to logical values.")),
    ],
    compute: function (...logicalExpressions) {
        let foundBoolean = false;
        let acc = false;
        conditionalVisitBoolean(logicalExpressions, (arg) => {
            foundBoolean = true;
            acc = acc ? !arg : arg;
            return true; // no stop condition
        });
        assert(() => foundBoolean, _t("[[FUNCTION_NAME]] has no valid input data."));
        return acc;
    },
    isExported: true,
};

var logical = /*#__PURE__*/Object.freeze({
    __proto__: null,
    AND: AND,
    FALSE: FALSE,
    IF: IF,
    IFERROR: IFERROR,
    IFNA: IFNA,
    IFS: IFS,
    NOT: NOT,
    OR: OR,
    TRUE: TRUE,
    XOR: XOR
});

/**
 * Get the pivot ID from the formula pivot ID.
 */
function getPivotId(pivotFormulaId, getters) {
    const pivotId = getters.getPivotId(pivotFormulaId);
    if (!pivotId) {
        throw new EvaluationError(_t('There is no pivot with id "%s"', pivotFormulaId));
    }
    return pivotId;
}
function assertMeasureExist(pivotId, measure, getters) {
    const { measures } = getters.getPivotCoreDefinition(pivotId);
    if (!measures.find((m) => m.id === measure)) {
        const validMeasures = `(${measures.map((m) => m.id).join(", ")})`;
        throw new EvaluationError(_t("The argument %s is not a valid measure. Here are the measures: %s", measure, validMeasures));
    }
}
function assertDomainLength(domain) {
    if (domain.length % 2 !== 0) {
        throw new EvaluationError(_t("Function PIVOT takes an even number of arguments."));
    }
}
function addPivotDependencies(evalContext, coreDefinition, forMeasures) {
    //TODO This function can be very costly when used with PIVOT.VALUE and PIVOT.HEADER
    const dependencies = [];
    if (coreDefinition.type === "SPREADSHEET" && coreDefinition.dataSet) {
        const { sheetId, zone } = coreDefinition.dataSet;
        const xc = zoneToXc(zone);
        const range = evalContext.getters.getRangeFromSheetXC(sheetId, xc);
        if (range === undefined || range.invalidXc || range.invalidSheetName) {
            throw new InvalidReferenceError();
        }
        dependencies.push(range);
    }
    for (const measure of forMeasures) {
        if (measure.computedBy) {
            const formula = evalContext.getters.getMeasureCompiledFormula(measure);
            dependencies.push(...formula.dependencies.filter((range) => !range.invalidXc));
        }
    }
    const originPosition = evalContext.__originCellPosition;
    if (originPosition && dependencies.length) {
        // The following line is used to reset the dependencies of the cell, to avoid
        // keeping dependencies from previous evaluation of the PIVOT formula (i.e.
        // in case the reference has been changed).
        evalContext.updateDependencies?.(originPosition);
        evalContext.addDependencies?.(originPosition, dependencies);
    }
}

const DEFAULT_IS_SORTED = true;
const DEFAULT_MATCH_MODE = 0;
const DEFAULT_SEARCH_MODE = 1;
const DEFAULT_ABSOLUTE_RELATIVE_MODE = 1;
function valueNotAvailable(searchKey) {
    return {
        value: CellErrorType.NotAvailable,
        message: _t("Did not find value '%s' in [[FUNCTION_NAME]] evaluation.", toString(searchKey)),
    };
}
// -----------------------------------------------------------------------------
// ADDRESS
// -----------------------------------------------------------------------------
const ADDRESS = {
    description: _t("Returns a cell reference as a string. "),
    args: [
        arg("row (number)", _t("The row number of the cell reference. ")),
        arg("column (number)", _t("The column number (not name) of the cell reference. A is column number 1. ")),
        arg(`absolute_relative_mode (number, default=${DEFAULT_ABSOLUTE_RELATIVE_MODE})`, _t("An indicator of whether the reference is row/column absolute. 1 is row and column absolute (e.g. $A$1), 2 is row absolute and column relative (e.g. A$1), 3 is row relative and column absolute (e.g. $A1), and 4 is row and column relative (e.g. A1).")),
        arg("use_a1_notation (boolean, default=TRUE)", _t("A boolean indicating whether to use A1 style notation (TRUE) or R1C1 style notation (FALSE).")),
        arg("sheet (string, optional)", _t("A string indicating the name of the sheet into which the address points.")),
    ],
    compute: function (row, column, absoluteRelativeMode = { value: DEFAULT_ABSOLUTE_RELATIVE_MODE }, useA1Notation = { value: true }, sheet) {
        const rowNumber = strictToInteger(row, this.locale);
        const colNumber = strictToInteger(column, this.locale);
        assertNumberGreaterThanOrEqualToOne(rowNumber);
        assertNumberGreaterThanOrEqualToOne(colNumber);
        const _absoluteRelativeMode = strictToInteger(absoluteRelativeMode, this.locale);
        assert(() => [1, 2, 3, 4].includes(_absoluteRelativeMode), expectNumberRangeError(1, 4, _absoluteRelativeMode));
        const _useA1Notation = toBoolean(useA1Notation);
        let cellReference;
        if (_useA1Notation) {
            const rangePart = {
                rowFixed: [1, 2].includes(_absoluteRelativeMode) ? true : false,
                colFixed: [1, 3].includes(_absoluteRelativeMode) ? true : false,
            };
            cellReference = toXC(colNumber - 1, rowNumber - 1, rangePart);
        }
        else {
            const rowPart = [1, 2].includes(_absoluteRelativeMode) ? `R${rowNumber}` : `R[${rowNumber}]`;
            const colPart = [1, 3].includes(_absoluteRelativeMode) ? `C${colNumber}` : `C[${colNumber}]`;
            cellReference = rowPart + colPart;
        }
        if (sheet !== undefined) {
            return getFullReference(toString(sheet), cellReference);
        }
        return cellReference;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// COLUMN
// -----------------------------------------------------------------------------
const COLUMN = {
    description: _t("Column number of a specified cell."),
    args: [
        arg("cell_reference (meta, default='this cell')", _t("The cell whose column number will be returned. Column A corresponds to 1. By default, the function use the cell in which the formula is entered.")),
    ],
    compute: function (cellReference) {
        if (isEvaluationError(cellReference?.value)) {
            throw cellReference;
        }
        const column = cellReference === undefined
            ? this.__originCellPosition?.col
            : toZone(cellReference.value).left;
        assert(() => column !== undefined, "In this context, the function [[FUNCTION_NAME]] needs to have a cell or range in parameter.");
        return column + 1;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// COLUMNS
// -----------------------------------------------------------------------------
const COLUMNS = {
    description: _t("Number of columns in a specified array or range."),
    args: [arg("range (meta)", _t("The range whose column count will be returned."))],
    compute: function (range) {
        if (isEvaluationError(range?.value)) {
            throw range;
        }
        const zone = toZone(range.value);
        return zone.right - zone.left + 1;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// HLOOKUP
// -----------------------------------------------------------------------------
const HLOOKUP = {
    description: _t("Horizontal lookup"),
    args: [
        arg("search_key (string, number, boolean)", _t("The value to search for. For example, 42, 'Cats', or I24.")),
        arg("range (any, range)", _t("The range to consider for the search. The first row in the range is searched for the key specified in search_key.")),
        arg("index (number)", _t("The row index of the value to be returned, where the first row in range is numbered 1.")),
        arg(`is_sorted (boolean, default=${DEFAULT_IS_SORTED})`, _t("Indicates whether the row to be searched (the first row of the specified range) is sorted, in which case the closest match for search_key will be returned.")),
    ],
    compute: function (searchKey, range, index, isSorted = { value: DEFAULT_IS_SORTED }) {
        const _index = Math.trunc(toNumber(index?.value, this.locale));
        const _range = toMatrix(range);
        assert(() => 1 <= _index && _index <= _range[0].length, _t("[[FUNCTION_NAME]] evaluates to an out of bounds range."));
        const getValueFromRange = (range, index) => range[index][0].value;
        const _isSorted = toBoolean(isSorted.value);
        const colIndex = _isSorted
            ? dichotomicSearch(_range, searchKey, "nextSmaller", "asc", _range.length, getValueFromRange)
            : linearSearch(range, searchKey, "wildcard", _range.length, getValueFromRange, this.lookupCaches);
        const col = _range[colIndex];
        if (col === undefined) {
            return valueNotAvailable(searchKey);
        }
        return col[_index - 1];
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// INDEX
// -----------------------------------------------------------------------------
const INDEX = {
    description: _t("Returns the content of a cell, specified by row and column offset."),
    args: [
        arg("reference (any, range)", _t("The range of cells from which the values are returned.")),
        arg("row (number, default=0)", _t("The index of the row to be returned from within the reference range of cells.")),
        arg("column (number, default=0)", _t("The index of the column to be returned from within the reference range of cells.")),
    ],
    compute: function (reference, row = { value: 0 }, column = { value: 0 }) {
        const _reference = toMatrix(reference);
        const _row = toNumber(row.value, this.locale);
        const _column = toNumber(column.value, this.locale);
        assert(() => _column >= 0 &&
            _column - 1 < _reference.length &&
            _row >= 0 &&
            _row - 1 < _reference[0].length, _t("Index out of range."));
        if (_row === 0 && _column === 0) {
            return _reference;
        }
        if (_row === 0) {
            return [_reference[_column - 1]];
        }
        if (_column === 0) {
            return _reference.map((col) => [col[_row - 1]]);
        }
        return _reference[_column - 1][_row - 1];
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// INDIRECT
// -----------------------------------------------------------------------------
const INDIRECT = {
    description: _t("Returns the content of a cell, specified by a string."),
    args: [
        arg("reference (string)", _t("The range of cells from which the values are returned.")),
        arg("use_a1_notation (boolean, default=TRUE)", _t("A boolean indicating whether to use A1 style notation (TRUE) or R1C1 style notation (FALSE).")),
    ],
    compute: function (reference, useA1Notation = { value: true }) {
        let _reference = reference?.value?.toString();
        if (!_reference) {
            throw new InvalidReferenceError(_t("Reference should be defined."));
        }
        const _useA1Notation = toBoolean(useA1Notation);
        if (!_useA1Notation) {
            throw new EvaluationError(_t("R1C1 notation is not supported."));
        }
        const sheetId = this.__originSheetId;
        const originPosition = this.__originCellPosition;
        if (originPosition) {
            // The following line is used to reset the dependencies of the cell, to avoid
            // keeping dependencies from previous evaluation of the INDIRECT formula (i.e.
            // in case the reference has been changed).
            this.updateDependencies?.(originPosition);
        }
        const range = this.getters.getRangeFromSheetXC(sheetId, _reference);
        if (range === undefined || range.invalidXc || range.invalidSheetName) {
            throw new InvalidReferenceError();
        }
        if (originPosition) {
            this.addDependencies?.(originPosition, [range]);
        }
        const values = [];
        for (let col = range.zone.left; col <= range.zone.right; col++) {
            const colValues = [];
            for (let row = range.zone.top; row <= range.zone.bottom; row++) {
                const position = { sheetId: range.sheetId, col, row };
                colValues.push(this.getters.getEvaluatedCell(position));
            }
            values.push(colValues);
        }
        return values.length === 1 && values[0].length === 1 ? values[0][0] : values;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// LOOKUP
// -----------------------------------------------------------------------------
const LOOKUP = {
    description: _t("Look up a value."),
    args: [
        arg("search_key (string, number, boolean)", _t("The value to search for. For example, 42, 'Cats', or I24.")),
        arg("search_array (any, range)", _t("One method of using this function is to provide a single sorted row or column search_array to look through for the search_key with a second argument result_range. The other way is to combine these two arguments into one search_array where the first row or column is searched and a value is returned from the last row or column in the array. If search_key is not found, a non-exact match may be returned.")),
        arg("result_range (any, range, optional)", _t("The range from which to return a result. The value returned corresponds to the location where search_key is found in search_range. This range must be only a single row or column and should not be used if using the search_result_array method.")),
    ],
    compute: function (searchKey, searchArray, resultRange) {
        const _searchArray = toMatrix(searchArray);
        const _resultRange = toMatrix(resultRange);
        let nbCol = _searchArray.length;
        let nbRow = _searchArray[0].length;
        const verticalSearch = nbRow >= nbCol;
        const getElement = verticalSearch
            ? (range, index) => range[0][index].value
            : (range, index) => range[index][0].value;
        const rangeLength = verticalSearch ? nbRow : nbCol;
        const index = dichotomicSearch(_searchArray, searchKey, "nextSmaller", "asc", rangeLength, getElement);
        if (index === -1 ||
            (verticalSearch && _searchArray[0][index] === undefined) ||
            (!verticalSearch && _searchArray[index][nbRow - 1] === undefined)) {
            return valueNotAvailable(searchKey);
        }
        if (_resultRange[0].length === 0) {
            return verticalSearch ? _searchArray[nbCol - 1][index] : _searchArray[index][nbRow - 1];
        }
        nbCol = _resultRange.length;
        nbRow = _resultRange[0].length;
        assert(() => nbCol === 1 || nbRow === 1, _t("The result_range must be a single row or a single column."));
        if (nbCol > 1) {
            assert(() => index <= nbCol - 1, _t("[[FUNCTION_NAME]] evaluates to an out of range row value %s.", (index + 1).toString()));
            return _resultRange[index][0];
        }
        assert(() => index <= nbRow - 1, _t("[[FUNCTION_NAME]] evaluates to an out of range column value %s.", (index + 1).toString()));
        return _resultRange[0][index];
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// MATCH
// -----------------------------------------------------------------------------
const DEFAULT_SEARCH_TYPE = 1;
const MATCH = {
    description: _t("Position of item in range that matches value."),
    args: [
        arg("search_key (string, number, boolean)", _t("The value to search for. For example, 42, 'Cats', or I24.")),
        arg("range (any, range)", _t("The one-dimensional array to be searched.")),
        arg(`search_type (number, default=${DEFAULT_SEARCH_TYPE})`, _t("The search method. 1 (default) finds the largest value less than or equal to search_key when range is sorted in ascending order. 0 finds the exact value when range is unsorted. -1 finds the smallest value greater than or equal to search_key when range is sorted in descending order.")),
    ],
    compute: function (searchKey, range, searchType = { value: DEFAULT_SEARCH_TYPE }) {
        let _searchType = toNumber(searchType, this.locale);
        const _range = toMatrix(range);
        const nbCol = _range.length;
        const nbRow = _range[0].length;
        assert(() => nbCol === 1 || nbRow === 1, _t("The range must be a single row or a single column."));
        let index = -1;
        const getElement = nbCol === 1
            ? (_range, index) => _range[0][index].value
            : (_range, index) => _range[index][0].value;
        const rangeLen = nbCol === 1 ? _range[0].length : _range.length;
        _searchType = Math.sign(_searchType);
        switch (_searchType) {
            case 1:
                index = dichotomicSearch(_range, searchKey, "nextSmaller", "asc", rangeLen, getElement);
                break;
            case 0:
                index = linearSearch(_range, searchKey, "wildcard", rangeLen, getElement, this.lookupCaches);
                break;
            case -1:
                index = dichotomicSearch(_range, searchKey, "nextGreater", "desc", rangeLen, getElement);
                break;
        }
        if ((nbCol === 1 && _range[0][index] === undefined) ||
            (nbCol !== 1 && _range[index] === undefined)) {
            return valueNotAvailable(searchKey);
        }
        return index + 1;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// ROW
// -----------------------------------------------------------------------------
const ROW = {
    description: _t("Row number of a specified cell."),
    args: [
        arg("cell_reference (meta, default='this cell')", _t("The cell whose row number will be returned. By default, this function uses the cell in which the formula is entered.")),
    ],
    compute: function (cellReference) {
        if (isEvaluationError(cellReference?.value)) {
            throw cellReference;
        }
        const row = cellReference === undefined
            ? this.__originCellPosition?.row
            : toZone(cellReference.value).top;
        assert(() => row !== undefined, "In this context, the function [[FUNCTION_NAME]] needs to have a cell or range in parameter.");
        return row + 1;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// ROWS
// -----------------------------------------------------------------------------
const ROWS = {
    description: _t("Number of rows in a specified array or range."),
    args: [arg("range (meta)", _t("The range whose row count will be returned."))],
    compute: function (range) {
        if (isEvaluationError(range?.value)) {
            throw range;
        }
        const zone = toZone(range.value);
        return zone.bottom - zone.top + 1;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// VLOOKUP
// -----------------------------------------------------------------------------
const VLOOKUP = {
    description: _t("Vertical lookup."),
    args: [
        arg("search_key (string, number, boolean)", _t("The value to search for. For example, 42, 'Cats', or I24.")),
        arg("range (any, range)", _t("The range to consider for the search. The first column in the range is searched for the key specified in search_key.")),
        arg("index (number)", _t("The column index of the value to be returned, where the first column in range is numbered 1.")),
        arg(`is_sorted (boolean, default=${DEFAULT_IS_SORTED})`, _t("Indicates whether the column to be searched (the first column of the specified range) is sorted, in which case the closest match for search_key will be returned.")),
    ],
    compute: function (searchKey, range, index, isSorted = { value: DEFAULT_IS_SORTED }) {
        const _index = Math.trunc(toNumber(index?.value, this.locale));
        const _range = toMatrix(range);
        assert(() => 1 <= _index && _index <= _range.length, _t("[[FUNCTION_NAME]] evaluates to an out of bounds range."));
        const getValueFromRange = (range, index) => range[0][index].value;
        const _isSorted = toBoolean(isSorted.value);
        const rowIndex = _isSorted
            ? dichotomicSearch(_range, searchKey, "nextSmaller", "asc", _range[0].length, getValueFromRange)
            : linearSearch(_range, searchKey, "wildcard", _range[0].length, getValueFromRange, this.lookupCaches);
        const value = _range[_index - 1][rowIndex];
        if (value === undefined) {
            return valueNotAvailable(searchKey);
        }
        return value;
    },
    isExported: true,
};
// -----------------------------------------------------------------------------
// XLOOKUP
// -----------------------------------------------------------